"""
    Authentication endpoints - OpenAPI 3.0

    The endpoints for the authentication API.  # noqa: E501

    The version of the OpenAPI document: DRAFT
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from swx_sdk.api_client import ApiClient, Endpoint as _Endpoint
from swx_sdk.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from swx_sdk.model.thing_connections_request import ThingConnectionsRequest
from swx_sdk.model.thing_connections_response import ThingConnectionsResponse


class SmartworksApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

        def __delete_support_smartworks_thing_connections(
            self,
            thing_id,
            **kwargs
        ):
            """Delete MQTT subscribers and publishers for SmartWorks Sync  # noqa: E501

            Deletes Thing Connections by Thing ID  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.delete_support_smartworks_thing_connections(thing_id, async_req=True)
            >>> result = thread.get()

            Args:
                thing_id (str):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                None
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['thing_id'] = \
                thing_id
            return self.call_with_http_info(**kwargs)

        self.delete_support_smartworks_thing_connections = _Endpoint(
            settings={
                'response_type': None,
                'auth': [
                    'bearerAuth'
                ],
                'endpoint_path': '/support/smartworks/thingConnections/{thing_id}',
                'operation_id': 'delete_support_smartworks_thing_connections',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'thing_id',
                ],
                'required': [
                    'thing_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'thing_id':
                        (str,),
                },
                'attribute_map': {
                    'thing_id': 'thing_id',
                },
                'location_map': {
                    'thing_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [],
                'content_type': [],
            },
            api_client=api_client,
            callable=__delete_support_smartworks_thing_connections
        )

        def __setup_support_smartworks_thing_connections(
            self,
            thing_id,
            thing_connections_request,
            **kwargs
        ):
            """Set up (create or update) MQTT subscribers and publishers for SmartWorks Sync  # noqa: E501

            Set up Thing Connections by Thing ID  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.setup_support_smartworks_thing_connections(thing_id, thing_connections_request, async_req=True)
            >>> result = thread.get()

            Args:
                thing_id (str):
                thing_connections_request (ThingConnectionsRequest): SmartWorks space, collection and MQTT details for the Thing

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ThingConnectionsResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['thing_id'] = \
                thing_id
            kwargs['thing_connections_request'] = \
                thing_connections_request
            return self.call_with_http_info(**kwargs)

        self.setup_support_smartworks_thing_connections = _Endpoint(
            settings={
                'response_type': (ThingConnectionsResponse,),
                'auth': [
                    'bearerAuth'
                ],
                'endpoint_path': '/support/smartworks/thingConnections/{thing_id}',
                'operation_id': 'setup_support_smartworks_thing_connections',
                'http_method': 'PUT',
                'servers': None,
            },
            params_map={
                'all': [
                    'thing_id',
                    'thing_connections_request',
                ],
                'required': [
                    'thing_id',
                    'thing_connections_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'thing_id':
                        (str,),
                    'thing_connections_request':
                        (ThingConnectionsRequest,),
                },
                'attribute_map': {
                    'thing_id': 'thing_id',
                },
                'location_map': {
                    'thing_id': 'path',
                    'thing_connections_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__setup_support_smartworks_thing_connections
        )
