"""
    Authentication endpoints - OpenAPI 3.0

    The endpoints for the authentication API.  # noqa: E501

    The version of the OpenAPI document: DRAFT
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from swx_sdk.api_client import ApiClient, Endpoint as _Endpoint
from swx_sdk.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from swx_sdk.model.label_thing_property_mapping_request import LabelThingPropertyMappingRequest
from swx_sdk.model.label_thing_property_mapping_response import LabelThingPropertyMappingResponse


class MappingsApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

        def __add_support_labels_label_thing_property_mapping(
            self,
            label_id,
            label_thing_property_mapping_request,
            **kwargs
        ):
            """Add Label to Thing property mappings  # noqa: E501

            Add new label to thing property mappings to the platform  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.add_support_labels_label_thing_property_mapping(label_id, label_thing_property_mapping_request, async_req=True)
            >>> result = thread.get()

            Args:
                label_id (str):
                label_thing_property_mapping_request (LabelThingPropertyMappingRequest): Create new label thing property mappings in the platform

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                LabelThingPropertyMappingResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['label_id'] = \
                label_id
            kwargs['label_thing_property_mapping_request'] = \
                label_thing_property_mapping_request
            return self.call_with_http_info(**kwargs)

        self.add_support_labels_label_thing_property_mapping = _Endpoint(
            settings={
                'response_type': (LabelThingPropertyMappingResponse,),
                'auth': [
                    'bearerAuth'
                ],
                'endpoint_path': '/support/labels/{label_id}/mappings',
                'operation_id': 'add_support_labels_label_thing_property_mapping',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'label_id',
                    'label_thing_property_mapping_request',
                ],
                'required': [
                    'label_id',
                    'label_thing_property_mapping_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'label_id':
                        (str,),
                    'label_thing_property_mapping_request':
                        (LabelThingPropertyMappingRequest,),
                },
                'attribute_map': {
                    'label_id': 'label_id',
                },
                'location_map': {
                    'label_id': 'path',
                    'label_thing_property_mapping_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__add_support_labels_label_thing_property_mapping
        )

        def __delete_support_labels_label_thing_property_mapping(
            self,
            label_id,
            property_label_id,
            **kwargs
        ):
            """Delete Label to Thing property mapping  # noqa: E501

            Delete of label to thing property mapping  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.delete_support_labels_label_thing_property_mapping(label_id, property_label_id, async_req=True)
            >>> result = thread.get()

            Args:
                label_id (str):
                property_label_id (str):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                None
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['label_id'] = \
                label_id
            kwargs['property_label_id'] = \
                property_label_id
            return self.call_with_http_info(**kwargs)

        self.delete_support_labels_label_thing_property_mapping = _Endpoint(
            settings={
                'response_type': None,
                'auth': [
                    'bearerAuth'
                ],
                'endpoint_path': '/support/labels/{label_id}/mappings/{property_label_id}',
                'operation_id': 'delete_support_labels_label_thing_property_mapping',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'label_id',
                    'property_label_id',
                ],
                'required': [
                    'label_id',
                    'property_label_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'label_id':
                        (str,),
                    'property_label_id':
                        (str,),
                },
                'attribute_map': {
                    'label_id': 'label_id',
                    'property_label_id': 'property_label_id',
                },
                'location_map': {
                    'label_id': 'path',
                    'property_label_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [],
                'content_type': [],
            },
            api_client=api_client,
            callable=__delete_support_labels_label_thing_property_mapping
        )

        def __list_support_labels_label_thing_property_mappings(
            self,
            label_id,
            **kwargs
        ):
            """List Label to Thing property mappings  # noqa: E501

            List of label to thing property mappings in array  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.list_support_labels_label_thing_property_mappings(label_id, async_req=True)
            >>> result = thread.get()

            Args:
                label_id (str):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                [LabelThingPropertyMappingResponse]
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['label_id'] = \
                label_id
            return self.call_with_http_info(**kwargs)

        self.list_support_labels_label_thing_property_mappings = _Endpoint(
            settings={
                'response_type': ([LabelThingPropertyMappingResponse],),
                'auth': [
                    'bearerAuth'
                ],
                'endpoint_path': '/support/labels/{label_id}/mappings',
                'operation_id': 'list_support_labels_label_thing_property_mappings',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'label_id',
                ],
                'required': [
                    'label_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'label_id':
                        (str,),
                },
                'attribute_map': {
                    'label_id': 'label_id',
                },
                'location_map': {
                    'label_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__list_support_labels_label_thing_property_mappings
        )

        def __show_support_labels_label_thing_property_mapping(
            self,
            label_id,
            property_label_id,
            **kwargs
        ):
            """Show Label to Thing property mapping  # noqa: E501

            Show of label to thing property mapping  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.show_support_labels_label_thing_property_mapping(label_id, property_label_id, async_req=True)
            >>> result = thread.get()

            Args:
                label_id (str):
                property_label_id (str):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                LabelThingPropertyMappingResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['label_id'] = \
                label_id
            kwargs['property_label_id'] = \
                property_label_id
            return self.call_with_http_info(**kwargs)

        self.show_support_labels_label_thing_property_mapping = _Endpoint(
            settings={
                'response_type': (LabelThingPropertyMappingResponse,),
                'auth': [
                    'bearerAuth'
                ],
                'endpoint_path': '/support/labels/{label_id}/mappings/{property_label_id}',
                'operation_id': 'show_support_labels_label_thing_property_mapping',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'label_id',
                    'property_label_id',
                ],
                'required': [
                    'label_id',
                    'property_label_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'label_id':
                        (str,),
                    'property_label_id':
                        (str,),
                },
                'attribute_map': {
                    'label_id': 'label_id',
                    'property_label_id': 'property_label_id',
                },
                'location_map': {
                    'label_id': 'path',
                    'property_label_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__show_support_labels_label_thing_property_mapping
        )
