"""
    Authentication endpoints - OpenAPI 3.0

    The endpoints for the authentication API.  # noqa: E501

    The version of the OpenAPI document: DRAFT
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from swx_sdk.api_client import ApiClient, Endpoint as _Endpoint
from swx_sdk.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from swx_sdk.model.logging_request import LoggingRequest
from swx_sdk.model.logging_response import LoggingResponse


class LoggingApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

        def __update_logging_logging(
            self,
            service_key,
            logging_request,
            **kwargs
        ):
            """Update the minimum log level  # noqa: E501

            Update the minimum log level of a service by service key  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.update_logging_logging(service_key, logging_request, async_req=True)
            >>> result = thread.get()

            Args:
                service_key (str):
                logging_request (LoggingRequest): Update the minimum log level of a service by service key

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                LoggingResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['service_key'] = \
                service_key
            kwargs['logging_request'] = \
                logging_request
            return self.call_with_http_info(**kwargs)

        self.update_logging_logging = _Endpoint(
            settings={
                'response_type': (LoggingResponse,),
                'auth': [
                    'bearerAuth'
                ],
                'endpoint_path': '/logging/services/{service_key}',
                'operation_id': 'update_logging_logging',
                'http_method': 'PUT',
                'servers': None,
            },
            params_map={
                'all': [
                    'service_key',
                    'logging_request',
                ],
                'required': [
                    'service_key',
                    'logging_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'service_key':
                        (str,),
                    'logging_request':
                        (LoggingRequest,),
                },
                'attribute_map': {
                    'service_key': 'service_key',
                },
                'location_map': {
                    'service_key': 'path',
                    'logging_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__update_logging_logging
        )
