
zephyr/zephyr.elf:     file format elf32-littleriscv


Disassembly of section vector:

80000000 <__start>:

	/*
	 * Set mtvec (Machine Trap-Vector Base-Address Register)
	 * to __irq_wrapper.
	 */
	la t0, __irq_wrapper
80000000:	00000297          	auipc	t0,0x0
80000004:	01028293          	addi	t0,t0,16 # 80000010 <__irq_wrapper>
	csrw mtvec, t0
80000008:	30529073          	csrw	mtvec,t0

	/* Jump to __initialize */
	tail __initialize
8000000c:	7550006f          	j	80000f60 <__initialize>

Disassembly of section exceptions:

80000010 <__irq_wrapper>:
 * In this architecture, system call (ECALL) is used to perform context
 * switching or IRQ offloading (when enabled).
 */
SECTION_FUNC(exception.entry, __irq_wrapper)
	/* Allocate space on thread stack to save registers */
	addi sp, sp, -__NANO_ESF_SIZEOF
80000010:	fb010113          	addi	sp,sp,-80
	 * Save caller-saved registers on current thread stack.
	 * NOTE: need to be updated to account for floating-point registers
	 * floating-point registers should be accounted for when corresponding
	 * config variable is set
	 */
	sw ra, __NANO_ESF_ra_OFFSET(sp)
80000014:	00112023          	sw	ra,0(sp)
	sw gp, __NANO_ESF_gp_OFFSET(sp)
80000018:	00312223          	sw	gp,4(sp)
	sw tp, __NANO_ESF_tp_OFFSET(sp)
8000001c:	00412423          	sw	tp,8(sp)
	sw t0, __NANO_ESF_t0_OFFSET(sp)
80000020:	00512623          	sw	t0,12(sp)
	sw t1, __NANO_ESF_t1_OFFSET(sp)
80000024:	00612823          	sw	t1,16(sp)
	sw t2, __NANO_ESF_t2_OFFSET(sp)
80000028:	00712a23          	sw	t2,20(sp)
	sw t3, __NANO_ESF_t3_OFFSET(sp)
8000002c:	01c12c23          	sw	t3,24(sp)
	sw t4, __NANO_ESF_t4_OFFSET(sp)
80000030:	01d12e23          	sw	t4,28(sp)
	sw t5, __NANO_ESF_t5_OFFSET(sp)
80000034:	03e12023          	sw	t5,32(sp)
	sw t6, __NANO_ESF_t6_OFFSET(sp)
80000038:	03f12223          	sw	t6,36(sp)
	sw a0, __NANO_ESF_a0_OFFSET(sp)
8000003c:	02a12423          	sw	a0,40(sp)
	sw a1, __NANO_ESF_a1_OFFSET(sp)
80000040:	02b12623          	sw	a1,44(sp)
	sw a2, __NANO_ESF_a2_OFFSET(sp)
80000044:	02c12823          	sw	a2,48(sp)
	sw a3, __NANO_ESF_a3_OFFSET(sp)
80000048:	02d12a23          	sw	a3,52(sp)
	sw a4, __NANO_ESF_a4_OFFSET(sp)
8000004c:	02e12c23          	sw	a4,56(sp)
	sw a5, __NANO_ESF_a5_OFFSET(sp)
80000050:	02f12e23          	sw	a5,60(sp)
	sw a6, __NANO_ESF_a6_OFFSET(sp)
80000054:	05012023          	sw	a6,64(sp)
	sw a7, __NANO_ESF_a7_OFFSET(sp)
80000058:	05112223          	sw	a7,68(sp)

	/* Save MEPC register */
	csrr t0, mepc
8000005c:	341022f3          	csrr	t0,mepc
	sw t0, __NANO_ESF_mepc_OFFSET(sp)
80000060:	04512423          	sw	t0,72(sp)

	/* Save SOC-specific MSTATUS register */
	csrr t0, SOC_MSTATUS_REG
80000064:	300022f3          	csrr	t0,mstatus
	sw t0, __NANO_ESF_mstatus_OFFSET(sp)
80000068:	04512623          	sw	t0,76(sp)
	 * SOCs (like pulpino or riscv-qemu), the MSB is never set to indicate
	 * interrupt. Hence, check for interrupt/exception via the __soc_is_irq
	 * function (that needs to be implemented by each SOC). The result is
	 * returned via register a0 (1: interrupt, 0 exception)
	 */
	jal ra, __soc_is_irq
8000006c:	200000ef          	jal	ra,8000026c <__soc_is_irq>

	/* If a0 != 0, jump to is_interrupt */
	addi t1, x0, 0
80000070:	00000313          	li	t1,0
	bnez a0, is_interrupt
80000074:	04051663          	bnez	a0,800000c0 <is_interrupt>
	/*
	 * If the exception is the result of an ECALL, check whether to
	 * perform a context-switch or an IRQ offload. Otherwise call _Fault
	 * to report the exception.
	 */
	csrr t0, mcause
80000078:	342022f3          	csrr	t0,mcause
	li t2, SOC_MCAUSE_EXP_MASK
8000007c:	800003b7          	lui	t2,0x80000
80000080:	fff38393          	addi	t2,t2,-1 # 7fffffff <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80000000>
	and t0, t0, t2
80000084:	0072f2b3          	and	t0,t0,t2
	li t1, SOC_MCAUSE_ECALL_EXP
80000088:	00b00313          	li	t1,11

	/*
	 * If mcause == SOC_MCAUSE_ECALL_EXP, handle system call,
	 * otherwise handle fault
	 */
	beq t0, t1, is_syscall
8000008c:	00628a63          	beq	t0,t1,800000a0 <is_syscall>
	 * Stack pointer is pointing to a NANO_ESF structure, pass it
	 * to _Fault (via register a0).
	 * If _Fault shall return, set return address to no_reschedule
	 * to restore stack.
	 */
	addi a0, sp, 0
80000090:	00010513          	mv	a0,sp
	la ra, no_reschedule
80000094:	00000097          	auipc	ra,0x0
80000098:	14408093          	addi	ra,ra,324 # 800001d8 <no_reschedule>
	tail _Fault
8000009c:	5d50006f          	j	80000e70 <_Fault>

800000a0 <is_syscall>:
	 * again upon exiting the ISR.
	 *
	 * It's safe to always increment by 4, even with compressed
	 * instructions, because the ecall instruction is always 4 bytes.
	 */
	lw t0, __NANO_ESF_mepc_OFFSET(sp)
800000a0:	04812283          	lw	t0,72(sp)
	addi t0, t0, 4
800000a4:	00428293          	addi	t0,t0,4
	sw t0, __NANO_ESF_mepc_OFFSET(sp)
800000a8:	04512423          	sw	t0,72(sp)
	 * Determine if the system call is the result of an IRQ offloading.
	 * Done by checking if _offload_routine is not pointing to NULL.
	 * If NULL, jump to reschedule to perform a context-switch, otherwise,
	 * jump to is_interrupt to handle the IRQ offload.
	 */
	la t0, _offload_routine
800000ac:	00007297          	auipc	t0,0x7
800000b0:	8b428293          	addi	t0,t0,-1868 # 80006960 <_offload_routine>
	lw t1, 0x00(t0)
800000b4:	0002a303          	lw	t1,0(t0)
	bnez t1, is_interrupt
800000b8:	00031463          	bnez	t1,800000c0 <is_interrupt>
#endif

	/*
	 * Go to reschedule to handle context-switch
	 */
	j reschedule
800000bc:	0900006f          	j	8000014c <reschedule>

800000c0 <is_interrupt>:
	 * Save current thread stack pointer and switch
	 * stack pointer to interrupt stack.
	 */

	/* Save thread stack pointer to temp register t0 */
	addi t0, sp, 0
800000c0:	00010293          	mv	t0,sp

	/* Switch to interrupt stack */
	la t2, _kernel
800000c4:	00007397          	auipc	t2,0x7
800000c8:	be038393          	addi	t2,t2,-1056 # 80006ca4 <_kernel>
	lw sp, _kernel_offset_to_irq_stack(t2)
800000cc:	0043a103          	lw	sp,4(t2)

	/*
	 * Save thread stack pointer on interrupt stack
	 * In RISC-V, stack pointer needs to be 16-byte aligned
	 */
	addi sp, sp, -16
800000d0:	ff010113          	addi	sp,sp,-16
	sw t0, 0x00(sp)
800000d4:	00512023          	sw	t0,0(sp)

800000d8 <on_irq_stack>:

on_irq_stack:
	/* Increment _kernel.nested variable */
	lw t3, _kernel_offset_to_nested(t2)
800000d8:	0003ae03          	lw	t3,0(t2)
	addi t3, t3, 1
800000dc:	001e0e13          	addi	t3,t3,1
	sw t3, _kernel_offset_to_nested(t2)
800000e0:	01c3a023          	sw	t3,0(t2)

	/*
	 * If we are here due to a system call, t1 register should != 0.
	 * In this case, perform IRQ offloading, otherwise jump to call_irq
	 */
	beqz t1, call_irq
800000e4:	00030863          	beqz	t1,800000f4 <call_irq>
	/*
	 * Call z_irq_do_offload to handle IRQ offloading.
	 * Set return address to on_thread_stack in order to jump there
	 * upon returning from z_irq_do_offload
	 */
	la ra, on_thread_stack
800000e8:	00000097          	auipc	ra,0x0
800000ec:	03c08093          	addi	ra,ra,60 # 80000124 <on_thread_stack>
	tail z_irq_do_offload
800000f0:	60d0006f          	j	80000efc <z_irq_do_offload>

800000f4 <call_irq>:
#ifdef CONFIG_TRACING
	call z_sys_trace_isr_enter
#endif

	/* Get IRQ causing interrupt */
	csrr a0, mcause
800000f4:	34202573          	csrr	a0,mcause
	li t0, SOC_MCAUSE_EXP_MASK
800000f8:	800002b7          	lui	t0,0x80000
800000fc:	fff28293          	addi	t0,t0,-1 # 7fffffff <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80000000>
	and a0, a0, t0
80000100:	00557533          	and	a0,a0,t0

	/*
	 * Clear pending IRQ generating the interrupt at SOC level
	 * Pass IRQ number to __soc_handle_irq via register a0
	 */
	jal ra, __soc_handle_irq
80000104:	158000ef          	jal	ra,8000025c <__soc_handle_irq>

	/*
	 * Call corresponding registered function in _sw_isr_table.
	 * (table is 8-bytes wide, we should shift index by 3)
	 */
	la t0, _sw_isr_table
80000108:	00006297          	auipc	t0,0x6
8000010c:	81028293          	addi	t0,t0,-2032 # 80005918 <_image_text_end>
	slli a0, a0, 3
80000110:	00351513          	slli	a0,a0,0x3
	add t0, t0, a0
80000114:	00a282b3          	add	t0,t0,a0

	/* Load argument in a0 register */
	lw a0, 0x00(t0)
80000118:	0002a503          	lw	a0,0(t0)

	/* Load ISR function address in register t1 */
	lw t1, 0x04(t0)
8000011c:	0042a303          	lw	t1,4(t0)
	lw t1, 0x04(sp)
	lw a0, 0x00(sp)
	addi sp, sp, 16
#endif
	/* Call ISR function */
	jalr ra, t1
80000120:	000300e7          	jalr	t1

80000124 <on_thread_stack>:

on_thread_stack:
	/* Get reference to _kernel */
	la t1, _kernel
80000124:	00007317          	auipc	t1,0x7
80000128:	b8030313          	addi	t1,t1,-1152 # 80006ca4 <_kernel>

	/* Decrement _kernel.nested variable */
	lw t2, _kernel_offset_to_nested(t1)
8000012c:	00032383          	lw	t2,0(t1)
	addi t2, t2, -1
80000130:	fff38393          	addi	t2,t2,-1
	sw t2, _kernel_offset_to_nested(t1)
80000134:	00732023          	sw	t2,0(t1)

	/* Restore thread stack pointer */
	lw t0, 0x00(sp)
80000138:	00012283          	lw	t0,0(sp)
	addi sp, t0, 0
8000013c:	00028113          	mv	sp,t0
	/*
	 * Check if we need to perform a reschedule
	 */

	/* Get pointer to _kernel.current */
	lw t2, _kernel_offset_to_current(t1)
80000140:	00832383          	lw	t2,8(t1)

	/*
	 * Check if next thread to schedule is current thread.
	 * If yes do not perform a reschedule
	 */
	lw t3, _kernel_offset_to_ready_q_cache(t1)
80000144:	02032e03          	lw	t3,32(t1)
	beq t3, t2, no_reschedule
80000148:	087e0863          	beq	t3,t2,800001d8 <no_reschedule>

8000014c <reschedule>:
reschedule:
#if CONFIG_TRACING
	call z_sys_trace_thread_switched_in
#endif
	/* Get reference to _kernel */
	la t0, _kernel
8000014c:	00007297          	auipc	t0,0x7
80000150:	b5828293          	addi	t0,t0,-1192 # 80006ca4 <_kernel>

	/* Get pointer to _kernel.current */
	lw t1, _kernel_offset_to_current(t0)
80000154:	0082a303          	lw	t1,8(t0)

	/*
	 * Save callee-saved registers of current thread
	 * prior to handle context-switching
	 */
	sw s0, _thread_offset_to_s0(t1)
80000158:	02832623          	sw	s0,44(t1)
	sw s1, _thread_offset_to_s1(t1)
8000015c:	02932823          	sw	s1,48(t1)
	sw s2, _thread_offset_to_s2(t1)
80000160:	03232a23          	sw	s2,52(t1)
	sw s3, _thread_offset_to_s3(t1)
80000164:	03332c23          	sw	s3,56(t1)
	sw s4, _thread_offset_to_s4(t1)
80000168:	03432e23          	sw	s4,60(t1)
	sw s5, _thread_offset_to_s5(t1)
8000016c:	05532023          	sw	s5,64(t1)
	sw s6, _thread_offset_to_s6(t1)
80000170:	05632223          	sw	s6,68(t1)
	sw s7, _thread_offset_to_s7(t1)
80000174:	05732423          	sw	s7,72(t1)
	sw s8, _thread_offset_to_s8(t1)
80000178:	05832623          	sw	s8,76(t1)
	sw s9, _thread_offset_to_s9(t1)
8000017c:	05932823          	sw	s9,80(t1)
	sw s10, _thread_offset_to_s10(t1)
80000180:	05a32a23          	sw	s10,84(t1)
	sw s11, _thread_offset_to_s11(t1)
80000184:	05b32c23          	sw	s11,88(t1)

	/*
	 * Save stack pointer of current thread and set the default return value
	 * of z_swap to _k_neg_eagain for the thread.
	 */
	sw sp, _thread_offset_to_sp(t1)
80000188:	02232423          	sw	sp,40(t1)
	la t2, _k_neg_eagain
8000018c:	00006397          	auipc	t2,0x6
80000190:	71c38393          	addi	t2,t2,1820 # 800068a8 <_k_neg_eagain>
	lw t3, 0x00(t2)
80000194:	0003ae03          	lw	t3,0(t2)
	sw t3, _thread_offset_to_swap_return_value(t1)
80000198:	07c32623          	sw	t3,108(t1)

	/* Get next thread to schedule. */
	lw t1, _kernel_offset_to_ready_q_cache(t0)
8000019c:	0202a303          	lw	t1,32(t0)

	/*
	 * Set _kernel.current to new thread loaded in t1
	 */
	sw t1, _kernel_offset_to_current(t0)
800001a0:	0062a423          	sw	t1,8(t0)

	/* Switch to new thread stack */
	lw sp, _thread_offset_to_sp(t1)
800001a4:	02832103          	lw	sp,40(t1)

	/* Restore callee-saved registers of new thread */
	lw s0, _thread_offset_to_s0(t1)
800001a8:	02c32403          	lw	s0,44(t1)
	lw s1, _thread_offset_to_s1(t1)
800001ac:	03032483          	lw	s1,48(t1)
	lw s2, _thread_offset_to_s2(t1)
800001b0:	03432903          	lw	s2,52(t1)
	lw s3, _thread_offset_to_s3(t1)
800001b4:	03832983          	lw	s3,56(t1)
	lw s4, _thread_offset_to_s4(t1)
800001b8:	03c32a03          	lw	s4,60(t1)
	lw s5, _thread_offset_to_s5(t1)
800001bc:	04032a83          	lw	s5,64(t1)
	lw s6, _thread_offset_to_s6(t1)
800001c0:	04432b03          	lw	s6,68(t1)
	lw s7, _thread_offset_to_s7(t1)
800001c4:	04832b83          	lw	s7,72(t1)
	lw s8, _thread_offset_to_s8(t1)
800001c8:	04c32c03          	lw	s8,76(t1)
	lw s9, _thread_offset_to_s9(t1)
800001cc:	05032c83          	lw	s9,80(t1)
	lw s10, _thread_offset_to_s10(t1)
800001d0:	05432d03          	lw	s10,84(t1)
	lw s11, _thread_offset_to_s11(t1)
800001d4:	05832d83          	lw	s11,88(t1)

800001d8 <no_reschedule>:
	addi a0, sp, __NANO_ESF_soc_context_OFFSET
	jal ra, __soc_restore_context
#endif /* CONFIG_RISCV_SOC_CONTEXT_SAVE */

	/* Restore MEPC register */
	lw t0, __NANO_ESF_mepc_OFFSET(sp)
800001d8:	04812283          	lw	t0,72(sp)
	csrw mepc, t0
800001dc:	34129073          	csrw	mepc,t0

	/* Restore SOC-specific MSTATUS register */
	lw t0, __NANO_ESF_mstatus_OFFSET(sp)
800001e0:	04c12283          	lw	t0,76(sp)
	csrw SOC_MSTATUS_REG, t0
800001e4:	30029073          	csrw	mstatus,t0

	/* Restore caller-saved registers from thread stack */
	lw ra, __NANO_ESF_ra_OFFSET(sp)
800001e8:	00012083          	lw	ra,0(sp)
	lw gp, __NANO_ESF_gp_OFFSET(sp)
800001ec:	00412183          	lw	gp,4(sp)
	lw tp, __NANO_ESF_tp_OFFSET(sp)
800001f0:	00812203          	lw	tp,8(sp)
	lw t0, __NANO_ESF_t0_OFFSET(sp)
800001f4:	00c12283          	lw	t0,12(sp)
	lw t1, __NANO_ESF_t1_OFFSET(sp)
800001f8:	01012303          	lw	t1,16(sp)
	lw t2, __NANO_ESF_t2_OFFSET(sp)
800001fc:	01412383          	lw	t2,20(sp)
	lw t3, __NANO_ESF_t3_OFFSET(sp)
80000200:	01812e03          	lw	t3,24(sp)
	lw t4, __NANO_ESF_t4_OFFSET(sp)
80000204:	01c12e83          	lw	t4,28(sp)
	lw t5, __NANO_ESF_t5_OFFSET(sp)
80000208:	02012f03          	lw	t5,32(sp)
	lw t6, __NANO_ESF_t6_OFFSET(sp)
8000020c:	02412f83          	lw	t6,36(sp)
	lw a0, __NANO_ESF_a0_OFFSET(sp)
80000210:	02812503          	lw	a0,40(sp)
	lw a1, __NANO_ESF_a1_OFFSET(sp)
80000214:	02c12583          	lw	a1,44(sp)
	lw a2, __NANO_ESF_a2_OFFSET(sp)
80000218:	03012603          	lw	a2,48(sp)
	lw a3, __NANO_ESF_a3_OFFSET(sp)
8000021c:	03412683          	lw	a3,52(sp)
	lw a4, __NANO_ESF_a4_OFFSET(sp)
80000220:	03812703          	lw	a4,56(sp)
	lw a5, __NANO_ESF_a5_OFFSET(sp)
80000224:	03c12783          	lw	a5,60(sp)
	lw a6, __NANO_ESF_a6_OFFSET(sp)
80000228:	04012803          	lw	a6,64(sp)
	lw a7, __NANO_ESF_a7_OFFSET(sp)
8000022c:	04412883          	lw	a7,68(sp)

	/* Release stack space */
	addi sp, sp, __NANO_ESF_SIZEOF
80000230:	05010113          	addi	sp,sp,80

	/* Call SOC_ERET to exit ISR */
	SOC_ERET
80000234:	30200073          	mret

80000238 <__swap>:
	lw a7, __NANO_ESF_a7_OFFSET(sp)

	/* Release stack space */
	addi sp, sp, __NANO_ESF_SIZEOF
#endif
	ecall
80000238:	00000073          	ecall
	 * Prior to unlocking irq, load return value of
	 * __swap to temp register t2 (from
	 * _thread_offset_to_swap_return_value). Normally, it should be -EAGAIN,
	 * unless someone has previously called z_set_thread_return_value(..).
	 */
	la t0, _kernel
8000023c:	00007297          	auipc	t0,0x7
80000240:	a6828293          	addi	t0,t0,-1432 # 80006ca4 <_kernel>

	/* Get pointer to _kernel.current */
	lw t1, _kernel_offset_to_current(t0)
80000244:	0082a303          	lw	t1,8(t0)

	/* Load return value of __swap function in temp register t2 */
	lw t2, _thread_offset_to_swap_return_value(t1)
80000248:	06c32383          	lw	t2,108(t1)

	/*
	 * Unlock irq, following IRQ lock state in a0 register.
	 * Use atomic instruction csrrs to do so.
	 */
	andi a0, a0, SOC_MSTATUS_IEN
8000024c:	00857513          	andi	a0,a0,8
	csrrs t0, mstatus, a0
80000250:	300522f3          	csrrs	t0,mstatus,a0

	/* Set value of return register a0 to value of register t2 */
	addi a0, t2, 0
80000254:	00038513          	mv	a0,t2

	/* Return */
	jalr x0, ra
80000258:	00008067          	ret

8000025c <__soc_handle_irq>:
 * SOC-specific function to handle pending IRQ number generating the interrupt.
 * Exception number is given as parameter via register a0.
 */
SECTION_FUNC(exception.other, __soc_handle_irq)
	/* Clear exception number from CSR mip register */
	li t1, 1
8000025c:	00100313          	li	t1,1
	sll t0, t1, a0
80000260:	00a312b3          	sll	t0,t1,a0
	csrrc t1, mip, t0
80000264:	3442b373          	csrrc	t1,mip,t0

	/* Return */
	jalr x0, ra
80000268:	00008067          	ret

8000026c <__soc_is_irq>:
 * return 1 (interrupt) or 0 (exception)
 *
 */
SECTION_FUNC(exception.other, __soc_is_irq)
	/* Read mcause and check if interrupt bit is set */
	csrr t0, mcause
8000026c:	342022f3          	csrr	t0,mcause
	li t1, SOC_MCAUSE_IRQ_MASK
80000270:	80000337          	lui	t1,0x80000
	and t0, t0, t1
80000274:	0062f2b3          	and	t0,t0,t1

	/* If interrupt bit is not set, return with 0 */
	addi a0, x0, 0
80000278:	00000513          	li	a0,0
	beqz t0, not_interrupt
8000027c:	00028463          	beqz	t0,80000284 <not_interrupt>
	addi a0, a0, 1
80000280:	00150513          	addi	a0,a0,1

80000284 <not_interrupt>:

not_interrupt:
	/* return */
	jalr x0, ra
80000284:	00008067          	ret

Disassembly of section text:

80000288 <__lshrdi3>:
80000288:	02060063          	beqz	a2,800002a8 <__lshrdi3+0x20>
8000028c:	02000793          	li	a5,32
80000290:	40c787b3          	sub	a5,a5,a2
80000294:	00f04c63          	bgtz	a5,800002ac <__lshrdi3+0x24>
80000298:	fe060513          	addi	a0,a2,-32
8000029c:	00000713          	li	a4,0
800002a0:	00a5d533          	srl	a0,a1,a0
800002a4:	00070593          	mv	a1,a4
800002a8:	00008067          	ret
800002ac:	00c5d733          	srl	a4,a1,a2
800002b0:	00c55533          	srl	a0,a0,a2
800002b4:	00f595b3          	sll	a1,a1,a5
800002b8:	00b56533          	or	a0,a0,a1
800002bc:	fe9ff06f          	j	800002a4 <__lshrdi3+0x1c>

800002c0 <__udivdi3>:
800002c0:	00058793          	mv	a5,a1
800002c4:	00060813          	mv	a6,a2
800002c8:	00068713          	mv	a4,a3
800002cc:	00050313          	mv	t1,a0
800002d0:	28069663          	bnez	a3,8000055c <__udivdi3+0x29c>
800002d4:	00005897          	auipc	a7,0x5
800002d8:	7c488893          	addi	a7,a7,1988 # 80005a98 <__devconfig_end>
800002dc:	0ec5f663          	bgeu	a1,a2,800003c8 <__udivdi3+0x108>
800002e0:	00010737          	lui	a4,0x10
800002e4:	0ce67863          	bgeu	a2,a4,800003b4 <__udivdi3+0xf4>
800002e8:	0ff00713          	li	a4,255
800002ec:	00c73733          	sltu	a4,a4,a2
800002f0:	00371713          	slli	a4,a4,0x3
800002f4:	00e656b3          	srl	a3,a2,a4
800002f8:	00d888b3          	add	a7,a7,a3
800002fc:	0008c683          	lbu	a3,0(a7)
80000300:	00e68733          	add	a4,a3,a4
80000304:	02000693          	li	a3,32
80000308:	40e686b3          	sub	a3,a3,a4
8000030c:	00068c63          	beqz	a3,80000324 <__udivdi3+0x64>
80000310:	00d797b3          	sll	a5,a5,a3
80000314:	00e55733          	srl	a4,a0,a4
80000318:	00d61833          	sll	a6,a2,a3
8000031c:	00f765b3          	or	a1,a4,a5
80000320:	00d51333          	sll	t1,a0,a3
80000324:	01085513          	srli	a0,a6,0x10
80000328:	02a5f733          	remu	a4,a1,a0
8000032c:	01081613          	slli	a2,a6,0x10
80000330:	01065613          	srli	a2,a2,0x10
80000334:	01035693          	srli	a3,t1,0x10
80000338:	02a5d5b3          	divu	a1,a1,a0
8000033c:	01071713          	slli	a4,a4,0x10
80000340:	00d766b3          	or	a3,a4,a3
80000344:	02b607b3          	mul	a5,a2,a1
80000348:	00058713          	mv	a4,a1
8000034c:	00f6fe63          	bgeu	a3,a5,80000368 <__udivdi3+0xa8>
80000350:	010686b3          	add	a3,a3,a6
80000354:	fff58713          	addi	a4,a1,-1
80000358:	0106e863          	bltu	a3,a6,80000368 <__udivdi3+0xa8>
8000035c:	00f6f663          	bgeu	a3,a5,80000368 <__udivdi3+0xa8>
80000360:	ffe58713          	addi	a4,a1,-2
80000364:	010686b3          	add	a3,a3,a6
80000368:	40f686b3          	sub	a3,a3,a5
8000036c:	02a6f7b3          	remu	a5,a3,a0
80000370:	01031313          	slli	t1,t1,0x10
80000374:	01035313          	srli	t1,t1,0x10
80000378:	02a6d6b3          	divu	a3,a3,a0
8000037c:	01079793          	slli	a5,a5,0x10
80000380:	0067e333          	or	t1,a5,t1
80000384:	02d605b3          	mul	a1,a2,a3
80000388:	00068513          	mv	a0,a3
8000038c:	00b37c63          	bgeu	t1,a1,800003a4 <__udivdi3+0xe4>
80000390:	00680333          	add	t1,a6,t1
80000394:	fff68513          	addi	a0,a3,-1
80000398:	01036663          	bltu	t1,a6,800003a4 <__udivdi3+0xe4>
8000039c:	00b37463          	bgeu	t1,a1,800003a4 <__udivdi3+0xe4>
800003a0:	ffe68513          	addi	a0,a3,-2
800003a4:	01071713          	slli	a4,a4,0x10
800003a8:	00a76733          	or	a4,a4,a0
800003ac:	00000593          	li	a1,0
800003b0:	0e40006f          	j	80000494 <__udivdi3+0x1d4>
800003b4:	010006b7          	lui	a3,0x1000
800003b8:	01000713          	li	a4,16
800003bc:	f2d66ce3          	bltu	a2,a3,800002f4 <__udivdi3+0x34>
800003c0:	01800713          	li	a4,24
800003c4:	f31ff06f          	j	800002f4 <__udivdi3+0x34>
800003c8:	00061663          	bnez	a2,800003d4 <__udivdi3+0x114>
800003cc:	00100693          	li	a3,1
800003d0:	02c6d833          	divu	a6,a3,a2
800003d4:	000106b7          	lui	a3,0x10
800003d8:	0cd87263          	bgeu	a6,a3,8000049c <__udivdi3+0x1dc>
800003dc:	0ff00693          	li	a3,255
800003e0:	0106f463          	bgeu	a3,a6,800003e8 <__udivdi3+0x128>
800003e4:	00800713          	li	a4,8
800003e8:	00e856b3          	srl	a3,a6,a4
800003ec:	00d888b3          	add	a7,a7,a3
800003f0:	0008c683          	lbu	a3,0(a7)
800003f4:	00e686b3          	add	a3,a3,a4
800003f8:	02000713          	li	a4,32
800003fc:	40d70733          	sub	a4,a4,a3
80000400:	0a071863          	bnez	a4,800004b0 <__udivdi3+0x1f0>
80000404:	410787b3          	sub	a5,a5,a6
80000408:	00100593          	li	a1,1
8000040c:	01085613          	srli	a2,a6,0x10
80000410:	01081893          	slli	a7,a6,0x10
80000414:	0108d893          	srli	a7,a7,0x10
80000418:	01035693          	srli	a3,t1,0x10
8000041c:	02c7f733          	remu	a4,a5,a2
80000420:	02c7d7b3          	divu	a5,a5,a2
80000424:	01071713          	slli	a4,a4,0x10
80000428:	00d766b3          	or	a3,a4,a3
8000042c:	02f88533          	mul	a0,a7,a5
80000430:	00078713          	mv	a4,a5
80000434:	00a6fe63          	bgeu	a3,a0,80000450 <__udivdi3+0x190>
80000438:	010686b3          	add	a3,a3,a6
8000043c:	fff78713          	addi	a4,a5,-1
80000440:	0106e863          	bltu	a3,a6,80000450 <__udivdi3+0x190>
80000444:	00a6f663          	bgeu	a3,a0,80000450 <__udivdi3+0x190>
80000448:	ffe78713          	addi	a4,a5,-2
8000044c:	010686b3          	add	a3,a3,a6
80000450:	40a686b3          	sub	a3,a3,a0
80000454:	02c6f7b3          	remu	a5,a3,a2
80000458:	01031313          	slli	t1,t1,0x10
8000045c:	01035313          	srli	t1,t1,0x10
80000460:	02c6d6b3          	divu	a3,a3,a2
80000464:	01079793          	slli	a5,a5,0x10
80000468:	0067e333          	or	t1,a5,t1
8000046c:	02d888b3          	mul	a7,a7,a3
80000470:	00068513          	mv	a0,a3
80000474:	01137c63          	bgeu	t1,a7,8000048c <__udivdi3+0x1cc>
80000478:	00680333          	add	t1,a6,t1
8000047c:	fff68513          	addi	a0,a3,-1 # ffff <CONFIG_ISR_STACK_SIZE+0xf7ff>
80000480:	01036663          	bltu	t1,a6,8000048c <__udivdi3+0x1cc>
80000484:	01137463          	bgeu	t1,a7,8000048c <__udivdi3+0x1cc>
80000488:	ffe68513          	addi	a0,a3,-2
8000048c:	01071713          	slli	a4,a4,0x10
80000490:	00a76733          	or	a4,a4,a0
80000494:	00070513          	mv	a0,a4
80000498:	00008067          	ret
8000049c:	010006b7          	lui	a3,0x1000
800004a0:	01000713          	li	a4,16
800004a4:	f4d862e3          	bltu	a6,a3,800003e8 <__udivdi3+0x128>
800004a8:	01800713          	li	a4,24
800004ac:	f3dff06f          	j	800003e8 <__udivdi3+0x128>
800004b0:	00e81833          	sll	a6,a6,a4
800004b4:	00d7d5b3          	srl	a1,a5,a3
800004b8:	00e51333          	sll	t1,a0,a4
800004bc:	00d556b3          	srl	a3,a0,a3
800004c0:	01085513          	srli	a0,a6,0x10
800004c4:	00e797b3          	sll	a5,a5,a4
800004c8:	02a5f733          	remu	a4,a1,a0
800004cc:	00f6e8b3          	or	a7,a3,a5
800004d0:	01081793          	slli	a5,a6,0x10
800004d4:	0107d793          	srli	a5,a5,0x10
800004d8:	0108d613          	srli	a2,a7,0x10
800004dc:	02a5d5b3          	divu	a1,a1,a0
800004e0:	01071713          	slli	a4,a4,0x10
800004e4:	00c76733          	or	a4,a4,a2
800004e8:	02b786b3          	mul	a3,a5,a1
800004ec:	00058613          	mv	a2,a1
800004f0:	00d77e63          	bgeu	a4,a3,8000050c <__udivdi3+0x24c>
800004f4:	01070733          	add	a4,a4,a6
800004f8:	fff58613          	addi	a2,a1,-1
800004fc:	01076863          	bltu	a4,a6,8000050c <__udivdi3+0x24c>
80000500:	00d77663          	bgeu	a4,a3,8000050c <__udivdi3+0x24c>
80000504:	ffe58613          	addi	a2,a1,-2
80000508:	01070733          	add	a4,a4,a6
8000050c:	40d706b3          	sub	a3,a4,a3
80000510:	02a6f733          	remu	a4,a3,a0
80000514:	01089893          	slli	a7,a7,0x10
80000518:	0108d893          	srli	a7,a7,0x10
8000051c:	02a6d6b3          	divu	a3,a3,a0
80000520:	01071713          	slli	a4,a4,0x10
80000524:	02d785b3          	mul	a1,a5,a3
80000528:	011767b3          	or	a5,a4,a7
8000052c:	00068713          	mv	a4,a3
80000530:	00b7fe63          	bgeu	a5,a1,8000054c <__udivdi3+0x28c>
80000534:	010787b3          	add	a5,a5,a6
80000538:	fff68713          	addi	a4,a3,-1 # ffffff <CONFIG_SYS_CLOCK_HW_CYCLES_PER_SEC+0x48e4ff>
8000053c:	0107e863          	bltu	a5,a6,8000054c <__udivdi3+0x28c>
80000540:	00b7f663          	bgeu	a5,a1,8000054c <__udivdi3+0x28c>
80000544:	ffe68713          	addi	a4,a3,-2
80000548:	010787b3          	add	a5,a5,a6
8000054c:	40b787b3          	sub	a5,a5,a1
80000550:	01061593          	slli	a1,a2,0x10
80000554:	00e5e5b3          	or	a1,a1,a4
80000558:	eb5ff06f          	j	8000040c <__udivdi3+0x14c>
8000055c:	18d5e663          	bltu	a1,a3,800006e8 <__udivdi3+0x428>
80000560:	00010737          	lui	a4,0x10
80000564:	04e6f463          	bgeu	a3,a4,800005ac <__udivdi3+0x2ec>
80000568:	0ff00813          	li	a6,255
8000056c:	00d83733          	sltu	a4,a6,a3
80000570:	00371713          	slli	a4,a4,0x3
80000574:	00e6d833          	srl	a6,a3,a4
80000578:	00005597          	auipc	a1,0x5
8000057c:	52058593          	addi	a1,a1,1312 # 80005a98 <__devconfig_end>
80000580:	010585b3          	add	a1,a1,a6
80000584:	0005c803          	lbu	a6,0(a1)
80000588:	02000593          	li	a1,32
8000058c:	00e80833          	add	a6,a6,a4
80000590:	410585b3          	sub	a1,a1,a6
80000594:	02059663          	bnez	a1,800005c0 <__udivdi3+0x300>
80000598:	00100713          	li	a4,1
8000059c:	eef6ece3          	bltu	a3,a5,80000494 <__udivdi3+0x1d4>
800005a0:	00c53533          	sltu	a0,a0,a2
800005a4:	00154713          	xori	a4,a0,1
800005a8:	eedff06f          	j	80000494 <__udivdi3+0x1d4>
800005ac:	010005b7          	lui	a1,0x1000
800005b0:	01000713          	li	a4,16
800005b4:	fcb6e0e3          	bltu	a3,a1,80000574 <__udivdi3+0x2b4>
800005b8:	01800713          	li	a4,24
800005bc:	fb9ff06f          	j	80000574 <__udivdi3+0x2b4>
800005c0:	01065733          	srl	a4,a2,a6
800005c4:	00b696b3          	sll	a3,a3,a1
800005c8:	00d766b3          	or	a3,a4,a3
800005cc:	0106de93          	srli	t4,a3,0x10
800005d0:	0107d733          	srl	a4,a5,a6
800005d4:	03d778b3          	remu	a7,a4,t4
800005d8:	00b797b3          	sll	a5,a5,a1
800005dc:	01055833          	srl	a6,a0,a6
800005e0:	00f86333          	or	t1,a6,a5
800005e4:	01069793          	slli	a5,a3,0x10
800005e8:	0107d793          	srli	a5,a5,0x10
800005ec:	01035813          	srli	a6,t1,0x10
800005f0:	00b61633          	sll	a2,a2,a1
800005f4:	03d75733          	divu	a4,a4,t4
800005f8:	01089893          	slli	a7,a7,0x10
800005fc:	0108e833          	or	a6,a7,a6
80000600:	02e78f33          	mul	t5,a5,a4
80000604:	00070e13          	mv	t3,a4
80000608:	01e87e63          	bgeu	a6,t5,80000624 <__udivdi3+0x364>
8000060c:	00d80833          	add	a6,a6,a3
80000610:	fff70e13          	addi	t3,a4,-1 # ffff <CONFIG_ISR_STACK_SIZE+0xf7ff>
80000614:	00d86863          	bltu	a6,a3,80000624 <__udivdi3+0x364>
80000618:	01e87663          	bgeu	a6,t5,80000624 <__udivdi3+0x364>
8000061c:	ffe70e13          	addi	t3,a4,-2
80000620:	00d80833          	add	a6,a6,a3
80000624:	41e80833          	sub	a6,a6,t5
80000628:	03d878b3          	remu	a7,a6,t4
8000062c:	03d85833          	divu	a6,a6,t4
80000630:	01089893          	slli	a7,a7,0x10
80000634:	03078eb3          	mul	t4,a5,a6
80000638:	01031793          	slli	a5,t1,0x10
8000063c:	0107d793          	srli	a5,a5,0x10
80000640:	00f8e7b3          	or	a5,a7,a5
80000644:	00080713          	mv	a4,a6
80000648:	01d7fe63          	bgeu	a5,t4,80000664 <__udivdi3+0x3a4>
8000064c:	00d787b3          	add	a5,a5,a3
80000650:	fff80713          	addi	a4,a6,-1
80000654:	00d7e863          	bltu	a5,a3,80000664 <__udivdi3+0x3a4>
80000658:	01d7f663          	bgeu	a5,t4,80000664 <__udivdi3+0x3a4>
8000065c:	ffe80713          	addi	a4,a6,-2
80000660:	00d787b3          	add	a5,a5,a3
80000664:	010e1e13          	slli	t3,t3,0x10
80000668:	41d787b3          	sub	a5,a5,t4
8000066c:	00010eb7          	lui	t4,0x10
80000670:	00ee6733          	or	a4,t3,a4
80000674:	fffe8813          	addi	a6,t4,-1 # ffff <CONFIG_ISR_STACK_SIZE+0xf7ff>
80000678:	01077333          	and	t1,a4,a6
8000067c:	01075893          	srli	a7,a4,0x10
80000680:	01067833          	and	a6,a2,a6
80000684:	01065613          	srli	a2,a2,0x10
80000688:	03030e33          	mul	t3,t1,a6
8000068c:	03088833          	mul	a6,a7,a6
80000690:	010e5693          	srli	a3,t3,0x10
80000694:	02c30333          	mul	t1,t1,a2
80000698:	01030333          	add	t1,t1,a6
8000069c:	006686b3          	add	a3,a3,t1
800006a0:	02c888b3          	mul	a7,a7,a2
800006a4:	0106f463          	bgeu	a3,a6,800006ac <__udivdi3+0x3ec>
800006a8:	01d888b3          	add	a7,a7,t4
800006ac:	0106d613          	srli	a2,a3,0x10
800006b0:	011608b3          	add	a7,a2,a7
800006b4:	0317e663          	bltu	a5,a7,800006e0 <__udivdi3+0x420>
800006b8:	cf179ae3          	bne	a5,a7,800003ac <__udivdi3+0xec>
800006bc:	000107b7          	lui	a5,0x10
800006c0:	fff78793          	addi	a5,a5,-1 # ffff <CONFIG_ISR_STACK_SIZE+0xf7ff>
800006c4:	00f6f6b3          	and	a3,a3,a5
800006c8:	01069693          	slli	a3,a3,0x10
800006cc:	00fe7e33          	and	t3,t3,a5
800006d0:	00b51533          	sll	a0,a0,a1
800006d4:	01c686b3          	add	a3,a3,t3
800006d8:	00000593          	li	a1,0
800006dc:	dad57ce3          	bgeu	a0,a3,80000494 <__udivdi3+0x1d4>
800006e0:	fff70713          	addi	a4,a4,-1
800006e4:	cc9ff06f          	j	800003ac <__udivdi3+0xec>
800006e8:	00000593          	li	a1,0
800006ec:	00000713          	li	a4,0
800006f0:	da5ff06f          	j	80000494 <__udivdi3+0x1d4>

800006f4 <unit_test_noop>:
 * nothing, successfully. Can be used as a parameter to
 * ztest_unit_test_setup_teardown().
 */
static inline void unit_test_noop(void)
{
}
800006f4:	00008067          	ret

800006f8 <test_stack_user_thread2thread>:
	static void _name(void)	   \
	{			   \
		ztest_test_skip(); \
	}

dummy_test(test_stack_user_thread2thread);
800006f8:	6f50106f          	j	800025ec <ztest_test_skip>

800006fc <test_stack_user_pop_fail>:
800006fc:	6f10106f          	j	800025ec <ztest_test_skip>

80000700 <test_main>:
 * @{
 * @}
 */
/*test case main entry*/
void test_main(void)
{
80000700:	ff010113          	addi	sp,sp,-16
80000704:	00112623          	sw	ra,12(sp)

K_SYSCALL_DECLARE0_VOID(K_SYSCALL_K_YIELD, k_yield)

K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_WAKEUP, k_wakeup, k_tid_t, thread)

K_SYSCALL_DECLARE0(K_SYSCALL_K_CURRENT_GET, k_current_get, k_tid_t)
80000708:	7d4030ef          	jal	ra,80003edc <z_impl_k_current_get>
8000070c:	7d0030ef          	jal	ra,80003edc <z_impl_k_current_get>
80000710:	7cc030ef          	jal	ra,80003edc <z_impl_k_current_get>
80000714:	7c8030ef          	jal	ra,80003edc <z_impl_k_current_get>
80000718:	7c4030ef          	jal	ra,80003edc <z_impl_k_current_get>
8000071c:	7c0030ef          	jal	ra,80003edc <z_impl_k_current_get>
 * @req K-THREAD-005
 */
static inline void k_thread_resource_pool_assign(struct k_thread *thread,
						 struct k_mem_pool *pool)
{
	thread->resource_pool = pool;
80000720:	800077b7          	lui	a5,0x80007
			 ztest_unit_test(test_stack_thread2isr),
			 ztest_unit_test(test_stack_pop_fail),
			 ztest_user_unit_test(test_stack_user_pop_fail),
			 ztest_unit_test(test_stack_alloc_thread2thread));
	ztest_run_test_suite(stack_api);
}
80000724:	00c12083          	lw	ra,12(sp)
80000728:	8e078793          	addi	a5,a5,-1824 # 800068e0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800068e1>
8000072c:	06f52423          	sw	a5,104(a0)
	ztest_run_test_suite(stack_api);
80000730:	800065b7          	lui	a1,0x80006
80000734:	80006537          	lui	a0,0x80006
80000738:	7f858593          	addi	a1,a1,2040 # 800067f8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800067f9>
8000073c:	c3c50513          	addi	a0,a0,-964 # 80005c3c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005c3d>
}
80000740:	01010113          	addi	sp,sp,16
	ztest_run_test_suite(stack_api);
80000744:	6d90106f          	j	8000261c <z_ztest_run_test_suite>

80000748 <tstack_push>:
struct k_thread thread_data;
static ZTEST_DMEM u32_t data[STACK_LEN] = { 0xABCD, 0x1234 };
struct k_sem end_sema;

static void tstack_push(struct k_stack *pstack)
{
80000748:	ff010113          	addi	sp,sp,-16
8000074c:	00812423          	sw	s0,8(sp)
80000750:	80007437          	lui	s0,0x80007
80000754:	88440413          	addi	s0,s0,-1916 # 80006884 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006885>
80000758:	00912223          	sw	s1,4(sp)
8000075c:	01212023          	sw	s2,0(sp)
80000760:	00112623          	sw	ra,12(sp)
80000764:	00050913          	mv	s2,a0
80000768:	01040493          	addi	s1,s0,16

K_SYSCALL_DECLARE1(K_SYSCALL_K_QUEUE_PEEK_TAIL, k_queue_peek_tail, void *, struct k_queue *, queue)

K_SYSCALL_DECLARE2(K_SYSCALL_K_STACK_ALLOC_INIT, k_stack_alloc_init, s32_t, struct k_stack *, stack, u32_t, num_entries)

K_SYSCALL_DECLARE2_VOID(K_SYSCALL_K_STACK_PUSH, k_stack_push, struct k_stack *, stack, u32_t, data)
8000076c:	00042583          	lw	a1,0(s0)
80000770:	00090513          	mv	a0,s2
80000774:	00440413          	addi	s0,s0,4
80000778:	3e1030ef          	jal	ra,80004358 <z_impl_k_stack_push>
	for (int i = 0; i < STACK_LEN; i++) {
8000077c:	fe9418e3          	bne	s0,s1,8000076c <tstack_push+0x24>
		/**TESTPOINT: stack push*/
		k_stack_push(pstack, data[i]);
	}
}
80000780:	00c12083          	lw	ra,12(sp)
80000784:	00812403          	lw	s0,8(sp)
80000788:	00412483          	lw	s1,4(sp)
8000078c:	00012903          	lw	s2,0(sp)
80000790:	01010113          	addi	sp,sp,16
80000794:	00008067          	ret

80000798 <tIsr_entry_push>:
}

/*entry of contexts*/
static void tIsr_entry_push(void *p)
{
	tstack_push((struct k_stack *)p);
80000798:	fb1ff06f          	j	80000748 <tstack_push>

8000079c <z_zassert.constprop.0>:
#define z_zassert(cond, default_msg, file, line, func, msg, ...)	\
	z_zassert_(cond, file, line)

#else /* CONFIG_ZTEST_ASSERT_VERBOSE != 0 */

static inline void z_zassert(int cond,
8000079c:	fd010113          	addi	sp,sp,-48
800007a0:	00112e23          	sw	ra,28(sp)
800007a4:	00812c23          	sw	s0,24(sp)
800007a8:	03012423          	sw	a6,40(sp)
800007ac:	03112623          	sw	a7,44(sp)
			    const char *default_msg,
			    const char *file,
			    int line, const char *func,
			    const char *msg, ...)
{
	if (!(cond)) {
800007b0:	04051663          	bnez	a0,800007fc <z_zassert.constprop.0+0x60>
800007b4:	00068613          	mv	a2,a3
		va_list vargs;

		va_start(vargs, msg);
		PRINT("\n    Assertion failed at %s:%d: %s: %s\n",
800007b8:	80006537          	lui	a0,0x80006
800007bc:	00070693          	mv	a3,a4
800007c0:	00058713          	mv	a4,a1
800007c4:	800065b7          	lui	a1,0x80006
800007c8:	00078413          	mv	s0,a5
800007cc:	d1458593          	addi	a1,a1,-748 # 80005d14 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d15>
		va_start(vargs, msg);
800007d0:	02810793          	addi	a5,sp,40
		PRINT("\n    Assertion failed at %s:%d: %s: %s\n",
800007d4:	d5050513          	addi	a0,a0,-688 # 80005d50 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d51>
		va_start(vargs, msg);
800007d8:	00f12623          	sw	a5,12(sp)
		PRINT("\n    Assertion failed at %s:%d: %s: %s\n",
800007dc:	678010ef          	jal	ra,80001e54 <printk>
		      file, line, func, default_msg);
		vprintk(msg, vargs);
800007e0:	00c12583          	lw	a1,12(sp)
800007e4:	00040513          	mv	a0,s0
800007e8:	63c010ef          	jal	ra,80001e24 <vprintk>
		printk("\n");
800007ec:	80006537          	lui	a0,0x80006
800007f0:	f8c50513          	addi	a0,a0,-116 # 80005f8c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005f8d>
800007f4:	660010ef          	jal	ra,80001e54 <printk>
		va_end(vargs);
		ztest_test_fail();
800007f8:	5c5010ef          	jal	ra,800025bc <ztest_test_fail>
	else {
		PRINT("\n   Assertion succeeded at %s:%d (%s)\n",
		      file, line, func);
	}
#endif
}
800007fc:	01c12083          	lw	ra,28(sp)
80000800:	01812403          	lw	s0,24(sp)
80000804:	03010113          	addi	sp,sp,48
80000808:	00008067          	ret

8000080c <tstack_pop>:
{
8000080c:	fc010113          	addi	sp,sp,-64
80000810:	02812c23          	sw	s0,56(sp)
80000814:	80007437          	lui	s0,0x80007
80000818:	88440413          	addi	s0,s0,-1916 # 80006884 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006885>
8000081c:	02912a23          	sw	s1,52(sp)
80000820:	03212823          	sw	s2,48(sp)
80000824:	03312623          	sw	s3,44(sp)
80000828:	03412423          	sw	s4,40(sp)
8000082c:	03512223          	sw	s5,36(sp)
80000830:	03612023          	sw	s6,32(sp)
80000834:	01712e23          	sw	s7,28(sp)
80000838:	02112e23          	sw	ra,60(sp)
8000083c:	00050b93          	mv	s7,a0
80000840:	ff040a13          	addi	s4,s0,-16
		zassert_false(k_stack_pop(pstack, &rx_data, K_NO_WAIT), NULL);
80000844:	80006937          	lui	s2,0x80006
80000848:	800069b7          	lui	s3,0x80006
8000084c:	800064b7          	lui	s1,0x80006
80000850:	80006b37          	lui	s6,0x80006
		zassert_equal(rx_data, data[i], NULL);
80000854:	80006ab7          	lui	s5,0x80006

K_SYSCALL_DECLARE3(K_SYSCALL_K_STACK_POP, k_stack_pop, int, struct k_stack *, stack, u32_t *, data, s32_t, timeout)
80000858:	00000613          	li	a2,0
8000085c:	00c10593          	addi	a1,sp,12
80000860:	000b8513          	mv	a0,s7
80000864:	489030ef          	jal	ra,800044ec <z_impl_k_stack_pop>
		zassert_false(k_stack_pop(pstack, &rx_data, K_NO_WAIT), NULL);
80000868:	e8c98793          	addi	a5,s3,-372 # 80005e8c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005e8d>
8000086c:	c4890713          	addi	a4,s2,-952 # 80005c48 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005c49>
80000870:	02400693          	li	a3,36
80000874:	d1448613          	addi	a2,s1,-748 # 80005d14 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d15>
80000878:	cc0b0593          	addi	a1,s6,-832 # 80005cc0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005cc1>
8000087c:	00153513          	seqz	a0,a0
80000880:	f1dff0ef          	jal	ra,8000079c <z_zassert.constprop.0>
		zassert_equal(rx_data, data[i], NULL);
80000884:	00c42503          	lw	a0,12(s0)
80000888:	00c12783          	lw	a5,12(sp)
8000088c:	c4890713          	addi	a4,s2,-952
80000890:	02500693          	li	a3,37
80000894:	40f50533          	sub	a0,a0,a5
80000898:	d1448613          	addi	a2,s1,-748
8000089c:	e8c98793          	addi	a5,s3,-372
800008a0:	cf4a8593          	addi	a1,s5,-780 # 80005cf4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005cf5>
800008a4:	00153513          	seqz	a0,a0
800008a8:	ffc40413          	addi	s0,s0,-4
800008ac:	ef1ff0ef          	jal	ra,8000079c <z_zassert.constprop.0>
	for (int i = STACK_LEN - 1; i >= 0; i--) {
800008b0:	fb4414e3          	bne	s0,s4,80000858 <tstack_pop+0x4c>
}
800008b4:	03c12083          	lw	ra,60(sp)
800008b8:	03812403          	lw	s0,56(sp)
800008bc:	03412483          	lw	s1,52(sp)
800008c0:	03012903          	lw	s2,48(sp)
800008c4:	02c12983          	lw	s3,44(sp)
800008c8:	02812a03          	lw	s4,40(sp)
800008cc:	02412a83          	lw	s5,36(sp)
800008d0:	02012b03          	lw	s6,32(sp)
800008d4:	01c12b83          	lw	s7,28(sp)
800008d8:	04010113          	addi	sp,sp,64
800008dc:	00008067          	ret

800008e0 <tThread_entry>:
{
	tstack_pop((struct k_stack *)p);
}

static void tThread_entry(void *p1, void *p2, void *p3)
{
800008e0:	ff010113          	addi	sp,sp,-16
800008e4:	00112623          	sw	ra,12(sp)
800008e8:	00812423          	sw	s0,8(sp)
800008ec:	00912223          	sw	s1,4(sp)

K_SYSCALL_DECLARE3_VOID(K_SYSCALL_K_SEM_INIT, k_sem_init, struct k_sem *, sem, unsigned int, initial_count, unsigned int, limit)

K_SYSCALL_DECLARE2(K_SYSCALL_K_SEM_TAKE, k_sem_take, int, struct k_sem *, sem, s32_t, timeout)

K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_SEM_GIVE, k_sem_give, struct k_sem *, sem)
800008f0:	80007437          	lui	s0,0x80007
800008f4:	00050493          	mv	s1,a0
	tstack_pop((struct k_stack *)p1);
800008f8:	f15ff0ef          	jal	ra,8000080c <tstack_pop>
800008fc:	aa840513          	addi	a0,s0,-1368 # 80006aa8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006aa9>
80000900:	6b0030ef          	jal	ra,80003fb0 <z_impl_k_sem_give>
	k_sem_give(&end_sema);
	tstack_push((struct k_stack *)p1);
80000904:	00048513          	mv	a0,s1
80000908:	e41ff0ef          	jal	ra,80000748 <tstack_push>
8000090c:	aa840513          	addi	a0,s0,-1368
	k_sem_give(&end_sema);
}
80000910:	00812403          	lw	s0,8(sp)
80000914:	00c12083          	lw	ra,12(sp)
80000918:	00412483          	lw	s1,4(sp)
8000091c:	01010113          	addi	sp,sp,16
80000920:	6900306f          	j	80003fb0 <z_impl_k_sem_give>

80000924 <tIsr_entry_pop>:
	tstack_pop((struct k_stack *)p);
80000924:	ee9ff06f          	j	8000080c <tstack_pop>

80000928 <tstack_thread_isr>:
	/* clear the spawn thread to avoid side effect */
	k_thread_abort(tid);
}

static void tstack_thread_isr(struct k_stack *pstack)
{
80000928:	ff010113          	addi	sp,sp,-16
8000092c:	00812423          	sw	s0,8(sp)
80000930:	00050413          	mv	s0,a0
K_SYSCALL_DECLARE3_VOID(K_SYSCALL_K_SEM_INIT, k_sem_init, struct k_sem *, sem, unsigned int, initial_count, unsigned int, limit)
80000934:	80007537          	lui	a0,0x80007
80000938:	00100613          	li	a2,1
8000093c:	00000593          	li	a1,0
80000940:	aa850513          	addi	a0,a0,-1368 # 80006aa8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006aa9>
80000944:	00112623          	sw	ra,12(sp)
80000948:	5a0030ef          	jal	ra,80003ee8 <z_impl_k_sem_init>
	k_sem_init(&end_sema, 0, 1);
	/**TESTPOINT: thread-isr data passing via stack*/
	irq_offload(tIsr_entry_push, pstack);
8000094c:	80000537          	lui	a0,0x80000
80000950:	00040593          	mv	a1,s0
80000954:	79850513          	addi	a0,a0,1944 # 80000798 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80000799>
80000958:	5cc000ef          	jal	ra,80000f24 <irq_offload>
	tstack_pop(pstack);
8000095c:	00040513          	mv	a0,s0
80000960:	eadff0ef          	jal	ra,8000080c <tstack_pop>

	tstack_push(pstack);
80000964:	00040513          	mv	a0,s0
80000968:	de1ff0ef          	jal	ra,80000748 <tstack_push>
	irq_offload(tIsr_entry_pop, pstack);
8000096c:	00040593          	mv	a1,s0
}
80000970:	00812403          	lw	s0,8(sp)
80000974:	00c12083          	lw	ra,12(sp)
	irq_offload(tIsr_entry_pop, pstack);
80000978:	80001537          	lui	a0,0x80001
8000097c:	92450513          	addi	a0,a0,-1756 # 80000924 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80000925>
}
80000980:	01010113          	addi	sp,sp,16
	irq_offload(tIsr_entry_pop, pstack);
80000984:	5a00006f          	j	80000f24 <irq_offload>

80000988 <tstack_thread_thread>:
{
80000988:	fe010113          	addi	sp,sp,-32
8000098c:	00912a23          	sw	s1,20(sp)
80000990:	800074b7          	lui	s1,0x80007
80000994:	00812c23          	sw	s0,24(sp)
80000998:	00100613          	li	a2,1
8000099c:	00050413          	mv	s0,a0
800009a0:	00000593          	li	a1,0
800009a4:	aa848513          	addi	a0,s1,-1368 # 80006aa8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006aa9>
800009a8:	00112e23          	sw	ra,28(sp)
800009ac:	01212823          	sw	s2,16(sp)
800009b0:	538030ef          	jal	ra,80003ee8 <z_impl_k_sem_init>
K_SYSCALL_DECLARE10(K_SYSCALL_K_THREAD_CREATE, k_thread_create, k_tid_t, struct k_thread *, new_thread, k_thread_stack_t *, stack, size_t, stack_size, k_thread_entry_t, entry, void *, p1, void *, p2, void *, p3, int, prio, u32_t, options, s32_t, delay)
800009b4:	00c00793          	li	a5,12
800009b8:	800016b7          	lui	a3,0x80001
800009bc:	800075b7          	lui	a1,0x80007
800009c0:	80007537          	lui	a0,0x80007
800009c4:	00040713          	mv	a4,s0
800009c8:	00000893          	li	a7,0
800009cc:	00000813          	li	a6,0
800009d0:	8e068693          	addi	a3,a3,-1824 # 800008e0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800008e1>
800009d4:	20000613          	li	a2,512
800009d8:	00f12023          	sw	a5,0(sp)
800009dc:	cd058593          	addi	a1,a1,-816 # 80006cd0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006cd1>
800009e0:	00000793          	li	a5,0
800009e4:	00012223          	sw	zero,4(sp)
800009e8:	ad450513          	addi	a0,a0,-1324 # 80006ad4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006ad5>
800009ec:	76d030ef          	jal	ra,80004958 <z_impl_k_thread_create>
800009f0:	00050913          	mv	s2,a0
	tstack_push(pstack);
800009f4:	00040513          	mv	a0,s0
800009f8:	d51ff0ef          	jal	ra,80000748 <tstack_push>
K_SYSCALL_DECLARE2(K_SYSCALL_K_SEM_TAKE, k_sem_take, int, struct k_sem *, sem, s32_t, timeout)
800009fc:	fff00593          	li	a1,-1
80000a00:	aa848513          	addi	a0,s1,-1368
80000a04:	690030ef          	jal	ra,80004094 <z_impl_k_sem_take>
80000a08:	fff00593          	li	a1,-1
80000a0c:	aa848513          	addi	a0,s1,-1368
80000a10:	684030ef          	jal	ra,80004094 <z_impl_k_sem_take>
	tstack_pop(pstack);
80000a14:	00040513          	mv	a0,s0
80000a18:	df5ff0ef          	jal	ra,8000080c <tstack_pop>
}
80000a1c:	01812403          	lw	s0,24(sp)
80000a20:	01c12083          	lw	ra,28(sp)
80000a24:	01412483          	lw	s1,20(sp)
K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_THREAD_ABORT, k_thread_abort, k_tid_t, thread)
80000a28:	00090513          	mv	a0,s2
80000a2c:	01012903          	lw	s2,16(sp)
80000a30:	02010113          	addi	sp,sp,32
80000a34:	0c80406f          	j	80004afc <z_impl_k_thread_abort>

80000a38 <test_stack_thread2thread>:
/**
 * @brief Test to verify data passing between threads via stack
 * @see k_stack_init(), k_stack_push(), #K_STACK_DEFINE(x), k_stack_pop()
 */
void test_stack_thread2thread(void)
{
80000a38:	ff010113          	addi	sp,sp,-16
80000a3c:	00812423          	sw	s0,8(sp)
	/**TESTPOINT: test k_stack_init stack*/
	k_stack_init(&stack, data, STACK_LEN);
80000a40:	800075b7          	lui	a1,0x80007
80000a44:	80007437          	lui	s0,0x80007
80000a48:	ab840513          	addi	a0,s0,-1352 # 80006ab8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006ab9>
80000a4c:	00400613          	li	a2,4
80000a50:	88458593          	addi	a1,a1,-1916 # 80006884 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006885>
{
80000a54:	00112623          	sw	ra,12(sp)
	k_stack_init(&stack, data, STACK_LEN);
80000a58:	005030ef          	jal	ra,8000425c <k_stack_init>
	tstack_thread_thread(&stack);
80000a5c:	ab840513          	addi	a0,s0,-1352
80000a60:	f29ff0ef          	jal	ra,80000988 <tstack_thread_thread>

	/**TESTPOINT: test K_STACK_DEFINE stack*/
	tstack_thread_thread(&kstack);
}
80000a64:	00812403          	lw	s0,8(sp)
80000a68:	00c12083          	lw	ra,12(sp)
	tstack_thread_thread(&kstack);
80000a6c:	80007537          	lui	a0,0x80007
80000a70:	91050513          	addi	a0,a0,-1776 # 80006910 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006911>
}
80000a74:	01010113          	addi	sp,sp,16
	tstack_thread_thread(&kstack);
80000a78:	f11ff06f          	j	80000988 <tstack_thread_thread>

80000a7c <test_stack_thread2isr>:
/**
 * @brief Verifies data passing between thread and ISR via stack
 * @see k_stack_init(), k_stack_push(), #K_STACK_DEFINE(x), k_stack_pop()
 */
void test_stack_thread2isr(void)
{
80000a7c:	ff010113          	addi	sp,sp,-16
80000a80:	00812423          	sw	s0,8(sp)
	/**TESTPOINT: test k_stack_init stack*/
	k_stack_init(&stack, data, STACK_LEN);
80000a84:	800075b7          	lui	a1,0x80007
80000a88:	80007437          	lui	s0,0x80007
80000a8c:	ab840513          	addi	a0,s0,-1352 # 80006ab8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006ab9>
80000a90:	00400613          	li	a2,4
80000a94:	88458593          	addi	a1,a1,-1916 # 80006884 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006885>
{
80000a98:	00112623          	sw	ra,12(sp)
	k_stack_init(&stack, data, STACK_LEN);
80000a9c:	7c0030ef          	jal	ra,8000425c <k_stack_init>
	tstack_thread_isr(&stack);
80000aa0:	ab840513          	addi	a0,s0,-1352
80000aa4:	e85ff0ef          	jal	ra,80000928 <tstack_thread_isr>

	/**TESTPOINT: test K_STACK_DEFINE stack*/
	tstack_thread_isr(&kstack);
}
80000aa8:	00812403          	lw	s0,8(sp)
80000aac:	00c12083          	lw	ra,12(sp)
	tstack_thread_isr(&kstack);
80000ab0:	80007537          	lui	a0,0x80007
80000ab4:	91050513          	addi	a0,a0,-1776 # 80006910 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006911>
}
80000ab8:	01010113          	addi	sp,sp,16
	tstack_thread_isr(&kstack);
80000abc:	e6dff06f          	j	80000928 <tstack_thread_isr>

80000ac0 <test_stack_alloc_thread2thread>:
/**
 * @see k_stack_alloc_init(), k_stack_push(), #K_STACK_DEFINE(x), k_stack_pop(),
 * k_stack_cleanup()
 */
void test_stack_alloc_thread2thread(void)
{
80000ac0:	fe010113          	addi	sp,sp,-32
80000ac4:	00812c23          	sw	s0,24(sp)
K_SYSCALL_DECLARE2(K_SYSCALL_K_STACK_ALLOC_INIT, k_stack_alloc_init, s32_t, struct k_stack *, stack, u32_t, num_entries)
80000ac8:	80007437          	lui	s0,0x80007
80000acc:	00400593          	li	a1,4
80000ad0:	92c40513          	addi	a0,s0,-1748 # 8000692c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000692d>
80000ad4:	00112e23          	sw	ra,28(sp)
80000ad8:	00912a23          	sw	s1,20(sp)
80000adc:	01212823          	sw	s2,16(sp)
K_SYSCALL_DECLARE3_VOID(K_SYSCALL_K_SEM_INIT, k_sem_init, struct k_sem *, sem, unsigned int, initial_count, unsigned int, limit)
80000ae0:	800074b7          	lui	s1,0x80007
K_SYSCALL_DECLARE2(K_SYSCALL_K_STACK_ALLOC_INIT, k_stack_alloc_init, s32_t, struct k_stack *, stack, u32_t, num_entries)
80000ae4:	79c030ef          	jal	ra,80004280 <z_impl_k_stack_alloc_init>
K_SYSCALL_DECLARE3_VOID(K_SYSCALL_K_SEM_INIT, k_sem_init, struct k_sem *, sem, unsigned int, initial_count, unsigned int, limit)
80000ae8:	aa848513          	addi	a0,s1,-1368 # 80006aa8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006aa9>
80000aec:	00100613          	li	a2,1
80000af0:	00000593          	li	a1,0
80000af4:	3f4030ef          	jal	ra,80003ee8 <z_impl_k_sem_init>
K_SYSCALL_DECLARE10(K_SYSCALL_K_THREAD_CREATE, k_thread_create, k_tid_t, struct k_thread *, new_thread, k_thread_stack_t *, stack, size_t, stack_size, k_thread_entry_t, entry, void *, p1, void *, p2, void *, p3, int, prio, u32_t, options, s32_t, delay)
80000af8:	800016b7          	lui	a3,0x80001
80000afc:	800075b7          	lui	a1,0x80007
80000b00:	80007537          	lui	a0,0x80007
80000b04:	92c40713          	addi	a4,s0,-1748
80000b08:	00000793          	li	a5,0
80000b0c:	8e068693          	addi	a3,a3,-1824 # 800008e0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800008e1>
80000b10:	20000613          	li	a2,512
80000b14:	00000893          	li	a7,0
80000b18:	00000813          	li	a6,0
80000b1c:	cd058593          	addi	a1,a1,-816 # 80006cd0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006cd1>
80000b20:	00012223          	sw	zero,4(sp)
80000b24:	00012023          	sw	zero,0(sp)
80000b28:	ad450513          	addi	a0,a0,-1324 # 80006ad4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006ad5>
80000b2c:	62d030ef          	jal	ra,80004958 <z_impl_k_thread_create>
80000b30:	00050913          	mv	s2,a0
	k_sem_init(&end_sema, 0, 1);
	/**TESTPOINT: thread-thread data passing via stack*/
	k_tid_t tid = k_thread_create(&thread_data, threadstack, STACK_SIZE,
					tThread_entry, &kstack_test_alloc,
					NULL, NULL, K_PRIO_PREEMPT(0), 0, 0);
	tstack_push(&kstack_test_alloc);
80000b34:	92c40513          	addi	a0,s0,-1748
80000b38:	c11ff0ef          	jal	ra,80000748 <tstack_push>
K_SYSCALL_DECLARE2(K_SYSCALL_K_SEM_TAKE, k_sem_take, int, struct k_sem *, sem, s32_t, timeout)
80000b3c:	fff00593          	li	a1,-1
80000b40:	aa848513          	addi	a0,s1,-1368
80000b44:	550030ef          	jal	ra,80004094 <z_impl_k_sem_take>
80000b48:	fff00593          	li	a1,-1
80000b4c:	aa848513          	addi	a0,s1,-1368
80000b50:	544030ef          	jal	ra,80004094 <z_impl_k_sem_take>
	k_sem_take(&end_sema, K_FOREVER);

	k_sem_take(&end_sema, K_FOREVER);
	tstack_pop(&kstack_test_alloc);
80000b54:	92c40513          	addi	a0,s0,-1748
80000b58:	cb5ff0ef          	jal	ra,8000080c <tstack_pop>
K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_THREAD_ABORT, k_thread_abort, k_tid_t, thread)
80000b5c:	00090513          	mv	a0,s2
80000b60:	79d030ef          	jal	ra,80004afc <z_impl_k_thread_abort>

	/* clear the spawn thread to avoid side effect */
	k_thread_abort(tid);
	k_stack_cleanup(&kstack_test_alloc);
80000b64:	92c40513          	addi	a0,s0,-1748
80000b68:	76c030ef          	jal	ra,800042d4 <k_stack_cleanup>
K_SYSCALL_DECLARE2(K_SYSCALL_K_STACK_ALLOC_INIT, k_stack_alloc_init, s32_t, struct k_stack *, stack, u32_t, num_entries)
80000b6c:	10100593          	li	a1,257
80000b70:	92c40513          	addi	a0,s0,-1748
80000b74:	70c030ef          	jal	ra,80004280 <z_impl_k_stack_alloc_init>

	/** Requested buffer allocation from the test pool.*/
	ret = k_stack_alloc_init(&kstack_test_alloc, (STACK_SIZE/2)+1);
	zassert_true(ret == -ENOMEM,
			"resource pool is smaller then requested buffer");
}
80000b78:	01812403          	lw	s0,24(sp)
80000b7c:	01c12083          	lw	ra,28(sp)
80000b80:	01412483          	lw	s1,20(sp)
80000b84:	01012903          	lw	s2,16(sp)
	zassert_true(ret == -ENOMEM,
80000b88:	00c50513          	addi	a0,a0,12
80000b8c:	800067b7          	lui	a5,0x80006
80000b90:	80006737          	lui	a4,0x80006
80000b94:	80006637          	lui	a2,0x80006
80000b98:	800065b7          	lui	a1,0x80006
80000b9c:	c7478793          	addi	a5,a5,-908 # 80005c74 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005c75>
80000ba0:	c5470713          	addi	a4,a4,-940 # 80005c54 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005c55>
80000ba4:	0a700693          	li	a3,167
80000ba8:	d1460613          	addi	a2,a2,-748 # 80005d14 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d15>
80000bac:	ca458593          	addi	a1,a1,-860 # 80005ca4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005ca5>
80000bb0:	00153513          	seqz	a0,a0
}
80000bb4:	02010113          	addi	sp,sp,32
	zassert_true(ret == -ENOMEM,
80000bb8:	be5ff06f          	j	8000079c <z_zassert.constprop.0>

80000bbc <z_zassert.constprop.1>:
static inline void z_zassert(int cond,
80000bbc:	fd010113          	addi	sp,sp,-48
80000bc0:	00112e23          	sw	ra,28(sp)
80000bc4:	03012423          	sw	a6,40(sp)
80000bc8:	03112623          	sw	a7,44(sp)
	if (!(cond)) {
80000bcc:	04051863          	bnez	a0,80000c1c <z_zassert.constprop.1+0x60>
80000bd0:	00068613          	mv	a2,a3
80000bd4:	00058713          	mv	a4,a1
		PRINT("\n    Assertion failed at %s:%d: %s: %s\n",
80000bd8:	800066b7          	lui	a3,0x80006
80000bdc:	800065b7          	lui	a1,0x80006
80000be0:	80006537          	lui	a0,0x80006
		va_start(vargs, msg);
80000be4:	02810793          	addi	a5,sp,40
		PRINT("\n    Assertion failed at %s:%d: %s: %s\n",
80000be8:	d7868693          	addi	a3,a3,-648 # 80005d78 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d79>
80000bec:	e0058593          	addi	a1,a1,-512 # 80005e00 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005e01>
80000bf0:	d5050513          	addi	a0,a0,-688 # 80005d50 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d51>
		va_start(vargs, msg);
80000bf4:	00f12623          	sw	a5,12(sp)
		PRINT("\n    Assertion failed at %s:%d: %s: %s\n",
80000bf8:	25c010ef          	jal	ra,80001e54 <printk>
		vprintk(msg, vargs);
80000bfc:	00c12583          	lw	a1,12(sp)
80000c00:	80006537          	lui	a0,0x80006
80000c04:	e8c50513          	addi	a0,a0,-372 # 80005e8c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005e8d>
80000c08:	21c010ef          	jal	ra,80001e24 <vprintk>
		printk("\n");
80000c0c:	80006537          	lui	a0,0x80006
80000c10:	f8c50513          	addi	a0,a0,-116 # 80005f8c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005f8d>
80000c14:	240010ef          	jal	ra,80001e54 <printk>
		ztest_test_fail();
80000c18:	1a5010ef          	jal	ra,800025bc <ztest_test_fail>
}
80000c1c:	01c12083          	lw	ra,28(sp)
80000c20:	03010113          	addi	sp,sp,48
80000c24:	00008067          	ret

80000c28 <test_stack_pop_fail>:
/**
 * @brief Verifies stack pop functionality
 * @see k_stack_init(), k_stack_pop()
 */
void test_stack_pop_fail(void)
{
80000c28:	fd010113          	addi	sp,sp,-48
80000c2c:	02812423          	sw	s0,40(sp)
	k_stack_init(&stack, data, STACK_LEN);
80000c30:	800075b7          	lui	a1,0x80007
80000c34:	80007437          	lui	s0,0x80007
80000c38:	ab840513          	addi	a0,s0,-1352 # 80006ab8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006ab9>
80000c3c:	00200613          	li	a2,2
80000c40:	95858593          	addi	a1,a1,-1704 # 80006958 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006959>
{
80000c44:	02112623          	sw	ra,44(sp)
80000c48:	02912223          	sw	s1,36(sp)
80000c4c:	03212023          	sw	s2,32(sp)
80000c50:	01312e23          	sw	s3,28(sp)
	k_stack_init(&stack, data, STACK_LEN);
80000c54:	608030ef          	jal	ra,8000425c <k_stack_init>
K_SYSCALL_DECLARE3(K_SYSCALL_K_STACK_POP, k_stack_pop, int, struct k_stack *, stack, u32_t *, data, s32_t, timeout)
80000c58:	00c10593          	addi	a1,sp,12
80000c5c:	00000613          	li	a2,0
80000c60:	ab840513          	addi	a0,s0,-1352
80000c64:	089030ef          	jal	ra,800044ec <z_impl_k_stack_pop>
	zassert_equal(k_stack_pop(stack, &rx_data, K_NO_WAIT), -EBUSY, NULL);
80000c68:	80006937          	lui	s2,0x80006
80000c6c:	800069b7          	lui	s3,0x80006
80000c70:	800064b7          	lui	s1,0x80006
80000c74:	01050513          	addi	a0,a0,16
80000c78:	800065b7          	lui	a1,0x80006
80000c7c:	e8c98793          	addi	a5,s3,-372 # 80005e8c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005e8d>
80000c80:	d7890713          	addi	a4,s2,-648 # 80005d78 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d79>
80000c84:	01500693          	li	a3,21
80000c88:	e0048613          	addi	a2,s1,-512 # 80005e00 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005e01>
80000c8c:	d8858593          	addi	a1,a1,-632 # 80005d88 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d89>
80000c90:	00153513          	seqz	a0,a0
80000c94:	f29ff0ef          	jal	ra,80000bbc <z_zassert.constprop.1>
80000c98:	00c10593          	addi	a1,sp,12
80000c9c:	06400613          	li	a2,100
80000ca0:	ab840513          	addi	a0,s0,-1352
80000ca4:	049030ef          	jal	ra,800044ec <z_impl_k_stack_pop>
	zassert_equal(k_stack_pop(stack, &rx_data, TIMEOUT), -EAGAIN, NULL);
80000ca8:	00b50513          	addi	a0,a0,11
80000cac:	800065b7          	lui	a1,0x80006
80000cb0:	e8c98793          	addi	a5,s3,-372
80000cb4:	d7890713          	addi	a4,s2,-648
80000cb8:	e0048613          	addi	a2,s1,-512
80000cbc:	01700693          	li	a3,23
80000cc0:	dc458593          	addi	a1,a1,-572 # 80005dc4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005dc5>
80000cc4:	00153513          	seqz	a0,a0
80000cc8:	ef5ff0ef          	jal	ra,80000bbc <z_zassert.constprop.1>

	stack_pop_fail(&stack);
}
80000ccc:	02c12083          	lw	ra,44(sp)
80000cd0:	02812403          	lw	s0,40(sp)
80000cd4:	02412483          	lw	s1,36(sp)
80000cd8:	02012903          	lw	s2,32(sp)
80000cdc:	01c12983          	lw	s3,28(sp)
80000ce0:	03010113          	addi	sp,sp,48
80000ce4:	00008067          	ret

80000ce8 <z_SysFatalErrorHandler>:
 *
 * @return N/A
 */
FUNC_NORETURN __weak void z_SysFatalErrorHandler(unsigned int reason,
						const NANO_ESF *esf)
{
80000ce8:	ff010113          	addi	sp,sp,-16
80000cec:	00112623          	sw	ra,12(sp)
80000cf0:	00812423          	sw	s0,8(sp)
#ifdef CONFIG_STACK_SENTINEL
	if (reason == _NANO_ERR_STACK_CHK_FAIL) {
		goto hang_system;
	}
#endif
	if (reason == _NANO_ERR_KERNEL_PANIC) {
80000cf4:	00600793          	li	a5,6
80000cf8:	02f50463          	beq	a0,a5,80000d20 <z_SysFatalErrorHandler+0x38>
		goto hang_system;
	}
	if (k_is_in_isr() || z_is_thread_essential()) {
80000cfc:	1a9030ef          	jal	ra,800046a4 <k_is_in_isr>
80000d00:	02050463          	beqz	a0,80000d28 <z_SysFatalErrorHandler+0x40>
		printk("Fatal fault in %s! Spinning...\n",
		       k_is_in_isr() ? "ISR" : "essential thread");
80000d04:	1a1030ef          	jal	ra,800046a4 <k_is_in_isr>
		printk("Fatal fault in %s! Spinning...\n",
80000d08:	04051663          	bnez	a0,80000d54 <z_SysFatalErrorHandler+0x6c>
80000d0c:	800065b7          	lui	a1,0x80006
80000d10:	0e858593          	addi	a1,a1,232 # 800060e8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800060e9>
80000d14:	80006537          	lui	a0,0x80006
80000d18:	0fc50513          	addi	a0,a0,252 # 800060fc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800060fd>
80000d1c:	138010ef          	jal	ra,80001e54 <printk>
#else
	ARG_UNUSED(reason);
#endif

	for (;;) {
		k_cpu_idle();
80000d20:	1a4010ef          	jal	ra,80001ec4 <k_cpu_idle>
80000d24:	ffdff06f          	j	80000d20 <z_SysFatalErrorHandler+0x38>
	if (k_is_in_isr() || z_is_thread_essential()) {
80000d28:	18d030ef          	jal	ra,800046b4 <z_is_thread_essential>
80000d2c:	fc051ce3          	bnez	a0,80000d04 <z_SysFatalErrorHandler+0x1c>
	printk("Fatal fault in thread %p! Aborting.\n", _current);
80000d30:	80007437          	lui	s0,0x80007
80000d34:	ca440413          	addi	s0,s0,-860 # 80006ca4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006ca5>
80000d38:	00842583          	lw	a1,8(s0)
80000d3c:	80006537          	lui	a0,0x80006
80000d40:	11c50513          	addi	a0,a0,284 # 8000611c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000611d>
80000d44:	110010ef          	jal	ra,80001e54 <printk>
K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_THREAD_ABORT, k_thread_abort, k_tid_t, thread)
80000d48:	00842503          	lw	a0,8(s0)
80000d4c:	5b1030ef          	jal	ra,80004afc <z_impl_k_thread_abort>
80000d50:	fd1ff06f          	j	80000d20 <z_SysFatalErrorHandler+0x38>
		printk("Fatal fault in %s! Spinning...\n",
80000d54:	800065b7          	lui	a1,0x80006
80000d58:	0e458593          	addi	a1,a1,228 # 800060e4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800060e5>
80000d5c:	fb9ff06f          	j	80000d14 <z_SysFatalErrorHandler+0x2c>

80000d60 <z_NanoFatalErrorHandler>:
{
80000d60:	fb010113          	addi	sp,sp,-80
80000d64:	04812423          	sw	s0,72(sp)
80000d68:	04912223          	sw	s1,68(sp)
80000d6c:	04112623          	sw	ra,76(sp)
	switch (reason) {
80000d70:	00600793          	li	a5,6
{
80000d74:	00050493          	mv	s1,a0
80000d78:	00058413          	mv	s0,a1
	switch (reason) {
80000d7c:	0ea7e063          	bltu	a5,a0,80000e5c <z_NanoFatalErrorHandler+0xfc>
80000d80:	80006737          	lui	a4,0x80006
80000d84:	00251793          	slli	a5,a0,0x2
80000d88:	e3870713          	addi	a4,a4,-456 # 80005e38 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005e39>
80000d8c:	00e787b3          	add	a5,a5,a4
80000d90:	0007a783          	lw	a5,0(a5)
80000d94:	00078067          	jr	a5
		printk("**** Kernel Allocation Failure! ****\n");
80000d98:	80006537          	lui	a0,0x80006
80000d9c:	f6850513          	addi	a0,a0,-152 # 80005f68 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005f69>
		printk("***** Kernel OOPS! *****\n");
80000da0:	0b4010ef          	jal	ra,80001e54 <printk>
K_SYSCALL_DECLARE0(K_SYSCALL_K_CURRENT_GET, k_current_get, k_tid_t)
80000da4:	138030ef          	jal	ra,80003edc <z_impl_k_current_get>
	printk("Current thread ID = %p\n"
80000da8:	04442783          	lw	a5,68(s0)
80000dac:	01042883          	lw	a7,16(s0)
80000db0:	00c42803          	lw	a6,12(s0)
80000db4:	02f12823          	sw	a5,48(sp)
80000db8:	04042783          	lw	a5,64(s0)
80000dbc:	00442703          	lw	a4,4(s0)
80000dc0:	00042683          	lw	a3,0(s0)
80000dc4:	02f12623          	sw	a5,44(sp)
80000dc8:	03c42783          	lw	a5,60(s0)
80000dcc:	04842603          	lw	a2,72(s0)
80000dd0:	00050593          	mv	a1,a0
80000dd4:	02f12423          	sw	a5,40(sp)
80000dd8:	03842783          	lw	a5,56(s0)
80000ddc:	80006537          	lui	a0,0x80006
80000de0:	fec50513          	addi	a0,a0,-20 # 80005fec <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005fed>
80000de4:	02f12223          	sw	a5,36(sp)
80000de8:	03442783          	lw	a5,52(s0)
80000dec:	02f12023          	sw	a5,32(sp)
80000df0:	03042783          	lw	a5,48(s0)
80000df4:	00f12e23          	sw	a5,28(sp)
80000df8:	02c42783          	lw	a5,44(s0)
80000dfc:	00f12c23          	sw	a5,24(sp)
80000e00:	02842783          	lw	a5,40(s0)
80000e04:	00f12a23          	sw	a5,20(sp)
80000e08:	02442783          	lw	a5,36(s0)
80000e0c:	00f12823          	sw	a5,16(sp)
80000e10:	02042783          	lw	a5,32(s0)
80000e14:	00f12623          	sw	a5,12(sp)
80000e18:	01c42783          	lw	a5,28(s0)
80000e1c:	00f12423          	sw	a5,8(sp)
80000e20:	01842783          	lw	a5,24(s0)
80000e24:	00f12223          	sw	a5,4(sp)
80000e28:	01442783          	lw	a5,20(s0)
80000e2c:	00f12023          	sw	a5,0(sp)
80000e30:	00842783          	lw	a5,8(s0)
80000e34:	020010ef          	jal	ra,80001e54 <printk>
	z_SysFatalErrorHandler(reason, esf);
80000e38:	00040593          	mv	a1,s0
80000e3c:	00048513          	mv	a0,s1
80000e40:	ea9ff0ef          	jal	ra,80000ce8 <z_SysFatalErrorHandler>
		printk("***** Kernel OOPS! *****\n");
80000e44:	80006537          	lui	a0,0x80006
80000e48:	f9050513          	addi	a0,a0,-112 # 80005f90 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005f91>
80000e4c:	f55ff06f          	j	80000da0 <z_NanoFatalErrorHandler+0x40>
		printk("***** Kernel Panic! *****\n");
80000e50:	80006537          	lui	a0,0x80006
80000e54:	fac50513          	addi	a0,a0,-84 # 80005fac <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005fad>
80000e58:	f49ff06f          	j	80000da0 <z_NanoFatalErrorHandler+0x40>
		printk("**** Unknown Fatal Error %d! ****\n", reason);
80000e5c:	80006537          	lui	a0,0x80006
80000e60:	00048593          	mv	a1,s1
80000e64:	fc850513          	addi	a0,a0,-56 # 80005fc8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005fc9>
80000e68:	7ed000ef          	jal	ra,80001e54 <printk>
		break;
80000e6c:	f39ff06f          	j	80000da4 <z_NanoFatalErrorHandler+0x44>

80000e70 <_Fault>:
	}
}


FUNC_NORETURN void _Fault(const NANO_ESF *esf)
{
80000e70:	ff010113          	addi	sp,sp,-16
80000e74:	00812423          	sw	s0,8(sp)
80000e78:	00112623          	sw	ra,12(sp)
80000e7c:	00050413          	mv	s0,a0
	u32_t mcause;

	__asm__ volatile("csrr %0, mcause" : "=r" (mcause));
80000e80:	34202673          	csrr	a2,mcause

	mcause &= SOC_MCAUSE_EXP_MASK;
80000e84:	00161613          	slli	a2,a2,0x1
80000e88:	00165613          	srli	a2,a2,0x1
	switch (cause) {
80000e8c:	00500793          	li	a5,5
80000e90:	02c7e863          	bltu	a5,a2,80000ec0 <_Fault+0x50>
80000e94:	80006737          	lui	a4,0x80006
80000e98:	00261793          	slli	a5,a2,0x2
80000e9c:	e5470713          	addi	a4,a4,-428 # 80005e54 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005e55>
80000ea0:	00f707b3          	add	a5,a4,a5
80000ea4:	0007a583          	lw	a1,0(a5)
	printk("Exception cause %s (%d)\n", cause_str(mcause), (int)mcause);
80000ea8:	80006537          	lui	a0,0x80006
80000eac:	e7450513          	addi	a0,a0,-396 # 80005e74 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005e75>
80000eb0:	7a5000ef          	jal	ra,80001e54 <printk>

	z_NanoFatalErrorHandler(_NANO_ERR_CPU_EXCEPTION, esf);
80000eb4:	00040593          	mv	a1,s0
80000eb8:	00000513          	li	a0,0
80000ebc:	ea5ff0ef          	jal	ra,80000d60 <z_NanoFatalErrorHandler>
	mcause &= SOC_MCAUSE_EXP_MASK;
80000ec0:	800065b7          	lui	a1,0x80006
80000ec4:	e6c58593          	addi	a1,a1,-404 # 80005e6c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005e6d>
80000ec8:	fe1ff06f          	j	80000ea8 <_Fault+0x38>

80000ecc <z_irq_spurious>:
#include <toolchain.h>
#include <kernel_structs.h>
#include <misc/printk.h>

void z_irq_spurious(void *unused)
{
80000ecc:	ff010113          	addi	sp,sp,-16
80000ed0:	00112623          	sw	ra,12(sp)
	u32_t mcause;

	ARG_UNUSED(unused);

	__asm__ volatile("csrr %0, mcause" : "=r" (mcause));
80000ed4:	342025f3          	csrr	a1,mcause

	mcause &= SOC_MCAUSE_EXP_MASK;

	printk("Spurious interrupt detected! IRQ: %d\n", (int)mcause);
80000ed8:	80006537          	lui	a0,0x80006
	mcause &= SOC_MCAUSE_EXP_MASK;
80000edc:	00159593          	slli	a1,a1,0x1
	printk("Spurious interrupt detected! IRQ: %d\n", (int)mcause);
80000ee0:	0015d593          	srli	a1,a1,0x1
80000ee4:	14450513          	addi	a0,a0,324 # 80006144 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006145>
80000ee8:	76d000ef          	jal	ra,80001e54 <printk>
		printk("PLIC interrupt line causing the IRQ: %d\n",
		       riscv_plic_get_irq());
	}
#endif

	z_NanoFatalErrorHandler(_NANO_ERR_SPURIOUS_INT, &_default_esf);
80000eec:	800065b7          	lui	a1,0x80006
80000ef0:	e9058593          	addi	a1,a1,-368 # 80005e90 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005e91>
80000ef4:	00400513          	li	a0,4
80000ef8:	e69ff0ef          	jal	ra,80000d60 <z_NanoFatalErrorHandler>

80000efc <z_irq_do_offload>:
 */
void z_irq_do_offload(void)
{
	irq_offload_routine_t tmp;

	if (!_offload_routine)
80000efc:	800077b7          	lui	a5,0x80007
80000f00:	96078793          	addi	a5,a5,-1696 # 80006960 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006961>
80000f04:	0007a703          	lw	a4,0(a5)
80000f08:	00070c63          	beqz	a4,80000f20 <z_irq_do_offload+0x24>
		return;

	tmp = _offload_routine;
80000f0c:	0007a303          	lw	t1,0(a5)
	_offload_routine = NULL;
80000f10:	0007a023          	sw	zero,0(a5)

	tmp((void *)offload_param);
80000f14:	800077b7          	lui	a5,0x80007
80000f18:	9647a503          	lw	a0,-1692(a5) # 80006964 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006965>
80000f1c:	00030067          	jr	t1 # 80000000 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80000001>
}
80000f20:	00008067          	ret

80000f24 <irq_offload>:
 */
static ALWAYS_INLINE unsigned int z_arch_irq_lock(void)
{
	unsigned int key, mstatus;

	__asm__ volatile ("csrrc %0, mstatus, %1"
80000f24:	00800793          	li	a5,8
80000f28:	3007b7f3          	csrrc	a5,mstatus,a5
void irq_offload(irq_offload_routine_t routine, void *parameter)
{
	unsigned int key;

	key = irq_lock();
	_offload_routine = routine;
80000f2c:	80007737          	lui	a4,0x80007
80000f30:	96a72023          	sw	a0,-1696(a4) # 80006960 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006961>
	offload_param = parameter;
80000f34:	80007737          	lui	a4,0x80007
80000f38:	96b72223          	sw	a1,-1692(a4) # 80006964 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006965>

	__asm__ volatile ("ecall");
80000f3c:	00000073          	ecall
			  : "=r" (mstatus)
			  : "r" (SOC_MSTATUS_IEN)
			  : "memory");

	key = (mstatus & SOC_MSTATUS_IEN);
80000f40:	0087f793          	andi	a5,a5,8
 */
static ALWAYS_INLINE void z_arch_irq_unlock(unsigned int key)
{
	unsigned int mstatus;

	__asm__ volatile ("csrrs %0, mstatus, %1"
80000f44:	3007a7f3          	csrrs	a5,mstatus,a5

	irq_unlock(key);
}
80000f48:	00008067          	ret

80000f4c <_PrepC>:
 *
 * @return N/A
 */

void _PrepC(void)
{
80000f4c:	ff010113          	addi	sp,sp,-16
80000f50:	00112623          	sw	ra,12(sp)
	z_bss_zero();
80000f54:	27d010ef          	jal	ra,800029d0 <z_bss_zero>
#ifdef CONFIG_XIP
	z_data_copy();
#endif
#if defined(CONFIG_RISCV_SOC_INTERRUPT_INIT)
	soc_interrupt_init();
80000f58:	78d000ef          	jal	ra,80001ee4 <soc_interrupt_init>
#endif
	z_cstart();
80000f5c:	2e1010ef          	jal	ra,80002a3c <z_cstart>

80000f60 <__initialize>:

	/*
	 * Initially, setup stack pointer to
	 * _interrupt_stack + CONFIG_ISR_STACK_SIZE
	 */
	la sp, _interrupt_stack
80000f60:	00006117          	auipc	sp,0x6
80000f64:	77010113          	addi	sp,sp,1904 # 800076d0 <_interrupt_stack>
	li t0, CONFIG_ISR_STACK_SIZE
80000f68:	000012b7          	lui	t0,0x1
80000f6c:	80028293          	addi	t0,t0,-2048 # 800 <CONFIG_ISR_STACK_SIZE>
	add sp, sp, t0
80000f70:	00510133          	add	sp,sp,t0

	/*
	 * Jump into C domain. _PrepC zeroes BSS, copies rw data into RAM,
	 * and then enters kernel z_cstart
	 */
	call _PrepC
80000f74:	fd9ff0ef          	jal	ra,80000f4c <_PrepC>

80000f78 <z_thread_entry_wrapper>:
	 * in registers a0, a1, a2 and a3. These registers are used as arguments
	 * to function z_thread_entry. Hence, just call z_thread_entry with
	 * return address set to 0 to indicate a non-returning function call.
	 */

	jal x0, z_thread_entry
80000f78:	0890006f          	j	80001800 <z_thread_entry>

80000f7c <z_new_thread>:

void z_new_thread(struct k_thread *thread, k_thread_stack_t *stack,
		 size_t stack_size, k_thread_entry_t thread_func,
		 void *arg1, void *arg2, void *arg3,
		 int priority, unsigned int options)
{
80000f7c:	fd010113          	addi	sp,sp,-48
80000f80:	02812423          	sw	s0,40(sp)
80000f84:	02912223          	sw	s1,36(sp)
80000f88:	03212023          	sw	s2,32(sp)
80000f8c:	01312e23          	sw	s3,28(sp)
80000f90:	01412c23          	sw	s4,24(sp)
80000f94:	01512a23          	sw	s5,20(sp)
80000f98:	01612823          	sw	s6,16(sp)
80000f9c:	01712623          	sw	s7,12(sp)
80000fa0:	00078b13          	mv	s6,a5
80000fa4:	02112623          	sw	ra,44(sp)
80000fa8:	01812423          	sw	s8,8(sp)
	char *stack_memory = Z_THREAD_STACK_BUFFER(stack);
	Z_ASSERT_VALID_PRIO(priority, thread_func);
80000fac:	00f00793          	li	a5,15
{
80000fb0:	00050493          	mv	s1,a0
80000fb4:	00058413          	mv	s0,a1
80000fb8:	00060993          	mv	s3,a2
80000fbc:	00068a13          	mv	s4,a3
80000fc0:	00070b93          	mv	s7,a4
80000fc4:	00080a93          	mv	s5,a6
80000fc8:	00088913          	mv	s2,a7
	Z_ASSERT_VALID_PRIO(priority, thread_func);
80000fcc:	08f89a63          	bne	a7,a5,80001060 <z_new_thread+0xe4>
80000fd0:	800037b7          	lui	a5,0x80003
80000fd4:	99878793          	addi	a5,a5,-1640 # 80002998 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80002999>
80000fd8:	08f69a63          	bne	a3,a5,8000106c <z_new_thread+0xf0>
	 * if it isn't.
	 */
	*((u32_t *)pStack) = STACK_SENTINEL;
#endif /* CONFIG_STACK_SENTINEL */
	/* Initialize various struct k_thread members */
	z_init_thread_base(&thread->base, prio, _THREAD_PRESTART, options);
80000fdc:	03012683          	lw	a3,48(sp)
80000fe0:	00090593          	mv	a1,s2
80000fe4:	00048513          	mv	a0,s1
80000fe8:	00400613          	li	a2,4
80000fec:	78c030ef          	jal	ra,80004778 <z_init_thread_base>

	z_new_thread_init(thread, stack_memory, stack_size, priority, options);

	/* Initial stack frame for thread */
	stack_init = (struct __esf *)
		STACK_ROUND_DOWN(stack_memory +
80000ff0:	fb098593          	addi	a1,s3,-80
80000ff4:	00b405b3          	add	a1,s0,a1
	 *    restored following the MSTATUS value set within the thread stack;
	 * 2) the core will jump to z_thread_entry_wrapper, as the program
	 *    counter will be restored following the MEPC value set within the
	 *    thread stack.
	 */
	stack_init->mstatus = SOC_MSTATUS_DEF_RESTORE;
80000ff8:	000027b7          	lui	a5,0x2

	/* static threads overwrite it afterwards with real value */
	thread->init_data = NULL;
80000ffc:	0404ae23          	sw	zero,92(s1)
	thread->fn_abort = NULL;
80001000:	0604a023          	sw	zero,96(s1)
		STACK_ROUND_DOWN(stack_memory +
80001004:	ff05f593          	andi	a1,a1,-16
	stack_init->mstatus = SOC_MSTATUS_DEF_RESTORE;
80001008:	88078793          	addi	a5,a5,-1920 # 1880 <CONFIG_ISR_STACK_SIZE+0x1080>
8000100c:	04f5a623          	sw	a5,76(a1)
	stack_init->mepc = (u32_t)z_thread_entry_wrapper;
80001010:	800017b7          	lui	a5,0x80001

	thread->callee_saved.sp = (u32_t)stack_init;
}
80001014:	02c12083          	lw	ra,44(sp)
80001018:	02812403          	lw	s0,40(sp)
	stack_init->mepc = (u32_t)z_thread_entry_wrapper;
8000101c:	f7878793          	addi	a5,a5,-136 # 80000f78 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80000f79>
	stack_init->a0 = (u32_t)thread_func;
80001020:	0345a423          	sw	s4,40(a1)
	stack_init->a1 = (u32_t)arg1;
80001024:	0375a623          	sw	s7,44(a1)
	stack_init->a2 = (u32_t)arg2;
80001028:	0365a823          	sw	s6,48(a1)
	stack_init->a3 = (u32_t)arg3;
8000102c:	0355aa23          	sw	s5,52(a1)
	stack_init->mepc = (u32_t)z_thread_entry_wrapper;
80001030:	04f5a423          	sw	a5,72(a1)
	thread->callee_saved.sp = (u32_t)stack_init;
80001034:	02b4a423          	sw	a1,40(s1)
}
80001038:	02012903          	lw	s2,32(sp)
8000103c:	02412483          	lw	s1,36(sp)
80001040:	01c12983          	lw	s3,28(sp)
80001044:	01812a03          	lw	s4,24(sp)
80001048:	01412a83          	lw	s5,20(sp)
8000104c:	01012b03          	lw	s6,16(sp)
80001050:	00c12b83          	lw	s7,12(sp)
80001054:	00812c03          	lw	s8,8(sp)
80001058:	03010113          	addi	sp,sp,48
8000105c:	00008067          	ret
	Z_ASSERT_VALID_PRIO(priority, thread_func);
80001060:	01088693          	addi	a3,a7,16
80001064:	01e00793          	li	a5,30
80001068:	f6d7fae3          	bgeu	a5,a3,80000fdc <z_new_thread+0x60>
8000106c:	80006c37          	lui	s8,0x80006
80001070:	800065b7          	lui	a1,0x80006
80001074:	80006537          	lui	a0,0x80006
80001078:	16cc0613          	addi	a2,s8,364 # 8000616c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000616d>
8000107c:	01800693          	li	a3,24
80001080:	18c58593          	addi	a1,a1,396 # 8000618c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000618d>
80001084:	21850513          	addi	a0,a0,536 # 80006218 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006219>
80001088:	5cd000ef          	jal	ra,80001e54 <printk>
8000108c:	80006537          	lui	a0,0x80006
80001090:	00090593          	mv	a1,s2
80001094:	ff000693          	li	a3,-16
80001098:	00e00613          	li	a2,14
8000109c:	23850513          	addi	a0,a0,568 # 80006238 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006239>
800010a0:	5b5000ef          	jal	ra,80001e54 <printk>
800010a4:	01800593          	li	a1,24
800010a8:	16cc0513          	addi	a0,s8,364
800010ac:	5e5000ef          	jal	ra,80001e90 <assert_post_action>
800010b0:	f2dff06f          	j	80000fdc <z_new_thread+0x60>

800010b4 <get_bit_ptr>:
 * within that word as the return value
 */
static int get_bit_ptr(struct sys_mem_pool_base *p, int level, int bn,
		       u32_t **word)
{
	u32_t *bitarray = level <= p->max_inline_level ?
800010b4:	00c00793          	li	a5,12
800010b8:	02f58733          	mul	a4,a1,a5
800010bc:	00c52783          	lw	a5,12(a0)
800010c0:	00e787b3          	add	a5,a5,a4
800010c4:	00b50703          	lb	a4,11(a0)
		&p->levels[level].bits : p->levels[level].bits_p;
800010c8:	00b75463          	bge	a4,a1,800010d0 <get_bit_ptr+0x1c>
800010cc:	0007a783          	lw	a5,0(a5)

	*word = &bitarray[bn / 32];
800010d0:	02000713          	li	a4,32
800010d4:	02e64733          	div	a4,a2,a4

	return bn & 0x1f;
}
800010d8:	01f67513          	andi	a0,a2,31
	*word = &bitarray[bn / 32];
800010dc:	00271713          	slli	a4,a4,0x2
800010e0:	00e787b3          	add	a5,a5,a4
800010e4:	00f6a023          	sw	a5,0(a3)
}
800010e8:	00008067          	ret

800010ec <set_free_bit>:

static void set_free_bit(struct sys_mem_pool_base *p, int level, int bn)
{
800010ec:	fe010113          	addi	sp,sp,-32
	u32_t *word;
	int bit = get_bit_ptr(p, level, bn, &word);
800010f0:	00c10693          	addi	a3,sp,12
{
800010f4:	00112e23          	sw	ra,28(sp)
	int bit = get_bit_ptr(p, level, bn, &word);
800010f8:	fbdff0ef          	jal	ra,800010b4 <get_bit_ptr>

	*word |= (1<<bit);
800010fc:	00c12703          	lw	a4,12(sp)
80001100:	00100793          	li	a5,1
80001104:	00a79533          	sll	a0,a5,a0
80001108:	00072783          	lw	a5,0(a4)
}
8000110c:	01c12083          	lw	ra,28(sp)
	*word |= (1<<bit);
80001110:	00a7e7b3          	or	a5,a5,a0
80001114:	00f72023          	sw	a5,0(a4)
}
80001118:	02010113          	addi	sp,sp,32
8000111c:	00008067          	ret

80001120 <clear_free_bit>:

static void clear_free_bit(struct sys_mem_pool_base *p, int level, int bn)
{
80001120:	fe010113          	addi	sp,sp,-32
	u32_t *word;
	int bit = get_bit_ptr(p, level, bn, &word);
80001124:	00c10693          	addi	a3,sp,12
{
80001128:	00112e23          	sw	ra,28(sp)
	int bit = get_bit_ptr(p, level, bn, &word);
8000112c:	f89ff0ef          	jal	ra,800010b4 <get_bit_ptr>

	*word &= ~(1<<bit);
80001130:	00c12703          	lw	a4,12(sp)
80001134:	00100793          	li	a5,1
80001138:	00a79533          	sll	a0,a5,a0
8000113c:	00072783          	lw	a5,0(a4)
}
80001140:	01c12083          	lw	ra,28(sp)
	*word &= ~(1<<bit);
80001144:	fff54513          	not	a0,a0
80001148:	00a7f533          	and	a0,a5,a0
8000114c:	00a72023          	sw	a0,0(a4)
}
80001150:	02010113          	addi	sp,sp,32
80001154:	00008067          	ret

80001158 <z_sys_mem_pool_base_init>:
}

void z_sys_mem_pool_base_init(struct sys_mem_pool_base *p)
{
	int i;
	size_t buflen = p->n_max * p->max_sz, sz = p->max_sz;
80001158:	00452783          	lw	a5,4(a0)
8000115c:	00855803          	lhu	a6,8(a0)
{
80001160:	ff010113          	addi	sp,sp,-16
80001164:	00812423          	sw	s0,8(sp)
	size_t buflen = p->n_max * p->max_sz, sz = p->max_sz;
80001168:	02f80833          	mul	a6,a6,a5
{
8000116c:	00050413          	mv	s0,a0
	u32_t *bits = (u32_t *)((u8_t *)p->buf + buflen);
80001170:	00052503          	lw	a0,0(a0)

	p->max_inline_level = -1;

	for (i = 0; i < p->n_levels; i++) {
80001174:	00a44883          	lbu	a7,10(s0)
	p->max_inline_level = -1;
80001178:	fff00713          	li	a4,-1
{
8000117c:	00112623          	sw	ra,12(sp)
80001180:	00912223          	sw	s1,4(sp)
	p->max_inline_level = -1;
80001184:	00e405a3          	sb	a4,11(s0)
	for (i = 0; i < p->n_levels; i++) {
80001188:	00000593          	li	a1,0
		int nblocks = buflen / sz;

		sys_dlist_init(&p->levels[i].free_list);
8000118c:	00c00313          	li	t1,12
	u32_t *bits = (u32_t *)((u8_t *)p->buf + buflen);
80001190:	01050533          	add	a0,a0,a6

		if (nblocks < 32) {
80001194:	01f00e13          	li	t3,31
			p->max_inline_level = i;
		} else {
			p->levels[i].bits_p = bits;
			bits += (nblocks + 31)/32;
80001198:	02000e93          	li	t4,32
	for (i = 0; i < p->n_levels; i++) {
8000119c:	0315c263          	blt	a1,a7,800011c0 <z_sys_mem_pool_base_init+0x68>
		}

		sz = _ALIGN4(sz / 4);
	}

	for (i = 0; i < p->n_max; i++) {
800011a0:	00000493          	li	s1,0
800011a4:	00845783          	lhu	a5,8(s0)
800011a8:	06f4c463          	blt	s1,a5,80001210 <z_sys_mem_pool_base_init+0xb8>
		void *block = block_ptr(p, p->max_sz, i);

		sys_dlist_append(&p->levels[0].free_list, block);
		set_free_bit(p, 0, i);
	}
}
800011ac:	00c12083          	lw	ra,12(sp)
800011b0:	00812403          	lw	s0,8(sp)
800011b4:	00412483          	lw	s1,4(sp)
800011b8:	01010113          	addi	sp,sp,16
800011bc:	00008067          	ret
		int nblocks = buflen / sz;
800011c0:	02f85733          	divu	a4,a6,a5
		sys_dlist_init(&p->levels[i].free_list);
800011c4:	00c42603          	lw	a2,12(s0)
800011c8:	026586b3          	mul	a3,a1,t1
800011cc:	00d606b3          	add	a3,a2,a3
800011d0:	00468613          	addi	a2,a3,4
 * @return N/A
 */

static inline void sys_dlist_init(sys_dlist_t *list)
{
	list->head = (sys_dnode_t *)list;
800011d4:	00c6a223          	sw	a2,4(a3)
	list->tail = (sys_dnode_t *)list;
800011d8:	00c6a423          	sw	a2,8(a3)
		if (nblocks < 32) {
800011dc:	00ee4e63          	blt	t3,a4,800011f8 <z_sys_mem_pool_base_init+0xa0>
			p->max_inline_level = i;
800011e0:	00b405a3          	sb	a1,11(s0)
		sz = _ALIGN4(sz / 4);
800011e4:	0027d793          	srli	a5,a5,0x2
800011e8:	00378793          	addi	a5,a5,3
800011ec:	ffc7f793          	andi	a5,a5,-4
	for (i = 0; i < p->n_levels; i++) {
800011f0:	00158593          	addi	a1,a1,1
800011f4:	fa9ff06f          	j	8000119c <z_sys_mem_pool_base_init+0x44>
			bits += (nblocks + 31)/32;
800011f8:	01f70713          	addi	a4,a4,31
800011fc:	03d74733          	div	a4,a4,t4
			p->levels[i].bits_p = bits;
80001200:	00a6a023          	sw	a0,0(a3)
			bits += (nblocks + 31)/32;
80001204:	00271713          	slli	a4,a4,0x2
80001208:	00e50533          	add	a0,a0,a4
8000120c:	fd9ff06f          	j	800011e4 <z_sys_mem_pool_base_init+0x8c>
	return (u8_t *)p->buf + lsz * block;
80001210:	00442783          	lw	a5,4(s0)
		set_free_bit(p, 0, i);
80001214:	00048613          	mv	a2,s1
80001218:	00000593          	li	a1,0
	return (u8_t *)p->buf + lsz * block;
8000121c:	02f48733          	mul	a4,s1,a5
80001220:	00042783          	lw	a5,0(s0)
		set_free_bit(p, 0, i);
80001224:	00040513          	mv	a0,s0
	for (i = 0; i < p->n_max; i++) {
80001228:	00148493          	addi	s1,s1,1
	return (u8_t *)p->buf + lsz * block;
8000122c:	00e787b3          	add	a5,a5,a4
		sys_dlist_append(&p->levels[0].free_list, block);
80001230:	00c42703          	lw	a4,12(s0)
80001234:	00470693          	addi	a3,a4,4
 * @return N/A
 */

static inline void sys_dlist_append(sys_dlist_t *list, sys_dnode_t *node)
{
	node->next = list;
80001238:	00d7a023          	sw	a3,0(a5)
	node->prev = list->tail;
8000123c:	00872683          	lw	a3,8(a4)
80001240:	00d7a223          	sw	a3,4(a5)

	list->tail->next = node;
80001244:	00872683          	lw	a3,8(a4)
80001248:	00f6a023          	sw	a5,0(a3)
	list->tail = node;
8000124c:	00f72423          	sw	a5,8(a4)
		set_free_bit(p, 0, i);
80001250:	e9dff0ef          	jal	ra,800010ec <set_free_bit>
80001254:	f51ff06f          	j	800011a4 <z_sys_mem_pool_base_init+0x4c>

80001258 <z_sys_mem_pool_block_alloc>:
	return block;
}

int z_sys_mem_pool_block_alloc(struct sys_mem_pool_base *p, size_t size,
			      u32_t *level_p, u32_t *block_p, void **data_p)
{
80001258:	fb010113          	addi	sp,sp,-80
8000125c:	04812423          	sw	s0,72(sp)
80001260:	03712623          	sw	s7,44(sp)
80001264:	04112623          	sw	ra,76(sp)
80001268:	04912223          	sw	s1,68(sp)
8000126c:	05212023          	sw	s2,64(sp)
80001270:	03312e23          	sw	s3,60(sp)
80001274:	03412c23          	sw	s4,56(sp)
80001278:	03512a23          	sw	s5,52(sp)
8000127c:	03612823          	sw	s6,48(sp)
80001280:	03812423          	sw	s8,40(sp)
80001284:	03912223          	sw	s9,36(sp)
80001288:	03a12023          	sw	s10,32(sp)
8000128c:	01b12e23          	sw	s11,28(sp)
80001290:	05010413          	addi	s0,sp,80
	int i, from_l, alloc_l = -1;
	unsigned int key;
	void *data = NULL;
	size_t lsizes[LVL_ARRAY_SZ(p->n_levels)];
80001294:	00a54e03          	lbu	t3,10(a0)
	 * from which we can split an allocation if needed.  Along the
	 * way, we populate an array of sizes for each level so we
	 * don't need to waste RAM storing it.
	 */
	lsizes[0] = _ALIGN4(p->max_sz);
	for (i = 0; i < p->n_levels; i++) {
80001298:	00000893          	li	a7,0
	size_t lsizes[LVL_ARRAY_SZ(p->n_levels)];
8000129c:	002e1793          	slli	a5,t3,0x2
800012a0:	00f78793          	addi	a5,a5,15
800012a4:	7f07f793          	andi	a5,a5,2032
800012a8:	40f10133          	sub	sp,sp,a5
	lsizes[0] = _ALIGN4(p->max_sz);
800012ac:	00452783          	lw	a5,4(a0)
	size_t lsizes[LVL_ARRAY_SZ(p->n_levels)];
800012b0:	00010b93          	mv	s7,sp
	lsizes[0] = _ALIGN4(p->max_sz);
800012b4:	000b8313          	mv	t1,s7
800012b8:	00378793          	addi	a5,a5,3
800012bc:	ffc7f793          	andi	a5,a5,-4
800012c0:	00fba023          	sw	a5,0(s7)
	for (i = 0; i < p->n_levels; i++) {
800012c4:	fff88c13          	addi	s8,a7,-1
800012c8:	03c8d463          	bge	a7,t3,800012f0 <z_sys_mem_pool_block_alloc+0x98>
		if (i > 0) {
800012cc:	00088c63          	beqz	a7,800012e4 <z_sys_mem_pool_block_alloc+0x8c>
			lsizes[i] = _ALIGN4(lsizes[i-1] / 4);
800012d0:	ffc32783          	lw	a5,-4(t1)
800012d4:	0027d793          	srli	a5,a5,0x2
800012d8:	00378793          	addi	a5,a5,3
800012dc:	ffc7f793          	andi	a5,a5,-4
800012e0:	00f32023          	sw	a5,0(t1)
		}

		if (lsizes[i] < size) {
800012e4:	00430313          	addi	t1,t1,4
800012e8:	ffc32783          	lw	a5,-4(t1)
800012ec:	04b7fa63          	bgeu	a5,a1,80001340 <z_sys_mem_pool_block_alloc+0xe8>
		}

		alloc_l = i;
	}

	if (alloc_l < 0) {
800012f0:	fff00793          	li	a5,-1
800012f4:	04fc1a63          	bne	s8,a5,80001348 <z_sys_mem_pool_block_alloc+0xf0>
		*data_p = NULL;
800012f8:	00072023          	sw	zero,0(a4)
		return -ENOMEM;
800012fc:	ff400513          	li	a0,-12

	*level_p = alloc_l;
	*block_p = block_num(p, data, lsizes[alloc_l]);

	return 0;
}
80001300:	fb040113          	addi	sp,s0,-80
80001304:	04c12083          	lw	ra,76(sp)
80001308:	04812403          	lw	s0,72(sp)
8000130c:	04412483          	lw	s1,68(sp)
80001310:	04012903          	lw	s2,64(sp)
80001314:	03c12983          	lw	s3,60(sp)
80001318:	03812a03          	lw	s4,56(sp)
8000131c:	03412a83          	lw	s5,52(sp)
80001320:	03012b03          	lw	s6,48(sp)
80001324:	02c12b83          	lw	s7,44(sp)
80001328:	02812c03          	lw	s8,40(sp)
8000132c:	02412c83          	lw	s9,36(sp)
80001330:	02012d03          	lw	s10,32(sp)
80001334:	01c12d83          	lw	s11,28(sp)
80001338:	05010113          	addi	sp,sp,80
8000133c:	00008067          	ret
	for (i = 0; i < p->n_levels; i++) {
80001340:	00188893          	addi	a7,a7,1
80001344:	f81ff06f          	j	800012c4 <z_sys_mem_pool_block_alloc+0x6c>
	if (p->flags & SYS_MEM_POOL_KERNEL) {
80001348:	01054783          	lbu	a5,16(a0)
		return 0;
8000134c:	00000913          	li	s2,0
	if (p->flags & SYS_MEM_POOL_KERNEL) {
80001350:	0017f793          	andi	a5,a5,1
80001354:	00078863          	beqz	a5,80001364 <z_sys_mem_pool_block_alloc+0x10c>
	__asm__ volatile ("csrrc %0, mstatus, %1"
80001358:	00800913          	li	s2,8
8000135c:	30093973          	csrrc	s2,mstatus,s2
	key = (mstatus & SOC_MSTATUS_IEN);
80001360:	00897913          	andi	s2,s2,8
80001364:	00c00793          	li	a5,12
80001368:	02fc07b3          	mul	a5,s8,a5
8000136c:	fae42e23          	sw	a4,-68(s0)
80001370:	00068d13          	mv	s10,a3
80001374:	00060c93          	mv	s9,a2
80001378:	00050493          	mv	s1,a0
	block = sys_dlist_get(&p->levels[l].free_list);
8000137c:	000c0a13          	mv	s4,s8
80001380:	00478713          	addi	a4,a5,4
80001384:	00c52783          	lw	a5,12(a0)
80001388:	00e787b3          	add	a5,a5,a4
	for (i = alloc_l; i >= 0; i--) {
8000138c:	fff00713          	li	a4,-1
	return list->head == list;
80001390:	0007a983          	lw	s3,0(a5)

static inline sys_dnode_t *sys_dlist_get(sys_dlist_t *list)
{
	sys_dnode_t *node = NULL;

	if (!sys_dlist_is_empty(list)) {
80001394:	17378c63          	beq	a5,s3,8000150c <z_sys_mem_pool_block_alloc+0x2b4>
	node->prev->next = node->next;
80001398:	0009a783          	lw	a5,0(s3)
8000139c:	0049a703          	lw	a4,4(s3)
		data = block_alloc(p, i, lsizes[i]);
800013a0:	002a1a93          	slli	s5,s4,0x2
800013a4:	015b8ab3          	add	s5,s7,s5
800013a8:	00f72023          	sw	a5,0(a4)
	node->next->prev = node->prev;
800013ac:	00e7a223          	sw	a4,4(a5)
	node->next = NULL;
800013b0:	0009a023          	sw	zero,0(s3)
	node->prev = NULL;
800013b4:	0009a223          	sw	zero,4(s3)
	return ((u8_t *)block - (u8_t *)p->buf) / sz;
800013b8:	0004a783          	lw	a5,0(s1)
		data = block_alloc(p, i, lsizes[i]);
800013bc:	000aa603          	lw	a2,0(s5)
		clear_free_bit(p, l, block_num(p, block, lsz));
800013c0:	000a0593          	mv	a1,s4
	return ((u8_t *)block - (u8_t *)p->buf) / sz;
800013c4:	40f987b3          	sub	a5,s3,a5
		clear_free_bit(p, l, block_num(p, block, lsz));
800013c8:	02c7c633          	div	a2,a5,a2
800013cc:	00048513          	mv	a0,s1
800013d0:	001a0a13          	addi	s4,s4,1
800013d4:	d4dff0ef          	jal	ra,80001120 <clear_free_bit>
		if (data != NULL) {
800013d8:	00c00693          	li	a3,12
			for (from_l = i; from_l < alloc_l; from_l++) {
800013dc:	fffa0793          	addi	a5,s4,-1
800013e0:	0587c663          	blt	a5,s8,8000142c <z_sys_mem_pool_block_alloc+0x1d4>
	if (p->flags & SYS_MEM_POOL_KERNEL) {
800013e4:	0104c783          	lbu	a5,16(s1)
800013e8:	0017f793          	andi	a5,a5,1
800013ec:	00078463          	beqz	a5,800013f4 <z_sys_mem_pool_block_alloc+0x19c>
	__asm__ volatile ("csrrs %0, mstatus, %1"
800013f0:	30092973          	csrrs	s2,mstatus,s2
	*data_p = data;
800013f4:	fbc42783          	lw	a5,-68(s0)
		return -ENOMEM;
800013f8:	ff400513          	li	a0,-12
	*data_p = data;
800013fc:	0137a023          	sw	s3,0(a5)
	if (data == NULL) {
80001400:	f00980e3          	beqz	s3,80001300 <z_sys_mem_pool_block_alloc+0xa8>
	return ((u8_t *)block - (u8_t *)p->buf) / sz;
80001404:	0004a783          	lw	a5,0(s1)
	*block_p = block_num(p, data, lsizes[alloc_l]);
80001408:	002c1813          	slli	a6,s8,0x2
8000140c:	010b8bb3          	add	s7,s7,a6
	return ((u8_t *)block - (u8_t *)p->buf) / sz;
80001410:	40f989b3          	sub	s3,s3,a5
80001414:	000ba783          	lw	a5,0(s7)
	*level_p = alloc_l;
80001418:	018ca023          	sw	s8,0(s9)
	return 0;
8000141c:	00000513          	li	a0,0
	return ((u8_t *)block - (u8_t *)p->buf) / sz;
80001420:	02f9c9b3          	div	s3,s3,a5
	*block_p = block_num(p, data, lsizes[alloc_l]);
80001424:	013d2023          	sw	s3,0(s10)
	return 0;
80001428:	ed9ff06f          	j	80001300 <z_sys_mem_pool_block_alloc+0xa8>
	return ((u8_t *)block - (u8_t *)p->buf) / sz;
8000142c:	0004ad83          	lw	s11,0(s1)
80001430:	000aa783          	lw	a5,0(s5)
80001434:	02da0eb3          	mul	t4,s4,a3
80001438:	41b98db3          	sub	s11,s3,s11
	for (i = 1; i < 4; i++) {
8000143c:	00100713          	li	a4,1
	return ((u8_t *)block - (u8_t *)p->buf) / sz;
80001440:	02fdcdb3          	div	s11,s11,a5
		int lbn = 4*bn + i;
80001444:	002d9d93          	slli	s11,s11,0x2
		int lsz = lsizes[l + 1];
80001448:	004aab03          	lw	s6,4(s5)
		set_free_bit(p, l + 1, lbn);
8000144c:	01b70633          	add	a2,a4,s11
80001450:	000a0593          	mv	a1,s4
		void *block2 = (lsz * i) + (char *)block;
80001454:	02eb0e33          	mul	t3,s6,a4
		set_free_bit(p, l + 1, lbn);
80001458:	00048513          	mv	a0,s1
8000145c:	fbd42823          	sw	t4,-80(s0)
80001460:	fae42c23          	sw	a4,-72(s0)
	return ((u8_t *)block + bsz - 1 - (u8_t *)p->buf) < buf_size(p);
80001464:	fffb0b13          	addi	s6,s6,-1
		void *block2 = (lsz * i) + (char *)block;
80001468:	01c98e33          	add	t3,s3,t3
8000146c:	fbc42a23          	sw	t3,-76(s0)
		set_free_bit(p, l + 1, lbn);
80001470:	c7dff0ef          	jal	ra,800010ec <set_free_bit>
	return ((u8_t *)block + bsz - 1 - (u8_t *)p->buf) < buf_size(p);
80001474:	fb442e03          	lw	t3,-76(s0)
80001478:	0004a783          	lw	a5,0(s1)
	return p->n_max * p->max_sz;
8000147c:	0044a603          	lw	a2,4(s1)
	return ((u8_t *)block + bsz - 1 - (u8_t *)p->buf) < buf_size(p);
80001480:	016e0b33          	add	s6,t3,s6
80001484:	40fb0b33          	sub	s6,s6,a5
	return p->n_max * p->max_sz;
80001488:	0084d783          	lhu	a5,8(s1)
		if (block_fits(p, block2, lsz)) {
8000148c:	fb842703          	lw	a4,-72(s0)
80001490:	fb042e83          	lw	t4,-80(s0)
	return p->n_max * p->max_sz;
80001494:	02c787b3          	mul	a5,a5,a2
		if (block_fits(p, block2, lsz)) {
80001498:	00c00693          	li	a3,12
8000149c:	00400893          	li	a7,4
800014a0:	00800313          	li	t1,8
800014a4:	02fb7463          	bgeu	s6,a5,800014cc <z_sys_mem_pool_block_alloc+0x274>
			sys_dlist_append(&p->levels[l + 1].free_list, block2);
800014a8:	00c4a783          	lw	a5,12(s1)
800014ac:	01d787b3          	add	a5,a5,t4
800014b0:	00478613          	addi	a2,a5,4
	node->next = list;
800014b4:	00ce2023          	sw	a2,0(t3)
	node->prev = list->tail;
800014b8:	0087a603          	lw	a2,8(a5)
800014bc:	00ce2223          	sw	a2,4(t3)
	list->tail->next = node;
800014c0:	0087a603          	lw	a2,8(a5)
800014c4:	01c62023          	sw	t3,0(a2)
	list->tail = node;
800014c8:	01c7a423          	sw	t3,8(a5)
	for (i = 1; i < 4; i++) {
800014cc:	00170713          	addi	a4,a4,1
800014d0:	f7171ce3          	bne	a4,a7,80001448 <z_sys_mem_pool_block_alloc+0x1f0>
	if (p->flags & SYS_MEM_POOL_KERNEL) {
800014d4:	0104c783          	lbu	a5,16(s1)
800014d8:	0017f793          	andi	a5,a5,1
800014dc:	00079a63          	bnez	a5,800014f0 <z_sys_mem_pool_block_alloc+0x298>
		return 0;
800014e0:	00000913          	li	s2,0
800014e4:	001a0a13          	addi	s4,s4,1
800014e8:	004a8a93          	addi	s5,s5,4
800014ec:	ef1ff06f          	j	800013dc <z_sys_mem_pool_block_alloc+0x184>
800014f0:	30092973          	csrrs	s2,mstatus,s2
	if (p->flags & SYS_MEM_POOL_KERNEL) {
800014f4:	0104c783          	lbu	a5,16(s1)
800014f8:	0017f793          	andi	a5,a5,1
800014fc:	fe0782e3          	beqz	a5,800014e0 <z_sys_mem_pool_block_alloc+0x288>
	__asm__ volatile ("csrrc %0, mstatus, %1"
80001500:	30033973          	csrrc	s2,mstatus,t1
	key = (mstatus & SOC_MSTATUS_IEN);
80001504:	00897913          	andi	s2,s2,8
80001508:	fddff06f          	j	800014e4 <z_sys_mem_pool_block_alloc+0x28c>
	for (i = alloc_l; i >= 0; i--) {
8000150c:	fffa0a13          	addi	s4,s4,-1
80001510:	ff498793          	addi	a5,s3,-12
80001514:	e6ea1ee3          	bne	s4,a4,80001390 <z_sys_mem_pool_block_alloc+0x138>
80001518:	00000993          	li	s3,0
8000151c:	ec9ff06f          	j	800013e4 <z_sys_mem_pool_block_alloc+0x18c>

80001520 <z_sys_mem_pool_block_free>:

void z_sys_mem_pool_block_free(struct sys_mem_pool_base *p, u32_t level,
			      u32_t block)
{
80001520:	fa010113          	addi	sp,sp,-96
80001524:	04812c23          	sw	s0,88(sp)
80001528:	05312623          	sw	s3,76(sp)
8000152c:	03712e23          	sw	s7,60(sp)
80001530:	04112e23          	sw	ra,92(sp)
80001534:	04912a23          	sw	s1,84(sp)
80001538:	05212823          	sw	s2,80(sp)
8000153c:	05412423          	sw	s4,72(sp)
80001540:	05512223          	sw	s5,68(sp)
80001544:	05612023          	sw	s6,64(sp)
80001548:	03812c23          	sw	s8,56(sp)
8000154c:	03912a23          	sw	s9,52(sp)
80001550:	03a12823          	sw	s10,48(sp)
80001554:	03b12623          	sw	s11,44(sp)
80001558:	06010413          	addi	s0,sp,96
	size_t lsizes[LVL_ARRAY_SZ(p->n_levels)];
8000155c:	00a54683          	lbu	a3,10(a0)
{
80001560:	00050b93          	mv	s7,a0
	 * Overhead here is somewhat higher because block_free()
	 * doesn't inherently need to traverse all the larger
	 * sublevels.
	 */
	lsizes[0] = _ALIGN4(p->max_sz);
	for (i = 1; i <= level; i++) {
80001564:	00100813          	li	a6,1
	size_t lsizes[LVL_ARRAY_SZ(p->n_levels)];
80001568:	00269693          	slli	a3,a3,0x2
8000156c:	00f68693          	addi	a3,a3,15
80001570:	7f06f693          	andi	a3,a3,2032
80001574:	40d10133          	sub	sp,sp,a3
	lsizes[0] = _ALIGN4(p->max_sz);
80001578:	00452683          	lw	a3,4(a0)
	size_t lsizes[LVL_ARRAY_SZ(p->n_levels)];
8000157c:	00010993          	mv	s3,sp
	lsizes[0] = _ALIGN4(p->max_sz);
80001580:	00098513          	mv	a0,s3
80001584:	00368693          	addi	a3,a3,3
80001588:	ffc6f693          	andi	a3,a3,-4
8000158c:	00d9a023          	sw	a3,0(s3)
	for (i = 1; i <= level; i++) {
80001590:	00450513          	addi	a0,a0,4
80001594:	0d05f463          	bgeu	a1,a6,8000165c <z_sys_mem_pool_block_free+0x13c>
	if (p->flags & SYS_MEM_POOL_KERNEL) {
80001598:	010bc683          	lbu	a3,16(s7)
		lsizes[i] = _ALIGN4(lsizes[i-1] / 4);
	}

	block_free(p, level, lsizes, block);
8000159c:	00058c13          	mv	s8,a1
800015a0:	00060913          	mv	s2,a2
	if (p->flags & SYS_MEM_POOL_KERNEL) {
800015a4:	0016f693          	andi	a3,a3,1
		return 0;
800015a8:	00000493          	li	s1,0
	if (p->flags & SYS_MEM_POOL_KERNEL) {
800015ac:	00068863          	beqz	a3,800015bc <z_sys_mem_pool_block_free+0x9c>
	__asm__ volatile ("csrrc %0, mstatus, %1"
800015b0:	00800493          	li	s1,8
800015b4:	3004b4f3          	csrrc	s1,mstatus,s1
	key = (mstatus & SOC_MSTATUS_IEN);
800015b8:	0084f493          	andi	s1,s1,8
		__ASSERT(block_fits(p, block, lsz), "");
800015bc:	80006ab7          	lui	s5,0x80006
		sys_dlist_append(&p->levels[level].free_list, block);
800015c0:	00c00d13          	li	s10,12
	__asm__ volatile ("csrrc %0, mstatus, %1"
800015c4:	00800d93          	li	s11,8
	while (level >= 0) {
800015c8:	0a0c5863          	bgez	s8,80001678 <z_sys_mem_pool_block_free+0x158>
	__ASSERT(0, "out of levels");
800015cc:	800064b7          	lui	s1,0x80006
800015d0:	800065b7          	lui	a1,0x80006
800015d4:	80006537          	lui	a0,0x80006
800015d8:	26c48613          	addi	a2,s1,620 # 8000626c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000626d>
800015dc:	0c000693          	li	a3,192
800015e0:	2d458593          	addi	a1,a1,724 # 800062d4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800062d5>
800015e4:	21850513          	addi	a0,a0,536 # 80006218 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006219>
800015e8:	06d000ef          	jal	ra,80001e54 <printk>
800015ec:	80006537          	lui	a0,0x80006
800015f0:	2a050513          	addi	a0,a0,672 # 800062a0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800062a1>
800015f4:	061000ef          	jal	ra,80001e54 <printk>
800015f8:	26c48513          	addi	a0,s1,620
800015fc:	0c000593          	li	a1,192
80001600:	091000ef          	jal	ra,80001e90 <assert_post_action>
	return -1;
80001604:	fff00493          	li	s1,-1
	if (p->flags & SYS_MEM_POOL_KERNEL) {
80001608:	010bc783          	lbu	a5,16(s7)
8000160c:	0017f793          	andi	a5,a5,1
80001610:	00078663          	beqz	a5,8000161c <z_sys_mem_pool_block_free+0xfc>
			  : "=r" (mstatus)
			  : "r" (key & SOC_MSTATUS_IEN)
80001614:	0084f493          	andi	s1,s1,8
	__asm__ volatile ("csrrs %0, mstatus, %1"
80001618:	3004a4f3          	csrrs	s1,mstatus,s1
}
8000161c:	fa040113          	addi	sp,s0,-96
80001620:	05c12083          	lw	ra,92(sp)
80001624:	05812403          	lw	s0,88(sp)
80001628:	05412483          	lw	s1,84(sp)
8000162c:	05012903          	lw	s2,80(sp)
80001630:	04c12983          	lw	s3,76(sp)
80001634:	04812a03          	lw	s4,72(sp)
80001638:	04412a83          	lw	s5,68(sp)
8000163c:	04012b03          	lw	s6,64(sp)
80001640:	03c12b83          	lw	s7,60(sp)
80001644:	03812c03          	lw	s8,56(sp)
80001648:	03412c83          	lw	s9,52(sp)
8000164c:	03012d03          	lw	s10,48(sp)
80001650:	02c12d83          	lw	s11,44(sp)
80001654:	06010113          	addi	sp,sp,96
80001658:	00008067          	ret
		lsizes[i] = _ALIGN4(lsizes[i-1] / 4);
8000165c:	ffc52683          	lw	a3,-4(a0)
	for (i = 1; i <= level; i++) {
80001660:	00180813          	addi	a6,a6,1
		lsizes[i] = _ALIGN4(lsizes[i-1] / 4);
80001664:	0026d693          	srli	a3,a3,0x2
80001668:	00368693          	addi	a3,a3,3
8000166c:	ffc6f693          	andi	a3,a3,-4
80001670:	00d52023          	sw	a3,0(a0)
80001674:	f1dff06f          	j	80001590 <z_sys_mem_pool_block_free+0x70>
		int i, lsz = lsizes[level];
80001678:	002c1693          	slli	a3,s8,0x2
8000167c:	00d986b3          	add	a3,s3,a3
80001680:	0006aa03          	lw	s4,0(a3)
	return p->n_max * p->max_sz;
80001684:	008bd603          	lhu	a2,8(s7)
80001688:	004ba583          	lw	a1,4(s7)
	return (u8_t *)p->buf + lsz * block;
8000168c:	034906b3          	mul	a3,s2,s4
		void *block = block_ptr(p, lsz, bn);
80001690:	000ba803          	lw	a6,0(s7)
	return ((u8_t *)block + bsz - 1 - (u8_t *)p->buf) < buf_size(p);
80001694:	fffa0b13          	addi	s6,s4,-1
	return p->n_max * p->max_sz;
80001698:	02b60633          	mul	a2,a2,a1
	return ((u8_t *)block + bsz - 1 - (u8_t *)p->buf) < buf_size(p);
8000169c:	00d80cb3          	add	s9,a6,a3
800016a0:	00db06b3          	add	a3,s6,a3
		__ASSERT(block_fits(p, block, lsz), "");
800016a4:	02c6ec63          	bltu	a3,a2,800016dc <z_sys_mem_pool_block_free+0x1bc>
800016a8:	800067b7          	lui	a5,0x80006
800016ac:	28078593          	addi	a1,a5,640 # 80006280 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006281>
800016b0:	800067b7          	lui	a5,0x80006
800016b4:	21878513          	addi	a0,a5,536 # 80006218 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006219>
800016b8:	0a400693          	li	a3,164
800016bc:	26ca8613          	addi	a2,s5,620 # 8000626c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000626d>
800016c0:	794000ef          	jal	ra,80001e54 <printk>
800016c4:	800067b7          	lui	a5,0x80006
800016c8:	29c78513          	addi	a0,a5,668 # 8000629c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000629d>
800016cc:	788000ef          	jal	ra,80001e54 <printk>
800016d0:	0a400593          	li	a1,164
800016d4:	26ca8513          	addi	a0,s5,620
800016d8:	7b8000ef          	jal	ra,80001e90 <assert_post_action>
		set_free_bit(p, level, bn);
800016dc:	00090613          	mv	a2,s2
800016e0:	000c0593          	mv	a1,s8
800016e4:	000b8513          	mv	a0,s7
800016e8:	a05ff0ef          	jal	ra,800010ec <set_free_bit>
		sys_dlist_append(&p->levels[level].free_list, block);
800016ec:	03ac06b3          	mul	a3,s8,s10
800016f0:	00cba603          	lw	a2,12(s7)
800016f4:	00d606b3          	add	a3,a2,a3
800016f8:	00468613          	addi	a2,a3,4
	node->next = list;
800016fc:	00cca023          	sw	a2,0(s9)
	node->prev = list->tail;
80001700:	0086a603          	lw	a2,8(a3)
80001704:	00cca223          	sw	a2,4(s9)
	list->tail->next = node;
80001708:	0086a603          	lw	a2,8(a3)
8000170c:	01962023          	sw	s9,0(a2)
	list->tail = node;
80001710:	0196a423          	sw	s9,8(a3)
	if (p->flags & SYS_MEM_POOL_KERNEL) {
80001714:	010bc683          	lbu	a3,16(s7)
80001718:	0016f693          	andi	a3,a3,1
8000171c:	0c069463          	bnez	a3,800017e4 <z_sys_mem_pool_block_free+0x2c4>
		return 0;
80001720:	00000493          	li	s1,0
		if (level == 0 || partner_bits(p, level, bn) != 0xf) {
80001724:	ee0c02e3          	beqz	s8,80001608 <z_sys_mem_pool_block_free+0xe8>
	int bit = get_bit_ptr(p, level, bn, &word);
80001728:	fbc40693          	addi	a3,s0,-68
8000172c:	00090613          	mv	a2,s2
80001730:	000c0593          	mv	a1,s8
80001734:	000b8513          	mv	a0,s7
80001738:	97dff0ef          	jal	ra,800010b4 <get_bit_ptr>
	return (*word >> (4*(bit / 4))) & 0xf;
8000173c:	00400693          	li	a3,4
80001740:	02d546b3          	div	a3,a0,a3
80001744:	fbc42603          	lw	a2,-68(s0)
80001748:	00062503          	lw	a0,0(a2)
8000174c:	00269693          	slli	a3,a3,0x2
80001750:	00d55533          	srl	a0,a0,a3
80001754:	00f57513          	andi	a0,a0,15
		if (level == 0 || partner_bits(p, level, bn) != 0xf) {
80001758:	00f00693          	li	a3,15
8000175c:	ead516e3          	bne	a0,a3,80001608 <z_sys_mem_pool_block_free+0xe8>
		for (i = 0; i < 4; i++) {
80001760:	00000813          	li	a6,0
			int b = (bn & ~3) + i;
80001764:	ffc97e13          	andi	t3,s2,-4
		for (i = 0; i < 4; i++) {
80001768:	00400313          	li	t1,4
	return p->n_max * p->max_sz;
8000176c:	008bd583          	lhu	a1,8(s7)
80001770:	004ba503          	lw	a0,4(s7)
			int b = (bn & ~3) + i;
80001774:	010e0633          	add	a2,t3,a6
	return (u8_t *)p->buf + lsz * block;
80001778:	034608b3          	mul	a7,a2,s4
	return p->n_max * p->max_sz;
8000177c:	02a585b3          	mul	a1,a1,a0
			if (block_fits(p, block_ptr(p, lsz, b), lsz)) {
80001780:	016886b3          	add	a3,a7,s6
80001784:	04b6f663          	bgeu	a3,a1,800017d0 <z_sys_mem_pool_block_free+0x2b0>
				clear_free_bit(p, level, b);
80001788:	000c0593          	mv	a1,s8
8000178c:	000b8513          	mv	a0,s7
80001790:	fbc42223          	sw	t3,-92(s0)
80001794:	fb042423          	sw	a6,-88(s0)
80001798:	fb142623          	sw	a7,-84(s0)
8000179c:	985ff0ef          	jal	ra,80001120 <clear_free_bit>
	return (u8_t *)p->buf + lsz * block;
800017a0:	000ba683          	lw	a3,0(s7)
800017a4:	fac42883          	lw	a7,-84(s0)
	node->prev = NULL;
800017a8:	fa442e03          	lw	t3,-92(s0)
800017ac:	fa842803          	lw	a6,-88(s0)
800017b0:	011686b3          	add	a3,a3,a7
	node->prev->next = node->next;
800017b4:	0046a583          	lw	a1,4(a3)
800017b8:	0006a603          	lw	a2,0(a3)
	node->prev = NULL;
800017bc:	00400313          	li	t1,4
	node->prev->next = node->next;
800017c0:	00c5a023          	sw	a2,0(a1)
	node->next->prev = node->prev;
800017c4:	00b62223          	sw	a1,4(a2)
	node->next = NULL;
800017c8:	0006a023          	sw	zero,0(a3)
	node->prev = NULL;
800017cc:	0006a223          	sw	zero,4(a3)
		for (i = 0; i < 4; i++) {
800017d0:	00180813          	addi	a6,a6,1
800017d4:	f8681ce3          	bne	a6,t1,8000176c <z_sys_mem_pool_block_free+0x24c>
		level = level - 1;
800017d8:	fffc0c13          	addi	s8,s8,-1
		bn = bn / 4;
800017dc:	03094933          	div	s2,s2,a6
800017e0:	de9ff06f          	j	800015c8 <z_sys_mem_pool_block_free+0xa8>
800017e4:	3004a4f3          	csrrs	s1,mstatus,s1
	if (p->flags & SYS_MEM_POOL_KERNEL) {
800017e8:	010bc683          	lbu	a3,16(s7)
800017ec:	0016f693          	andi	a3,a3,1
800017f0:	f20688e3          	beqz	a3,80001720 <z_sys_mem_pool_block_free+0x200>
	__asm__ volatile ("csrrc %0, mstatus, %1"
800017f4:	300db4f3          	csrrc	s1,mstatus,s11
	key = (mstatus & SOC_MSTATUS_IEN);
800017f8:	0084f493          	andi	s1,s1,8
800017fc:	f29ff06f          	j	80001724 <z_sys_mem_pool_block_free+0x204>

80001800 <z_thread_entry>:
 * This routine does not return, and is marked as such so the compiler won't
 * generate preamble code that is only used by functions that actually return.
 */
FUNC_NORETURN void z_thread_entry(k_thread_entry_t entry,
				 void *p1, void *p2, void *p3)
{
80001800:	ff010113          	addi	sp,sp,-16
80001804:	00050793          	mv	a5,a0
80001808:	00058513          	mv	a0,a1
8000180c:	00060593          	mv	a1,a2
	entry(p1, p2, p3);
80001810:	00068613          	mv	a2,a3
{
80001814:	00112623          	sw	ra,12(sp)
	entry(p1, p2, p3);
80001818:	000780e7          	jalr	a5
8000181c:	6c0020ef          	jal	ra,80003edc <z_impl_k_current_get>
K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_THREAD_ABORT, k_thread_abort, k_tid_t, thread)
80001820:	2dc030ef          	jal	ra,80004afc <z_impl_k_thread_abort>

80001824 <z_arch_printk_char_out>:
{
	ARG_UNUSED(c);

	/* do nothing */
	return 0;
}
80001824:	00000513          	li	a0,0
80001828:	00008067          	ret

8000182c <print_err>:
{
	return _char_out;
}

static void print_err(out_func_t out, void *ctx)
{
8000182c:	ff010113          	addi	sp,sp,-16
80001830:	00812423          	sw	s0,8(sp)
80001834:	00050413          	mv	s0,a0
	out('E', ctx);
80001838:	04500513          	li	a0,69
{
8000183c:	00112623          	sw	ra,12(sp)
80001840:	00912223          	sw	s1,4(sp)
80001844:	00058493          	mv	s1,a1
	out('E', ctx);
80001848:	000400e7          	jalr	s0
	out('R', ctx);
8000184c:	00048593          	mv	a1,s1
80001850:	05200513          	li	a0,82
80001854:	000400e7          	jalr	s0
	out('R', ctx);
80001858:	00040313          	mv	t1,s0
}
8000185c:	00812403          	lw	s0,8(sp)
80001860:	00c12083          	lw	ra,12(sp)
	out('R', ctx);
80001864:	00048593          	mv	a1,s1
}
80001868:	00412483          	lw	s1,4(sp)
	out('R', ctx);
8000186c:	05200513          	li	a0,82
}
80001870:	01010113          	addi	sp,sp,16
	out('R', ctx);
80001874:	00030067          	jr	t1

80001878 <char_out>:

static int char_out(int c, void *ctx_p)
{
	struct out_context *ctx = ctx_p;

	ctx->count++;
80001878:	0005a783          	lw	a5,0(a1)
8000187c:	00178793          	addi	a5,a5,1
80001880:	00f5a023          	sw	a5,0(a1)
	return _char_out(c);
80001884:	800077b7          	lui	a5,0x80007
80001888:	8947a303          	lw	t1,-1900(a5) # 80006894 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006895>
8000188c:	00030067          	jr	t1

80001890 <_printk_dec_ulong>:
 * @return N/A
 */
static void _printk_dec_ulong(out_func_t out, void *ctx,
			      const unsigned long num, enum pad_type padding,
			      int min_width)
{
80001890:	fb010113          	addi	sp,sp,-80
80001894:	04812423          	sw	s0,72(sp)
80001898:	03312e23          	sw	s3,60(sp)
8000189c:	03412c23          	sw	s4,56(sp)
800018a0:	03512a23          	sw	s5,52(sp)
800018a4:	03612823          	sw	s6,48(sp)
800018a8:	04112623          	sw	ra,76(sp)
800018ac:	04912223          	sw	s1,68(sp)
800018b0:	05212023          	sw	s2,64(sp)
800018b4:	03712623          	sw	s7,44(sp)
800018b8:	03812423          	sw	s8,40(sp)
800018bc:	03912223          	sw	s9,36(sp)
800018c0:	03a12023          	sw	s10,32(sp)
800018c4:	01b12e23          	sw	s11,28(sp)
800018c8:	00050a13          	mv	s4,a0
800018cc:	00058a93          	mv	s5,a1
800018d0:	00060993          	mv	s3,a2
800018d4:	00068b13          	mv	s6,a3
800018d8:	00100413          	li	s0,1
800018dc:	00e05463          	blez	a4,800018e4 <_printk_dec_ulong+0x54>
800018e0:	00070413          	mv	s0,a4
800018e4:	00100793          	li	a5,1
800018e8:	02000c13          	li	s8,32
800018ec:	00fb1463          	bne	s6,a5,800018f4 <_printk_dec_ulong+0x64>
800018f0:	03000c13          	li	s8,48
800018f4:	3b9ad4b7          	lui	s1,0x3b9ad
800018f8:	00100913          	li	s2,1
800018fc:	00a00c93          	li	s9,10
80001900:	00000713          	li	a4,0
80001904:	9ff48493          	addi	s1,s1,-1537 # 3b9ac9ff <CONFIG_SYS_CLOCK_HW_CYCLES_PER_SEC+0x3ae3aeff>
		if (found_largest_digit != 0 || remainder > pos) {
			found_largest_digit = 1;
			out((int)((remainder / (pos + 1)) + 48), ctx);
			digits++;
		} else if (remaining <= min_width
				&& padding < PAD_SPACE_AFTER) {
80001908:	00200d93          	li	s11,2
			out((int)(padding == PAD_ZERO_BEFORE ? '0' : ' '), ctx);
			digits++;
		}
		remaining--;
		remainder %= (pos + 1);
		pos /= 10;
8000190c:	00a00d13          	li	s10,10
		if (found_largest_digit != 0 || remainder > pos) {
80001910:	00148b93          	addi	s7,s1,1
80001914:	00071463          	bnez	a4,8000191c <_printk_dec_ulong+0x8c>
80001918:	0934f263          	bgeu	s1,s3,8000199c <_printk_dec_ulong+0x10c>
			out((int)((remainder / (pos + 1)) + 48), ctx);
8000191c:	0379d533          	divu	a0,s3,s7
80001920:	000a8593          	mv	a1,s5
			digits++;
80001924:	00190913          	addi	s2,s2,1
			out((int)((remainder / (pos + 1)) + 48), ctx);
80001928:	03050513          	addi	a0,a0,48
8000192c:	000a00e7          	jalr	s4
			found_largest_digit = 1;
80001930:	00100713          	li	a4,1
		remaining--;
80001934:	fffc8c93          	addi	s9,s9,-1
	while (pos >= 9) {
80001938:	00100793          	li	a5,1
		remainder %= (pos + 1);
8000193c:	0379f9b3          	remu	s3,s3,s7
		pos /= 10;
80001940:	03a4d4b3          	divu	s1,s1,s10
	while (pos >= 9) {
80001944:	fcfc96e3          	bne	s9,a5,80001910 <_printk_dec_ulong+0x80>
	}
	out((int)(remainder + 48), ctx);
80001948:	000a8593          	mv	a1,s5
8000194c:	03098513          	addi	a0,s3,48
80001950:	000a00e7          	jalr	s4

	if (padding == PAD_SPACE_AFTER) {
80001954:	00300793          	li	a5,3
		remaining = min_width - digits;
80001958:	41240433          	sub	s0,s0,s2
	if (padding == PAD_SPACE_AFTER) {
8000195c:	06fb0a63          	beq	s6,a5,800019d0 <_printk_dec_ulong+0x140>
		while (remaining-- > 0) {
			out(' ', ctx);
		}
	}
}
80001960:	04c12083          	lw	ra,76(sp)
80001964:	04812403          	lw	s0,72(sp)
80001968:	04412483          	lw	s1,68(sp)
8000196c:	04012903          	lw	s2,64(sp)
80001970:	03c12983          	lw	s3,60(sp)
80001974:	03812a03          	lw	s4,56(sp)
80001978:	03412a83          	lw	s5,52(sp)
8000197c:	03012b03          	lw	s6,48(sp)
80001980:	02c12b83          	lw	s7,44(sp)
80001984:	02812c03          	lw	s8,40(sp)
80001988:	02412c83          	lw	s9,36(sp)
8000198c:	02012d03          	lw	s10,32(sp)
80001990:	01c12d83          	lw	s11,28(sp)
80001994:	05010113          	addi	sp,sp,80
80001998:	00008067          	ret
		} else if (remaining <= min_width
8000199c:	f9944ce3          	blt	s0,s9,80001934 <_printk_dec_ulong+0xa4>
				&& padding < PAD_SPACE_AFTER) {
800019a0:	f96deae3          	bltu	s11,s6,80001934 <_printk_dec_ulong+0xa4>
			out((int)(padding == PAD_ZERO_BEFORE ? '0' : ' '), ctx);
800019a4:	000a8593          	mv	a1,s5
800019a8:	000c0513          	mv	a0,s8
800019ac:	00e12623          	sw	a4,12(sp)
800019b0:	000a00e7          	jalr	s4
			digits++;
800019b4:	00190913          	addi	s2,s2,1
800019b8:	00c12703          	lw	a4,12(sp)
800019bc:	f79ff06f          	j	80001934 <_printk_dec_ulong+0xa4>
			out(' ', ctx);
800019c0:	000a8593          	mv	a1,s5
800019c4:	02000513          	li	a0,32
800019c8:	000a00e7          	jalr	s4
800019cc:	fff40413          	addi	s0,s0,-1
		while (remaining-- > 0) {
800019d0:	fe8048e3          	bgtz	s0,800019c0 <_printk_dec_ulong+0x130>
800019d4:	f8dff06f          	j	80001960 <_printk_dec_ulong+0xd0>

800019d8 <__printk_hook_install>:
	_char_out = fn;
800019d8:	800077b7          	lui	a5,0x80007
800019dc:	88a7aa23          	sw	a0,-1900(a5) # 80006894 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006895>
}
800019e0:	00008067          	ret

800019e4 <z_vprintk>:
{
800019e4:	fb010113          	addi	sp,sp,-80
800019e8:	04812423          	sw	s0,72(sp)
800019ec:	04912223          	sw	s1,68(sp)
800019f0:	05212023          	sw	s2,64(sp)
800019f4:	03312e23          	sw	s3,60(sp)
800019f8:	03412c23          	sw	s4,56(sp)
800019fc:	03512a23          	sw	s5,52(sp)
80001a00:	03912223          	sw	s9,36(sp)
80001a04:	03a12023          	sw	s10,32(sp)
80001a08:	01b12e23          	sw	s11,28(sp)
80001a0c:	04112623          	sw	ra,76(sp)
80001a10:	03612823          	sw	s6,48(sp)
80001a14:	03712623          	sw	s7,44(sp)
80001a18:	03812423          	sw	s8,40(sp)
80001a1c:	00050413          	mv	s0,a0
80001a20:	00058493          	mv	s1,a1
80001a24:	00060a93          	mv	s5,a2
80001a28:	00068d13          	mv	s10,a3
	int long_ctr = 0;
80001a2c:	00000a13          	li	s4,0
	int min_width = -1;
80001a30:	fff00913          	li	s2,-1
	enum pad_type padding = PAD_NONE;
80001a34:	00000993          	li	s3,0
	int might_format = 0; /* 1 if encountered a '%' */
80001a38:	00000c93          	li	s9,0
					if (lld > INT32_MAX ||
80001a3c:	80000db7          	lui	s11,0x80000
	while (*fmt) {
80001a40:	000ac503          	lbu	a0,0(s5)
80001a44:	04051063          	bnez	a0,80001a84 <z_vprintk+0xa0>
}
80001a48:	04c12083          	lw	ra,76(sp)
80001a4c:	04812403          	lw	s0,72(sp)
80001a50:	04412483          	lw	s1,68(sp)
80001a54:	04012903          	lw	s2,64(sp)
80001a58:	03c12983          	lw	s3,60(sp)
80001a5c:	03812a03          	lw	s4,56(sp)
80001a60:	03412a83          	lw	s5,52(sp)
80001a64:	03012b03          	lw	s6,48(sp)
80001a68:	02c12b83          	lw	s7,44(sp)
80001a6c:	02812c03          	lw	s8,40(sp)
80001a70:	02412c83          	lw	s9,36(sp)
80001a74:	02012d03          	lw	s10,32(sp)
80001a78:	01c12d83          	lw	s11,28(sp)
80001a7c:	05010113          	addi	sp,sp,80
80001a80:	00008067          	ret
		if (!might_format) {
80001a84:	000c9e63          	bnez	s9,80001aa0 <z_vprintk+0xbc>
			if (*fmt != '%') {
80001a88:	02500693          	li	a3,37
80001a8c:	36d50a63          	beq	a0,a3,80001e00 <z_vprintk+0x41c>
				out((int)*fmt, ctx);
80001a90:	00048593          	mv	a1,s1
80001a94:	000400e7          	jalr	s0
		++fmt;
80001a98:	001a8a93          	addi	s5,s5,1
80001a9c:	fa5ff06f          	j	80001a40 <z_vprintk+0x5c>
			switch (*fmt) {
80001aa0:	06400693          	li	a3,100
80001aa4:	10d50e63          	beq	a0,a3,80001bc0 <z_vprintk+0x1dc>
80001aa8:	06a6e263          	bltu	a3,a0,80001b0c <z_vprintk+0x128>
80001aac:	03900693          	li	a3,57
80001ab0:	02a6ea63          	bltu	a3,a0,80001ae4 <z_vprintk+0x100>
80001ab4:	03100693          	li	a3,49
80001ab8:	0ed57463          	bgeu	a0,a3,80001ba0 <z_vprintk+0x1bc>
80001abc:	02d00693          	li	a3,45
80001ac0:	34d50a63          	beq	a0,a3,80001e14 <z_vprintk+0x430>
80001ac4:	03000793          	li	a5,48
80001ac8:	0cf50063          	beq	a0,a5,80001b88 <z_vprintk+0x1a4>
80001acc:	02500713          	li	a4,37
80001ad0:	02e51263          	bne	a0,a4,80001af4 <z_vprintk+0x110>
				out((int)'%', ctx);
80001ad4:	00048593          	mv	a1,s1
80001ad8:	02500513          	li	a0,37
				out((int)*fmt, ctx);
80001adc:	000400e7          	jalr	s0
				break;
80001ae0:	15c0006f          	j	80001c3c <z_vprintk+0x258>
80001ae4:	05800693          	li	a3,88
80001ae8:	1ad50e63          	beq	a0,a3,80001ca4 <z_vprintk+0x2c0>
80001aec:	06300713          	li	a4,99
80001af0:	2ee50e63          	beq	a0,a4,80001dec <z_vprintk+0x408>
				out((int)'%', ctx);
80001af4:	00048593          	mv	a1,s1
80001af8:	02500513          	li	a0,37
80001afc:	000400e7          	jalr	s0
				out((int)*fmt, ctx);
80001b00:	00048593          	mv	a1,s1
80001b04:	000ac503          	lbu	a0,0(s5)
80001b08:	fd5ff06f          	j	80001adc <z_vprintk+0xf8>
80001b0c:	07000693          	li	a3,112
80001b10:	16d50a63          	beq	a0,a3,80001c84 <z_vprintk+0x2a0>
80001b14:	02a6e063          	bltu	a3,a0,80001b34 <z_vprintk+0x150>
80001b18:	06900693          	li	a3,105
80001b1c:	0ad50263          	beq	a0,a3,80001bc0 <z_vprintk+0x1dc>
80001b20:	06c00693          	li	a3,108
80001b24:	08d50a63          	beq	a0,a3,80001bb8 <z_vprintk+0x1d4>
80001b28:	06800693          	li	a3,104
80001b2c:	f6d506e3          	beq	a0,a3,80001a98 <z_vprintk+0xb4>
80001b30:	fc5ff06f          	j	80001af4 <z_vprintk+0x110>
80001b34:	07500693          	li	a3,117
80001b38:	10d50663          	beq	a0,a3,80001c44 <z_vprintk+0x260>
80001b3c:	02a6ee63          	bltu	a3,a0,80001b78 <z_vprintk+0x194>
80001b40:	07300713          	li	a4,115
80001b44:	fae518e3          	bne	a0,a4,80001af4 <z_vprintk+0x110>
				char *s = va_arg(ap, char *);
80001b48:	000d2c03          	lw	s8,0(s10)
80001b4c:	004d0b13          	addi	s6,s10,4
80001b50:	000c0b93          	mv	s7,s8
				while (*s)
80001b54:	000bc503          	lbu	a0,0(s7)
80001b58:	26051863          	bnez	a0,80001dc8 <z_vprintk+0x3e4>
				if (padding == PAD_SPACE_AFTER) {
80001b5c:	00300793          	li	a5,3
80001b60:	00f99863          	bne	s3,a5,80001b70 <z_vprintk+0x18c>
					int remaining = min_width - (s - start);
80001b64:	418b8bb3          	sub	s7,s7,s8
80001b68:	41790bb3          	sub	s7,s2,s7
					while (remaining-- > 0) {
80001b6c:	27704663          	bgtz	s7,80001dd8 <z_vprintk+0x3f4>
				char *s = va_arg(ap, char *);
80001b70:	000b0d13          	mv	s10,s6
80001b74:	0c80006f          	j	80001c3c <z_vprintk+0x258>
80001b78:	07800693          	li	a3,120
80001b7c:	12d50463          	beq	a0,a3,80001ca4 <z_vprintk+0x2c0>
80001b80:	07a00693          	li	a3,122
80001b84:	fa9ff06f          	j	80001b2c <z_vprintk+0x148>
				if (min_width < 0 && padding == PAD_NONE) {
80001b88:	00095e63          	bgez	s2,80001ba4 <z_vprintk+0x1c0>
80001b8c:	28098863          	beqz	s3,80001e1c <z_vprintk+0x438>
					min_width = *fmt - '0';
80001b90:	fd050913          	addi	s2,a0,-48
				if (padding == PAD_NONE) {
80001b94:	f00992e3          	bnez	s3,80001a98 <z_vprintk+0xb4>
					padding = PAD_SPACE_BEFORE;
80001b98:	00200993          	li	s3,2
80001b9c:	efdff06f          	j	80001a98 <z_vprintk+0xb4>
				if (min_width < 0) {
80001ba0:	fe0948e3          	bltz	s2,80001b90 <z_vprintk+0x1ac>
					min_width = 10 * min_width + *fmt - '0';
80001ba4:	00a00693          	li	a3,10
80001ba8:	02d90933          	mul	s2,s2,a3
80001bac:	fd090913          	addi	s2,s2,-48
80001bb0:	01250933          	add	s2,a0,s2
80001bb4:	fe1ff06f          	j	80001b94 <z_vprintk+0x1b0>
				long_ctr++;
80001bb8:	001a0a13          	addi	s4,s4,1
80001bbc:	eddff06f          	j	80001a98 <z_vprintk+0xb4>
				if (long_ctr == 0) {
80001bc0:	040a1263          	bnez	s4,80001c04 <z_vprintk+0x220>
					long ld = va_arg(ap, long);
80001bc4:	000d2603          	lw	a2,0(s10)
80001bc8:	004d0d13          	addi	s10,s10,4
				if (d < 0) {
80001bcc:	02065063          	bgez	a2,80001bec <z_vprintk+0x208>
					out((int)'-', ctx);
80001bd0:	00048593          	mv	a1,s1
80001bd4:	02d00513          	li	a0,45
80001bd8:	00c12023          	sw	a2,0(sp)
80001bdc:	000400e7          	jalr	s0
					d = -d;
80001be0:	00012603          	lw	a2,0(sp)
					min_width--;
80001be4:	fff90913          	addi	s2,s2,-1
					d = -d;
80001be8:	40c00633          	neg	a2,a2
				_printk_dec_ulong(out, ctx, u, padding,
80001bec:	00090713          	mv	a4,s2
80001bf0:	00098693          	mv	a3,s3
80001bf4:	00048593          	mv	a1,s1
80001bf8:	00040513          	mv	a0,s0
80001bfc:	c95ff0ef          	jal	ra,80001890 <_printk_dec_ulong>
				break;
80001c00:	03c0006f          	j	80001c3c <z_vprintk+0x258>
				} else if (long_ctr == 1) {
80001c04:	00100713          	li	a4,1
80001c08:	faea0ee3          	beq	s4,a4,80001bc4 <z_vprintk+0x1e0>
					long long lld = va_arg(ap, long long);
80001c0c:	007d0793          	addi	a5,s10,7
80001c10:	ff87f713          	andi	a4,a5,-8
80001c14:	00072603          	lw	a2,0(a4)
80001c18:	00472683          	lw	a3,4(a4)
80001c1c:	00870d13          	addi	s10,a4,8
					if (lld > INT32_MAX ||
80001c20:	01b60733          	add	a4,a2,s11
80001c24:	00c73733          	sltu	a4,a4,a2
80001c28:	00d70733          	add	a4,a4,a3
80001c2c:	fa0700e3          	beqz	a4,80001bcc <z_vprintk+0x1e8>
						print_err(out, ctx);
80001c30:	00048593          	mv	a1,s1
80001c34:	00040513          	mv	a0,s0
80001c38:	bf5ff0ef          	jal	ra,8000182c <print_err>
			might_format = 0;
80001c3c:	00000c93          	li	s9,0
80001c40:	e59ff06f          	j	80001a98 <z_vprintk+0xb4>
				if (long_ctr == 0) {
80001c44:	000a1863          	bnez	s4,80001c54 <z_vprintk+0x270>
					long lu = va_arg(ap, unsigned long);
80001c48:	000d2603          	lw	a2,0(s10)
80001c4c:	004d0d13          	addi	s10,s10,4
80001c50:	f9dff06f          	j	80001bec <z_vprintk+0x208>
				} else if (long_ctr == 1) {
80001c54:	00100713          	li	a4,1
80001c58:	feea08e3          	beq	s4,a4,80001c48 <z_vprintk+0x264>
					unsigned long long llu =
80001c5c:	007d0793          	addi	a5,s10,7
80001c60:	ff87f713          	andi	a4,a5,-8
80001c64:	00870d13          	addi	s10,a4,8
80001c68:	00072603          	lw	a2,0(a4)
80001c6c:	00472703          	lw	a4,4(a4)
					if (llu > INT32_MAX) {
80001c70:	fc0710e3          	bnez	a4,80001c30 <z_vprintk+0x24c>
80001c74:	800007b7          	lui	a5,0x80000
80001c78:	fff7c793          	not	a5,a5
80001c7c:	f6c7f8e3          	bgeu	a5,a2,80001bec <z_vprintk+0x208>
80001c80:	fb1ff06f          	j	80001c30 <z_vprintk+0x24c>
				  out('0', ctx);
80001c84:	00048593          	mv	a1,s1
80001c88:	03000513          	li	a0,48
80001c8c:	000400e7          	jalr	s0
				  out('x', ctx);
80001c90:	00048593          	mv	a1,s1
80001c94:	07800513          	li	a0,120
80001c98:	000400e7          	jalr	s0
				  min_width = 8;
80001c9c:	00800913          	li	s2,8
				  padding = PAD_ZERO_BEFORE;
80001ca0:	00100993          	li	s3,1
				if (long_ctr < 2) {
80001ca4:	00100693          	li	a3,1
80001ca8:	0b46c263          	blt	a3,s4,80001d4c <z_vprintk+0x368>
					x = va_arg(ap, unsigned long);
80001cac:	000d2783          	lw	a5,0(s10)
80001cb0:	00012423          	sw	zero,8(sp)
80001cb4:	004d0d13          	addi	s10,s10,4
80001cb8:	00f12223          	sw	a5,4(sp)
	int remaining = 16; /* 16 digits max */
80001cbc:	01000c13          	li	s8,16
	int digits = 0;
80001cc0:	00000b93          	li	s7,0
	int found_largest_digit = 0;
80001cc4:	00012023          	sw	zero,0(sp)
	int size = sizeof(num) * 2;
80001cc8:	01000893          	li	a7,16
		char nibble = (num >> ((size - 1) << 2) & 0xf);
80001ccc:	00412503          	lw	a0,4(sp)
80001cd0:	00812583          	lw	a1,8(sp)
80001cd4:	fff88b13          	addi	s6,a7,-1
80001cd8:	002b1613          	slli	a2,s6,0x2
80001cdc:	01112623          	sw	a7,12(sp)
80001ce0:	da8fe0ef          	jal	ra,80000288 <__lshrdi3>
80001ce4:	00f57513          	andi	a0,a0,15
		if (nibble != 0 || found_largest_digit != 0 || size == 1) {
80001ce8:	08051863          	bnez	a0,80001d78 <z_vprintk+0x394>
80001cec:	00012783          	lw	a5,0(sp)
			nibble += nibble > 9 ? 87 : 48;
80001cf0:	03000693          	li	a3,48
		if (nibble != 0 || found_largest_digit != 0 || size == 1) {
80001cf4:	00079863          	bnez	a5,80001d04 <z_vprintk+0x320>
80001cf8:	00c12883          	lw	a7,12(sp)
80001cfc:	00100793          	li	a5,1
80001d00:	08f89663          	bne	a7,a5,80001d8c <z_vprintk+0x3a8>
			nibble += nibble > 9 ? 87 : 48;
80001d04:	00a68533          	add	a0,a3,a0
			out((int)nibble, ctx);
80001d08:	01851513          	slli	a0,a0,0x18
80001d0c:	00048593          	mv	a1,s1
80001d10:	41855513          	srai	a0,a0,0x18
80001d14:	000400e7          	jalr	s0
			digits++;
80001d18:	001b8b93          	addi	s7,s7,1
	for (; size != 0; size--) {
80001d1c:	040b1863          	bnez	s6,80001d6c <z_vprintk+0x388>
	if (padding == PAD_SPACE_AFTER) {
80001d20:	00300693          	li	a3,3
			might_format = 0;
80001d24:	00000c93          	li	s9,0
	if (padding == PAD_SPACE_AFTER) {
80001d28:	d6d998e3          	bne	s3,a3,80001a98 <z_vprintk+0xb4>
		remaining = min_width * 2 - digits;
80001d2c:	00191713          	slli	a4,s2,0x1
80001d30:	41770bb3          	sub	s7,a4,s7
		while (remaining-- > 0) {
80001d34:	f17054e3          	blez	s7,80001c3c <z_vprintk+0x258>
			out(' ', ctx);
80001d38:	00048593          	mv	a1,s1
80001d3c:	02000513          	li	a0,32
80001d40:	000400e7          	jalr	s0
80001d44:	fffb8b93          	addi	s7,s7,-1
80001d48:	fedff06f          	j	80001d34 <z_vprintk+0x350>
					x = va_arg(ap, unsigned long long);
80001d4c:	007d0793          	addi	a5,s10,7
80001d50:	ff87f693          	andi	a3,a5,-8
80001d54:	0006a783          	lw	a5,0(a3)
80001d58:	00868d13          	addi	s10,a3,8
80001d5c:	00f12223          	sw	a5,4(sp)
80001d60:	0046a783          	lw	a5,4(a3)
80001d64:	00f12423          	sw	a5,8(sp)
80001d68:	f55ff06f          	j	80001cbc <z_vprintk+0x2d8>
			found_largest_digit = 1;
80001d6c:	01912023          	sw	s9,0(sp)
		char nibble = (num >> ((size - 1) << 2) & 0xf);
80001d70:	000b0893          	mv	a7,s6
80001d74:	f59ff06f          	j	80001ccc <z_vprintk+0x2e8>
			nibble += nibble > 9 ? 87 : 48;
80001d78:	00900793          	li	a5,9
80001d7c:	05700693          	li	a3,87
80001d80:	f8a7e2e3          	bltu	a5,a0,80001d04 <z_vprintk+0x320>
80001d84:	03000693          	li	a3,48
80001d88:	f7dff06f          	j	80001d04 <z_vprintk+0x320>
		if (remaining-- <= min_width) {
80001d8c:	fffc0793          	addi	a5,s8,-1
80001d90:	00f12623          	sw	a5,12(sp)
80001d94:	01894c63          	blt	s2,s8,80001dac <z_vprintk+0x3c8>
			if (padding == PAD_ZERO_BEFORE) {
80001d98:	00100793          	li	a5,1
80001d9c:	00f99c63          	bne	s3,a5,80001db4 <z_vprintk+0x3d0>
				out('0', ctx);
80001da0:	00048593          	mv	a1,s1
80001da4:	03000513          	li	a0,48
				out(' ', ctx);
80001da8:	000400e7          	jalr	s0
					x = va_arg(ap, unsigned long);
80001dac:	00c12c03          	lw	s8,12(sp)
80001db0:	fc1ff06f          	j	80001d70 <z_vprintk+0x38c>
			} else if (padding == PAD_SPACE_BEFORE) {
80001db4:	00200793          	li	a5,2
80001db8:	fef99ae3          	bne	s3,a5,80001dac <z_vprintk+0x3c8>
				out(' ', ctx);
80001dbc:	00048593          	mv	a1,s1
80001dc0:	02000513          	li	a0,32
80001dc4:	fe5ff06f          	j	80001da8 <z_vprintk+0x3c4>
					out((int)(*s++), ctx);
80001dc8:	00048593          	mv	a1,s1
80001dcc:	001b8b93          	addi	s7,s7,1
80001dd0:	000400e7          	jalr	s0
80001dd4:	d81ff06f          	j	80001b54 <z_vprintk+0x170>
						out(' ', ctx);
80001dd8:	00048593          	mv	a1,s1
80001ddc:	02000513          	li	a0,32
80001de0:	000400e7          	jalr	s0
80001de4:	fffb8b93          	addi	s7,s7,-1
80001de8:	d85ff06f          	j	80001b6c <z_vprintk+0x188>
				out(c, ctx);
80001dec:	000d2503          	lw	a0,0(s10)
80001df0:	00048593          	mv	a1,s1
				int c = va_arg(ap, int);
80001df4:	004d0b13          	addi	s6,s10,4
				out(c, ctx);
80001df8:	000400e7          	jalr	s0
				break;
80001dfc:	d75ff06f          	j	80001b70 <z_vprintk+0x18c>
				long_ctr = 0;
80001e00:	00000a13          	li	s4,0
				min_width = -1;
80001e04:	fff00913          	li	s2,-1
				padding = PAD_NONE;
80001e08:	00000993          	li	s3,0
				might_format = 1;
80001e0c:	00100c93          	li	s9,1
80001e10:	c89ff06f          	j	80001a98 <z_vprintk+0xb4>
				padding = PAD_SPACE_AFTER;
80001e14:	00300993          	li	s3,3
80001e18:	c81ff06f          	j	80001a98 <z_vprintk+0xb4>
					padding = PAD_ZERO_BEFORE;
80001e1c:	00100993          	li	s3,1
80001e20:	c79ff06f          	j	80001a98 <z_vprintk+0xb4>

80001e24 <vprintk>:
{
80001e24:	fe010113          	addi	sp,sp,-32
	z_vprintk(char_out, &ctx, fmt, ap);
80001e28:	00050613          	mv	a2,a0
80001e2c:	80002537          	lui	a0,0x80002
80001e30:	00058693          	mv	a3,a1
80001e34:	87850513          	addi	a0,a0,-1928 # 80001878 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80001879>
80001e38:	00c10593          	addi	a1,sp,12
{
80001e3c:	00112e23          	sw	ra,28(sp)
	struct out_context ctx = { 0 };
80001e40:	00012623          	sw	zero,12(sp)
	z_vprintk(char_out, &ctx, fmt, ap);
80001e44:	ba1ff0ef          	jal	ra,800019e4 <z_vprintk>
}
80001e48:	01c12083          	lw	ra,28(sp)
80001e4c:	02010113          	addi	sp,sp,32
80001e50:	00008067          	ret

80001e54 <printk>:
{
80001e54:	fc010113          	addi	sp,sp,-64
80001e58:	02b12223          	sw	a1,36(sp)
	va_start(ap, fmt);
80001e5c:	02410593          	addi	a1,sp,36
{
80001e60:	00112e23          	sw	ra,28(sp)
80001e64:	02c12423          	sw	a2,40(sp)
80001e68:	02d12623          	sw	a3,44(sp)
80001e6c:	02e12823          	sw	a4,48(sp)
80001e70:	02f12a23          	sw	a5,52(sp)
80001e74:	03012c23          	sw	a6,56(sp)
80001e78:	03112e23          	sw	a7,60(sp)
	va_start(ap, fmt);
80001e7c:	00b12623          	sw	a1,12(sp)
		vprintk(fmt, ap);
80001e80:	fa5ff0ef          	jal	ra,80001e24 <vprintk>
}
80001e84:	01c12083          	lw	ra,28(sp)
80001e88:	04010113          	addi	sp,sp,64
80001e8c:	00008067          	ret

80001e90 <assert_post_action>:
__weak void assert_post_action(const char *file, unsigned int line)
{
  ARG_UNUSED(file);
  ARG_UNUSED(line);

  k_panic();
80001e90:	800065b7          	lui	a1,0x80006
80001e94:	80006537          	lui	a0,0x80006
{
80001e98:	ff010113          	addi	sp,sp,-16
  k_panic();
80001e9c:	2b058593          	addi	a1,a1,688 # 800062b0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800062b1>
80001ea0:	2c450513          	addi	a0,a0,708 # 800062c4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800062c5>
80001ea4:	01e00613          	li	a2,30
{
80001ea8:	00112623          	sw	ra,12(sp)
  k_panic();
80001eac:	fa9ff0ef          	jal	ra,80001e54 <printk>
80001eb0:	800065b7          	lui	a1,0x80006
80001eb4:	e9058593          	addi	a1,a1,-368 # 80005e90 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005e91>
80001eb8:	00600513          	li	a0,6
80001ebc:	ea5fe0ef          	jal	ra,80000d60 <z_NanoFatalErrorHandler>

80001ec0 <_ConfigAbsSyms>:
GEN_ABSOLUTE_SYM(CONFIG_OUTPUT_STAT, 1);
GEN_ABSOLUTE_SYM(CONFIG_OUTPUT_DISASSEMBLY, 1);
GEN_ABSOLUTE_SYM(CONFIG_OUTPUT_PRINT_MEMORY_USAGE, 1);
GEN_ABSOLUTE_SYM(CONFIG_BUILD_OUTPUT_BIN, 1);

GEN_ABS_SYM_END
80001ec0:	00008067          	ret

80001ec4 <k_cpu_idle>:
	__asm__ volatile ("csrrs %0, mstatus, %1"
80001ec4:	00800793          	li	a5,8
80001ec8:	3007a7f3          	csrrs	a5,mstatus,a5
	z_sys_trace_idle();
	/* unlock interrupts */
	irq_unlock(key);

	/* Wait for interrupt */
	__asm__ volatile("wfi");
80001ecc:	10500073          	wfi
 * @return N/A
 */
void k_cpu_idle(void)
{
	riscv_idle(SOC_MSTATUS_IEN);
}
80001ed0:	00008067          	ret

80001ed4 <z_arch_irq_enable>:
	 * CSR mie register is updated using atomic instruction csrrs
	 * (atomic read and set bits in CSR register)
	 */
	__asm__ volatile ("csrrs %0, mie, %1\n"
			  : "=r" (mie)
			  : "r" (1 << irq));
80001ed4:	00100793          	li	a5,1
80001ed8:	00a79533          	sll	a0,a5,a0
	__asm__ volatile ("csrrs %0, mie, %1\n"
80001edc:	30452573          	csrrs	a0,mie,a0
}
80001ee0:	00008067          	ret

80001ee4 <soc_interrupt_init>:
	__asm__ volatile ("csrrc %0, mstatus, %1"
80001ee4:	00800793          	li	a5,8
80001ee8:	3007b7f3          	csrrc	a5,mstatus,a5
void soc_interrupt_init(void)
{
	/* ensure that all interrupts are disabled */
	(void)irq_lock();

	__asm__ volatile ("csrwi mie, 0\n"
80001eec:	30405073          	csrwi	mie,0
80001ef0:	34405073          	csrwi	mip,0
			  "csrwi mip, 0\n");
}
80001ef4:	00008067          	ret

80001ef8 <console_out>:
 *
 * @return The character passed as input.
 */

static int console_out(int c)
{
80001ef8:	ff010113          	addi	sp,sp,-16
80001efc:	00812423          	sw	s0,8(sp)
80001f00:	00912223          	sw	s1,4(sp)
80001f04:	80007437          	lui	s0,0x80007
80001f08:	00112623          	sw	ra,12(sp)
		return c;
	}

#endif  /* CONFIG_UART_CONSOLE_DEBUG_SERVER_HOOKS */

	if ('\n' == c) {
80001f0c:	00a00793          	li	a5,10
{
80001f10:	00050493          	mv	s1,a0
80001f14:	96840413          	addi	s0,s0,-1688 # 80006968 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006969>
	if ('\n' == c) {
80001f18:	00f51c63          	bne	a0,a5,80001f30 <console_out+0x38>
80001f1c:	00042503          	lw	a0,0(s0)
						unsigned char out_char)
{
	const struct uart_driver_api *api =
		(const struct uart_driver_api *)dev->driver_api;

	api->poll_out(dev, out_char);
80001f20:	00d00593          	li	a1,13
80001f24:	00452783          	lw	a5,4(a0)
80001f28:	0047a783          	lw	a5,4(a5) # 80000004 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80000005>
80001f2c:	000780e7          	jalr	a5
		uart_poll_out(uart_console_dev, '\r');
	}
	uart_poll_out(uart_console_dev, c);
80001f30:	00042503          	lw	a0,0(s0)
80001f34:	0ff4f593          	andi	a1,s1,255
80001f38:	00452783          	lw	a5,4(a0)
80001f3c:	0047a783          	lw	a5,4(a5)
80001f40:	000780e7          	jalr	a5

	return c;
}
80001f44:	00c12083          	lw	ra,12(sp)
80001f48:	00812403          	lw	s0,8(sp)
80001f4c:	00048513          	mv	a0,s1
80001f50:	00412483          	lw	s1,4(sp)
80001f54:	01010113          	addi	sp,sp,16
80001f58:	00008067          	ret

80001f5c <uart_console_hook_install>:
 *
 * @return N/A
 */

void uart_console_hook_install(void)
{
80001f5c:	ff010113          	addi	sp,sp,-16
80001f60:	00812423          	sw	s0,8(sp)
	__stdout_hook_install(console_out);
80001f64:	80002437          	lui	s0,0x80002
80001f68:	ef840513          	addi	a0,s0,-264 # 80001ef8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80001ef9>
{
80001f6c:	00112623          	sw	ra,12(sp)
	__stdout_hook_install(console_out);
80001f70:	5b4000ef          	jal	ra,80002524 <__stdout_hook_install>
	__printk_hook_install(console_out);
80001f74:	ef840513          	addi	a0,s0,-264
}
80001f78:	00812403          	lw	s0,8(sp)
80001f7c:	00c12083          	lw	ra,12(sp)
80001f80:	01010113          	addi	sp,sp,16
	__printk_hook_install(console_out);
80001f84:	a55ff06f          	j	800019d8 <__printk_hook_install>

80001f88 <uart_console_init>:

#ifdef __cplusplus
extern "C" {
#endif

K_SYSCALL_DECLARE1(K_SYSCALL_DEVICE_GET_BINDING, device_get_binding, struct device *, const char *, name)
80001f88:	80006537          	lui	a0,0x80006
 * @brief Initialize one UART as the console/debug port
 *
 * @return 0 if successful, otherwise failed.
 */
static int uart_console_init(struct device *arg)
{
80001f8c:	ff010113          	addi	sp,sp,-16
80001f90:	2d050513          	addi	a0,a0,720 # 800062d0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800062d1>
80001f94:	00112623          	sw	ra,12(sp)
80001f98:	165000ef          	jal	ra,800028fc <z_impl_device_get_binding>

	ARG_UNUSED(arg);

	uart_console_dev = device_get_binding(CONFIG_UART_CONSOLE_ON_DEV_NAME);
80001f9c:	800077b7          	lui	a5,0x80007
80001fa0:	96a7a423          	sw	a0,-1688(a5) # 80006968 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006969>
		}
	}
	k_busy_wait(1000000);
#endif

	uart_console_hook_install();
80001fa4:	fb9ff0ef          	jal	ra,80001f5c <uart_console_hook_install>

	return 0;
}
80001fa8:	00c12083          	lw	ra,12(sp)
80001fac:	00000513          	li	a0,0
80001fb0:	01010113          	addi	sp,sp,16
80001fb4:	00008067          	ret

80001fb8 <mtime>:
	volatile u32_t *r = (u32_t *)RISCV_MTIME_BASE;
	u32_t lo, hi;

	/* Likewise, must guard against rollover when reading */
	do {
		hi = r[1];
80001fb8:	f01007b7          	lui	a5,0xf0100
80001fbc:	f447a703          	lw	a4,-188(a5) # f00fff44 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0xf00fff45>
		lo = r[0];
80001fc0:	f407a503          	lw	a0,-192(a5)
	} while (r[1] != hi);
80001fc4:	f447a583          	lw	a1,-188(a5)
80001fc8:	fee59ae3          	bne	a1,a4,80001fbc <mtime+0x4>

	return (((u64_t)hi) << 32) | lo;
}
80001fcc:	00008067          	ret

80001fd0 <timer_isr>:

static void timer_isr(void *arg)
{
80001fd0:	fe010113          	addi	sp,sp,-32
80001fd4:	00812c23          	sw	s0,24(sp)
80001fd8:	00112e23          	sw	ra,28(sp)
80001fdc:	00912a23          	sw	s1,20(sp)
80001fe0:	01212823          	sw	s2,16(sp)
80001fe4:	01312623          	sw	s3,12(sp)
80001fe8:	01412423          	sw	s4,8(sp)
80001fec:	01512223          	sw	s5,4(sp)
80001ff0:	00800413          	li	s0,8
80001ff4:	30043473          	csrrc	s0,mstatus,s0
	 * actually a wrapper for a global spinlock!
	 */
	k.key = z_arch_irq_lock();

#ifdef SPIN_VALIDATE
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80001ff8:	80007937          	lui	s2,0x80007
80001ffc:	96c90513          	addi	a0,s2,-1684 # 8000696c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000696d>
	key = (mstatus & SOC_MSTATUS_IEN);
80002000:	00847413          	andi	s0,s0,8
80002004:	790020ef          	jal	ra,80004794 <z_spin_lock_valid>
80002008:	02051e63          	bnez	a0,80002044 <timer_isr+0x74>
8000200c:	800064b7          	lui	s1,0x80006
80002010:	800065b7          	lui	a1,0x80006
80002014:	80006537          	lui	a0,0x80006
80002018:	2fc58593          	addi	a1,a1,764 # 800062fc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800062fd>
8000201c:	04e00693          	li	a3,78
80002020:	2e448613          	addi	a2,s1,740 # 800062e4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800062e5>
80002024:	21850513          	addi	a0,a0,536 # 80006218 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006219>
80002028:	e2dff0ef          	jal	ra,80001e54 <printk>
8000202c:	80006537          	lui	a0,0x80006
80002030:	31450513          	addi	a0,a0,788 # 80006314 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006315>
80002034:	e21ff0ef          	jal	ra,80001e54 <printk>
80002038:	04e00593          	li	a1,78
8000203c:	2e448513          	addi	a0,s1,740
80002040:	e51ff0ef          	jal	ra,80001e90 <assert_post_action>
	while (!atomic_cas(&l->locked, 0, 1)) {
	}
#endif

#ifdef SPIN_VALIDATE
	z_spin_lock_set_owner(l);
80002044:	96c90513          	addi	a0,s2,-1684
	ARG_UNUSED(arg);

	k_spinlock_key_t key = k_spin_lock(&lock);
	u64_t now = mtime();
	u32_t dticks = (u32_t)((now - last_count) / CYC_PER_TICK);
80002048:	800074b7          	lui	s1,0x80007
8000204c:	7a0020ef          	jal	ra,800047ec <z_spin_lock_set_owner>
80002050:	94848493          	addi	s1,s1,-1720 # 80006948 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006949>
	u64_t now = mtime();
80002054:	f65ff0ef          	jal	ra,80001fb8 <mtime>
	u32_t dticks = (u32_t)((now - last_count) / CYC_PER_TICK);
80002058:	0004a983          	lw	s3,0(s1)
8000205c:	0044aa83          	lw	s5,4(s1)
	u64_t now = mtime();
80002060:	00050713          	mv	a4,a0
	u32_t dticks = (u32_t)((now - last_count) / CYC_PER_TICK);
80002064:	41350533          	sub	a0,a0,s3
80002068:	00a73733          	sltu	a4,a4,a0
8000206c:	415585b3          	sub	a1,a1,s5
80002070:	0001d637          	lui	a2,0x1d
80002074:	4c060613          	addi	a2,a2,1216 # 1d4c0 <CONFIG_ISR_STACK_SIZE+0x1ccc0>
80002078:	00000693          	li	a3,0
8000207c:	40e585b3          	sub	a1,a1,a4
80002080:	a40fe0ef          	jal	ra,800002c0 <__udivdi3>

	last_count += dticks * CYC_PER_TICK;
80002084:	0001d7b7          	lui	a5,0x1d
80002088:	4c078793          	addi	a5,a5,1216 # 1d4c0 <CONFIG_ISR_STACK_SIZE+0x1ccc0>
8000208c:	02a787b3          	mul	a5,a5,a0
	u32_t dticks = (u32_t)((now - last_count) / CYC_PER_TICK);
80002090:	00050a13          	mv	s4,a0
static ALWAYS_INLINE void k_spin_unlock(struct k_spinlock *l,
					k_spinlock_key_t key)
{
	ARG_UNUSED(l);
#ifdef SPIN_VALIDATE
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80002094:	96c90513          	addi	a0,s2,-1684
	last_count += dticks * CYC_PER_TICK;
80002098:	013789b3          	add	s3,a5,s3
8000209c:	00f9b7b3          	sltu	a5,s3,a5
800020a0:	015787b3          	add	a5,a5,s5
800020a4:	0134a023          	sw	s3,0(s1)
800020a8:	00f4a223          	sw	a5,4(s1)
800020ac:	710020ef          	jal	ra,800047bc <z_spin_unlock_valid>
800020b0:	02051e63          	bnez	a0,800020ec <timer_isr+0x11c>
800020b4:	800064b7          	lui	s1,0x80006
800020b8:	800065b7          	lui	a1,0x80006
800020bc:	80006537          	lui	a0,0x80006
800020c0:	32c58593          	addi	a1,a1,812 # 8000632c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000632d>
800020c4:	06100693          	li	a3,97
800020c8:	2e448613          	addi	a2,s1,740 # 800062e4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800062e5>
800020cc:	21850513          	addi	a0,a0,536 # 80006218 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006219>
800020d0:	d85ff0ef          	jal	ra,80001e54 <printk>
800020d4:	80006537          	lui	a0,0x80006
800020d8:	34450513          	addi	a0,a0,836 # 80006344 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006345>
800020dc:	d79ff0ef          	jal	ra,80001e54 <printk>
800020e0:	06100593          	li	a1,97
800020e4:	2e448513          	addi	a0,s1,740
800020e8:	da9ff0ef          	jal	ra,80001e90 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
800020ec:	30042473          	csrrs	s0,mstatus,s0
		set_mtimecmp(next);
	}

	k_spin_unlock(&lock, key);
	z_clock_announce(IS_ENABLED(CONFIG_TICKLESS_KERNEL) ? dticks : 1);
}
800020f0:	01812403          	lw	s0,24(sp)
800020f4:	01c12083          	lw	ra,28(sp)
800020f8:	01412483          	lw	s1,20(sp)
800020fc:	01012903          	lw	s2,16(sp)
80002100:	00c12983          	lw	s3,12(sp)
80002104:	00412a83          	lw	s5,4(sp)
	z_clock_announce(IS_ENABLED(CONFIG_TICKLESS_KERNEL) ? dticks : 1);
80002108:	000a0513          	mv	a0,s4
}
8000210c:	00812a03          	lw	s4,8(sp)
80002110:	02010113          	addi	sp,sp,32
	z_clock_announce(IS_ENABLED(CONFIG_TICKLESS_KERNEL) ? dticks : 1);
80002114:	0ac0306f          	j	800051c0 <z_clock_announce>

80002118 <z_clock_driver_init>:

int z_clock_driver_init(struct device *device)
{
80002118:	ff010113          	addi	sp,sp,-16
8000211c:	00112623          	sw	ra,12(sp)
	IRQ_CONNECT(RISCV_MACHINE_TIMER_IRQ, 0, timer_isr, NULL, 0);
	set_mtimecmp(mtime() + CYC_PER_TICK);
80002120:	e99ff0ef          	jal	ra,80001fb8 <mtime>
80002124:	0001d7b7          	lui	a5,0x1d
80002128:	4c078793          	addi	a5,a5,1216 # 1d4c0 <CONFIG_ISR_STACK_SIZE+0x1ccc0>
	r[1] = 0xffffffff;
8000212c:	f0100737          	lui	a4,0xf0100
	set_mtimecmp(mtime() + CYC_PER_TICK);
80002130:	00f507b3          	add	a5,a0,a5
	r[1] = 0xffffffff;
80002134:	fff00693          	li	a3,-1
80002138:	f4d72623          	sw	a3,-180(a4) # f00fff4c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0xf00fff4d>
	set_mtimecmp(mtime() + CYC_PER_TICK);
8000213c:	00a7b533          	sltu	a0,a5,a0
80002140:	00b50533          	add	a0,a0,a1
	r[0] = (u32_t)time;
80002144:	f4f72423          	sw	a5,-184(a4)
	r[1] = (u32_t)(time >> 32);
80002148:	f4a72623          	sw	a0,-180(a4)
	irq_enable(RISCV_MACHINE_TIMER_IRQ);
8000214c:	00700513          	li	a0,7
80002150:	d85ff0ef          	jal	ra,80001ed4 <z_arch_irq_enable>
	return 0;
}
80002154:	00c12083          	lw	ra,12(sp)
80002158:	00000513          	li	a0,0
8000215c:	01010113          	addi	sp,sp,16
80002160:	00008067          	ret

80002164 <z_clock_set_timeout>:
	 * logic below to reset the comparator, we'll always bump it
	 * forward to the "next tick" due to MIN_DELAY handling and
	 * the interrupt will never fire!  Just rely on the fact that
	 * the OS gave us the proper timeout already.
	 */
	if (idle) {
80002164:	16059c63          	bnez	a1,800022dc <z_clock_set_timeout+0x178>
{
80002168:	fe010113          	addi	sp,sp,-32
8000216c:	00112e23          	sw	ra,28(sp)
80002170:	00812c23          	sw	s0,24(sp)
80002174:	00912a23          	sw	s1,20(sp)
80002178:	01212823          	sw	s2,16(sp)
8000217c:	01312623          	sw	s3,12(sp)
		return;
	}

	ticks = ticks == K_FOREVER ? MAX_TICKS : ticks;
80002180:	fff00793          	li	a5,-1
80002184:	00f51663          	bne	a0,a5,80002190 <z_clock_set_timeout+0x2c>
80002188:	00009537          	lui	a0,0x9
8000218c:	bce50513          	addi	a0,a0,-1074 # 8bce <CONFIG_ISR_STACK_SIZE+0x83ce>
	ticks = MAX(MIN(ticks - 1, (s32_t)MAX_TICKS), 0);
80002190:	000097b7          	lui	a5,0x9
80002194:	fff50413          	addi	s0,a0,-1
80002198:	bce78793          	addi	a5,a5,-1074 # 8bce <CONFIG_ISR_STACK_SIZE+0x83ce>
8000219c:	1287da63          	bge	a5,s0,800022d0 <z_clock_set_timeout+0x16c>
800021a0:	00078413          	mv	s0,a5
	__asm__ volatile ("csrrc %0, mstatus, %1"
800021a4:	00800493          	li	s1,8
800021a8:	3004b4f3          	csrrc	s1,mstatus,s1
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
800021ac:	80007937          	lui	s2,0x80007
800021b0:	96c90513          	addi	a0,s2,-1684 # 8000696c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000696d>
	key = (mstatus & SOC_MSTATUS_IEN);
800021b4:	0084f493          	andi	s1,s1,8
800021b8:	5dc020ef          	jal	ra,80004794 <z_spin_lock_valid>
800021bc:	02051e63          	bnez	a0,800021f8 <z_clock_set_timeout+0x94>
800021c0:	800069b7          	lui	s3,0x80006
800021c4:	800065b7          	lui	a1,0x80006
800021c8:	80006537          	lui	a0,0x80006
800021cc:	2fc58593          	addi	a1,a1,764 # 800062fc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800062fd>
800021d0:	04e00693          	li	a3,78
800021d4:	2e498613          	addi	a2,s3,740 # 800062e4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800062e5>
800021d8:	21850513          	addi	a0,a0,536 # 80006218 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006219>
800021dc:	c79ff0ef          	jal	ra,80001e54 <printk>
800021e0:	80006537          	lui	a0,0x80006
800021e4:	31450513          	addi	a0,a0,788 # 80006314 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006315>
800021e8:	c6dff0ef          	jal	ra,80001e54 <printk>
800021ec:	04e00593          	li	a1,78
800021f0:	2e498513          	addi	a0,s3,740
800021f4:	c9dff0ef          	jal	ra,80001e90 <assert_post_action>
	z_spin_lock_set_owner(l);
800021f8:	96c90513          	addi	a0,s2,-1684
800021fc:	5f0020ef          	jal	ra,800047ec <z_spin_lock_set_owner>

	k_spinlock_key_t key = k_spin_lock(&lock);
	u64_t now = mtime();
80002200:	db9ff0ef          	jal	ra,80001fb8 <mtime>
	u32_t cyc = ticks * CYC_PER_TICK;
80002204:	0001d6b7          	lui	a3,0x1d

	/* Round up to next tick boundary.  Note use of 32 bit math,
	 * max_ticks is calibrated to permit this.
	 */
	cyc += (u32_t)(now - last_count) + (CYC_PER_TICK - 1);
80002208:	800077b7          	lui	a5,0x80007
	u32_t cyc = ticks * CYC_PER_TICK;
8000220c:	4c068613          	addi	a2,a3,1216 # 1d4c0 <CONFIG_ISR_STACK_SIZE+0x1ccc0>
	cyc += (u32_t)(now - last_count) + (CYC_PER_TICK - 1);
80002210:	94878793          	addi	a5,a5,-1720 # 80006948 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006949>
80002214:	0007a703          	lw	a4,0(a5)
80002218:	0047a583          	lw	a1,4(a5)
	u32_t cyc = ticks * CYC_PER_TICK;
8000221c:	02c407b3          	mul	a5,s0,a2
80002220:	4bf68693          	addi	a3,a3,1215
80002224:	40e68433          	sub	s0,a3,a4
	cyc = (cyc / CYC_PER_TICK) * CYC_PER_TICK;

	if ((s32_t)(cyc + last_count - now) < MIN_DELAY) {
80002228:	3e700693          	li	a3,999
8000222c:	008787b3          	add	a5,a5,s0
	cyc += (u32_t)(now - last_count) + (CYC_PER_TICK - 1);
80002230:	00f507b3          	add	a5,a0,a5
	cyc = (cyc / CYC_PER_TICK) * CYC_PER_TICK;
80002234:	02c7d7b3          	divu	a5,a5,a2
	if ((s32_t)(cyc + last_count - now) < MIN_DELAY) {
80002238:	40a70533          	sub	a0,a4,a0
	cyc = (cyc / CYC_PER_TICK) * CYC_PER_TICK;
8000223c:	02c787b3          	mul	a5,a5,a2
	if ((s32_t)(cyc + last_count - now) < MIN_DELAY) {
80002240:	00f50533          	add	a0,a0,a5
80002244:	00a6c463          	blt	a3,a0,8000224c <z_clock_set_timeout+0xe8>
		cyc += CYC_PER_TICK;
80002248:	00c787b3          	add	a5,a5,a2
	r[1] = 0xffffffff;
8000224c:	f01006b7          	lui	a3,0xf0100
	}

	set_mtimecmp(cyc + last_count);
80002250:	00e78733          	add	a4,a5,a4
	r[1] = 0xffffffff;
80002254:	fff00613          	li	a2,-1
80002258:	f4c6a623          	sw	a2,-180(a3) # f00fff4c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0xf00fff4d>
	set_mtimecmp(cyc + last_count);
8000225c:	00f737b3          	sltu	a5,a4,a5
80002260:	00b787b3          	add	a5,a5,a1
	r[0] = (u32_t)time;
80002264:	f4e6a423          	sw	a4,-184(a3)
	r[1] = (u32_t)(time >> 32);
80002268:	f4f6a623          	sw	a5,-180(a3)
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
8000226c:	96c90513          	addi	a0,s2,-1684
80002270:	54c020ef          	jal	ra,800047bc <z_spin_unlock_valid>
80002274:	02051e63          	bnez	a0,800022b0 <z_clock_set_timeout+0x14c>
80002278:	80006437          	lui	s0,0x80006
8000227c:	800065b7          	lui	a1,0x80006
80002280:	80006537          	lui	a0,0x80006
80002284:	32c58593          	addi	a1,a1,812 # 8000632c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000632d>
80002288:	06100693          	li	a3,97
8000228c:	2e440613          	addi	a2,s0,740 # 800062e4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800062e5>
80002290:	21850513          	addi	a0,a0,536 # 80006218 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006219>
80002294:	bc1ff0ef          	jal	ra,80001e54 <printk>
80002298:	80006537          	lui	a0,0x80006
8000229c:	34450513          	addi	a0,a0,836 # 80006344 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006345>
800022a0:	bb5ff0ef          	jal	ra,80001e54 <printk>
800022a4:	06100593          	li	a1,97
800022a8:	2e440513          	addi	a0,s0,740
800022ac:	be5ff0ef          	jal	ra,80001e90 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
800022b0:	3004a4f3          	csrrs	s1,mstatus,s1
	k_spin_unlock(&lock, key);
#endif
}
800022b4:	01c12083          	lw	ra,28(sp)
800022b8:	01812403          	lw	s0,24(sp)
800022bc:	01412483          	lw	s1,20(sp)
800022c0:	01012903          	lw	s2,16(sp)
800022c4:	00c12983          	lw	s3,12(sp)
800022c8:	02010113          	addi	sp,sp,32
800022cc:	00008067          	ret
800022d0:	ec045ae3          	bgez	s0,800021a4 <z_clock_set_timeout+0x40>
800022d4:	00000413          	li	s0,0
800022d8:	ecdff06f          	j	800021a4 <z_clock_set_timeout+0x40>
800022dc:	00008067          	ret

800022e0 <z_clock_elapsed>:

u32_t z_clock_elapsed(void)
{
800022e0:	ff010113          	addi	sp,sp,-16
800022e4:	00812423          	sw	s0,8(sp)
800022e8:	00112623          	sw	ra,12(sp)
800022ec:	00912223          	sw	s1,4(sp)
800022f0:	01212023          	sw	s2,0(sp)
	__asm__ volatile ("csrrc %0, mstatus, %1"
800022f4:	00800413          	li	s0,8
800022f8:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
800022fc:	80007937          	lui	s2,0x80007
80002300:	96c90513          	addi	a0,s2,-1684 # 8000696c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000696d>
	key = (mstatus & SOC_MSTATUS_IEN);
80002304:	00847413          	andi	s0,s0,8
80002308:	48c020ef          	jal	ra,80004794 <z_spin_lock_valid>
8000230c:	02051e63          	bnez	a0,80002348 <z_clock_elapsed+0x68>
80002310:	800064b7          	lui	s1,0x80006
80002314:	800065b7          	lui	a1,0x80006
80002318:	80006537          	lui	a0,0x80006
8000231c:	2fc58593          	addi	a1,a1,764 # 800062fc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800062fd>
80002320:	04e00693          	li	a3,78
80002324:	2e448613          	addi	a2,s1,740 # 800062e4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800062e5>
80002328:	21850513          	addi	a0,a0,536 # 80006218 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006219>
8000232c:	b29ff0ef          	jal	ra,80001e54 <printk>
80002330:	80006537          	lui	a0,0x80006
80002334:	31450513          	addi	a0,a0,788 # 80006314 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006315>
80002338:	b1dff0ef          	jal	ra,80001e54 <printk>
8000233c:	04e00593          	li	a1,78
80002340:	2e448513          	addi	a0,s1,740
80002344:	b4dff0ef          	jal	ra,80001e90 <assert_post_action>
	z_spin_lock_set_owner(l);
80002348:	96c90513          	addi	a0,s2,-1684
8000234c:	4a0020ef          	jal	ra,800047ec <z_spin_lock_set_owner>
	if (!IS_ENABLED(CONFIG_TICKLESS_KERNEL)) {
		return 0;
	}

	k_spinlock_key_t key = k_spin_lock(&lock);
	u32_t ret = ((u32_t)mtime() - (u32_t)last_count) / CYC_PER_TICK;
80002350:	c69ff0ef          	jal	ra,80001fb8 <mtime>
80002354:	800077b7          	lui	a5,0x80007
80002358:	9487a483          	lw	s1,-1720(a5) # 80006948 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006949>
8000235c:	409504b3          	sub	s1,a0,s1
80002360:	0001d537          	lui	a0,0x1d
80002364:	4c050513          	addi	a0,a0,1216 # 1d4c0 <CONFIG_ISR_STACK_SIZE+0x1ccc0>
80002368:	02a4d4b3          	divu	s1,s1,a0
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
8000236c:	96c90513          	addi	a0,s2,-1684
80002370:	44c020ef          	jal	ra,800047bc <z_spin_unlock_valid>
80002374:	02051e63          	bnez	a0,800023b0 <z_clock_elapsed+0xd0>
80002378:	80006937          	lui	s2,0x80006
8000237c:	800065b7          	lui	a1,0x80006
80002380:	80006537          	lui	a0,0x80006
80002384:	32c58593          	addi	a1,a1,812 # 8000632c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000632d>
80002388:	06100693          	li	a3,97
8000238c:	2e490613          	addi	a2,s2,740 # 800062e4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800062e5>
80002390:	21850513          	addi	a0,a0,536 # 80006218 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006219>
80002394:	ac1ff0ef          	jal	ra,80001e54 <printk>
80002398:	80006537          	lui	a0,0x80006
8000239c:	34450513          	addi	a0,a0,836 # 80006344 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006345>
800023a0:	ab5ff0ef          	jal	ra,80001e54 <printk>
800023a4:	06100593          	li	a1,97
800023a8:	2e490513          	addi	a0,s2,740
800023ac:	ae5ff0ef          	jal	ra,80001e90 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
800023b0:	30042473          	csrrs	s0,mstatus,s0

	k_spin_unlock(&lock, key);
	return ret;
}
800023b4:	00c12083          	lw	ra,12(sp)
800023b8:	00812403          	lw	s0,8(sp)
800023bc:	00048513          	mv	a0,s1
800023c0:	00012903          	lw	s2,0(sp)
800023c4:	00412483          	lw	s1,4(sp)
800023c8:	01010113          	addi	sp,sp,16
800023cc:	00008067          	ret

800023d0 <strcmp>:
 * @return negative # if <s1> < <s2>, 0 if <s1> == <s2>, else positive #
 */

int strcmp(const char *s1, const char *s2)
{
	while ((*s1 == *s2) && (*s1 != '\0')) {
800023d0:	00054783          	lbu	a5,0(a0)
800023d4:	0005c703          	lbu	a4,0(a1)
800023d8:	00e79463          	bne	a5,a4,800023e0 <strcmp+0x10>
800023dc:	00079663          	bnez	a5,800023e8 <strcmp+0x18>
		s1++;
		s2++;
	}

	return *s1 - *s2;
}
800023e0:	40e78533          	sub	a0,a5,a4
800023e4:	00008067          	ret
		s1++;
800023e8:	00150513          	addi	a0,a0,1
		s2++;
800023ec:	00158593          	addi	a1,a1,1
800023f0:	fe1ff06f          	j	800023d0 <strcmp>

800023f4 <memcpy>:
	/* attempt word-sized copying only if buffers have identical alignment */

	unsigned char *d_byte = (unsigned char *)d;
	const unsigned char *s_byte = (const unsigned char *)s;

	if ((((unsigned int)d ^ (unsigned int)s_byte) & 0x3) == 0U) {
800023f4:	00b547b3          	xor	a5,a0,a1
800023f8:	0037f793          	andi	a5,a5,3
800023fc:	06078063          	beqz	a5,8000245c <memcpy+0x68>
	unsigned char *d_byte = (unsigned char *)d;
80002400:	00050793          	mv	a5,a0
80002404:	00000713          	li	a4,0
		s_byte = (unsigned char *)s_word;
	}

	/* do byte-sized copying until finished */

	while (n > 0) {
80002408:	06e61a63          	bne	a2,a4,8000247c <memcpy+0x88>
		*(d_byte++) = *(s_byte++);
		n--;
	}

	return d;
}
8000240c:	00008067          	ret
			if (n == 0) {
80002410:	fe060ee3          	beqz	a2,8000240c <memcpy+0x18>
			*(d_byte++) = *(s_byte++);
80002414:	00158593          	addi	a1,a1,1
80002418:	fff5c703          	lbu	a4,-1(a1)
8000241c:	00178793          	addi	a5,a5,1
			n--;
80002420:	fff60613          	addi	a2,a2,-1
			*(d_byte++) = *(s_byte++);
80002424:	fee78fa3          	sb	a4,-1(a5)
		while (((unsigned int)d_byte) & 0x3) {
80002428:	0037f713          	andi	a4,a5,3
8000242c:	fe0712e3          	bnez	a4,80002410 <memcpy+0x1c>
		while (n >= sizeof(unsigned int)) {
80002430:	00300693          	li	a3,3
80002434:	40e60833          	sub	a6,a2,a4
80002438:	0306e663          	bltu	a3,a6,80002464 <memcpy+0x70>
8000243c:	00265713          	srli	a4,a2,0x2
80002440:	ffc00693          	li	a3,-4
80002444:	02d706b3          	mul	a3,a4,a3
80002448:	00271713          	slli	a4,a4,0x2
8000244c:	00e787b3          	add	a5,a5,a4
80002450:	00e585b3          	add	a1,a1,a4
80002454:	00d60633          	add	a2,a2,a3
80002458:	fadff06f          	j	80002404 <memcpy+0x10>
	unsigned char *d_byte = (unsigned char *)d;
8000245c:	00050793          	mv	a5,a0
80002460:	fc9ff06f          	j	80002428 <memcpy+0x34>
			*(d_word++) = *(s_word++);
80002464:	00e588b3          	add	a7,a1,a4
80002468:	0008a883          	lw	a7,0(a7)
8000246c:	00e78833          	add	a6,a5,a4
80002470:	00470713          	addi	a4,a4,4
80002474:	01182023          	sw	a7,0(a6)
			n -= sizeof(unsigned int);
80002478:	fbdff06f          	j	80002434 <memcpy+0x40>
		*(d_byte++) = *(s_byte++);
8000247c:	00e58833          	add	a6,a1,a4
80002480:	00084803          	lbu	a6,0(a6)
80002484:	00e786b3          	add	a3,a5,a4
80002488:	00170713          	addi	a4,a4,1
8000248c:	01068023          	sb	a6,0(a3)
		n--;
80002490:	f79ff06f          	j	80002408 <memcpy+0x14>

80002494 <memset>:
void *memset(void *buf, int c, size_t n)
{
	/* do byte-sized initialization until word-aligned or finished */

	unsigned char *d_byte = (unsigned char *)buf;
	unsigned char c_byte = (unsigned char)c;
80002494:	0ff5f693          	andi	a3,a1,255
	unsigned char *d_byte = (unsigned char *)buf;
80002498:	00050793          	mv	a5,a0

	while (((unsigned int)d_byte) & 0x3) {
8000249c:	0037f713          	andi	a4,a5,3
800024a0:	04071863          	bnez	a4,800024f0 <memset+0x5c>
	};

	/* do word-sized initialization as long as possible */

	unsigned int *d_word = (unsigned int *)d_byte;
	unsigned int c_word = (unsigned int)(unsigned char)c;
800024a4:	0ff5f593          	andi	a1,a1,255

	c_word |= c_word << 8;
800024a8:	00859713          	slli	a4,a1,0x8
800024ac:	00b765b3          	or	a1,a4,a1
	c_word |= c_word << 16;
800024b0:	01059713          	slli	a4,a1,0x10
800024b4:	00b765b3          	or	a1,a4,a1

	while (n >= sizeof(unsigned int)) {
800024b8:	00c78333          	add	t1,a5,a2
800024bc:	00078713          	mv	a4,a5
800024c0:	00300813          	li	a6,3
800024c4:	40e308b3          	sub	a7,t1,a4
800024c8:	03186e63          	bltu	a6,a7,80002504 <memset+0x70>
800024cc:	00265713          	srli	a4,a2,0x2
800024d0:	00271593          	slli	a1,a4,0x2
800024d4:	00b787b3          	add	a5,a5,a1
800024d8:	ffc00593          	li	a1,-4
800024dc:	02b70733          	mul	a4,a4,a1
800024e0:	00c70733          	add	a4,a4,a2
800024e4:	00e78733          	add	a4,a5,a4

	/* do byte-sized initialization until finished */

	d_byte = (unsigned char *)d_word;

	while (n > 0) {
800024e8:	02e79463          	bne	a5,a4,80002510 <memset+0x7c>
		*(d_byte++) = c_byte;
		n--;
	}

	return buf;
}
800024ec:	00008067          	ret
		if (n == 0) {
800024f0:	fe060ee3          	beqz	a2,800024ec <memset+0x58>
		*(d_byte++) = c_byte;
800024f4:	00178793          	addi	a5,a5,1
800024f8:	fed78fa3          	sb	a3,-1(a5)
		n--;
800024fc:	fff60613          	addi	a2,a2,-1
80002500:	f9dff06f          	j	8000249c <memset+0x8>
		*(d_word++) = c_word;
80002504:	00470713          	addi	a4,a4,4
80002508:	feb72e23          	sw	a1,-4(a4)
		n -= sizeof(unsigned int);
8000250c:	fb9ff06f          	j	800024c4 <memset+0x30>
		*(d_byte++) = c_byte;
80002510:	00178793          	addi	a5,a5,1
80002514:	fed78fa3          	sb	a3,-1(a5)
		n--;
80002518:	fd1ff06f          	j	800024e8 <memset+0x54>

8000251c <_stdout_hook_default>:
static int _stdout_hook_default(int c)
{
	(void)(c);  /* Prevent warning about unused argument */

	return EOF;
}
8000251c:	fff00513          	li	a0,-1
80002520:	00008067          	ret

80002524 <__stdout_hook_install>:

static int (*_stdout_hook)(int) = _stdout_hook_default;

void __stdout_hook_install(int (*hook)(int))
{
	_stdout_hook = hook;
80002524:	800077b7          	lui	a5,0x80007
80002528:	88a7ac23          	sw	a0,-1896(a5) # 80006898 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006899>
}
8000252c:	00008067          	ret

80002530 <test_cb>:
	k_sem_init(&test_end_signal, 0, 1);
	k_object_access_all_grant(&test_end_signal);
}

static void test_cb(void *a, void *dummy2, void *dummy)
{
80002530:	fe010113          	addi	sp,sp,-32
80002534:	00812c23          	sw	s0,24(sp)
	test->setup();
80002538:	00852783          	lw	a5,8(a0)
	phase = TEST_PHASE_SETUP;
8000253c:	80007437          	lui	s0,0x80007
{
80002540:	00912a23          	sw	s1,20(sp)
	phase = TEST_PHASE_SETUP;
80002544:	89c40413          	addi	s0,s0,-1892 # 8000689c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000689d>
	struct unit_test *test = (struct unit_test *)a;

	ARG_UNUSED(dummy2);
	ARG_UNUSED(dummy);

	test_result = 1;
80002548:	800074b7          	lui	s1,0x80007
{
8000254c:	00112e23          	sw	ra,28(sp)
80002550:	01212823          	sw	s2,16(sp)
80002554:	01312623          	sw	s3,12(sp)
	test_result = 1;
80002558:	97048493          	addi	s1,s1,-1680 # 80006970 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006971>
8000255c:	00100993          	li	s3,1
	phase = TEST_PHASE_SETUP;
80002560:	00042023          	sw	zero,0(s0)
{
80002564:	00050913          	mv	s2,a0
	test_result = 1;
80002568:	0134a023          	sw	s3,0(s1)
	test->setup();
8000256c:	000780e7          	jalr	a5
	test->test();
80002570:	00492783          	lw	a5,4(s2)
	phase = TEST_PHASE_TEST;
80002574:	01342023          	sw	s3,0(s0)
	test->test();
80002578:	000780e7          	jalr	a5
	phase = TEST_PHASE_TEARDOWN;
8000257c:	00200793          	li	a5,2
80002580:	00f42023          	sw	a5,0(s0)
	test->teardown();
80002584:	00c92783          	lw	a5,12(s2)
80002588:	000780e7          	jalr	a5
	phase = TEST_PHASE_FRAMEWORK;
8000258c:	00300793          	li	a5,3
80002590:	00f42023          	sw	a5,0(s0)
	run_test_functions(test);
	test_result = 0;

	k_sem_give(&test_end_signal);
}
80002594:	01812403          	lw	s0,24(sp)
	test_result = 0;
80002598:	0004a023          	sw	zero,0(s1)
}
8000259c:	01c12083          	lw	ra,28(sp)
800025a0:	01412483          	lw	s1,20(sp)
800025a4:	01012903          	lw	s2,16(sp)
800025a8:	00c12983          	lw	s3,12(sp)
K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_SEM_GIVE, k_sem_give, struct k_sem *, sem)
800025ac:	80007537          	lui	a0,0x80007
800025b0:	b4450513          	addi	a0,a0,-1212 # 80006b44 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006b45>
800025b4:	02010113          	addi	sp,sp,32
800025b8:	1f90106f          	j	80003fb0 <z_impl_k_sem_give>

800025bc <ztest_test_fail>:
800025bc:	80007537          	lui	a0,0x80007
{
800025c0:	ff010113          	addi	sp,sp,-16
	test_result = -1;
800025c4:	800077b7          	lui	a5,0x80007
800025c8:	fff00713          	li	a4,-1
800025cc:	b4450513          	addi	a0,a0,-1212 # 80006b44 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006b45>
{
800025d0:	00112623          	sw	ra,12(sp)
	test_result = -1;
800025d4:	96e7a823          	sw	a4,-1680(a5) # 80006970 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006971>
800025d8:	1d9010ef          	jal	ra,80003fb0 <z_impl_k_sem_give>
K_SYSCALL_DECLARE0(K_SYSCALL_K_CURRENT_GET, k_current_get, k_tid_t)
800025dc:	101010ef          	jal	ra,80003edc <z_impl_k_current_get>
}
800025e0:	00c12083          	lw	ra,12(sp)
800025e4:	01010113          	addi	sp,sp,16
K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_THREAD_ABORT, k_thread_abort, k_tid_t, thread)
800025e8:	5140206f          	j	80004afc <z_impl_k_thread_abort>

800025ec <ztest_test_skip>:
K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_SEM_GIVE, k_sem_give, struct k_sem *, sem)
800025ec:	80007537          	lui	a0,0x80007
{
800025f0:	ff010113          	addi	sp,sp,-16
	test_result = -2;
800025f4:	800077b7          	lui	a5,0x80007
800025f8:	ffe00713          	li	a4,-2
800025fc:	b4450513          	addi	a0,a0,-1212 # 80006b44 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006b45>
{
80002600:	00112623          	sw	ra,12(sp)
	test_result = -2;
80002604:	96e7a823          	sw	a4,-1680(a5) # 80006970 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006971>
80002608:	1a9010ef          	jal	ra,80003fb0 <z_impl_k_sem_give>
K_SYSCALL_DECLARE0(K_SYSCALL_K_CURRENT_GET, k_current_get, k_tid_t)
8000260c:	0d1010ef          	jal	ra,80003edc <z_impl_k_current_get>
}
80002610:	00c12083          	lw	ra,12(sp)
80002614:	01010113          	addi	sp,sp,16
K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_THREAD_ABORT, k_thread_abort, k_tid_t, thread)
80002618:	4e40206f          	j	80004afc <z_impl_k_thread_abort>

8000261c <z_ztest_run_test_suite>:
}

#endif /* !KERNEL */

void z_ztest_run_test_suite(const char *name, struct unit_test *suite)
{
8000261c:	fa010113          	addi	sp,sp,-96
80002620:	04912a23          	sw	s1,84(sp)
	int fail = 0;

	if (test_status < 0) {
80002624:	800074b7          	lui	s1,0x80007
80002628:	9744a783          	lw	a5,-1676(s1) # 80006974 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006975>
{
8000262c:	04112e23          	sw	ra,92(sp)
80002630:	04812c23          	sw	s0,88(sp)
80002634:	05212823          	sw	s2,80(sp)
80002638:	05312623          	sw	s3,76(sp)
8000263c:	05412423          	sw	s4,72(sp)
80002640:	05512223          	sw	s5,68(sp)
80002644:	05612023          	sw	s6,64(sp)
80002648:	03712e23          	sw	s7,60(sp)
8000264c:	03812c23          	sw	s8,56(sp)
80002650:	03912a23          	sw	s9,52(sp)
80002654:	03a12823          	sw	s10,48(sp)
80002658:	03b12623          	sw	s11,44(sp)
	if (test_status < 0) {
8000265c:	0807c463          	bltz	a5,800026e4 <z_ztest_run_test_suite+0xc8>
K_SYSCALL_DECLARE3_VOID(K_SYSCALL_K_SEM_INIT, k_sem_init, struct k_sem *, sem, unsigned int, initial_count, unsigned int, limit)
80002660:	80007437          	lui	s0,0x80007
80002664:	00100613          	li	a2,1
80002668:	00050993          	mv	s3,a0
8000266c:	00058c13          	mv	s8,a1
80002670:	b4440513          	addi	a0,s0,-1212 # 80006b44 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006b45>
80002674:	00000593          	li	a1,0
80002678:	071010ef          	jal	ra,80003ee8 <z_impl_k_sem_init>
		return;
	}

	init_testing();

	PRINT("Running test suite %s\n", name);
8000267c:	80006537          	lui	a0,0x80006
80002680:	00098593          	mv	a1,s3
80002684:	3a050513          	addi	a0,a0,928 # 800063a0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800063a1>
80002688:	fccff0ef          	jal	ra,80001e54 <printk>
	PRINT_LINE;
8000268c:	80006937          	lui	s2,0x80006
80002690:	3b890513          	addi	a0,s2,952 # 800063b8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800063b9>
		Z_TC_END_RESULT(ret, test->name);
80002694:	80006ab7          	lui	s5,0x80006
	PRINT_LINE;
80002698:	fbcff0ef          	jal	ra,80001e54 <printk>
8000269c:	97448493          	addi	s1,s1,-1676
	int fail = 0;
800026a0:	00000a13          	li	s4,0
800026a4:	00812e23          	sw	s0,28(sp)
K_SYSCALL_DECLARE10(K_SYSCALL_K_THREAD_CREATE, k_thread_create, k_tid_t, struct k_thread *, new_thread, k_thread_stack_t *, stack, size_t, stack_size, k_thread_entry_t, entry, void *, p1, void *, p2, void *, p3, int, prio, u32_t, options, s32_t, delay)
800026a8:	80007cb7          	lui	s9,0x80007
800026ac:	80007b37          	lui	s6,0x80007
800026b0:	80002d37          	lui	s10,0x80002
	if (test_result == -1) {
800026b4:	80007db7          	lui	s11,0x80007
800026b8:	80006bb7          	lui	s7,0x80006
		Z_TC_END_RESULT(ret, test->name);
800026bc:	358a8a93          	addi	s5,s5,856 # 80006358 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006359>
	while (suite->test) {
800026c0:	004c2783          	lw	a5,4(s8)
800026c4:	04079e63          	bnez	a5,80002720 <z_ztest_run_test_suite+0x104>
		if (fail && FAIL_FAST) {
			break;
		}
	}
	if (fail) {
		TC_PRINT("Test suite %s failed.\n", name);
800026c8:	00098593          	mv	a1,s3
	if (fail) {
800026cc:	100a0663          	beqz	s4,800027d8 <z_ztest_run_test_suite+0x1bc>
		TC_PRINT("Test suite %s failed.\n", name);
800026d0:	80006537          	lui	a0,0x80006
800026d4:	42850513          	addi	a0,a0,1064 # 80006428 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006429>
800026d8:	f7cff0ef          	jal	ra,80001e54 <printk>
	} else {
		TC_PRINT("Test suite %s succeeded\n", name);
	}

	test_status = (test_status || fail) ? 1 : 0;
800026dc:	00100793          	li	a5,1
800026e0:	00f4a023          	sw	a5,0(s1)
}
800026e4:	05c12083          	lw	ra,92(sp)
800026e8:	05812403          	lw	s0,88(sp)
800026ec:	05412483          	lw	s1,84(sp)
800026f0:	05012903          	lw	s2,80(sp)
800026f4:	04c12983          	lw	s3,76(sp)
800026f8:	04812a03          	lw	s4,72(sp)
800026fc:	04412a83          	lw	s5,68(sp)
80002700:	04012b03          	lw	s6,64(sp)
80002704:	03c12b83          	lw	s7,60(sp)
80002708:	03812c03          	lw	s8,56(sp)
8000270c:	03412c83          	lw	s9,52(sp)
80002710:	03012d03          	lw	s10,48(sp)
80002714:	02c12d83          	lw	s11,44(sp)
80002718:	06010113          	addi	sp,sp,96
8000271c:	00008067          	ret
	TC_START(test->name);
80002720:	000c2583          	lw	a1,0(s8)
80002724:	800067b7          	lui	a5,0x80006
80002728:	40078513          	addi	a0,a5,1024 # 80006400 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006401>
8000272c:	f28ff0ef          	jal	ra,80001e54 <printk>
80002730:	00012223          	sw	zero,4(sp)
			test->thread_options | K_INHERIT_PERMS,	0);
80002734:	010c2783          	lw	a5,16(s8)
80002738:	000c0713          	mv	a4,s8
8000273c:	40000613          	li	a2,1024
80002740:	0087e793          	ori	a5,a5,8
80002744:	fff00893          	li	a7,-1
80002748:	00000813          	li	a6,0
8000274c:	530d0693          	addi	a3,s10,1328 # 80002530 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80002531>
80002750:	00f12023          	sw	a5,0(sp)
80002754:	ed0c8593          	addi	a1,s9,-304 # 80006ed0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006ed1>
80002758:	00000793          	li	a5,0
8000275c:	b54b0513          	addi	a0,s6,-1196 # 80006b54 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006b55>
80002760:	1f8020ef          	jal	ra,80004958 <z_impl_k_thread_create>
K_SYSCALL_DECLARE2(K_SYSCALL_K_SEM_TAKE, k_sem_take, int, struct k_sem *, sem, s32_t, timeout)
80002764:	01c12783          	lw	a5,28(sp)
80002768:	fff00593          	li	a1,-1
8000276c:	b4478513          	addi	a0,a5,-1212
80002770:	125010ef          	jal	ra,80004094 <z_impl_k_sem_take>
	if (test_result == -1) {
80002774:	970d8793          	addi	a5,s11,-1680 # 80006970 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006971>
K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_THREAD_ABORT, k_thread_abort, k_tid_t, thread)
80002778:	b54b0513          	addi	a0,s6,-1196
8000277c:	0007a403          	lw	s0,0(a5)
80002780:	37c020ef          	jal	ra,80004afc <z_impl_k_thread_abort>
	if (test_result == -2) {
80002784:	800077b7          	lui	a5,0x80007
80002788:	97078793          	addi	a5,a5,-1680 # 80006970 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006971>
8000278c:	0007a703          	lw	a4,0(a5)
	if (test_result == -1) {
80002790:	00140413          	addi	s0,s0,1
	if (test_result == -2) {
80002794:	ffe00793          	li	a5,-2
	if (test_result == -1) {
80002798:	00143413          	seqz	s0,s0
	if (test_result == -2) {
8000279c:	000c2603          	lw	a2,0(s8)
800027a0:	02f71463          	bne	a4,a5,800027c8 <z_ztest_run_test_suite+0x1ac>
		Z_TC_END_RESULT(TC_SKIP, test->name);
800027a4:	800065b7          	lui	a1,0x80006
800027a8:	41458593          	addi	a1,a1,1044 # 80006414 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006415>
		Z_TC_END_RESULT(ret, test->name);
800027ac:	41cb8513          	addi	a0,s7,1052 # 8000641c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000641d>
800027b0:	ea4ff0ef          	jal	ra,80001e54 <printk>
800027b4:	3b890513          	addi	a0,s2,952
800027b8:	e9cff0ef          	jal	ra,80001e54 <printk>
		fail += run_test(suite);
800027bc:	008a0a33          	add	s4,s4,s0
		suite++;
800027c0:	014c0c13          	addi	s8,s8,20
		if (fail && FAIL_FAST) {
800027c4:	efdff06f          	j	800026c0 <z_ztest_run_test_suite+0xa4>
		Z_TC_END_RESULT(ret, test->name);
800027c8:	00241793          	slli	a5,s0,0x2
800027cc:	00fa87b3          	add	a5,s5,a5
800027d0:	0007a583          	lw	a1,0(a5)
800027d4:	fd9ff06f          	j	800027ac <z_ztest_run_test_suite+0x190>
		TC_PRINT("Test suite %s succeeded\n", name);
800027d8:	80006537          	lui	a0,0x80006
800027dc:	44050513          	addi	a0,a0,1088 # 80006440 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006441>
800027e0:	e74ff0ef          	jal	ra,80001e54 <printk>
	test_status = (test_status || fail) ? 1 : 0;
800027e4:	0004a783          	lw	a5,0(s1)
800027e8:	00f037b3          	snez	a5,a5
800027ec:	ef5ff06f          	j	800026e0 <z_ztest_run_test_suite+0xc4>

800027f0 <end_report>:

void end_report(void)
{
	if (test_status) {
800027f0:	800077b7          	lui	a5,0x80007
800027f4:	9747a783          	lw	a5,-1676(a5) # 80006974 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006975>
{
800027f8:	ff010113          	addi	sp,sp,-16
800027fc:	00812423          	sw	s0,8(sp)
80002800:	80006537          	lui	a0,0x80006
80002804:	00112623          	sw	ra,12(sp)
80002808:	80006437          	lui	s0,0x80006
		TC_END_REPORT(TC_FAIL);
8000280c:	3b850513          	addi	a0,a0,952 # 800063b8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800063b9>
	if (test_status) {
80002810:	02078263          	beqz	a5,80002834 <end_report+0x44>
		TC_END_REPORT(TC_FAIL);
80002814:	e40ff0ef          	jal	ra,80001e54 <printk>
80002818:	800065b7          	lui	a1,0x80006
8000281c:	36458593          	addi	a1,a1,868 # 80006364 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006365>
	} else {
		TC_END_REPORT(TC_PASS);
80002820:	36c40513          	addi	a0,s0,876 # 8000636c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000636d>
	}
}
80002824:	00812403          	lw	s0,8(sp)
80002828:	00c12083          	lw	ra,12(sp)
8000282c:	01010113          	addi	sp,sp,16
		TC_END_REPORT(TC_PASS);
80002830:	e24ff06f          	j	80001e54 <printk>
80002834:	e20ff0ef          	jal	ra,80001e54 <printk>
80002838:	800065b7          	lui	a1,0x80006
8000283c:	38458593          	addi	a1,a1,900 # 80006384 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006385>
80002840:	fe1ff06f          	j	80002820 <end_report+0x30>

80002844 <main>:

	return test_status;
}
#else
void main(void)
{
80002844:	ff010113          	addi	sp,sp,-16
80002848:	00112623          	sw	ra,12(sp)
	k_mem_domain_init(&ztest_mem_domain, ARRAY_SIZE(parts), parts);
	k_mem_domain_add_thread(&ztest_mem_domain, k_current_get());
#endif /* CONFIG_USERSPACE */

	z_init_mock();
	test_main();
8000284c:	eb5fd0ef          	jal	ra,80000700 <test_main>
	end_report();
}
80002850:	00c12083          	lw	ra,12(sp)
80002854:	01010113          	addi	sp,sp,16
	end_report();
80002858:	f99ff06f          	j	800027f0 <end_report>

8000285c <uart_vexriscv_sim_poll_out>:



static void uart_vexriscv_sim_poll_out(struct device *dev,
				       unsigned char c)
{
8000285c:	ff010113          	addi	sp,sp,-16
	volatile int *uart = (int*)0xF0010000;
    volatile int i = 0;
80002860:	00012623          	sw	zero,12(sp)
    i++;
80002864:	00c12783          	lw	a5,12(sp)
80002868:	00178793          	addi	a5,a5,1
8000286c:	00f12623          	sw	a5,12(sp)
    uart[0] = c;
80002870:	f00107b7          	lui	a5,0xf0010
80002874:	00b7a023          	sw	a1,0(a5) # f0010000 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0xf0010001>
}
80002878:	01010113          	addi	sp,sp,16
8000287c:	00008067          	ret

80002880 <uart_vexriscv_sim_poll_in>:

static int uart_vexriscv_sim_poll_in(struct device *dev, unsigned char *c)
{
	return -1;
}
80002880:	fff00513          	li	a0,-1
80002884:	00008067          	ret

80002888 <uart_vexriscv_sim_init>:
static int uart_vexriscv_sim_init(struct device *dev)
{
	/* Nothing to do */

	return 0;
}
80002888:	00000513          	li	a0,0
8000288c:	00008067          	ret

80002890 <z_sys_device_do_config_level>:
		__device_APPLICATION_start,
		/* End marker */
		__device_init_end,
	};

	for (info = config_levels[level]; info < config_levels[level+1];
80002890:	00251713          	slli	a4,a0,0x2
80002894:	800067b7          	lui	a5,0x80006
80002898:	00150513          	addi	a0,a0,1
8000289c:	47078793          	addi	a5,a5,1136 # 80006470 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006471>
800028a0:	00251513          	slli	a0,a0,0x2
{
800028a4:	ff010113          	addi	sp,sp,-16
	for (info = config_levels[level]; info < config_levels[level+1];
800028a8:	00e78733          	add	a4,a5,a4
800028ac:	00a787b3          	add	a5,a5,a0
{
800028b0:	00812423          	sw	s0,8(sp)
800028b4:	00912223          	sw	s1,4(sp)
	for (info = config_levels[level]; info < config_levels[level+1];
800028b8:	00072403          	lw	s0,0(a4)
800028bc:	0007a483          	lw	s1,0(a5)
{
800028c0:	00112623          	sw	ra,12(sp)
	for (info = config_levels[level]; info < config_levels[level+1];
800028c4:	00946c63          	bltu	s0,s1,800028dc <z_sys_device_do_config_level+0x4c>
			info->driver_api = NULL;
		} else {
			z_object_init(info);
		}
	}
}
800028c8:	00c12083          	lw	ra,12(sp)
800028cc:	00812403          	lw	s0,8(sp)
800028d0:	00412483          	lw	s1,4(sp)
800028d4:	01010113          	addi	sp,sp,16
800028d8:	00008067          	ret
		retval = device_conf->init(info);
800028dc:	00042783          	lw	a5,0(s0)
800028e0:	00040513          	mv	a0,s0
800028e4:	0047a783          	lw	a5,4(a5)
800028e8:	000780e7          	jalr	a5
		if (retval != 0) {
800028ec:	00050463          	beqz	a0,800028f4 <z_sys_device_do_config_level+0x64>
			info->driver_api = NULL;
800028f0:	00042223          	sw	zero,4(s0)
								info++) {
800028f4:	00c40413          	addi	s0,s0,12
800028f8:	fcdff06f          	j	800028c4 <z_sys_device_do_config_level+0x34>

800028fc <z_impl_device_get_binding>:

struct device *z_impl_device_get_binding(const char *name)
{
800028fc:	ff010113          	addi	sp,sp,-16
	/* Split the search into two loops: in the common scenario, where
	 * device names are stored in ROM (and are referenced by the user
	 * with CONFIG_* macros), only cheap pointer comparisons will be
	 * performed.  Reserve string comparisons for a fallback.
	 */
	for (info = __device_init_start; info != __device_init_end; info++) {
80002900:	800077b7          	lui	a5,0x80007
{
80002904:	00912223          	sw	s1,4(sp)
	for (info = __device_init_start; info != __device_init_end; info++) {
80002908:	800074b7          	lui	s1,0x80007
{
8000290c:	00812423          	sw	s0,8(sp)
80002910:	00112623          	sw	ra,12(sp)
	for (info = __device_init_start; info != __device_init_end; info++) {
80002914:	8b078413          	addi	s0,a5,-1872 # 800068b0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800068b1>
{
80002918:	01212023          	sw	s2,0(sp)
8000291c:	8b078793          	addi	a5,a5,-1872
80002920:	8e048493          	addi	s1,s1,-1824 # 800068e0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800068e1>
	for (info = __device_init_start; info != __device_init_end; info++) {
80002924:	00941c63          	bne	s0,s1,8000293c <z_impl_device_get_binding+0x40>
80002928:	00050913          	mv	s2,a0
		    (info->config->name == name)) {
			return info;
		}
	}

	for (info = __device_init_start; info != __device_init_end; info++) {
8000292c:	00078413          	mv	s0,a5
80002930:	02941463          	bne	s0,s1,80002958 <z_impl_device_get_binding+0x5c>
		if (strcmp(name, info->config->name) == 0) {
			return info;
		}
	}

	return NULL;
80002934:	00000413          	li	s0,0
80002938:	0440006f          	j	8000297c <z_impl_device_get_binding+0x80>
		if ((info->driver_api != NULL) &&
8000293c:	00442703          	lw	a4,4(s0)
80002940:	00070863          	beqz	a4,80002950 <z_impl_device_get_binding+0x54>
		    (info->config->name == name)) {
80002944:	00042703          	lw	a4,0(s0)
		if ((info->driver_api != NULL) &&
80002948:	00072703          	lw	a4,0(a4)
8000294c:	02a70863          	beq	a4,a0,8000297c <z_impl_device_get_binding+0x80>
	for (info = __device_init_start; info != __device_init_end; info++) {
80002950:	00c40413          	addi	s0,s0,12
80002954:	fd1ff06f          	j	80002924 <z_impl_device_get_binding+0x28>
		if (info->driver_api == NULL) {
80002958:	00442783          	lw	a5,4(s0)
8000295c:	00079663          	bnez	a5,80002968 <z_impl_device_get_binding+0x6c>
	for (info = __device_init_start; info != __device_init_end; info++) {
80002960:	00c40413          	addi	s0,s0,12
80002964:	fcdff06f          	j	80002930 <z_impl_device_get_binding+0x34>
		if (strcmp(name, info->config->name) == 0) {
80002968:	00042783          	lw	a5,0(s0)
8000296c:	00090513          	mv	a0,s2
80002970:	0007a583          	lw	a1,0(a5)
80002974:	a5dff0ef          	jal	ra,800023d0 <strcmp>
80002978:	fe0514e3          	bnez	a0,80002960 <z_impl_device_get_binding+0x64>
}
8000297c:	00040513          	mv	a0,s0
80002980:	00c12083          	lw	ra,12(sp)
80002984:	00812403          	lw	s0,8(sp)
80002988:	00412483          	lw	s1,4(sp)
8000298c:	00012903          	lw	s2,0(sp)
80002990:	01010113          	addi	sp,sp,16
80002994:	00008067          	ret

80002998 <idle>:
#else
#define IDLE_YIELD_IF_COOP() do { } while (false)
#endif

void idle(void *unused1, void *unused2, void *unused3)
{
80002998:	ff010113          	addi	sp,sp,-16
8000299c:	00812423          	sw	s0,8(sp)
800029a0:	00912223          	sw	s1,4(sp)
800029a4:	00112623          	sw	ra,12(sp)
	__asm__ volatile ("csrrc %0, mstatus, %1"
800029a8:	00800413          	li	s0,8
	z_set_timeout_expiry((ticks < IDLE_THRESH) ? 1 : ticks, true);
800029ac:	00200493          	li	s1,2
800029b0:	300437f3          	csrrc	a5,mstatus,s0
	s32_t ticks = z_get_next_timeout_expiry();
800029b4:	62c020ef          	jal	ra,80004fe0 <z_get_next_timeout_expiry>
	z_set_timeout_expiry((ticks < IDLE_THRESH) ? 1 : ticks, true);
800029b8:	00a4c463          	blt	s1,a0,800029c0 <idle+0x28>
800029bc:	00100513          	li	a0,1
800029c0:	00100593          	li	a1,1
800029c4:	6f8020ef          	jal	ra,800050bc <z_set_timeout_expiry>
	k_cpu_idle();
800029c8:	cfcff0ef          	jal	ra,80001ec4 <k_cpu_idle>
800029cc:	fe5ff06f          	j	800029b0 <idle+0x18>

800029d0 <z_bss_zero>:
 *
 * @return N/A
 */
void z_bss_zero(void)
{
	(void)memset(&__bss_start, 0,
800029d0:	80007537          	lui	a0,0x80007
800029d4:	800077b7          	lui	a5,0x80007
800029d8:	94850613          	addi	a2,a0,-1720 # 80006948 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006949>
800029dc:	cd078793          	addi	a5,a5,-816 # 80006cd0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006cd1>
800029e0:	40c78633          	sub	a2,a5,a2
800029e4:	00000593          	li	a1,0
800029e8:	94850513          	addi	a0,a0,-1720
800029ec:	aa9ff06f          	j	80002494 <memset>

800029f0 <bg_thread_main>:
 * init functions, then invokes application's main() routine.
 *
 * @return N/A
 */
static void bg_thread_main(void *unused1, void *unused2, void *unused3)
{
800029f0:	ff010113          	addi	sp,sp,-16
	static const unsigned int boot_delay = CONFIG_BOOT_DELAY;
#else
	static const unsigned int boot_delay;
#endif

	z_sys_device_do_config_level(_SYS_INIT_LEVEL_POST_KERNEL);
800029f4:	00200513          	li	a0,2
{
800029f8:	00112623          	sw	ra,12(sp)
	z_sys_device_do_config_level(_SYS_INIT_LEVEL_POST_KERNEL);
800029fc:	e95ff0ef          	jal	ra,80002890 <z_sys_device_do_config_level>
	if (boot_delay > 0 && IS_ENABLED(CONFIG_MULTITHREADING)) {
		printk("***** delaying boot " STRINGIFY(CONFIG_BOOT_DELAY)
		       "ms (per build configuration) *****\n");
		k_busy_wait(CONFIG_BOOT_DELAY * USEC_PER_MSEC);
	}
	PRINT_BOOT_BANNER();
80002a00:	80006537          	lui	a0,0x80006
80002a04:	48450513          	addi	a0,a0,1156 # 80006484 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006485>
80002a08:	c4cff0ef          	jal	ra,80001e54 <printk>

	/* Final init level before app starts */
	z_sys_device_do_config_level(_SYS_INIT_LEVEL_APPLICATION);
80002a0c:	00300513          	li	a0,3
80002a10:	e81ff0ef          	jal	ra,80002890 <z_sys_device_do_config_level>
	extern void __do_init_array_aux(void);
	__do_global_ctors_aux();
	__do_init_array_aux();
#endif

	z_init_static_threads();
80002a14:	038020ef          	jal	ra,80004a4c <z_init_static_threads>
	__main_time_stamp = (u64_t)k_cycle_get_32();
#endif

	extern void main(void);

	main();
80002a18:	e2dff0ef          	jal	ra,80002844 <main>

	/* Dump coverage data once the main() has exited. */
	gcov_coverage_dump();

	/* Terminate thread normally since it has no more work to do */
	_main_thread->base.user_options &= ~K_ESSENTIAL;
80002a1c:	800077b7          	lui	a5,0x80007
80002a20:	c3478793          	addi	a5,a5,-972 # 80006c34 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006c35>
80002a24:	00c7c703          	lbu	a4,12(a5)
80002a28:	ffe77713          	andi	a4,a4,-2
80002a2c:	00e78623          	sb	a4,12(a5)
}
80002a30:	00c12083          	lw	ra,12(sp)
80002a34:	01010113          	addi	sp,sp,16
80002a38:	00008067          	ret

80002a3c <z_cstart>:
 * cleared/zeroed.
 *
 * @return Does not return
 */
FUNC_NORETURN void z_cstart(void)
{
80002a3c:	f6010113          	addi	sp,sp,-160
80002a40:	08812c23          	sw	s0,152(sp)
void k_cpu_idle(void);
void k_cpu_atomic_idle(unsigned int key);

static ALWAYS_INLINE void kernel_arch_init(void)
{
	_kernel.irq_stack =
80002a44:	800087b7          	lui	a5,0x80008
80002a48:	80007437          	lui	s0,0x80007
80002a4c:	09312623          	sw	s3,140(sp)
80002a50:	ed078793          	addi	a5,a5,-304 # 80007ed0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007ed1>
80002a54:	ca440993          	addi	s3,s0,-860 # 80006ca4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006ca5>
80002a58:	00f9a223          	sw	a5,4(s3)

	/* perform any architecture-specific initialization */
	kernel_arch_init();

#ifdef CONFIG_MULTITHREADING
	struct k_thread dummy_thread = {
80002a5c:	01010793          	addi	a5,sp,16
80002a60:	07000613          	li	a2,112
80002a64:	00000593          	li	a1,0
80002a68:	00078513          	mv	a0,a5
{
80002a6c:	08112e23          	sw	ra,156(sp)
80002a70:	08912a23          	sw	s1,148(sp)
80002a74:	09212823          	sw	s2,144(sp)
	struct k_thread dummy_thread = {
80002a78:	a1dff0ef          	jal	ra,80002494 <memset>
80002a7c:	00100713          	li	a4,1
# ifdef CONFIG_SCHED_CPU_MASK
		 .base.cpu_mask = -1,
# endif
	};

	_current = &dummy_thread;
80002a80:	00a9a423          	sw	a0,8(s3)
#ifdef CONFIG_USERSPACE
	z_app_shmem_bss_zero();
#endif

	/* perform basic hardware initialization */
	z_sys_device_do_config_level(_SYS_INIT_LEVEL_PRE_KERNEL_1);
80002a84:	00000513          	li	a0,0
	struct k_thread dummy_thread = {
80002a88:	00e10ea3          	sb	a4,29(sp)
	z_sys_device_do_config_level(_SYS_INIT_LEVEL_PRE_KERNEL_1);
80002a8c:	e05ff0ef          	jal	ra,80002890 <z_sys_device_do_config_level>
	z_sys_device_do_config_level(_SYS_INIT_LEVEL_PRE_KERNEL_2);
80002a90:	00100513          	li	a0,1
80002a94:	dfdff0ef          	jal	ra,80002890 <z_sys_device_do_config_level>
	dummy_thread->base.user_options = K_ESSENTIAL;
80002a98:	10100793          	li	a5,257
80002a9c:	00f11e23          	sh	a5,28(sp)
	z_sched_init();
80002aa0:	41c010ef          	jal	ra,80003ebc <z_sched_init>
	z_setup_new_thread(_main_thread, _main_stack,
80002aa4:	800067b7          	lui	a5,0x80006
80002aa8:	4c878793          	addi	a5,a5,1224 # 800064c8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800064c9>
	_kernel.ready_q.cache = _main_thread;
80002aac:	80007937          	lui	s2,0x80007
	z_setup_new_thread(_main_thread, _main_stack,
80002ab0:	00f12223          	sw	a5,4(sp)
80002ab4:	800036b7          	lui	a3,0x80003
80002ab8:	00100793          	li	a5,1
80002abc:	800075b7          	lui	a1,0x80007
	_kernel.ready_q.cache = _main_thread;
80002ac0:	c3490493          	addi	s1,s2,-972 # 80006c34 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006c35>
	z_setup_new_thread(_main_thread, _main_stack,
80002ac4:	00f12023          	sw	a5,0(sp)
80002ac8:	00000713          	li	a4,0
80002acc:	00000793          	li	a5,0
80002ad0:	00000893          	li	a7,0
80002ad4:	00000813          	li	a6,0
80002ad8:	9f068693          	addi	a3,a3,-1552 # 800029f0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800029f1>
80002adc:	20000613          	li	a2,512
80002ae0:	2d058593          	addi	a1,a1,720 # 800072d0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800072d1>
80002ae4:	c3490513          	addi	a0,s2,-972
	_kernel.ready_q.cache = _main_thread;
80002ae8:	0299a023          	sw	s1,32(s3)
	z_setup_new_thread(_main_thread, _main_stack,
80002aec:	3dd010ef          	jal	ra,800046c8 <z_setup_new_thread>
	thread->base.thread_state &= ~_THREAD_SUSPENDED;
}

static inline void z_mark_thread_as_started(struct k_thread *thread)
{
	thread->base.thread_state &= ~_THREAD_PRESTART;
80002af0:	00d4c783          	lbu	a5,13(s1)
80002af4:	ca440413          	addi	s0,s0,-860
80002af8:	ffb7f713          	andi	a4,a5,-5
80002afc:	00e486a3          	sb	a4,13(s1)
	return !((z_is_thread_prevented_from_running(thread)) != 0 ||
80002b00:	01b7f793          	andi	a5,a5,27
80002b04:	00079a63          	bnez	a5,80002b18 <z_cstart+0xdc>
	return true;
}

static ALWAYS_INLINE void z_ready_thread(struct k_thread *thread)
{
	if (z_is_thread_ready(thread)) {
80002b08:	0184a783          	lw	a5,24(s1)
80002b0c:	00079663          	bnez	a5,80002b18 <z_cstart+0xdc>
		z_add_thread_to_ready_q(thread);
80002b10:	c3490513          	addi	a0,s2,-972
80002b14:	189000ef          	jal	ra,8000349c <z_add_thread_to_ready_q>
	z_setup_new_thread(thr, stack,
80002b18:	800067b7          	lui	a5,0x80006
80002b1c:	4d078793          	addi	a5,a5,1232 # 800064d0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800064d1>
80002b20:	00f12223          	sw	a5,4(sp)
80002b24:	80007537          	lui	a0,0x80007
80002b28:	00100793          	li	a5,1
80002b2c:	800036b7          	lui	a3,0x80003
80002b30:	800075b7          	lui	a1,0x80007
80002b34:	bc450493          	addi	s1,a0,-1084 # 80006bc4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006bc5>
80002b38:	00f12023          	sw	a5,0(sp)
80002b3c:	00f00893          	li	a7,15
80002b40:	00000813          	li	a6,0
80002b44:	00000793          	li	a5,0
80002b48:	00000713          	li	a4,0
80002b4c:	99868693          	addi	a3,a3,-1640 # 80002998 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80002999>
80002b50:	20000613          	li	a2,512
80002b54:	4d058593          	addi	a1,a1,1232 # 800074d0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800074d1>
80002b58:	bc450513          	addi	a0,a0,-1084
80002b5c:	36d010ef          	jal	ra,800046c8 <z_setup_new_thread>
	thread->base.thread_state &= ~_THREAD_PRESTART;
80002b60:	00d4c783          	lbu	a5,13(s1)
	_kernel.cpus[0].idle_thread = _idle_thread;
80002b64:	00942623          	sw	s1,12(s0)
80002b68:	00800513          	li	a0,8
80002b6c:	ffb7f793          	andi	a5,a5,-5
80002b70:	00f486a3          	sb	a5,13(s1)
	list->head = (sys_dnode_t *)list;
80002b74:	800077b7          	lui	a5,0x80007
80002b78:	cbc78793          	addi	a5,a5,-836 # 80006cbc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006cbd>
80002b7c:	00f42c23          	sw	a5,24(s0)
	list->tail = (sys_dnode_t *)list;
80002b80:	00f42e23          	sw	a5,28(s0)
80002b84:	30053573          	csrrc	a0,mstatus,a0
#ifndef CONFIG_ARM
#ifdef CONFIG_TRACING
	sys_trace_thread_switched_out();
#endif
#endif
	ret = __swap(key);
80002b88:	00857513          	andi	a0,a0,8
80002b8c:	eacfd0ef          	jal	ra,80000238 <__swap>

80002b90 <z_is_thread_ready>:
	return !((z_is_thread_prevented_from_running(thread)) != 0 ||
80002b90:	00d54783          	lbu	a5,13(a0)
80002b94:	01f7f793          	andi	a5,a5,31
80002b98:	00079863          	bnez	a5,80002ba8 <z_is_thread_ready+0x18>
80002b9c:	01852503          	lw	a0,24(a0)
80002ba0:	00153513          	seqz	a0,a0
80002ba4:	00008067          	ret
80002ba8:	00000513          	li	a0,0
}
80002bac:	00008067          	ret

80002bb0 <reset_time_slice>:
 */
static struct k_thread *pending_current;
#endif

static void reset_time_slice(void)
{
80002bb0:	ff010113          	addi	sp,sp,-16
80002bb4:	00112623          	sw	ra,12(sp)
	/* Add the elapsed time since the last announced tick to the
	 * slice count, as we'll see those "expired" ticks arrive in a
	 * FUTURE z_time_slice() call.
	 */
	_current_cpu->slice_ticks = slice_time + z_clock_elapsed();
80002bb8:	f28ff0ef          	jal	ra,800022e0 <z_clock_elapsed>
80002bbc:	800077b7          	lui	a5,0x80007
80002bc0:	9807a783          	lw	a5,-1664(a5) # 80006980 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006981>

	z_set_timeout_expiry(slice_time, false);
}
80002bc4:	00c12083          	lw	ra,12(sp)
	_current_cpu->slice_ticks = slice_time + z_clock_elapsed();
80002bc8:	80007737          	lui	a4,0x80007
80002bcc:	00a78533          	add	a0,a5,a0
80002bd0:	caa72a23          	sw	a0,-844(a4) # 80006cb4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006cb5>
	z_set_timeout_expiry(slice_time, false);
80002bd4:	00000593          	li	a1,0
80002bd8:	00078513          	mv	a0,a5
}
80002bdc:	01010113          	addi	sp,sp,16
	z_set_timeout_expiry(slice_time, false);
80002be0:	4dc0206f          	j	800050bc <z_set_timeout_expiry>

80002be4 <pended_on.isra.15>:
	pend(thread, wait_q, timeout);
}

static _wait_q_t *pended_on(struct k_thread *thread)
{
	__ASSERT_NO_MSG(thread->base.pended_on);
80002be4:	00052783          	lw	a5,0(a0)
static _wait_q_t *pended_on(struct k_thread *thread)
80002be8:	ff010113          	addi	sp,sp,-16
80002bec:	00812423          	sw	s0,8(sp)
80002bf0:	00112623          	sw	ra,12(sp)
80002bf4:	00912223          	sw	s1,4(sp)
80002bf8:	00050413          	mv	s0,a0
	__ASSERT_NO_MSG(thread->base.pended_on);
80002bfc:	02079863          	bnez	a5,80002c2c <pended_on.isra.15+0x48>
80002c00:	800064b7          	lui	s1,0x80006
80002c04:	800065b7          	lui	a1,0x80006
80002c08:	80006537          	lui	a0,0x80006
80002c0c:	57058593          	addi	a1,a1,1392 # 80006570 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006571>
80002c10:	21850513          	addi	a0,a0,536 # 80006218 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006219>
80002c14:	18300693          	li	a3,387
80002c18:	55c48613          	addi	a2,s1,1372 # 8000655c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000655d>
80002c1c:	a38ff0ef          	jal	ra,80001e54 <printk>
80002c20:	18300593          	li	a1,387
80002c24:	55c48513          	addi	a0,s1,1372
80002c28:	a68ff0ef          	jal	ra,80001e90 <assert_post_action>

	return thread->base.pended_on;
}
80002c2c:	00042503          	lw	a0,0(s0)
80002c30:	00c12083          	lw	ra,12(sp)
80002c34:	00812403          	lw	s0,8(sp)
80002c38:	00412483          	lw	s1,4(sp)
80002c3c:	01010113          	addi	sp,sp,16
80002c40:	00008067          	ret

80002c44 <k_sched_time_slice_set>:
{
80002c44:	fe010113          	addi	sp,sp,-32
80002c48:	00812c23          	sw	s0,24(sp)
80002c4c:	01212823          	sw	s2,16(sp)
80002c50:	01412423          	sw	s4,8(sp)
80002c54:	00112e23          	sw	ra,28(sp)
80002c58:	00912a23          	sw	s1,20(sp)
80002c5c:	01312623          	sw	s3,12(sp)
80002c60:	00050913          	mv	s2,a0
80002c64:	00058a13          	mv	s4,a1
80002c68:	00800413          	li	s0,8
80002c6c:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80002c70:	800074b7          	lui	s1,0x80007
80002c74:	97848513          	addi	a0,s1,-1672 # 80006978 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006979>
	key = (mstatus & SOC_MSTATUS_IEN);
80002c78:	00847413          	andi	s0,s0,8
80002c7c:	319010ef          	jal	ra,80004794 <z_spin_lock_valid>
80002c80:	02051e63          	bnez	a0,80002cbc <k_sched_time_slice_set+0x78>
80002c84:	800069b7          	lui	s3,0x80006
80002c88:	800065b7          	lui	a1,0x80006
80002c8c:	80006537          	lui	a0,0x80006
80002c90:	2fc58593          	addi	a1,a1,764 # 800062fc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800062fd>
80002c94:	04e00693          	li	a3,78
80002c98:	2e498613          	addi	a2,s3,740 # 800062e4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800062e5>
80002c9c:	21850513          	addi	a0,a0,536 # 80006218 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006219>
80002ca0:	9b4ff0ef          	jal	ra,80001e54 <printk>
80002ca4:	80006537          	lui	a0,0x80006
80002ca8:	31450513          	addi	a0,a0,788 # 80006314 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006315>
80002cac:	9a8ff0ef          	jal	ra,80001e54 <printk>
80002cb0:	04e00593          	li	a1,78
80002cb4:	2e498513          	addi	a0,s3,740
80002cb8:	9d8ff0ef          	jal	ra,80001e90 <assert_post_action>
	z_spin_lock_set_owner(l);
80002cbc:	97848513          	addi	a0,s1,-1672
80002cc0:	32d010ef          	jal	ra,800047ec <z_spin_lock_set_owner>
		_current_cpu->slice_ticks = 0;
80002cc4:	800077b7          	lui	a5,0x80007
80002cc8:	ca07aa23          	sw	zero,-844(a5) # 80006cb4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006cb5>
		CONFIG_SYS_CLOCK_TICKS_PER_SEC);
#else
	/* simple division keeps precision */
	s32_t ms_per_tick = MSEC_PER_SEC / CONFIG_SYS_CLOCK_TICKS_PER_SEC;

	return (s32_t)ceiling_fraction(ms, ms_per_tick);
80002ccc:	00990913          	addi	s2,s2,9
80002cd0:	00a00793          	li	a5,10
80002cd4:	02f94933          	div	s2,s2,a5
		slice_time = z_ms_to_ticks(slice);
80002cd8:	800077b7          	lui	a5,0x80007
80002cdc:	9927a023          	sw	s2,-1664(a5) # 80006980 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006981>
		slice_max_prio = prio;
80002ce0:	800077b7          	lui	a5,0x80007
80002ce4:	9747ae23          	sw	s4,-1668(a5) # 8000697c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000697d>
		reset_time_slice();
80002ce8:	ec9ff0ef          	jal	ra,80002bb0 <reset_time_slice>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80002cec:	97848513          	addi	a0,s1,-1672
80002cf0:	2cd010ef          	jal	ra,800047bc <z_spin_unlock_valid>
80002cf4:	02051e63          	bnez	a0,80002d30 <k_sched_time_slice_set+0xec>
80002cf8:	800064b7          	lui	s1,0x80006
80002cfc:	800065b7          	lui	a1,0x80006
80002d00:	80006537          	lui	a0,0x80006
80002d04:	32c58593          	addi	a1,a1,812 # 8000632c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000632d>
80002d08:	06100693          	li	a3,97
80002d0c:	2e448613          	addi	a2,s1,740 # 800062e4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800062e5>
80002d10:	21850513          	addi	a0,a0,536 # 80006218 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006219>
80002d14:	940ff0ef          	jal	ra,80001e54 <printk>
80002d18:	80006537          	lui	a0,0x80006
80002d1c:	34450513          	addi	a0,a0,836 # 80006344 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006345>
80002d20:	934ff0ef          	jal	ra,80001e54 <printk>
80002d24:	06100593          	li	a1,97
80002d28:	2e448513          	addi	a0,s1,740
80002d2c:	964ff0ef          	jal	ra,80001e90 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80002d30:	30042473          	csrrs	s0,mstatus,s0
}
80002d34:	01c12083          	lw	ra,28(sp)
80002d38:	01812403          	lw	s0,24(sp)
80002d3c:	01412483          	lw	s1,20(sp)
80002d40:	01012903          	lw	s2,16(sp)
80002d44:	00c12983          	lw	s3,12(sp)
80002d48:	00812a03          	lw	s4,8(sp)
80002d4c:	02010113          	addi	sp,sp,32
80002d50:	00008067          	ret

80002d54 <z_unpend_thread_no_timeout>:

	return ret;
}

ALWAYS_INLINE void z_unpend_thread_no_timeout(struct k_thread *thread)
{
80002d54:	fe010113          	addi	sp,sp,-32
80002d58:	00812c23          	sw	s0,24(sp)
80002d5c:	01212823          	sw	s2,16(sp)
80002d60:	00112e23          	sw	ra,28(sp)
80002d64:	00912a23          	sw	s1,20(sp)
80002d68:	01312623          	sw	s3,12(sp)
80002d6c:	00050913          	mv	s2,a0
	__asm__ volatile ("csrrc %0, mstatus, %1"
80002d70:	00800413          	li	s0,8
80002d74:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80002d78:	800074b7          	lui	s1,0x80007
80002d7c:	97848513          	addi	a0,s1,-1672 # 80006978 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006979>
	key = (mstatus & SOC_MSTATUS_IEN);
80002d80:	00847413          	andi	s0,s0,8
80002d84:	211010ef          	jal	ra,80004794 <z_spin_lock_valid>
80002d88:	02051e63          	bnez	a0,80002dc4 <z_unpend_thread_no_timeout+0x70>
80002d8c:	800069b7          	lui	s3,0x80006
80002d90:	800065b7          	lui	a1,0x80006
80002d94:	80006537          	lui	a0,0x80006
80002d98:	2fc58593          	addi	a1,a1,764 # 800062fc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800062fd>
80002d9c:	04e00693          	li	a3,78
80002da0:	2e498613          	addi	a2,s3,740 # 800062e4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800062e5>
80002da4:	21850513          	addi	a0,a0,536 # 80006218 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006219>
80002da8:	8acff0ef          	jal	ra,80001e54 <printk>
80002dac:	80006537          	lui	a0,0x80006
80002db0:	31450513          	addi	a0,a0,788 # 80006314 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006315>
80002db4:	8a0ff0ef          	jal	ra,80001e54 <printk>
80002db8:	04e00593          	li	a1,78
80002dbc:	2e498513          	addi	a0,s3,740
80002dc0:	8d0ff0ef          	jal	ra,80001e90 <assert_post_action>
	z_spin_lock_set_owner(l);
80002dc4:	97848513          	addi	a0,s1,-1672
80002dc8:	225010ef          	jal	ra,800047ec <z_spin_lock_set_owner>
	LOCKED(&sched_spinlock) {
		_priq_wait_remove(&pended_on(thread)->waitq, thread);
80002dcc:	00890513          	addi	a0,s2,8
80002dd0:	e15ff0ef          	jal	ra,80002be4 <pended_on.isra.15>
80002dd4:	00090593          	mv	a1,s2
80002dd8:	2f0000ef          	jal	ra,800030c8 <z_priq_dumb_remove>
	thread->base.thread_state &= ~_THREAD_PENDING;
80002ddc:	00d94783          	lbu	a5,13(s2)
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80002de0:	97848513          	addi	a0,s1,-1672
80002de4:	ffd7f793          	andi	a5,a5,-3
80002de8:	00f906a3          	sb	a5,13(s2)
80002dec:	1d1010ef          	jal	ra,800047bc <z_spin_unlock_valid>
80002df0:	02051e63          	bnez	a0,80002e2c <z_unpend_thread_no_timeout+0xd8>
80002df4:	800064b7          	lui	s1,0x80006
80002df8:	800065b7          	lui	a1,0x80006
80002dfc:	80006537          	lui	a0,0x80006
80002e00:	32c58593          	addi	a1,a1,812 # 8000632c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000632d>
80002e04:	06100693          	li	a3,97
80002e08:	2e448613          	addi	a2,s1,740 # 800062e4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800062e5>
80002e0c:	21850513          	addi	a0,a0,536 # 80006218 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006219>
80002e10:	844ff0ef          	jal	ra,80001e54 <printk>
80002e14:	80006537          	lui	a0,0x80006
80002e18:	34450513          	addi	a0,a0,836 # 80006344 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006345>
80002e1c:	838ff0ef          	jal	ra,80001e54 <printk>
80002e20:	06100593          	li	a1,97
80002e24:	2e448513          	addi	a0,s1,740
80002e28:	868ff0ef          	jal	ra,80001e90 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80002e2c:	30042473          	csrrs	s0,mstatus,s0
		z_mark_thread_as_not_pending(thread);
	}

	thread->base.pended_on = NULL;
}
80002e30:	01c12083          	lw	ra,28(sp)
80002e34:	01812403          	lw	s0,24(sp)
	thread->base.pended_on = NULL;
80002e38:	00092423          	sw	zero,8(s2)
}
80002e3c:	01412483          	lw	s1,20(sp)
80002e40:	01012903          	lw	s2,16(sp)
80002e44:	00c12983          	lw	s3,12(sp)
80002e48:	02010113          	addi	sp,sp,32
80002e4c:	00008067          	ret

80002e50 <z_reschedule>:
	return !z_is_in_isr();
}

void z_reschedule(struct k_spinlock *lock, k_spinlock_key_t key)
{
	if (resched()) {
80002e50:	800077b7          	lui	a5,0x80007
80002e54:	ca47a783          	lw	a5,-860(a5) # 80006ca4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006ca5>
{
80002e58:	ff010113          	addi	sp,sp,-16
80002e5c:	00812423          	sw	s0,8(sp)
80002e60:	00112623          	sw	ra,12(sp)
80002e64:	00912223          	sw	s1,4(sp)
80002e68:	00058413          	mv	s0,a1
	if (resched()) {
80002e6c:	04079e63          	bnez	a5,80002ec8 <z_reschedule+0x78>
 */
static ALWAYS_INLINE void k_spin_release(struct k_spinlock *l)
{
	ARG_UNUSED(l);
#ifdef SPIN_VALIDATE
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80002e70:	14d010ef          	jal	ra,800047bc <z_spin_unlock_valid>
80002e74:	02051e63          	bnez	a0,80002eb0 <z_reschedule+0x60>
80002e78:	800064b7          	lui	s1,0x80006
80002e7c:	800065b7          	lui	a1,0x80006
80002e80:	80006537          	lui	a0,0x80006
80002e84:	32c58593          	addi	a1,a1,812 # 8000632c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000632d>
80002e88:	07800693          	li	a3,120
80002e8c:	2e448613          	addi	a2,s1,740 # 800062e4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800062e5>
80002e90:	21850513          	addi	a0,a0,536 # 80006218 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006219>
80002e94:	fc1fe0ef          	jal	ra,80001e54 <printk>
80002e98:	80006537          	lui	a0,0x80006
80002e9c:	34450513          	addi	a0,a0,836 # 80006344 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006345>
80002ea0:	fb5fe0ef          	jal	ra,80001e54 <printk>
80002ea4:	07800593          	li	a1,120
80002ea8:	2e448513          	addi	a0,s1,740
80002eac:	fe5fe0ef          	jal	ra,80001e90 <assert_post_action>
80002eb0:	00040513          	mv	a0,s0
		z_swap(lock, key);
	} else {
		k_spin_unlock(lock, key);
	}
}
80002eb4:	00812403          	lw	s0,8(sp)
80002eb8:	00c12083          	lw	ra,12(sp)
80002ebc:	00412483          	lw	s1,4(sp)
80002ec0:	01010113          	addi	sp,sp,16
80002ec4:	b74fd06f          	j	80000238 <__swap>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80002ec8:	0f5010ef          	jal	ra,800047bc <z_spin_unlock_valid>
80002ecc:	02051e63          	bnez	a0,80002f08 <z_reschedule+0xb8>
80002ed0:	800064b7          	lui	s1,0x80006
80002ed4:	800065b7          	lui	a1,0x80006
80002ed8:	80006537          	lui	a0,0x80006
80002edc:	32c58593          	addi	a1,a1,812 # 8000632c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000632d>
80002ee0:	06100693          	li	a3,97
80002ee4:	2e448613          	addi	a2,s1,740 # 800062e4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800062e5>
80002ee8:	21850513          	addi	a0,a0,536 # 80006218 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006219>
80002eec:	f69fe0ef          	jal	ra,80001e54 <printk>
80002ef0:	80006537          	lui	a0,0x80006
80002ef4:	34450513          	addi	a0,a0,836 # 80006344 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006345>
80002ef8:	f5dfe0ef          	jal	ra,80001e54 <printk>
80002efc:	06100593          	li	a1,97
80002f00:	2e448513          	addi	a0,s1,740
80002f04:	f8dfe0ef          	jal	ra,80001e90 <assert_post_action>
			  : "r" (key & SOC_MSTATUS_IEN)
80002f08:	00847413          	andi	s0,s0,8
	__asm__ volatile ("csrrs %0, mstatus, %1"
80002f0c:	30042473          	csrrs	s0,mstatus,s0
80002f10:	00c12083          	lw	ra,12(sp)
80002f14:	00812403          	lw	s0,8(sp)
80002f18:	00412483          	lw	s1,4(sp)
80002f1c:	01010113          	addi	sp,sp,16
80002f20:	00008067          	ret

80002f24 <z_reschedule_irqlock>:

void z_reschedule_irqlock(u32_t key)
{
	if (resched()) {
80002f24:	80007737          	lui	a4,0x80007
80002f28:	ca472703          	lw	a4,-860(a4) # 80006ca4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006ca5>
80002f2c:	00071463          	bnez	a4,80002f34 <z_reschedule_irqlock+0x10>
80002f30:	b08fd06f          	j	80000238 <__swap>
			  : "r" (key & SOC_MSTATUS_IEN)
80002f34:	00857793          	andi	a5,a0,8
	__asm__ volatile ("csrrs %0, mstatus, %1"
80002f38:	3007a7f3          	csrrs	a5,mstatus,a5
		z_swap_irqlock(key);
	} else {
		irq_unlock(key);
	}
}
80002f3c:	00008067          	ret

80002f40 <z_reschedule_unlocked>:
	__asm__ volatile ("csrrc %0, mstatus, %1"
80002f40:	00800513          	li	a0,8
80002f44:	30053573          	csrrc	a0,mstatus,a0
	(void) z_reschedule_irqlock(z_arch_irq_lock());
80002f48:	00857513          	andi	a0,a0,8
80002f4c:	fd9ff06f          	j	80002f24 <z_reschedule_irqlock>

80002f50 <k_sched_lock>:

void k_sched_lock(void)
{
80002f50:	fe010113          	addi	sp,sp,-32
80002f54:	00812c23          	sw	s0,24(sp)
80002f58:	00112e23          	sw	ra,28(sp)
80002f5c:	00912a23          	sw	s1,20(sp)
80002f60:	01212823          	sw	s2,16(sp)
80002f64:	01312623          	sw	s3,12(sp)
80002f68:	00800413          	li	s0,8
80002f6c:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80002f70:	800074b7          	lui	s1,0x80007
80002f74:	97848513          	addi	a0,s1,-1672 # 80006978 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006979>
	key = (mstatus & SOC_MSTATUS_IEN);
80002f78:	00847413          	andi	s0,s0,8
80002f7c:	019010ef          	jal	ra,80004794 <z_spin_lock_valid>
80002f80:	02051e63          	bnez	a0,80002fbc <k_sched_lock+0x6c>
80002f84:	80006937          	lui	s2,0x80006
80002f88:	800065b7          	lui	a1,0x80006
80002f8c:	80006537          	lui	a0,0x80006
80002f90:	2fc58593          	addi	a1,a1,764 # 800062fc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800062fd>
80002f94:	04e00693          	li	a3,78
80002f98:	2e490613          	addi	a2,s2,740 # 800062e4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800062e5>
80002f9c:	21850513          	addi	a0,a0,536 # 80006218 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006219>
80002fa0:	eb5fe0ef          	jal	ra,80001e54 <printk>
80002fa4:	80006537          	lui	a0,0x80006
80002fa8:	31450513          	addi	a0,a0,788 # 80006314 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006315>
80002fac:	ea9fe0ef          	jal	ra,80001e54 <printk>
80002fb0:	04e00593          	li	a1,78
80002fb4:	2e490513          	addi	a0,s2,740
80002fb8:	ed9fe0ef          	jal	ra,80001e90 <assert_post_action>
	z_spin_lock_set_owner(l);
80002fbc:	97848513          	addi	a0,s1,-1672
}

static inline void z_sched_lock(void)
{
#ifdef CONFIG_PREEMPT_ENABLED
	__ASSERT(!z_is_in_isr(), "");
80002fc0:	80007937          	lui	s2,0x80007
80002fc4:	029010ef          	jal	ra,800047ec <z_spin_lock_set_owner>
80002fc8:	ca492783          	lw	a5,-860(s2) # 80006ca4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006ca5>
80002fcc:	ca490913          	addi	s2,s2,-860
80002fd0:	02078e63          	beqz	a5,8000300c <k_sched_lock+0xbc>
80002fd4:	800069b7          	lui	s3,0x80006
80002fd8:	800065b7          	lui	a1,0x80006
80002fdc:	80006537          	lui	a0,0x80006
80002fe0:	4f458593          	addi	a1,a1,1268 # 800064f4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800064f5>
80002fe4:	10000693          	li	a3,256
80002fe8:	4d898613          	addi	a2,s3,1240 # 800064d8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800064d9>
80002fec:	21850513          	addi	a0,a0,536 # 80006218 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006219>
80002ff0:	e65fe0ef          	jal	ra,80001e54 <printk>
80002ff4:	80006537          	lui	a0,0x80006
80002ff8:	29c50513          	addi	a0,a0,668 # 8000629c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000629d>
80002ffc:	e59fe0ef          	jal	ra,80001e54 <printk>
80003000:	10000593          	li	a1,256
80003004:	4d898513          	addi	a0,s3,1240
80003008:	e89fe0ef          	jal	ra,80001e90 <assert_post_action>
	__ASSERT(_current->base.sched_locked != 1, "");
8000300c:	00892783          	lw	a5,8(s2)
80003010:	00f7c703          	lbu	a4,15(a5)
80003014:	00100793          	li	a5,1
80003018:	02f71e63          	bne	a4,a5,80003054 <k_sched_lock+0x104>
8000301c:	800069b7          	lui	s3,0x80006
80003020:	800065b7          	lui	a1,0x80006
80003024:	80006537          	lui	a0,0x80006
80003028:	50c58593          	addi	a1,a1,1292 # 8000650c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000650d>
8000302c:	10100693          	li	a3,257
80003030:	4d898613          	addi	a2,s3,1240 # 800064d8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800064d9>
80003034:	21850513          	addi	a0,a0,536 # 80006218 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006219>
80003038:	e1dfe0ef          	jal	ra,80001e54 <printk>
8000303c:	80006537          	lui	a0,0x80006
80003040:	29c50513          	addi	a0,a0,668 # 8000629c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000629d>
80003044:	e11fe0ef          	jal	ra,80001e54 <printk>
80003048:	10100593          	li	a1,257
8000304c:	4d898513          	addi	a0,s3,1240
80003050:	e41fe0ef          	jal	ra,80001e90 <assert_post_action>

	--_current->base.sched_locked;
80003054:	00892703          	lw	a4,8(s2)
80003058:	00f74783          	lbu	a5,15(a4)
8000305c:	fff78793          	addi	a5,a5,-1
80003060:	00f707a3          	sb	a5,15(a4)
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80003064:	97848513          	addi	a0,s1,-1672
80003068:	754010ef          	jal	ra,800047bc <z_spin_unlock_valid>
8000306c:	02051e63          	bnez	a0,800030a8 <k_sched_lock+0x158>
80003070:	800064b7          	lui	s1,0x80006
80003074:	800065b7          	lui	a1,0x80006
80003078:	80006537          	lui	a0,0x80006
8000307c:	32c58593          	addi	a1,a1,812 # 8000632c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000632d>
80003080:	06100693          	li	a3,97
80003084:	2e448613          	addi	a2,s1,740 # 800062e4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800062e5>
80003088:	21850513          	addi	a0,a0,536 # 80006218 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006219>
8000308c:	dc9fe0ef          	jal	ra,80001e54 <printk>
80003090:	80006537          	lui	a0,0x80006
80003094:	34450513          	addi	a0,a0,836 # 80006344 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006345>
80003098:	dbdfe0ef          	jal	ra,80001e54 <printk>
8000309c:	06100593          	li	a1,97
800030a0:	2e448513          	addi	a0,s1,740
800030a4:	dedfe0ef          	jal	ra,80001e90 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
800030a8:	30042473          	csrrs	s0,mstatus,s0
	LOCKED(&sched_spinlock) {
		z_sched_lock();
	}
}
800030ac:	01c12083          	lw	ra,28(sp)
800030b0:	01812403          	lw	s0,24(sp)
800030b4:	01412483          	lw	s1,20(sp)
800030b8:	01012903          	lw	s2,16(sp)
800030bc:	00c12983          	lw	s3,12(sp)
800030c0:	02010113          	addi	sp,sp,32
800030c4:	00008067          	ret

800030c8 <z_priq_dumb_remove>:
	return thread == _idle_thread;
800030c8:	800077b7          	lui	a5,0x80007
	    z_is_thread_prevented_from_running(thread)) {
		return;
	}
#endif

	__ASSERT_NO_MSG(!is_idle(thread));
800030cc:	8ac7a783          	lw	a5,-1876(a5) # 800068ac <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800068ad>
{
800030d0:	ff010113          	addi	sp,sp,-16
800030d4:	00812423          	sw	s0,8(sp)
800030d8:	00112623          	sw	ra,12(sp)
800030dc:	00912223          	sw	s1,4(sp)
800030e0:	00058413          	mv	s0,a1
	__ASSERT_NO_MSG(!is_idle(thread));
800030e4:	02f59863          	bne	a1,a5,80003114 <z_priq_dumb_remove+0x4c>
800030e8:	800064b7          	lui	s1,0x80006
800030ec:	800065b7          	lui	a1,0x80006
800030f0:	80006537          	lui	a0,0x80006
800030f4:	5a858593          	addi	a1,a1,1448 # 800065a8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800065a9>
800030f8:	21850513          	addi	a0,a0,536 # 80006218 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006219>
800030fc:	28c00693          	li	a3,652
80003100:	55c48613          	addi	a2,s1,1372 # 8000655c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000655d>
80003104:	d51fe0ef          	jal	ra,80001e54 <printk>
80003108:	28c00593          	li	a1,652
8000310c:	55c48513          	addi	a0,s1,1372
80003110:	d81fe0ef          	jal	ra,80001e90 <assert_post_action>
	node->prev->next = node->next;
80003114:	00442703          	lw	a4,4(s0)
80003118:	00042783          	lw	a5,0(s0)

	sys_dlist_remove(&thread->base.qnode_dlist);
}
8000311c:	00c12083          	lw	ra,12(sp)
80003120:	00412483          	lw	s1,4(sp)
80003124:	00f72023          	sw	a5,0(a4)
	node->next->prev = node->prev;
80003128:	00e7a223          	sw	a4,4(a5)
	node->next = NULL;
8000312c:	00042023          	sw	zero,0(s0)
	node->prev = NULL;
80003130:	00042223          	sw	zero,4(s0)
80003134:	00812403          	lw	s0,8(sp)
80003138:	01010113          	addi	sp,sp,16
8000313c:	00008067          	ret

80003140 <z_unpend_thread>:
{
80003140:	fe010113          	addi	sp,sp,-32
80003144:	00812c23          	sw	s0,24(sp)
80003148:	00912a23          	sw	s1,20(sp)
8000314c:	00112e23          	sw	ra,28(sp)
80003150:	01212823          	sw	s2,16(sp)
80003154:	01312623          	sw	s3,12(sp)
80003158:	00050413          	mv	s0,a0
	__asm__ volatile ("csrrc %0, mstatus, %1"
8000315c:	00800493          	li	s1,8
80003160:	3004b4f3          	csrrc	s1,mstatus,s1
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80003164:	80007937          	lui	s2,0x80007
80003168:	97890513          	addi	a0,s2,-1672 # 80006978 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006979>
	key = (mstatus & SOC_MSTATUS_IEN);
8000316c:	0084f493          	andi	s1,s1,8
80003170:	624010ef          	jal	ra,80004794 <z_spin_lock_valid>
80003174:	02051e63          	bnez	a0,800031b0 <z_unpend_thread+0x70>
80003178:	800069b7          	lui	s3,0x80006
8000317c:	800065b7          	lui	a1,0x80006
80003180:	80006537          	lui	a0,0x80006
80003184:	2fc58593          	addi	a1,a1,764 # 800062fc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800062fd>
80003188:	04e00693          	li	a3,78
8000318c:	2e498613          	addi	a2,s3,740 # 800062e4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800062e5>
80003190:	21850513          	addi	a0,a0,536 # 80006218 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006219>
80003194:	cc1fe0ef          	jal	ra,80001e54 <printk>
80003198:	80006537          	lui	a0,0x80006
8000319c:	31450513          	addi	a0,a0,788 # 80006314 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006315>
800031a0:	cb5fe0ef          	jal	ra,80001e54 <printk>
800031a4:	04e00593          	li	a1,78
800031a8:	2e498513          	addi	a0,s3,740
800031ac:	ce5fe0ef          	jal	ra,80001e90 <assert_post_action>
	z_spin_lock_set_owner(l);
800031b0:	97890513          	addi	a0,s2,-1672
800031b4:	638010ef          	jal	ra,800047ec <z_spin_lock_set_owner>
		_priq_wait_remove(&pended_on(thread)->waitq, thread);
800031b8:	00840513          	addi	a0,s0,8
800031bc:	a29ff0ef          	jal	ra,80002be4 <pended_on.isra.15>
800031c0:	00040593          	mv	a1,s0
800031c4:	f05ff0ef          	jal	ra,800030c8 <z_priq_dumb_remove>
	thread->base.thread_state &= ~_THREAD_PENDING;
800031c8:	00d44783          	lbu	a5,13(s0)
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
800031cc:	97890513          	addi	a0,s2,-1672
800031d0:	ffd7f793          	andi	a5,a5,-3
800031d4:	00f406a3          	sb	a5,13(s0)
800031d8:	5e4010ef          	jal	ra,800047bc <z_spin_unlock_valid>
800031dc:	02051e63          	bnez	a0,80003218 <z_unpend_thread+0xd8>
800031e0:	80006937          	lui	s2,0x80006
800031e4:	800065b7          	lui	a1,0x80006
800031e8:	80006537          	lui	a0,0x80006
800031ec:	32c58593          	addi	a1,a1,812 # 8000632c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000632d>
800031f0:	06100693          	li	a3,97
800031f4:	2e490613          	addi	a2,s2,740 # 800062e4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800062e5>
800031f8:	21850513          	addi	a0,a0,536 # 80006218 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006219>
800031fc:	c59fe0ef          	jal	ra,80001e54 <printk>
80003200:	80006537          	lui	a0,0x80006
80003204:	34450513          	addi	a0,a0,836 # 80006344 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006345>
80003208:	c4dfe0ef          	jal	ra,80001e54 <printk>
8000320c:	06100593          	li	a1,97
80003210:	2e490513          	addi	a0,s2,740
80003214:	c7dfe0ef          	jal	ra,80001e90 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80003218:	3004a4f3          	csrrs	s1,mstatus,s1
	thread->base.pended_on = NULL;
8000321c:	00042423          	sw	zero,8(s0)
	z_add_timeout(&th->base.timeout, z_thread_timeout, ticks);
}

static inline int z_abort_thread_timeout(struct k_thread *thread)
{
	return z_abort_timeout(&thread->base.timeout);
80003220:	01840513          	addi	a0,s0,24
}
80003224:	01812403          	lw	s0,24(sp)
80003228:	01c12083          	lw	ra,28(sp)
8000322c:	01412483          	lw	s1,20(sp)
80003230:	01012903          	lw	s2,16(sp)
80003234:	00c12983          	lw	s3,12(sp)
80003238:	02010113          	addi	sp,sp,32
8000323c:	4ad0106f          	j	80004ee8 <z_abort_timeout>

80003240 <z_priq_dumb_best>:
	return list->head == list;
80003240:	00052783          	lw	a5,0(a0)
	return sys_dlist_is_empty(list) ? NULL : list->head;
80003244:	00f51463          	bne	a0,a5,8000324c <z_priq_dumb_best+0xc>

struct k_thread *z_priq_dumb_best(sys_dlist_t *pq)
{
	struct k_thread *t = NULL;
80003248:	00000793          	li	a5,0

	if (n != NULL) {
		t = CONTAINER_OF(n, struct k_thread, base.qnode_dlist);
	}
	return t;
}
8000324c:	00078513          	mv	a0,a5
80003250:	00008067          	ret

80003254 <update_cache>:
{
80003254:	ff010113          	addi	sp,sp,-16
80003258:	00812423          	sw	s0,8(sp)
	struct k_thread *th = _priq_run_best(&_kernel.ready_q.runq);
8000325c:	80007437          	lui	s0,0x80007
{
80003260:	01212023          	sw	s2,0(sp)
80003264:	00050913          	mv	s2,a0
	struct k_thread *th = _priq_run_best(&_kernel.ready_q.runq);
80003268:	ca440513          	addi	a0,s0,-860 # 80006ca4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006ca5>
8000326c:	02450513          	addi	a0,a0,36
{
80003270:	00912223          	sw	s1,4(sp)
80003274:	00112623          	sw	ra,12(sp)
	struct k_thread *th = _priq_run_best(&_kernel.ready_q.runq);
80003278:	fc9ff0ef          	jal	ra,80003240 <z_priq_dumb_best>
	return th ? th : _current_cpu->idle_thread;
8000327c:	ca440413          	addi	s0,s0,-860
80003280:	00050493          	mv	s1,a0
80003284:	00051463          	bnez	a0,8000328c <update_cache+0x38>
80003288:	00c42483          	lw	s1,12(s0)
	if (preempt_ok != 0) {
8000328c:	06091e63          	bnez	s2,80003308 <update_cache+0xb4>
	__ASSERT(_current != NULL, "");
80003290:	00842783          	lw	a5,8(s0)
80003294:	02079e63          	bnez	a5,800032d0 <update_cache+0x7c>
80003298:	80006937          	lui	s2,0x80006
8000329c:	800065b7          	lui	a1,0x80006
800032a0:	80006537          	lui	a0,0x80006
800032a4:	58858593          	addi	a1,a1,1416 # 80006588 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006589>
800032a8:	07f00693          	li	a3,127
800032ac:	55c90613          	addi	a2,s2,1372 # 8000655c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000655d>
800032b0:	21850513          	addi	a0,a0,536 # 80006218 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006219>
800032b4:	ba1fe0ef          	jal	ra,80001e54 <printk>
800032b8:	80006537          	lui	a0,0x80006
800032bc:	29c50513          	addi	a0,a0,668 # 8000629c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000629d>
800032c0:	b95fe0ef          	jal	ra,80001e54 <printk>
800032c4:	07f00593          	li	a1,127
800032c8:	55c90513          	addi	a0,s2,1372
800032cc:	bc5fe0ef          	jal	ra,80001e90 <assert_post_action>
	if (z_is_thread_prevented_from_running(_current)) {
800032d0:	00842783          	lw	a5,8(s0)
800032d4:	00d7c703          	lbu	a4,13(a5)
800032d8:	01f77713          	andi	a4,a4,31
800032dc:	02071663          	bnez	a4,80003308 <update_cache+0xb4>
	if (is_preempt(_current) || is_metairq(th)) {
800032e0:	00e7d683          	lhu	a3,14(a5)
800032e4:	07f00713          	li	a4,127
800032e8:	02d77063          	bgeu	a4,a3,80003308 <update_cache+0xb4>
		_kernel.ready_q.cache = _current;
800032ec:	02f42023          	sw	a5,32(s0)
}
800032f0:	00c12083          	lw	ra,12(sp)
800032f4:	00812403          	lw	s0,8(sp)
800032f8:	00412483          	lw	s1,4(sp)
800032fc:	00012903          	lw	s2,0(sp)
80003300:	01010113          	addi	sp,sp,16
80003304:	00008067          	ret
		if (th != _current) {
80003308:	00842783          	lw	a5,8(s0)
8000330c:	00978463          	beq	a5,s1,80003314 <update_cache+0xc0>
			reset_time_slice();
80003310:	8a1ff0ef          	jal	ra,80002bb0 <reset_time_slice>
		_kernel.ready_q.cache = th;
80003314:	02942023          	sw	s1,32(s0)
}
80003318:	fd9ff06f          	j	800032f0 <update_cache+0x9c>

8000331c <k_sched_unlock>:
{
8000331c:	fe010113          	addi	sp,sp,-32
80003320:	01212823          	sw	s2,16(sp)
	__ASSERT(_current->base.sched_locked != 0, "");
80003324:	80007937          	lui	s2,0x80007
80003328:	ca490793          	addi	a5,s2,-860 # 80006ca4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006ca5>
8000332c:	0087a783          	lw	a5,8(a5)
{
80003330:	00112e23          	sw	ra,28(sp)
80003334:	00812c23          	sw	s0,24(sp)
	__ASSERT(_current->base.sched_locked != 0, "");
80003338:	00f7c783          	lbu	a5,15(a5)
{
8000333c:	00912a23          	sw	s1,20(sp)
80003340:	01312623          	sw	s3,12(sp)
80003344:	ca490913          	addi	s2,s2,-860
	__ASSERT(_current->base.sched_locked != 0, "");
80003348:	02079e63          	bnez	a5,80003384 <k_sched_unlock+0x68>
8000334c:	80006437          	lui	s0,0x80006
80003350:	800065b7          	lui	a1,0x80006
80003354:	80006537          	lui	a0,0x80006
80003358:	53458593          	addi	a1,a1,1332 # 80006534 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006535>
8000335c:	22100693          	li	a3,545
80003360:	55c40613          	addi	a2,s0,1372 # 8000655c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000655d>
80003364:	21850513          	addi	a0,a0,536 # 80006218 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006219>
80003368:	aedfe0ef          	jal	ra,80001e54 <printk>
8000336c:	80006537          	lui	a0,0x80006
80003370:	29c50513          	addi	a0,a0,668 # 8000629c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000629d>
80003374:	ae1fe0ef          	jal	ra,80001e54 <printk>
80003378:	22100593          	li	a1,545
8000337c:	55c40513          	addi	a0,s0,1372
80003380:	b11fe0ef          	jal	ra,80001e90 <assert_post_action>
	__ASSERT(!z_is_in_isr(), "");
80003384:	00092783          	lw	a5,0(s2)
80003388:	02078e63          	beqz	a5,800033c4 <k_sched_unlock+0xa8>
8000338c:	80006437          	lui	s0,0x80006
80003390:	800065b7          	lui	a1,0x80006
80003394:	80006537          	lui	a0,0x80006
80003398:	4f458593          	addi	a1,a1,1268 # 800064f4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800064f5>
8000339c:	22200693          	li	a3,546
800033a0:	55c40613          	addi	a2,s0,1372 # 8000655c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000655d>
800033a4:	21850513          	addi	a0,a0,536 # 80006218 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006219>
800033a8:	aadfe0ef          	jal	ra,80001e54 <printk>
800033ac:	80006537          	lui	a0,0x80006
800033b0:	29c50513          	addi	a0,a0,668 # 8000629c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000629d>
800033b4:	aa1fe0ef          	jal	ra,80001e54 <printk>
800033b8:	22200593          	li	a1,546
800033bc:	55c40513          	addi	a0,s0,1372
800033c0:	ad1fe0ef          	jal	ra,80001e90 <assert_post_action>
	__asm__ volatile ("csrrc %0, mstatus, %1"
800033c4:	00800413          	li	s0,8
800033c8:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
800033cc:	800074b7          	lui	s1,0x80007
800033d0:	97848513          	addi	a0,s1,-1672 # 80006978 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006979>
	key = (mstatus & SOC_MSTATUS_IEN);
800033d4:	00847413          	andi	s0,s0,8
800033d8:	3bc010ef          	jal	ra,80004794 <z_spin_lock_valid>
800033dc:	02051e63          	bnez	a0,80003418 <k_sched_unlock+0xfc>
800033e0:	800069b7          	lui	s3,0x80006
800033e4:	800065b7          	lui	a1,0x80006
800033e8:	80006537          	lui	a0,0x80006
800033ec:	2fc58593          	addi	a1,a1,764 # 800062fc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800062fd>
800033f0:	04e00693          	li	a3,78
800033f4:	2e498613          	addi	a2,s3,740 # 800062e4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800062e5>
800033f8:	21850513          	addi	a0,a0,536 # 80006218 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006219>
800033fc:	a59fe0ef          	jal	ra,80001e54 <printk>
80003400:	80006537          	lui	a0,0x80006
80003404:	31450513          	addi	a0,a0,788 # 80006314 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006315>
80003408:	a4dfe0ef          	jal	ra,80001e54 <printk>
8000340c:	04e00593          	li	a1,78
80003410:	2e498513          	addi	a0,s3,740
80003414:	a7dfe0ef          	jal	ra,80001e90 <assert_post_action>
	z_spin_lock_set_owner(l);
80003418:	97848513          	addi	a0,s1,-1672
8000341c:	3d0010ef          	jal	ra,800047ec <z_spin_lock_set_owner>
		++_current->base.sched_locked;
80003420:	00892703          	lw	a4,8(s2)
		update_cache(1);
80003424:	00100513          	li	a0,1
		++_current->base.sched_locked;
80003428:	00f74783          	lbu	a5,15(a4)
8000342c:	00178793          	addi	a5,a5,1
80003430:	00f707a3          	sb	a5,15(a4)
		update_cache(1);
80003434:	e21ff0ef          	jal	ra,80003254 <update_cache>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80003438:	97848513          	addi	a0,s1,-1672
8000343c:	380010ef          	jal	ra,800047bc <z_spin_unlock_valid>
80003440:	02051e63          	bnez	a0,8000347c <k_sched_unlock+0x160>
80003444:	800064b7          	lui	s1,0x80006
80003448:	800065b7          	lui	a1,0x80006
8000344c:	80006537          	lui	a0,0x80006
80003450:	32c58593          	addi	a1,a1,812 # 8000632c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000632d>
80003454:	06100693          	li	a3,97
80003458:	2e448613          	addi	a2,s1,740 # 800062e4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800062e5>
8000345c:	21850513          	addi	a0,a0,536 # 80006218 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006219>
80003460:	9f5fe0ef          	jal	ra,80001e54 <printk>
80003464:	80006537          	lui	a0,0x80006
80003468:	34450513          	addi	a0,a0,836 # 80006344 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006345>
8000346c:	9e9fe0ef          	jal	ra,80001e54 <printk>
80003470:	06100593          	li	a1,97
80003474:	2e448513          	addi	a0,s1,740
80003478:	a19fe0ef          	jal	ra,80001e90 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
8000347c:	30042473          	csrrs	s0,mstatus,s0
}
80003480:	01812403          	lw	s0,24(sp)
80003484:	01c12083          	lw	ra,28(sp)
80003488:	01412483          	lw	s1,20(sp)
8000348c:	01012903          	lw	s2,16(sp)
80003490:	00c12983          	lw	s3,12(sp)
80003494:	02010113          	addi	sp,sp,32
	z_reschedule_unlocked();
80003498:	aa9ff06f          	j	80002f40 <z_reschedule_unlocked>

8000349c <z_add_thread_to_ready_q>:
{
8000349c:	fe010113          	addi	sp,sp,-32
800034a0:	00812c23          	sw	s0,24(sp)
800034a4:	00912a23          	sw	s1,20(sp)
800034a8:	00112e23          	sw	ra,28(sp)
800034ac:	01212823          	sw	s2,16(sp)
800034b0:	01312623          	sw	s3,12(sp)
800034b4:	00050413          	mv	s0,a0
	__asm__ volatile ("csrrc %0, mstatus, %1"
800034b8:	00800493          	li	s1,8
800034bc:	3004b4f3          	csrrc	s1,mstatus,s1
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
800034c0:	80007937          	lui	s2,0x80007
800034c4:	97890513          	addi	a0,s2,-1672 # 80006978 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006979>
	key = (mstatus & SOC_MSTATUS_IEN);
800034c8:	0084f493          	andi	s1,s1,8
800034cc:	2c8010ef          	jal	ra,80004794 <z_spin_lock_valid>
800034d0:	02051e63          	bnez	a0,8000350c <z_add_thread_to_ready_q+0x70>
800034d4:	800069b7          	lui	s3,0x80006
800034d8:	800065b7          	lui	a1,0x80006
800034dc:	80006537          	lui	a0,0x80006
800034e0:	2fc58593          	addi	a1,a1,764 # 800062fc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800062fd>
800034e4:	04e00693          	li	a3,78
800034e8:	2e498613          	addi	a2,s3,740 # 800062e4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800062e5>
800034ec:	21850513          	addi	a0,a0,536 # 80006218 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006219>
800034f0:	965fe0ef          	jal	ra,80001e54 <printk>
800034f4:	80006537          	lui	a0,0x80006
800034f8:	31450513          	addi	a0,a0,788 # 80006314 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006315>
800034fc:	959fe0ef          	jal	ra,80001e54 <printk>
80003500:	04e00593          	li	a1,78
80003504:	2e498513          	addi	a0,s3,740
80003508:	989fe0ef          	jal	ra,80001e90 <assert_post_action>
	z_spin_lock_set_owner(l);
8000350c:	97890513          	addi	a0,s2,-1672
80003510:	2dc010ef          	jal	ra,800047ec <z_spin_lock_set_owner>
	return thread == _idle_thread;
80003514:	800077b7          	lui	a5,0x80007
	__ASSERT_NO_MSG(!is_idle(thread));
80003518:	8ac7a783          	lw	a5,-1876(a5) # 800068ac <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800068ad>
8000351c:	02f41863          	bne	s0,a5,8000354c <z_add_thread_to_ready_q+0xb0>
80003520:	800069b7          	lui	s3,0x80006
80003524:	800065b7          	lui	a1,0x80006
80003528:	80006537          	lui	a0,0x80006
8000352c:	5a858593          	addi	a1,a1,1448 # 800065a8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800065a9>
80003530:	21850513          	addi	a0,a0,536 # 80006218 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006219>
80003534:	27600693          	li	a3,630
80003538:	55c98613          	addi	a2,s3,1372 # 8000655c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000655d>
8000353c:	919fe0ef          	jal	ra,80001e54 <printk>
80003540:	27600593          	li	a1,630
80003544:	55c98513          	addi	a0,s3,1372
80003548:	949fe0ef          	jal	ra,80001e90 <assert_post_action>
	return list->head == list;
8000354c:	80007737          	lui	a4,0x80007
80003550:	ca470693          	addi	a3,a4,-860 # 80006ca4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006ca5>
80003554:	0246a783          	lw	a5,36(a3)
80003558:	0286a603          	lw	a2,40(a3)
8000355c:	800076b7          	lui	a3,0x80007
80003560:	cc868693          	addi	a3,a3,-824 # 80006cc8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006cc9>
80003564:	ca470713          	addi	a4,a4,-860
	return sys_dlist_is_empty(list) ? NULL : list->head;
80003568:	0ad78663          	beq	a5,a3,80003614 <z_add_thread_to_ready_q+0x178>
	SYS_DLIST_FOR_EACH_CONTAINER(pq, t, base.qnode_dlist) {
8000356c:	0a078463          	beqz	a5,80003614 <z_add_thread_to_ready_q+0x178>
	if (t1->base.prio < t2->base.prio) {
80003570:	00e40583          	lb	a1,14(s0)
80003574:	00e78503          	lb	a0,14(a5)
80003578:	08a5d863          	bge	a1,a0,80003608 <z_add_thread_to_ready_q+0x16c>
	node->prev = successor->prev;
8000357c:	0047a703          	lw	a4,4(a5)
	node->next = successor;
80003580:	00f42023          	sw	a5,0(s0)
	node->prev = successor->prev;
80003584:	00e42223          	sw	a4,4(s0)
	successor->prev->next = node;
80003588:	00872023          	sw	s0,0(a4)
	successor->prev = node;
8000358c:	0087a223          	sw	s0,4(a5)
	thread->base.thread_state |= states;
80003590:	00d44783          	lbu	a5,13(s0)
		update_cache(0);
80003594:	00000513          	li	a0,0
80003598:	0407e793          	ori	a5,a5,64
8000359c:	00f406a3          	sb	a5,13(s0)
800035a0:	cb5ff0ef          	jal	ra,80003254 <update_cache>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
800035a4:	97890513          	addi	a0,s2,-1672
800035a8:	214010ef          	jal	ra,800047bc <z_spin_unlock_valid>
800035ac:	02051e63          	bnez	a0,800035e8 <z_add_thread_to_ready_q+0x14c>
800035b0:	80006437          	lui	s0,0x80006
800035b4:	800065b7          	lui	a1,0x80006
800035b8:	80006537          	lui	a0,0x80006
800035bc:	32c58593          	addi	a1,a1,812 # 8000632c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000632d>
800035c0:	06100693          	li	a3,97
800035c4:	2e440613          	addi	a2,s0,740 # 800062e4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800062e5>
800035c8:	21850513          	addi	a0,a0,536 # 80006218 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006219>
800035cc:	889fe0ef          	jal	ra,80001e54 <printk>
800035d0:	80006537          	lui	a0,0x80006
800035d4:	34450513          	addi	a0,a0,836 # 80006344 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006345>
800035d8:	87dfe0ef          	jal	ra,80001e54 <printk>
800035dc:	06100593          	li	a1,97
800035e0:	2e440513          	addi	a0,s0,740
800035e4:	8adfe0ef          	jal	ra,80001e90 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
800035e8:	3004a4f3          	csrrs	s1,mstatus,s1
}
800035ec:	01c12083          	lw	ra,28(sp)
800035f0:	01812403          	lw	s0,24(sp)
800035f4:	01412483          	lw	s1,20(sp)
800035f8:	01012903          	lw	s2,16(sp)
800035fc:	00c12983          	lw	s3,12(sp)
80003600:	02010113          	addi	sp,sp,32
80003604:	00008067          	ret
	return (node == list->tail) ? NULL : node->next;
80003608:	00f60663          	beq	a2,a5,80003614 <z_add_thread_to_ready_q+0x178>
8000360c:	0007a783          	lw	a5,0(a5)
	SYS_DLIST_FOR_EACH_CONTAINER(pq, t, base.qnode_dlist) {
80003610:	f60792e3          	bnez	a5,80003574 <z_add_thread_to_ready_q+0xd8>
	node->prev = list->tail;
80003614:	00c42223          	sw	a2,4(s0)
	list->tail->next = node;
80003618:	02872783          	lw	a5,40(a4)
	node->next = list;
8000361c:	00d42023          	sw	a3,0(s0)
	list->tail->next = node;
80003620:	0087a023          	sw	s0,0(a5)
	list->tail = node;
80003624:	02872423          	sw	s0,40(a4)
80003628:	f69ff06f          	j	80003590 <z_add_thread_to_ready_q+0xf4>

8000362c <z_thread_timeout>:
	if (th->base.pended_on != NULL) {
8000362c:	ff052783          	lw	a5,-16(a0)
{
80003630:	fe010113          	addi	sp,sp,-32
80003634:	00812c23          	sw	s0,24(sp)
80003638:	01312623          	sw	s3,12(sp)
8000363c:	00112e23          	sw	ra,28(sp)
80003640:	00912a23          	sw	s1,20(sp)
80003644:	01212823          	sw	s2,16(sp)
80003648:	01412423          	sw	s4,8(sp)
8000364c:	00050413          	mv	s0,a0
	struct k_thread *th = CONTAINER_OF(to, struct k_thread, base.timeout);
80003650:	fe850993          	addi	s3,a0,-24
	if (th->base.pended_on != NULL) {
80003654:	0c078463          	beqz	a5,8000371c <z_thread_timeout+0xf0>
	__asm__ volatile ("csrrc %0, mstatus, %1"
80003658:	00800493          	li	s1,8
8000365c:	3004b4f3          	csrrc	s1,mstatus,s1
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80003660:	80007937          	lui	s2,0x80007
80003664:	97890513          	addi	a0,s2,-1672 # 80006978 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006979>
	key = (mstatus & SOC_MSTATUS_IEN);
80003668:	0084f493          	andi	s1,s1,8
8000366c:	128010ef          	jal	ra,80004794 <z_spin_lock_valid>
80003670:	02051e63          	bnez	a0,800036ac <z_thread_timeout+0x80>
80003674:	80006a37          	lui	s4,0x80006
80003678:	800065b7          	lui	a1,0x80006
8000367c:	80006537          	lui	a0,0x80006
80003680:	2fc58593          	addi	a1,a1,764 # 800062fc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800062fd>
80003684:	04e00693          	li	a3,78
80003688:	2e4a0613          	addi	a2,s4,740 # 800062e4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800062e5>
8000368c:	21850513          	addi	a0,a0,536 # 80006218 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006219>
80003690:	fc4fe0ef          	jal	ra,80001e54 <printk>
80003694:	80006537          	lui	a0,0x80006
80003698:	31450513          	addi	a0,a0,788 # 80006314 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006315>
8000369c:	fb8fe0ef          	jal	ra,80001e54 <printk>
800036a0:	04e00593          	li	a1,78
800036a4:	2e4a0513          	addi	a0,s4,740
800036a8:	fe8fe0ef          	jal	ra,80001e90 <assert_post_action>
	z_spin_lock_set_owner(l);
800036ac:	97890513          	addi	a0,s2,-1672
800036b0:	13c010ef          	jal	ra,800047ec <z_spin_lock_set_owner>
		_priq_wait_remove(&pended_on(thread)->waitq, thread);
800036b4:	ff040513          	addi	a0,s0,-16
800036b8:	d2cff0ef          	jal	ra,80002be4 <pended_on.isra.15>
800036bc:	00098593          	mv	a1,s3
800036c0:	a09ff0ef          	jal	ra,800030c8 <z_priq_dumb_remove>
	thread->base.thread_state &= ~_THREAD_PENDING;
800036c4:	ff544783          	lbu	a5,-11(s0)
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
800036c8:	97890513          	addi	a0,s2,-1672
800036cc:	ffd7f793          	andi	a5,a5,-3
800036d0:	fef40aa3          	sb	a5,-11(s0)
800036d4:	0e8010ef          	jal	ra,800047bc <z_spin_unlock_valid>
800036d8:	02051e63          	bnez	a0,80003714 <z_thread_timeout+0xe8>
800036dc:	80006937          	lui	s2,0x80006
800036e0:	800065b7          	lui	a1,0x80006
800036e4:	80006537          	lui	a0,0x80006
800036e8:	32c58593          	addi	a1,a1,812 # 8000632c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000632d>
800036ec:	06100693          	li	a3,97
800036f0:	2e490613          	addi	a2,s2,740 # 800062e4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800062e5>
800036f4:	21850513          	addi	a0,a0,536 # 80006218 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006219>
800036f8:	f5cfe0ef          	jal	ra,80001e54 <printk>
800036fc:	80006537          	lui	a0,0x80006
80003700:	34450513          	addi	a0,a0,836 # 80006344 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006345>
80003704:	f50fe0ef          	jal	ra,80001e54 <printk>
80003708:	06100593          	li	a1,97
8000370c:	2e490513          	addi	a0,s2,740
80003710:	f80fe0ef          	jal	ra,80001e90 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80003714:	3004a4f3          	csrrs	s1,mstatus,s1
	thread->base.pended_on = NULL;
80003718:	fe042823          	sw	zero,-16(s0)
	thread->base.thread_state &= ~_THREAD_SUSPENDED;
8000371c:	ff544783          	lbu	a5,-11(s0)
	if (z_is_thread_ready(thread)) {
80003720:	00098513          	mv	a0,s3
	thread->base.thread_state &= ~_THREAD_SUSPENDED;
80003724:	feb7f793          	andi	a5,a5,-21
80003728:	fef40aa3          	sb	a5,-11(s0)
	if (z_is_thread_ready(thread)) {
8000372c:	c64ff0ef          	jal	ra,80002b90 <z_is_thread_ready>
80003730:	02050463          	beqz	a0,80003758 <z_thread_timeout+0x12c>
}
80003734:	01812403          	lw	s0,24(sp)
80003738:	01c12083          	lw	ra,28(sp)
8000373c:	01412483          	lw	s1,20(sp)
80003740:	01012903          	lw	s2,16(sp)
80003744:	00812a03          	lw	s4,8(sp)
		z_add_thread_to_ready_q(thread);
80003748:	00098513          	mv	a0,s3
8000374c:	00c12983          	lw	s3,12(sp)
80003750:	02010113          	addi	sp,sp,32
80003754:	d49ff06f          	j	8000349c <z_add_thread_to_ready_q>
80003758:	01c12083          	lw	ra,28(sp)
8000375c:	01812403          	lw	s0,24(sp)
80003760:	01412483          	lw	s1,20(sp)
80003764:	01012903          	lw	s2,16(sp)
80003768:	00c12983          	lw	s3,12(sp)
8000376c:	00812a03          	lw	s4,8(sp)
80003770:	02010113          	addi	sp,sp,32
80003774:	00008067          	ret

80003778 <z_move_thread_to_end_of_prio_q>:
{
80003778:	fe010113          	addi	sp,sp,-32
8000377c:	00812c23          	sw	s0,24(sp)
80003780:	01212823          	sw	s2,16(sp)
80003784:	00112e23          	sw	ra,28(sp)
80003788:	00912a23          	sw	s1,20(sp)
8000378c:	01312623          	sw	s3,12(sp)
80003790:	01412423          	sw	s4,8(sp)
80003794:	01512223          	sw	s5,4(sp)
80003798:	00050413          	mv	s0,a0
	__asm__ volatile ("csrrc %0, mstatus, %1"
8000379c:	00800913          	li	s2,8
800037a0:	30093973          	csrrc	s2,mstatus,s2
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
800037a4:	800079b7          	lui	s3,0x80007
800037a8:	97898513          	addi	a0,s3,-1672 # 80006978 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006979>
	key = (mstatus & SOC_MSTATUS_IEN);
800037ac:	00897913          	andi	s2,s2,8
800037b0:	7e5000ef          	jal	ra,80004794 <z_spin_lock_valid>
800037b4:	02051e63          	bnez	a0,800037f0 <z_move_thread_to_end_of_prio_q+0x78>
800037b8:	800064b7          	lui	s1,0x80006
800037bc:	800065b7          	lui	a1,0x80006
800037c0:	80006537          	lui	a0,0x80006
800037c4:	2fc58593          	addi	a1,a1,764 # 800062fc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800062fd>
800037c8:	04e00693          	li	a3,78
800037cc:	2e448613          	addi	a2,s1,740 # 800062e4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800062e5>
800037d0:	21850513          	addi	a0,a0,536 # 80006218 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006219>
800037d4:	e80fe0ef          	jal	ra,80001e54 <printk>
800037d8:	80006537          	lui	a0,0x80006
800037dc:	31450513          	addi	a0,a0,788 # 80006314 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006315>
800037e0:	e74fe0ef          	jal	ra,80001e54 <printk>
800037e4:	04e00593          	li	a1,78
800037e8:	2e448513          	addi	a0,s1,740
800037ec:	ea4fe0ef          	jal	ra,80001e90 <assert_post_action>
	z_spin_lock_set_owner(l);
800037f0:	97898513          	addi	a0,s3,-1672
800037f4:	7f9000ef          	jal	ra,800047ec <z_spin_lock_set_owner>
		_priq_run_remove(&_kernel.ready_q.runq, thread);
800037f8:	800074b7          	lui	s1,0x80007
800037fc:	ca448513          	addi	a0,s1,-860 # 80006ca4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006ca5>
80003800:	00040593          	mv	a1,s0
80003804:	02450513          	addi	a0,a0,36
80003808:	8c1ff0ef          	jal	ra,800030c8 <z_priq_dumb_remove>
	return thread == _idle_thread;
8000380c:	800077b7          	lui	a5,0x80007
	__ASSERT_NO_MSG(!is_idle(thread));
80003810:	8ac7a783          	lw	a5,-1876(a5) # 800068ac <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800068ad>
80003814:	80007a37          	lui	s4,0x80007
80003818:	ca448493          	addi	s1,s1,-860
8000381c:	cc8a0a13          	addi	s4,s4,-824 # 80006cc8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006cc9>
80003820:	02f41863          	bne	s0,a5,80003850 <z_move_thread_to_end_of_prio_q+0xd8>
80003824:	80006ab7          	lui	s5,0x80006
80003828:	800065b7          	lui	a1,0x80006
8000382c:	80006537          	lui	a0,0x80006
80003830:	5a858593          	addi	a1,a1,1448 # 800065a8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800065a9>
80003834:	21850513          	addi	a0,a0,536 # 80006218 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006219>
80003838:	27600693          	li	a3,630
8000383c:	55ca8613          	addi	a2,s5,1372 # 8000655c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000655d>
80003840:	e14fe0ef          	jal	ra,80001e54 <printk>
80003844:	27600593          	li	a1,630
80003848:	55ca8513          	addi	a0,s5,1372
8000384c:	e44fe0ef          	jal	ra,80001e90 <assert_post_action>
	return list->head == list;
80003850:	0244a783          	lw	a5,36(s1)
80003854:	0284a703          	lw	a4,40(s1)
	return sys_dlist_is_empty(list) ? NULL : list->head;
80003858:	0b478e63          	beq	a5,s4,80003914 <z_move_thread_to_end_of_prio_q+0x19c>
	SYS_DLIST_FOR_EACH_CONTAINER(pq, t, base.qnode_dlist) {
8000385c:	0a078c63          	beqz	a5,80003914 <z_move_thread_to_end_of_prio_q+0x19c>
	if (t1->base.prio < t2->base.prio) {
80003860:	00e40683          	lb	a3,14(s0)
80003864:	00e78603          	lb	a2,14(a5)
80003868:	0ac6d063          	bge	a3,a2,80003908 <z_move_thread_to_end_of_prio_q+0x190>
	node->prev = successor->prev;
8000386c:	0047a703          	lw	a4,4(a5)
	node->next = successor;
80003870:	00f42023          	sw	a5,0(s0)
	node->prev = successor->prev;
80003874:	00e42223          	sw	a4,4(s0)
	successor->prev->next = node;
80003878:	00872023          	sw	s0,0(a4)
	successor->prev = node;
8000387c:	0087a223          	sw	s0,4(a5)
	thread->base.thread_state |= states;
80003880:	00d44783          	lbu	a5,13(s0)
		update_cache(thread == _current);
80003884:	0084a503          	lw	a0,8(s1)
80003888:	0407e793          	ori	a5,a5,64
8000388c:	40850533          	sub	a0,a0,s0
80003890:	00153513          	seqz	a0,a0
80003894:	00f406a3          	sb	a5,13(s0)
80003898:	9bdff0ef          	jal	ra,80003254 <update_cache>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
8000389c:	97898513          	addi	a0,s3,-1672
800038a0:	71d000ef          	jal	ra,800047bc <z_spin_unlock_valid>
800038a4:	02051e63          	bnez	a0,800038e0 <z_move_thread_to_end_of_prio_q+0x168>
800038a8:	80006437          	lui	s0,0x80006
800038ac:	800065b7          	lui	a1,0x80006
800038b0:	80006537          	lui	a0,0x80006
800038b4:	32c58593          	addi	a1,a1,812 # 8000632c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000632d>
800038b8:	06100693          	li	a3,97
800038bc:	2e440613          	addi	a2,s0,740 # 800062e4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800062e5>
800038c0:	21850513          	addi	a0,a0,536 # 80006218 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006219>
800038c4:	d90fe0ef          	jal	ra,80001e54 <printk>
800038c8:	80006537          	lui	a0,0x80006
800038cc:	34450513          	addi	a0,a0,836 # 80006344 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006345>
800038d0:	d84fe0ef          	jal	ra,80001e54 <printk>
800038d4:	06100593          	li	a1,97
800038d8:	2e440513          	addi	a0,s0,740
800038dc:	db4fe0ef          	jal	ra,80001e90 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
800038e0:	30092973          	csrrs	s2,mstatus,s2
}
800038e4:	01c12083          	lw	ra,28(sp)
800038e8:	01812403          	lw	s0,24(sp)
800038ec:	01412483          	lw	s1,20(sp)
800038f0:	01012903          	lw	s2,16(sp)
800038f4:	00c12983          	lw	s3,12(sp)
800038f8:	00812a03          	lw	s4,8(sp)
800038fc:	00412a83          	lw	s5,4(sp)
80003900:	02010113          	addi	sp,sp,32
80003904:	00008067          	ret
	return (node == list->tail) ? NULL : node->next;
80003908:	00e78663          	beq	a5,a4,80003914 <z_move_thread_to_end_of_prio_q+0x19c>
8000390c:	0007a783          	lw	a5,0(a5)
	SYS_DLIST_FOR_EACH_CONTAINER(pq, t, base.qnode_dlist) {
80003910:	f4079ae3          	bnez	a5,80003864 <z_move_thread_to_end_of_prio_q+0xec>
	node->prev = list->tail;
80003914:	00e42223          	sw	a4,4(s0)
	list->tail->next = node;
80003918:	0284a783          	lw	a5,40(s1)
	node->next = list;
8000391c:	01442023          	sw	s4,0(s0)
	list->tail->next = node;
80003920:	0087a023          	sw	s0,0(a5)
	list->tail = node;
80003924:	0284a423          	sw	s0,40(s1)
80003928:	f59ff06f          	j	80003880 <z_move_thread_to_end_of_prio_q+0x108>

8000392c <z_time_slice>:
	if (slice_time && sliceable(_current)) {
8000392c:	800077b7          	lui	a5,0x80007
80003930:	9807a783          	lw	a5,-1664(a5) # 80006980 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006981>
80003934:	06078663          	beqz	a5,800039a0 <z_time_slice+0x74>
80003938:	800077b7          	lui	a5,0x80007
8000393c:	ca478793          	addi	a5,a5,-860 # 80006ca4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006ca5>
80003940:	0087a703          	lw	a4,8(a5)
		&& !z_is_thread_timeout_active(t);
80003944:	07f00693          	li	a3,127
80003948:	00e75603          	lhu	a2,14(a4)
8000394c:	04c6ea63          	bltu	a3,a2,800039a0 <z_time_slice+0x74>
		&& !z_is_prio_higher(t->base.prio, slice_max_prio)
80003950:	800076b7          	lui	a3,0x80007
80003954:	00e70603          	lb	a2,14(a4)
80003958:	97c6a683          	lw	a3,-1668(a3) # 8000697c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000697d>
8000395c:	04d64263          	blt	a2,a3,800039a0 <z_time_slice+0x74>
	return thread == _idle_thread;
80003960:	800076b7          	lui	a3,0x80007
		&& !is_idle(t)
80003964:	8ac6a683          	lw	a3,-1876(a3) # 800068ac <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800068ad>
80003968:	02d70c63          	beq	a4,a3,800039a0 <z_time_slice+0x74>
		&& !z_is_thread_timeout_active(t);
8000396c:	01872683          	lw	a3,24(a4)
80003970:	02069863          	bnez	a3,800039a0 <z_time_slice+0x74>
		if (ticks >= _current_cpu->slice_ticks) {
80003974:	0107a683          	lw	a3,16(a5)
80003978:	02d54063          	blt	a0,a3,80003998 <z_time_slice+0x6c>
{
8000397c:	ff010113          	addi	sp,sp,-16
			z_move_thread_to_end_of_prio_q(_current);
80003980:	00070513          	mv	a0,a4
{
80003984:	00112623          	sw	ra,12(sp)
			z_move_thread_to_end_of_prio_q(_current);
80003988:	df1ff0ef          	jal	ra,80003778 <z_move_thread_to_end_of_prio_q>
}
8000398c:	00c12083          	lw	ra,12(sp)
80003990:	01010113          	addi	sp,sp,16
			reset_time_slice();
80003994:	a1cff06f          	j	80002bb0 <reset_time_slice>
			_current_cpu->slice_ticks -= ticks;
80003998:	40a686b3          	sub	a3,a3,a0
8000399c:	00d7a823          	sw	a3,16(a5)
800039a0:	00008067          	ret

800039a4 <z_remove_thread_from_ready_q>:
{
800039a4:	fe010113          	addi	sp,sp,-32
800039a8:	00812c23          	sw	s0,24(sp)
800039ac:	01312623          	sw	s3,12(sp)
800039b0:	00112e23          	sw	ra,28(sp)
800039b4:	00912a23          	sw	s1,20(sp)
800039b8:	01212823          	sw	s2,16(sp)
800039bc:	00050993          	mv	s3,a0
	__asm__ volatile ("csrrc %0, mstatus, %1"
800039c0:	00800413          	li	s0,8
800039c4:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
800039c8:	800074b7          	lui	s1,0x80007
800039cc:	97848513          	addi	a0,s1,-1672 # 80006978 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006979>
	key = (mstatus & SOC_MSTATUS_IEN);
800039d0:	00847413          	andi	s0,s0,8
800039d4:	5c1000ef          	jal	ra,80004794 <z_spin_lock_valid>
800039d8:	02051e63          	bnez	a0,80003a14 <z_remove_thread_from_ready_q+0x70>
800039dc:	80006937          	lui	s2,0x80006
800039e0:	800065b7          	lui	a1,0x80006
800039e4:	80006537          	lui	a0,0x80006
800039e8:	2fc58593          	addi	a1,a1,764 # 800062fc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800062fd>
800039ec:	04e00693          	li	a3,78
800039f0:	2e490613          	addi	a2,s2,740 # 800062e4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800062e5>
800039f4:	21850513          	addi	a0,a0,536 # 80006218 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006219>
800039f8:	c5cfe0ef          	jal	ra,80001e54 <printk>
800039fc:	80006537          	lui	a0,0x80006
80003a00:	31450513          	addi	a0,a0,788 # 80006314 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006315>
80003a04:	c50fe0ef          	jal	ra,80001e54 <printk>
80003a08:	04e00593          	li	a1,78
80003a0c:	2e490513          	addi	a0,s2,740
80003a10:	c80fe0ef          	jal	ra,80001e90 <assert_post_action>
	z_spin_lock_set_owner(l);
80003a14:	97848513          	addi	a0,s1,-1672
80003a18:	5d5000ef          	jal	ra,800047ec <z_spin_lock_set_owner>
		if (z_is_thread_queued(thread)) {
80003a1c:	00d9c783          	lbu	a5,13(s3)
80003a20:	80007937          	lui	s2,0x80007
80003a24:	ca490913          	addi	s2,s2,-860 # 80006ca4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006ca5>
80003a28:	0407f793          	andi	a5,a5,64
80003a2c:	00078e63          	beqz	a5,80003a48 <z_remove_thread_from_ready_q+0xa4>
			_priq_run_remove(&_kernel.ready_q.runq, thread);
80003a30:	00098593          	mv	a1,s3
80003a34:	02490513          	addi	a0,s2,36
80003a38:	e90ff0ef          	jal	ra,800030c8 <z_priq_dumb_remove>
	thread->base.thread_state &= ~states;
80003a3c:	00d9c783          	lbu	a5,13(s3)
80003a40:	fbf7f793          	andi	a5,a5,-65
80003a44:	00f986a3          	sb	a5,13(s3)
		update_cache(thread == _current);
80003a48:	00892503          	lw	a0,8(s2)
80003a4c:	41350533          	sub	a0,a0,s3
80003a50:	00153513          	seqz	a0,a0
80003a54:	801ff0ef          	jal	ra,80003254 <update_cache>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80003a58:	97848513          	addi	a0,s1,-1672
80003a5c:	561000ef          	jal	ra,800047bc <z_spin_unlock_valid>
80003a60:	02051e63          	bnez	a0,80003a9c <z_remove_thread_from_ready_q+0xf8>
80003a64:	800064b7          	lui	s1,0x80006
80003a68:	800065b7          	lui	a1,0x80006
80003a6c:	80006537          	lui	a0,0x80006
80003a70:	32c58593          	addi	a1,a1,812 # 8000632c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000632d>
80003a74:	06100693          	li	a3,97
80003a78:	2e448613          	addi	a2,s1,740 # 800062e4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800062e5>
80003a7c:	21850513          	addi	a0,a0,536 # 80006218 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006219>
80003a80:	bd4fe0ef          	jal	ra,80001e54 <printk>
80003a84:	80006537          	lui	a0,0x80006
80003a88:	34450513          	addi	a0,a0,836 # 80006344 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006345>
80003a8c:	bc8fe0ef          	jal	ra,80001e54 <printk>
80003a90:	06100593          	li	a1,97
80003a94:	2e448513          	addi	a0,s1,740
80003a98:	bf8fe0ef          	jal	ra,80001e90 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80003a9c:	30042473          	csrrs	s0,mstatus,s0
}
80003aa0:	01c12083          	lw	ra,28(sp)
80003aa4:	01812403          	lw	s0,24(sp)
80003aa8:	01412483          	lw	s1,20(sp)
80003aac:	01012903          	lw	s2,16(sp)
80003ab0:	00c12983          	lw	s3,12(sp)
80003ab4:	02010113          	addi	sp,sp,32
80003ab8:	00008067          	ret

80003abc <pend>:
{
80003abc:	fe010113          	addi	sp,sp,-32
80003ac0:	00812c23          	sw	s0,24(sp)
80003ac4:	00912a23          	sw	s1,20(sp)
80003ac8:	00050413          	mv	s0,a0
80003acc:	01212823          	sw	s2,16(sp)
80003ad0:	00112e23          	sw	ra,28(sp)
80003ad4:	01312623          	sw	s3,12(sp)
80003ad8:	00058493          	mv	s1,a1
80003adc:	00060913          	mv	s2,a2
	z_remove_thread_from_ready_q(thread);
80003ae0:	ec5ff0ef          	jal	ra,800039a4 <z_remove_thread_from_ready_q>
	thread->base.thread_state |= _THREAD_PENDING;
80003ae4:	00d44783          	lbu	a5,13(s0)
80003ae8:	0027e793          	ori	a5,a5,2
80003aec:	00f406a3          	sb	a5,13(s0)
	if (wait_q != NULL) {
80003af0:	06048663          	beqz	s1,80003b5c <pend+0xa0>
	return thread == _idle_thread;
80003af4:	800077b7          	lui	a5,0x80007
	__ASSERT_NO_MSG(!is_idle(thread));
80003af8:	8ac7a783          	lw	a5,-1876(a5) # 800068ac <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800068ad>
		thread->base.pended_on = wait_q;
80003afc:	00942423          	sw	s1,8(s0)
	__ASSERT_NO_MSG(!is_idle(thread));
80003b00:	02f41863          	bne	s0,a5,80003b30 <pend+0x74>
80003b04:	800069b7          	lui	s3,0x80006
80003b08:	800065b7          	lui	a1,0x80006
80003b0c:	80006537          	lui	a0,0x80006
80003b10:	5a858593          	addi	a1,a1,1448 # 800065a8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800065a9>
80003b14:	21850513          	addi	a0,a0,536 # 80006218 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006219>
80003b18:	27600693          	li	a3,630
80003b1c:	55c98613          	addi	a2,s3,1372 # 8000655c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000655d>
80003b20:	b34fe0ef          	jal	ra,80001e54 <printk>
80003b24:	27600593          	li	a1,630
80003b28:	55c98513          	addi	a0,s3,1372
80003b2c:	b64fe0ef          	jal	ra,80001e90 <assert_post_action>
	return list->head == list;
80003b30:	0004a783          	lw	a5,0(s1)
	return sys_dlist_is_empty(list) ? NULL : list->head;
80003b34:	06f48c63          	beq	s1,a5,80003bac <pend+0xf0>
	SYS_DLIST_FOR_EACH_CONTAINER(pq, t, base.qnode_dlist) {
80003b38:	06078a63          	beqz	a5,80003bac <pend+0xf0>
	if (t1->base.prio < t2->base.prio) {
80003b3c:	00e40703          	lb	a4,14(s0)
80003b40:	00e78683          	lb	a3,14(a5)
80003b44:	04d75c63          	bge	a4,a3,80003b9c <pend+0xe0>
	node->prev = successor->prev;
80003b48:	0047a703          	lw	a4,4(a5)
	node->next = successor;
80003b4c:	00f42023          	sw	a5,0(s0)
	node->prev = successor->prev;
80003b50:	00e42223          	sw	a4,4(s0)
	successor->prev->next = node;
80003b54:	00872023          	sw	s0,0(a4)
	successor->prev = node;
80003b58:	0087a223          	sw	s0,4(a5)
	if (timeout != K_FOREVER) {
80003b5c:	fff00793          	li	a5,-1
80003b60:	06f90463          	beq	s2,a5,80003bc8 <pend+0x10c>
80003b64:	00990913          	addi	s2,s2,9
80003b68:	00a00613          	li	a2,10
80003b6c:	02c94633          	div	a2,s2,a2
	z_add_timeout(&th->base.timeout, z_thread_timeout, ticks);
80003b70:	01840513          	addi	a0,s0,24
}
80003b74:	01812403          	lw	s0,24(sp)
80003b78:	01c12083          	lw	ra,28(sp)
80003b7c:	01412483          	lw	s1,20(sp)
80003b80:	01012903          	lw	s2,16(sp)
80003b84:	00c12983          	lw	s3,12(sp)
80003b88:	800035b7          	lui	a1,0x80003
80003b8c:	62c58593          	addi	a1,a1,1580 # 8000362c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000362d>
80003b90:	02010113          	addi	sp,sp,32
80003b94:	00160613          	addi	a2,a2,1
80003b98:	1240106f          	j	80004cbc <z_add_timeout>
	return (node == list->tail) ? NULL : node->next;
80003b9c:	0044a683          	lw	a3,4(s1)
80003ba0:	00d78663          	beq	a5,a3,80003bac <pend+0xf0>
80003ba4:	0007a783          	lw	a5,0(a5)
	SYS_DLIST_FOR_EACH_CONTAINER(pq, t, base.qnode_dlist) {
80003ba8:	f8079ce3          	bnez	a5,80003b40 <pend+0x84>
	node->prev = list->tail;
80003bac:	0044a783          	lw	a5,4(s1)
	node->next = list;
80003bb0:	00942023          	sw	s1,0(s0)
	node->prev = list->tail;
80003bb4:	00f42223          	sw	a5,4(s0)
	list->tail->next = node;
80003bb8:	0044a783          	lw	a5,4(s1)
80003bbc:	0087a023          	sw	s0,0(a5)
	list->tail = node;
80003bc0:	0084a223          	sw	s0,4(s1)
80003bc4:	f99ff06f          	j	80003b5c <pend+0xa0>
}
80003bc8:	01c12083          	lw	ra,28(sp)
80003bcc:	01812403          	lw	s0,24(sp)
80003bd0:	01412483          	lw	s1,20(sp)
80003bd4:	01012903          	lw	s2,16(sp)
80003bd8:	00c12983          	lw	s3,12(sp)
80003bdc:	02010113          	addi	sp,sp,32
80003be0:	00008067          	ret

80003be4 <z_pend_curr_irqlock>:
{
80003be4:	ff010113          	addi	sp,sp,-16
	pend(_current, wait_q, timeout);
80003be8:	800077b7          	lui	a5,0x80007
{
80003bec:	00812423          	sw	s0,8(sp)
80003bf0:	00050413          	mv	s0,a0
	pend(_current, wait_q, timeout);
80003bf4:	cac7a503          	lw	a0,-852(a5) # 80006cac <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006cad>
{
80003bf8:	00112623          	sw	ra,12(sp)
	pend(_current, wait_q, timeout);
80003bfc:	ec1ff0ef          	jal	ra,80003abc <pend>
80003c00:	00040513          	mv	a0,s0
}
80003c04:	00812403          	lw	s0,8(sp)
80003c08:	00c12083          	lw	ra,12(sp)
80003c0c:	01010113          	addi	sp,sp,16
80003c10:	e28fc06f          	j	80000238 <__swap>

80003c14 <z_pend_curr>:
{
80003c14:	ff010113          	addi	sp,sp,-16
	pend(_current, wait_q, timeout);
80003c18:	800077b7          	lui	a5,0x80007
{
80003c1c:	00812423          	sw	s0,8(sp)
80003c20:	00050413          	mv	s0,a0
	pend(_current, wait_q, timeout);
80003c24:	cac7a503          	lw	a0,-852(a5) # 80006cac <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006cad>
{
80003c28:	00912223          	sw	s1,4(sp)
80003c2c:	00058493          	mv	s1,a1
80003c30:	00060593          	mv	a1,a2
	pend(_current, wait_q, timeout);
80003c34:	00068613          	mv	a2,a3
{
80003c38:	00112623          	sw	ra,12(sp)
	pend(_current, wait_q, timeout);
80003c3c:	e81ff0ef          	jal	ra,80003abc <pend>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80003c40:	00040513          	mv	a0,s0
80003c44:	379000ef          	jal	ra,800047bc <z_spin_unlock_valid>
80003c48:	02051e63          	bnez	a0,80003c84 <z_pend_curr+0x70>
80003c4c:	80006437          	lui	s0,0x80006
80003c50:	800065b7          	lui	a1,0x80006
80003c54:	80006537          	lui	a0,0x80006
80003c58:	32c58593          	addi	a1,a1,812 # 8000632c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000632d>
80003c5c:	07800693          	li	a3,120
80003c60:	2e440613          	addi	a2,s0,740 # 800062e4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800062e5>
80003c64:	21850513          	addi	a0,a0,536 # 80006218 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006219>
80003c68:	9ecfe0ef          	jal	ra,80001e54 <printk>
80003c6c:	80006537          	lui	a0,0x80006
80003c70:	34450513          	addi	a0,a0,836 # 80006344 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006345>
80003c74:	9e0fe0ef          	jal	ra,80001e54 <printk>
80003c78:	07800593          	li	a1,120
80003c7c:	2e440513          	addi	a0,s0,740
80003c80:	a10fe0ef          	jal	ra,80001e90 <assert_post_action>
}
80003c84:	00812403          	lw	s0,8(sp)
80003c88:	00c12083          	lw	ra,12(sp)
80003c8c:	00048513          	mv	a0,s1
80003c90:	00412483          	lw	s1,4(sp)
80003c94:	01010113          	addi	sp,sp,16
80003c98:	da0fc06f          	j	80000238 <__swap>

80003c9c <z_unpend_first_thread>:
{
80003c9c:	fe010113          	addi	sp,sp,-32
80003ca0:	01212823          	sw	s2,16(sp)
80003ca4:	01312623          	sw	s3,12(sp)
80003ca8:	00112e23          	sw	ra,28(sp)
80003cac:	00812c23          	sw	s0,24(sp)
80003cb0:	00912a23          	sw	s1,20(sp)
80003cb4:	00050993          	mv	s3,a0
	__asm__ volatile ("csrrc %0, mstatus, %1"
80003cb8:	00800913          	li	s2,8
80003cbc:	30093973          	csrrc	s2,mstatus,s2
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80003cc0:	800074b7          	lui	s1,0x80007
80003cc4:	97848513          	addi	a0,s1,-1672 # 80006978 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006979>
	key = (mstatus & SOC_MSTATUS_IEN);
80003cc8:	00897913          	andi	s2,s2,8
80003ccc:	2c9000ef          	jal	ra,80004794 <z_spin_lock_valid>
80003cd0:	02051e63          	bnez	a0,80003d0c <z_unpend_first_thread+0x70>
80003cd4:	80006437          	lui	s0,0x80006
80003cd8:	800065b7          	lui	a1,0x80006
80003cdc:	80006537          	lui	a0,0x80006
80003ce0:	2fc58593          	addi	a1,a1,764 # 800062fc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800062fd>
80003ce4:	04e00693          	li	a3,78
80003ce8:	2e440613          	addi	a2,s0,740 # 800062e4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800062e5>
80003cec:	21850513          	addi	a0,a0,536 # 80006218 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006219>
80003cf0:	964fe0ef          	jal	ra,80001e54 <printk>
80003cf4:	80006537          	lui	a0,0x80006
80003cf8:	31450513          	addi	a0,a0,788 # 80006314 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006315>
80003cfc:	958fe0ef          	jal	ra,80001e54 <printk>
80003d00:	04e00593          	li	a1,78
80003d04:	2e440513          	addi	a0,s0,740
80003d08:	988fe0ef          	jal	ra,80001e90 <assert_post_action>
	z_spin_lock_set_owner(l);
80003d0c:	97848513          	addi	a0,s1,-1672
80003d10:	2dd000ef          	jal	ra,800047ec <z_spin_lock_set_owner>
		ret = _priq_wait_best(&wait_q->waitq);
80003d14:	00098513          	mv	a0,s3
80003d18:	d28ff0ef          	jal	ra,80003240 <z_priq_dumb_best>
80003d1c:	00050413          	mv	s0,a0
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80003d20:	97848513          	addi	a0,s1,-1672
80003d24:	299000ef          	jal	ra,800047bc <z_spin_unlock_valid>
80003d28:	02051e63          	bnez	a0,80003d64 <z_unpend_first_thread+0xc8>
80003d2c:	800069b7          	lui	s3,0x80006
80003d30:	800065b7          	lui	a1,0x80006
80003d34:	80006537          	lui	a0,0x80006
80003d38:	32c58593          	addi	a1,a1,812 # 8000632c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000632d>
80003d3c:	06100693          	li	a3,97
80003d40:	2e498613          	addi	a2,s3,740 # 800062e4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800062e5>
80003d44:	21850513          	addi	a0,a0,536 # 80006218 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006219>
80003d48:	90cfe0ef          	jal	ra,80001e54 <printk>
80003d4c:	80006537          	lui	a0,0x80006
80003d50:	34450513          	addi	a0,a0,836 # 80006344 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006345>
80003d54:	900fe0ef          	jal	ra,80001e54 <printk>
80003d58:	06100593          	li	a1,97
80003d5c:	2e498513          	addi	a0,s3,740
80003d60:	930fe0ef          	jal	ra,80001e90 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80003d64:	30092973          	csrrs	s2,mstatus,s2

static inline struct k_thread *z_unpend1_no_timeout(_wait_q_t *wait_q)
{
	struct k_thread *thread = z_find_first_thread_to_unpend(wait_q, NULL);

	if (thread != NULL) {
80003d68:	0c040663          	beqz	s0,80003e34 <z_unpend_first_thread+0x198>
	__asm__ volatile ("csrrc %0, mstatus, %1"
80003d6c:	00800913          	li	s2,8
80003d70:	30093973          	csrrc	s2,mstatus,s2
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80003d74:	97848513          	addi	a0,s1,-1672
	key = (mstatus & SOC_MSTATUS_IEN);
80003d78:	00897913          	andi	s2,s2,8
80003d7c:	219000ef          	jal	ra,80004794 <z_spin_lock_valid>
80003d80:	02051e63          	bnez	a0,80003dbc <z_unpend_first_thread+0x120>
80003d84:	800069b7          	lui	s3,0x80006
80003d88:	800065b7          	lui	a1,0x80006
80003d8c:	80006537          	lui	a0,0x80006
80003d90:	2fc58593          	addi	a1,a1,764 # 800062fc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800062fd>
80003d94:	04e00693          	li	a3,78
80003d98:	2e498613          	addi	a2,s3,740 # 800062e4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800062e5>
80003d9c:	21850513          	addi	a0,a0,536 # 80006218 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006219>
80003da0:	8b4fe0ef          	jal	ra,80001e54 <printk>
80003da4:	80006537          	lui	a0,0x80006
80003da8:	31450513          	addi	a0,a0,788 # 80006314 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006315>
80003dac:	8a8fe0ef          	jal	ra,80001e54 <printk>
80003db0:	04e00593          	li	a1,78
80003db4:	2e498513          	addi	a0,s3,740
80003db8:	8d8fe0ef          	jal	ra,80001e90 <assert_post_action>
	z_spin_lock_set_owner(l);
80003dbc:	97848513          	addi	a0,s1,-1672
80003dc0:	22d000ef          	jal	ra,800047ec <z_spin_lock_set_owner>
		_priq_wait_remove(&pended_on(thread)->waitq, thread);
80003dc4:	00840513          	addi	a0,s0,8
80003dc8:	e1dfe0ef          	jal	ra,80002be4 <pended_on.isra.15>
80003dcc:	00040593          	mv	a1,s0
80003dd0:	af8ff0ef          	jal	ra,800030c8 <z_priq_dumb_remove>
	thread->base.thread_state &= ~_THREAD_PENDING;
80003dd4:	00d44783          	lbu	a5,13(s0)
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80003dd8:	97848513          	addi	a0,s1,-1672
80003ddc:	ffd7f793          	andi	a5,a5,-3
80003de0:	00f406a3          	sb	a5,13(s0)
80003de4:	1d9000ef          	jal	ra,800047bc <z_spin_unlock_valid>
80003de8:	02051e63          	bnez	a0,80003e24 <z_unpend_first_thread+0x188>
80003dec:	800064b7          	lui	s1,0x80006
80003df0:	800065b7          	lui	a1,0x80006
80003df4:	80006537          	lui	a0,0x80006
80003df8:	32c58593          	addi	a1,a1,812 # 8000632c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000632d>
80003dfc:	06100693          	li	a3,97
80003e00:	2e448613          	addi	a2,s1,740 # 800062e4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800062e5>
80003e04:	21850513          	addi	a0,a0,536 # 80006218 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006219>
80003e08:	84cfe0ef          	jal	ra,80001e54 <printk>
80003e0c:	80006537          	lui	a0,0x80006
80003e10:	34450513          	addi	a0,a0,836 # 80006344 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006345>
80003e14:	840fe0ef          	jal	ra,80001e54 <printk>
80003e18:	06100593          	li	a1,97
80003e1c:	2e448513          	addi	a0,s1,740
80003e20:	870fe0ef          	jal	ra,80001e90 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80003e24:	30092973          	csrrs	s2,mstatus,s2
	thread->base.pended_on = NULL;
80003e28:	00042423          	sw	zero,8(s0)
	return z_abort_timeout(&thread->base.timeout);
80003e2c:	01840513          	addi	a0,s0,24
80003e30:	0b8010ef          	jal	ra,80004ee8 <z_abort_timeout>
}
80003e34:	00040513          	mv	a0,s0
80003e38:	01c12083          	lw	ra,28(sp)
80003e3c:	01812403          	lw	s0,24(sp)
80003e40:	01412483          	lw	s1,20(sp)
80003e44:	01012903          	lw	s2,16(sp)
80003e48:	00c12983          	lw	s3,12(sp)
80003e4c:	02010113          	addi	sp,sp,32
80003e50:	00008067          	ret

80003e54 <z_unpend_all>:
	}
	return t;
}

int z_unpend_all(_wait_q_t *wait_q)
{
80003e54:	ff010113          	addi	sp,sp,-16
80003e58:	00912223          	sw	s1,4(sp)
80003e5c:	01212023          	sw	s2,0(sp)
80003e60:	00112623          	sw	ra,12(sp)
80003e64:	00812423          	sw	s0,8(sp)
80003e68:	00050913          	mv	s2,a0
	int need_sched = 0;
80003e6c:	00000493          	li	s1,0
	return list->head == list;
80003e70:	00092403          	lw	s0,0(s2)
	return sys_dlist_is_empty(list) ? NULL : list->head;
80003e74:	00890463          	beq	s2,s0,80003e7c <z_unpend_all+0x28>
	struct k_thread *th;

	while ((th = z_waitq_head(wait_q)) != NULL) {
80003e78:	02041063          	bnez	s0,80003e98 <z_unpend_all+0x44>
		z_ready_thread(th);
		need_sched = 1;
	}

	return need_sched;
}
80003e7c:	00c12083          	lw	ra,12(sp)
80003e80:	00812403          	lw	s0,8(sp)
80003e84:	00048513          	mv	a0,s1
80003e88:	00012903          	lw	s2,0(sp)
80003e8c:	00412483          	lw	s1,4(sp)
80003e90:	01010113          	addi	sp,sp,16
80003e94:	00008067          	ret
		z_unpend_thread(th);
80003e98:	00040513          	mv	a0,s0
80003e9c:	aa4ff0ef          	jal	ra,80003140 <z_unpend_thread>
	if (z_is_thread_ready(thread)) {
80003ea0:	00040513          	mv	a0,s0
80003ea4:	cedfe0ef          	jal	ra,80002b90 <z_is_thread_ready>
		need_sched = 1;
80003ea8:	00100493          	li	s1,1
80003eac:	fc0502e3          	beqz	a0,80003e70 <z_unpend_all+0x1c>
		z_add_thread_to_ready_q(thread);
80003eb0:	00040513          	mv	a0,s0
80003eb4:	de8ff0ef          	jal	ra,8000349c <z_add_thread_to_ready_q>
80003eb8:	fb9ff06f          	j	80003e70 <z_unpend_all+0x1c>

80003ebc <z_sched_init>:
	list->head = (sys_dnode_t *)list;
80003ebc:	800077b7          	lui	a5,0x80007
80003ec0:	ca478793          	addi	a5,a5,-860 # 80006ca4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006ca5>
80003ec4:	02478713          	addi	a4,a5,36
80003ec8:	02e7a223          	sw	a4,36(a5)
	list->tail = (sys_dnode_t *)list;
80003ecc:	02e7a423          	sw	a4,40(a5)
		sys_dlist_init(&_kernel.ready_q.runq.queues[i]);
	}
#endif

#ifdef CONFIG_TIMESLICING
	k_sched_time_slice_set(CONFIG_TIMESLICE_SIZE,
80003ed0:	00000593          	li	a1,0
80003ed4:	00000513          	li	a0,0
80003ed8:	d6dfe06f          	j	80002c44 <k_sched_time_slice_set>

80003edc <z_impl_k_current_get>:
#endif

k_tid_t z_impl_k_current_get(void)
{
	return _current;
}
80003edc:	800077b7          	lui	a5,0x80007
80003ee0:	cac7a503          	lw	a0,-852(a5) # 80006cac <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006cad>
80003ee4:	00008067          	ret

80003ee8 <z_impl_k_sem_init>:

#endif /* CONFIG_OBJECT_TRACING */

void z_impl_k_sem_init(struct k_sem *sem, unsigned int initial_count,
		      unsigned int limit)
{
80003ee8:	fe010113          	addi	sp,sp,-32
80003eec:	00812c23          	sw	s0,24(sp)
80003ef0:	00912a23          	sw	s1,20(sp)
80003ef4:	01212823          	sw	s2,16(sp)
80003ef8:	00112e23          	sw	ra,28(sp)
80003efc:	01312623          	sw	s3,12(sp)
80003f00:	00050413          	mv	s0,a0
80003f04:	00058913          	mv	s2,a1
80003f08:	00060493          	mv	s1,a2
	__ASSERT(limit != 0U, "limit cannot be zero");
80003f0c:	02061e63          	bnez	a2,80003f48 <z_impl_k_sem_init+0x60>
80003f10:	800069b7          	lui	s3,0x80006
80003f14:	800065b7          	lui	a1,0x80006
80003f18:	80006537          	lui	a0,0x80006
80003f1c:	5cc58593          	addi	a1,a1,1484 # 800065cc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800065cd>
80003f20:	04600693          	li	a3,70
80003f24:	5bc98613          	addi	a2,s3,1468 # 800065bc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800065bd>
80003f28:	21850513          	addi	a0,a0,536 # 80006218 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006219>
80003f2c:	f29fd0ef          	jal	ra,80001e54 <printk>
80003f30:	80006537          	lui	a0,0x80006
80003f34:	5d850513          	addi	a0,a0,1496 # 800065d8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800065d9>
80003f38:	f1dfd0ef          	jal	ra,80001e54 <printk>
80003f3c:	04600593          	li	a1,70
80003f40:	5bc98513          	addi	a0,s3,1468
80003f44:	f4dfd0ef          	jal	ra,80001e90 <assert_post_action>
	__ASSERT(initial_count <= limit, "count cannot be greater than limit");
80003f48:	0324fe63          	bgeu	s1,s2,80003f84 <z_impl_k_sem_init+0x9c>
80003f4c:	800069b7          	lui	s3,0x80006
80003f50:	800065b7          	lui	a1,0x80006
80003f54:	80006537          	lui	a0,0x80006
80003f58:	5f058593          	addi	a1,a1,1520 # 800065f0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800065f1>
80003f5c:	04700693          	li	a3,71
80003f60:	5bc98613          	addi	a2,s3,1468 # 800065bc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800065bd>
80003f64:	21850513          	addi	a0,a0,536 # 80006218 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006219>
80003f68:	eedfd0ef          	jal	ra,80001e54 <printk>
80003f6c:	80006537          	lui	a0,0x80006
80003f70:	60850513          	addi	a0,a0,1544 # 80006608 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006609>
80003f74:	ee1fd0ef          	jal	ra,80001e54 <printk>
80003f78:	04700593          	li	a1,71
80003f7c:	5bc98513          	addi	a0,s3,1468
80003f80:	f11fd0ef          	jal	ra,80001e90 <assert_post_action>

	sys_trace_void(SYS_TRACE_ID_SEMA_INIT);
	sem->count = initial_count;
80003f84:	01242423          	sw	s2,8(s0)
	sem->limit = limit;
80003f88:	00942623          	sw	s1,12(s0)
	list->head = (sys_dnode_t *)list;
80003f8c:	00842023          	sw	s0,0(s0)
	list->tail = (sys_dnode_t *)list;
80003f90:	00842223          	sw	s0,4(s0)

	SYS_TRACING_OBJ_INIT(k_sem, sem);

	z_object_init(sem);
	sys_trace_end_call(SYS_TRACE_ID_SEMA_INIT);
}
80003f94:	01c12083          	lw	ra,28(sp)
80003f98:	01812403          	lw	s0,24(sp)
80003f9c:	01412483          	lw	s1,20(sp)
80003fa0:	01012903          	lw	s2,16(sp)
80003fa4:	00c12983          	lw	s3,12(sp)
80003fa8:	02010113          	addi	sp,sp,32
80003fac:	00008067          	ret

80003fb0 <z_impl_k_sem_give>:
		handle_poll_events(sem);
	}
}

void z_impl_k_sem_give(struct k_sem *sem)
{
80003fb0:	fe010113          	addi	sp,sp,-32
80003fb4:	00912a23          	sw	s1,20(sp)
80003fb8:	01312623          	sw	s3,12(sp)
80003fbc:	00112e23          	sw	ra,28(sp)
80003fc0:	00812c23          	sw	s0,24(sp)
80003fc4:	01212823          	sw	s2,16(sp)
80003fc8:	00050993          	mv	s3,a0
	__asm__ volatile ("csrrc %0, mstatus, %1"
80003fcc:	00800493          	li	s1,8
80003fd0:	3004b4f3          	csrrc	s1,mstatus,s1
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80003fd4:	80007437          	lui	s0,0x80007
80003fd8:	98440513          	addi	a0,s0,-1660 # 80006984 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006985>
	key = (mstatus & SOC_MSTATUS_IEN);
80003fdc:	0084f493          	andi	s1,s1,8
80003fe0:	7b4000ef          	jal	ra,80004794 <z_spin_lock_valid>
80003fe4:	02051e63          	bnez	a0,80004020 <z_impl_k_sem_give+0x70>
80003fe8:	80006937          	lui	s2,0x80006
80003fec:	800065b7          	lui	a1,0x80006
80003ff0:	80006537          	lui	a0,0x80006
80003ff4:	2fc58593          	addi	a1,a1,764 # 800062fc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800062fd>
80003ff8:	04e00693          	li	a3,78
80003ffc:	2e490613          	addi	a2,s2,740 # 800062e4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800062e5>
80004000:	21850513          	addi	a0,a0,536 # 80006218 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006219>
80004004:	e51fd0ef          	jal	ra,80001e54 <printk>
80004008:	80006537          	lui	a0,0x80006
8000400c:	31450513          	addi	a0,a0,788 # 80006314 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006315>
80004010:	e45fd0ef          	jal	ra,80001e54 <printk>
80004014:	04e00593          	li	a1,78
80004018:	2e490513          	addi	a0,s2,740
8000401c:	e75fd0ef          	jal	ra,80001e90 <assert_post_action>
	z_spin_lock_set_owner(l);
80004020:	98440513          	addi	a0,s0,-1660
80004024:	7c8000ef          	jal	ra,800047ec <z_spin_lock_set_owner>
	struct k_thread *thread = z_unpend_first_thread(&sem->wait_q);
80004028:	00098513          	mv	a0,s3
8000402c:	c71ff0ef          	jal	ra,80003c9c <z_unpend_first_thread>
80004030:	00050913          	mv	s2,a0
	if (thread != NULL) {
80004034:	04050263          	beqz	a0,80004078 <z_impl_k_sem_give+0xc8>
	return !((z_is_thread_prevented_from_running(thread)) != 0 ||
80004038:	00d54783          	lbu	a5,13(a0)
8000403c:	01f7f793          	andi	a5,a5,31
80004040:	00079863          	bnez	a5,80004050 <z_impl_k_sem_give+0xa0>
	if (z_is_thread_ready(thread)) {
80004044:	01852783          	lw	a5,24(a0)
80004048:	00079463          	bnez	a5,80004050 <z_impl_k_sem_give+0xa0>
		z_add_thread_to_ready_q(thread);
8000404c:	c50ff0ef          	jal	ra,8000349c <z_add_thread_to_ready_q>
}

static ALWAYS_INLINE void
z_set_thread_return_value(struct k_thread *thread, unsigned int value)
{
	thread->arch.swap_return_value = value;
80004050:	06092623          	sw	zero,108(s2)
	k_spinlock_key_t key = k_spin_lock(&lock);

	sys_trace_void(SYS_TRACE_ID_SEMA_GIVE);
	do_sem_give(sem);
	sys_trace_end_call(SYS_TRACE_ID_SEMA_GIVE);
	z_reschedule(&lock, key);
80004054:	98440513          	addi	a0,s0,-1660
}
80004058:	01812403          	lw	s0,24(sp)
8000405c:	01c12083          	lw	ra,28(sp)
80004060:	01012903          	lw	s2,16(sp)
80004064:	00c12983          	lw	s3,12(sp)
	z_reschedule(&lock, key);
80004068:	00048593          	mv	a1,s1
}
8000406c:	01412483          	lw	s1,20(sp)
80004070:	02010113          	addi	sp,sp,32
	z_reschedule(&lock, key);
80004074:	dddfe06f          	j	80002e50 <z_reschedule>
	sem->count += (sem->count != sem->limit) ? 1U : 0U;
80004078:	0089a703          	lw	a4,8(s3)
8000407c:	00c9a783          	lw	a5,12(s3)
80004080:	40e787b3          	sub	a5,a5,a4
80004084:	00f037b3          	snez	a5,a5
80004088:	00e787b3          	add	a5,a5,a4
8000408c:	00f9a423          	sw	a5,8(s3)
80004090:	fc5ff06f          	j	80004054 <z_impl_k_sem_give+0xa4>

80004094 <z_impl_k_sem_take>:
Z_SYSCALL_HANDLER1_SIMPLE_VOID(k_sem_give, K_OBJ_SEM, struct k_sem *);
#endif

int z_impl_k_sem_take(struct k_sem *sem, s32_t timeout)
{
	__ASSERT(((z_is_in_isr() == false) || (timeout == K_NO_WAIT)), "");
80004094:	800077b7          	lui	a5,0x80007
80004098:	ca47a783          	lw	a5,-860(a5) # 80006ca4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006ca5>
{
8000409c:	fe010113          	addi	sp,sp,-32
800040a0:	01212823          	sw	s2,16(sp)
800040a4:	01312623          	sw	s3,12(sp)
800040a8:	00112e23          	sw	ra,28(sp)
800040ac:	00812c23          	sw	s0,24(sp)
800040b0:	00912a23          	sw	s1,20(sp)
800040b4:	01412423          	sw	s4,8(sp)
800040b8:	00050913          	mv	s2,a0
800040bc:	00058993          	mv	s3,a1
	__ASSERT(((z_is_in_isr() == false) || (timeout == K_NO_WAIT)), "");
800040c0:	04078063          	beqz	a5,80004100 <z_impl_k_sem_take+0x6c>
800040c4:	02058e63          	beqz	a1,80004100 <z_impl_k_sem_take+0x6c>
800040c8:	80006437          	lui	s0,0x80006
800040cc:	800065b7          	lui	a1,0x80006
800040d0:	80006537          	lui	a0,0x80006
800040d4:	63058593          	addi	a1,a1,1584 # 80006630 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006631>
800040d8:	08c00693          	li	a3,140
800040dc:	5bc40613          	addi	a2,s0,1468 # 800065bc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800065bd>
800040e0:	21850513          	addi	a0,a0,536 # 80006218 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006219>
800040e4:	d71fd0ef          	jal	ra,80001e54 <printk>
800040e8:	80006537          	lui	a0,0x80006
800040ec:	29c50513          	addi	a0,a0,668 # 8000629c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000629d>
800040f0:	d65fd0ef          	jal	ra,80001e54 <printk>
800040f4:	08c00593          	li	a1,140
800040f8:	5bc40513          	addi	a0,s0,1468
800040fc:	d95fd0ef          	jal	ra,80001e90 <assert_post_action>
	__asm__ volatile ("csrrc %0, mstatus, %1"
80004100:	00800413          	li	s0,8
80004104:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80004108:	800074b7          	lui	s1,0x80007
8000410c:	98448513          	addi	a0,s1,-1660 # 80006984 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006985>
	key = (mstatus & SOC_MSTATUS_IEN);
80004110:	00847413          	andi	s0,s0,8
80004114:	680000ef          	jal	ra,80004794 <z_spin_lock_valid>
80004118:	02051e63          	bnez	a0,80004154 <z_impl_k_sem_take+0xc0>
8000411c:	80006a37          	lui	s4,0x80006
80004120:	800065b7          	lui	a1,0x80006
80004124:	80006537          	lui	a0,0x80006
80004128:	2fc58593          	addi	a1,a1,764 # 800062fc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800062fd>
8000412c:	04e00693          	li	a3,78
80004130:	2e4a0613          	addi	a2,s4,740 # 800062e4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800062e5>
80004134:	21850513          	addi	a0,a0,536 # 80006218 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006219>
80004138:	d1dfd0ef          	jal	ra,80001e54 <printk>
8000413c:	80006537          	lui	a0,0x80006
80004140:	31450513          	addi	a0,a0,788 # 80006314 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006315>
80004144:	d11fd0ef          	jal	ra,80001e54 <printk>
80004148:	04e00593          	li	a1,78
8000414c:	2e4a0513          	addi	a0,s4,740
80004150:	d41fd0ef          	jal	ra,80001e90 <assert_post_action>
	z_spin_lock_set_owner(l);
80004154:	98448513          	addi	a0,s1,-1660
80004158:	694000ef          	jal	ra,800047ec <z_spin_lock_set_owner>

	sys_trace_void(SYS_TRACE_ID_SEMA_TAKE);
	k_spinlock_key_t key = k_spin_lock(&lock);

	if (likely(sem->count > 0U)) {
8000415c:	00892783          	lw	a5,8(s2)
80004160:	06078c63          	beqz	a5,800041d8 <z_impl_k_sem_take+0x144>
		sem->count--;
80004164:	fff78793          	addi	a5,a5,-1
80004168:	00f92423          	sw	a5,8(s2)
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
8000416c:	98448513          	addi	a0,s1,-1660
80004170:	64c000ef          	jal	ra,800047bc <z_spin_unlock_valid>
80004174:	02051e63          	bnez	a0,800041b0 <z_impl_k_sem_take+0x11c>
80004178:	800064b7          	lui	s1,0x80006
8000417c:	800065b7          	lui	a1,0x80006
80004180:	80006537          	lui	a0,0x80006
80004184:	32c58593          	addi	a1,a1,812 # 8000632c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000632d>
80004188:	06100693          	li	a3,97
8000418c:	2e448613          	addi	a2,s1,740 # 800062e4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800062e5>
80004190:	21850513          	addi	a0,a0,536 # 80006218 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006219>
80004194:	cc1fd0ef          	jal	ra,80001e54 <printk>
80004198:	80006537          	lui	a0,0x80006
8000419c:	34450513          	addi	a0,a0,836 # 80006344 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006345>
800041a0:	cb5fd0ef          	jal	ra,80001e54 <printk>
800041a4:	06100593          	li	a1,97
800041a8:	2e448513          	addi	a0,s1,740
800041ac:	ce5fd0ef          	jal	ra,80001e90 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
800041b0:	30042473          	csrrs	s0,mstatus,s0
		k_spin_unlock(&lock, key);
		sys_trace_end_call(SYS_TRACE_ID_SEMA_TAKE);
		return 0;
800041b4:	00000513          	li	a0,0

	sys_trace_end_call(SYS_TRACE_ID_SEMA_TAKE);

	int ret = z_pend_curr(&lock, key, &sem->wait_q, timeout);
	return ret;
}
800041b8:	01c12083          	lw	ra,28(sp)
800041bc:	01812403          	lw	s0,24(sp)
800041c0:	01412483          	lw	s1,20(sp)
800041c4:	01012903          	lw	s2,16(sp)
800041c8:	00c12983          	lw	s3,12(sp)
800041cc:	00812a03          	lw	s4,8(sp)
800041d0:	02010113          	addi	sp,sp,32
800041d4:	00008067          	ret
	if (timeout == K_NO_WAIT) {
800041d8:	04099a63          	bnez	s3,8000422c <z_impl_k_sem_take+0x198>
800041dc:	98448513          	addi	a0,s1,-1660
800041e0:	5dc000ef          	jal	ra,800047bc <z_spin_unlock_valid>
800041e4:	02051e63          	bnez	a0,80004220 <z_impl_k_sem_take+0x18c>
800041e8:	800064b7          	lui	s1,0x80006
800041ec:	800065b7          	lui	a1,0x80006
800041f0:	80006537          	lui	a0,0x80006
800041f4:	32c58593          	addi	a1,a1,812 # 8000632c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000632d>
800041f8:	06100693          	li	a3,97
800041fc:	2e448613          	addi	a2,s1,740 # 800062e4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800062e5>
80004200:	21850513          	addi	a0,a0,536 # 80006218 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006219>
80004204:	c51fd0ef          	jal	ra,80001e54 <printk>
80004208:	80006537          	lui	a0,0x80006
8000420c:	34450513          	addi	a0,a0,836 # 80006344 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006345>
80004210:	c45fd0ef          	jal	ra,80001e54 <printk>
80004214:	06100593          	li	a1,97
80004218:	2e448513          	addi	a0,s1,740
8000421c:	c75fd0ef          	jal	ra,80001e90 <assert_post_action>
80004220:	30042473          	csrrs	s0,mstatus,s0
		return -EBUSY;
80004224:	ff000513          	li	a0,-16
80004228:	f91ff06f          	j	800041b8 <z_impl_k_sem_take+0x124>
	int ret = z_pend_curr(&lock, key, &sem->wait_q, timeout);
8000422c:	00040593          	mv	a1,s0
}
80004230:	01812403          	lw	s0,24(sp)
80004234:	01c12083          	lw	ra,28(sp)
80004238:	00812a03          	lw	s4,8(sp)
	int ret = z_pend_curr(&lock, key, &sem->wait_q, timeout);
8000423c:	00098693          	mv	a3,s3
80004240:	00090613          	mv	a2,s2
}
80004244:	00c12983          	lw	s3,12(sp)
80004248:	01012903          	lw	s2,16(sp)
	int ret = z_pend_curr(&lock, key, &sem->wait_q, timeout);
8000424c:	98448513          	addi	a0,s1,-1660
}
80004250:	01412483          	lw	s1,20(sp)
80004254:	02010113          	addi	sp,sp,32
	int ret = z_pend_curr(&lock, key, &sem->wait_q, timeout);
80004258:	9bdff06f          	j	80003c14 <z_pend_curr>

8000425c <k_stack_init>:
		  u32_t num_entries)
{
	z_waitq_init(&stack->wait_q);
	stack->lock = (struct k_spinlock) {};
	stack->next = stack->base = buffer;
	stack->top = stack->base + num_entries;
8000425c:	00261613          	slli	a2,a2,0x2
	stack->next = stack->base = buffer;
80004260:	00b52623          	sw	a1,12(a0)
80004264:	00b52823          	sw	a1,16(a0)
	stack->top = stack->base + num_entries;
80004268:	00c585b3          	add	a1,a1,a2
	list->head = (sys_dnode_t *)list;
8000426c:	00a52023          	sw	a0,0(a0)
	list->tail = (sys_dnode_t *)list;
80004270:	00a52223          	sw	a0,4(a0)
	stack->lock = (struct k_spinlock) {};
80004274:	00052423          	sw	zero,8(a0)
	stack->top = stack->base + num_entries;
80004278:	00b52a23          	sw	a1,20(a0)

	SYS_TRACING_OBJ_INIT(k_stack, stack);
	z_object_init(stack);
}
8000427c:	00008067          	ret

80004280 <z_impl_k_stack_alloc_init>:

s32_t z_impl_k_stack_alloc_init(struct k_stack *stack, u32_t num_entries)
{
80004280:	fe010113          	addi	sp,sp,-32
80004284:	00812c23          	sw	s0,24(sp)
80004288:	00050413          	mv	s0,a0
	void *buffer;
	s32_t ret;

	buffer = z_thread_malloc(num_entries);
8000428c:	00058513          	mv	a0,a1
{
80004290:	00112e23          	sw	ra,28(sp)
	buffer = z_thread_malloc(num_entries);
80004294:	00b12623          	sw	a1,12(sp)
80004298:	65c010ef          	jal	ra,800058f4 <z_thread_malloc>
	if (buffer != NULL) {
8000429c:	02050863          	beqz	a0,800042cc <z_impl_k_stack_alloc_init+0x4c>
		k_stack_init(stack, buffer, num_entries);
800042a0:	00c12603          	lw	a2,12(sp)
800042a4:	00050593          	mv	a1,a0
800042a8:	00040513          	mv	a0,s0
800042ac:	fb1ff0ef          	jal	ra,8000425c <k_stack_init>
		stack->flags = K_STACK_FLAG_ALLOC;
800042b0:	00100793          	li	a5,1
800042b4:	00f40c23          	sb	a5,24(s0)
		ret = (s32_t)0;
800042b8:	00000513          	li	a0,0
	} else {
		ret = -ENOMEM;
	}

	return ret;
}
800042bc:	01c12083          	lw	ra,28(sp)
800042c0:	01812403          	lw	s0,24(sp)
800042c4:	02010113          	addi	sp,sp,32
800042c8:	00008067          	ret
		ret = -ENOMEM;
800042cc:	ff400513          	li	a0,-12
	return ret;
800042d0:	fedff06f          	j	800042bc <z_impl_k_stack_alloc_init+0x3c>

800042d4 <k_stack_cleanup>:
	return list->head == list;
800042d4:	00052783          	lw	a5,0(a0)
	return z_impl_k_stack_alloc_init((struct k_stack *)stack, num_entries);
}
#endif

void k_stack_cleanup(struct k_stack *stack)
{
800042d8:	ff010113          	addi	sp,sp,-16
800042dc:	00812423          	sw	s0,8(sp)
800042e0:	00112623          	sw	ra,12(sp)
800042e4:	00912223          	sw	s1,4(sp)
800042e8:	00050413          	mv	s0,a0
	return sys_dlist_is_empty(list) ? NULL : list->head;
800042ec:	02f50a63          	beq	a0,a5,80004320 <k_stack_cleanup+0x4c>
	__ASSERT_NO_MSG(z_waitq_head(&stack->wait_q) == NULL);
800042f0:	02078863          	beqz	a5,80004320 <k_stack_cleanup+0x4c>
800042f4:	800064b7          	lui	s1,0x80006
800042f8:	800065b7          	lui	a1,0x80006
800042fc:	80006537          	lui	a0,0x80006
80004300:	67858593          	addi	a1,a1,1656 # 80006678 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006679>
80004304:	21850513          	addi	a0,a0,536 # 80006218 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006219>
80004308:	05a00693          	li	a3,90
8000430c:	66448613          	addi	a2,s1,1636 # 80006664 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006665>
80004310:	b45fd0ef          	jal	ra,80001e54 <printk>
80004314:	05a00593          	li	a1,90
80004318:	66448513          	addi	a0,s1,1636
8000431c:	b75fd0ef          	jal	ra,80001e90 <assert_post_action>

	if ((stack->flags & K_STACK_FLAG_ALLOC) != (u8_t)0) {
80004320:	01844783          	lbu	a5,24(s0)
80004324:	0017f793          	andi	a5,a5,1
80004328:	00078e63          	beqz	a5,80004344 <k_stack_cleanup+0x70>
		k_free(stack->base);
8000432c:	00c42503          	lw	a0,12(s0)
80004330:	5b4010ef          	jal	ra,800058e4 <k_free>
		stack->base = NULL;
		stack->flags &= ~K_STACK_FLAG_ALLOC;
80004334:	01844783          	lbu	a5,24(s0)
		stack->base = NULL;
80004338:	00042623          	sw	zero,12(s0)
		stack->flags &= ~K_STACK_FLAG_ALLOC;
8000433c:	ffe7f793          	andi	a5,a5,-2
80004340:	00f40c23          	sb	a5,24(s0)
	}
}
80004344:	00c12083          	lw	ra,12(sp)
80004348:	00812403          	lw	s0,8(sp)
8000434c:	00412483          	lw	s1,4(sp)
80004350:	01010113          	addi	sp,sp,16
80004354:	00008067          	ret

80004358 <z_impl_k_stack_push>:
void z_impl_k_stack_push(struct k_stack *stack, u32_t data)
{
	struct k_thread *first_pending_thread;
	k_spinlock_key_t key;

	__ASSERT(stack->next != stack->top, "stack is full");
80004358:	01052703          	lw	a4,16(a0)
8000435c:	01452783          	lw	a5,20(a0)
{
80004360:	fe010113          	addi	sp,sp,-32
80004364:	00912a23          	sw	s1,20(sp)
80004368:	01412423          	sw	s4,8(sp)
8000436c:	00112e23          	sw	ra,28(sp)
80004370:	00812c23          	sw	s0,24(sp)
80004374:	01212823          	sw	s2,16(sp)
80004378:	01312623          	sw	s3,12(sp)
8000437c:	00050493          	mv	s1,a0
80004380:	00058a13          	mv	s4,a1
	__ASSERT(stack->next != stack->top, "stack is full");
80004384:	02f71e63          	bne	a4,a5,800043c0 <z_impl_k_stack_push+0x68>
80004388:	80006437          	lui	s0,0x80006
8000438c:	800065b7          	lui	a1,0x80006
80004390:	80006537          	lui	a0,0x80006
80004394:	6a458593          	addi	a1,a1,1700 # 800066a4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800066a5>
80004398:	06800693          	li	a3,104
8000439c:	66440613          	addi	a2,s0,1636 # 80006664 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006665>
800043a0:	21850513          	addi	a0,a0,536 # 80006218 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006219>
800043a4:	ab1fd0ef          	jal	ra,80001e54 <printk>
800043a8:	80006537          	lui	a0,0x80006
800043ac:	6c050513          	addi	a0,a0,1728 # 800066c0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800066c1>
800043b0:	aa5fd0ef          	jal	ra,80001e54 <printk>
800043b4:	06800593          	li	a1,104
800043b8:	66440513          	addi	a0,s0,1636
800043bc:	ad5fd0ef          	jal	ra,80001e90 <assert_post_action>

	key = k_spin_lock(&stack->lock);
800043c0:	00848993          	addi	s3,s1,8
	__asm__ volatile ("csrrc %0, mstatus, %1"
800043c4:	00800413          	li	s0,8
800043c8:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
800043cc:	00098513          	mv	a0,s3
	key = (mstatus & SOC_MSTATUS_IEN);
800043d0:	00847413          	andi	s0,s0,8
800043d4:	3c0000ef          	jal	ra,80004794 <z_spin_lock_valid>
800043d8:	02051e63          	bnez	a0,80004414 <z_impl_k_stack_push+0xbc>
800043dc:	80006937          	lui	s2,0x80006
800043e0:	800065b7          	lui	a1,0x80006
800043e4:	80006537          	lui	a0,0x80006
800043e8:	2fc58593          	addi	a1,a1,764 # 800062fc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800062fd>
800043ec:	04e00693          	li	a3,78
800043f0:	2e490613          	addi	a2,s2,740 # 800062e4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800062e5>
800043f4:	21850513          	addi	a0,a0,536 # 80006218 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006219>
800043f8:	a5dfd0ef          	jal	ra,80001e54 <printk>
800043fc:	80006537          	lui	a0,0x80006
80004400:	31450513          	addi	a0,a0,788 # 80006314 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006315>
80004404:	a51fd0ef          	jal	ra,80001e54 <printk>
80004408:	04e00593          	li	a1,78
8000440c:	2e490513          	addi	a0,s2,740
80004410:	a81fd0ef          	jal	ra,80001e90 <assert_post_action>
	z_spin_lock_set_owner(l);
80004414:	00098513          	mv	a0,s3
80004418:	3d4000ef          	jal	ra,800047ec <z_spin_lock_set_owner>

	first_pending_thread = z_unpend_first_thread(&stack->wait_q);
8000441c:	00048513          	mv	a0,s1
80004420:	87dff0ef          	jal	ra,80003c9c <z_unpend_first_thread>
80004424:	00050913          	mv	s2,a0

	if (first_pending_thread != NULL) {
80004428:	04050663          	beqz	a0,80004474 <z_impl_k_stack_push+0x11c>
	return !((z_is_thread_prevented_from_running(thread)) != 0 ||
8000442c:	00d54783          	lbu	a5,13(a0)
80004430:	01f7f793          	andi	a5,a5,31
80004434:	00079863          	bnez	a5,80004444 <z_impl_k_stack_push+0xec>
	if (z_is_thread_ready(thread)) {
80004438:	01852783          	lw	a5,24(a0)
8000443c:	00079463          	bnez	a5,80004444 <z_impl_k_stack_push+0xec>
		z_add_thread_to_ready_q(thread);
80004440:	85cff0ef          	jal	ra,8000349c <z_add_thread_to_ready_q>
		z_ready_thread(first_pending_thread);

		z_set_thread_return_value_with_data(first_pending_thread,
						   0, (void *)data);
		z_reschedule(&stack->lock, key);
80004444:	00040593          	mv	a1,s0
		*(stack->next) = data;
		stack->next++;
		k_spin_unlock(&stack->lock, key);
	}

}
80004448:	01812403          	lw	s0,24(sp)
	thread->base.swap_data = data;
8000444c:	01492a23          	sw	s4,20(s2)
80004450:	06092623          	sw	zero,108(s2)
80004454:	01c12083          	lw	ra,28(sp)
80004458:	01412483          	lw	s1,20(sp)
8000445c:	01012903          	lw	s2,16(sp)
80004460:	00812a03          	lw	s4,8(sp)
		z_reschedule(&stack->lock, key);
80004464:	00098513          	mv	a0,s3
}
80004468:	00c12983          	lw	s3,12(sp)
8000446c:	02010113          	addi	sp,sp,32
		z_reschedule(&stack->lock, key);
80004470:	9e1fe06f          	j	80002e50 <z_reschedule>
		*(stack->next) = data;
80004474:	0104a783          	lw	a5,16(s1)
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80004478:	00098513          	mv	a0,s3
8000447c:	0147a023          	sw	s4,0(a5)
		stack->next++;
80004480:	00478793          	addi	a5,a5,4
80004484:	00f4a823          	sw	a5,16(s1)
80004488:	334000ef          	jal	ra,800047bc <z_spin_unlock_valid>
8000448c:	02051e63          	bnez	a0,800044c8 <z_impl_k_stack_push+0x170>
80004490:	800064b7          	lui	s1,0x80006
80004494:	800065b7          	lui	a1,0x80006
80004498:	80006537          	lui	a0,0x80006
8000449c:	32c58593          	addi	a1,a1,812 # 8000632c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000632d>
800044a0:	06100693          	li	a3,97
800044a4:	2e448613          	addi	a2,s1,740 # 800062e4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800062e5>
800044a8:	21850513          	addi	a0,a0,536 # 80006218 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006219>
800044ac:	9a9fd0ef          	jal	ra,80001e54 <printk>
800044b0:	80006537          	lui	a0,0x80006
800044b4:	34450513          	addi	a0,a0,836 # 80006344 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006345>
800044b8:	99dfd0ef          	jal	ra,80001e54 <printk>
800044bc:	06100593          	li	a1,97
800044c0:	2e448513          	addi	a0,s1,740
800044c4:	9cdfd0ef          	jal	ra,80001e90 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
800044c8:	30042473          	csrrs	s0,mstatus,s0
}
800044cc:	01c12083          	lw	ra,28(sp)
800044d0:	01812403          	lw	s0,24(sp)
800044d4:	01412483          	lw	s1,20(sp)
800044d8:	01012903          	lw	s2,16(sp)
800044dc:	00c12983          	lw	s3,12(sp)
800044e0:	00812a03          	lw	s4,8(sp)
800044e4:	02010113          	addi	sp,sp,32
800044e8:	00008067          	ret

800044ec <z_impl_k_stack_pop>:
	return 0;
}
#endif

int z_impl_k_stack_pop(struct k_stack *stack, u32_t *data, s32_t timeout)
{
800044ec:	fe010113          	addi	sp,sp,-32
800044f0:	00812c23          	sw	s0,24(sp)
800044f4:	00912a23          	sw	s1,20(sp)
800044f8:	01212823          	sw	s2,16(sp)
800044fc:	01312623          	sw	s3,12(sp)
80004500:	01412423          	sw	s4,8(sp)
80004504:	00112e23          	sw	ra,28(sp)
80004508:	01512223          	sw	s5,4(sp)
8000450c:	00050913          	mv	s2,a0
80004510:	00058993          	mv	s3,a1
80004514:	00060a13          	mv	s4,a2
	k_spinlock_key_t key;
	int result;

	key = k_spin_lock(&stack->lock);
80004518:	00850493          	addi	s1,a0,8
	__asm__ volatile ("csrrc %0, mstatus, %1"
8000451c:	00800413          	li	s0,8
80004520:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80004524:	00048513          	mv	a0,s1
	key = (mstatus & SOC_MSTATUS_IEN);
80004528:	00847413          	andi	s0,s0,8
8000452c:	268000ef          	jal	ra,80004794 <z_spin_lock_valid>
80004530:	02051e63          	bnez	a0,8000456c <z_impl_k_stack_pop+0x80>
80004534:	80006ab7          	lui	s5,0x80006
80004538:	800065b7          	lui	a1,0x80006
8000453c:	80006537          	lui	a0,0x80006
80004540:	2fc58593          	addi	a1,a1,764 # 800062fc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800062fd>
80004544:	04e00693          	li	a3,78
80004548:	2e4a8613          	addi	a2,s5,740 # 800062e4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800062e5>
8000454c:	21850513          	addi	a0,a0,536 # 80006218 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006219>
80004550:	905fd0ef          	jal	ra,80001e54 <printk>
80004554:	80006537          	lui	a0,0x80006
80004558:	31450513          	addi	a0,a0,788 # 80006314 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006315>
8000455c:	8f9fd0ef          	jal	ra,80001e54 <printk>
80004560:	04e00593          	li	a1,78
80004564:	2e4a8513          	addi	a0,s5,740
80004568:	929fd0ef          	jal	ra,80001e90 <assert_post_action>
	z_spin_lock_set_owner(l);
8000456c:	00048513          	mv	a0,s1
80004570:	27c000ef          	jal	ra,800047ec <z_spin_lock_set_owner>

	if (likely(stack->next > stack->base)) {
80004574:	01092783          	lw	a5,16(s2)
80004578:	00c92703          	lw	a4,12(s2)
8000457c:	06f77263          	bgeu	a4,a5,800045e0 <z_impl_k_stack_pop+0xf4>
		stack->next--;
80004580:	ffc78713          	addi	a4,a5,-4
		*data = *(stack->next);
80004584:	ffc7a783          	lw	a5,-4(a5)
		stack->next--;
80004588:	00e92823          	sw	a4,16(s2)
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
8000458c:	00048513          	mv	a0,s1
		*data = *(stack->next);
80004590:	00f9a023          	sw	a5,0(s3)
80004594:	228000ef          	jal	ra,800047bc <z_spin_unlock_valid>
80004598:	02051e63          	bnez	a0,800045d4 <z_impl_k_stack_pop+0xe8>
8000459c:	800064b7          	lui	s1,0x80006
800045a0:	800065b7          	lui	a1,0x80006
800045a4:	80006537          	lui	a0,0x80006
800045a8:	32c58593          	addi	a1,a1,812 # 8000632c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000632d>
800045ac:	06100693          	li	a3,97
800045b0:	2e448613          	addi	a2,s1,740 # 800062e4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800062e5>
800045b4:	21850513          	addi	a0,a0,536 # 80006218 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006219>
800045b8:	89dfd0ef          	jal	ra,80001e54 <printk>
800045bc:	80006537          	lui	a0,0x80006
800045c0:	34450513          	addi	a0,a0,836 # 80006344 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006345>
800045c4:	891fd0ef          	jal	ra,80001e54 <printk>
800045c8:	06100593          	li	a1,97
800045cc:	2e448513          	addi	a0,s1,740
800045d0:	8c1fd0ef          	jal	ra,80001e90 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
800045d4:	30042473          	csrrs	s0,mstatus,s0
	if (result == -EAGAIN) {
		return -EAGAIN;
	}

	*data = (u32_t)_current->base.swap_data;
	return 0;
800045d8:	00000513          	li	a0,0
800045dc:	0540006f          	j	80004630 <z_impl_k_stack_pop+0x144>
	if (timeout == K_NO_WAIT) {
800045e0:	060a1a63          	bnez	s4,80004654 <z_impl_k_stack_pop+0x168>
800045e4:	00048513          	mv	a0,s1
800045e8:	1d4000ef          	jal	ra,800047bc <z_spin_unlock_valid>
800045ec:	02051e63          	bnez	a0,80004628 <z_impl_k_stack_pop+0x13c>
800045f0:	800064b7          	lui	s1,0x80006
800045f4:	800065b7          	lui	a1,0x80006
800045f8:	80006537          	lui	a0,0x80006
800045fc:	32c58593          	addi	a1,a1,812 # 8000632c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000632d>
80004600:	06100693          	li	a3,97
80004604:	2e448613          	addi	a2,s1,740 # 800062e4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800062e5>
80004608:	21850513          	addi	a0,a0,536 # 80006218 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006219>
8000460c:	849fd0ef          	jal	ra,80001e54 <printk>
80004610:	80006537          	lui	a0,0x80006
80004614:	34450513          	addi	a0,a0,836 # 80006344 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006345>
80004618:	83dfd0ef          	jal	ra,80001e54 <printk>
8000461c:	06100593          	li	a1,97
80004620:	2e448513          	addi	a0,s1,740
80004624:	86dfd0ef          	jal	ra,80001e90 <assert_post_action>
80004628:	30042473          	csrrs	s0,mstatus,s0
		return -EBUSY;
8000462c:	ff000513          	li	a0,-16
}
80004630:	01c12083          	lw	ra,28(sp)
80004634:	01812403          	lw	s0,24(sp)
80004638:	01412483          	lw	s1,20(sp)
8000463c:	01012903          	lw	s2,16(sp)
80004640:	00c12983          	lw	s3,12(sp)
80004644:	00812a03          	lw	s4,8(sp)
80004648:	00412a83          	lw	s5,4(sp)
8000464c:	02010113          	addi	sp,sp,32
80004650:	00008067          	ret
	result = z_pend_curr(&stack->lock, key, &stack->wait_q, timeout);
80004654:	000a0693          	mv	a3,s4
80004658:	00090613          	mv	a2,s2
8000465c:	00040593          	mv	a1,s0
80004660:	00048513          	mv	a0,s1
80004664:	db0ff0ef          	jal	ra,80003c14 <z_pend_curr>
	if (result == -EAGAIN) {
80004668:	ff500793          	li	a5,-11
8000466c:	fcf502e3          	beq	a0,a5,80004630 <z_impl_k_stack_pop+0x144>
	*data = (u32_t)_current->base.swap_data;
80004670:	800077b7          	lui	a5,0x80007
80004674:	cac7a783          	lw	a5,-852(a5) # 80006cac <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006cad>
80004678:	0147a783          	lw	a5,20(a5)
8000467c:	00f9a023          	sw	a5,0(s3)
80004680:	f59ff06f          	j	800045d8 <z_impl_k_stack_pop+0xec>

80004684 <z_is_thread_ready>:
	return !((z_is_thread_prevented_from_running(thread)) != 0 ||
80004684:	00d54783          	lbu	a5,13(a0)
80004688:	01f7f793          	andi	a5,a5,31
8000468c:	00079863          	bnez	a5,8000469c <z_is_thread_ready+0x18>
80004690:	01852503          	lw	a0,24(a0)
80004694:	00153513          	seqz	a0,a0
80004698:	00008067          	ret
8000469c:	00000513          	li	a0,0
}
800046a0:	00008067          	ret

800046a4 <k_is_in_isr>:
#endif
}

bool k_is_in_isr(void)
{
	return z_is_in_isr();
800046a4:	800077b7          	lui	a5,0x80007
800046a8:	ca47a503          	lw	a0,-860(a5) # 80006ca4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006ca5>
}
800046ac:	00a03533          	snez	a0,a0
800046b0:	00008067          	ret

800046b4 <z_is_thread_essential>:
 *
 * Returns true if current thread is essential, false if it is not.
 */
bool z_is_thread_essential(void)
{
	return (_current->base.user_options & K_ESSENTIAL) == K_ESSENTIAL;
800046b4:	800077b7          	lui	a5,0x80007
800046b8:	cac7a783          	lw	a5,-852(a5) # 80006cac <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006cad>
800046bc:	00c7c503          	lbu	a0,12(a5)
}
800046c0:	00157513          	andi	a0,a0,1
800046c4:	00008067          	ret

800046c8 <z_setup_new_thread>:
void z_setup_new_thread(struct k_thread *new_thread,
		       k_thread_stack_t *stack, size_t stack_size,
		       k_thread_entry_t entry,
		       void *p1, void *p2, void *p3,
		       int prio, u32_t options, const char *name)
{
800046c8:	fe010113          	addi	sp,sp,-32
	stack_size = STACK_ROUND_DOWN(stack_size
			- sizeof(*new_thread->userspace_local_data));
#endif
#endif

	z_new_thread(new_thread, stack, stack_size, entry, p1, p2, p3,
800046cc:	02012303          	lw	t1,32(sp)
{
800046d0:	00812c23          	sw	s0,24(sp)
800046d4:	00112e23          	sw	ra,28(sp)
	z_new_thread(new_thread, stack, stack_size, entry, p1, p2, p3,
800046d8:	00612023          	sw	t1,0(sp)
{
800046dc:	00050413          	mv	s0,a0
	z_new_thread(new_thread, stack, stack_size, entry, p1, p2, p3,
800046e0:	89dfc0ef          	jal	ra,80000f7c <z_new_thread>
	}
#endif
#ifdef CONFIG_SCHED_DEADLINE
	new_thread->base.prio_deadline = 0;
#endif
	new_thread->resource_pool = _current->resource_pool;
800046e4:	800077b7          	lui	a5,0x80007
800046e8:	cac7a783          	lw	a5,-852(a5) # 80006cac <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006cad>
	sys_trace_thread_create(new_thread);
}
800046ec:	01c12083          	lw	ra,28(sp)
	new_thread->resource_pool = _current->resource_pool;
800046f0:	0687a783          	lw	a5,104(a5)
800046f4:	06f42423          	sw	a5,104(s0)
}
800046f8:	01812403          	lw	s0,24(sp)
800046fc:	02010113          	addi	sp,sp,32
80004700:	00008067          	ret

80004704 <z_thread_single_abort>:
Z_SYSCALL_HANDLER1_SIMPLE_VOID(k_thread_resume, K_OBJ_THREAD, k_tid_t);
#endif

void z_thread_single_abort(struct k_thread *thread)
{
	if (thread->fn_abort != NULL) {
80004704:	06052783          	lw	a5,96(a0)
{
80004708:	ff010113          	addi	sp,sp,-16
8000470c:	00812423          	sw	s0,8(sp)
80004710:	00112623          	sw	ra,12(sp)
80004714:	00050413          	mv	s0,a0
	if (thread->fn_abort != NULL) {
80004718:	00078463          	beqz	a5,80004720 <z_thread_single_abort+0x1c>
		thread->fn_abort();
8000471c:	000780e7          	jalr	a5

	if (IS_ENABLED(CONFIG_SMP)) {
		z_sched_abort(thread);
	}

	if (z_is_thread_ready(thread)) {
80004720:	00040513          	mv	a0,s0
80004724:	f61ff0ef          	jal	ra,80004684 <z_is_thread_ready>
80004728:	02050463          	beqz	a0,80004750 <z_thread_single_abort+0x4c>
		z_remove_thread_from_ready_q(thread);
8000472c:	00040513          	mv	a0,s0
80004730:	a74ff0ef          	jal	ra,800039a4 <z_remove_thread_from_ready_q>
		if (z_is_thread_timeout_active(thread)) {
			(void)z_abort_thread_timeout(thread);
		}
	}

	thread->base.thread_state |= _THREAD_DEAD;
80004734:	00d44783          	lbu	a5,13(s0)
	z_object_uninit(thread);

	/* Revoke permissions on thread's ID so that it may be recycled */
	z_thread_perms_all_clear(thread);
#endif
}
80004738:	00c12083          	lw	ra,12(sp)
	thread->base.thread_state |= _THREAD_DEAD;
8000473c:	0087e793          	ori	a5,a5,8
80004740:	00f406a3          	sb	a5,13(s0)
}
80004744:	00812403          	lw	s0,8(sp)
80004748:	01010113          	addi	sp,sp,16
8000474c:	00008067          	ret
		if (z_is_thread_pending(thread)) {
80004750:	00d44783          	lbu	a5,13(s0)
80004754:	0027f793          	andi	a5,a5,2
80004758:	00078663          	beqz	a5,80004764 <z_thread_single_abort+0x60>
			z_unpend_thread_no_timeout(thread);
8000475c:	00040513          	mv	a0,s0
80004760:	df4fe0ef          	jal	ra,80002d54 <z_unpend_thread_no_timeout>
		if (z_is_thread_timeout_active(thread)) {
80004764:	01842783          	lw	a5,24(s0)
80004768:	fc0786e3          	beqz	a5,80004734 <z_thread_single_abort+0x30>
8000476c:	01840513          	addi	a0,s0,24
80004770:	778000ef          	jal	ra,80004ee8 <z_abort_timeout>
80004774:	fc1ff06f          	j	80004734 <z_thread_single_abort+0x30>

80004778 <z_init_thread_base>:
void z_init_thread_base(struct _thread_base *thread_base, int priority,
		       u32_t initial_state, unsigned int options)
{
	/* k_q_node is initialized upon first insertion in a list */

	thread_base->user_options = (u8_t)options;
80004778:	00d50623          	sb	a3,12(a0)
	thread_base->thread_state = (u8_t)initial_state;
8000477c:	00c506a3          	sb	a2,13(a0)

	thread_base->prio = priority;
80004780:	00b50723          	sb	a1,14(a0)

	thread_base->sched_locked = 0U;
80004784:	000507a3          	sb	zero,15(a0)
	node->next = NULL;
80004788:	00052c23          	sw	zero,24(a0)
	node->prev = NULL;
8000478c:	00052e23          	sw	zero,28(a0)

	/* swap_data does not need to be initialized */

	z_init_thread_timeout(thread_base);
}
80004790:	00008067          	ret

80004794 <z_spin_lock_valid>:
 * them in spinlock.h is a giant header ordering headache.
 */
#ifdef SPIN_VALIDATE
bool z_spin_lock_valid(struct k_spinlock *l)
{
	if (l->thread_cpu) {
80004794:	00052503          	lw	a0,0(a0)
80004798:	00050e63          	beqz	a0,800047b4 <z_spin_lock_valid+0x20>
		if ((l->thread_cpu & 3) == _current_cpu->id) {
8000479c:	800077b7          	lui	a5,0x80007
800047a0:	cb87c783          	lbu	a5,-840(a5) # 80006cb8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006cb9>
800047a4:	00357513          	andi	a0,a0,3
800047a8:	40f50533          	sub	a0,a0,a5
800047ac:	00a03533          	snez	a0,a0
800047b0:	00008067          	ret
			return false;
		}
	}
	return true;
800047b4:	00100513          	li	a0,1
}
800047b8:	00008067          	ret

800047bc <z_spin_unlock_valid>:

bool z_spin_unlock_valid(struct k_spinlock *l)
{
	if (l->thread_cpu != (_current_cpu->id | (u32_t)_current)) {
800047bc:	800077b7          	lui	a5,0x80007
800047c0:	ca478793          	addi	a5,a5,-860 # 80006ca4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006ca5>
800047c4:	0147c703          	lbu	a4,20(a5)
800047c8:	0087a783          	lw	a5,8(a5)
800047cc:	00e7e7b3          	or	a5,a5,a4
800047d0:	00052703          	lw	a4,0(a0)
800047d4:	00f71863          	bne	a4,a5,800047e4 <z_spin_unlock_valid+0x28>
		return false;
	}
	l->thread_cpu = 0;
800047d8:	00052023          	sw	zero,0(a0)
	return true;
800047dc:	00100513          	li	a0,1
800047e0:	00008067          	ret
		return false;
800047e4:	00000513          	li	a0,0
}
800047e8:	00008067          	ret

800047ec <z_spin_lock_set_owner>:

void z_spin_lock_set_owner(struct k_spinlock *l)
{
	l->thread_cpu = _current_cpu->id | (u32_t)_current;
800047ec:	800077b7          	lui	a5,0x80007
800047f0:	ca478793          	addi	a5,a5,-860 # 80006ca4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006ca5>
800047f4:	0147c703          	lbu	a4,20(a5)
800047f8:	0087a783          	lw	a5,8(a5)
800047fc:	00e7e7b3          	or	a5,a5,a4
80004800:	00f52023          	sw	a5,0(a0)
}
80004804:	00008067          	ret

80004808 <z_impl_k_thread_start>:
{
80004808:	fe010113          	addi	sp,sp,-32
8000480c:	00812c23          	sw	s0,24(sp)
80004810:	01212823          	sw	s2,16(sp)
80004814:	00112e23          	sw	ra,28(sp)
80004818:	00912a23          	sw	s1,20(sp)
8000481c:	01312623          	sw	s3,12(sp)
80004820:	00050913          	mv	s2,a0
	__asm__ volatile ("csrrc %0, mstatus, %1"
80004824:	00800413          	li	s0,8
80004828:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
8000482c:	800074b7          	lui	s1,0x80007
80004830:	98848513          	addi	a0,s1,-1656 # 80006988 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006989>
	key = (mstatus & SOC_MSTATUS_IEN);
80004834:	00847413          	andi	s0,s0,8
80004838:	f5dff0ef          	jal	ra,80004794 <z_spin_lock_valid>
8000483c:	02051e63          	bnez	a0,80004878 <z_impl_k_thread_start+0x70>
80004840:	800069b7          	lui	s3,0x80006
80004844:	800065b7          	lui	a1,0x80006
80004848:	80006537          	lui	a0,0x80006
8000484c:	2fc58593          	addi	a1,a1,764 # 800062fc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800062fd>
80004850:	04e00693          	li	a3,78
80004854:	2e498613          	addi	a2,s3,740 # 800062e4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800062e5>
80004858:	21850513          	addi	a0,a0,536 # 80006218 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006219>
8000485c:	df8fd0ef          	jal	ra,80001e54 <printk>
80004860:	80006537          	lui	a0,0x80006
80004864:	31450513          	addi	a0,a0,788 # 80006314 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006315>
80004868:	decfd0ef          	jal	ra,80001e54 <printk>
8000486c:	04e00593          	li	a1,78
80004870:	2e498513          	addi	a0,s3,740
80004874:	e1cfd0ef          	jal	ra,80001e90 <assert_post_action>
	z_spin_lock_set_owner(l);
80004878:	98848513          	addi	a0,s1,-1656
8000487c:	f71ff0ef          	jal	ra,800047ec <z_spin_lock_set_owner>
	if (z_has_thread_started(thread)) {
80004880:	00d94783          	lbu	a5,13(s2)
80004884:	0047f713          	andi	a4,a5,4
80004888:	06071463          	bnez	a4,800048f0 <z_impl_k_thread_start+0xe8>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
8000488c:	98848513          	addi	a0,s1,-1656
80004890:	f2dff0ef          	jal	ra,800047bc <z_spin_unlock_valid>
80004894:	02051e63          	bnez	a0,800048d0 <z_impl_k_thread_start+0xc8>
80004898:	800064b7          	lui	s1,0x80006
8000489c:	800065b7          	lui	a1,0x80006
800048a0:	80006537          	lui	a0,0x80006
800048a4:	32c58593          	addi	a1,a1,812 # 8000632c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000632d>
800048a8:	06100693          	li	a3,97
800048ac:	2e448613          	addi	a2,s1,740 # 800062e4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800062e5>
800048b0:	21850513          	addi	a0,a0,536 # 80006218 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006219>
800048b4:	da0fd0ef          	jal	ra,80001e54 <printk>
800048b8:	80006537          	lui	a0,0x80006
800048bc:	34450513          	addi	a0,a0,836 # 80006344 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006345>
800048c0:	d94fd0ef          	jal	ra,80001e54 <printk>
800048c4:	06100593          	li	a1,97
800048c8:	2e448513          	addi	a0,s1,740
800048cc:	dc4fd0ef          	jal	ra,80001e90 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
800048d0:	30042473          	csrrs	s0,mstatus,s0
}
800048d4:	01c12083          	lw	ra,28(sp)
800048d8:	01812403          	lw	s0,24(sp)
800048dc:	01412483          	lw	s1,20(sp)
800048e0:	01012903          	lw	s2,16(sp)
800048e4:	00c12983          	lw	s3,12(sp)
800048e8:	02010113          	addi	sp,sp,32
800048ec:	00008067          	ret
	thread->base.thread_state &= ~_THREAD_PRESTART;
800048f0:	ffb7f793          	andi	a5,a5,-5
800048f4:	00f906a3          	sb	a5,13(s2)
	if (z_is_thread_ready(thread)) {
800048f8:	00090513          	mv	a0,s2
800048fc:	d89ff0ef          	jal	ra,80004684 <z_is_thread_ready>
80004900:	00050663          	beqz	a0,8000490c <z_impl_k_thread_start+0x104>
		z_add_thread_to_ready_q(thread);
80004904:	00090513          	mv	a0,s2
80004908:	b95fe0ef          	jal	ra,8000349c <z_add_thread_to_ready_q>
	z_reschedule(&lock, key);
8000490c:	00040593          	mv	a1,s0
}
80004910:	01812403          	lw	s0,24(sp)
80004914:	01c12083          	lw	ra,28(sp)
80004918:	01012903          	lw	s2,16(sp)
8000491c:	00c12983          	lw	s3,12(sp)
	z_reschedule(&lock, key);
80004920:	98848513          	addi	a0,s1,-1656
}
80004924:	01412483          	lw	s1,20(sp)
80004928:	02010113          	addi	sp,sp,32
	z_reschedule(&lock, key);
8000492c:	d24fe06f          	j	80002e50 <z_reschedule>

80004930 <schedule_new_thread>:
	if (delay == 0) {
80004930:	00059463          	bnez	a1,80004938 <schedule_new_thread+0x8>
K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_THREAD_START, k_thread_start, k_tid_t, thread)
80004934:	ed5ff06f          	j	80004808 <z_impl_k_thread_start>
80004938:	00958593          	addi	a1,a1,9
8000493c:	00a00613          	li	a2,10
80004940:	02c5c633          	div	a2,a1,a2
	z_add_timeout(&th->base.timeout, z_thread_timeout, ticks);
80004944:	800035b7          	lui	a1,0x80003
80004948:	62c58593          	addi	a1,a1,1580 # 8000362c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000362d>
8000494c:	01850513          	addi	a0,a0,24
80004950:	00160613          	addi	a2,a2,1
80004954:	3680006f          	j	80004cbc <z_add_timeout>

80004958 <z_impl_k_thread_create>:
{
80004958:	fc010113          	addi	sp,sp,-64
8000495c:	03512223          	sw	s5,36(sp)
80004960:	00068a93          	mv	s5,a3
	__ASSERT(!z_is_in_isr(), "Threads may not be created in ISRs");
80004964:	800076b7          	lui	a3,0x80007
80004968:	ca46a683          	lw	a3,-860(a3) # 80006ca4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006ca5>
{
8000496c:	02812c23          	sw	s0,56(sp)
80004970:	02912a23          	sw	s1,52(sp)
80004974:	03312623          	sw	s3,44(sp)
80004978:	03412423          	sw	s4,40(sp)
8000497c:	02112e23          	sw	ra,60(sp)
80004980:	03212823          	sw	s2,48(sp)
80004984:	00050413          	mv	s0,a0
80004988:	00058993          	mv	s3,a1
8000498c:	00060a13          	mv	s4,a2
80004990:	04412483          	lw	s1,68(sp)
	__ASSERT(!z_is_in_isr(), "Threads may not be created in ISRs");
80004994:	04068e63          	beqz	a3,800049f0 <z_impl_k_thread_create+0x98>
80004998:	80006937          	lui	s2,0x80006
8000499c:	800065b7          	lui	a1,0x80006
800049a0:	80006537          	lui	a0,0x80006
800049a4:	1b200693          	li	a3,434
800049a8:	6d090613          	addi	a2,s2,1744 # 800066d0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800066d1>
800049ac:	4f458593          	addi	a1,a1,1268 # 800064f4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800064f5>
800049b0:	21850513          	addi	a0,a0,536 # 80006218 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006219>
800049b4:	01112e23          	sw	a7,28(sp)
800049b8:	01012c23          	sw	a6,24(sp)
800049bc:	00f12a23          	sw	a5,20(sp)
800049c0:	00e12823          	sw	a4,16(sp)
800049c4:	c90fd0ef          	jal	ra,80001e54 <printk>
800049c8:	80006537          	lui	a0,0x80006
800049cc:	6e450513          	addi	a0,a0,1764 # 800066e4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800066e5>
800049d0:	c84fd0ef          	jal	ra,80001e54 <printk>
800049d4:	1b200593          	li	a1,434
800049d8:	6d090513          	addi	a0,s2,1744
800049dc:	cb4fd0ef          	jal	ra,80001e90 <assert_post_action>
800049e0:	01c12883          	lw	a7,28(sp)
800049e4:	01812803          	lw	a6,24(sp)
800049e8:	01412783          	lw	a5,20(sp)
800049ec:	01012703          	lw	a4,16(sp)
	z_setup_new_thread(new_thread, stack, stack_size, entry, p1, p2, p3,
800049f0:	04012683          	lw	a3,64(sp)
800049f4:	00012223          	sw	zero,4(sp)
800049f8:	000a0613          	mv	a2,s4
800049fc:	00d12023          	sw	a3,0(sp)
80004a00:	00098593          	mv	a1,s3
80004a04:	000a8693          	mv	a3,s5
80004a08:	00040513          	mv	a0,s0
80004a0c:	cbdff0ef          	jal	ra,800046c8 <z_setup_new_thread>
	if (delay != K_FOREVER) {
80004a10:	fff00793          	li	a5,-1
80004a14:	00f48863          	beq	s1,a5,80004a24 <z_impl_k_thread_create+0xcc>
		schedule_new_thread(new_thread, delay);
80004a18:	00048593          	mv	a1,s1
80004a1c:	00040513          	mv	a0,s0
80004a20:	f11ff0ef          	jal	ra,80004930 <schedule_new_thread>
}
80004a24:	00040513          	mv	a0,s0
80004a28:	03c12083          	lw	ra,60(sp)
80004a2c:	03812403          	lw	s0,56(sp)
80004a30:	03412483          	lw	s1,52(sp)
80004a34:	03012903          	lw	s2,48(sp)
80004a38:	02c12983          	lw	s3,44(sp)
80004a3c:	02812a03          	lw	s4,40(sp)
80004a40:	02412a83          	lw	s5,36(sp)
80004a44:	04010113          	addi	sp,sp,64
80004a48:	00008067          	ret

80004a4c <z_init_static_threads>:
{
80004a4c:	fe010113          	addi	sp,sp,-32
	_FOREACH_STATIC_THREAD(thread_data) {
80004a50:	800077b7          	lui	a5,0x80007
{
80004a54:	01212823          	sw	s2,16(sp)
	_FOREACH_STATIC_THREAD(thread_data) {
80004a58:	80007937          	lui	s2,0x80007
{
80004a5c:	00812c23          	sw	s0,24(sp)
80004a60:	00912a23          	sw	s1,20(sp)
80004a64:	00112e23          	sw	ra,28(sp)
	_FOREACH_STATIC_THREAD(thread_data) {
80004a68:	8e078413          	addi	s0,a5,-1824 # 800068e0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800068e1>
80004a6c:	8e078493          	addi	s1,a5,-1824
80004a70:	8e090913          	addi	s2,s2,-1824 # 800068e0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800068e1>
80004a74:	03246663          	bltu	s0,s2,80004aa0 <z_init_static_threads+0x54>
	_FOREACH_STATIC_THREAD(thread_data) {
80004a78:	00048413          	mv	s0,s1
	k_sched_lock();
80004a7c:	cd4fe0ef          	jal	ra,80002f50 <k_sched_lock>
		if (thread_data->init_delay != K_FOREVER) {
80004a80:	fff00493          	li	s1,-1
	_FOREACH_STATIC_THREAD(thread_data) {
80004a84:	07246063          	bltu	s0,s2,80004ae4 <z_init_static_threads+0x98>
}
80004a88:	01812403          	lw	s0,24(sp)
80004a8c:	01c12083          	lw	ra,28(sp)
80004a90:	01412483          	lw	s1,20(sp)
80004a94:	01012903          	lw	s2,16(sp)
80004a98:	02010113          	addi	sp,sp,32
	k_sched_unlock();
80004a9c:	881fe06f          	j	8000331c <k_sched_unlock>
		z_setup_new_thread(
80004aa0:	02c42783          	lw	a5,44(s0)
80004aa4:	00f12223          	sw	a5,4(sp)
80004aa8:	02042783          	lw	a5,32(s0)
80004aac:	00f12023          	sw	a5,0(sp)
80004ab0:	01442783          	lw	a5,20(s0)
80004ab4:	01c42883          	lw	a7,28(s0)
80004ab8:	01842803          	lw	a6,24(s0)
80004abc:	01042703          	lw	a4,16(s0)
80004ac0:	00c42683          	lw	a3,12(s0)
80004ac4:	00842603          	lw	a2,8(s0)
80004ac8:	00442583          	lw	a1,4(s0)
80004acc:	00042503          	lw	a0,0(s0)
80004ad0:	bf9ff0ef          	jal	ra,800046c8 <z_setup_new_thread>
		thread_data->init_thread->init_data = thread_data;
80004ad4:	00042783          	lw	a5,0(s0)
80004ad8:	0487ae23          	sw	s0,92(a5)
	_FOREACH_STATIC_THREAD(thread_data) {
80004adc:	03040413          	addi	s0,s0,48
80004ae0:	f95ff06f          	j	80004a74 <z_init_static_threads+0x28>
		if (thread_data->init_delay != K_FOREVER) {
80004ae4:	02442583          	lw	a1,36(s0)
80004ae8:	00958663          	beq	a1,s1,80004af4 <z_init_static_threads+0xa8>
			schedule_new_thread(thread_data->init_thread,
80004aec:	00042503          	lw	a0,0(s0)
80004af0:	e41ff0ef          	jal	ra,80004930 <schedule_new_thread>
	_FOREACH_STATIC_THREAD(thread_data) {
80004af4:	03040413          	addi	s0,s0,48
80004af8:	f8dff06f          	j	80004a84 <z_init_static_threads+0x38>

80004afc <z_impl_k_thread_abort>:

extern void z_thread_single_abort(struct k_thread *thread);

#if !defined(CONFIG_ARCH_HAS_THREAD_ABORT)
void z_impl_k_thread_abort(k_tid_t thread)
{
80004afc:	fe010113          	addi	sp,sp,-32
80004b00:	00812c23          	sw	s0,24(sp)
80004b04:	00912a23          	sw	s1,20(sp)
80004b08:	00112e23          	sw	ra,28(sp)
80004b0c:	01212823          	sw	s2,16(sp)
80004b10:	00050493          	mv	s1,a0
	 * to have been in place to prevent the thread from waking up
	 * due to a delivered interrupt.  Leave a dummy spinlock in
	 * place to do that.  This API should be revisted though, it
	 * doesn't look SMP-safe as it stands.
	 */
	struct k_spinlock lock = {};
80004b14:	00012623          	sw	zero,12(sp)
	__asm__ volatile ("csrrc %0, mstatus, %1"
80004b18:	00800413          	li	s0,8
80004b1c:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80004b20:	00c10513          	addi	a0,sp,12
	key = (mstatus & SOC_MSTATUS_IEN);
80004b24:	00847413          	andi	s0,s0,8
80004b28:	c6dff0ef          	jal	ra,80004794 <z_spin_lock_valid>
80004b2c:	02051e63          	bnez	a0,80004b68 <z_impl_k_thread_abort+0x6c>
80004b30:	80006937          	lui	s2,0x80006
80004b34:	800065b7          	lui	a1,0x80006
80004b38:	80006537          	lui	a0,0x80006
80004b3c:	2fc58593          	addi	a1,a1,764 # 800062fc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800062fd>
80004b40:	04e00693          	li	a3,78
80004b44:	2e490613          	addi	a2,s2,740 # 800062e4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800062e5>
80004b48:	21850513          	addi	a0,a0,536 # 80006218 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006219>
80004b4c:	b08fd0ef          	jal	ra,80001e54 <printk>
80004b50:	80006537          	lui	a0,0x80006
80004b54:	31450513          	addi	a0,a0,788 # 80006314 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006315>
80004b58:	afcfd0ef          	jal	ra,80001e54 <printk>
80004b5c:	04e00593          	li	a1,78
80004b60:	2e490513          	addi	a0,s2,740
80004b64:	b2cfd0ef          	jal	ra,80001e90 <assert_post_action>
	z_spin_lock_set_owner(l);
80004b68:	00c10513          	addi	a0,sp,12
80004b6c:	c81ff0ef          	jal	ra,800047ec <z_spin_lock_set_owner>
	k_spinlock_key_t key = k_spin_lock(&lock);

	__ASSERT((thread->base.user_options & K_ESSENTIAL) == 0U,
80004b70:	00c4c783          	lbu	a5,12(s1)
80004b74:	0017f793          	andi	a5,a5,1
80004b78:	02078e63          	beqz	a5,80004bb4 <z_impl_k_thread_abort+0xb8>
80004b7c:	80006937          	lui	s2,0x80006
80004b80:	800065b7          	lui	a1,0x80006
80004b84:	80006537          	lui	a0,0x80006
80004b88:	72458593          	addi	a1,a1,1828 # 80006724 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006725>
80004b8c:	02900693          	li	a3,41
80004b90:	70c90613          	addi	a2,s2,1804 # 8000670c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000670d>
80004b94:	21850513          	addi	a0,a0,536 # 80006218 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006219>
80004b98:	abcfd0ef          	jal	ra,80001e54 <printk>
80004b9c:	80006537          	lui	a0,0x80006
80004ba0:	75850513          	addi	a0,a0,1880 # 80006758 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006759>
80004ba4:	ab0fd0ef          	jal	ra,80001e54 <printk>
80004ba8:	02900593          	li	a1,41
80004bac:	70c90513          	addi	a0,s2,1804
80004bb0:	ae0fd0ef          	jal	ra,80001e90 <assert_post_action>
		 "essential thread aborted");

	z_thread_single_abort(thread);
80004bb4:	00048513          	mv	a0,s1
80004bb8:	b4dff0ef          	jal	ra,80004704 <z_thread_single_abort>
	z_thread_monitor_exit(thread);

	z_reschedule(&lock, key);
80004bbc:	00040593          	mv	a1,s0
80004bc0:	00c10513          	addi	a0,sp,12
80004bc4:	a8cfe0ef          	jal	ra,80002e50 <z_reschedule>
}
80004bc8:	01c12083          	lw	ra,28(sp)
80004bcc:	01812403          	lw	s0,24(sp)
80004bd0:	01412483          	lw	s1,20(sp)
80004bd4:	01012903          	lw	s2,16(sp)
80004bd8:	02010113          	addi	sp,sp,32
80004bdc:	00008067          	ret

80004be0 <elapsed>:
	sys_dlist_remove(&t->node);
}

static s32_t elapsed(void)
{
	return announce_remaining == 0 ? z_clock_elapsed() : 0;
80004be0:	800077b7          	lui	a5,0x80007
80004be4:	98c7a783          	lw	a5,-1652(a5) # 8000698c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000698d>
80004be8:	00079463          	bnez	a5,80004bf0 <elapsed+0x10>
80004bec:	ef4fd06f          	j	800022e0 <z_clock_elapsed>
}
80004bf0:	00000513          	li	a0,0
80004bf4:	00008067          	ret

80004bf8 <remove_timeout>:
	return (node != NULL) ? sys_dlist_peek_next_no_check(list, node) : NULL;
80004bf8:	00052783          	lw	a5,0(a0)
80004bfc:	02050263          	beqz	a0,80004c20 <remove_timeout+0x28>
80004c00:	80007737          	lui	a4,0x80007
	return (node == list->tail) ? NULL : node->next;
80004c04:	8a472703          	lw	a4,-1884(a4) # 800068a4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800068a5>
80004c08:	00e50c63          	beq	a0,a4,80004c20 <remove_timeout+0x28>
	if (next(t) != NULL) {
80004c0c:	00078a63          	beqz	a5,80004c20 <remove_timeout+0x28>
		next(t)->dticks += t->dticks;
80004c10:	0087a703          	lw	a4,8(a5)
80004c14:	00852683          	lw	a3,8(a0)
80004c18:	00d70733          	add	a4,a4,a3
80004c1c:	00e7a423          	sw	a4,8(a5)
	node->prev->next = node->next;
80004c20:	00452703          	lw	a4,4(a0)
80004c24:	00f72023          	sw	a5,0(a4)
	node->next->prev = node->prev;
80004c28:	00e7a223          	sw	a4,4(a5)
	node->next = NULL;
80004c2c:	00052023          	sw	zero,0(a0)
	node->prev = NULL;
80004c30:	00052223          	sw	zero,4(a0)
}
80004c34:	00008067          	ret

80004c38 <next_timeout>:

static s32_t next_timeout(void)
{
	int maxw = can_wait_forever ? K_FOREVER : INT_MAX;
80004c38:	800077b7          	lui	a5,0x80007
80004c3c:	9987c783          	lbu	a5,-1640(a5) # 80006998 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006999>
{
80004c40:	ff010113          	addi	sp,sp,-16
80004c44:	00112623          	sw	ra,12(sp)
80004c48:	00812423          	sw	s0,8(sp)
80004c4c:	00912223          	sw	s1,4(sp)
80004c50:	fff00513          	li	a0,-1
	int maxw = can_wait_forever ? K_FOREVER : INT_MAX;
80004c54:	00079663          	bnez	a5,80004c60 <next_timeout+0x28>
80004c58:	80000537          	lui	a0,0x80000
80004c5c:	fff54513          	not	a0,a0
	return list->head == list;
80004c60:	800077b7          	lui	a5,0x80007
80004c64:	8a078793          	addi	a5,a5,-1888 # 800068a0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800068a1>
80004c68:	0007a403          	lw	s0,0(a5)
	return sys_dlist_is_empty(list) ? NULL : list->head;
80004c6c:	02f40463          	beq	s0,a5,80004c94 <next_timeout+0x5c>
	struct _timeout *to = first();
	s32_t ret = to == NULL ? maxw : MAX(0, to->dticks - elapsed());
80004c70:	02040263          	beqz	s0,80004c94 <next_timeout+0x5c>
80004c74:	00842483          	lw	s1,8(s0)
80004c78:	f69ff0ef          	jal	ra,80004be0 <elapsed>
80004c7c:	40a484b3          	sub	s1,s1,a0
80004c80:	00000513          	li	a0,0
80004c84:	0004c863          	bltz	s1,80004c94 <next_timeout+0x5c>
80004c88:	00842403          	lw	s0,8(s0)
80004c8c:	f55ff0ef          	jal	ra,80004be0 <elapsed>
80004c90:	40a40533          	sub	a0,s0,a0

#ifdef CONFIG_TIMESLICING
	if (_current_cpu->slice_ticks && _current_cpu->slice_ticks < ret) {
80004c94:	800077b7          	lui	a5,0x80007
80004c98:	cb47a783          	lw	a5,-844(a5) # 80006cb4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006cb5>
80004c9c:	00078663          	beqz	a5,80004ca8 <next_timeout+0x70>
80004ca0:	00a7d463          	bge	a5,a0,80004ca8 <next_timeout+0x70>
80004ca4:	00078513          	mv	a0,a5
		ret = _current_cpu->slice_ticks;
	}
#endif
	return ret;
}
80004ca8:	00c12083          	lw	ra,12(sp)
80004cac:	00812403          	lw	s0,8(sp)
80004cb0:	00412483          	lw	s1,4(sp)
80004cb4:	01010113          	addi	sp,sp,16
80004cb8:	00008067          	ret

80004cbc <z_add_timeout>:

void z_add_timeout(struct _timeout *to, _timeout_func_t fn, s32_t ticks)
{
	__ASSERT(!sys_dnode_is_linked(&to->node), "");
80004cbc:	00052783          	lw	a5,0(a0) # 80000000 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80000001>
{
80004cc0:	fd010113          	addi	sp,sp,-48
80004cc4:	02812423          	sw	s0,40(sp)
80004cc8:	02912223          	sw	s1,36(sp)
80004ccc:	01312e23          	sw	s3,28(sp)
80004cd0:	02112623          	sw	ra,44(sp)
80004cd4:	03212023          	sw	s2,32(sp)
80004cd8:	01412c23          	sw	s4,24(sp)
80004cdc:	01512a23          	sw	s5,20(sp)
80004ce0:	01612823          	sw	s6,16(sp)
80004ce4:	01712623          	sw	s7,12(sp)
80004ce8:	01812423          	sw	s8,8(sp)
80004cec:	00050413          	mv	s0,a0
80004cf0:	00058993          	mv	s3,a1
80004cf4:	00060493          	mv	s1,a2
	__ASSERT(!sys_dnode_is_linked(&to->node), "");
80004cf8:	02078e63          	beqz	a5,80004d34 <z_add_timeout+0x78>
80004cfc:	80006937          	lui	s2,0x80006
80004d00:	800065b7          	lui	a1,0x80006
80004d04:	80006537          	lui	a0,0x80006
80004d08:	78858593          	addi	a1,a1,1928 # 80006788 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006789>
80004d0c:	04d00693          	li	a3,77
80004d10:	77490613          	addi	a2,s2,1908 # 80006774 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006775>
80004d14:	21850513          	addi	a0,a0,536 # 80006218 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006219>
80004d18:	93cfd0ef          	jal	ra,80001e54 <printk>
80004d1c:	80006537          	lui	a0,0x80006
80004d20:	29c50513          	addi	a0,a0,668 # 8000629c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000629d>
80004d24:	930fd0ef          	jal	ra,80001e54 <printk>
80004d28:	04d00593          	li	a1,77
80004d2c:	77490513          	addi	a0,s2,1908
80004d30:	960fd0ef          	jal	ra,80001e90 <assert_post_action>
	to->fn = fn;
80004d34:	01342623          	sw	s3,12(s0)
	ticks = MAX(1, ticks);
80004d38:	00904463          	bgtz	s1,80004d40 <z_add_timeout+0x84>
80004d3c:	00100493          	li	s1,1
	__asm__ volatile ("csrrc %0, mstatus, %1"
80004d40:	00800993          	li	s3,8
80004d44:	3009b9f3          	csrrc	s3,mstatus,s3
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80004d48:	80007a37          	lui	s4,0x80007
80004d4c:	990a0513          	addi	a0,s4,-1648 # 80006990 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006991>
	key = (mstatus & SOC_MSTATUS_IEN);
80004d50:	0089f993          	andi	s3,s3,8
80004d54:	a41ff0ef          	jal	ra,80004794 <z_spin_lock_valid>
80004d58:	02051e63          	bnez	a0,80004d94 <z_add_timeout+0xd8>
80004d5c:	80006937          	lui	s2,0x80006
80004d60:	800065b7          	lui	a1,0x80006
80004d64:	80006537          	lui	a0,0x80006
80004d68:	2fc58593          	addi	a1,a1,764 # 800062fc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800062fd>
80004d6c:	04e00693          	li	a3,78
80004d70:	2e490613          	addi	a2,s2,740 # 800062e4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800062e5>
80004d74:	21850513          	addi	a0,a0,536 # 80006218 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006219>
80004d78:	8dcfd0ef          	jal	ra,80001e54 <printk>
80004d7c:	80006537          	lui	a0,0x80006
80004d80:	31450513          	addi	a0,a0,788 # 80006314 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006315>
80004d84:	8d0fd0ef          	jal	ra,80001e54 <printk>
80004d88:	04e00593          	li	a1,78
80004d8c:	2e490513          	addi	a0,s2,740
80004d90:	900fd0ef          	jal	ra,80001e90 <assert_post_action>
	z_spin_lock_set_owner(l);
80004d94:	990a0513          	addi	a0,s4,-1648
80004d98:	a55ff0ef          	jal	ra,800047ec <z_spin_lock_set_owner>

	LOCKED(&timeout_lock) {
		struct _timeout *t;

		to->dticks = ticks + elapsed();
80004d9c:	e45ff0ef          	jal	ra,80004be0 <elapsed>
80004da0:	00950533          	add	a0,a0,s1
	return list->head == list;
80004da4:	800074b7          	lui	s1,0x80007
80004da8:	8a04a903          	lw	s2,-1888(s1) # 800068a0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800068a1>
80004dac:	00a42423          	sw	a0,8(s0)
80004db0:	8a048493          	addi	s1,s1,-1888
	return sys_dlist_is_empty(list) ? NULL : list->head;
80004db4:	00990c63          	beq	s2,s1,80004dcc <z_add_timeout+0x110>
		for (t = first(); t != NULL; t = next(t)) {
			__ASSERT(t->dticks >= 0, "");
80004db8:	80006ab7          	lui	s5,0x80006
80004dbc:	80006b37          	lui	s6,0x80006
80004dc0:	80006bb7          	lui	s7,0x80006
80004dc4:	80006c37          	lui	s8,0x80006
		for (t = first(); t != NULL; t = next(t)) {
80004dc8:	02091063          	bnez	s2,80004de8 <z_add_timeout+0x12c>
	node->prev = list->tail;
80004dcc:	0044a783          	lw	a5,4(s1)
	node->next = list;
80004dd0:	00942023          	sw	s1,0(s0)
	node->prev = list->tail;
80004dd4:	00f42223          	sw	a5,4(s0)
	list->tail->next = node;
80004dd8:	0044a783          	lw	a5,4(s1)
80004ddc:	0087a023          	sw	s0,0(a5)
	list->tail = node;
80004de0:	0084a223          	sw	s0,4(s1)
80004de4:	05c0006f          	j	80004e40 <z_add_timeout+0x184>
			__ASSERT(t->dticks >= 0, "");
80004de8:	00892783          	lw	a5,8(s2)
80004dec:	0207d663          	bgez	a5,80004e18 <z_add_timeout+0x15c>
80004df0:	7a8b0593          	addi	a1,s6,1960 # 800067a8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800067a9>
80004df4:	05600693          	li	a3,86
80004df8:	774a8613          	addi	a2,s5,1908 # 80006774 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006775>
80004dfc:	218b8513          	addi	a0,s7,536 # 80006218 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006219>
80004e00:	854fd0ef          	jal	ra,80001e54 <printk>
80004e04:	29cc0513          	addi	a0,s8,668 # 8000629c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000629d>
80004e08:	84cfd0ef          	jal	ra,80001e54 <printk>
80004e0c:	05600593          	li	a1,86
80004e10:	774a8513          	addi	a0,s5,1908
80004e14:	87cfd0ef          	jal	ra,80001e90 <assert_post_action>

			if (t->dticks > to->dticks) {
80004e18:	00892703          	lw	a4,8(s2)
80004e1c:	00842783          	lw	a5,8(s0)
80004e20:	0ae7d863          	bge	a5,a4,80004ed0 <z_add_timeout+0x214>
				t->dticks -= to->dticks;
80004e24:	40f707b3          	sub	a5,a4,a5
80004e28:	00f92423          	sw	a5,8(s2)
	node->prev = successor->prev;
80004e2c:	00492783          	lw	a5,4(s2)
	node->next = successor;
80004e30:	01242023          	sw	s2,0(s0)
	node->prev = successor->prev;
80004e34:	00f42223          	sw	a5,4(s0)
	successor->prev->next = node;
80004e38:	0087a023          	sw	s0,0(a5)
	successor->prev = node;
80004e3c:	00892223          	sw	s0,4(s2)
	return list->head == list;
80004e40:	0004a783          	lw	a5,0(s1)
	return sys_dlist_is_empty(list) ? NULL : list->head;
80004e44:	00978a63          	beq	a5,s1,80004e58 <z_add_timeout+0x19c>

		if (t == NULL) {
			sys_dlist_append(&timeout_list, &to->node);
		}

		if (to == first()) {
80004e48:	00f41863          	bne	s0,a5,80004e58 <z_add_timeout+0x19c>
			z_clock_set_timeout(next_timeout(), false);
80004e4c:	dedff0ef          	jal	ra,80004c38 <next_timeout>
80004e50:	00000593          	li	a1,0
80004e54:	b10fd0ef          	jal	ra,80002164 <z_clock_set_timeout>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80004e58:	990a0513          	addi	a0,s4,-1648
80004e5c:	961ff0ef          	jal	ra,800047bc <z_spin_unlock_valid>
80004e60:	02051e63          	bnez	a0,80004e9c <z_add_timeout+0x1e0>
80004e64:	80006437          	lui	s0,0x80006
80004e68:	800065b7          	lui	a1,0x80006
80004e6c:	80006537          	lui	a0,0x80006
80004e70:	32c58593          	addi	a1,a1,812 # 8000632c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000632d>
80004e74:	06100693          	li	a3,97
80004e78:	2e440613          	addi	a2,s0,740 # 800062e4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800062e5>
80004e7c:	21850513          	addi	a0,a0,536 # 80006218 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006219>
80004e80:	fd5fc0ef          	jal	ra,80001e54 <printk>
80004e84:	80006537          	lui	a0,0x80006
80004e88:	34450513          	addi	a0,a0,836 # 80006344 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006345>
80004e8c:	fc9fc0ef          	jal	ra,80001e54 <printk>
80004e90:	06100593          	li	a1,97
80004e94:	2e440513          	addi	a0,s0,740
80004e98:	ff9fc0ef          	jal	ra,80001e90 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80004e9c:	3009a9f3          	csrrs	s3,mstatus,s3
		}
	}
}
80004ea0:	02c12083          	lw	ra,44(sp)
80004ea4:	02812403          	lw	s0,40(sp)
80004ea8:	02412483          	lw	s1,36(sp)
80004eac:	02012903          	lw	s2,32(sp)
80004eb0:	01c12983          	lw	s3,28(sp)
80004eb4:	01812a03          	lw	s4,24(sp)
80004eb8:	01412a83          	lw	s5,20(sp)
80004ebc:	01012b03          	lw	s6,16(sp)
80004ec0:	00c12b83          	lw	s7,12(sp)
80004ec4:	00812c03          	lw	s8,8(sp)
80004ec8:	03010113          	addi	sp,sp,48
80004ecc:	00008067          	ret
			to->dticks -= t->dticks;
80004ed0:	40e787b3          	sub	a5,a5,a4
80004ed4:	00f42423          	sw	a5,8(s0)
	return (node == list->tail) ? NULL : node->next;
80004ed8:	0044a783          	lw	a5,4(s1)
80004edc:	ef2788e3          	beq	a5,s2,80004dcc <z_add_timeout+0x110>
80004ee0:	00092903          	lw	s2,0(s2)
80004ee4:	ee5ff06f          	j	80004dc8 <z_add_timeout+0x10c>

80004ee8 <z_abort_timeout>:

int z_abort_timeout(struct _timeout *to)
{
80004ee8:	fe010113          	addi	sp,sp,-32
80004eec:	00812c23          	sw	s0,24(sp)
80004ef0:	01312623          	sw	s3,12(sp)
80004ef4:	00112e23          	sw	ra,28(sp)
80004ef8:	00912a23          	sw	s1,20(sp)
80004efc:	01212823          	sw	s2,16(sp)
80004f00:	00050993          	mv	s3,a0
	__asm__ volatile ("csrrc %0, mstatus, %1"
80004f04:	00800413          	li	s0,8
80004f08:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80004f0c:	800074b7          	lui	s1,0x80007
80004f10:	99048513          	addi	a0,s1,-1648 # 80006990 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006991>
	key = (mstatus & SOC_MSTATUS_IEN);
80004f14:	00847413          	andi	s0,s0,8
80004f18:	87dff0ef          	jal	ra,80004794 <z_spin_lock_valid>
80004f1c:	02051e63          	bnez	a0,80004f58 <z_abort_timeout+0x70>
80004f20:	80006937          	lui	s2,0x80006
80004f24:	800065b7          	lui	a1,0x80006
80004f28:	80006537          	lui	a0,0x80006
80004f2c:	2fc58593          	addi	a1,a1,764 # 800062fc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800062fd>
80004f30:	04e00693          	li	a3,78
80004f34:	2e490613          	addi	a2,s2,740 # 800062e4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800062e5>
80004f38:	21850513          	addi	a0,a0,536 # 80006218 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006219>
80004f3c:	f19fc0ef          	jal	ra,80001e54 <printk>
80004f40:	80006537          	lui	a0,0x80006
80004f44:	31450513          	addi	a0,a0,788 # 80006314 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006315>
80004f48:	f0dfc0ef          	jal	ra,80001e54 <printk>
80004f4c:	04e00593          	li	a1,78
80004f50:	2e490513          	addi	a0,s2,740
80004f54:	f3dfc0ef          	jal	ra,80001e90 <assert_post_action>
	z_spin_lock_set_owner(l);
80004f58:	99048513          	addi	a0,s1,-1648
80004f5c:	891ff0ef          	jal	ra,800047ec <z_spin_lock_set_owner>
	int ret = -EINVAL;

	LOCKED(&timeout_lock) {
		if (sys_dnode_is_linked(&to->node)) {
80004f60:	0009a783          	lw	a5,0(s3)
	int ret = -EINVAL;
80004f64:	fea00913          	li	s2,-22
		if (sys_dnode_is_linked(&to->node)) {
80004f68:	00078863          	beqz	a5,80004f78 <z_abort_timeout+0x90>
			remove_timeout(to);
80004f6c:	00098513          	mv	a0,s3
80004f70:	c89ff0ef          	jal	ra,80004bf8 <remove_timeout>
			ret = 0;
80004f74:	00000913          	li	s2,0
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80004f78:	99048513          	addi	a0,s1,-1648
80004f7c:	841ff0ef          	jal	ra,800047bc <z_spin_unlock_valid>
80004f80:	02051e63          	bnez	a0,80004fbc <z_abort_timeout+0xd4>
80004f84:	800064b7          	lui	s1,0x80006
80004f88:	800065b7          	lui	a1,0x80006
80004f8c:	80006537          	lui	a0,0x80006
80004f90:	32c58593          	addi	a1,a1,812 # 8000632c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000632d>
80004f94:	06100693          	li	a3,97
80004f98:	2e448613          	addi	a2,s1,740 # 800062e4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800062e5>
80004f9c:	21850513          	addi	a0,a0,536 # 80006218 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006219>
80004fa0:	eb5fc0ef          	jal	ra,80001e54 <printk>
80004fa4:	80006537          	lui	a0,0x80006
80004fa8:	34450513          	addi	a0,a0,836 # 80006344 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006345>
80004fac:	ea9fc0ef          	jal	ra,80001e54 <printk>
80004fb0:	06100593          	li	a1,97
80004fb4:	2e448513          	addi	a0,s1,740
80004fb8:	ed9fc0ef          	jal	ra,80001e90 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80004fbc:	30042473          	csrrs	s0,mstatus,s0
		}
	}

	return ret;
}
80004fc0:	01c12083          	lw	ra,28(sp)
80004fc4:	01812403          	lw	s0,24(sp)
80004fc8:	00090513          	mv	a0,s2
80004fcc:	01412483          	lw	s1,20(sp)
80004fd0:	01012903          	lw	s2,16(sp)
80004fd4:	00c12983          	lw	s3,12(sp)
80004fd8:	02010113          	addi	sp,sp,32
80004fdc:	00008067          	ret

80004fe0 <z_get_next_timeout_expiry>:

	return ticks - elapsed();
}

s32_t z_get_next_timeout_expiry(void)
{
80004fe0:	ff010113          	addi	sp,sp,-16
80004fe4:	00812423          	sw	s0,8(sp)
80004fe8:	00112623          	sw	ra,12(sp)
80004fec:	00912223          	sw	s1,4(sp)
80004ff0:	01212023          	sw	s2,0(sp)
	__asm__ volatile ("csrrc %0, mstatus, %1"
80004ff4:	00800413          	li	s0,8
80004ff8:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80004ffc:	800074b7          	lui	s1,0x80007
80005000:	99048513          	addi	a0,s1,-1648 # 80006990 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006991>
	key = (mstatus & SOC_MSTATUS_IEN);
80005004:	00847413          	andi	s0,s0,8
80005008:	f8cff0ef          	jal	ra,80004794 <z_spin_lock_valid>
8000500c:	02051e63          	bnez	a0,80005048 <z_get_next_timeout_expiry+0x68>
80005010:	80006937          	lui	s2,0x80006
80005014:	800065b7          	lui	a1,0x80006
80005018:	80006537          	lui	a0,0x80006
8000501c:	2fc58593          	addi	a1,a1,764 # 800062fc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800062fd>
80005020:	04e00693          	li	a3,78
80005024:	2e490613          	addi	a2,s2,740 # 800062e4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800062e5>
80005028:	21850513          	addi	a0,a0,536 # 80006218 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006219>
8000502c:	e29fc0ef          	jal	ra,80001e54 <printk>
80005030:	80006537          	lui	a0,0x80006
80005034:	31450513          	addi	a0,a0,788 # 80006314 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006315>
80005038:	e1dfc0ef          	jal	ra,80001e54 <printk>
8000503c:	04e00593          	li	a1,78
80005040:	2e490513          	addi	a0,s2,740
80005044:	e4dfc0ef          	jal	ra,80001e90 <assert_post_action>
	z_spin_lock_set_owner(l);
80005048:	99048513          	addi	a0,s1,-1648
8000504c:	fa0ff0ef          	jal	ra,800047ec <z_spin_lock_set_owner>
	s32_t ret = K_FOREVER;

	LOCKED(&timeout_lock) {
		ret = next_timeout();
80005050:	be9ff0ef          	jal	ra,80004c38 <next_timeout>
80005054:	00050913          	mv	s2,a0
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80005058:	99048513          	addi	a0,s1,-1648
8000505c:	f60ff0ef          	jal	ra,800047bc <z_spin_unlock_valid>
80005060:	02051e63          	bnez	a0,8000509c <z_get_next_timeout_expiry+0xbc>
80005064:	800064b7          	lui	s1,0x80006
80005068:	800065b7          	lui	a1,0x80006
8000506c:	80006537          	lui	a0,0x80006
80005070:	32c58593          	addi	a1,a1,812 # 8000632c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000632d>
80005074:	06100693          	li	a3,97
80005078:	2e448613          	addi	a2,s1,740 # 800062e4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800062e5>
8000507c:	21850513          	addi	a0,a0,536 # 80006218 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006219>
80005080:	dd5fc0ef          	jal	ra,80001e54 <printk>
80005084:	80006537          	lui	a0,0x80006
80005088:	34450513          	addi	a0,a0,836 # 80006344 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006345>
8000508c:	dc9fc0ef          	jal	ra,80001e54 <printk>
80005090:	06100593          	li	a1,97
80005094:	2e448513          	addi	a0,s1,740
80005098:	df9fc0ef          	jal	ra,80001e90 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
8000509c:	30042473          	csrrs	s0,mstatus,s0
	}
	return ret;
}
800050a0:	00c12083          	lw	ra,12(sp)
800050a4:	00812403          	lw	s0,8(sp)
800050a8:	00090513          	mv	a0,s2
800050ac:	00412483          	lw	s1,4(sp)
800050b0:	00012903          	lw	s2,0(sp)
800050b4:	01010113          	addi	sp,sp,16
800050b8:	00008067          	ret

800050bc <z_set_timeout_expiry>:

void z_set_timeout_expiry(s32_t ticks, bool idle)
{
800050bc:	fe010113          	addi	sp,sp,-32
800050c0:	00812c23          	sw	s0,24(sp)
800050c4:	01212823          	sw	s2,16(sp)
800050c8:	01412423          	sw	s4,8(sp)
800050cc:	00112e23          	sw	ra,28(sp)
800050d0:	00912a23          	sw	s1,20(sp)
800050d4:	01312623          	sw	s3,12(sp)
800050d8:	00050913          	mv	s2,a0
800050dc:	00058a13          	mv	s4,a1
	__asm__ volatile ("csrrc %0, mstatus, %1"
800050e0:	00800413          	li	s0,8
800050e4:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
800050e8:	800074b7          	lui	s1,0x80007
800050ec:	99048513          	addi	a0,s1,-1648 # 80006990 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006991>
	key = (mstatus & SOC_MSTATUS_IEN);
800050f0:	00847413          	andi	s0,s0,8
800050f4:	ea0ff0ef          	jal	ra,80004794 <z_spin_lock_valid>
800050f8:	02051e63          	bnez	a0,80005134 <z_set_timeout_expiry+0x78>
800050fc:	800069b7          	lui	s3,0x80006
80005100:	800065b7          	lui	a1,0x80006
80005104:	80006537          	lui	a0,0x80006
80005108:	2fc58593          	addi	a1,a1,764 # 800062fc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800062fd>
8000510c:	04e00693          	li	a3,78
80005110:	2e498613          	addi	a2,s3,740 # 800062e4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800062e5>
80005114:	21850513          	addi	a0,a0,536 # 80006218 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006219>
80005118:	d3dfc0ef          	jal	ra,80001e54 <printk>
8000511c:	80006537          	lui	a0,0x80006
80005120:	31450513          	addi	a0,a0,788 # 80006314 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006315>
80005124:	d31fc0ef          	jal	ra,80001e54 <printk>
80005128:	04e00593          	li	a1,78
8000512c:	2e498513          	addi	a0,s3,740
80005130:	d61fc0ef          	jal	ra,80001e90 <assert_post_action>
	z_spin_lock_set_owner(l);
80005134:	99048513          	addi	a0,s1,-1648
80005138:	eb4ff0ef          	jal	ra,800047ec <z_spin_lock_set_owner>
	LOCKED(&timeout_lock) {
		int next = next_timeout();
8000513c:	afdff0ef          	jal	ra,80004c38 <next_timeout>
		 * what we have.  Also don't try to set a timeout when
		 * one is about to expire: drivers have internal logic
		 * that will bump the timeout to the "next" tick if
		 * it's not considered to be settable as directed.
		 */
		if (sooner && !imminent) {
80005140:	00a95c63          	bge	s2,a0,80005158 <z_set_timeout_expiry+0x9c>
80005144:	00100793          	li	a5,1
80005148:	00a7d863          	bge	a5,a0,80005158 <z_set_timeout_expiry+0x9c>
			z_clock_set_timeout(ticks, idle);
8000514c:	000a0593          	mv	a1,s4
80005150:	00090513          	mv	a0,s2
80005154:	810fd0ef          	jal	ra,80002164 <z_clock_set_timeout>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80005158:	99048513          	addi	a0,s1,-1648
8000515c:	e60ff0ef          	jal	ra,800047bc <z_spin_unlock_valid>
80005160:	02051e63          	bnez	a0,8000519c <z_set_timeout_expiry+0xe0>
80005164:	800064b7          	lui	s1,0x80006
80005168:	800065b7          	lui	a1,0x80006
8000516c:	80006537          	lui	a0,0x80006
80005170:	32c58593          	addi	a1,a1,812 # 8000632c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000632d>
80005174:	06100693          	li	a3,97
80005178:	2e448613          	addi	a2,s1,740 # 800062e4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800062e5>
8000517c:	21850513          	addi	a0,a0,536 # 80006218 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006219>
80005180:	cd5fc0ef          	jal	ra,80001e54 <printk>
80005184:	80006537          	lui	a0,0x80006
80005188:	34450513          	addi	a0,a0,836 # 80006344 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006345>
8000518c:	cc9fc0ef          	jal	ra,80001e54 <printk>
80005190:	06100593          	li	a1,97
80005194:	2e448513          	addi	a0,s1,740
80005198:	cf9fc0ef          	jal	ra,80001e90 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
8000519c:	30042473          	csrrs	s0,mstatus,s0
		}
	}
}
800051a0:	01c12083          	lw	ra,28(sp)
800051a4:	01812403          	lw	s0,24(sp)
800051a8:	01412483          	lw	s1,20(sp)
800051ac:	01012903          	lw	s2,16(sp)
800051b0:	00c12983          	lw	s3,12(sp)
800051b4:	00812a03          	lw	s4,8(sp)
800051b8:	02010113          	addi	sp,sp,32
800051bc:	00008067          	ret

800051c0 <z_clock_announce>:

void z_clock_announce(s32_t ticks)
{
800051c0:	fd010113          	addi	sp,sp,-48
800051c4:	02812423          	sw	s0,40(sp)
800051c8:	01412c23          	sw	s4,24(sp)
800051cc:	02112623          	sw	ra,44(sp)
800051d0:	02912223          	sw	s1,36(sp)
800051d4:	03212023          	sw	s2,32(sp)
800051d8:	01312e23          	sw	s3,28(sp)
800051dc:	01512a23          	sw	s5,20(sp)
800051e0:	01612823          	sw	s6,16(sp)
800051e4:	01712623          	sw	s7,12(sp)
800051e8:	01812423          	sw	s8,8(sp)
800051ec:	01912223          	sw	s9,4(sp)
800051f0:	01a12023          	sw	s10,0(sp)
800051f4:	00050a13          	mv	s4,a0
	__asm__ volatile ("csrrc %0, mstatus, %1"
800051f8:	00800413          	li	s0,8
#ifdef CONFIG_TIMESLICING
	z_time_slice(ticks);
800051fc:	f30fe0ef          	jal	ra,8000392c <z_time_slice>
80005200:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80005204:	80007937          	lui	s2,0x80007
80005208:	99090513          	addi	a0,s2,-1648 # 80006990 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006991>
	key = (mstatus & SOC_MSTATUS_IEN);
8000520c:	00847413          	andi	s0,s0,8
80005210:	d84ff0ef          	jal	ra,80004794 <z_spin_lock_valid>
80005214:	02051e63          	bnez	a0,80005250 <z_clock_announce+0x90>
80005218:	800064b7          	lui	s1,0x80006
8000521c:	800065b7          	lui	a1,0x80006
80005220:	80006537          	lui	a0,0x80006
80005224:	2fc58593          	addi	a1,a1,764 # 800062fc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800062fd>
80005228:	04e00693          	li	a3,78
8000522c:	2e448613          	addi	a2,s1,740 # 800062e4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800062e5>
80005230:	21850513          	addi	a0,a0,536 # 80006218 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006219>
80005234:	c21fc0ef          	jal	ra,80001e54 <printk>
80005238:	80006537          	lui	a0,0x80006
8000523c:	31450513          	addi	a0,a0,788 # 80006314 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006315>
80005240:	c15fc0ef          	jal	ra,80001e54 <printk>
80005244:	04e00593          	li	a1,78
80005248:	2e448513          	addi	a0,s1,740
8000524c:	c45fc0ef          	jal	ra,80001e90 <assert_post_action>
#endif

	k_spinlock_key_t key = k_spin_lock(&timeout_lock);

	announce_remaining = ticks;
80005250:	800079b7          	lui	s3,0x80007
	z_spin_lock_set_owner(l);
80005254:	99090513          	addi	a0,s2,-1648
80005258:	d94ff0ef          	jal	ra,800047ec <z_spin_lock_set_owner>
8000525c:	800074b7          	lui	s1,0x80007
80005260:	9949a623          	sw	s4,-1652(s3) # 8000698c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000698d>
	return list->head == list;
80005264:	80007a37          	lui	s4,0x80007
80005268:	98c98993          	addi	s3,s3,-1652
8000526c:	8a0a0a13          	addi	s4,s4,-1888 # 800068a0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800068a1>
80005270:	95048493          	addi	s1,s1,-1712 # 80006950 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006951>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80005274:	80006ab7          	lui	s5,0x80006
80005278:	80006bb7          	lui	s7,0x80006
8000527c:	80006b37          	lui	s6,0x80006
80005280:	80006c37          	lui	s8,0x80006
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80005284:	80006cb7          	lui	s9,0x80006
80005288:	000a2d03          	lw	s10,0(s4)
8000528c:	0009a783          	lw	a5,0(s3)
80005290:	0004a683          	lw	a3,0(s1)
80005294:	0044a503          	lw	a0,4(s1)
	return sys_dlist_is_empty(list) ? NULL : list->head;
80005298:	014d0c63          	beq	s10,s4,800052b0 <z_clock_announce+0xf0>

	while (first() != NULL && first()->dticks <= announce_remaining) {
8000529c:	000d0a63          	beqz	s10,800052b0 <z_clock_announce+0xf0>
800052a0:	008d2703          	lw	a4,8(s10)
800052a4:	0ae7dc63          	bge	a5,a4,8000535c <z_clock_announce+0x19c>
		t->fn(t);
		key = k_spin_lock(&timeout_lock);
	}

	if (first() != NULL) {
		first()->dticks -= announce_remaining;
800052a8:	40f70733          	sub	a4,a4,a5
800052ac:	00ed2423          	sw	a4,8(s10)
	}

	curr_tick += announce_remaining;
800052b0:	00d786b3          	add	a3,a5,a3
800052b4:	41f7d713          	srai	a4,a5,0x1f
800052b8:	00a70733          	add	a4,a4,a0
800052bc:	00f6b7b3          	sltu	a5,a3,a5
800052c0:	00e787b3          	add	a5,a5,a4
800052c4:	00d4a023          	sw	a3,0(s1)
800052c8:	00f4a223          	sw	a5,4(s1)
	announce_remaining = 0;
800052cc:	0009a023          	sw	zero,0(s3)

	z_clock_set_timeout(next_timeout(), false);
800052d0:	969ff0ef          	jal	ra,80004c38 <next_timeout>
800052d4:	00000593          	li	a1,0
800052d8:	e8dfc0ef          	jal	ra,80002164 <z_clock_set_timeout>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
800052dc:	99090513          	addi	a0,s2,-1648
800052e0:	cdcff0ef          	jal	ra,800047bc <z_spin_unlock_valid>
800052e4:	02051e63          	bnez	a0,80005320 <z_clock_announce+0x160>
800052e8:	800064b7          	lui	s1,0x80006
800052ec:	800065b7          	lui	a1,0x80006
800052f0:	80006537          	lui	a0,0x80006
800052f4:	32c58593          	addi	a1,a1,812 # 8000632c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000632d>
800052f8:	06100693          	li	a3,97
800052fc:	2e448613          	addi	a2,s1,740 # 800062e4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800062e5>
80005300:	21850513          	addi	a0,a0,536 # 80006218 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006219>
80005304:	b51fc0ef          	jal	ra,80001e54 <printk>
80005308:	80006537          	lui	a0,0x80006
8000530c:	34450513          	addi	a0,a0,836 # 80006344 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006345>
80005310:	b45fc0ef          	jal	ra,80001e54 <printk>
80005314:	06100593          	li	a1,97
80005318:	2e448513          	addi	a0,s1,740
8000531c:	b75fc0ef          	jal	ra,80001e90 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80005320:	30042473          	csrrs	s0,mstatus,s0

	k_spin_unlock(&timeout_lock, key);
}
80005324:	02c12083          	lw	ra,44(sp)
80005328:	02812403          	lw	s0,40(sp)
8000532c:	02412483          	lw	s1,36(sp)
80005330:	02012903          	lw	s2,32(sp)
80005334:	01c12983          	lw	s3,28(sp)
80005338:	01812a03          	lw	s4,24(sp)
8000533c:	01412a83          	lw	s5,20(sp)
80005340:	01012b03          	lw	s6,16(sp)
80005344:	00c12b83          	lw	s7,12(sp)
80005348:	00812c03          	lw	s8,8(sp)
8000534c:	00412c83          	lw	s9,4(sp)
80005350:	00012d03          	lw	s10,0(sp)
80005354:	03010113          	addi	sp,sp,48
80005358:	00008067          	ret
		curr_tick += dt;
8000535c:	00d706b3          	add	a3,a4,a3
80005360:	41f75593          	srai	a1,a4,0x1f
80005364:	00a585b3          	add	a1,a1,a0
80005368:	00e6b633          	sltu	a2,a3,a4
8000536c:	00b60633          	add	a2,a2,a1
		announce_remaining -= dt;
80005370:	40e787b3          	sub	a5,a5,a4
		remove_timeout(t);
80005374:	000d0513          	mv	a0,s10
		t->dticks = 0;
80005378:	000d2423          	sw	zero,8(s10)
		curr_tick += dt;
8000537c:	00d4a023          	sw	a3,0(s1)
80005380:	00c4a223          	sw	a2,4(s1)
		announce_remaining -= dt;
80005384:	00f9a023          	sw	a5,0(s3)
		remove_timeout(t);
80005388:	871ff0ef          	jal	ra,80004bf8 <remove_timeout>
8000538c:	99090513          	addi	a0,s2,-1648
80005390:	c2cff0ef          	jal	ra,800047bc <z_spin_unlock_valid>
80005394:	02051663          	bnez	a0,800053c0 <z_clock_announce+0x200>
80005398:	32cb8593          	addi	a1,s7,812 # 8000632c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000632d>
8000539c:	06100693          	li	a3,97
800053a0:	2e4a8613          	addi	a2,s5,740 # 800062e4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800062e5>
800053a4:	218b0513          	addi	a0,s6,536 # 80006218 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006219>
800053a8:	aadfc0ef          	jal	ra,80001e54 <printk>
800053ac:	344c0513          	addi	a0,s8,836 # 80006344 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006345>
800053b0:	aa5fc0ef          	jal	ra,80001e54 <printk>
800053b4:	06100593          	li	a1,97
800053b8:	2e4a8513          	addi	a0,s5,740
800053bc:	ad5fc0ef          	jal	ra,80001e90 <assert_post_action>
800053c0:	30042473          	csrrs	s0,mstatus,s0
		t->fn(t);
800053c4:	00cd2783          	lw	a5,12(s10)
800053c8:	000d0513          	mv	a0,s10
	__asm__ volatile ("csrrc %0, mstatus, %1"
800053cc:	00800413          	li	s0,8
800053d0:	000780e7          	jalr	a5
800053d4:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
800053d8:	99090513          	addi	a0,s2,-1648
	key = (mstatus & SOC_MSTATUS_IEN);
800053dc:	00847413          	andi	s0,s0,8
800053e0:	bb4ff0ef          	jal	ra,80004794 <z_spin_lock_valid>
800053e4:	02051863          	bnez	a0,80005414 <z_clock_announce+0x254>
800053e8:	2fcc8593          	addi	a1,s9,764 # 800062fc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800062fd>
800053ec:	04e00693          	li	a3,78
800053f0:	2e4a8613          	addi	a2,s5,740
800053f4:	218b0513          	addi	a0,s6,536
800053f8:	a5dfc0ef          	jal	ra,80001e54 <printk>
800053fc:	80006537          	lui	a0,0x80006
80005400:	31450513          	addi	a0,a0,788 # 80006314 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006315>
80005404:	a51fc0ef          	jal	ra,80001e54 <printk>
80005408:	04e00593          	li	a1,78
8000540c:	2e4a8513          	addi	a0,s5,740
80005410:	a81fc0ef          	jal	ra,80001e90 <assert_post_action>
	z_spin_lock_set_owner(l);
80005414:	99090513          	addi	a0,s2,-1648
80005418:	bd4ff0ef          	jal	ra,800047ec <z_spin_lock_set_owner>
	return k;
8000541c:	e6dff06f          	j	80005288 <z_clock_announce+0xc8>

80005420 <z_tick_get>:
{
	can_wait_forever = 1;
}

s64_t z_tick_get(void)
{
80005420:	fe010113          	addi	sp,sp,-32
80005424:	00912a23          	sw	s1,20(sp)
80005428:	00112e23          	sw	ra,28(sp)
8000542c:	00812c23          	sw	s0,24(sp)
80005430:	01212823          	sw	s2,16(sp)
80005434:	01312623          	sw	s3,12(sp)
	__asm__ volatile ("csrrc %0, mstatus, %1"
80005438:	00800493          	li	s1,8
8000543c:	3004b4f3          	csrrc	s1,mstatus,s1
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80005440:	80007937          	lui	s2,0x80007
80005444:	99090513          	addi	a0,s2,-1648 # 80006990 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006991>
	key = (mstatus & SOC_MSTATUS_IEN);
80005448:	0084f493          	andi	s1,s1,8
8000544c:	b48ff0ef          	jal	ra,80004794 <z_spin_lock_valid>
80005450:	02051e63          	bnez	a0,8000548c <z_tick_get+0x6c>
80005454:	80006437          	lui	s0,0x80006
80005458:	800065b7          	lui	a1,0x80006
8000545c:	80006537          	lui	a0,0x80006
80005460:	2fc58593          	addi	a1,a1,764 # 800062fc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800062fd>
80005464:	04e00693          	li	a3,78
80005468:	2e440613          	addi	a2,s0,740 # 800062e4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800062e5>
8000546c:	21850513          	addi	a0,a0,536 # 80006218 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006219>
80005470:	9e5fc0ef          	jal	ra,80001e54 <printk>
80005474:	80006537          	lui	a0,0x80006
80005478:	31450513          	addi	a0,a0,788 # 80006314 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006315>
8000547c:	9d9fc0ef          	jal	ra,80001e54 <printk>
80005480:	04e00593          	li	a1,78
80005484:	2e440513          	addi	a0,s0,740
80005488:	a09fc0ef          	jal	ra,80001e90 <assert_post_action>
	z_spin_lock_set_owner(l);
8000548c:	99090513          	addi	a0,s2,-1648
80005490:	b5cff0ef          	jal	ra,800047ec <z_spin_lock_set_owner>
	u64_t t = 0U;

	LOCKED(&timeout_lock) {
		t = curr_tick + z_clock_elapsed();
80005494:	e4dfc0ef          	jal	ra,800022e0 <z_clock_elapsed>
80005498:	800077b7          	lui	a5,0x80007
8000549c:	95078793          	addi	a5,a5,-1712 # 80006950 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006951>
800054a0:	0007a983          	lw	s3,0(a5)
800054a4:	0047a403          	lw	s0,4(a5)
800054a8:	013509b3          	add	s3,a0,s3
800054ac:	00a9b533          	sltu	a0,s3,a0
800054b0:	00850433          	add	s0,a0,s0
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
800054b4:	99090513          	addi	a0,s2,-1648
800054b8:	b04ff0ef          	jal	ra,800047bc <z_spin_unlock_valid>
800054bc:	02051e63          	bnez	a0,800054f8 <z_tick_get+0xd8>
800054c0:	80006937          	lui	s2,0x80006
800054c4:	800065b7          	lui	a1,0x80006
800054c8:	80006537          	lui	a0,0x80006
800054cc:	32c58593          	addi	a1,a1,812 # 8000632c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000632d>
800054d0:	06100693          	li	a3,97
800054d4:	2e490613          	addi	a2,s2,740 # 800062e4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800062e5>
800054d8:	21850513          	addi	a0,a0,536 # 80006218 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006219>
800054dc:	979fc0ef          	jal	ra,80001e54 <printk>
800054e0:	80006537          	lui	a0,0x80006
800054e4:	34450513          	addi	a0,a0,836 # 80006344 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006345>
800054e8:	96dfc0ef          	jal	ra,80001e54 <printk>
800054ec:	06100593          	li	a1,97
800054f0:	2e490513          	addi	a0,s2,740
800054f4:	99dfc0ef          	jal	ra,80001e90 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
800054f8:	3004a4f3          	csrrs	s1,mstatus,s1
	}
	return t;
}
800054fc:	00040593          	mv	a1,s0
80005500:	01c12083          	lw	ra,28(sp)
80005504:	01812403          	lw	s0,24(sp)
80005508:	00098513          	mv	a0,s3
8000550c:	01412483          	lw	s1,20(sp)
80005510:	01012903          	lw	s2,16(sp)
80005514:	00c12983          	lw	s3,12(sp)
80005518:	02010113          	addi	sp,sp,32
8000551c:	00008067          	ret

80005520 <init_static_pools>:
	z_waitq_init(&p->wait_q);
	z_sys_mem_pool_base_init(&p->base);
}

int init_static_pools(struct device *unused)
{
80005520:	ff010113          	addi	sp,sp,-16
80005524:	00812423          	sw	s0,8(sp)
80005528:	00912223          	sw	s1,4(sp)
	ARG_UNUSED(unused);
	struct k_mem_pool *p;

	for (p = _k_mem_pool_list_start; p < _k_mem_pool_list_end; p++) {
8000552c:	80007437          	lui	s0,0x80007
80005530:	800074b7          	lui	s1,0x80007
{
80005534:	00112623          	sw	ra,12(sp)
	for (p = _k_mem_pool_list_start; p < _k_mem_pool_list_end; p++) {
80005538:	8e040413          	addi	s0,s0,-1824 # 800068e0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800068e1>
8000553c:	8fc48493          	addi	s1,s1,-1796 # 800068fc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800068fd>
80005540:	00946e63          	bltu	s0,s1,8000555c <init_static_pools+0x3c>
		k_mem_pool_init(p);
	}

	return 0;
}
80005544:	00c12083          	lw	ra,12(sp)
80005548:	00812403          	lw	s0,8(sp)
8000554c:	00412483          	lw	s1,4(sp)
80005550:	00000513          	li	a0,0
80005554:	01010113          	addi	sp,sp,16
80005558:	00008067          	ret
	SYS_DLIST_FOR_EACH_CONTAINER(&((wq)->waitq), thread_ptr, \
				     base.qnode_dlist)

static inline void z_waitq_init(_wait_q_t *w)
{
	sys_dlist_init(&w->waitq);
8000555c:	01440793          	addi	a5,s0,20
	z_sys_mem_pool_base_init(&p->base);
80005560:	00040513          	mv	a0,s0
	list->head = (sys_dnode_t *)list;
80005564:	00f42a23          	sw	a5,20(s0)
	list->tail = (sys_dnode_t *)list;
80005568:	00f42c23          	sw	a5,24(s0)
8000556c:	bedfb0ef          	jal	ra,80001158 <z_sys_mem_pool_base_init>
	for (p = _k_mem_pool_list_start; p < _k_mem_pool_list_end; p++) {
80005570:	01c40413          	addi	s0,s0,28
80005574:	fcdff06f          	j	80005540 <init_static_pools+0x20>

80005578 <k_mem_pool_alloc>:
		     size_t size, s32_t timeout)
{
	int ret;
	s64_t end = 0;

	__ASSERT(!(z_is_in_isr() && timeout != K_NO_WAIT), "");
80005578:	800077b7          	lui	a5,0x80007
8000557c:	ca47a783          	lw	a5,-860(a5) # 80006ca4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006ca5>
{
80005580:	fb010113          	addi	sp,sp,-80
80005584:	04912223          	sw	s1,68(sp)
80005588:	03312e23          	sw	s3,60(sp)
8000558c:	03412c23          	sw	s4,56(sp)
80005590:	03712623          	sw	s7,44(sp)
80005594:	04112623          	sw	ra,76(sp)
80005598:	04812423          	sw	s0,72(sp)
8000559c:	05212023          	sw	s2,64(sp)
800055a0:	03512a23          	sw	s5,52(sp)
800055a4:	03612823          	sw	s6,48(sp)
800055a8:	03812423          	sw	s8,40(sp)
800055ac:	03912223          	sw	s9,36(sp)
800055b0:	03a12023          	sw	s10,32(sp)
800055b4:	01b12e23          	sw	s11,28(sp)
800055b8:	00050a13          	mv	s4,a0
800055bc:	00058993          	mv	s3,a1
800055c0:	00060b93          	mv	s7,a2
800055c4:	00068493          	mv	s1,a3
	__ASSERT(!(z_is_in_isr() && timeout != K_NO_WAIT), "");
800055c8:	16078263          	beqz	a5,8000572c <k_mem_pool_alloc+0x1b4>
800055cc:	12069463          	bnez	a3,800056f4 <k_mem_pool_alloc+0x17c>
	s64_t end = 0;
800055d0:	00000913          	li	s2,0
	return pool - &_k_mem_pool_list_start[0];
800055d4:	80007437          	lui	s0,0x80007
800055d8:	8e040413          	addi	s0,s0,-1824 # 800068e0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800068e1>
800055dc:	408a0433          	sub	s0,s4,s0
800055e0:	b6db77b7          	lui	a5,0xb6db7
800055e4:	40245413          	srai	s0,s0,0x2
800055e8:	db778793          	addi	a5,a5,-585 # b6db6db7 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0xb6db6db8>
800055ec:	02f40433          	mul	s0,s0,a5
		if (ret == -EAGAIN) {
			ret = -ENOMEM;
		}

		block->id.pool = pool_id(p);
		block->id.level = level_num;
800055f0:	fffffab7          	lui	s5,0xfffff
		block->id.block = block_num;
800055f4:	00001b37          	lui	s6,0x1
			if (ret != -EAGAIN) {
800055f8:	ff500c13          	li	s8,-11
			ret = -ENOMEM;
800055fc:	ff400c93          	li	s9,-12
		block->id.level = level_num;
80005600:	0ffa8a93          	addi	s5,s5,255 # fffff0ff <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0xfffff100>
		block->id.block = block_num;
80005604:	fffb0b13          	addi	s6,s6,-1 # fff <CONFIG_ISR_STACK_SIZE+0x7ff>
	__asm__ volatile ("csrrc %0, mstatus, %1"
80005608:	00800d13          	li	s10,8
		if (ret == 0 || timeout == K_NO_WAIT ||
		    ret != -ENOMEM) {
			return ret;
		}

		z_pend_curr_unlocked(&p->wait_q, timeout);
8000560c:	014a0d93          	addi	s11,s4,20
		block->id.pool = pool_id(p);
80005610:	0ff47413          	andi	s0,s0,255
			ret = z_sys_mem_pool_block_alloc(&p->base, size,
80005614:	00098713          	mv	a4,s3
80005618:	00c10693          	addi	a3,sp,12
8000561c:	00810613          	addi	a2,sp,8
80005620:	000b8593          	mv	a1,s7
80005624:	000a0513          	mv	a0,s4
80005628:	c31fb0ef          	jal	ra,80001258 <z_sys_mem_pool_block_alloc>
			if (ret != -EAGAIN) {
8000562c:	03851263          	bne	a0,s8,80005650 <k_mem_pool_alloc+0xd8>
			ret = z_sys_mem_pool_block_alloc(&p->base, size,
80005630:	00098713          	mv	a4,s3
80005634:	00c10693          	addi	a3,sp,12
80005638:	00810613          	addi	a2,sp,8
8000563c:	000b8593          	mv	a1,s7
80005640:	000a0513          	mv	a0,s4
80005644:	c15fb0ef          	jal	ra,80001258 <z_sys_mem_pool_block_alloc>
			if (ret != -EAGAIN) {
80005648:	01851463          	bne	a0,s8,80005650 <k_mem_pool_alloc+0xd8>
			ret = -ENOMEM;
8000564c:	ff400513          	li	a0,-12
		block->id.level = level_num;
80005650:	00812783          	lw	a5,8(sp)
		block->id.pool = pool_id(p);
80005654:	00898223          	sb	s0,4(s3)
		block->id.level = level_num;
80005658:	00f7f793          	andi	a5,a5,15
8000565c:	00879713          	slli	a4,a5,0x8
80005660:	0049a783          	lw	a5,4(s3)
80005664:	0157f7b3          	and	a5,a5,s5
80005668:	00e7e7b3          	or	a5,a5,a4
		block->id.block = block_num;
8000566c:	00c12703          	lw	a4,12(sp)
80005670:	0167f7b3          	and	a5,a5,s6
80005674:	00c71713          	slli	a4,a4,0xc
80005678:	00e7e7b3          	or	a5,a5,a4
8000567c:	00f9a223          	sw	a5,4(s3)
		if (ret == 0 || timeout == K_NO_WAIT ||
80005680:	02050c63          	beqz	a0,800056b8 <k_mem_pool_alloc+0x140>
80005684:	02048a63          	beqz	s1,800056b8 <k_mem_pool_alloc+0x140>
80005688:	03951863          	bne	a0,s9,800056b8 <k_mem_pool_alloc+0x140>
8000568c:	300d3573          	csrrc	a0,mstatus,s10
	(void) z_pend_curr_irqlock(z_arch_irq_lock(), wait_q, timeout);
80005690:	00048613          	mv	a2,s1
80005694:	000d8593          	mv	a1,s11
80005698:	00857513          	andi	a0,a0,8
8000569c:	d48fe0ef          	jal	ra,80003be4 <z_pend_curr_irqlock>

		if (timeout != K_FOREVER) {
800056a0:	fff00793          	li	a5,-1
800056a4:	f6f488e3          	beq	s1,a5,80005614 <k_mem_pool_alloc+0x9c>
			timeout = end - z_tick_get();
800056a8:	d79ff0ef          	jal	ra,80005420 <z_tick_get>
800056ac:	40a904b3          	sub	s1,s2,a0

			if (timeout < 0) {
800056b0:	f604d2e3          	bgez	s1,80005614 <k_mem_pool_alloc+0x9c>
				break;
			}
		}
	}

	return -EAGAIN;
800056b4:	ff500513          	li	a0,-11
}
800056b8:	04c12083          	lw	ra,76(sp)
800056bc:	04812403          	lw	s0,72(sp)
800056c0:	04412483          	lw	s1,68(sp)
800056c4:	04012903          	lw	s2,64(sp)
800056c8:	03c12983          	lw	s3,60(sp)
800056cc:	03812a03          	lw	s4,56(sp)
800056d0:	03412a83          	lw	s5,52(sp)
800056d4:	03012b03          	lw	s6,48(sp)
800056d8:	02c12b83          	lw	s7,44(sp)
800056dc:	02812c03          	lw	s8,40(sp)
800056e0:	02412c83          	lw	s9,36(sp)
800056e4:	02012d03          	lw	s10,32(sp)
800056e8:	01c12d83          	lw	s11,28(sp)
800056ec:	05010113          	addi	sp,sp,80
800056f0:	00008067          	ret
	__ASSERT(!(z_is_in_isr() && timeout != K_NO_WAIT), "");
800056f4:	80006437          	lui	s0,0x80006
800056f8:	800065b7          	lui	a1,0x80006
800056fc:	80006537          	lui	a0,0x80006
80005700:	7cc58593          	addi	a1,a1,1996 # 800067cc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800067cd>
80005704:	03900693          	li	a3,57
80005708:	7b840613          	addi	a2,s0,1976 # 800067b8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800067b9>
8000570c:	21850513          	addi	a0,a0,536 # 80006218 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006219>
80005710:	f44fc0ef          	jal	ra,80001e54 <printk>
80005714:	80006537          	lui	a0,0x80006
80005718:	29c50513          	addi	a0,a0,668 # 8000629c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000629d>
8000571c:	f38fc0ef          	jal	ra,80001e54 <printk>
80005720:	03900593          	li	a1,57
80005724:	7b840513          	addi	a0,s0,1976
80005728:	f68fc0ef          	jal	ra,80001e90 <assert_post_action>
	if (timeout > 0) {
8000572c:	ea9052e3          	blez	s1,800055d0 <k_mem_pool_alloc+0x58>
		end = z_tick_get() + z_ms_to_ticks(timeout);
80005730:	cf1ff0ef          	jal	ra,80005420 <z_tick_get>
80005734:	00948913          	addi	s2,s1,9
80005738:	00a00793          	li	a5,10
8000573c:	02f94933          	div	s2,s2,a5
80005740:	00a90933          	add	s2,s2,a0
80005744:	e91ff06f          	j	800055d4 <k_mem_pool_alloc+0x5c>

80005748 <k_mem_pool_free_id>:

void k_mem_pool_free_id(struct k_mem_block_id *id)
{
80005748:	fe010113          	addi	sp,sp,-32
8000574c:	01212823          	sw	s2,16(sp)
80005750:	00054903          	lbu	s2,0(a0)
80005754:	01c00793          	li	a5,28
	int need_sched = 0;
	struct k_mem_pool *p = get_pool(id->pool);

	z_sys_mem_pool_block_free(&p->base, id->level, id->block);
80005758:	00052603          	lw	a2,0(a0)
8000575c:	02f90933          	mul	s2,s2,a5
{
80005760:	01312623          	sw	s3,12(sp)
	z_sys_mem_pool_block_free(&p->base, id->level, id->block);
80005764:	800079b7          	lui	s3,0x80007
80005768:	00865593          	srli	a1,a2,0x8
8000576c:	8e098513          	addi	a0,s3,-1824 # 800068e0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800068e1>
80005770:	00c65613          	srli	a2,a2,0xc
80005774:	00f5f593          	andi	a1,a1,15
{
80005778:	00812c23          	sw	s0,24(sp)
8000577c:	00112e23          	sw	ra,28(sp)
80005780:	00912a23          	sw	s1,20(sp)
	z_sys_mem_pool_block_free(&p->base, id->level, id->block);
80005784:	01250533          	add	a0,a0,s2
{
80005788:	01412423          	sw	s4,8(sp)
8000578c:	00800413          	li	s0,8
	z_sys_mem_pool_block_free(&p->base, id->level, id->block);
80005790:	d91fb0ef          	jal	ra,80001520 <z_sys_mem_pool_block_free>
80005794:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80005798:	800074b7          	lui	s1,0x80007
8000579c:	99448513          	addi	a0,s1,-1644 # 80006994 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006995>
800057a0:	ff5fe0ef          	jal	ra,80004794 <z_spin_lock_valid>
	key = (mstatus & SOC_MSTATUS_IEN);
800057a4:	00847413          	andi	s0,s0,8
800057a8:	8e098993          	addi	s3,s3,-1824
800057ac:	02051e63          	bnez	a0,800057e8 <k_mem_pool_free_id+0xa0>
800057b0:	80006a37          	lui	s4,0x80006
800057b4:	800065b7          	lui	a1,0x80006
800057b8:	80006537          	lui	a0,0x80006
800057bc:	2fc58593          	addi	a1,a1,764 # 800062fc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800062fd>
800057c0:	04e00693          	li	a3,78
800057c4:	2e4a0613          	addi	a2,s4,740 # 800062e4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800062e5>
800057c8:	21850513          	addi	a0,a0,536 # 80006218 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006219>
800057cc:	e88fc0ef          	jal	ra,80001e54 <printk>
800057d0:	80006537          	lui	a0,0x80006
800057d4:	31450513          	addi	a0,a0,788 # 80006314 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006315>
800057d8:	e7cfc0ef          	jal	ra,80001e54 <printk>
800057dc:	04e00593          	li	a1,78
800057e0:	2e4a0513          	addi	a0,s4,740
800057e4:	eacfc0ef          	jal	ra,80001e90 <assert_post_action>
	z_spin_lock_set_owner(l);
800057e8:	99448513          	addi	a0,s1,-1644
800057ec:	800ff0ef          	jal	ra,800047ec <z_spin_lock_set_owner>
	 * is unsynchronized.  Maybe we want to put the lock into the
	 * wait_q instead and make the API safe?)
	 */
	k_spinlock_key_t key = k_spin_lock(&lock);

	need_sched = z_unpend_all(&p->wait_q);
800057f0:	01490513          	addi	a0,s2,20
800057f4:	00a98533          	add	a0,s3,a0
800057f8:	e5cfe0ef          	jal	ra,80003e54 <z_unpend_all>

	if (need_sched != 0) {
800057fc:	02050663          	beqz	a0,80005828 <k_mem_pool_free_id+0xe0>
		z_reschedule(&lock, key);
80005800:	00040593          	mv	a1,s0
	} else {
		k_spin_unlock(&lock, key);
	}
}
80005804:	01812403          	lw	s0,24(sp)
80005808:	01c12083          	lw	ra,28(sp)
8000580c:	01012903          	lw	s2,16(sp)
80005810:	00c12983          	lw	s3,12(sp)
80005814:	00812a03          	lw	s4,8(sp)
		z_reschedule(&lock, key);
80005818:	99448513          	addi	a0,s1,-1644
}
8000581c:	01412483          	lw	s1,20(sp)
80005820:	02010113          	addi	sp,sp,32
		z_reschedule(&lock, key);
80005824:	e2cfd06f          	j	80002e50 <z_reschedule>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80005828:	99448513          	addi	a0,s1,-1644
8000582c:	f91fe0ef          	jal	ra,800047bc <z_spin_unlock_valid>
80005830:	02051e63          	bnez	a0,8000586c <k_mem_pool_free_id+0x124>
80005834:	800064b7          	lui	s1,0x80006
80005838:	800065b7          	lui	a1,0x80006
8000583c:	80006537          	lui	a0,0x80006
80005840:	32c58593          	addi	a1,a1,812 # 8000632c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000632d>
80005844:	06100693          	li	a3,97
80005848:	2e448613          	addi	a2,s1,740 # 800062e4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800062e5>
8000584c:	21850513          	addi	a0,a0,536 # 80006218 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006219>
80005850:	e04fc0ef          	jal	ra,80001e54 <printk>
80005854:	80006537          	lui	a0,0x80006
80005858:	34450513          	addi	a0,a0,836 # 80006344 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006345>
8000585c:	df8fc0ef          	jal	ra,80001e54 <printk>
80005860:	06100593          	li	a1,97
80005864:	2e448513          	addi	a0,s1,740
80005868:	e28fc0ef          	jal	ra,80001e90 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
8000586c:	30042473          	csrrs	s0,mstatus,s0
}
80005870:	01c12083          	lw	ra,28(sp)
80005874:	01812403          	lw	s0,24(sp)
80005878:	01412483          	lw	s1,20(sp)
8000587c:	01012903          	lw	s2,16(sp)
80005880:	00c12983          	lw	s3,12(sp)
80005884:	00812a03          	lw	s4,8(sp)
80005888:	02010113          	addi	sp,sp,32
8000588c:	00008067          	ret

80005890 <k_mem_pool_malloc>:

	/*
	 * get a block large enough to hold an initial (hidden) block
	 * descriptor, as well as the space the caller requested
	 */
	if (__builtin_add_overflow(size, sizeof(struct k_mem_block_id),
80005890:	00458613          	addi	a2,a1,4
80005894:	00b67e63          	bgeu	a2,a1,800058b0 <k_mem_pool_malloc+0x20>
				   &size)) {
		return NULL;
80005898:	00000513          	li	a0,0
	/* save the block descriptor info at the start of the actual block */
	(void)memcpy(block.data, &block.id, sizeof(struct k_mem_block_id));

	/* return address of the user area part of the block to the caller */
	return (char *)block.data + sizeof(struct k_mem_block_id);
}
8000589c:	00008067          	ret
		return NULL;
800058a0:	00000513          	li	a0,0
}
800058a4:	01c12083          	lw	ra,28(sp)
800058a8:	02010113          	addi	sp,sp,32
800058ac:	00008067          	ret
{
800058b0:	fe010113          	addi	sp,sp,-32
	if (k_mem_pool_alloc(pool, &block, size, K_NO_WAIT) != 0) {
800058b4:	00000693          	li	a3,0
800058b8:	00810593          	addi	a1,sp,8
{
800058bc:	00112e23          	sw	ra,28(sp)
	if (k_mem_pool_alloc(pool, &block, size, K_NO_WAIT) != 0) {
800058c0:	cb9ff0ef          	jal	ra,80005578 <k_mem_pool_alloc>
800058c4:	fc051ee3          	bnez	a0,800058a0 <k_mem_pool_malloc+0x10>
	(void)memcpy(block.data, &block.id, sizeof(struct k_mem_block_id));
800058c8:	00812503          	lw	a0,8(sp)
800058cc:	00400613          	li	a2,4
800058d0:	00c10593          	addi	a1,sp,12
800058d4:	b21fc0ef          	jal	ra,800023f4 <memcpy>
	return (char *)block.data + sizeof(struct k_mem_block_id);
800058d8:	00812503          	lw	a0,8(sp)
800058dc:	00450513          	addi	a0,a0,4
800058e0:	fc5ff06f          	j	800058a4 <k_mem_pool_malloc+0x14>

800058e4 <k_free>:

void k_free(void *ptr)
{
	if (ptr != NULL) {
800058e4:	00050663          	beqz	a0,800058f0 <k_free+0xc>
		/* point to hidden block descriptor at start of block */
		ptr = (char *)ptr - sizeof(struct k_mem_block_id);

		/* return block to the heap memory pool */
		k_mem_pool_free_id(ptr);
800058e8:	ffc50513          	addi	a0,a0,-4
800058ec:	e5dff06f          	j	80005748 <k_mem_pool_free_id>
	}
}
800058f0:	00008067          	ret

800058f4 <z_thread_malloc>:

void *z_thread_malloc(size_t size)
{
	void *ret;

	if (_current->resource_pool != NULL) {
800058f4:	800077b7          	lui	a5,0x80007
800058f8:	cac7a783          	lw	a5,-852(a5) # 80006cac <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006cad>
{
800058fc:	00050593          	mv	a1,a0
	if (_current->resource_pool != NULL) {
80005900:	0687a503          	lw	a0,104(a5)
80005904:	00050463          	beqz	a0,8000590c <z_thread_malloc+0x18>
		ret = k_mem_pool_malloc(_current->resource_pool, size);
80005908:	f89ff06f          	j	80005890 <k_mem_pool_malloc>
	} else {
		ret = NULL;
	}

	return ret;
}
8000590c:	00000513          	li	a0,0
80005910:	00008067          	ret

80005914 <_OffsetAbsSyms>:
 * point regs
 */
GEN_ABSOLUTE_SYM(_K_THREAD_NO_FLOAT_SIZEOF,
		 STACK_ROUND_UP(sizeof(struct k_thread)));

GEN_ABS_SYM_END
80005914:	00008067          	ret
