
zephyr/zephyr.elf:     file format elf32-littleriscv


Disassembly of section vector:

80000000 <__start>:

	/*
	 * Set mtvec (Machine Trap-Vector Base-Address Register)
	 * to __irq_wrapper.
	 */
	la t0, __irq_wrapper
80000000:	00000297          	auipc	t0,0x0
80000004:	01028293          	addi	t0,t0,16 # 80000010 <__irq_wrapper>
	csrw mtvec, t0
80000008:	30529073          	csrw	mtvec,t0

	/* Jump to __initialize */
	tail __initialize
8000000c:	07c0106f          	j	80001088 <__initialize>

Disassembly of section exceptions:

80000010 <__irq_wrapper>:
 * In this architecture, system call (ECALL) is used to perform context
 * switching or IRQ offloading (when enabled).
 */
SECTION_FUNC(exception.entry, __irq_wrapper)
	/* Allocate space on thread stack to save registers */
	addi sp, sp, -__NANO_ESF_SIZEOF
80000010:	fb010113          	addi	sp,sp,-80
	 * Save caller-saved registers on current thread stack.
	 * NOTE: need to be updated to account for floating-point registers
	 * floating-point registers should be accounted for when corresponding
	 * config variable is set
	 */
	sw ra, __NANO_ESF_ra_OFFSET(sp)
80000014:	00112023          	sw	ra,0(sp)
	sw gp, __NANO_ESF_gp_OFFSET(sp)
80000018:	00312223          	sw	gp,4(sp)
	sw tp, __NANO_ESF_tp_OFFSET(sp)
8000001c:	00412423          	sw	tp,8(sp)
	sw t0, __NANO_ESF_t0_OFFSET(sp)
80000020:	00512623          	sw	t0,12(sp)
	sw t1, __NANO_ESF_t1_OFFSET(sp)
80000024:	00612823          	sw	t1,16(sp)
	sw t2, __NANO_ESF_t2_OFFSET(sp)
80000028:	00712a23          	sw	t2,20(sp)
	sw t3, __NANO_ESF_t3_OFFSET(sp)
8000002c:	01c12c23          	sw	t3,24(sp)
	sw t4, __NANO_ESF_t4_OFFSET(sp)
80000030:	01d12e23          	sw	t4,28(sp)
	sw t5, __NANO_ESF_t5_OFFSET(sp)
80000034:	03e12023          	sw	t5,32(sp)
	sw t6, __NANO_ESF_t6_OFFSET(sp)
80000038:	03f12223          	sw	t6,36(sp)
	sw a0, __NANO_ESF_a0_OFFSET(sp)
8000003c:	02a12423          	sw	a0,40(sp)
	sw a1, __NANO_ESF_a1_OFFSET(sp)
80000040:	02b12623          	sw	a1,44(sp)
	sw a2, __NANO_ESF_a2_OFFSET(sp)
80000044:	02c12823          	sw	a2,48(sp)
	sw a3, __NANO_ESF_a3_OFFSET(sp)
80000048:	02d12a23          	sw	a3,52(sp)
	sw a4, __NANO_ESF_a4_OFFSET(sp)
8000004c:	02e12c23          	sw	a4,56(sp)
	sw a5, __NANO_ESF_a5_OFFSET(sp)
80000050:	02f12e23          	sw	a5,60(sp)
	sw a6, __NANO_ESF_a6_OFFSET(sp)
80000054:	05012023          	sw	a6,64(sp)
	sw a7, __NANO_ESF_a7_OFFSET(sp)
80000058:	05112223          	sw	a7,68(sp)

	/* Save MEPC register */
	csrr t0, mepc
8000005c:	341022f3          	csrr	t0,mepc
	sw t0, __NANO_ESF_mepc_OFFSET(sp)
80000060:	04512423          	sw	t0,72(sp)

	/* Save SOC-specific MSTATUS register */
	csrr t0, SOC_MSTATUS_REG
80000064:	300022f3          	csrr	t0,mstatus
	sw t0, __NANO_ESF_mstatus_OFFSET(sp)
80000068:	04512623          	sw	t0,76(sp)
	 * SOCs (like pulpino or riscv-qemu), the MSB is never set to indicate
	 * interrupt. Hence, check for interrupt/exception via the __soc_is_irq
	 * function (that needs to be implemented by each SOC). The result is
	 * returned via register a0 (1: interrupt, 0 exception)
	 */
	jal ra, __soc_is_irq
8000006c:	1f0000ef          	jal	ra,8000025c <__soc_is_irq>

	/* If a0 != 0, jump to is_interrupt */
	addi t1, x0, 0
80000070:	00000313          	li	t1,0
	bnez a0, is_interrupt
80000074:	02051e63          	bnez	a0,800000b0 <is_interrupt>
	/*
	 * If the exception is the result of an ECALL, check whether to
	 * perform a context-switch or an IRQ offload. Otherwise call _Fault
	 * to report the exception.
	 */
	csrr t0, mcause
80000078:	342022f3          	csrr	t0,mcause
	li t2, SOC_MCAUSE_EXP_MASK
8000007c:	800003b7          	lui	t2,0x80000
80000080:	fff38393          	addi	t2,t2,-1 # 7fffffff <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80000000>
	and t0, t0, t2
80000084:	0072f2b3          	and	t0,t0,t2
	li t1, SOC_MCAUSE_ECALL_EXP
80000088:	00b00313          	li	t1,11

	/*
	 * If mcause == SOC_MCAUSE_ECALL_EXP, handle system call,
	 * otherwise handle fault
	 */
	beq t0, t1, is_syscall
8000008c:	00628a63          	beq	t0,t1,800000a0 <is_syscall>
	 * Stack pointer is pointing to a NANO_ESF structure, pass it
	 * to _Fault (via register a0).
	 * If _Fault shall return, set return address to no_reschedule
	 * to restore stack.
	 */
	addi a0, sp, 0
80000090:	00010513          	mv	a0,sp
	la ra, no_reschedule
80000094:	00000097          	auipc	ra,0x0
80000098:	13408093          	addi	ra,ra,308 # 800001c8 <no_reschedule>
	tail _Fault
8000009c:	7250006f          	j	80000fc0 <_Fault>

800000a0 <is_syscall>:
	 * again upon exiting the ISR.
	 *
	 * It's safe to always increment by 4, even with compressed
	 * instructions, because the ecall instruction is always 4 bytes.
	 */
	lw t0, __NANO_ESF_mepc_OFFSET(sp)
800000a0:	04812283          	lw	t0,72(sp)
	addi t0, t0, 4
800000a4:	00428293          	addi	t0,t0,4
	sw t0, __NANO_ESF_mepc_OFFSET(sp)
800000a8:	04512423          	sw	t0,72(sp)
#endif

	/*
	 * Go to reschedule to handle context-switch
	 */
	j reschedule
800000ac:	0900006f          	j	8000013c <reschedule>

800000b0 <is_interrupt>:
	 * Save current thread stack pointer and switch
	 * stack pointer to interrupt stack.
	 */

	/* Save thread stack pointer to temp register t0 */
	addi t0, sp, 0
800000b0:	00010293          	mv	t0,sp

	/* Switch to interrupt stack */
	la t2, _kernel
800000b4:	00007397          	auipc	t2,0x7
800000b8:	08038393          	addi	t2,t2,128 # 80007134 <_kernel>
	lw sp, _kernel_offset_to_irq_stack(t2)
800000bc:	0043a103          	lw	sp,4(t2)

	/*
	 * Save thread stack pointer on interrupt stack
	 * In RISC-V, stack pointer needs to be 16-byte aligned
	 */
	addi sp, sp, -16
800000c0:	ff010113          	addi	sp,sp,-16
	sw t0, 0x00(sp)
800000c4:	00512023          	sw	t0,0(sp)

800000c8 <on_irq_stack>:

on_irq_stack:
	/* Increment _kernel.nested variable */
	lw t3, _kernel_offset_to_nested(t2)
800000c8:	0003ae03          	lw	t3,0(t2)
	addi t3, t3, 1
800000cc:	001e0e13          	addi	t3,t3,1
	sw t3, _kernel_offset_to_nested(t2)
800000d0:	01c3a023          	sw	t3,0(t2)

	/*
	 * If we are here due to a system call, t1 register should != 0.
	 * In this case, perform IRQ offloading, otherwise jump to call_irq
	 */
	beqz t1, call_irq
800000d4:	00030863          	beqz	t1,800000e4 <call_irq>
	/*
	 * Call z_irq_do_offload to handle IRQ offloading.
	 * Set return address to on_thread_stack in order to jump there
	 * upon returning from z_irq_do_offload
	 */
	la ra, on_thread_stack
800000d8:	00000097          	auipc	ra,0x0
800000dc:	03c08093          	addi	ra,ra,60 # 80000114 <on_thread_stack>
	tail z_irq_do_offload
800000e0:	76d0006f          	j	8000104c <z_irq_do_offload>

800000e4 <call_irq>:
#ifdef CONFIG_TRACING
	call z_sys_trace_isr_enter
#endif

	/* Get IRQ causing interrupt */
	csrr a0, mcause
800000e4:	34202573          	csrr	a0,mcause
	li t0, SOC_MCAUSE_EXP_MASK
800000e8:	800002b7          	lui	t0,0x80000
800000ec:	fff28293          	addi	t0,t0,-1 # 7fffffff <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80000000>
	and a0, a0, t0
800000f0:	00557533          	and	a0,a0,t0

	/*
	 * Clear pending IRQ generating the interrupt at SOC level
	 * Pass IRQ number to __soc_handle_irq via register a0
	 */
	jal ra, __soc_handle_irq
800000f4:	158000ef          	jal	ra,8000024c <__soc_handle_irq>

	/*
	 * Call corresponding registered function in _sw_isr_table.
	 * (table is 8-bytes wide, we should shift index by 3)
	 */
	la t0, _sw_isr_table
800000f8:	00006297          	auipc	t0,0x6
800000fc:	ee028293          	addi	t0,t0,-288 # 80005fd8 <_image_text_end>
	slli a0, a0, 3
80000100:	00351513          	slli	a0,a0,0x3
	add t0, t0, a0
80000104:	00a282b3          	add	t0,t0,a0

	/* Load argument in a0 register */
	lw a0, 0x00(t0)
80000108:	0002a503          	lw	a0,0(t0)

	/* Load ISR function address in register t1 */
	lw t1, 0x04(t0)
8000010c:	0042a303          	lw	t1,4(t0)
	lw t1, 0x04(sp)
	lw a0, 0x00(sp)
	addi sp, sp, 16
#endif
	/* Call ISR function */
	jalr ra, t1
80000110:	000300e7          	jalr	t1

80000114 <on_thread_stack>:

on_thread_stack:
	/* Get reference to _kernel */
	la t1, _kernel
80000114:	00007317          	auipc	t1,0x7
80000118:	02030313          	addi	t1,t1,32 # 80007134 <_kernel>

	/* Decrement _kernel.nested variable */
	lw t2, _kernel_offset_to_nested(t1)
8000011c:	00032383          	lw	t2,0(t1)
	addi t2, t2, -1
80000120:	fff38393          	addi	t2,t2,-1
	sw t2, _kernel_offset_to_nested(t1)
80000124:	00732023          	sw	t2,0(t1)

	/* Restore thread stack pointer */
	lw t0, 0x00(sp)
80000128:	00012283          	lw	t0,0(sp)
	addi sp, t0, 0
8000012c:	00028113          	mv	sp,t0
	/*
	 * Check if we need to perform a reschedule
	 */

	/* Get pointer to _kernel.current */
	lw t2, _kernel_offset_to_current(t1)
80000130:	00832383          	lw	t2,8(t1)

	/*
	 * Check if next thread to schedule is current thread.
	 * If yes do not perform a reschedule
	 */
	lw t3, _kernel_offset_to_ready_q_cache(t1)
80000134:	02032e03          	lw	t3,32(t1)
	beq t3, t2, no_reschedule
80000138:	087e0863          	beq	t3,t2,800001c8 <no_reschedule>

8000013c <reschedule>:
reschedule:
#if CONFIG_TRACING
	call z_sys_trace_thread_switched_in
#endif
	/* Get reference to _kernel */
	la t0, _kernel
8000013c:	00007297          	auipc	t0,0x7
80000140:	ff828293          	addi	t0,t0,-8 # 80007134 <_kernel>

	/* Get pointer to _kernel.current */
	lw t1, _kernel_offset_to_current(t0)
80000144:	0082a303          	lw	t1,8(t0)

	/*
	 * Save callee-saved registers of current thread
	 * prior to handle context-switching
	 */
	sw s0, _thread_offset_to_s0(t1)
80000148:	02832623          	sw	s0,44(t1)
	sw s1, _thread_offset_to_s1(t1)
8000014c:	02932823          	sw	s1,48(t1)
	sw s2, _thread_offset_to_s2(t1)
80000150:	03232a23          	sw	s2,52(t1)
	sw s3, _thread_offset_to_s3(t1)
80000154:	03332c23          	sw	s3,56(t1)
	sw s4, _thread_offset_to_s4(t1)
80000158:	03432e23          	sw	s4,60(t1)
	sw s5, _thread_offset_to_s5(t1)
8000015c:	05532023          	sw	s5,64(t1)
	sw s6, _thread_offset_to_s6(t1)
80000160:	05632223          	sw	s6,68(t1)
	sw s7, _thread_offset_to_s7(t1)
80000164:	05732423          	sw	s7,72(t1)
	sw s8, _thread_offset_to_s8(t1)
80000168:	05832623          	sw	s8,76(t1)
	sw s9, _thread_offset_to_s9(t1)
8000016c:	05932823          	sw	s9,80(t1)
	sw s10, _thread_offset_to_s10(t1)
80000170:	05a32a23          	sw	s10,84(t1)
	sw s11, _thread_offset_to_s11(t1)
80000174:	05b32c23          	sw	s11,88(t1)

	/*
	 * Save stack pointer of current thread and set the default return value
	 * of z_swap to _k_neg_eagain for the thread.
	 */
	sw sp, _thread_offset_to_sp(t1)
80000178:	02232423          	sw	sp,40(t1)
	la t2, _k_neg_eagain
8000017c:	00007397          	auipc	t2,0x7
80000180:	c1c38393          	addi	t2,t2,-996 # 80006d98 <_k_neg_eagain>
	lw t3, 0x00(t2)
80000184:	0003ae03          	lw	t3,0(t2)
	sw t3, _thread_offset_to_swap_return_value(t1)
80000188:	07c32623          	sw	t3,108(t1)

	/* Get next thread to schedule. */
	lw t1, _kernel_offset_to_ready_q_cache(t0)
8000018c:	0202a303          	lw	t1,32(t0)

	/*
	 * Set _kernel.current to new thread loaded in t1
	 */
	sw t1, _kernel_offset_to_current(t0)
80000190:	0062a423          	sw	t1,8(t0)

	/* Switch to new thread stack */
	lw sp, _thread_offset_to_sp(t1)
80000194:	02832103          	lw	sp,40(t1)

	/* Restore callee-saved registers of new thread */
	lw s0, _thread_offset_to_s0(t1)
80000198:	02c32403          	lw	s0,44(t1)
	lw s1, _thread_offset_to_s1(t1)
8000019c:	03032483          	lw	s1,48(t1)
	lw s2, _thread_offset_to_s2(t1)
800001a0:	03432903          	lw	s2,52(t1)
	lw s3, _thread_offset_to_s3(t1)
800001a4:	03832983          	lw	s3,56(t1)
	lw s4, _thread_offset_to_s4(t1)
800001a8:	03c32a03          	lw	s4,60(t1)
	lw s5, _thread_offset_to_s5(t1)
800001ac:	04032a83          	lw	s5,64(t1)
	lw s6, _thread_offset_to_s6(t1)
800001b0:	04432b03          	lw	s6,68(t1)
	lw s7, _thread_offset_to_s7(t1)
800001b4:	04832b83          	lw	s7,72(t1)
	lw s8, _thread_offset_to_s8(t1)
800001b8:	04c32c03          	lw	s8,76(t1)
	lw s9, _thread_offset_to_s9(t1)
800001bc:	05032c83          	lw	s9,80(t1)
	lw s10, _thread_offset_to_s10(t1)
800001c0:	05432d03          	lw	s10,84(t1)
	lw s11, _thread_offset_to_s11(t1)
800001c4:	05832d83          	lw	s11,88(t1)

800001c8 <no_reschedule>:
	addi a0, sp, __NANO_ESF_soc_context_OFFSET
	jal ra, __soc_restore_context
#endif /* CONFIG_RISCV_SOC_CONTEXT_SAVE */

	/* Restore MEPC register */
	lw t0, __NANO_ESF_mepc_OFFSET(sp)
800001c8:	04812283          	lw	t0,72(sp)
	csrw mepc, t0
800001cc:	34129073          	csrw	mepc,t0

	/* Restore SOC-specific MSTATUS register */
	lw t0, __NANO_ESF_mstatus_OFFSET(sp)
800001d0:	04c12283          	lw	t0,76(sp)
	csrw SOC_MSTATUS_REG, t0
800001d4:	30029073          	csrw	mstatus,t0

	/* Restore caller-saved registers from thread stack */
	lw ra, __NANO_ESF_ra_OFFSET(sp)
800001d8:	00012083          	lw	ra,0(sp)
	lw gp, __NANO_ESF_gp_OFFSET(sp)
800001dc:	00412183          	lw	gp,4(sp)
	lw tp, __NANO_ESF_tp_OFFSET(sp)
800001e0:	00812203          	lw	tp,8(sp)
	lw t0, __NANO_ESF_t0_OFFSET(sp)
800001e4:	00c12283          	lw	t0,12(sp)
	lw t1, __NANO_ESF_t1_OFFSET(sp)
800001e8:	01012303          	lw	t1,16(sp)
	lw t2, __NANO_ESF_t2_OFFSET(sp)
800001ec:	01412383          	lw	t2,20(sp)
	lw t3, __NANO_ESF_t3_OFFSET(sp)
800001f0:	01812e03          	lw	t3,24(sp)
	lw t4, __NANO_ESF_t4_OFFSET(sp)
800001f4:	01c12e83          	lw	t4,28(sp)
	lw t5, __NANO_ESF_t5_OFFSET(sp)
800001f8:	02012f03          	lw	t5,32(sp)
	lw t6, __NANO_ESF_t6_OFFSET(sp)
800001fc:	02412f83          	lw	t6,36(sp)
	lw a0, __NANO_ESF_a0_OFFSET(sp)
80000200:	02812503          	lw	a0,40(sp)
	lw a1, __NANO_ESF_a1_OFFSET(sp)
80000204:	02c12583          	lw	a1,44(sp)
	lw a2, __NANO_ESF_a2_OFFSET(sp)
80000208:	03012603          	lw	a2,48(sp)
	lw a3, __NANO_ESF_a3_OFFSET(sp)
8000020c:	03412683          	lw	a3,52(sp)
	lw a4, __NANO_ESF_a4_OFFSET(sp)
80000210:	03812703          	lw	a4,56(sp)
	lw a5, __NANO_ESF_a5_OFFSET(sp)
80000214:	03c12783          	lw	a5,60(sp)
	lw a6, __NANO_ESF_a6_OFFSET(sp)
80000218:	04012803          	lw	a6,64(sp)
	lw a7, __NANO_ESF_a7_OFFSET(sp)
8000021c:	04412883          	lw	a7,68(sp)

	/* Release stack space */
	addi sp, sp, __NANO_ESF_SIZEOF
80000220:	05010113          	addi	sp,sp,80

	/* Call SOC_ERET to exit ISR */
	SOC_ERET
80000224:	30200073          	mret

80000228 <__swap>:
	lw a7, __NANO_ESF_a7_OFFSET(sp)

	/* Release stack space */
	addi sp, sp, __NANO_ESF_SIZEOF
#endif
	ecall
80000228:	00000073          	ecall
	 * Prior to unlocking irq, load return value of
	 * __swap to temp register t2 (from
	 * _thread_offset_to_swap_return_value). Normally, it should be -EAGAIN,
	 * unless someone has previously called z_set_thread_return_value(..).
	 */
	la t0, _kernel
8000022c:	00007297          	auipc	t0,0x7
80000230:	f0828293          	addi	t0,t0,-248 # 80007134 <_kernel>

	/* Get pointer to _kernel.current */
	lw t1, _kernel_offset_to_current(t0)
80000234:	0082a303          	lw	t1,8(t0)

	/* Load return value of __swap function in temp register t2 */
	lw t2, _thread_offset_to_swap_return_value(t1)
80000238:	06c32383          	lw	t2,108(t1)

	/*
	 * Unlock irq, following IRQ lock state in a0 register.
	 * Use atomic instruction csrrs to do so.
	 */
	andi a0, a0, SOC_MSTATUS_IEN
8000023c:	00857513          	andi	a0,a0,8
	csrrs t0, mstatus, a0
80000240:	300522f3          	csrrs	t0,mstatus,a0

	/* Set value of return register a0 to value of register t2 */
	addi a0, t2, 0
80000244:	00038513          	mv	a0,t2

	/* Return */
	jalr x0, ra
80000248:	00008067          	ret

8000024c <__soc_handle_irq>:
 * SOC-specific function to handle pending IRQ number generating the interrupt.
 * Exception number is given as parameter via register a0.
 */
SECTION_FUNC(exception.other, __soc_handle_irq)
	/* Clear exception number from CSR mip register */
	li t1, 1
8000024c:	00100313          	li	t1,1
	sll t0, t1, a0
80000250:	00a312b3          	sll	t0,t1,a0
	csrrc t1, mip, t0
80000254:	3442b373          	csrrc	t1,mip,t0

	/* Return */
	jalr x0, ra
80000258:	00008067          	ret

8000025c <__soc_is_irq>:
 * return 1 (interrupt) or 0 (exception)
 *
 */
SECTION_FUNC(exception.other, __soc_is_irq)
	/* Read mcause and check if interrupt bit is set */
	csrr t0, mcause
8000025c:	342022f3          	csrr	t0,mcause
	li t1, SOC_MCAUSE_IRQ_MASK
80000260:	80000337          	lui	t1,0x80000
	and t0, t0, t1
80000264:	0062f2b3          	and	t0,t0,t1

	/* If interrupt bit is not set, return with 0 */
	addi a0, x0, 0
80000268:	00000513          	li	a0,0
	beqz t0, not_interrupt
8000026c:	00028463          	beqz	t0,80000274 <not_interrupt>
	addi a0, a0, 1
80000270:	00150513          	addi	a0,a0,1

80000274 <not_interrupt>:

not_interrupt:
	/* return */
	jalr x0, ra
80000274:	00008067          	ret

Disassembly of section text:

80000278 <__lshrdi3>:
80000278:	02060063          	beqz	a2,80000298 <__lshrdi3+0x20>
8000027c:	02000793          	li	a5,32
80000280:	40c787b3          	sub	a5,a5,a2
80000284:	00f04c63          	bgtz	a5,8000029c <__lshrdi3+0x24>
80000288:	fe060513          	addi	a0,a2,-32
8000028c:	00000713          	li	a4,0
80000290:	00a5d533          	srl	a0,a1,a0
80000294:	00070593          	mv	a1,a4
80000298:	00008067          	ret
8000029c:	00c5d733          	srl	a4,a1,a2
800002a0:	00c55533          	srl	a0,a0,a2
800002a4:	00f595b3          	sll	a1,a1,a5
800002a8:	00b56533          	or	a0,a0,a1
800002ac:	fe9ff06f          	j	80000294 <__lshrdi3+0x1c>

800002b0 <__udivdi3>:
800002b0:	fd010113          	addi	sp,sp,-48
800002b4:	02912223          	sw	s1,36(sp)
800002b8:	01612823          	sw	s6,16(sp)
800002bc:	02112623          	sw	ra,44(sp)
800002c0:	02812423          	sw	s0,40(sp)
800002c4:	03212023          	sw	s2,32(sp)
800002c8:	01312e23          	sw	s3,28(sp)
800002cc:	01412c23          	sw	s4,24(sp)
800002d0:	01512a23          	sw	s5,20(sp)
800002d4:	01712623          	sw	s7,12(sp)
800002d8:	01812423          	sw	s8,8(sp)
800002dc:	01912223          	sw	s9,4(sp)
800002e0:	00050b13          	mv	s6,a0
800002e4:	00058493          	mv	s1,a1
800002e8:	38069c63          	bnez	a3,80000680 <__udivdi3+0x3d0>
800002ec:	00060413          	mv	s0,a2
800002f0:	00050993          	mv	s3,a0
800002f4:	00006917          	auipc	s2,0x6
800002f8:	e6490913          	addi	s2,s2,-412 # 80006158 <__devconfig_end>
800002fc:	12c5f863          	bgeu	a1,a2,8000042c <__udivdi3+0x17c>
80000300:	000107b7          	lui	a5,0x10
80000304:	00058a93          	mv	s5,a1
80000308:	10f67863          	bgeu	a2,a5,80000418 <__udivdi3+0x168>
8000030c:	0ff00693          	li	a3,255
80000310:	00c6b6b3          	sltu	a3,a3,a2
80000314:	00369693          	slli	a3,a3,0x3
80000318:	00d657b3          	srl	a5,a2,a3
8000031c:	00f90933          	add	s2,s2,a5
80000320:	00094703          	lbu	a4,0(s2)
80000324:	00d706b3          	add	a3,a4,a3
80000328:	02000713          	li	a4,32
8000032c:	40d70733          	sub	a4,a4,a3
80000330:	00070c63          	beqz	a4,80000348 <__udivdi3+0x98>
80000334:	00e494b3          	sll	s1,s1,a4
80000338:	00db56b3          	srl	a3,s6,a3
8000033c:	00e61433          	sll	s0,a2,a4
80000340:	0096eab3          	or	s5,a3,s1
80000344:	00eb19b3          	sll	s3,s6,a4
80000348:	01045b13          	srli	s6,s0,0x10
8000034c:	000b0593          	mv	a1,s6
80000350:	000a8513          	mv	a0,s5
80000354:	634000ef          	jal	ra,80000988 <__umodsi3>
80000358:	00050913          	mv	s2,a0
8000035c:	000b0593          	mv	a1,s6
80000360:	01041b93          	slli	s7,s0,0x10
80000364:	000a8513          	mv	a0,s5
80000368:	5d8000ef          	jal	ra,80000940 <__udivsi3>
8000036c:	010bdb93          	srli	s7,s7,0x10
80000370:	00050493          	mv	s1,a0
80000374:	00050593          	mv	a1,a0
80000378:	000b8513          	mv	a0,s7
8000037c:	508000ef          	jal	ra,80000884 <__mulsi3>
80000380:	01091913          	slli	s2,s2,0x10
80000384:	0109d713          	srli	a4,s3,0x10
80000388:	00e96733          	or	a4,s2,a4
8000038c:	00048a13          	mv	s4,s1
80000390:	00a77e63          	bgeu	a4,a0,800003ac <__udivdi3+0xfc>
80000394:	00870733          	add	a4,a4,s0
80000398:	fff48a13          	addi	s4,s1,-1
8000039c:	00876863          	bltu	a4,s0,800003ac <__udivdi3+0xfc>
800003a0:	00a77663          	bgeu	a4,a0,800003ac <__udivdi3+0xfc>
800003a4:	ffe48a13          	addi	s4,s1,-2
800003a8:	00870733          	add	a4,a4,s0
800003ac:	40a704b3          	sub	s1,a4,a0
800003b0:	000b0593          	mv	a1,s6
800003b4:	00048513          	mv	a0,s1
800003b8:	5d0000ef          	jal	ra,80000988 <__umodsi3>
800003bc:	00050913          	mv	s2,a0
800003c0:	000b0593          	mv	a1,s6
800003c4:	00048513          	mv	a0,s1
800003c8:	578000ef          	jal	ra,80000940 <__udivsi3>
800003cc:	01099993          	slli	s3,s3,0x10
800003d0:	00050493          	mv	s1,a0
800003d4:	00050593          	mv	a1,a0
800003d8:	01091913          	slli	s2,s2,0x10
800003dc:	000b8513          	mv	a0,s7
800003e0:	0109d993          	srli	s3,s3,0x10
800003e4:	4a0000ef          	jal	ra,80000884 <__mulsi3>
800003e8:	013969b3          	or	s3,s2,s3
800003ec:	00048613          	mv	a2,s1
800003f0:	00a9fc63          	bgeu	s3,a0,80000408 <__udivdi3+0x158>
800003f4:	013409b3          	add	s3,s0,s3
800003f8:	fff48613          	addi	a2,s1,-1
800003fc:	0089e663          	bltu	s3,s0,80000408 <__udivdi3+0x158>
80000400:	00a9f463          	bgeu	s3,a0,80000408 <__udivdi3+0x158>
80000404:	ffe48613          	addi	a2,s1,-2
80000408:	010a1793          	slli	a5,s4,0x10
8000040c:	00c7e7b3          	or	a5,a5,a2
80000410:	00000a13          	li	s4,0
80000414:	1300006f          	j	80000544 <__udivdi3+0x294>
80000418:	010007b7          	lui	a5,0x1000
8000041c:	01000693          	li	a3,16
80000420:	eef66ce3          	bltu	a2,a5,80000318 <__udivdi3+0x68>
80000424:	01800693          	li	a3,24
80000428:	ef1ff06f          	j	80000318 <__udivdi3+0x68>
8000042c:	00068a13          	mv	s4,a3
80000430:	00061a63          	bnez	a2,80000444 <__udivdi3+0x194>
80000434:	00000593          	li	a1,0
80000438:	00100513          	li	a0,1
8000043c:	504000ef          	jal	ra,80000940 <__udivsi3>
80000440:	00050413          	mv	s0,a0
80000444:	000107b7          	lui	a5,0x10
80000448:	12f47c63          	bgeu	s0,a5,80000580 <__udivdi3+0x2d0>
8000044c:	0ff00793          	li	a5,255
80000450:	0087f463          	bgeu	a5,s0,80000458 <__udivdi3+0x1a8>
80000454:	00800a13          	li	s4,8
80000458:	014457b3          	srl	a5,s0,s4
8000045c:	00f90933          	add	s2,s2,a5
80000460:	00094683          	lbu	a3,0(s2)
80000464:	02000613          	li	a2,32
80000468:	014686b3          	add	a3,a3,s4
8000046c:	40d60633          	sub	a2,a2,a3
80000470:	12061263          	bnez	a2,80000594 <__udivdi3+0x2e4>
80000474:	408484b3          	sub	s1,s1,s0
80000478:	00100a13          	li	s4,1
8000047c:	01045b13          	srli	s6,s0,0x10
80000480:	000b0593          	mv	a1,s6
80000484:	00048513          	mv	a0,s1
80000488:	500000ef          	jal	ra,80000988 <__umodsi3>
8000048c:	00050913          	mv	s2,a0
80000490:	000b0593          	mv	a1,s6
80000494:	00048513          	mv	a0,s1
80000498:	01041b93          	slli	s7,s0,0x10
8000049c:	4a4000ef          	jal	ra,80000940 <__udivsi3>
800004a0:	010bdb93          	srli	s7,s7,0x10
800004a4:	00050493          	mv	s1,a0
800004a8:	00050593          	mv	a1,a0
800004ac:	000b8513          	mv	a0,s7
800004b0:	3d4000ef          	jal	ra,80000884 <__mulsi3>
800004b4:	01091913          	slli	s2,s2,0x10
800004b8:	0109d713          	srli	a4,s3,0x10
800004bc:	00e96733          	or	a4,s2,a4
800004c0:	00048a93          	mv	s5,s1
800004c4:	00a77e63          	bgeu	a4,a0,800004e0 <__udivdi3+0x230>
800004c8:	00870733          	add	a4,a4,s0
800004cc:	fff48a93          	addi	s5,s1,-1
800004d0:	00876863          	bltu	a4,s0,800004e0 <__udivdi3+0x230>
800004d4:	00a77663          	bgeu	a4,a0,800004e0 <__udivdi3+0x230>
800004d8:	ffe48a93          	addi	s5,s1,-2
800004dc:	00870733          	add	a4,a4,s0
800004e0:	40a704b3          	sub	s1,a4,a0
800004e4:	000b0593          	mv	a1,s6
800004e8:	00048513          	mv	a0,s1
800004ec:	49c000ef          	jal	ra,80000988 <__umodsi3>
800004f0:	00050913          	mv	s2,a0
800004f4:	000b0593          	mv	a1,s6
800004f8:	00048513          	mv	a0,s1
800004fc:	444000ef          	jal	ra,80000940 <__udivsi3>
80000500:	01099993          	slli	s3,s3,0x10
80000504:	00050493          	mv	s1,a0
80000508:	00050593          	mv	a1,a0
8000050c:	01091913          	slli	s2,s2,0x10
80000510:	000b8513          	mv	a0,s7
80000514:	0109d993          	srli	s3,s3,0x10
80000518:	36c000ef          	jal	ra,80000884 <__mulsi3>
8000051c:	013969b3          	or	s3,s2,s3
80000520:	00048613          	mv	a2,s1
80000524:	00a9fc63          	bgeu	s3,a0,8000053c <__udivdi3+0x28c>
80000528:	013409b3          	add	s3,s0,s3
8000052c:	fff48613          	addi	a2,s1,-1
80000530:	0089e663          	bltu	s3,s0,8000053c <__udivdi3+0x28c>
80000534:	00a9f463          	bgeu	s3,a0,8000053c <__udivdi3+0x28c>
80000538:	ffe48613          	addi	a2,s1,-2
8000053c:	010a9793          	slli	a5,s5,0x10
80000540:	00c7e7b3          	or	a5,a5,a2
80000544:	00078513          	mv	a0,a5
80000548:	000a0593          	mv	a1,s4
8000054c:	02c12083          	lw	ra,44(sp)
80000550:	02812403          	lw	s0,40(sp)
80000554:	02412483          	lw	s1,36(sp)
80000558:	02012903          	lw	s2,32(sp)
8000055c:	01c12983          	lw	s3,28(sp)
80000560:	01812a03          	lw	s4,24(sp)
80000564:	01412a83          	lw	s5,20(sp)
80000568:	01012b03          	lw	s6,16(sp)
8000056c:	00c12b83          	lw	s7,12(sp)
80000570:	00812c03          	lw	s8,8(sp)
80000574:	00412c83          	lw	s9,4(sp)
80000578:	03010113          	addi	sp,sp,48
8000057c:	00008067          	ret
80000580:	010007b7          	lui	a5,0x1000
80000584:	01000a13          	li	s4,16
80000588:	ecf468e3          	bltu	s0,a5,80000458 <__udivdi3+0x1a8>
8000058c:	01800a13          	li	s4,24
80000590:	ec9ff06f          	j	80000458 <__udivdi3+0x1a8>
80000594:	00c41433          	sll	s0,s0,a2
80000598:	00d4da33          	srl	s4,s1,a3
8000059c:	00cb19b3          	sll	s3,s6,a2
800005a0:	00db56b3          	srl	a3,s6,a3
800005a4:	01045b13          	srli	s6,s0,0x10
800005a8:	00c494b3          	sll	s1,s1,a2
800005ac:	000b0593          	mv	a1,s6
800005b0:	000a0513          	mv	a0,s4
800005b4:	0096eab3          	or	s5,a3,s1
800005b8:	3d0000ef          	jal	ra,80000988 <__umodsi3>
800005bc:	00050913          	mv	s2,a0
800005c0:	000b0593          	mv	a1,s6
800005c4:	000a0513          	mv	a0,s4
800005c8:	01041b93          	slli	s7,s0,0x10
800005cc:	374000ef          	jal	ra,80000940 <__udivsi3>
800005d0:	010bdb93          	srli	s7,s7,0x10
800005d4:	00050493          	mv	s1,a0
800005d8:	00050593          	mv	a1,a0
800005dc:	000b8513          	mv	a0,s7
800005e0:	2a4000ef          	jal	ra,80000884 <__mulsi3>
800005e4:	01091913          	slli	s2,s2,0x10
800005e8:	010ad713          	srli	a4,s5,0x10
800005ec:	00e96733          	or	a4,s2,a4
800005f0:	00048a13          	mv	s4,s1
800005f4:	00a77e63          	bgeu	a4,a0,80000610 <__udivdi3+0x360>
800005f8:	00870733          	add	a4,a4,s0
800005fc:	fff48a13          	addi	s4,s1,-1
80000600:	00876863          	bltu	a4,s0,80000610 <__udivdi3+0x360>
80000604:	00a77663          	bgeu	a4,a0,80000610 <__udivdi3+0x360>
80000608:	ffe48a13          	addi	s4,s1,-2
8000060c:	00870733          	add	a4,a4,s0
80000610:	40a704b3          	sub	s1,a4,a0
80000614:	000b0593          	mv	a1,s6
80000618:	00048513          	mv	a0,s1
8000061c:	36c000ef          	jal	ra,80000988 <__umodsi3>
80000620:	00050913          	mv	s2,a0
80000624:	000b0593          	mv	a1,s6
80000628:	00048513          	mv	a0,s1
8000062c:	314000ef          	jal	ra,80000940 <__udivsi3>
80000630:	00050493          	mv	s1,a0
80000634:	00050593          	mv	a1,a0
80000638:	000b8513          	mv	a0,s7
8000063c:	248000ef          	jal	ra,80000884 <__mulsi3>
80000640:	010a9693          	slli	a3,s5,0x10
80000644:	01091913          	slli	s2,s2,0x10
80000648:	0106d693          	srli	a3,a3,0x10
8000064c:	00d967b3          	or	a5,s2,a3
80000650:	00048713          	mv	a4,s1
80000654:	00a7fe63          	bgeu	a5,a0,80000670 <__udivdi3+0x3c0>
80000658:	008787b3          	add	a5,a5,s0
8000065c:	fff48713          	addi	a4,s1,-1
80000660:	0087e863          	bltu	a5,s0,80000670 <__udivdi3+0x3c0>
80000664:	00a7f663          	bgeu	a5,a0,80000670 <__udivdi3+0x3c0>
80000668:	ffe48713          	addi	a4,s1,-2
8000066c:	008787b3          	add	a5,a5,s0
80000670:	010a1a13          	slli	s4,s4,0x10
80000674:	40a784b3          	sub	s1,a5,a0
80000678:	00ea6a33          	or	s4,s4,a4
8000067c:	e01ff06f          	j	8000047c <__udivdi3+0x1cc>
80000680:	1ed5ec63          	bltu	a1,a3,80000878 <__udivdi3+0x5c8>
80000684:	000107b7          	lui	a5,0x10
80000688:	04f6f463          	bgeu	a3,a5,800006d0 <__udivdi3+0x420>
8000068c:	0ff00593          	li	a1,255
80000690:	00d5b533          	sltu	a0,a1,a3
80000694:	00351513          	slli	a0,a0,0x3
80000698:	00a6d733          	srl	a4,a3,a0
8000069c:	00006797          	auipc	a5,0x6
800006a0:	abc78793          	addi	a5,a5,-1348 # 80006158 <__devconfig_end>
800006a4:	00e787b3          	add	a5,a5,a4
800006a8:	0007c583          	lbu	a1,0(a5)
800006ac:	02000a13          	li	s4,32
800006b0:	00a585b3          	add	a1,a1,a0
800006b4:	40ba0a33          	sub	s4,s4,a1
800006b8:	020a1663          	bnez	s4,800006e4 <__udivdi3+0x434>
800006bc:	00100793          	li	a5,1
800006c0:	e896e2e3          	bltu	a3,s1,80000544 <__udivdi3+0x294>
800006c4:	00cb3633          	sltu	a2,s6,a2
800006c8:	00164793          	xori	a5,a2,1
800006cc:	e79ff06f          	j	80000544 <__udivdi3+0x294>
800006d0:	010007b7          	lui	a5,0x1000
800006d4:	01000513          	li	a0,16
800006d8:	fcf6e0e3          	bltu	a3,a5,80000698 <__udivdi3+0x3e8>
800006dc:	01800513          	li	a0,24
800006e0:	fb9ff06f          	j	80000698 <__udivdi3+0x3e8>
800006e4:	00b65ab3          	srl	s5,a2,a1
800006e8:	014696b3          	sll	a3,a3,s4
800006ec:	00daeab3          	or	s5,s5,a3
800006f0:	00b4d933          	srl	s2,s1,a1
800006f4:	014497b3          	sll	a5,s1,s4
800006f8:	00bb55b3          	srl	a1,s6,a1
800006fc:	010adb93          	srli	s7,s5,0x10
80000700:	00f5e4b3          	or	s1,a1,a5
80000704:	00090513          	mv	a0,s2
80000708:	000b8593          	mv	a1,s7
8000070c:	014619b3          	sll	s3,a2,s4
80000710:	278000ef          	jal	ra,80000988 <__umodsi3>
80000714:	00050413          	mv	s0,a0
80000718:	000b8593          	mv	a1,s7
8000071c:	00090513          	mv	a0,s2
80000720:	010a9c13          	slli	s8,s5,0x10
80000724:	21c000ef          	jal	ra,80000940 <__udivsi3>
80000728:	010c5c13          	srli	s8,s8,0x10
8000072c:	00050913          	mv	s2,a0
80000730:	00050593          	mv	a1,a0
80000734:	000c0513          	mv	a0,s8
80000738:	14c000ef          	jal	ra,80000884 <__mulsi3>
8000073c:	01041413          	slli	s0,s0,0x10
80000740:	0104d713          	srli	a4,s1,0x10
80000744:	00e46733          	or	a4,s0,a4
80000748:	00090c93          	mv	s9,s2
8000074c:	00a77e63          	bgeu	a4,a0,80000768 <__udivdi3+0x4b8>
80000750:	01570733          	add	a4,a4,s5
80000754:	fff90c93          	addi	s9,s2,-1
80000758:	01576863          	bltu	a4,s5,80000768 <__udivdi3+0x4b8>
8000075c:	00a77663          	bgeu	a4,a0,80000768 <__udivdi3+0x4b8>
80000760:	ffe90c93          	addi	s9,s2,-2
80000764:	01570733          	add	a4,a4,s5
80000768:	40a70933          	sub	s2,a4,a0
8000076c:	000b8593          	mv	a1,s7
80000770:	00090513          	mv	a0,s2
80000774:	214000ef          	jal	ra,80000988 <__umodsi3>
80000778:	00050413          	mv	s0,a0
8000077c:	000b8593          	mv	a1,s7
80000780:	00090513          	mv	a0,s2
80000784:	1bc000ef          	jal	ra,80000940 <__udivsi3>
80000788:	00050913          	mv	s2,a0
8000078c:	00050593          	mv	a1,a0
80000790:	000c0513          	mv	a0,s8
80000794:	0f0000ef          	jal	ra,80000884 <__mulsi3>
80000798:	01049793          	slli	a5,s1,0x10
8000079c:	01041413          	slli	s0,s0,0x10
800007a0:	0107d793          	srli	a5,a5,0x10
800007a4:	00f46733          	or	a4,s0,a5
800007a8:	00090613          	mv	a2,s2
800007ac:	00a77e63          	bgeu	a4,a0,800007c8 <__udivdi3+0x518>
800007b0:	01570733          	add	a4,a4,s5
800007b4:	fff90613          	addi	a2,s2,-1
800007b8:	01576863          	bltu	a4,s5,800007c8 <__udivdi3+0x518>
800007bc:	00a77663          	bgeu	a4,a0,800007c8 <__udivdi3+0x518>
800007c0:	ffe90613          	addi	a2,s2,-2
800007c4:	01570733          	add	a4,a4,s5
800007c8:	010c9793          	slli	a5,s9,0x10
800007cc:	00010e37          	lui	t3,0x10
800007d0:	00c7e7b3          	or	a5,a5,a2
800007d4:	fffe0813          	addi	a6,t3,-1 # ffff <CONFIG_ISR_STACK_SIZE+0xf7ff>
800007d8:	0107f333          	and	t1,a5,a6
800007dc:	0109f833          	and	a6,s3,a6
800007e0:	40a70733          	sub	a4,a4,a0
800007e4:	0107de93          	srli	t4,a5,0x10
800007e8:	0109d993          	srli	s3,s3,0x10
800007ec:	00030513          	mv	a0,t1
800007f0:	00080593          	mv	a1,a6
800007f4:	090000ef          	jal	ra,80000884 <__mulsi3>
800007f8:	00050893          	mv	a7,a0
800007fc:	00098593          	mv	a1,s3
80000800:	00030513          	mv	a0,t1
80000804:	080000ef          	jal	ra,80000884 <__mulsi3>
80000808:	00050313          	mv	t1,a0
8000080c:	00080593          	mv	a1,a6
80000810:	000e8513          	mv	a0,t4
80000814:	070000ef          	jal	ra,80000884 <__mulsi3>
80000818:	00050813          	mv	a6,a0
8000081c:	00098593          	mv	a1,s3
80000820:	000e8513          	mv	a0,t4
80000824:	060000ef          	jal	ra,80000884 <__mulsi3>
80000828:	0108d693          	srli	a3,a7,0x10
8000082c:	01030333          	add	t1,t1,a6
80000830:	006686b3          	add	a3,a3,t1
80000834:	0106f463          	bgeu	a3,a6,8000083c <__udivdi3+0x58c>
80000838:	01c50533          	add	a0,a0,t3
8000083c:	0106d613          	srli	a2,a3,0x10
80000840:	00a60533          	add	a0,a2,a0
80000844:	02a76663          	bltu	a4,a0,80000870 <__udivdi3+0x5c0>
80000848:	bca714e3          	bne	a4,a0,80000410 <__udivdi3+0x160>
8000084c:	00010737          	lui	a4,0x10
80000850:	fff70713          	addi	a4,a4,-1 # ffff <CONFIG_ISR_STACK_SIZE+0xf7ff>
80000854:	00e6f6b3          	and	a3,a3,a4
80000858:	01069693          	slli	a3,a3,0x10
8000085c:	00e8f8b3          	and	a7,a7,a4
80000860:	014b1633          	sll	a2,s6,s4
80000864:	011686b3          	add	a3,a3,a7
80000868:	00000a13          	li	s4,0
8000086c:	ccd67ce3          	bgeu	a2,a3,80000544 <__udivdi3+0x294>
80000870:	fff78793          	addi	a5,a5,-1 # ffffff <CONFIG_SYS_CLOCK_HW_CYCLES_PER_SEC+0x48e4ff>
80000874:	b9dff06f          	j	80000410 <__udivdi3+0x160>
80000878:	00000a13          	li	s4,0
8000087c:	00000793          	li	a5,0
80000880:	cc5ff06f          	j	80000544 <__udivdi3+0x294>

80000884 <__mulsi3>:
80000884:	00050613          	mv	a2,a0
80000888:	00000513          	li	a0,0
8000088c:	0015f693          	andi	a3,a1,1
80000890:	00068463          	beqz	a3,80000898 <__mulsi3+0x14>
80000894:	00c50533          	add	a0,a0,a2
80000898:	0015d593          	srli	a1,a1,0x1
8000089c:	00161613          	slli	a2,a2,0x1
800008a0:	fe0596e3          	bnez	a1,8000088c <__mulsi3+0x8>
800008a4:	00008067          	ret

800008a8 <__muldi3>:
800008a8:	ff010113          	addi	sp,sp,-16
800008ac:	00068313          	mv	t1,a3
800008b0:	00112623          	sw	ra,12(sp)
800008b4:	00050e13          	mv	t3,a0
800008b8:	00050893          	mv	a7,a0
800008bc:	00060693          	mv	a3,a2
800008c0:	00000713          	li	a4,0
800008c4:	00000793          	li	a5,0
800008c8:	00000813          	li	a6,0
800008cc:	0016f513          	andi	a0,a3,1
800008d0:	00171e93          	slli	t4,a4,0x1
800008d4:	00050c63          	beqz	a0,800008ec <__muldi3+0x44>
800008d8:	01088533          	add	a0,a7,a6
800008dc:	01053833          	sltu	a6,a0,a6
800008e0:	00e787b3          	add	a5,a5,a4
800008e4:	00f807b3          	add	a5,a6,a5
800008e8:	00050813          	mv	a6,a0
800008ec:	01f8d713          	srli	a4,a7,0x1f
800008f0:	0016d693          	srli	a3,a3,0x1
800008f4:	00eee733          	or	a4,t4,a4
800008f8:	00189893          	slli	a7,a7,0x1
800008fc:	fc0698e3          	bnez	a3,800008cc <__muldi3+0x24>
80000900:	00058863          	beqz	a1,80000910 <__muldi3+0x68>
80000904:	00060513          	mv	a0,a2
80000908:	f7dff0ef          	jal	ra,80000884 <__mulsi3>
8000090c:	00a787b3          	add	a5,a5,a0
80000910:	00030a63          	beqz	t1,80000924 <__muldi3+0x7c>
80000914:	000e0513          	mv	a0,t3
80000918:	00030593          	mv	a1,t1
8000091c:	f69ff0ef          	jal	ra,80000884 <__mulsi3>
80000920:	00f507b3          	add	a5,a0,a5
80000924:	00c12083          	lw	ra,12(sp)
80000928:	00080513          	mv	a0,a6
8000092c:	00078593          	mv	a1,a5
80000930:	01010113          	addi	sp,sp,16
80000934:	00008067          	ret

80000938 <__divsi3>:
80000938:	06054063          	bltz	a0,80000998 <__umodsi3+0x10>
8000093c:	0605c663          	bltz	a1,800009a8 <__umodsi3+0x20>

80000940 <__udivsi3>:
80000940:	00058613          	mv	a2,a1
80000944:	00050593          	mv	a1,a0
80000948:	fff00513          	li	a0,-1
8000094c:	02060c63          	beqz	a2,80000984 <__udivsi3+0x44>
80000950:	00100693          	li	a3,1
80000954:	00b67a63          	bgeu	a2,a1,80000968 <__udivsi3+0x28>
80000958:	00c05863          	blez	a2,80000968 <__udivsi3+0x28>
8000095c:	00161613          	slli	a2,a2,0x1
80000960:	00169693          	slli	a3,a3,0x1
80000964:	feb66ae3          	bltu	a2,a1,80000958 <__udivsi3+0x18>
80000968:	00000513          	li	a0,0
8000096c:	00c5e663          	bltu	a1,a2,80000978 <__udivsi3+0x38>
80000970:	40c585b3          	sub	a1,a1,a2
80000974:	00d56533          	or	a0,a0,a3
80000978:	0016d693          	srli	a3,a3,0x1
8000097c:	00165613          	srli	a2,a2,0x1
80000980:	fe0696e3          	bnez	a3,8000096c <__udivsi3+0x2c>
80000984:	00008067          	ret

80000988 <__umodsi3>:
80000988:	00008293          	mv	t0,ra
8000098c:	fb5ff0ef          	jal	ra,80000940 <__udivsi3>
80000990:	00058513          	mv	a0,a1
80000994:	00028067          	jr	t0
80000998:	40a00533          	neg	a0,a0
8000099c:	0005d863          	bgez	a1,800009ac <__umodsi3+0x24>
800009a0:	40b005b3          	neg	a1,a1
800009a4:	f9dff06f          	j	80000940 <__udivsi3>
800009a8:	40b005b3          	neg	a1,a1
800009ac:	00008293          	mv	t0,ra
800009b0:	f91ff0ef          	jal	ra,80000940 <__udivsi3>
800009b4:	40a00533          	neg	a0,a0
800009b8:	00028067          	jr	t0

800009bc <__modsi3>:
800009bc:	00008293          	mv	t0,ra
800009c0:	0005ca63          	bltz	a1,800009d4 <__modsi3+0x18>
800009c4:	00054c63          	bltz	a0,800009dc <__modsi3+0x20>
800009c8:	f79ff0ef          	jal	ra,80000940 <__udivsi3>
800009cc:	00058513          	mv	a0,a1
800009d0:	00028067          	jr	t0
800009d4:	40b005b3          	neg	a1,a1
800009d8:	fe0558e3          	bgez	a0,800009c8 <__modsi3+0xc>
800009dc:	40a00533          	neg	a0,a0
800009e0:	f61ff0ef          	jal	ra,80000940 <__udivsi3>
800009e4:	40b00533          	neg	a0,a1
800009e8:	00028067          	jr	t0

800009ec <unit_test_noop>:
 * nothing, successfully. Can be used as a parameter to
 * ztest_unit_test_setup_teardown().
 */
static inline void unit_test_noop(void)
{
}
800009ec:	00008067          	ret

800009f0 <critical_rtn>:
{
	volatile u32_t x;

	ARG_UNUSED(unused);

	x = critical_var;
800009f0:	800077b7          	lui	a5,0x80007
800009f4:	e2c78793          	addi	a5,a5,-468 # 80006e2c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006e2d>
800009f8:	0007a703          	lw	a4,0(a5)
{
800009fc:	ff010113          	addi	sp,sp,-16
	x = critical_var;
80000a00:	00e12623          	sw	a4,12(sp)
	critical_var = x + 1;
80000a04:	00c12703          	lw	a4,12(sp)
80000a08:	00170713          	addi	a4,a4,1
80000a0c:	00e7a023          	sw	a4,0(a5)

}
80000a10:	01010113          	addi	sp,sp,16
80000a14:	00008067          	ret

80000a18 <z_zassert.constprop.0>:
#define z_zassert(cond, default_msg, file, line, func, msg, ...)	\
	z_zassert_(cond, file, line)

#else /* CONFIG_ZTEST_ASSERT_VERBOSE != 0 */

static inline void z_zassert(int cond,
80000a18:	fd010113          	addi	sp,sp,-48
80000a1c:	00112e23          	sw	ra,28(sp)
80000a20:	00812c23          	sw	s0,24(sp)
80000a24:	03012423          	sw	a6,40(sp)
80000a28:	03112623          	sw	a7,44(sp)
			    const char *default_msg,
			    const char *file,
			    int line, const char *func,
			    const char *msg, ...)
{
	if (!(cond)) {
80000a2c:	04051663          	bnez	a0,80000a78 <z_zassert.constprop.0+0x60>
80000a30:	00068613          	mv	a2,a3
		va_list vargs;

		va_start(vargs, msg);
		PRINT("\n    Assertion failed at %s:%d: %s: %s\n",
80000a34:	80006537          	lui	a0,0x80006
80000a38:	00070693          	mv	a3,a4
80000a3c:	00058713          	mv	a4,a1
80000a40:	800065b7          	lui	a1,0x80006
80000a44:	00078413          	mv	s0,a5
80000a48:	3b058593          	addi	a1,a1,944 # 800063b0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800063b1>
		va_start(vargs, msg);
80000a4c:	02810793          	addi	a5,sp,40
		PRINT("\n    Assertion failed at %s:%d: %s: %s\n",
80000a50:	3d450513          	addi	a0,a0,980 # 800063d4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800063d5>
		va_start(vargs, msg);
80000a54:	00f12623          	sw	a5,12(sp)
		PRINT("\n    Assertion failed at %s:%d: %s: %s\n",
80000a58:	618010ef          	jal	ra,80002070 <printk>
		      file, line, func, default_msg);
		vprintk(msg, vargs);
80000a5c:	00c12583          	lw	a1,12(sp)
80000a60:	00040513          	mv	a0,s0
80000a64:	5dc010ef          	jal	ra,80002040 <vprintk>
		printk("\n");
80000a68:	80006537          	lui	a0,0x80006
80000a6c:	55050513          	addi	a0,a0,1360 # 80006550 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006551>
80000a70:	600010ef          	jal	ra,80002070 <printk>
		va_end(vargs);
		ztest_test_fail();
80000a74:	589010ef          	jal	ra,800027fc <ztest_test_fail>
	else {
		PRINT("\n   Assertion succeeded at %s:%d (%s)\n",
		      file, line, func);
	}
#endif
}
80000a78:	01c12083          	lw	ra,28(sp)
80000a7c:	01812403          	lw	s0,24(sp)
80000a80:	03010113          	addi	sp,sp,48
80000a84:	00008067          	ret

80000a88 <test_critical>:

}

static void init_objects(void)
{
	critical_var = 0U;
80000a88:	800077b7          	lui	a5,0x80007
	alt_thread_iterations = 0U;
	k_work_q_start(&offload_work_q,
80000a8c:	800075b7          	lui	a1,0x80007
80000a90:	80007537          	lui	a0,0x80007
 * during context switch
 *
 * @ingroup kernel_critical_tests
 */
void test_critical(void)
{
80000a94:	fe010113          	addi	sp,sp,-32
	critical_var = 0U;
80000a98:	e207a623          	sw	zero,-468(a5) # 80006e2c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006e2d>
	k_work_q_start(&offload_work_q,
80000a9c:	fff00693          	li	a3,-1
	alt_thread_iterations = 0U;
80000aa0:	800077b7          	lui	a5,0x80007
	k_work_q_start(&offload_work_q,
80000aa4:	40000613          	li	a2,1024
80000aa8:	16058593          	addi	a1,a1,352 # 80007160 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007161>
80000aac:	e7050513          	addi	a0,a0,-400 # 80006e70 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006e71>
{
80000ab0:	00112e23          	sw	ra,28(sp)
	alt_thread_iterations = 0U;
80000ab4:	e207a423          	sw	zero,-472(a5) # 80006e28 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006e29>
	k_work_q_start(&offload_work_q,
80000ab8:	54c040ef          	jal	ra,80005004 <k_work_q_start>

K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_OBJECT_RELEASE, k_object_release, void *, object)

K_SYSCALL_DECLARE1(K_SYSCALL_K_OBJECT_ALLOC, k_object_alloc, void *, enum k_objects, otype)

K_SYSCALL_DECLARE10(K_SYSCALL_K_THREAD_CREATE, k_thread_create, k_tid_t, struct k_thread *, new_thread, k_thread_stack_t *, stack, size_t, stack_size, k_thread_entry_t, entry, void *, p1, void *, p2, void *, p3, int, prio, u32_t, options, s32_t, delay)
80000abc:	800016b7          	lui	a3,0x80001
80000ac0:	800075b7          	lui	a1,0x80007
80000ac4:	80007537          	lui	a0,0x80007
80000ac8:	00012223          	sw	zero,4(sp)
80000acc:	00012023          	sw	zero,0(sp)
80000ad0:	00c00893          	li	a7,12
80000ad4:	00000813          	li	a6,0
80000ad8:	00000793          	li	a5,0
80000adc:	00000713          	li	a4,0
80000ae0:	c2068693          	addi	a3,a3,-992 # 80000c20 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80000c21>
80000ae4:	40000613          	li	a2,1024
80000ae8:	56058593          	addi	a1,a1,1376 # 80007560 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007561>
80000aec:	ef450513          	addi	a0,a0,-268 # 80006ef4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006ef5>
80000af0:	28c040ef          	jal	ra,80004d7c <z_impl_k_thread_create>
80000af4:	800016b7          	lui	a3,0x80001
80000af8:	800085b7          	lui	a1,0x80008
80000afc:	80007537          	lui	a0,0x80007
80000b00:	00000793          	li	a5,0
80000b04:	00000713          	li	a4,0
80000b08:	c9868693          	addi	a3,a3,-872 # 80000c98 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80000c99>
80000b0c:	40000613          	li	a2,1024
80000b10:	00012223          	sw	zero,4(sp)
80000b14:	00012023          	sw	zero,0(sp)
80000b18:	00c00893          	li	a7,12
80000b1c:	00000813          	li	a6,0
80000b20:	96058593          	addi	a1,a1,-1696 # 80007960 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007961>
80000b24:	f6450513          	addi	a0,a0,-156 # 80006f64 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006f65>
80000b28:	254040ef          	jal	ra,80004d7c <z_impl_k_thread_create>

K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_MUTEX_UNLOCK, k_mutex_unlock, struct k_mutex *, mutex)

K_SYSCALL_DECLARE3_VOID(K_SYSCALL_K_SEM_INIT, k_sem_init, struct k_sem *, sem, unsigned int, initial_count, unsigned int, limit)

K_SYSCALL_DECLARE2(K_SYSCALL_K_SEM_TAKE, k_sem_take, int, struct k_sem *, sem, s32_t, timeout)
80000b2c:	0000a5b7          	lui	a1,0xa
80000b30:	80007537          	lui	a0,0x80007
80000b34:	c4058593          	addi	a1,a1,-960 # 9c40 <CONFIG_ISR_STACK_SIZE+0x9440>
80000b38:	df050513          	addi	a0,a0,-528 # 80006df0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006df1>
80000b3c:	581030ef          	jal	ra,800048bc <z_impl_k_sem_take>
	init_objects();
	start_threads();

	zassert_true(k_sem_take(&TEST_SEM, TEST_TIMEOUT * 2) == 0,
		     "Timed out waiting for TEST_SEM");
}
80000b40:	01c12083          	lw	ra,28(sp)
	zassert_true(k_sem_take(&TEST_SEM, TEST_TIMEOUT * 2) == 0,
80000b44:	800067b7          	lui	a5,0x80006
80000b48:	80006737          	lui	a4,0x80006
80000b4c:	80006637          	lui	a2,0x80006
80000b50:	800065b7          	lui	a1,0x80006
80000b54:	34878793          	addi	a5,a5,840 # 80006348 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006349>
80000b58:	26c70713          	addi	a4,a4,620 # 8000626c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000626d>
80000b5c:	0dc00693          	li	a3,220
80000b60:	3b060613          	addi	a2,a2,944 # 800063b0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800063b1>
80000b64:	36858593          	addi	a1,a1,872 # 80006368 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006369>
80000b68:	00153513          	seqz	a0,a0
}
80000b6c:	02010113          	addi	sp,sp,32
	zassert_true(k_sem_take(&TEST_SEM, TEST_TIMEOUT * 2) == 0,
80000b70:	ea9ff06f          	j	80000a18 <z_zassert.constprop.0>

80000b74 <critical_loop>:
{
80000b74:	fd010113          	addi	sp,sp,-48
80000b78:	02912223          	sw	s1,36(sp)
	while (k_uptime_get() < mseconds + NUM_MILLISECONDS) {
80000b7c:	000014b7          	lui	s1,0x1
{
80000b80:	02812423          	sw	s0,40(sp)
80000b84:	03212023          	sw	s2,32(sp)
80000b88:	01312e23          	sw	s3,28(sp)
80000b8c:	01412c23          	sw	s4,24(sp)
80000b90:	02112623          	sw	ra,44(sp)
80000b94:	00050913          	mv	s2,a0
	while (k_uptime_get() < mseconds + NUM_MILLISECONDS) {
80000b98:	38848493          	addi	s1,s1,904 # 1388 <CONFIG_ISR_STACK_SIZE+0xb88>
K_SYSCALL_DECLARE0_RET64(K_SYSCALL_K_UPTIME_GET, k_uptime_get, s64_t)
80000b9c:	61d040ef          	jal	ra,800059b8 <z_impl_k_uptime_get>
80000ba0:	009504b3          	add	s1,a0,s1
80000ba4:	00a4b433          	sltu	s0,s1,a0
 * @return N/A
 * @req K-WORK-001
 */
static inline void k_work_init(struct k_work *work, k_work_handler_t handler)
{
	*work = (struct k_work)Z_WORK_INITIALIZER(handler);
80000ba8:	800019b7          	lui	s3,0x80001
80000bac:	00b40433          	add	s0,s0,a1
80000bb0:	9f098993          	addi	s3,s3,-1552 # 800009f0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800009f1>
 */
static inline void k_work_submit_to_queue(struct k_work_q *work_q,
					  struct k_work *work)
{
	if (!atomic_test_and_set_bit(work->flags, K_WORK_STATE_PENDING)) {
		k_queue_append(&work_q->queue, work);
80000bb4:	80007a37          	lui	s4,0x80007
80000bb8:	601040ef          	jal	ra,800059b8 <z_impl_k_uptime_get>
80000bbc:	0285c863          	blt	a1,s0,80000bec <critical_loop+0x78>
80000bc0:	00b41463          	bne	s0,a1,80000bc8 <critical_loop+0x54>
80000bc4:	02956463          	bltu	a0,s1,80000bec <critical_loop+0x78>
}
80000bc8:	02c12083          	lw	ra,44(sp)
80000bcc:	02812403          	lw	s0,40(sp)
80000bd0:	00090513          	mv	a0,s2
80000bd4:	02412483          	lw	s1,36(sp)
80000bd8:	02012903          	lw	s2,32(sp)
80000bdc:	01c12983          	lw	s3,28(sp)
80000be0:	01812a03          	lw	s4,24(sp)
80000be4:	03010113          	addi	sp,sp,48
80000be8:	00008067          	ret

K_SYSCALL_DECLARE2(K_SYSCALL_ATOMIC_SUB, atomic_sub, atomic_val_t, atomic_t *, target, atomic_val_t, value)

K_SYSCALL_DECLARE2(K_SYSCALL_ATOMIC_SET, atomic_set, atomic_val_t, atomic_t *, target, atomic_val_t, value)

K_SYSCALL_DECLARE2(K_SYSCALL_ATOMIC_OR, atomic_or, atomic_val_t, atomic_t *, target, atomic_val_t, value)
80000bec:	00100593          	li	a1,1
80000bf0:	00c10513          	addi	a0,sp,12
	*work = (struct k_work)Z_WORK_INITIALIZER(handler);
80000bf4:	00012223          	sw	zero,4(sp)
80000bf8:	01312423          	sw	s3,8(sp)
80000bfc:	00012623          	sw	zero,12(sp)
80000c00:	5e9040ef          	jal	ra,800059e8 <z_impl_atomic_or>
	atomic_val_t mask = ATOMIC_MASK(bit);
	atomic_val_t old;

	old = atomic_or(ATOMIC_ELEM(target, bit), mask);

	return (old & mask) != 0;
80000c04:	00157513          	andi	a0,a0,1
	if (!atomic_test_and_set_bit(work->flags, K_WORK_STATE_PENDING)) {
80000c08:	00051863          	bnez	a0,80000c18 <critical_loop+0xa4>
		k_queue_append(&work_q->queue, work);
80000c0c:	00410593          	addi	a1,sp,4
80000c10:	e70a0513          	addi	a0,s4,-400 # 80006e70 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006e71>
80000c14:	404020ef          	jal	ra,80003018 <k_queue_append>
		count++;
80000c18:	00190913          	addi	s2,s2,1
80000c1c:	f9dff06f          	j	80000bb8 <critical_loop+0x44>

80000c20 <alternate_thread>:
{
80000c20:	ff010113          	addi	sp,sp,-16
80000c24:	01212023          	sw	s2,0(sp)
K_SYSCALL_DECLARE2(K_SYSCALL_K_SEM_TAKE, k_sem_take, int, struct k_sem *, sem, s32_t, timeout)
80000c28:	80007937          	lui	s2,0x80007
80000c2c:	00812423          	sw	s0,8(sp)
80000c30:	fff00593          	li	a1,-1
80000c34:	dd090513          	addi	a0,s2,-560 # 80006dd0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006dd1>
	alt_thread_iterations = critical_loop(alt_thread_iterations);
80000c38:	80007437          	lui	s0,0x80007
{
80000c3c:	00112623          	sw	ra,12(sp)
80000c40:	00912223          	sw	s1,4(sp)
	alt_thread_iterations = critical_loop(alt_thread_iterations);
80000c44:	e2840413          	addi	s0,s0,-472 # 80006e28 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006e29>
80000c48:	475030ef          	jal	ra,800048bc <z_impl_k_sem_take>
80000c4c:	00042503          	lw	a0,0(s0)

K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_SEM_GIVE, k_sem_give, struct k_sem *, sem)
80000c50:	800074b7          	lui	s1,0x80007
80000c54:	f21ff0ef          	jal	ra,80000b74 <critical_loop>
80000c58:	00a42023          	sw	a0,0(s0)
80000c5c:	de048513          	addi	a0,s1,-544 # 80006de0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006de1>
80000c60:	379030ef          	jal	ra,800047d8 <z_impl_k_sem_give>
K_SYSCALL_DECLARE2(K_SYSCALL_K_SEM_TAKE, k_sem_take, int, struct k_sem *, sem, s32_t, timeout)
80000c64:	fff00593          	li	a1,-1
80000c68:	dd090513          	addi	a0,s2,-560
80000c6c:	451030ef          	jal	ra,800048bc <z_impl_k_sem_take>
	alt_thread_iterations = critical_loop(alt_thread_iterations);
80000c70:	00042503          	lw	a0,0(s0)
80000c74:	f01ff0ef          	jal	ra,80000b74 <critical_loop>
80000c78:	00a42023          	sw	a0,0(s0)
}
80000c7c:	00812403          	lw	s0,8(sp)
80000c80:	00c12083          	lw	ra,12(sp)
80000c84:	00012903          	lw	s2,0(sp)
K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_SEM_GIVE, k_sem_give, struct k_sem *, sem)
80000c88:	de048513          	addi	a0,s1,-544
80000c8c:	00412483          	lw	s1,4(sp)
80000c90:	01010113          	addi	sp,sp,16
80000c94:	3450306f          	j	800047d8 <z_impl_k_sem_give>

80000c98 <regression_thread>:
{
80000c98:	fc010113          	addi	sp,sp,-64
80000c9c:	01b12623          	sw	s11,12(sp)
80000ca0:	80007db7          	lui	s11,0x80007
80000ca4:	dd0d8513          	addi	a0,s11,-560 # 80006dd0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006dd1>
80000ca8:	02112e23          	sw	ra,60(sp)
80000cac:	02812c23          	sw	s0,56(sp)
80000cb0:	02912a23          	sw	s1,52(sp)
80000cb4:	03212823          	sw	s2,48(sp)
80000cb8:	03312623          	sw	s3,44(sp)
80000cbc:	03412423          	sw	s4,40(sp)
80000cc0:	03512223          	sw	s5,36(sp)
80000cc4:	03612023          	sw	s6,32(sp)
80000cc8:	01712e23          	sw	s7,28(sp)
80000ccc:	01812c23          	sw	s8,24(sp)
80000cd0:	01912a23          	sw	s9,20(sp)
80000cd4:	01a12823          	sw	s10,16(sp)
80000cd8:	301030ef          	jal	ra,800047d8 <z_impl_k_sem_give>
	ncalls = critical_loop(ncalls);
80000cdc:	00000513          	li	a0,0
80000ce0:	e95ff0ef          	jal	ra,80000b74 <critical_loop>
K_SYSCALL_DECLARE2(K_SYSCALL_K_SEM_TAKE, k_sem_take, int, struct k_sem *, sem, s32_t, timeout)
80000ce4:	80007cb7          	lui	s9,0x80007
80000ce8:	00005d37          	lui	s10,0x5
80000cec:	00050413          	mv	s0,a0
80000cf0:	e20d0593          	addi	a1,s10,-480 # 4e20 <CONFIG_ISR_STACK_SIZE+0x4620>
80000cf4:	de0c8513          	addi	a0,s9,-544 # 80006de0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006de1>
80000cf8:	3c5030ef          	jal	ra,800048bc <z_impl_k_sem_take>
	zassert_true(k_sem_take(&REGRESS_SEM, TEST_TIMEOUT) == 0,
80000cfc:	80006937          	lui	s2,0x80006
80000d00:	800064b7          	lui	s1,0x80006
80000d04:	80006c37          	lui	s8,0x80006
80000d08:	80006bb7          	lui	s7,0x80006
80000d0c:	27cc0793          	addi	a5,s8,636 # 8000627c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000627d>
80000d10:	25890713          	addi	a4,s2,600 # 80006258 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006259>
80000d14:	3b048613          	addi	a2,s1,944 # 800063b0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800063b1>
80000d18:	2a0b8593          	addi	a1,s7,672 # 800062a0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800062a1>
80000d1c:	0a300693          	li	a3,163
80000d20:	00153513          	seqz	a0,a0
	zassert_equal(critical_var, ncalls + alt_thread_iterations,
80000d24:	80007a37          	lui	s4,0x80007
	zassert_true(k_sem_take(&REGRESS_SEM, TEST_TIMEOUT) == 0,
80000d28:	cf1ff0ef          	jal	ra,80000a18 <z_zassert.constprop.0>
	zassert_equal(critical_var, ncalls + alt_thread_iterations,
80000d2c:	e28a0a13          	addi	s4,s4,-472 # 80006e28 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006e29>
80000d30:	800079b7          	lui	s3,0x80007
80000d34:	000a2503          	lw	a0,0(s4)
80000d38:	e2c98993          	addi	s3,s3,-468 # 80006e2c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006e2d>
80000d3c:	0009a783          	lw	a5,0(s3)
80000d40:	00a40533          	add	a0,s0,a0
80000d44:	80006b37          	lui	s6,0x80006
80000d48:	80006ab7          	lui	s5,0x80006
80000d4c:	40f50533          	sub	a0,a0,a5
80000d50:	25890713          	addi	a4,s2,600
80000d54:	2d8b0793          	addi	a5,s6,728 # 800062d8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800062d9>
80000d58:	3b048613          	addi	a2,s1,944
80000d5c:	0a600693          	li	a3,166
80000d60:	2fca8593          	addi	a1,s5,764 # 800062fc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800062fd>
80000d64:	00153513          	seqz	a0,a0
80000d68:	cb1ff0ef          	jal	ra,80000a18 <z_zassert.constprop.0>
	k_sched_time_slice_set(10, 10);
80000d6c:	00a00593          	li	a1,10
80000d70:	00a00513          	li	a0,10
80000d74:	500020ef          	jal	ra,80003274 <k_sched_time_slice_set>
K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_SEM_GIVE, k_sem_give, struct k_sem *, sem)
80000d78:	dd0d8513          	addi	a0,s11,-560
80000d7c:	25d030ef          	jal	ra,800047d8 <z_impl_k_sem_give>
	ncalls = critical_loop(ncalls);
80000d80:	00040513          	mv	a0,s0
80000d84:	df1ff0ef          	jal	ra,80000b74 <critical_loop>
K_SYSCALL_DECLARE2(K_SYSCALL_K_SEM_TAKE, k_sem_take, int, struct k_sem *, sem, s32_t, timeout)
80000d88:	e20d0593          	addi	a1,s10,-480
80000d8c:	00050413          	mv	s0,a0
80000d90:	de0c8513          	addi	a0,s9,-544
80000d94:	329030ef          	jal	ra,800048bc <z_impl_k_sem_take>
	zassert_true(k_sem_take(&REGRESS_SEM, TEST_TIMEOUT) == 0,
80000d98:	27cc0793          	addi	a5,s8,636
80000d9c:	25890713          	addi	a4,s2,600
80000da0:	3b048613          	addi	a2,s1,944
80000da4:	2a0b8593          	addi	a1,s7,672
80000da8:	0b000693          	li	a3,176
80000dac:	00153513          	seqz	a0,a0
80000db0:	c69ff0ef          	jal	ra,80000a18 <z_zassert.constprop.0>
	zassert_equal(critical_var, ncalls + alt_thread_iterations,
80000db4:	000a2503          	lw	a0,0(s4)
80000db8:	2d8b0793          	addi	a5,s6,728
80000dbc:	25890713          	addi	a4,s2,600
80000dc0:	00a40433          	add	s0,s0,a0
80000dc4:	0009a503          	lw	a0,0(s3)
80000dc8:	3b048613          	addi	a2,s1,944
80000dcc:	2fca8593          	addi	a1,s5,764
80000dd0:	40a40533          	sub	a0,s0,a0
80000dd4:	00153513          	seqz	a0,a0
80000dd8:	0b300693          	li	a3,179
80000ddc:	c3dff0ef          	jal	ra,80000a18 <z_zassert.constprop.0>
}
80000de0:	03812403          	lw	s0,56(sp)
80000de4:	03c12083          	lw	ra,60(sp)
80000de8:	03412483          	lw	s1,52(sp)
80000dec:	03012903          	lw	s2,48(sp)
80000df0:	02c12983          	lw	s3,44(sp)
80000df4:	02812a03          	lw	s4,40(sp)
80000df8:	02412a83          	lw	s5,36(sp)
80000dfc:	02012b03          	lw	s6,32(sp)
80000e00:	01c12b83          	lw	s7,28(sp)
80000e04:	01812c03          	lw	s8,24(sp)
80000e08:	01412c83          	lw	s9,20(sp)
80000e0c:	01012d03          	lw	s10,16(sp)
80000e10:	00c12d83          	lw	s11,12(sp)
K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_SEM_GIVE, k_sem_give, struct k_sem *, sem)
80000e14:	80007537          	lui	a0,0x80007
80000e18:	df050513          	addi	a0,a0,-528 # 80006df0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006df1>
80000e1c:	04010113          	addi	sp,sp,64
80000e20:	1b90306f          	j	800047d8 <z_impl_k_sem_give>

80000e24 <test_main>:
void test_main(void)
{
	ztest_test_suite(kernel_critical,
			 ztest_unit_test(test_critical)
			 );
	ztest_run_test_suite(kernel_critical);
80000e24:	800075b7          	lui	a1,0x80007
80000e28:	80006537          	lui	a0,0x80006
80000e2c:	d5c58593          	addi	a1,a1,-676 # 80006d5c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006d5d>
80000e30:	3a050513          	addi	a0,a0,928 # 800063a0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800063a1>
80000e34:	1f90106f          	j	8000282c <z_ztest_run_test_suite>

80000e38 <z_SysFatalErrorHandler>:
 *
 * @return N/A
 */
FUNC_NORETURN __weak void z_SysFatalErrorHandler(unsigned int reason,
						const NANO_ESF *esf)
{
80000e38:	ff010113          	addi	sp,sp,-16
80000e3c:	00112623          	sw	ra,12(sp)
80000e40:	00812423          	sw	s0,8(sp)
#ifdef CONFIG_STACK_SENTINEL
	if (reason == _NANO_ERR_STACK_CHK_FAIL) {
		goto hang_system;
	}
#endif
	if (reason == _NANO_ERR_KERNEL_PANIC) {
80000e44:	00600793          	li	a5,6
80000e48:	02f50463          	beq	a0,a5,80000e70 <z_SysFatalErrorHandler+0x38>
		goto hang_system;
	}
	if (k_is_in_isr() || z_is_thread_essential()) {
80000e4c:	459030ef          	jal	ra,80004aa4 <k_is_in_isr>
80000e50:	02050463          	beqz	a0,80000e78 <z_SysFatalErrorHandler+0x40>
		printk("Fatal fault in %s! Spinning...\n",
		       k_is_in_isr() ? "ISR" : "essential thread");
80000e54:	451030ef          	jal	ra,80004aa4 <k_is_in_isr>
		printk("Fatal fault in %s! Spinning...\n",
80000e58:	04051663          	bnez	a0,80000ea4 <z_SysFatalErrorHandler+0x6c>
80000e5c:	800065b7          	lui	a1,0x80006
80000e60:	6ac58593          	addi	a1,a1,1708 # 800066ac <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800066ad>
80000e64:	80006537          	lui	a0,0x80006
80000e68:	6c050513          	addi	a0,a0,1728 # 800066c0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800066c1>
80000e6c:	204010ef          	jal	ra,80002070 <printk>
#else
	ARG_UNUSED(reason);
#endif

	for (;;) {
		k_cpu_idle();
80000e70:	270010ef          	jal	ra,800020e0 <k_cpu_idle>
80000e74:	ffdff06f          	j	80000e70 <z_SysFatalErrorHandler+0x38>
	if (k_is_in_isr() || z_is_thread_essential()) {
80000e78:	43d030ef          	jal	ra,80004ab4 <z_is_thread_essential>
80000e7c:	fc051ce3          	bnez	a0,80000e54 <z_SysFatalErrorHandler+0x1c>
	printk("Fatal fault in thread %p! Aborting.\n", _current);
80000e80:	80007437          	lui	s0,0x80007
80000e84:	13440413          	addi	s0,s0,308 # 80007134 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007135>
80000e88:	00842583          	lw	a1,8(s0)
80000e8c:	80006537          	lui	a0,0x80006
80000e90:	6e050513          	addi	a0,a0,1760 # 800066e0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800066e1>
80000e94:	1dc010ef          	jal	ra,80002070 <printk>
K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_THREAD_ABORT, k_thread_abort, k_tid_t, thread)
80000e98:	00842503          	lw	a0,8(s0)
80000e9c:	084040ef          	jal	ra,80004f20 <z_impl_k_thread_abort>
80000ea0:	fd1ff06f          	j	80000e70 <z_SysFatalErrorHandler+0x38>
		printk("Fatal fault in %s! Spinning...\n",
80000ea4:	800065b7          	lui	a1,0x80006
80000ea8:	6a858593          	addi	a1,a1,1704 # 800066a8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800066a9>
80000eac:	fb9ff06f          	j	80000e64 <z_SysFatalErrorHandler+0x2c>

80000eb0 <z_NanoFatalErrorHandler>:
{
80000eb0:	fb010113          	addi	sp,sp,-80
80000eb4:	04812423          	sw	s0,72(sp)
80000eb8:	04912223          	sw	s1,68(sp)
80000ebc:	04112623          	sw	ra,76(sp)
	switch (reason) {
80000ec0:	00600793          	li	a5,6
{
80000ec4:	00050493          	mv	s1,a0
80000ec8:	00058413          	mv	s0,a1
	switch (reason) {
80000ecc:	0ea7e063          	bltu	a5,a0,80000fac <z_NanoFatalErrorHandler+0xfc>
80000ed0:	80006737          	lui	a4,0x80006
80000ed4:	00251793          	slli	a5,a0,0x2
80000ed8:	3fc70713          	addi	a4,a4,1020 # 800063fc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800063fd>
80000edc:	00e787b3          	add	a5,a5,a4
80000ee0:	0007a783          	lw	a5,0(a5)
80000ee4:	00078067          	jr	a5
		printk("**** Kernel Allocation Failure! ****\n");
80000ee8:	80006537          	lui	a0,0x80006
80000eec:	52c50513          	addi	a0,a0,1324 # 8000652c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000652d>
		printk("***** Kernel OOPS! *****\n");
80000ef0:	180010ef          	jal	ra,80002070 <printk>
K_SYSCALL_DECLARE0(K_SYSCALL_K_CURRENT_GET, k_current_get, k_tid_t)
80000ef4:	011030ef          	jal	ra,80004704 <z_impl_k_current_get>
	printk("Current thread ID = %p\n"
80000ef8:	04442783          	lw	a5,68(s0)
80000efc:	01042883          	lw	a7,16(s0)
80000f00:	00c42803          	lw	a6,12(s0)
80000f04:	02f12823          	sw	a5,48(sp)
80000f08:	04042783          	lw	a5,64(s0)
80000f0c:	00442703          	lw	a4,4(s0)
80000f10:	00042683          	lw	a3,0(s0)
80000f14:	02f12623          	sw	a5,44(sp)
80000f18:	03c42783          	lw	a5,60(s0)
80000f1c:	04842603          	lw	a2,72(s0)
80000f20:	00050593          	mv	a1,a0
80000f24:	02f12423          	sw	a5,40(sp)
80000f28:	03842783          	lw	a5,56(s0)
80000f2c:	80006537          	lui	a0,0x80006
80000f30:	5b050513          	addi	a0,a0,1456 # 800065b0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800065b1>
80000f34:	02f12223          	sw	a5,36(sp)
80000f38:	03442783          	lw	a5,52(s0)
80000f3c:	02f12023          	sw	a5,32(sp)
80000f40:	03042783          	lw	a5,48(s0)
80000f44:	00f12e23          	sw	a5,28(sp)
80000f48:	02c42783          	lw	a5,44(s0)
80000f4c:	00f12c23          	sw	a5,24(sp)
80000f50:	02842783          	lw	a5,40(s0)
80000f54:	00f12a23          	sw	a5,20(sp)
80000f58:	02442783          	lw	a5,36(s0)
80000f5c:	00f12823          	sw	a5,16(sp)
80000f60:	02042783          	lw	a5,32(s0)
80000f64:	00f12623          	sw	a5,12(sp)
80000f68:	01c42783          	lw	a5,28(s0)
80000f6c:	00f12423          	sw	a5,8(sp)
80000f70:	01842783          	lw	a5,24(s0)
80000f74:	00f12223          	sw	a5,4(sp)
80000f78:	01442783          	lw	a5,20(s0)
80000f7c:	00f12023          	sw	a5,0(sp)
80000f80:	00842783          	lw	a5,8(s0)
80000f84:	0ec010ef          	jal	ra,80002070 <printk>
	z_SysFatalErrorHandler(reason, esf);
80000f88:	00040593          	mv	a1,s0
80000f8c:	00048513          	mv	a0,s1
80000f90:	ea9ff0ef          	jal	ra,80000e38 <z_SysFatalErrorHandler>
		printk("***** Kernel OOPS! *****\n");
80000f94:	80006537          	lui	a0,0x80006
80000f98:	55450513          	addi	a0,a0,1364 # 80006554 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006555>
80000f9c:	f55ff06f          	j	80000ef0 <z_NanoFatalErrorHandler+0x40>
		printk("***** Kernel Panic! *****\n");
80000fa0:	80006537          	lui	a0,0x80006
80000fa4:	57050513          	addi	a0,a0,1392 # 80006570 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006571>
80000fa8:	f49ff06f          	j	80000ef0 <z_NanoFatalErrorHandler+0x40>
		printk("**** Unknown Fatal Error %d! ****\n", reason);
80000fac:	80006537          	lui	a0,0x80006
80000fb0:	00048593          	mv	a1,s1
80000fb4:	58c50513          	addi	a0,a0,1420 # 8000658c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000658d>
80000fb8:	0b8010ef          	jal	ra,80002070 <printk>
		break;
80000fbc:	f39ff06f          	j	80000ef4 <z_NanoFatalErrorHandler+0x44>

80000fc0 <_Fault>:
	}
}


FUNC_NORETURN void _Fault(const NANO_ESF *esf)
{
80000fc0:	ff010113          	addi	sp,sp,-16
80000fc4:	00812423          	sw	s0,8(sp)
80000fc8:	00112623          	sw	ra,12(sp)
80000fcc:	00050413          	mv	s0,a0
	u32_t mcause;

	__asm__ volatile("csrr %0, mcause" : "=r" (mcause));
80000fd0:	34202673          	csrr	a2,mcause

	mcause &= SOC_MCAUSE_EXP_MASK;
80000fd4:	00161613          	slli	a2,a2,0x1
80000fd8:	00165613          	srli	a2,a2,0x1
	switch (cause) {
80000fdc:	00500793          	li	a5,5
80000fe0:	02c7e863          	bltu	a5,a2,80001010 <_Fault+0x50>
80000fe4:	80006737          	lui	a4,0x80006
80000fe8:	00261793          	slli	a5,a2,0x2
80000fec:	41870713          	addi	a4,a4,1048 # 80006418 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006419>
80000ff0:	00f707b3          	add	a5,a4,a5
80000ff4:	0007a583          	lw	a1,0(a5)
	printk("Exception cause %s (%d)\n", cause_str(mcause), (int)mcause);
80000ff8:	80006537          	lui	a0,0x80006
80000ffc:	43850513          	addi	a0,a0,1080 # 80006438 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006439>
80001000:	070010ef          	jal	ra,80002070 <printk>

	z_NanoFatalErrorHandler(_NANO_ERR_CPU_EXCEPTION, esf);
80001004:	00040593          	mv	a1,s0
80001008:	00000513          	li	a0,0
8000100c:	ea5ff0ef          	jal	ra,80000eb0 <z_NanoFatalErrorHandler>
	mcause &= SOC_MCAUSE_EXP_MASK;
80001010:	800065b7          	lui	a1,0x80006
80001014:	43058593          	addi	a1,a1,1072 # 80006430 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006431>
80001018:	fe1ff06f          	j	80000ff8 <_Fault+0x38>

8000101c <z_irq_spurious>:
#include <toolchain.h>
#include <kernel_structs.h>
#include <misc/printk.h>

void z_irq_spurious(void *unused)
{
8000101c:	ff010113          	addi	sp,sp,-16
80001020:	00112623          	sw	ra,12(sp)
	u32_t mcause;

	ARG_UNUSED(unused);

	__asm__ volatile("csrr %0, mcause" : "=r" (mcause));
80001024:	342025f3          	csrr	a1,mcause

	mcause &= SOC_MCAUSE_EXP_MASK;

	printk("Spurious interrupt detected! IRQ: %d\n", (int)mcause);
80001028:	80006537          	lui	a0,0x80006
	mcause &= SOC_MCAUSE_EXP_MASK;
8000102c:	00159593          	slli	a1,a1,0x1
	printk("Spurious interrupt detected! IRQ: %d\n", (int)mcause);
80001030:	0015d593          	srli	a1,a1,0x1
80001034:	70850513          	addi	a0,a0,1800 # 80006708 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006709>
80001038:	038010ef          	jal	ra,80002070 <printk>
		printk("PLIC interrupt line causing the IRQ: %d\n",
		       riscv_plic_get_irq());
	}
#endif

	z_NanoFatalErrorHandler(_NANO_ERR_SPURIOUS_INT, &_default_esf);
8000103c:	800065b7          	lui	a1,0x80006
80001040:	45458593          	addi	a1,a1,1108 # 80006454 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006455>
80001044:	00400513          	li	a0,4
80001048:	e69ff0ef          	jal	ra,80000eb0 <z_NanoFatalErrorHandler>

8000104c <z_irq_do_offload>:
 */
void z_irq_do_offload(void)
{
	irq_offload_routine_t tmp;

	if (!_offload_routine)
8000104c:	800077b7          	lui	a5,0x80007
80001050:	e3078793          	addi	a5,a5,-464 # 80006e30 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006e31>
80001054:	0007a703          	lw	a4,0(a5)
80001058:	00070c63          	beqz	a4,80001070 <z_irq_do_offload+0x24>
		return;

	tmp = _offload_routine;
8000105c:	0007a303          	lw	t1,0(a5)
	_offload_routine = NULL;
80001060:	0007a023          	sw	zero,0(a5)

	tmp((void *)offload_param);
80001064:	800077b7          	lui	a5,0x80007
80001068:	e347a503          	lw	a0,-460(a5) # 80006e34 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006e35>
8000106c:	00030067          	jr	t1 # 80000000 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80000001>
}
80001070:	00008067          	ret

80001074 <_PrepC>:
 *
 * @return N/A
 */

void _PrepC(void)
{
80001074:	ff010113          	addi	sp,sp,-16
80001078:	00112623          	sw	ra,12(sp)
	z_bss_zero();
8000107c:	365010ef          	jal	ra,80002be0 <z_bss_zero>
#ifdef CONFIG_XIP
	z_data_copy();
#endif
#if defined(CONFIG_RISCV_SOC_INTERRUPT_INIT)
	soc_interrupt_init();
80001080:	080010ef          	jal	ra,80002100 <soc_interrupt_init>
#endif
	z_cstart();
80001084:	3c9010ef          	jal	ra,80002c4c <z_cstart>

80001088 <__initialize>:

	/*
	 * Initially, setup stack pointer to
	 * _interrupt_stack + CONFIG_ISR_STACK_SIZE
	 */
	la sp, _interrupt_stack
80001088:	00007117          	auipc	sp,0x7
8000108c:	4d810113          	addi	sp,sp,1240 # 80008560 <_interrupt_stack>
	li t0, CONFIG_ISR_STACK_SIZE
80001090:	000012b7          	lui	t0,0x1
80001094:	80028293          	addi	t0,t0,-2048 # 800 <CONFIG_ISR_STACK_SIZE>
	add sp, sp, t0
80001098:	00510133          	add	sp,sp,t0

	/*
	 * Jump into C domain. _PrepC zeroes BSS, copies rw data into RAM,
	 * and then enters kernel z_cstart
	 */
	call _PrepC
8000109c:	fd9ff0ef          	jal	ra,80001074 <_PrepC>

800010a0 <z_thread_entry_wrapper>:
	 * in registers a0, a1, a2 and a3. These registers are used as arguments
	 * to function z_thread_entry. Hence, just call z_thread_entry with
	 * return address set to 0 to indicate a non-returning function call.
	 */

	jal x0, z_thread_entry
800010a0:	1110006f          	j	800019b0 <z_thread_entry>

800010a4 <z_new_thread>:

void z_new_thread(struct k_thread *thread, k_thread_stack_t *stack,
		 size_t stack_size, k_thread_entry_t thread_func,
		 void *arg1, void *arg2, void *arg3,
		 int priority, unsigned int options)
{
800010a4:	fd010113          	addi	sp,sp,-48
800010a8:	02812423          	sw	s0,40(sp)
800010ac:	02912223          	sw	s1,36(sp)
800010b0:	03212023          	sw	s2,32(sp)
800010b4:	01312e23          	sw	s3,28(sp)
800010b8:	01412c23          	sw	s4,24(sp)
800010bc:	01512a23          	sw	s5,20(sp)
800010c0:	01612823          	sw	s6,16(sp)
800010c4:	01712623          	sw	s7,12(sp)
800010c8:	00078b13          	mv	s6,a5
800010cc:	02112623          	sw	ra,44(sp)
800010d0:	01812423          	sw	s8,8(sp)
	char *stack_memory = Z_THREAD_STACK_BUFFER(stack);
	Z_ASSERT_VALID_PRIO(priority, thread_func);
800010d4:	00f00793          	li	a5,15
{
800010d8:	00050493          	mv	s1,a0
800010dc:	00058413          	mv	s0,a1
800010e0:	00060993          	mv	s3,a2
800010e4:	00068a13          	mv	s4,a3
800010e8:	00070b93          	mv	s7,a4
800010ec:	00080a93          	mv	s5,a6
800010f0:	00088913          	mv	s2,a7
	Z_ASSERT_VALID_PRIO(priority, thread_func);
800010f4:	08f89a63          	bne	a7,a5,80001188 <z_new_thread+0xe4>
800010f8:	800037b7          	lui	a5,0x80003
800010fc:	ba878793          	addi	a5,a5,-1112 # 80002ba8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80002ba9>
80001100:	08f69a63          	bne	a3,a5,80001194 <z_new_thread+0xf0>
	 * if it isn't.
	 */
	*((u32_t *)pStack) = STACK_SENTINEL;
#endif /* CONFIG_STACK_SENTINEL */
	/* Initialize various struct k_thread members */
	z_init_thread_base(&thread->base, prio, _THREAD_PRESTART, options);
80001104:	03012683          	lw	a3,48(sp)
80001108:	00090593          	mv	a1,s2
8000110c:	00048513          	mv	a0,s1
80001110:	00400613          	li	a2,4
80001114:	269030ef          	jal	ra,80004b7c <z_init_thread_base>

	z_new_thread_init(thread, stack_memory, stack_size, priority, options);

	/* Initial stack frame for thread */
	stack_init = (struct __esf *)
		STACK_ROUND_DOWN(stack_memory +
80001118:	fb098593          	addi	a1,s3,-80
8000111c:	00b405b3          	add	a1,s0,a1
	 *    restored following the MSTATUS value set within the thread stack;
	 * 2) the core will jump to z_thread_entry_wrapper, as the program
	 *    counter will be restored following the MEPC value set within the
	 *    thread stack.
	 */
	stack_init->mstatus = SOC_MSTATUS_DEF_RESTORE;
80001120:	000027b7          	lui	a5,0x2

	/* static threads overwrite it afterwards with real value */
	thread->init_data = NULL;
80001124:	0404ae23          	sw	zero,92(s1)
	thread->fn_abort = NULL;
80001128:	0604a023          	sw	zero,96(s1)
		STACK_ROUND_DOWN(stack_memory +
8000112c:	ff05f593          	andi	a1,a1,-16
	stack_init->mstatus = SOC_MSTATUS_DEF_RESTORE;
80001130:	88078793          	addi	a5,a5,-1920 # 1880 <CONFIG_ISR_STACK_SIZE+0x1080>
80001134:	04f5a623          	sw	a5,76(a1)
	stack_init->mepc = (u32_t)z_thread_entry_wrapper;
80001138:	800017b7          	lui	a5,0x80001

	thread->callee_saved.sp = (u32_t)stack_init;
}
8000113c:	02c12083          	lw	ra,44(sp)
80001140:	02812403          	lw	s0,40(sp)
	stack_init->mepc = (u32_t)z_thread_entry_wrapper;
80001144:	0a078793          	addi	a5,a5,160 # 800010a0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800010a1>
	stack_init->a0 = (u32_t)thread_func;
80001148:	0345a423          	sw	s4,40(a1)
	stack_init->a1 = (u32_t)arg1;
8000114c:	0375a623          	sw	s7,44(a1)
	stack_init->a2 = (u32_t)arg2;
80001150:	0365a823          	sw	s6,48(a1)
	stack_init->a3 = (u32_t)arg3;
80001154:	0355aa23          	sw	s5,52(a1)
	stack_init->mepc = (u32_t)z_thread_entry_wrapper;
80001158:	04f5a423          	sw	a5,72(a1)
	thread->callee_saved.sp = (u32_t)stack_init;
8000115c:	02b4a423          	sw	a1,40(s1)
}
80001160:	02012903          	lw	s2,32(sp)
80001164:	02412483          	lw	s1,36(sp)
80001168:	01c12983          	lw	s3,28(sp)
8000116c:	01812a03          	lw	s4,24(sp)
80001170:	01412a83          	lw	s5,20(sp)
80001174:	01012b03          	lw	s6,16(sp)
80001178:	00c12b83          	lw	s7,12(sp)
8000117c:	00812c03          	lw	s8,8(sp)
80001180:	03010113          	addi	sp,sp,48
80001184:	00008067          	ret
	Z_ASSERT_VALID_PRIO(priority, thread_func);
80001188:	01088693          	addi	a3,a7,16
8000118c:	01e00793          	li	a5,30
80001190:	f6d7fae3          	bgeu	a5,a3,80001104 <z_new_thread+0x60>
80001194:	80006c37          	lui	s8,0x80006
80001198:	800065b7          	lui	a1,0x80006
8000119c:	80006537          	lui	a0,0x80006
800011a0:	730c0613          	addi	a2,s8,1840 # 80006730 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006731>
800011a4:	01800693          	li	a3,24
800011a8:	75058593          	addi	a1,a1,1872 # 80006750 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006751>
800011ac:	7dc50513          	addi	a0,a0,2012 # 800067dc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800067dd>
800011b0:	6c1000ef          	jal	ra,80002070 <printk>
800011b4:	80006537          	lui	a0,0x80006
800011b8:	00090593          	mv	a1,s2
800011bc:	ff000693          	li	a3,-16
800011c0:	00e00613          	li	a2,14
800011c4:	7fc50513          	addi	a0,a0,2044 # 800067fc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800067fd>
800011c8:	6a9000ef          	jal	ra,80002070 <printk>
800011cc:	01800593          	li	a1,24
800011d0:	730c0513          	addi	a0,s8,1840
800011d4:	6d9000ef          	jal	ra,800020ac <assert_post_action>
800011d8:	f2dff06f          	j	80001104 <z_new_thread+0x60>

800011dc <get_bit_ptr>:
 * within that word as the return value
 */
static int get_bit_ptr(struct sys_mem_pool_base *p, int level, int bn,
		       u32_t **word)
{
	u32_t *bitarray = level <= p->max_inline_level ?
800011dc:	00159793          	slli	a5,a1,0x1
800011e0:	00b787b3          	add	a5,a5,a1
800011e4:	00279713          	slli	a4,a5,0x2
800011e8:	00c52783          	lw	a5,12(a0)
800011ec:	00e787b3          	add	a5,a5,a4
800011f0:	00b50703          	lb	a4,11(a0)
		&p->levels[level].bits : p->levels[level].bits_p;
800011f4:	00b75463          	bge	a4,a1,800011fc <get_bit_ptr+0x20>
800011f8:	0007a783          	lw	a5,0(a5)

	*word = &bitarray[bn / 32];
800011fc:	41f65713          	srai	a4,a2,0x1f
80001200:	01f77713          	andi	a4,a4,31
80001204:	00c70733          	add	a4,a4,a2
80001208:	40575713          	srai	a4,a4,0x5
8000120c:	00271713          	slli	a4,a4,0x2
80001210:	00e787b3          	add	a5,a5,a4
80001214:	00f6a023          	sw	a5,0(a3)

	return bn & 0x1f;
}
80001218:	01f67513          	andi	a0,a2,31
8000121c:	00008067          	ret

80001220 <set_free_bit>:

static void set_free_bit(struct sys_mem_pool_base *p, int level, int bn)
{
80001220:	fe010113          	addi	sp,sp,-32
	u32_t *word;
	int bit = get_bit_ptr(p, level, bn, &word);
80001224:	00c10693          	addi	a3,sp,12
{
80001228:	00112e23          	sw	ra,28(sp)
	int bit = get_bit_ptr(p, level, bn, &word);
8000122c:	fb1ff0ef          	jal	ra,800011dc <get_bit_ptr>

	*word |= (1<<bit);
80001230:	00c12703          	lw	a4,12(sp)
80001234:	00100793          	li	a5,1
80001238:	00a79533          	sll	a0,a5,a0
8000123c:	00072783          	lw	a5,0(a4)
}
80001240:	01c12083          	lw	ra,28(sp)
	*word |= (1<<bit);
80001244:	00a7e7b3          	or	a5,a5,a0
80001248:	00f72023          	sw	a5,0(a4)
}
8000124c:	02010113          	addi	sp,sp,32
80001250:	00008067          	ret

80001254 <clear_free_bit>:

static void clear_free_bit(struct sys_mem_pool_base *p, int level, int bn)
{
80001254:	fe010113          	addi	sp,sp,-32
	u32_t *word;
	int bit = get_bit_ptr(p, level, bn, &word);
80001258:	00c10693          	addi	a3,sp,12
{
8000125c:	00112e23          	sw	ra,28(sp)
	int bit = get_bit_ptr(p, level, bn, &word);
80001260:	f7dff0ef          	jal	ra,800011dc <get_bit_ptr>

	*word &= ~(1<<bit);
80001264:	00c12703          	lw	a4,12(sp)
80001268:	00100793          	li	a5,1
8000126c:	00a79533          	sll	a0,a5,a0
80001270:	00072783          	lw	a5,0(a4)
}
80001274:	01c12083          	lw	ra,28(sp)
	*word &= ~(1<<bit);
80001278:	fff54513          	not	a0,a0
8000127c:	00a7f533          	and	a0,a5,a0
80001280:	00a72023          	sw	a0,0(a4)
}
80001284:	02010113          	addi	sp,sp,32
80001288:	00008067          	ret

8000128c <z_sys_mem_pool_base_init>:
{
	return ((u8_t *)block + bsz - 1 - (u8_t *)p->buf) < buf_size(p);
}

void z_sys_mem_pool_base_init(struct sys_mem_pool_base *p)
{
8000128c:	fe010113          	addi	sp,sp,-32
80001290:	00912a23          	sw	s1,20(sp)
	int i;
	size_t buflen = p->n_max * p->max_sz, sz = p->max_sz;
80001294:	00452483          	lw	s1,4(a0)
{
80001298:	00812c23          	sw	s0,24(sp)
8000129c:	00050413          	mv	s0,a0
	size_t buflen = p->n_max * p->max_sz, sz = p->max_sz;
800012a0:	00855503          	lhu	a0,8(a0)
800012a4:	00048593          	mv	a1,s1
{
800012a8:	01212823          	sw	s2,16(sp)
800012ac:	01312623          	sw	s3,12(sp)
800012b0:	01412423          	sw	s4,8(sp)
800012b4:	01512223          	sw	s5,4(sp)
800012b8:	01612023          	sw	s6,0(sp)
800012bc:	00112e23          	sw	ra,28(sp)
	size_t buflen = p->n_max * p->max_sz, sz = p->max_sz;
800012c0:	dc4ff0ef          	jal	ra,80000884 <__mulsi3>
	u32_t *bits = (u32_t *)((u8_t *)p->buf + buflen);
800012c4:	00042983          	lw	s3,0(s0)

	p->max_inline_level = -1;

	for (i = 0; i < p->n_levels; i++) {
800012c8:	00a44a83          	lbu	s5,10(s0)
	p->max_inline_level = -1;
800012cc:	fff00793          	li	a5,-1
	size_t buflen = p->n_max * p->max_sz, sz = p->max_sz;
800012d0:	00050a13          	mv	s4,a0
	u32_t *bits = (u32_t *)((u8_t *)p->buf + buflen);
800012d4:	00a989b3          	add	s3,s3,a0
	p->max_inline_level = -1;
800012d8:	00f405a3          	sb	a5,11(s0)
	for (i = 0; i < p->n_levels; i++) {
800012dc:	00000913          	li	s2,0
		int nblocks = buflen / sz;

		sys_dlist_init(&p->levels[i].free_list);

		if (nblocks < 32) {
800012e0:	01f00b13          	li	s6,31
	for (i = 0; i < p->n_levels; i++) {
800012e4:	03594c63          	blt	s2,s5,8000131c <z_sys_mem_pool_base_init+0x90>
		}

		sz = _ALIGN4(sz / 4);
	}

	for (i = 0; i < p->n_max; i++) {
800012e8:	00000493          	li	s1,0
800012ec:	00845783          	lhu	a5,8(s0)
800012f0:	08f4cc63          	blt	s1,a5,80001388 <z_sys_mem_pool_base_init+0xfc>
		void *block = block_ptr(p, p->max_sz, i);

		sys_dlist_append(&p->levels[0].free_list, block);
		set_free_bit(p, 0, i);
	}
}
800012f4:	01c12083          	lw	ra,28(sp)
800012f8:	01812403          	lw	s0,24(sp)
800012fc:	01412483          	lw	s1,20(sp)
80001300:	01012903          	lw	s2,16(sp)
80001304:	00c12983          	lw	s3,12(sp)
80001308:	00812a03          	lw	s4,8(sp)
8000130c:	00412a83          	lw	s5,4(sp)
80001310:	00012b03          	lw	s6,0(sp)
80001314:	02010113          	addi	sp,sp,32
80001318:	00008067          	ret
		int nblocks = buflen / sz;
8000131c:	00048593          	mv	a1,s1
80001320:	000a0513          	mv	a0,s4
80001324:	e1cff0ef          	jal	ra,80000940 <__udivsi3>
		sys_dlist_init(&p->levels[i].free_list);
80001328:	00191713          	slli	a4,s2,0x1
8000132c:	01270733          	add	a4,a4,s2
80001330:	00271793          	slli	a5,a4,0x2
80001334:	00c42703          	lw	a4,12(s0)
80001338:	00f70733          	add	a4,a4,a5
8000133c:	00470793          	addi	a5,a4,4
 * @return N/A
 */

static inline void sys_dlist_init(sys_dlist_t *list)
{
	list->head = (sys_dnode_t *)list;
80001340:	00f72223          	sw	a5,4(a4)
	list->tail = (sys_dnode_t *)list;
80001344:	00f72423          	sw	a5,8(a4)
		if (nblocks < 32) {
80001348:	00ab4e63          	blt	s6,a0,80001364 <z_sys_mem_pool_base_init+0xd8>
			p->max_inline_level = i;
8000134c:	012405a3          	sb	s2,11(s0)
		sz = _ALIGN4(sz / 4);
80001350:	0024d493          	srli	s1,s1,0x2
80001354:	00348493          	addi	s1,s1,3
80001358:	ffc4f493          	andi	s1,s1,-4
	for (i = 0; i < p->n_levels; i++) {
8000135c:	00190913          	addi	s2,s2,1
80001360:	f85ff06f          	j	800012e4 <z_sys_mem_pool_base_init+0x58>
			bits += (nblocks + 31)/32;
80001364:	01f50513          	addi	a0,a0,31
80001368:	41f55793          	srai	a5,a0,0x1f
8000136c:	01f7f793          	andi	a5,a5,31
80001370:	00a787b3          	add	a5,a5,a0
80001374:	4057d793          	srai	a5,a5,0x5
80001378:	00279793          	slli	a5,a5,0x2
			p->levels[i].bits_p = bits;
8000137c:	01372023          	sw	s3,0(a4)
			bits += (nblocks + 31)/32;
80001380:	00f989b3          	add	s3,s3,a5
80001384:	fcdff06f          	j	80001350 <z_sys_mem_pool_base_init+0xc4>
	return (u8_t *)p->buf + lsz * block;
80001388:	00442583          	lw	a1,4(s0)
8000138c:	00048513          	mv	a0,s1
80001390:	cf4ff0ef          	jal	ra,80000884 <__mulsi3>
80001394:	00042783          	lw	a5,0(s0)
		set_free_bit(p, 0, i);
80001398:	00048613          	mv	a2,s1
8000139c:	00000593          	li	a1,0
	return (u8_t *)p->buf + lsz * block;
800013a0:	00a78533          	add	a0,a5,a0
		sys_dlist_append(&p->levels[0].free_list, block);
800013a4:	00c42783          	lw	a5,12(s0)
	for (i = 0; i < p->n_max; i++) {
800013a8:	00148493          	addi	s1,s1,1
		sys_dlist_append(&p->levels[0].free_list, block);
800013ac:	00478713          	addi	a4,a5,4
 * @return N/A
 */

static inline void sys_dlist_append(sys_dlist_t *list, sys_dnode_t *node)
{
	node->next = list;
800013b0:	00e52023          	sw	a4,0(a0)
	node->prev = list->tail;
800013b4:	0087a703          	lw	a4,8(a5)
800013b8:	00e52223          	sw	a4,4(a0)

	list->tail->next = node;
800013bc:	0087a703          	lw	a4,8(a5)
800013c0:	00a72023          	sw	a0,0(a4)
	list->tail = node;
800013c4:	00a7a423          	sw	a0,8(a5)
		set_free_bit(p, 0, i);
800013c8:	00040513          	mv	a0,s0
800013cc:	e55ff0ef          	jal	ra,80001220 <set_free_bit>
800013d0:	f1dff06f          	j	800012ec <z_sys_mem_pool_base_init+0x60>

800013d4 <z_sys_mem_pool_block_alloc>:
	return block;
}

int z_sys_mem_pool_block_alloc(struct sys_mem_pool_base *p, size_t size,
			      u32_t *level_p, u32_t *block_p, void **data_p)
{
800013d4:	fa010113          	addi	sp,sp,-96
800013d8:	04812c23          	sw	s0,88(sp)
800013dc:	05512223          	sw	s5,68(sp)
800013e0:	04112e23          	sw	ra,92(sp)
800013e4:	04912a23          	sw	s1,84(sp)
800013e8:	05212823          	sw	s2,80(sp)
800013ec:	05312623          	sw	s3,76(sp)
800013f0:	05412423          	sw	s4,72(sp)
800013f4:	05612023          	sw	s6,64(sp)
800013f8:	03712e23          	sw	s7,60(sp)
800013fc:	03812c23          	sw	s8,56(sp)
80001400:	03912a23          	sw	s9,52(sp)
80001404:	03a12823          	sw	s10,48(sp)
80001408:	03b12623          	sw	s11,44(sp)
8000140c:	06010413          	addi	s0,sp,96
	int i, from_l, alloc_l = -1;
	unsigned int key;
	void *data = NULL;
	size_t lsizes[LVL_ARRAY_SZ(p->n_levels)];
80001410:	00a54e03          	lbu	t3,10(a0)
	 * from which we can split an allocation if needed.  Along the
	 * way, we populate an array of sizes for each level so we
	 * don't need to waste RAM storing it.
	 */
	lsizes[0] = _ALIGN4(p->max_sz);
	for (i = 0; i < p->n_levels; i++) {
80001414:	00000893          	li	a7,0
	size_t lsizes[LVL_ARRAY_SZ(p->n_levels)];
80001418:	002e1793          	slli	a5,t3,0x2
8000141c:	00f78793          	addi	a5,a5,15
80001420:	7f07f793          	andi	a5,a5,2032
80001424:	40f10133          	sub	sp,sp,a5
	lsizes[0] = _ALIGN4(p->max_sz);
80001428:	00452783          	lw	a5,4(a0)
	size_t lsizes[LVL_ARRAY_SZ(p->n_levels)];
8000142c:	00010a93          	mv	s5,sp
	lsizes[0] = _ALIGN4(p->max_sz);
80001430:	000a8313          	mv	t1,s5
80001434:	00378793          	addi	a5,a5,3
80001438:	ffc7f793          	andi	a5,a5,-4
8000143c:	00faa023          	sw	a5,0(s5)
	for (i = 0; i < p->n_levels; i++) {
80001440:	fff88b13          	addi	s6,a7,-1
80001444:	03c8d463          	bge	a7,t3,8000146c <z_sys_mem_pool_block_alloc+0x98>
		if (i > 0) {
80001448:	00088c63          	beqz	a7,80001460 <z_sys_mem_pool_block_alloc+0x8c>
			lsizes[i] = _ALIGN4(lsizes[i-1] / 4);
8000144c:	ffc32803          	lw	a6,-4(t1)
80001450:	00285813          	srli	a6,a6,0x2
80001454:	00380813          	addi	a6,a6,3
80001458:	ffc87813          	andi	a6,a6,-4
8000145c:	01032023          	sw	a6,0(t1)
		}

		if (lsizes[i] < size) {
80001460:	00430313          	addi	t1,t1,4
80001464:	ffc32803          	lw	a6,-4(t1)
80001468:	04b87a63          	bgeu	a6,a1,800014bc <z_sys_mem_pool_block_alloc+0xe8>
		}

		alloc_l = i;
	}

	if (alloc_l < 0) {
8000146c:	fff00593          	li	a1,-1
80001470:	04bb1a63          	bne	s6,a1,800014c4 <z_sys_mem_pool_block_alloc+0xf0>
		*data_p = NULL;
80001474:	00072023          	sw	zero,0(a4)
		return -ENOMEM;
80001478:	ff400513          	li	a0,-12

	*level_p = alloc_l;
	*block_p = block_num(p, data, lsizes[alloc_l]);

	return 0;
}
8000147c:	fa040113          	addi	sp,s0,-96
80001480:	05c12083          	lw	ra,92(sp)
80001484:	05812403          	lw	s0,88(sp)
80001488:	05412483          	lw	s1,84(sp)
8000148c:	05012903          	lw	s2,80(sp)
80001490:	04c12983          	lw	s3,76(sp)
80001494:	04812a03          	lw	s4,72(sp)
80001498:	04412a83          	lw	s5,68(sp)
8000149c:	04012b03          	lw	s6,64(sp)
800014a0:	03c12b83          	lw	s7,60(sp)
800014a4:	03812c03          	lw	s8,56(sp)
800014a8:	03412c83          	lw	s9,52(sp)
800014ac:	03012d03          	lw	s10,48(sp)
800014b0:	02c12d83          	lw	s11,44(sp)
800014b4:	06010113          	addi	sp,sp,96
800014b8:	00008067          	ret
	for (i = 0; i < p->n_levels; i++) {
800014bc:	00188893          	addi	a7,a7,1
800014c0:	f81ff06f          	j	80001440 <z_sys_mem_pool_block_alloc+0x6c>
	if (p->flags & SYS_MEM_POOL_KERNEL) {
800014c4:	01054583          	lbu	a1,16(a0)
		return 0;
800014c8:	00000913          	li	s2,0
	if (p->flags & SYS_MEM_POOL_KERNEL) {
800014cc:	0015f593          	andi	a1,a1,1
800014d0:	00058863          	beqz	a1,800014e0 <z_sys_mem_pool_block_alloc+0x10c>
 */
static ALWAYS_INLINE unsigned int z_arch_irq_lock(void)
{
	unsigned int key, mstatus;

	__asm__ volatile ("csrrc %0, mstatus, %1"
800014d4:	00800913          	li	s2,8
800014d8:	30093973          	csrrc	s2,mstatus,s2
			  : "=r" (mstatus)
			  : "r" (SOC_MSTATUS_IEN)
			  : "memory");

	key = (mstatus & SOC_MSTATUS_IEN);
800014dc:	00897913          	andi	s2,s2,8
800014e0:	fae42a23          	sw	a4,-76(s0)
800014e4:	001b1713          	slli	a4,s6,0x1
800014e8:	fad42c23          	sw	a3,-72(s0)
800014ec:	01670733          	add	a4,a4,s6
800014f0:	00c52683          	lw	a3,12(a0)
800014f4:	00271713          	slli	a4,a4,0x2
800014f8:	00470713          	addi	a4,a4,4
800014fc:	00e68733          	add	a4,a3,a4
80001500:	fac42e23          	sw	a2,-68(s0)
80001504:	00050493          	mv	s1,a0
	block = sys_dlist_get(&p->levels[l].free_list);
80001508:	000b0a13          	mv	s4,s6
	for (i = alloc_l; i >= 0; i--) {
8000150c:	fff00693          	li	a3,-1
	return list->head == list;
80001510:	00072983          	lw	s3,0(a4)

static inline sys_dnode_t *sys_dlist_get(sys_dlist_t *list)
{
	sys_dnode_t *node = NULL;

	if (!sys_dlist_is_empty(list)) {
80001514:	19370663          	beq	a4,s3,800016a0 <z_sys_mem_pool_block_alloc+0x2cc>
		data = block_alloc(p, i, lsizes[i]);
80001518:	002a1713          	slli	a4,s4,0x2
	node->prev->next = node->next;
8000151c:	0049a683          	lw	a3,4(s3)
80001520:	00ea8cb3          	add	s9,s5,a4
80001524:	0009a703          	lw	a4,0(s3)
	return ((u8_t *)block - (u8_t *)p->buf) / sz;
80001528:	000ca583          	lw	a1,0(s9)
	__asm__ volatile ("csrrc %0, mstatus, %1"
8000152c:	00800d13          	li	s10,8
80001530:	00e6a023          	sw	a4,0(a3)
	node->next->prev = node->prev;
80001534:	00d72223          	sw	a3,4(a4)
	node->next = NULL;
80001538:	0009a023          	sw	zero,0(s3)
	node->prev = NULL;
8000153c:	0009a223          	sw	zero,4(s3)
80001540:	0004a503          	lw	a0,0(s1)
80001544:	40a98533          	sub	a0,s3,a0
80001548:	bf0ff0ef          	jal	ra,80000938 <__divsi3>
		clear_free_bit(p, l, block_num(p, block, lsz));
8000154c:	00050613          	mv	a2,a0
80001550:	000a0593          	mv	a1,s4
80001554:	00048513          	mv	a0,s1
80001558:	cfdff0ef          	jal	ra,80001254 <clear_free_bit>
		if (data != NULL) {
8000155c:	001a0a13          	addi	s4,s4,1
			for (from_l = i; from_l < alloc_l; from_l++) {
80001560:	fffa0693          	addi	a3,s4,-1
80001564:	0566ca63          	blt	a3,s6,800015b8 <z_sys_mem_pool_block_alloc+0x1e4>
	if (p->flags & SYS_MEM_POOL_KERNEL) {
80001568:	0104c703          	lbu	a4,16(s1)
8000156c:	00177713          	andi	a4,a4,1
80001570:	00070463          	beqz	a4,80001578 <z_sys_mem_pool_block_alloc+0x1a4>
 */
static ALWAYS_INLINE void z_arch_irq_unlock(unsigned int key)
{
	unsigned int mstatus;

	__asm__ volatile ("csrrs %0, mstatus, %1"
80001574:	30092973          	csrrs	s2,mstatus,s2
	*data_p = data;
80001578:	fb442783          	lw	a5,-76(s0)
		return -ENOMEM;
8000157c:	ff400513          	li	a0,-12
	*data_p = data;
80001580:	0137a023          	sw	s3,0(a5)
	if (data == NULL) {
80001584:	ee098ce3          	beqz	s3,8000147c <z_sys_mem_pool_block_alloc+0xa8>
	*level_p = alloc_l;
80001588:	fbc42783          	lw	a5,-68(s0)
	return ((u8_t *)block - (u8_t *)p->buf) / sz;
8000158c:	0004a503          	lw	a0,0(s1)
	*level_p = alloc_l;
80001590:	0167a023          	sw	s6,0(a5)
	*block_p = block_num(p, data, lsizes[alloc_l]);
80001594:	002b1793          	slli	a5,s6,0x2
80001598:	00fa8ab3          	add	s5,s5,a5
	return ((u8_t *)block - (u8_t *)p->buf) / sz;
8000159c:	000aa583          	lw	a1,0(s5)
800015a0:	40a98533          	sub	a0,s3,a0
800015a4:	b94ff0ef          	jal	ra,80000938 <__divsi3>
	*block_p = block_num(p, data, lsizes[alloc_l]);
800015a8:	fb842783          	lw	a5,-72(s0)
800015ac:	00a7a023          	sw	a0,0(a5)
	return 0;
800015b0:	00000513          	li	a0,0
800015b4:	ec9ff06f          	j	8000147c <z_sys_mem_pool_block_alloc+0xa8>
	return ((u8_t *)block - (u8_t *)p->buf) / sz;
800015b8:	0004a503          	lw	a0,0(s1)
800015bc:	000ca583          	lw	a1,0(s9)
	for (i = 1; i < 4; i++) {
800015c0:	00100b93          	li	s7,1
	return ((u8_t *)block - (u8_t *)p->buf) / sz;
800015c4:	40a98533          	sub	a0,s3,a0
800015c8:	b70ff0ef          	jal	ra,80000938 <__divsi3>
800015cc:	001a1893          	slli	a7,s4,0x1
800015d0:	014888b3          	add	a7,a7,s4
		int lbn = 4*bn + i;
800015d4:	00251d93          	slli	s11,a0,0x2
800015d8:	00289893          	slli	a7,a7,0x2
		int lsz = lsizes[l + 1];
800015dc:	004ca683          	lw	a3,4(s9)
		void *block2 = (lsz * i) + (char *)block;
800015e0:	000b8593          	mv	a1,s7
800015e4:	fb142623          	sw	a7,-84(s0)
800015e8:	00068513          	mv	a0,a3
800015ec:	fad42823          	sw	a3,-80(s0)
800015f0:	a94ff0ef          	jal	ra,80000884 <__mulsi3>
800015f4:	00a98c33          	add	s8,s3,a0
		set_free_bit(p, l + 1, lbn);
800015f8:	01bb8633          	add	a2,s7,s11
800015fc:	000a0593          	mv	a1,s4
80001600:	00048513          	mv	a0,s1
80001604:	c1dff0ef          	jal	ra,80001220 <set_free_bit>
	return ((u8_t *)block + bsz - 1 - (u8_t *)p->buf) < buf_size(p);
80001608:	fb042683          	lw	a3,-80(s0)
8000160c:	0004a603          	lw	a2,0(s1)
	return p->n_max * p->max_sz;
80001610:	0044a583          	lw	a1,4(s1)
	return ((u8_t *)block + bsz - 1 - (u8_t *)p->buf) < buf_size(p);
80001614:	fff68693          	addi	a3,a3,-1
	return p->n_max * p->max_sz;
80001618:	0084d503          	lhu	a0,8(s1)
	return ((u8_t *)block + bsz - 1 - (u8_t *)p->buf) < buf_size(p);
8000161c:	00dc06b3          	add	a3,s8,a3
80001620:	40c686b3          	sub	a3,a3,a2
80001624:	fad42823          	sw	a3,-80(s0)
	return p->n_max * p->max_sz;
80001628:	a5cff0ef          	jal	ra,80000884 <__mulsi3>
		if (block_fits(p, block2, lsz)) {
8000162c:	fb042683          	lw	a3,-80(s0)
80001630:	fac42883          	lw	a7,-84(s0)
80001634:	02a6f463          	bgeu	a3,a0,8000165c <z_sys_mem_pool_block_alloc+0x288>
			sys_dlist_append(&p->levels[l + 1].free_list, block2);
80001638:	00c4a683          	lw	a3,12(s1)
8000163c:	011686b3          	add	a3,a3,a7
80001640:	00468613          	addi	a2,a3,4
	node->next = list;
80001644:	00cc2023          	sw	a2,0(s8)
	node->prev = list->tail;
80001648:	0086a603          	lw	a2,8(a3)
8000164c:	00cc2223          	sw	a2,4(s8)
	list->tail->next = node;
80001650:	0086a603          	lw	a2,8(a3)
80001654:	01862023          	sw	s8,0(a2)
	list->tail = node;
80001658:	0186a423          	sw	s8,8(a3)
	for (i = 1; i < 4; i++) {
8000165c:	001b8b93          	addi	s7,s7,1
80001660:	00400793          	li	a5,4
80001664:	f6fb9ce3          	bne	s7,a5,800015dc <z_sys_mem_pool_block_alloc+0x208>
	if (p->flags & SYS_MEM_POOL_KERNEL) {
80001668:	0104c683          	lbu	a3,16(s1)
8000166c:	0016f693          	andi	a3,a3,1
80001670:	00069a63          	bnez	a3,80001684 <z_sys_mem_pool_block_alloc+0x2b0>
		return 0;
80001674:	00000913          	li	s2,0
80001678:	001a0a13          	addi	s4,s4,1
8000167c:	004c8c93          	addi	s9,s9,4
80001680:	ee1ff06f          	j	80001560 <z_sys_mem_pool_block_alloc+0x18c>
80001684:	30092973          	csrrs	s2,mstatus,s2
	if (p->flags & SYS_MEM_POOL_KERNEL) {
80001688:	0104c683          	lbu	a3,16(s1)
8000168c:	0016f693          	andi	a3,a3,1
80001690:	fe0682e3          	beqz	a3,80001674 <z_sys_mem_pool_block_alloc+0x2a0>
	__asm__ volatile ("csrrc %0, mstatus, %1"
80001694:	300d3973          	csrrc	s2,mstatus,s10
	key = (mstatus & SOC_MSTATUS_IEN);
80001698:	00897913          	andi	s2,s2,8
8000169c:	fddff06f          	j	80001678 <z_sys_mem_pool_block_alloc+0x2a4>
	for (i = alloc_l; i >= 0; i--) {
800016a0:	fffa0a13          	addi	s4,s4,-1
800016a4:	ff498713          	addi	a4,s3,-12
800016a8:	e6da14e3          	bne	s4,a3,80001510 <z_sys_mem_pool_block_alloc+0x13c>
800016ac:	00000993          	li	s3,0
800016b0:	eb9ff06f          	j	80001568 <z_sys_mem_pool_block_alloc+0x194>

800016b4 <z_sys_mem_pool_block_free>:

void z_sys_mem_pool_block_free(struct sys_mem_pool_base *p, u32_t level,
			      u32_t block)
{
800016b4:	fa010113          	addi	sp,sp,-96
800016b8:	04812c23          	sw	s0,88(sp)
800016bc:	05412423          	sw	s4,72(sp)
800016c0:	03912a23          	sw	s9,52(sp)
800016c4:	04112e23          	sw	ra,92(sp)
800016c8:	04912a23          	sw	s1,84(sp)
800016cc:	05212823          	sw	s2,80(sp)
800016d0:	05312623          	sw	s3,76(sp)
800016d4:	05512223          	sw	s5,68(sp)
800016d8:	05612023          	sw	s6,64(sp)
800016dc:	03712e23          	sw	s7,60(sp)
800016e0:	03812c23          	sw	s8,56(sp)
800016e4:	03a12823          	sw	s10,48(sp)
800016e8:	03b12623          	sw	s11,44(sp)
800016ec:	06010413          	addi	s0,sp,96
	size_t lsizes[LVL_ARRAY_SZ(p->n_levels)];
800016f0:	00a54703          	lbu	a4,10(a0)
{
800016f4:	00050c93          	mv	s9,a0
	size_t lsizes[LVL_ARRAY_SZ(p->n_levels)];
800016f8:	00271713          	slli	a4,a4,0x2
800016fc:	00f70713          	addi	a4,a4,15
80001700:	7f077713          	andi	a4,a4,2032
80001704:	40e10133          	sub	sp,sp,a4
	 * to avoid having to store it in precious RAM bytes.
	 * Overhead here is somewhat higher because block_free()
	 * doesn't inherently need to traverse all the larger
	 * sublevels.
	 */
	lsizes[0] = _ALIGN4(p->max_sz);
80001708:	00452703          	lw	a4,4(a0)
	size_t lsizes[LVL_ARRAY_SZ(p->n_levels)];
8000170c:	00010a13          	mv	s4,sp
	lsizes[0] = _ALIGN4(p->max_sz);
80001710:	000a0693          	mv	a3,s4
80001714:	00370713          	addi	a4,a4,3
80001718:	ffc77713          	andi	a4,a4,-4
8000171c:	00ea2023          	sw	a4,0(s4)
	for (i = 1; i <= level; i++) {
80001720:	00100513          	li	a0,1
80001724:	00468693          	addi	a3,a3,4
80001728:	0ca5f063          	bgeu	a1,a0,800017e8 <z_sys_mem_pool_block_free+0x134>
	if (p->flags & SYS_MEM_POOL_KERNEL) {
8000172c:	010cc703          	lbu	a4,16(s9)
		lsizes[i] = _ALIGN4(lsizes[i-1] / 4);
	}

	block_free(p, level, lsizes, block);
80001730:	00058913          	mv	s2,a1
80001734:	00060993          	mv	s3,a2
	if (p->flags & SYS_MEM_POOL_KERNEL) {
80001738:	00177713          	andi	a4,a4,1
		return 0;
8000173c:	00000493          	li	s1,0
	if (p->flags & SYS_MEM_POOL_KERNEL) {
80001740:	00070863          	beqz	a4,80001750 <z_sys_mem_pool_block_free+0x9c>
	__asm__ volatile ("csrrc %0, mstatus, %1"
80001744:	00800493          	li	s1,8
80001748:	3004b4f3          	csrrc	s1,mstatus,s1
	key = (mstatus & SOC_MSTATUS_IEN);
8000174c:	0084f493          	andi	s1,s1,8
		__ASSERT(block_fits(p, block, lsz), "");
80001750:	80007b37          	lui	s6,0x80007
	while (level >= 0) {
80001754:	0a095863          	bgez	s2,80001804 <z_sys_mem_pool_block_free+0x150>
	__ASSERT(0, "out of levels");
80001758:	800074b7          	lui	s1,0x80007
8000175c:	800075b7          	lui	a1,0x80007
80001760:	80006537          	lui	a0,0x80006
80001764:	83048613          	addi	a2,s1,-2000 # 80006830 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006831>
80001768:	0c000693          	li	a3,192
8000176c:	89858593          	addi	a1,a1,-1896 # 80006898 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006899>
80001770:	7dc50513          	addi	a0,a0,2012 # 800067dc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800067dd>
80001774:	0fd000ef          	jal	ra,80002070 <printk>
80001778:	80007537          	lui	a0,0x80007
8000177c:	86450513          	addi	a0,a0,-1948 # 80006864 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006865>
80001780:	0f1000ef          	jal	ra,80002070 <printk>
80001784:	83048513          	addi	a0,s1,-2000
80001788:	0c000593          	li	a1,192
8000178c:	121000ef          	jal	ra,800020ac <assert_post_action>
	return -1;
80001790:	fff00493          	li	s1,-1
	if (p->flags & SYS_MEM_POOL_KERNEL) {
80001794:	010cc783          	lbu	a5,16(s9)
80001798:	0017f793          	andi	a5,a5,1
8000179c:	00078663          	beqz	a5,800017a8 <z_sys_mem_pool_block_free+0xf4>
			  : "=r" (mstatus)
			  : "r" (key & SOC_MSTATUS_IEN)
800017a0:	0084f493          	andi	s1,s1,8
	__asm__ volatile ("csrrs %0, mstatus, %1"
800017a4:	3004a4f3          	csrrs	s1,mstatus,s1
}
800017a8:	fa040113          	addi	sp,s0,-96
800017ac:	05c12083          	lw	ra,92(sp)
800017b0:	05812403          	lw	s0,88(sp)
800017b4:	05412483          	lw	s1,84(sp)
800017b8:	05012903          	lw	s2,80(sp)
800017bc:	04c12983          	lw	s3,76(sp)
800017c0:	04812a03          	lw	s4,72(sp)
800017c4:	04412a83          	lw	s5,68(sp)
800017c8:	04012b03          	lw	s6,64(sp)
800017cc:	03c12b83          	lw	s7,60(sp)
800017d0:	03812c03          	lw	s8,56(sp)
800017d4:	03412c83          	lw	s9,52(sp)
800017d8:	03012d03          	lw	s10,48(sp)
800017dc:	02c12d83          	lw	s11,44(sp)
800017e0:	06010113          	addi	sp,sp,96
800017e4:	00008067          	ret
		lsizes[i] = _ALIGN4(lsizes[i-1] / 4);
800017e8:	ffc6a703          	lw	a4,-4(a3)
	for (i = 1; i <= level; i++) {
800017ec:	00150513          	addi	a0,a0,1
		lsizes[i] = _ALIGN4(lsizes[i-1] / 4);
800017f0:	00275713          	srli	a4,a4,0x2
800017f4:	00370713          	addi	a4,a4,3
800017f8:	ffc77713          	andi	a4,a4,-4
800017fc:	00e6a023          	sw	a4,0(a3)
80001800:	f25ff06f          	j	80001724 <z_sys_mem_pool_block_free+0x70>
		int i, lsz = lsizes[level];
80001804:	00291713          	slli	a4,s2,0x2
80001808:	00ea0733          	add	a4,s4,a4
8000180c:	00072a83          	lw	s5,0(a4)
		void *block = block_ptr(p, lsz, bn);
80001810:	000cac03          	lw	s8,0(s9)
	return (u8_t *)p->buf + lsz * block;
80001814:	00098513          	mv	a0,s3
80001818:	000a8593          	mv	a1,s5
8000181c:	868ff0ef          	jal	ra,80000884 <__mulsi3>
	return ((u8_t *)block + bsz - 1 - (u8_t *)p->buf) < buf_size(p);
80001820:	fffa8b93          	addi	s7,s5,-1
80001824:	01750d33          	add	s10,a0,s7
80001828:	00ac0c33          	add	s8,s8,a0
	return p->n_max * p->max_sz;
8000182c:	004ca583          	lw	a1,4(s9)
80001830:	008cd503          	lhu	a0,8(s9)
80001834:	850ff0ef          	jal	ra,80000884 <__mulsi3>
		__ASSERT(block_fits(p, block, lsz), "");
80001838:	02ad6c63          	bltu	s10,a0,80001870 <z_sys_mem_pool_block_free+0x1bc>
8000183c:	800077b7          	lui	a5,0x80007
80001840:	84478593          	addi	a1,a5,-1980 # 80006844 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006845>
80001844:	800067b7          	lui	a5,0x80006
80001848:	7dc78513          	addi	a0,a5,2012 # 800067dc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800067dd>
8000184c:	0a400693          	li	a3,164
80001850:	830b0613          	addi	a2,s6,-2000 # 80006830 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006831>
80001854:	01d000ef          	jal	ra,80002070 <printk>
80001858:	800077b7          	lui	a5,0x80007
8000185c:	86078513          	addi	a0,a5,-1952 # 80006860 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006861>
80001860:	011000ef          	jal	ra,80002070 <printk>
80001864:	0a400593          	li	a1,164
80001868:	830b0513          	addi	a0,s6,-2000
8000186c:	041000ef          	jal	ra,800020ac <assert_post_action>
		set_free_bit(p, level, bn);
80001870:	00098613          	mv	a2,s3
80001874:	00090593          	mv	a1,s2
80001878:	000c8513          	mv	a0,s9
8000187c:	9a5ff0ef          	jal	ra,80001220 <set_free_bit>
		sys_dlist_append(&p->levels[level].free_list, block);
80001880:	00191713          	slli	a4,s2,0x1
80001884:	01270733          	add	a4,a4,s2
80001888:	00271693          	slli	a3,a4,0x2
8000188c:	00cca703          	lw	a4,12(s9)
80001890:	00d70733          	add	a4,a4,a3
80001894:	00470693          	addi	a3,a4,4
	node->next = list;
80001898:	00dc2023          	sw	a3,0(s8)
	node->prev = list->tail;
8000189c:	00872683          	lw	a3,8(a4)
800018a0:	00dc2223          	sw	a3,4(s8)
	list->tail->next = node;
800018a4:	00872683          	lw	a3,8(a4)
800018a8:	0186a023          	sw	s8,0(a3)
	list->tail = node;
800018ac:	01872423          	sw	s8,8(a4)
	if (p->flags & SYS_MEM_POOL_KERNEL) {
800018b0:	010cc703          	lbu	a4,16(s9)
800018b4:	00177713          	andi	a4,a4,1
800018b8:	0c071c63          	bnez	a4,80001990 <z_sys_mem_pool_block_free+0x2dc>
		return 0;
800018bc:	00000493          	li	s1,0
		if (level == 0 || partner_bits(p, level, bn) != 0xf) {
800018c0:	ec090ae3          	beqz	s2,80001794 <z_sys_mem_pool_block_free+0xe0>
	int bit = get_bit_ptr(p, level, bn, &word);
800018c4:	fbc40693          	addi	a3,s0,-68
800018c8:	00098613          	mv	a2,s3
800018cc:	00090593          	mv	a1,s2
800018d0:	000c8513          	mv	a0,s9
800018d4:	909ff0ef          	jal	ra,800011dc <get_bit_ptr>
	return (*word >> (4*(bit / 4))) & 0xf;
800018d8:	fbc42683          	lw	a3,-68(s0)
800018dc:	41f55713          	srai	a4,a0,0x1f
800018e0:	00377713          	andi	a4,a4,3
800018e4:	00a70733          	add	a4,a4,a0
800018e8:	0006a503          	lw	a0,0(a3)
800018ec:	ffc77713          	andi	a4,a4,-4
		if (level == 0 || partner_bits(p, level, bn) != 0xf) {
800018f0:	00f00793          	li	a5,15
	return (*word >> (4*(bit / 4))) & 0xf;
800018f4:	00e55733          	srl	a4,a0,a4
800018f8:	00f77713          	andi	a4,a4,15
		if (level == 0 || partner_bits(p, level, bn) != 0xf) {
800018fc:	e8f71ce3          	bne	a4,a5,80001794 <z_sys_mem_pool_block_free+0xe0>
		for (i = 0; i < 4; i++) {
80001900:	00000d13          	li	s10,0
			int b = (bn & ~3) + i;
80001904:	ffc9fd93          	andi	s11,s3,-4
80001908:	01ad8633          	add	a2,s11,s10
	return (u8_t *)p->buf + lsz * block;
8000190c:	00060513          	mv	a0,a2
80001910:	000a8593          	mv	a1,s5
80001914:	fac42423          	sw	a2,-88(s0)
80001918:	f6dfe0ef          	jal	ra,80000884 <__mulsi3>
			if (block_fits(p, block_ptr(p, lsz, b), lsz)) {
8000191c:	01750733          	add	a4,a0,s7
	return (u8_t *)p->buf + lsz * block;
80001920:	00050c13          	mv	s8,a0
	return p->n_max * p->max_sz;
80001924:	004ca583          	lw	a1,4(s9)
80001928:	008cd503          	lhu	a0,8(s9)
			if (block_fits(p, block_ptr(p, lsz, b), lsz)) {
8000192c:	fae42623          	sw	a4,-84(s0)
	return p->n_max * p->max_sz;
80001930:	f55fe0ef          	jal	ra,80000884 <__mulsi3>
			if (block_fits(p, block_ptr(p, lsz, b), lsz)) {
80001934:	fac42703          	lw	a4,-84(s0)
80001938:	fa842603          	lw	a2,-88(s0)
8000193c:	02a77863          	bgeu	a4,a0,8000196c <z_sys_mem_pool_block_free+0x2b8>
				clear_free_bit(p, level, b);
80001940:	00090593          	mv	a1,s2
80001944:	000c8513          	mv	a0,s9
80001948:	90dff0ef          	jal	ra,80001254 <clear_free_bit>
	return (u8_t *)p->buf + lsz * block;
8000194c:	000ca703          	lw	a4,0(s9)
80001950:	01870c33          	add	s8,a4,s8
	node->prev->next = node->next;
80001954:	004c2603          	lw	a2,4(s8)
80001958:	000c2703          	lw	a4,0(s8)
8000195c:	00e62023          	sw	a4,0(a2)
	node->next->prev = node->prev;
80001960:	00c72223          	sw	a2,4(a4)
	node->next = NULL;
80001964:	000c2023          	sw	zero,0(s8)
	node->prev = NULL;
80001968:	000c2223          	sw	zero,4(s8)
		for (i = 0; i < 4; i++) {
8000196c:	001d0d13          	addi	s10,s10,1
80001970:	00400793          	li	a5,4
80001974:	f8fd1ae3          	bne	s10,a5,80001908 <z_sys_mem_pool_block_free+0x254>
		bn = bn / 4;
80001978:	41f9d613          	srai	a2,s3,0x1f
8000197c:	00367613          	andi	a2,a2,3
80001980:	013609b3          	add	s3,a2,s3
		level = level - 1;
80001984:	fff90913          	addi	s2,s2,-1
		bn = bn / 4;
80001988:	4029d993          	srai	s3,s3,0x2
8000198c:	dc9ff06f          	j	80001754 <z_sys_mem_pool_block_free+0xa0>
80001990:	3004a4f3          	csrrs	s1,mstatus,s1
	if (p->flags & SYS_MEM_POOL_KERNEL) {
80001994:	010cc703          	lbu	a4,16(s9)
80001998:	00177713          	andi	a4,a4,1
8000199c:	f20700e3          	beqz	a4,800018bc <z_sys_mem_pool_block_free+0x208>
	__asm__ volatile ("csrrc %0, mstatus, %1"
800019a0:	00800793          	li	a5,8
800019a4:	3007b4f3          	csrrc	s1,mstatus,a5
	key = (mstatus & SOC_MSTATUS_IEN);
800019a8:	0084f493          	andi	s1,s1,8
800019ac:	f15ff06f          	j	800018c0 <z_sys_mem_pool_block_free+0x20c>

800019b0 <z_thread_entry>:
 * This routine does not return, and is marked as such so the compiler won't
 * generate preamble code that is only used by functions that actually return.
 */
FUNC_NORETURN void z_thread_entry(k_thread_entry_t entry,
				 void *p1, void *p2, void *p3)
{
800019b0:	ff010113          	addi	sp,sp,-16
800019b4:	00050793          	mv	a5,a0
800019b8:	00058513          	mv	a0,a1
800019bc:	00060593          	mv	a1,a2
	entry(p1, p2, p3);
800019c0:	00068613          	mv	a2,a3
{
800019c4:	00112623          	sw	ra,12(sp)
	entry(p1, p2, p3);
800019c8:	000780e7          	jalr	a5
800019cc:	539020ef          	jal	ra,80004704 <z_impl_k_current_get>
K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_THREAD_ABORT, k_thread_abort, k_tid_t, thread)
800019d0:	550030ef          	jal	ra,80004f20 <z_impl_k_thread_abort>

800019d4 <z_work_q_main>:

#include <kernel.h>
#define WORKQUEUE_THREAD_NAME	"workqueue"

void z_work_q_main(void *work_q_ptr, void *p2, void *p3)
{
800019d4:	ff010113          	addi	sp,sp,-16
800019d8:	00912223          	sw	s1,4(sp)
800019dc:	00112623          	sw	ra,12(sp)
800019e0:	00812423          	sw	s0,8(sp)
800019e4:	01212023          	sw	s2,0(sp)
800019e8:	00050493          	mv	s1,a0
K_SYSCALL_DECLARE2(K_SYSCALL_K_QUEUE_GET, k_queue_get, void *, struct k_queue *, queue, s32_t, timeout)
800019ec:	fff00593          	li	a1,-1
800019f0:	00048513          	mv	a0,s1
800019f4:	634010ef          	jal	ra,80003028 <z_impl_k_queue_get>
800019f8:	00050413          	mv	s0,a0
	while (true) {
		struct k_work *work;
		k_work_handler_t handler;

		work = k_queue_get(&work_q->queue, K_FOREVER);
		if (work == NULL) {
800019fc:	fe0508e3          	beqz	a0,800019ec <z_work_q_main+0x18>
			continue;
		}

		handler = work->handler;
80001a00:	00452903          	lw	s2,4(a0)

K_SYSCALL_DECLARE2(K_SYSCALL_ATOMIC_XOR, atomic_xor, atomic_val_t, atomic_t *, target, atomic_val_t, value)

K_SYSCALL_DECLARE2(K_SYSCALL_ATOMIC_AND, atomic_and, atomic_val_t, atomic_t *, target, atomic_val_t, value)
80001a04:	ffe00593          	li	a1,-2
80001a08:	00850513          	addi	a0,a0,8
80001a0c:	0d4040ef          	jal	ra,80005ae0 <z_impl_atomic_and>
	return (old & mask) != 0;
80001a10:	00157513          	andi	a0,a0,1

		/* Reset pending state so it can be resubmitted by handler */
		if (atomic_test_and_clear_bit(work->flags,
80001a14:	00050663          	beqz	a0,80001a20 <z_work_q_main+0x4c>
					      K_WORK_STATE_PENDING)) {
			handler(work);
80001a18:	00040513          	mv	a0,s0
80001a1c:	000900e7          	jalr	s2
K_SYSCALL_DECLARE0_VOID(K_SYSCALL_K_YIELD, k_yield)
80001a20:	2ed020ef          	jal	ra,8000450c <z_impl_k_yield>
80001a24:	fc9ff06f          	j	800019ec <z_work_q_main+0x18>

80001a28 <z_arch_printk_char_out>:
{
	ARG_UNUSED(c);

	/* do nothing */
	return 0;
}
80001a28:	00000513          	li	a0,0
80001a2c:	00008067          	ret

80001a30 <print_err>:
{
	return _char_out;
}

static void print_err(out_func_t out, void *ctx)
{
80001a30:	ff010113          	addi	sp,sp,-16
80001a34:	00812423          	sw	s0,8(sp)
80001a38:	00050413          	mv	s0,a0
	out('E', ctx);
80001a3c:	04500513          	li	a0,69
{
80001a40:	00112623          	sw	ra,12(sp)
80001a44:	00912223          	sw	s1,4(sp)
80001a48:	00058493          	mv	s1,a1
	out('E', ctx);
80001a4c:	000400e7          	jalr	s0
	out('R', ctx);
80001a50:	00048593          	mv	a1,s1
80001a54:	05200513          	li	a0,82
80001a58:	000400e7          	jalr	s0
	out('R', ctx);
80001a5c:	00040313          	mv	t1,s0
}
80001a60:	00812403          	lw	s0,8(sp)
80001a64:	00c12083          	lw	ra,12(sp)
	out('R', ctx);
80001a68:	00048593          	mv	a1,s1
}
80001a6c:	00412483          	lw	s1,4(sp)
	out('R', ctx);
80001a70:	05200513          	li	a0,82
}
80001a74:	01010113          	addi	sp,sp,16
	out('R', ctx);
80001a78:	00030067          	jr	t1

80001a7c <char_out>:

static int char_out(int c, void *ctx_p)
{
	struct out_context *ctx = ctx_p;

	ctx->count++;
80001a7c:	0005a783          	lw	a5,0(a1)
80001a80:	00178793          	addi	a5,a5,1
80001a84:	00f5a023          	sw	a5,0(a1)
	return _char_out(c);
80001a88:	800077b7          	lui	a5,0x80007
80001a8c:	d847a303          	lw	t1,-636(a5) # 80006d84 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006d85>
80001a90:	00030067          	jr	t1

80001a94 <_printk_dec_ulong>:
 * @return N/A
 */
static void _printk_dec_ulong(out_func_t out, void *ctx,
			      const unsigned long num, enum pad_type padding,
			      int min_width)
{
80001a94:	fc010113          	addi	sp,sp,-64
80001a98:	02812c23          	sw	s0,56(sp)
80001a9c:	03312623          	sw	s3,44(sp)
80001aa0:	03412423          	sw	s4,40(sp)
80001aa4:	03612023          	sw	s6,32(sp)
80001aa8:	01a12823          	sw	s10,16(sp)
80001aac:	02112e23          	sw	ra,60(sp)
80001ab0:	02912a23          	sw	s1,52(sp)
80001ab4:	03212823          	sw	s2,48(sp)
80001ab8:	03512223          	sw	s5,36(sp)
80001abc:	01712e23          	sw	s7,28(sp)
80001ac0:	01812c23          	sw	s8,24(sp)
80001ac4:	01912a23          	sw	s9,20(sp)
80001ac8:	01b12623          	sw	s11,12(sp)
80001acc:	00050993          	mv	s3,a0
80001ad0:	00058a13          	mv	s4,a1
80001ad4:	00060d13          	mv	s10,a2
80001ad8:	00068b13          	mv	s6,a3
80001adc:	00100413          	li	s0,1
80001ae0:	00e05463          	blez	a4,80001ae8 <_printk_dec_ulong+0x54>
80001ae4:	00070413          	mv	s0,a4
80001ae8:	00100793          	li	a5,1
80001aec:	02000c93          	li	s9,32
80001af0:	00fb1463          	bne	s6,a5,80001af8 <_printk_dec_ulong+0x64>
80001af4:	03000c93          	li	s9,48
80001af8:	3b9ad4b7          	lui	s1,0x3b9ad
80001afc:	00100913          	li	s2,1
80001b00:	00a00a93          	li	s5,10
80001b04:	00000c13          	li	s8,0
80001b08:	9ff48493          	addi	s1,s1,-1537 # 3b9ac9ff <CONFIG_SYS_CLOCK_HW_CYCLES_PER_SEC+0x3ae3aeff>
		if (found_largest_digit != 0 || remainder > pos) {
			found_largest_digit = 1;
			out((int)((remainder / (pos + 1)) + 48), ctx);
			digits++;
		} else if (remaining <= min_width
				&& padding < PAD_SPACE_AFTER) {
80001b0c:	00200d93          	li	s11,2
		if (found_largest_digit != 0 || remainder > pos) {
80001b10:	00148b93          	addi	s7,s1,1
80001b14:	000c1463          	bnez	s8,80001b1c <_printk_dec_ulong+0x88>
80001b18:	0ba4f263          	bgeu	s1,s10,80001bbc <_printk_dec_ulong+0x128>
			out((int)((remainder / (pos + 1)) + 48), ctx);
80001b1c:	000b8593          	mv	a1,s7
80001b20:	000d0513          	mv	a0,s10
80001b24:	e1dfe0ef          	jal	ra,80000940 <__udivsi3>
80001b28:	000a0593          	mv	a1,s4
80001b2c:	03050513          	addi	a0,a0,48
80001b30:	000980e7          	jalr	s3
			digits++;
80001b34:	00190913          	addi	s2,s2,1
			found_largest_digit = 1;
80001b38:	00100c13          	li	s8,1
			out((int)(padding == PAD_ZERO_BEFORE ? '0' : ' '), ctx);
			digits++;
		}
		remaining--;
		remainder %= (pos + 1);
80001b3c:	000b8593          	mv	a1,s7
80001b40:	000d0513          	mv	a0,s10
80001b44:	e45fe0ef          	jal	ra,80000988 <__umodsi3>
80001b48:	00050d13          	mv	s10,a0
		pos /= 10;
80001b4c:	00a00593          	li	a1,10
80001b50:	00048513          	mv	a0,s1
80001b54:	dedfe0ef          	jal	ra,80000940 <__udivsi3>
		remaining--;
80001b58:	fffa8a93          	addi	s5,s5,-1
	while (pos >= 9) {
80001b5c:	00100793          	li	a5,1
		pos /= 10;
80001b60:	00050493          	mv	s1,a0
	while (pos >= 9) {
80001b64:	fafa96e3          	bne	s5,a5,80001b10 <_printk_dec_ulong+0x7c>
	}
	out((int)(remainder + 48), ctx);
80001b68:	000a0593          	mv	a1,s4
80001b6c:	030d0513          	addi	a0,s10,48
80001b70:	000980e7          	jalr	s3

	if (padding == PAD_SPACE_AFTER) {
80001b74:	00300793          	li	a5,3
		remaining = min_width - digits;
80001b78:	41240433          	sub	s0,s0,s2
	if (padding == PAD_SPACE_AFTER) {
80001b7c:	06fb0663          	beq	s6,a5,80001be8 <_printk_dec_ulong+0x154>
		while (remaining-- > 0) {
			out(' ', ctx);
		}
	}
}
80001b80:	03c12083          	lw	ra,60(sp)
80001b84:	03812403          	lw	s0,56(sp)
80001b88:	03412483          	lw	s1,52(sp)
80001b8c:	03012903          	lw	s2,48(sp)
80001b90:	02c12983          	lw	s3,44(sp)
80001b94:	02812a03          	lw	s4,40(sp)
80001b98:	02412a83          	lw	s5,36(sp)
80001b9c:	02012b03          	lw	s6,32(sp)
80001ba0:	01c12b83          	lw	s7,28(sp)
80001ba4:	01812c03          	lw	s8,24(sp)
80001ba8:	01412c83          	lw	s9,20(sp)
80001bac:	01012d03          	lw	s10,16(sp)
80001bb0:	00c12d83          	lw	s11,12(sp)
80001bb4:	04010113          	addi	sp,sp,64
80001bb8:	00008067          	ret
		} else if (remaining <= min_width
80001bbc:	f95440e3          	blt	s0,s5,80001b3c <_printk_dec_ulong+0xa8>
				&& padding < PAD_SPACE_AFTER) {
80001bc0:	f76deee3          	bltu	s11,s6,80001b3c <_printk_dec_ulong+0xa8>
			out((int)(padding == PAD_ZERO_BEFORE ? '0' : ' '), ctx);
80001bc4:	000a0593          	mv	a1,s4
80001bc8:	000c8513          	mv	a0,s9
80001bcc:	000980e7          	jalr	s3
			digits++;
80001bd0:	00190913          	addi	s2,s2,1
80001bd4:	f69ff06f          	j	80001b3c <_printk_dec_ulong+0xa8>
			out(' ', ctx);
80001bd8:	000a0593          	mv	a1,s4
80001bdc:	02000513          	li	a0,32
80001be0:	000980e7          	jalr	s3
80001be4:	fff40413          	addi	s0,s0,-1
		while (remaining-- > 0) {
80001be8:	fe8048e3          	bgtz	s0,80001bd8 <_printk_dec_ulong+0x144>
80001bec:	f95ff06f          	j	80001b80 <_printk_dec_ulong+0xec>

80001bf0 <__printk_hook_install>:
	_char_out = fn;
80001bf0:	800077b7          	lui	a5,0x80007
80001bf4:	d8a7a223          	sw	a0,-636(a5) # 80006d84 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006d85>
}
80001bf8:	00008067          	ret

80001bfc <z_vprintk>:
{
80001bfc:	fb010113          	addi	sp,sp,-80
80001c00:	04812423          	sw	s0,72(sp)
80001c04:	04912223          	sw	s1,68(sp)
80001c08:	05212023          	sw	s2,64(sp)
80001c0c:	03312e23          	sw	s3,60(sp)
80001c10:	03412c23          	sw	s4,56(sp)
80001c14:	03512a23          	sw	s5,52(sp)
80001c18:	03912223          	sw	s9,36(sp)
80001c1c:	03a12023          	sw	s10,32(sp)
80001c20:	01b12e23          	sw	s11,28(sp)
80001c24:	04112623          	sw	ra,76(sp)
80001c28:	03612823          	sw	s6,48(sp)
80001c2c:	03712623          	sw	s7,44(sp)
80001c30:	03812423          	sw	s8,40(sp)
80001c34:	00050413          	mv	s0,a0
80001c38:	00058493          	mv	s1,a1
80001c3c:	00060a93          	mv	s5,a2
80001c40:	00068d13          	mv	s10,a3
	int long_ctr = 0;
80001c44:	00000a13          	li	s4,0
	int min_width = -1;
80001c48:	fff00913          	li	s2,-1
	enum pad_type padding = PAD_NONE;
80001c4c:	00000993          	li	s3,0
	int might_format = 0; /* 1 if encountered a '%' */
80001c50:	00000c93          	li	s9,0
					if (lld > INT32_MAX ||
80001c54:	80000db7          	lui	s11,0x80000
	while (*fmt) {
80001c58:	000ac503          	lbu	a0,0(s5)
80001c5c:	04051063          	bnez	a0,80001c9c <z_vprintk+0xa0>
}
80001c60:	04c12083          	lw	ra,76(sp)
80001c64:	04812403          	lw	s0,72(sp)
80001c68:	04412483          	lw	s1,68(sp)
80001c6c:	04012903          	lw	s2,64(sp)
80001c70:	03c12983          	lw	s3,60(sp)
80001c74:	03812a03          	lw	s4,56(sp)
80001c78:	03412a83          	lw	s5,52(sp)
80001c7c:	03012b03          	lw	s6,48(sp)
80001c80:	02c12b83          	lw	s7,44(sp)
80001c84:	02812c03          	lw	s8,40(sp)
80001c88:	02412c83          	lw	s9,36(sp)
80001c8c:	02012d03          	lw	s10,32(sp)
80001c90:	01c12d83          	lw	s11,28(sp)
80001c94:	05010113          	addi	sp,sp,80
80001c98:	00008067          	ret
		if (!might_format) {
80001c9c:	000c9e63          	bnez	s9,80001cb8 <z_vprintk+0xbc>
			if (*fmt != '%') {
80001ca0:	02500693          	li	a3,37
80001ca4:	36d50c63          	beq	a0,a3,8000201c <z_vprintk+0x420>
				out((int)*fmt, ctx);
80001ca8:	00048593          	mv	a1,s1
80001cac:	000400e7          	jalr	s0
		++fmt;
80001cb0:	001a8a93          	addi	s5,s5,1
80001cb4:	fa5ff06f          	j	80001c58 <z_vprintk+0x5c>
			switch (*fmt) {
80001cb8:	06400693          	li	a3,100
80001cbc:	12d50063          	beq	a0,a3,80001ddc <z_vprintk+0x1e0>
80001cc0:	06a6e263          	bltu	a3,a0,80001d24 <z_vprintk+0x128>
80001cc4:	03900693          	li	a3,57
80001cc8:	02a6ea63          	bltu	a3,a0,80001cfc <z_vprintk+0x100>
80001ccc:	03100693          	li	a3,49
80001cd0:	0ed57463          	bgeu	a0,a3,80001db8 <z_vprintk+0x1bc>
80001cd4:	02d00693          	li	a3,45
80001cd8:	34d50c63          	beq	a0,a3,80002030 <z_vprintk+0x434>
80001cdc:	03000793          	li	a5,48
80001ce0:	0cf50063          	beq	a0,a5,80001da0 <z_vprintk+0x1a4>
80001ce4:	02500713          	li	a4,37
80001ce8:	02e51263          	bne	a0,a4,80001d0c <z_vprintk+0x110>
				out((int)'%', ctx);
80001cec:	00048593          	mv	a1,s1
80001cf0:	02500513          	li	a0,37
				out((int)*fmt, ctx);
80001cf4:	000400e7          	jalr	s0
				break;
80001cf8:	1600006f          	j	80001e58 <z_vprintk+0x25c>
80001cfc:	05800693          	li	a3,88
80001d00:	1cd50063          	beq	a0,a3,80001ec0 <z_vprintk+0x2c4>
80001d04:	06300713          	li	a4,99
80001d08:	30e50063          	beq	a0,a4,80002008 <z_vprintk+0x40c>
				out((int)'%', ctx);
80001d0c:	00048593          	mv	a1,s1
80001d10:	02500513          	li	a0,37
80001d14:	000400e7          	jalr	s0
				out((int)*fmt, ctx);
80001d18:	00048593          	mv	a1,s1
80001d1c:	000ac503          	lbu	a0,0(s5)
80001d20:	fd5ff06f          	j	80001cf4 <z_vprintk+0xf8>
80001d24:	07000693          	li	a3,112
80001d28:	16d50c63          	beq	a0,a3,80001ea0 <z_vprintk+0x2a4>
80001d2c:	02a6e063          	bltu	a3,a0,80001d4c <z_vprintk+0x150>
80001d30:	06900693          	li	a3,105
80001d34:	0ad50463          	beq	a0,a3,80001ddc <z_vprintk+0x1e0>
80001d38:	06c00693          	li	a3,108
80001d3c:	08d50c63          	beq	a0,a3,80001dd4 <z_vprintk+0x1d8>
80001d40:	06800693          	li	a3,104
80001d44:	f6d506e3          	beq	a0,a3,80001cb0 <z_vprintk+0xb4>
80001d48:	fc5ff06f          	j	80001d0c <z_vprintk+0x110>
80001d4c:	07500693          	li	a3,117
80001d50:	10d50863          	beq	a0,a3,80001e60 <z_vprintk+0x264>
80001d54:	02a6ee63          	bltu	a3,a0,80001d90 <z_vprintk+0x194>
80001d58:	07300713          	li	a4,115
80001d5c:	fae518e3          	bne	a0,a4,80001d0c <z_vprintk+0x110>
				char *s = va_arg(ap, char *);
80001d60:	000d2c03          	lw	s8,0(s10)
80001d64:	004d0b13          	addi	s6,s10,4
80001d68:	000c0b93          	mv	s7,s8
				while (*s)
80001d6c:	000bc503          	lbu	a0,0(s7)
80001d70:	26051a63          	bnez	a0,80001fe4 <z_vprintk+0x3e8>
				if (padding == PAD_SPACE_AFTER) {
80001d74:	00300793          	li	a5,3
80001d78:	00f99863          	bne	s3,a5,80001d88 <z_vprintk+0x18c>
					int remaining = min_width - (s - start);
80001d7c:	418b8bb3          	sub	s7,s7,s8
80001d80:	41790bb3          	sub	s7,s2,s7
					while (remaining-- > 0) {
80001d84:	27704863          	bgtz	s7,80001ff4 <z_vprintk+0x3f8>
				char *s = va_arg(ap, char *);
80001d88:	000b0d13          	mv	s10,s6
80001d8c:	0cc0006f          	j	80001e58 <z_vprintk+0x25c>
80001d90:	07800693          	li	a3,120
80001d94:	12d50663          	beq	a0,a3,80001ec0 <z_vprintk+0x2c4>
80001d98:	07a00693          	li	a3,122
80001d9c:	fa9ff06f          	j	80001d44 <z_vprintk+0x148>
				if (min_width < 0 && padding == PAD_NONE) {
80001da0:	00095e63          	bgez	s2,80001dbc <z_vprintk+0x1c0>
80001da4:	28098a63          	beqz	s3,80002038 <z_vprintk+0x43c>
					min_width = *fmt - '0';
80001da8:	fd050913          	addi	s2,a0,-48
				if (padding == PAD_NONE) {
80001dac:	f00992e3          	bnez	s3,80001cb0 <z_vprintk+0xb4>
					padding = PAD_SPACE_BEFORE;
80001db0:	00200993          	li	s3,2
80001db4:	efdff06f          	j	80001cb0 <z_vprintk+0xb4>
				if (min_width < 0) {
80001db8:	fe0948e3          	bltz	s2,80001da8 <z_vprintk+0x1ac>
					min_width = 10 * min_width + *fmt - '0';
80001dbc:	00291693          	slli	a3,s2,0x2
80001dc0:	01268933          	add	s2,a3,s2
80001dc4:	00191913          	slli	s2,s2,0x1
80001dc8:	fd090913          	addi	s2,s2,-48
80001dcc:	01250933          	add	s2,a0,s2
80001dd0:	fddff06f          	j	80001dac <z_vprintk+0x1b0>
				long_ctr++;
80001dd4:	001a0a13          	addi	s4,s4,1
80001dd8:	ed9ff06f          	j	80001cb0 <z_vprintk+0xb4>
				if (long_ctr == 0) {
80001ddc:	040a1263          	bnez	s4,80001e20 <z_vprintk+0x224>
					long ld = va_arg(ap, long);
80001de0:	000d2603          	lw	a2,0(s10)
80001de4:	004d0d13          	addi	s10,s10,4
				if (d < 0) {
80001de8:	02065063          	bgez	a2,80001e08 <z_vprintk+0x20c>
					out((int)'-', ctx);
80001dec:	00048593          	mv	a1,s1
80001df0:	02d00513          	li	a0,45
80001df4:	00c12023          	sw	a2,0(sp)
80001df8:	000400e7          	jalr	s0
					d = -d;
80001dfc:	00012603          	lw	a2,0(sp)
					min_width--;
80001e00:	fff90913          	addi	s2,s2,-1
					d = -d;
80001e04:	40c00633          	neg	a2,a2
				_printk_dec_ulong(out, ctx, u, padding,
80001e08:	00090713          	mv	a4,s2
80001e0c:	00098693          	mv	a3,s3
80001e10:	00048593          	mv	a1,s1
80001e14:	00040513          	mv	a0,s0
80001e18:	c7dff0ef          	jal	ra,80001a94 <_printk_dec_ulong>
				break;
80001e1c:	03c0006f          	j	80001e58 <z_vprintk+0x25c>
				} else if (long_ctr == 1) {
80001e20:	00100713          	li	a4,1
80001e24:	faea0ee3          	beq	s4,a4,80001de0 <z_vprintk+0x1e4>
					long long lld = va_arg(ap, long long);
80001e28:	007d0793          	addi	a5,s10,7
80001e2c:	ff87f713          	andi	a4,a5,-8
80001e30:	00072603          	lw	a2,0(a4)
80001e34:	00472683          	lw	a3,4(a4)
80001e38:	00870d13          	addi	s10,a4,8
					if (lld > INT32_MAX ||
80001e3c:	01b60733          	add	a4,a2,s11
80001e40:	00c73733          	sltu	a4,a4,a2
80001e44:	00d70733          	add	a4,a4,a3
80001e48:	fa0700e3          	beqz	a4,80001de8 <z_vprintk+0x1ec>
						print_err(out, ctx);
80001e4c:	00048593          	mv	a1,s1
80001e50:	00040513          	mv	a0,s0
80001e54:	bddff0ef          	jal	ra,80001a30 <print_err>
			might_format = 0;
80001e58:	00000c93          	li	s9,0
80001e5c:	e55ff06f          	j	80001cb0 <z_vprintk+0xb4>
				if (long_ctr == 0) {
80001e60:	000a1863          	bnez	s4,80001e70 <z_vprintk+0x274>
					long lu = va_arg(ap, unsigned long);
80001e64:	000d2603          	lw	a2,0(s10)
80001e68:	004d0d13          	addi	s10,s10,4
80001e6c:	f9dff06f          	j	80001e08 <z_vprintk+0x20c>
				} else if (long_ctr == 1) {
80001e70:	00100713          	li	a4,1
80001e74:	feea08e3          	beq	s4,a4,80001e64 <z_vprintk+0x268>
					unsigned long long llu =
80001e78:	007d0793          	addi	a5,s10,7
80001e7c:	ff87f713          	andi	a4,a5,-8
80001e80:	00870d13          	addi	s10,a4,8
80001e84:	00072603          	lw	a2,0(a4)
80001e88:	00472703          	lw	a4,4(a4)
					if (llu > INT32_MAX) {
80001e8c:	fc0710e3          	bnez	a4,80001e4c <z_vprintk+0x250>
80001e90:	800007b7          	lui	a5,0x80000
80001e94:	fff7c793          	not	a5,a5
80001e98:	f6c7f8e3          	bgeu	a5,a2,80001e08 <z_vprintk+0x20c>
80001e9c:	fb1ff06f          	j	80001e4c <z_vprintk+0x250>
				  out('0', ctx);
80001ea0:	00048593          	mv	a1,s1
80001ea4:	03000513          	li	a0,48
80001ea8:	000400e7          	jalr	s0
				  out('x', ctx);
80001eac:	00048593          	mv	a1,s1
80001eb0:	07800513          	li	a0,120
80001eb4:	000400e7          	jalr	s0
				  min_width = 8;
80001eb8:	00800913          	li	s2,8
				  padding = PAD_ZERO_BEFORE;
80001ebc:	00100993          	li	s3,1
				if (long_ctr < 2) {
80001ec0:	00100693          	li	a3,1
80001ec4:	0b46c263          	blt	a3,s4,80001f68 <z_vprintk+0x36c>
					x = va_arg(ap, unsigned long);
80001ec8:	000d2783          	lw	a5,0(s10)
80001ecc:	00012423          	sw	zero,8(sp)
80001ed0:	004d0d13          	addi	s10,s10,4
80001ed4:	00f12223          	sw	a5,4(sp)
	int remaining = 16; /* 16 digits max */
80001ed8:	01000c13          	li	s8,16
	int digits = 0;
80001edc:	00000b93          	li	s7,0
	int found_largest_digit = 0;
80001ee0:	00012023          	sw	zero,0(sp)
	int size = sizeof(num) * 2;
80001ee4:	01000893          	li	a7,16
		char nibble = (num >> ((size - 1) << 2) & 0xf);
80001ee8:	00412503          	lw	a0,4(sp)
80001eec:	00812583          	lw	a1,8(sp)
80001ef0:	fff88b13          	addi	s6,a7,-1
80001ef4:	002b1613          	slli	a2,s6,0x2
80001ef8:	01112623          	sw	a7,12(sp)
80001efc:	b7cfe0ef          	jal	ra,80000278 <__lshrdi3>
80001f00:	00f57513          	andi	a0,a0,15
		if (nibble != 0 || found_largest_digit != 0 || size == 1) {
80001f04:	08051863          	bnez	a0,80001f94 <z_vprintk+0x398>
80001f08:	00012783          	lw	a5,0(sp)
			nibble += nibble > 9 ? 87 : 48;
80001f0c:	03000693          	li	a3,48
		if (nibble != 0 || found_largest_digit != 0 || size == 1) {
80001f10:	00079863          	bnez	a5,80001f20 <z_vprintk+0x324>
80001f14:	00c12883          	lw	a7,12(sp)
80001f18:	00100793          	li	a5,1
80001f1c:	08f89663          	bne	a7,a5,80001fa8 <z_vprintk+0x3ac>
			nibble += nibble > 9 ? 87 : 48;
80001f20:	00a68533          	add	a0,a3,a0
			out((int)nibble, ctx);
80001f24:	01851513          	slli	a0,a0,0x18
80001f28:	00048593          	mv	a1,s1
80001f2c:	41855513          	srai	a0,a0,0x18
80001f30:	000400e7          	jalr	s0
			digits++;
80001f34:	001b8b93          	addi	s7,s7,1
	for (; size != 0; size--) {
80001f38:	040b1863          	bnez	s6,80001f88 <z_vprintk+0x38c>
	if (padding == PAD_SPACE_AFTER) {
80001f3c:	00300693          	li	a3,3
			might_format = 0;
80001f40:	00000c93          	li	s9,0
	if (padding == PAD_SPACE_AFTER) {
80001f44:	d6d996e3          	bne	s3,a3,80001cb0 <z_vprintk+0xb4>
		remaining = min_width * 2 - digits;
80001f48:	00191713          	slli	a4,s2,0x1
80001f4c:	41770bb3          	sub	s7,a4,s7
		while (remaining-- > 0) {
80001f50:	f17054e3          	blez	s7,80001e58 <z_vprintk+0x25c>
			out(' ', ctx);
80001f54:	00048593          	mv	a1,s1
80001f58:	02000513          	li	a0,32
80001f5c:	000400e7          	jalr	s0
80001f60:	fffb8b93          	addi	s7,s7,-1
80001f64:	fedff06f          	j	80001f50 <z_vprintk+0x354>
					x = va_arg(ap, unsigned long long);
80001f68:	007d0793          	addi	a5,s10,7
80001f6c:	ff87f693          	andi	a3,a5,-8
80001f70:	0006a783          	lw	a5,0(a3)
80001f74:	00868d13          	addi	s10,a3,8
80001f78:	00f12223          	sw	a5,4(sp)
80001f7c:	0046a783          	lw	a5,4(a3)
80001f80:	00f12423          	sw	a5,8(sp)
80001f84:	f55ff06f          	j	80001ed8 <z_vprintk+0x2dc>
			found_largest_digit = 1;
80001f88:	01912023          	sw	s9,0(sp)
		char nibble = (num >> ((size - 1) << 2) & 0xf);
80001f8c:	000b0893          	mv	a7,s6
80001f90:	f59ff06f          	j	80001ee8 <z_vprintk+0x2ec>
			nibble += nibble > 9 ? 87 : 48;
80001f94:	00900793          	li	a5,9
80001f98:	05700693          	li	a3,87
80001f9c:	f8a7e2e3          	bltu	a5,a0,80001f20 <z_vprintk+0x324>
80001fa0:	03000693          	li	a3,48
80001fa4:	f7dff06f          	j	80001f20 <z_vprintk+0x324>
		if (remaining-- <= min_width) {
80001fa8:	fffc0793          	addi	a5,s8,-1
80001fac:	00f12623          	sw	a5,12(sp)
80001fb0:	01894c63          	blt	s2,s8,80001fc8 <z_vprintk+0x3cc>
			if (padding == PAD_ZERO_BEFORE) {
80001fb4:	00100793          	li	a5,1
80001fb8:	00f99c63          	bne	s3,a5,80001fd0 <z_vprintk+0x3d4>
				out('0', ctx);
80001fbc:	00048593          	mv	a1,s1
80001fc0:	03000513          	li	a0,48
				out(' ', ctx);
80001fc4:	000400e7          	jalr	s0
					x = va_arg(ap, unsigned long);
80001fc8:	00c12c03          	lw	s8,12(sp)
80001fcc:	fc1ff06f          	j	80001f8c <z_vprintk+0x390>
			} else if (padding == PAD_SPACE_BEFORE) {
80001fd0:	00200793          	li	a5,2
80001fd4:	fef99ae3          	bne	s3,a5,80001fc8 <z_vprintk+0x3cc>
				out(' ', ctx);
80001fd8:	00048593          	mv	a1,s1
80001fdc:	02000513          	li	a0,32
80001fe0:	fe5ff06f          	j	80001fc4 <z_vprintk+0x3c8>
					out((int)(*s++), ctx);
80001fe4:	00048593          	mv	a1,s1
80001fe8:	001b8b93          	addi	s7,s7,1
80001fec:	000400e7          	jalr	s0
80001ff0:	d7dff06f          	j	80001d6c <z_vprintk+0x170>
						out(' ', ctx);
80001ff4:	00048593          	mv	a1,s1
80001ff8:	02000513          	li	a0,32
80001ffc:	000400e7          	jalr	s0
80002000:	fffb8b93          	addi	s7,s7,-1
80002004:	d81ff06f          	j	80001d84 <z_vprintk+0x188>
				out(c, ctx);
80002008:	000d2503          	lw	a0,0(s10)
8000200c:	00048593          	mv	a1,s1
				int c = va_arg(ap, int);
80002010:	004d0b13          	addi	s6,s10,4
				out(c, ctx);
80002014:	000400e7          	jalr	s0
				break;
80002018:	d71ff06f          	j	80001d88 <z_vprintk+0x18c>
				long_ctr = 0;
8000201c:	00000a13          	li	s4,0
				min_width = -1;
80002020:	fff00913          	li	s2,-1
				padding = PAD_NONE;
80002024:	00000993          	li	s3,0
				might_format = 1;
80002028:	00100c93          	li	s9,1
8000202c:	c85ff06f          	j	80001cb0 <z_vprintk+0xb4>
				padding = PAD_SPACE_AFTER;
80002030:	00300993          	li	s3,3
80002034:	c7dff06f          	j	80001cb0 <z_vprintk+0xb4>
					padding = PAD_ZERO_BEFORE;
80002038:	00100993          	li	s3,1
8000203c:	c75ff06f          	j	80001cb0 <z_vprintk+0xb4>

80002040 <vprintk>:
{
80002040:	fe010113          	addi	sp,sp,-32
	z_vprintk(char_out, &ctx, fmt, ap);
80002044:	00050613          	mv	a2,a0
80002048:	80002537          	lui	a0,0x80002
8000204c:	00058693          	mv	a3,a1
80002050:	a7c50513          	addi	a0,a0,-1412 # 80001a7c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80001a7d>
80002054:	00c10593          	addi	a1,sp,12
{
80002058:	00112e23          	sw	ra,28(sp)
	struct out_context ctx = { 0 };
8000205c:	00012623          	sw	zero,12(sp)
	z_vprintk(char_out, &ctx, fmt, ap);
80002060:	b9dff0ef          	jal	ra,80001bfc <z_vprintk>
}
80002064:	01c12083          	lw	ra,28(sp)
80002068:	02010113          	addi	sp,sp,32
8000206c:	00008067          	ret

80002070 <printk>:
{
80002070:	fc010113          	addi	sp,sp,-64
80002074:	02b12223          	sw	a1,36(sp)
	va_start(ap, fmt);
80002078:	02410593          	addi	a1,sp,36
{
8000207c:	00112e23          	sw	ra,28(sp)
80002080:	02c12423          	sw	a2,40(sp)
80002084:	02d12623          	sw	a3,44(sp)
80002088:	02e12823          	sw	a4,48(sp)
8000208c:	02f12a23          	sw	a5,52(sp)
80002090:	03012c23          	sw	a6,56(sp)
80002094:	03112e23          	sw	a7,60(sp)
	va_start(ap, fmt);
80002098:	00b12623          	sw	a1,12(sp)
		vprintk(fmt, ap);
8000209c:	fa5ff0ef          	jal	ra,80002040 <vprintk>
}
800020a0:	01c12083          	lw	ra,28(sp)
800020a4:	04010113          	addi	sp,sp,64
800020a8:	00008067          	ret

800020ac <assert_post_action>:
__weak void assert_post_action(const char *file, unsigned int line)
{
  ARG_UNUSED(file);
  ARG_UNUSED(line);

  k_panic();
800020ac:	800075b7          	lui	a1,0x80007
800020b0:	80007537          	lui	a0,0x80007
{
800020b4:	ff010113          	addi	sp,sp,-16
  k_panic();
800020b8:	87458593          	addi	a1,a1,-1932 # 80006874 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006875>
800020bc:	88850513          	addi	a0,a0,-1912 # 80006888 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006889>
800020c0:	01e00613          	li	a2,30
{
800020c4:	00112623          	sw	ra,12(sp)
  k_panic();
800020c8:	fa9ff0ef          	jal	ra,80002070 <printk>
800020cc:	800065b7          	lui	a1,0x80006
800020d0:	45458593          	addi	a1,a1,1108 # 80006454 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006455>
800020d4:	00600513          	li	a0,6
800020d8:	dd9fe0ef          	jal	ra,80000eb0 <z_NanoFatalErrorHandler>

800020dc <_ConfigAbsSyms>:
GEN_ABSOLUTE_SYM(CONFIG_OUTPUT_STAT, 1);
GEN_ABSOLUTE_SYM(CONFIG_OUTPUT_DISASSEMBLY, 1);
GEN_ABSOLUTE_SYM(CONFIG_OUTPUT_PRINT_MEMORY_USAGE, 1);
GEN_ABSOLUTE_SYM(CONFIG_BUILD_OUTPUT_BIN, 1);

GEN_ABS_SYM_END
800020dc:	00008067          	ret

800020e0 <k_cpu_idle>:
	__asm__ volatile ("csrrs %0, mstatus, %1"
800020e0:	00800793          	li	a5,8
800020e4:	3007a7f3          	csrrs	a5,mstatus,a5
	z_sys_trace_idle();
	/* unlock interrupts */
	irq_unlock(key);

	/* Wait for interrupt */
	__asm__ volatile("wfi");
800020e8:	10500073          	wfi
 * @return N/A
 */
void k_cpu_idle(void)
{
	riscv_idle(SOC_MSTATUS_IEN);
}
800020ec:	00008067          	ret

800020f0 <z_arch_irq_enable>:
	 * CSR mie register is updated using atomic instruction csrrs
	 * (atomic read and set bits in CSR register)
	 */
	__asm__ volatile ("csrrs %0, mie, %1\n"
			  : "=r" (mie)
			  : "r" (1 << irq));
800020f0:	00100793          	li	a5,1
800020f4:	00a79533          	sll	a0,a5,a0
	__asm__ volatile ("csrrs %0, mie, %1\n"
800020f8:	30452573          	csrrs	a0,mie,a0
}
800020fc:	00008067          	ret

80002100 <soc_interrupt_init>:
	__asm__ volatile ("csrrc %0, mstatus, %1"
80002100:	00800793          	li	a5,8
80002104:	3007b7f3          	csrrc	a5,mstatus,a5
void soc_interrupt_init(void)
{
	/* ensure that all interrupts are disabled */
	(void)irq_lock();

	__asm__ volatile ("csrwi mie, 0\n"
80002108:	30405073          	csrwi	mie,0
8000210c:	34405073          	csrwi	mip,0
			  "csrwi mip, 0\n");
}
80002110:	00008067          	ret

80002114 <console_out>:
 *
 * @return The character passed as input.
 */

static int console_out(int c)
{
80002114:	ff010113          	addi	sp,sp,-16
80002118:	00812423          	sw	s0,8(sp)
8000211c:	00912223          	sw	s1,4(sp)
80002120:	80007437          	lui	s0,0x80007
80002124:	00112623          	sw	ra,12(sp)
		return c;
	}

#endif  /* CONFIG_UART_CONSOLE_DEBUG_SERVER_HOOKS */

	if ('\n' == c) {
80002128:	00a00793          	li	a5,10
{
8000212c:	00050493          	mv	s1,a0
80002130:	e3840413          	addi	s0,s0,-456 # 80006e38 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006e39>
	if ('\n' == c) {
80002134:	00f51c63          	bne	a0,a5,8000214c <console_out+0x38>
80002138:	00042503          	lw	a0,0(s0)
						unsigned char out_char)
{
	const struct uart_driver_api *api =
		(const struct uart_driver_api *)dev->driver_api;

	api->poll_out(dev, out_char);
8000213c:	00d00593          	li	a1,13
80002140:	00452783          	lw	a5,4(a0)
80002144:	0047a783          	lw	a5,4(a5) # 80000004 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80000005>
80002148:	000780e7          	jalr	a5
		uart_poll_out(uart_console_dev, '\r');
	}
	uart_poll_out(uart_console_dev, c);
8000214c:	00042503          	lw	a0,0(s0)
80002150:	0ff4f593          	andi	a1,s1,255
80002154:	00452783          	lw	a5,4(a0)
80002158:	0047a783          	lw	a5,4(a5)
8000215c:	000780e7          	jalr	a5

	return c;
}
80002160:	00c12083          	lw	ra,12(sp)
80002164:	00812403          	lw	s0,8(sp)
80002168:	00048513          	mv	a0,s1
8000216c:	00412483          	lw	s1,4(sp)
80002170:	01010113          	addi	sp,sp,16
80002174:	00008067          	ret

80002178 <uart_console_hook_install>:
 *
 * @return N/A
 */

void uart_console_hook_install(void)
{
80002178:	ff010113          	addi	sp,sp,-16
8000217c:	00812423          	sw	s0,8(sp)
	__stdout_hook_install(console_out);
80002180:	80002437          	lui	s0,0x80002
80002184:	11440513          	addi	a0,s0,276 # 80002114 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80002115>
{
80002188:	00112623          	sw	ra,12(sp)
	__stdout_hook_install(console_out);
8000218c:	5d8000ef          	jal	ra,80002764 <__stdout_hook_install>
	__printk_hook_install(console_out);
80002190:	11440513          	addi	a0,s0,276
}
80002194:	00812403          	lw	s0,8(sp)
80002198:	00c12083          	lw	ra,12(sp)
8000219c:	01010113          	addi	sp,sp,16
	__printk_hook_install(console_out);
800021a0:	a51ff06f          	j	80001bf0 <__printk_hook_install>

800021a4 <uart_console_init>:

#ifdef __cplusplus
extern "C" {
#endif

K_SYSCALL_DECLARE1(K_SYSCALL_DEVICE_GET_BINDING, device_get_binding, struct device *, const char *, name)
800021a4:	80007537          	lui	a0,0x80007
 * @brief Initialize one UART as the console/debug port
 *
 * @return 0 if successful, otherwise failed.
 */
static int uart_console_init(struct device *arg)
{
800021a8:	ff010113          	addi	sp,sp,-16
800021ac:	89450513          	addi	a0,a0,-1900 # 80006894 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006895>
800021b0:	00112623          	sw	ra,12(sp)
800021b4:	159000ef          	jal	ra,80002b0c <z_impl_device_get_binding>

	ARG_UNUSED(arg);

	uart_console_dev = device_get_binding(CONFIG_UART_CONSOLE_ON_DEV_NAME);
800021b8:	800077b7          	lui	a5,0x80007
800021bc:	e2a7ac23          	sw	a0,-456(a5) # 80006e38 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006e39>
		}
	}
	k_busy_wait(1000000);
#endif

	uart_console_hook_install();
800021c0:	fb9ff0ef          	jal	ra,80002178 <uart_console_hook_install>

	return 0;
}
800021c4:	00c12083          	lw	ra,12(sp)
800021c8:	00000513          	li	a0,0
800021cc:	01010113          	addi	sp,sp,16
800021d0:	00008067          	ret

800021d4 <mtime>:
	volatile u32_t *r = (u32_t *)RISCV_MTIME_BASE;
	u32_t lo, hi;

	/* Likewise, must guard against rollover when reading */
	do {
		hi = r[1];
800021d4:	f01007b7          	lui	a5,0xf0100
800021d8:	f447a703          	lw	a4,-188(a5) # f00fff44 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0xf00fff45>
		lo = r[0];
800021dc:	f407a503          	lw	a0,-192(a5)
	} while (r[1] != hi);
800021e0:	f447a583          	lw	a1,-188(a5)
800021e4:	fee59ae3          	bne	a1,a4,800021d8 <mtime+0x4>

	return (((u64_t)hi) << 32) | lo;
}
800021e8:	00008067          	ret

800021ec <timer_isr>:

static void timer_isr(void *arg)
{
800021ec:	fe010113          	addi	sp,sp,-32
800021f0:	00812c23          	sw	s0,24(sp)
800021f4:	00112e23          	sw	ra,28(sp)
800021f8:	00912a23          	sw	s1,20(sp)
800021fc:	01212823          	sw	s2,16(sp)
80002200:	01312623          	sw	s3,12(sp)
80002204:	01412423          	sw	s4,8(sp)
80002208:	01512223          	sw	s5,4(sp)
8000220c:	00800413          	li	s0,8
80002210:	30043473          	csrrc	s0,mstatus,s0
	 * actually a wrapper for a global spinlock!
	 */
	k.key = z_arch_irq_lock();

#ifdef SPIN_VALIDATE
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80002214:	80007937          	lui	s2,0x80007
80002218:	e3c90513          	addi	a0,s2,-452 # 80006e3c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006e3d>
	key = (mstatus & SOC_MSTATUS_IEN);
8000221c:	00847413          	andi	s0,s0,8
80002220:	179020ef          	jal	ra,80004b98 <z_spin_lock_valid>
80002224:	02051e63          	bnez	a0,80002260 <timer_isr+0x74>
80002228:	800074b7          	lui	s1,0x80007
8000222c:	800075b7          	lui	a1,0x80007
80002230:	80006537          	lui	a0,0x80006
80002234:	8c058593          	addi	a1,a1,-1856 # 800068c0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800068c1>
80002238:	04e00693          	li	a3,78
8000223c:	8a848613          	addi	a2,s1,-1880 # 800068a8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800068a9>
80002240:	7dc50513          	addi	a0,a0,2012 # 800067dc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800067dd>
80002244:	e2dff0ef          	jal	ra,80002070 <printk>
80002248:	80007537          	lui	a0,0x80007
8000224c:	8d850513          	addi	a0,a0,-1832 # 800068d8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800068d9>
80002250:	e21ff0ef          	jal	ra,80002070 <printk>
80002254:	04e00593          	li	a1,78
80002258:	8a848513          	addi	a0,s1,-1880
8000225c:	e51ff0ef          	jal	ra,800020ac <assert_post_action>
	while (!atomic_cas(&l->locked, 0, 1)) {
	}
#endif

#ifdef SPIN_VALIDATE
	z_spin_lock_set_owner(l);
80002260:	e3c90513          	addi	a0,s2,-452
	ARG_UNUSED(arg);

	k_spinlock_key_t key = k_spin_lock(&lock);
	u64_t now = mtime();
	u32_t dticks = (u32_t)((now - last_count) / CYC_PER_TICK);
80002264:	800074b7          	lui	s1,0x80007
80002268:	189020ef          	jal	ra,80004bf0 <z_spin_lock_set_owner>
8000226c:	e1848493          	addi	s1,s1,-488 # 80006e18 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006e19>
	u64_t now = mtime();
80002270:	f65ff0ef          	jal	ra,800021d4 <mtime>
	u32_t dticks = (u32_t)((now - last_count) / CYC_PER_TICK);
80002274:	0004a983          	lw	s3,0(s1)
80002278:	0044aa83          	lw	s5,4(s1)
	u64_t now = mtime();
8000227c:	00050793          	mv	a5,a0
	u32_t dticks = (u32_t)((now - last_count) / CYC_PER_TICK);
80002280:	41350533          	sub	a0,a0,s3
80002284:	00a7b7b3          	sltu	a5,a5,a0
80002288:	415585b3          	sub	a1,a1,s5
8000228c:	0001d637          	lui	a2,0x1d
80002290:	4c060613          	addi	a2,a2,1216 # 1d4c0 <CONFIG_ISR_STACK_SIZE+0x1ccc0>
80002294:	00000693          	li	a3,0
80002298:	40f585b3          	sub	a1,a1,a5
8000229c:	814fe0ef          	jal	ra,800002b0 <__udivdi3>
800022a0:	00050a13          	mv	s4,a0

	last_count += dticks * CYC_PER_TICK;
800022a4:	0001d5b7          	lui	a1,0x1d
800022a8:	4c058593          	addi	a1,a1,1216 # 1d4c0 <CONFIG_ISR_STACK_SIZE+0x1ccc0>
800022ac:	000a0513          	mv	a0,s4
800022b0:	dd4fe0ef          	jal	ra,80000884 <__mulsi3>
800022b4:	013509b3          	add	s3,a0,s3
800022b8:	00a9b533          	sltu	a0,s3,a0
800022bc:	01550533          	add	a0,a0,s5
800022c0:	00a4a223          	sw	a0,4(s1)
static ALWAYS_INLINE void k_spin_unlock(struct k_spinlock *l,
					k_spinlock_key_t key)
{
	ARG_UNUSED(l);
#ifdef SPIN_VALIDATE
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
800022c4:	e3c90513          	addi	a0,s2,-452
800022c8:	0134a023          	sw	s3,0(s1)
800022cc:	0f5020ef          	jal	ra,80004bc0 <z_spin_unlock_valid>
800022d0:	02051e63          	bnez	a0,8000230c <timer_isr+0x120>
800022d4:	800074b7          	lui	s1,0x80007
800022d8:	800075b7          	lui	a1,0x80007
800022dc:	80006537          	lui	a0,0x80006
800022e0:	8f058593          	addi	a1,a1,-1808 # 800068f0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800068f1>
800022e4:	06100693          	li	a3,97
800022e8:	8a848613          	addi	a2,s1,-1880 # 800068a8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800068a9>
800022ec:	7dc50513          	addi	a0,a0,2012 # 800067dc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800067dd>
800022f0:	d81ff0ef          	jal	ra,80002070 <printk>
800022f4:	80007537          	lui	a0,0x80007
800022f8:	90850513          	addi	a0,a0,-1784 # 80006908 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006909>
800022fc:	d75ff0ef          	jal	ra,80002070 <printk>
80002300:	06100593          	li	a1,97
80002304:	8a848513          	addi	a0,s1,-1880
80002308:	da5ff0ef          	jal	ra,800020ac <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
8000230c:	30042473          	csrrs	s0,mstatus,s0
		set_mtimecmp(next);
	}

	k_spin_unlock(&lock, key);
	z_clock_announce(IS_ENABLED(CONFIG_TICKLESS_KERNEL) ? dticks : 1);
}
80002310:	01812403          	lw	s0,24(sp)
80002314:	01c12083          	lw	ra,28(sp)
80002318:	01412483          	lw	s1,20(sp)
8000231c:	01012903          	lw	s2,16(sp)
80002320:	00c12983          	lw	s3,12(sp)
80002324:	00412a83          	lw	s5,4(sp)
	z_clock_announce(IS_ENABLED(CONFIG_TICKLESS_KERNEL) ? dticks : 1);
80002328:	000a0513          	mv	a0,s4
}
8000232c:	00812a03          	lw	s4,8(sp)
80002330:	02010113          	addi	sp,sp,32
	z_clock_announce(IS_ENABLED(CONFIG_TICKLESS_KERNEL) ? dticks : 1);
80002334:	3240306f          	j	80005658 <z_clock_announce>

80002338 <z_clock_driver_init>:

int z_clock_driver_init(struct device *device)
{
80002338:	ff010113          	addi	sp,sp,-16
8000233c:	00112623          	sw	ra,12(sp)
	IRQ_CONNECT(RISCV_MACHINE_TIMER_IRQ, 0, timer_isr, NULL, 0);
	set_mtimecmp(mtime() + CYC_PER_TICK);
80002340:	e95ff0ef          	jal	ra,800021d4 <mtime>
80002344:	0001d7b7          	lui	a5,0x1d
80002348:	4c078793          	addi	a5,a5,1216 # 1d4c0 <CONFIG_ISR_STACK_SIZE+0x1ccc0>
	r[1] = 0xffffffff;
8000234c:	f0100737          	lui	a4,0xf0100
	set_mtimecmp(mtime() + CYC_PER_TICK);
80002350:	00f507b3          	add	a5,a0,a5
	r[1] = 0xffffffff;
80002354:	fff00693          	li	a3,-1
80002358:	f4d72623          	sw	a3,-180(a4) # f00fff4c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0xf00fff4d>
	set_mtimecmp(mtime() + CYC_PER_TICK);
8000235c:	00a7b533          	sltu	a0,a5,a0
80002360:	00b50533          	add	a0,a0,a1
	r[0] = (u32_t)time;
80002364:	f4f72423          	sw	a5,-184(a4)
	r[1] = (u32_t)(time >> 32);
80002368:	f4a72623          	sw	a0,-180(a4)
	irq_enable(RISCV_MACHINE_TIMER_IRQ);
8000236c:	00700513          	li	a0,7
80002370:	d81ff0ef          	jal	ra,800020f0 <z_arch_irq_enable>
	return 0;
}
80002374:	00c12083          	lw	ra,12(sp)
80002378:	00000513          	li	a0,0
8000237c:	01010113          	addi	sp,sp,16
80002380:	00008067          	ret

80002384 <z_clock_set_timeout>:
	 * logic below to reset the comparator, we'll always bump it
	 * forward to the "next tick" due to MIN_DELAY handling and
	 * the interrupt will never fire!  Just rely on the fact that
	 * the OS gave us the proper timeout already.
	 */
	if (idle) {
80002384:	1a059263          	bnez	a1,80002528 <z_clock_set_timeout+0x1a4>
{
80002388:	fe010113          	addi	sp,sp,-32
8000238c:	00112e23          	sw	ra,28(sp)
80002390:	00812c23          	sw	s0,24(sp)
80002394:	00912a23          	sw	s1,20(sp)
80002398:	01212823          	sw	s2,16(sp)
8000239c:	01312623          	sw	s3,12(sp)
800023a0:	01412423          	sw	s4,8(sp)
800023a4:	01512223          	sw	s5,4(sp)
800023a8:	01612023          	sw	s6,0(sp)
		return;
	}

	ticks = ticks == K_FOREVER ? MAX_TICKS : ticks;
800023ac:	fff00793          	li	a5,-1
800023b0:	00f51663          	bne	a0,a5,800023bc <z_clock_set_timeout+0x38>
800023b4:	00009537          	lui	a0,0x9
800023b8:	bce50513          	addi	a0,a0,-1074 # 8bce <CONFIG_ISR_STACK_SIZE+0x83ce>
	ticks = MAX(MIN(ticks - 1, (s32_t)MAX_TICKS), 0);
800023bc:	000097b7          	lui	a5,0x9
800023c0:	fff50413          	addi	s0,a0,-1
800023c4:	bce78793          	addi	a5,a5,-1074 # 8bce <CONFIG_ISR_STACK_SIZE+0x83ce>
800023c8:	1487da63          	bge	a5,s0,8000251c <z_clock_set_timeout+0x198>
800023cc:	00078413          	mv	s0,a5
	__asm__ volatile ("csrrc %0, mstatus, %1"
800023d0:	00800913          	li	s2,8
800023d4:	30093973          	csrrc	s2,mstatus,s2
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
800023d8:	80007ab7          	lui	s5,0x80007
800023dc:	e3ca8513          	addi	a0,s5,-452 # 80006e3c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006e3d>
	key = (mstatus & SOC_MSTATUS_IEN);
800023e0:	00897913          	andi	s2,s2,8
800023e4:	7b4020ef          	jal	ra,80004b98 <z_spin_lock_valid>
800023e8:	02051e63          	bnez	a0,80002424 <z_clock_set_timeout+0xa0>
800023ec:	800074b7          	lui	s1,0x80007
800023f0:	800075b7          	lui	a1,0x80007
800023f4:	80006537          	lui	a0,0x80006
800023f8:	8c058593          	addi	a1,a1,-1856 # 800068c0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800068c1>
800023fc:	04e00693          	li	a3,78
80002400:	8a848613          	addi	a2,s1,-1880 # 800068a8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800068a9>
80002404:	7dc50513          	addi	a0,a0,2012 # 800067dc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800067dd>
80002408:	c69ff0ef          	jal	ra,80002070 <printk>
8000240c:	80007537          	lui	a0,0x80007
80002410:	8d850513          	addi	a0,a0,-1832 # 800068d8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800068d9>
80002414:	c5dff0ef          	jal	ra,80002070 <printk>
80002418:	04e00593          	li	a1,78
8000241c:	8a848513          	addi	a0,s1,-1880
80002420:	c8dff0ef          	jal	ra,800020ac <assert_post_action>
	z_spin_lock_set_owner(l);
80002424:	e3ca8513          	addi	a0,s5,-452
80002428:	7c8020ef          	jal	ra,80004bf0 <z_spin_lock_set_owner>

	k_spinlock_key_t key = k_spin_lock(&lock);
	u64_t now = mtime();
8000242c:	da9ff0ef          	jal	ra,800021d4 <mtime>
	u32_t cyc = ticks * CYC_PER_TICK;

	/* Round up to next tick boundary.  Note use of 32 bit math,
	 * max_ticks is calibrated to permit this.
	 */
	cyc += (u32_t)(now - last_count) + (CYC_PER_TICK - 1);
80002430:	800077b7          	lui	a5,0x80007
80002434:	e1878793          	addi	a5,a5,-488 # 80006e18 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006e19>
	u32_t cyc = ticks * CYC_PER_TICK;
80002438:	0001d4b7          	lui	s1,0x1d
	cyc += (u32_t)(now - last_count) + (CYC_PER_TICK - 1);
8000243c:	0007a983          	lw	s3,0(a5)
	u64_t now = mtime();
80002440:	00050a13          	mv	s4,a0
	u32_t cyc = ticks * CYC_PER_TICK;
80002444:	4c048593          	addi	a1,s1,1216 # 1d4c0 <CONFIG_ISR_STACK_SIZE+0x1ccc0>
80002448:	00040513          	mv	a0,s0
	cyc += (u32_t)(now - last_count) + (CYC_PER_TICK - 1);
8000244c:	0047ab03          	lw	s6,4(a5)
	u32_t cyc = ticks * CYC_PER_TICK;
80002450:	c34fe0ef          	jal	ra,80000884 <__mulsi3>
80002454:	4bf48793          	addi	a5,s1,1215
80002458:	413787b3          	sub	a5,a5,s3
8000245c:	00f50533          	add	a0,a0,a5
	cyc = (cyc / CYC_PER_TICK) * CYC_PER_TICK;
80002460:	4c048593          	addi	a1,s1,1216
80002464:	00aa0533          	add	a0,s4,a0
80002468:	cd8fe0ef          	jal	ra,80000940 <__udivsi3>
8000246c:	4c048593          	addi	a1,s1,1216
80002470:	c14fe0ef          	jal	ra,80000884 <__mulsi3>

	if ((s32_t)(cyc + last_count - now) < MIN_DELAY) {
80002474:	41498a33          	sub	s4,s3,s4
80002478:	00aa0a33          	add	s4,s4,a0
8000247c:	3e700793          	li	a5,999
80002480:	0147c663          	blt	a5,s4,8000248c <z_clock_set_timeout+0x108>
		cyc += CYC_PER_TICK;
80002484:	4c048493          	addi	s1,s1,1216
80002488:	00950533          	add	a0,a0,s1
	r[1] = 0xffffffff;
8000248c:	f01007b7          	lui	a5,0xf0100
	}

	set_mtimecmp(cyc + last_count);
80002490:	013509b3          	add	s3,a0,s3
	r[1] = 0xffffffff;
80002494:	fff00713          	li	a4,-1
80002498:	f4e7a623          	sw	a4,-180(a5) # f00fff4c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0xf00fff4d>
	set_mtimecmp(cyc + last_count);
8000249c:	00a9b533          	sltu	a0,s3,a0
800024a0:	01650533          	add	a0,a0,s6
	r[0] = (u32_t)time;
800024a4:	f537a423          	sw	s3,-184(a5)
	r[1] = (u32_t)(time >> 32);
800024a8:	f4a7a623          	sw	a0,-180(a5)
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
800024ac:	e3ca8513          	addi	a0,s5,-452
800024b0:	710020ef          	jal	ra,80004bc0 <z_spin_unlock_valid>
800024b4:	02051e63          	bnez	a0,800024f0 <z_clock_set_timeout+0x16c>
800024b8:	80007437          	lui	s0,0x80007
800024bc:	800075b7          	lui	a1,0x80007
800024c0:	80006537          	lui	a0,0x80006
800024c4:	8f058593          	addi	a1,a1,-1808 # 800068f0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800068f1>
800024c8:	06100693          	li	a3,97
800024cc:	8a840613          	addi	a2,s0,-1880 # 800068a8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800068a9>
800024d0:	7dc50513          	addi	a0,a0,2012 # 800067dc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800067dd>
800024d4:	b9dff0ef          	jal	ra,80002070 <printk>
800024d8:	80007537          	lui	a0,0x80007
800024dc:	90850513          	addi	a0,a0,-1784 # 80006908 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006909>
800024e0:	b91ff0ef          	jal	ra,80002070 <printk>
800024e4:	06100593          	li	a1,97
800024e8:	8a840513          	addi	a0,s0,-1880
800024ec:	bc1ff0ef          	jal	ra,800020ac <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
800024f0:	30092973          	csrrs	s2,mstatus,s2
	k_spin_unlock(&lock, key);
#endif
}
800024f4:	01c12083          	lw	ra,28(sp)
800024f8:	01812403          	lw	s0,24(sp)
800024fc:	01412483          	lw	s1,20(sp)
80002500:	01012903          	lw	s2,16(sp)
80002504:	00c12983          	lw	s3,12(sp)
80002508:	00812a03          	lw	s4,8(sp)
8000250c:	00412a83          	lw	s5,4(sp)
80002510:	00012b03          	lw	s6,0(sp)
80002514:	02010113          	addi	sp,sp,32
80002518:	00008067          	ret
8000251c:	ea045ae3          	bgez	s0,800023d0 <z_clock_set_timeout+0x4c>
80002520:	00000413          	li	s0,0
80002524:	eadff06f          	j	800023d0 <z_clock_set_timeout+0x4c>
80002528:	00008067          	ret

8000252c <z_clock_elapsed>:

u32_t z_clock_elapsed(void)
{
8000252c:	ff010113          	addi	sp,sp,-16
80002530:	00812423          	sw	s0,8(sp)
80002534:	00112623          	sw	ra,12(sp)
80002538:	00912223          	sw	s1,4(sp)
8000253c:	01212023          	sw	s2,0(sp)
	__asm__ volatile ("csrrc %0, mstatus, %1"
80002540:	00800413          	li	s0,8
80002544:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80002548:	800074b7          	lui	s1,0x80007
8000254c:	e3c48513          	addi	a0,s1,-452 # 80006e3c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006e3d>
	key = (mstatus & SOC_MSTATUS_IEN);
80002550:	00847413          	andi	s0,s0,8
80002554:	644020ef          	jal	ra,80004b98 <z_spin_lock_valid>
80002558:	02051e63          	bnez	a0,80002594 <z_clock_elapsed+0x68>
8000255c:	80007937          	lui	s2,0x80007
80002560:	800075b7          	lui	a1,0x80007
80002564:	80006537          	lui	a0,0x80006
80002568:	8c058593          	addi	a1,a1,-1856 # 800068c0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800068c1>
8000256c:	04e00693          	li	a3,78
80002570:	8a890613          	addi	a2,s2,-1880 # 800068a8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800068a9>
80002574:	7dc50513          	addi	a0,a0,2012 # 800067dc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800067dd>
80002578:	af9ff0ef          	jal	ra,80002070 <printk>
8000257c:	80007537          	lui	a0,0x80007
80002580:	8d850513          	addi	a0,a0,-1832 # 800068d8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800068d9>
80002584:	aedff0ef          	jal	ra,80002070 <printk>
80002588:	04e00593          	li	a1,78
8000258c:	8a890513          	addi	a0,s2,-1880
80002590:	b1dff0ef          	jal	ra,800020ac <assert_post_action>
	z_spin_lock_set_owner(l);
80002594:	e3c48513          	addi	a0,s1,-452
80002598:	658020ef          	jal	ra,80004bf0 <z_spin_lock_set_owner>
	if (!IS_ENABLED(CONFIG_TICKLESS_KERNEL)) {
		return 0;
	}

	k_spinlock_key_t key = k_spin_lock(&lock);
	u32_t ret = ((u32_t)mtime() - (u32_t)last_count) / CYC_PER_TICK;
8000259c:	c39ff0ef          	jal	ra,800021d4 <mtime>
800025a0:	800077b7          	lui	a5,0x80007
800025a4:	e187a783          	lw	a5,-488(a5) # 80006e18 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006e19>
800025a8:	0001d5b7          	lui	a1,0x1d
800025ac:	4c058593          	addi	a1,a1,1216 # 1d4c0 <CONFIG_ISR_STACK_SIZE+0x1ccc0>
800025b0:	40f50533          	sub	a0,a0,a5
800025b4:	b8cfe0ef          	jal	ra,80000940 <__udivsi3>
800025b8:	00050913          	mv	s2,a0
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
800025bc:	e3c48513          	addi	a0,s1,-452
800025c0:	600020ef          	jal	ra,80004bc0 <z_spin_unlock_valid>
800025c4:	02051e63          	bnez	a0,80002600 <z_clock_elapsed+0xd4>
800025c8:	800074b7          	lui	s1,0x80007
800025cc:	800075b7          	lui	a1,0x80007
800025d0:	80006537          	lui	a0,0x80006
800025d4:	8f058593          	addi	a1,a1,-1808 # 800068f0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800068f1>
800025d8:	06100693          	li	a3,97
800025dc:	8a848613          	addi	a2,s1,-1880 # 800068a8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800068a9>
800025e0:	7dc50513          	addi	a0,a0,2012 # 800067dc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800067dd>
800025e4:	a8dff0ef          	jal	ra,80002070 <printk>
800025e8:	80007537          	lui	a0,0x80007
800025ec:	90850513          	addi	a0,a0,-1784 # 80006908 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006909>
800025f0:	a81ff0ef          	jal	ra,80002070 <printk>
800025f4:	06100593          	li	a1,97
800025f8:	8a848513          	addi	a0,s1,-1880
800025fc:	ab1ff0ef          	jal	ra,800020ac <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80002600:	30042473          	csrrs	s0,mstatus,s0

	k_spin_unlock(&lock, key);
	return ret;
}
80002604:	00c12083          	lw	ra,12(sp)
80002608:	00812403          	lw	s0,8(sp)
8000260c:	00090513          	mv	a0,s2
80002610:	00412483          	lw	s1,4(sp)
80002614:	00012903          	lw	s2,0(sp)
80002618:	01010113          	addi	sp,sp,16
8000261c:	00008067          	ret

80002620 <strcmp>:
 * @return negative # if <s1> < <s2>, 0 if <s1> == <s2>, else positive #
 */

int strcmp(const char *s1, const char *s2)
{
	while ((*s1 == *s2) && (*s1 != '\0')) {
80002620:	00054783          	lbu	a5,0(a0)
80002624:	0005c703          	lbu	a4,0(a1)
80002628:	00e79463          	bne	a5,a4,80002630 <strcmp+0x10>
8000262c:	00079663          	bnez	a5,80002638 <strcmp+0x18>
		s1++;
		s2++;
	}

	return *s1 - *s2;
}
80002630:	40e78533          	sub	a0,a5,a4
80002634:	00008067          	ret
		s1++;
80002638:	00150513          	addi	a0,a0,1
		s2++;
8000263c:	00158593          	addi	a1,a1,1
80002640:	fe1ff06f          	j	80002620 <strcmp>

80002644 <memcpy>:
	/* attempt word-sized copying only if buffers have identical alignment */

	unsigned char *d_byte = (unsigned char *)d;
	const unsigned char *s_byte = (const unsigned char *)s;

	if ((((unsigned int)d ^ (unsigned int)s_byte) & 0x3) == 0U) {
80002644:	00b547b3          	xor	a5,a0,a1
80002648:	0037f793          	andi	a5,a5,3
8000264c:	04078c63          	beqz	a5,800026a4 <memcpy+0x60>
	unsigned char *d_byte = (unsigned char *)d;
80002650:	00050793          	mv	a5,a0
80002654:	00000713          	li	a4,0
		s_byte = (unsigned char *)s_word;
	}

	/* do byte-sized copying until finished */

	while (n > 0) {
80002658:	06e61663          	bne	a2,a4,800026c4 <memcpy+0x80>
		*(d_byte++) = *(s_byte++);
		n--;
	}

	return d;
}
8000265c:	00008067          	ret
			if (n == 0) {
80002660:	fe060ee3          	beqz	a2,8000265c <memcpy+0x18>
			*(d_byte++) = *(s_byte++);
80002664:	00158593          	addi	a1,a1,1
80002668:	fff5c703          	lbu	a4,-1(a1)
8000266c:	00178793          	addi	a5,a5,1
			n--;
80002670:	fff60613          	addi	a2,a2,-1
			*(d_byte++) = *(s_byte++);
80002674:	fee78fa3          	sb	a4,-1(a5)
		while (((unsigned int)d_byte) & 0x3) {
80002678:	0037f713          	andi	a4,a5,3
8000267c:	fe0712e3          	bnez	a4,80002660 <memcpy+0x1c>
		while (n >= sizeof(unsigned int)) {
80002680:	00300693          	li	a3,3
80002684:	40e60833          	sub	a6,a2,a4
80002688:	0306e263          	bltu	a3,a6,800026ac <memcpy+0x68>
8000268c:	00265713          	srli	a4,a2,0x2
80002690:	00271693          	slli	a3,a4,0x2
80002694:	40d60633          	sub	a2,a2,a3
80002698:	00d787b3          	add	a5,a5,a3
8000269c:	00d585b3          	add	a1,a1,a3
800026a0:	fb5ff06f          	j	80002654 <memcpy+0x10>
	unsigned char *d_byte = (unsigned char *)d;
800026a4:	00050793          	mv	a5,a0
800026a8:	fd1ff06f          	j	80002678 <memcpy+0x34>
			*(d_word++) = *(s_word++);
800026ac:	00e588b3          	add	a7,a1,a4
800026b0:	0008a883          	lw	a7,0(a7)
800026b4:	00e78833          	add	a6,a5,a4
800026b8:	00470713          	addi	a4,a4,4
800026bc:	01182023          	sw	a7,0(a6)
			n -= sizeof(unsigned int);
800026c0:	fc5ff06f          	j	80002684 <memcpy+0x40>
		*(d_byte++) = *(s_byte++);
800026c4:	00e58833          	add	a6,a1,a4
800026c8:	00084803          	lbu	a6,0(a6)
800026cc:	00e786b3          	add	a3,a5,a4
800026d0:	00170713          	addi	a4,a4,1
800026d4:	01068023          	sb	a6,0(a3)
		n--;
800026d8:	f81ff06f          	j	80002658 <memcpy+0x14>

800026dc <memset>:
void *memset(void *buf, int c, size_t n)
{
	/* do byte-sized initialization until word-aligned or finished */

	unsigned char *d_byte = (unsigned char *)buf;
	unsigned char c_byte = (unsigned char)c;
800026dc:	0ff5f693          	andi	a3,a1,255
	unsigned char *d_byte = (unsigned char *)buf;
800026e0:	00050793          	mv	a5,a0

	while (((unsigned int)d_byte) & 0x3) {
800026e4:	0037f713          	andi	a4,a5,3
800026e8:	04071463          	bnez	a4,80002730 <memset+0x54>
	};

	/* do word-sized initialization as long as possible */

	unsigned int *d_word = (unsigned int *)d_byte;
	unsigned int c_word = (unsigned int)(unsigned char)c;
800026ec:	0ff5f593          	andi	a1,a1,255

	c_word |= c_word << 8;
800026f0:	00859713          	slli	a4,a1,0x8
800026f4:	00b765b3          	or	a1,a4,a1
	c_word |= c_word << 16;
800026f8:	01059713          	slli	a4,a1,0x10
800026fc:	00b765b3          	or	a1,a4,a1

	while (n >= sizeof(unsigned int)) {
80002700:	00c78333          	add	t1,a5,a2
80002704:	00078713          	mv	a4,a5
80002708:	00300813          	li	a6,3
8000270c:	40e308b3          	sub	a7,t1,a4
80002710:	03186a63          	bltu	a6,a7,80002744 <memset+0x68>
80002714:	00265713          	srli	a4,a2,0x2
80002718:	00271593          	slli	a1,a4,0x2
8000271c:	00b787b3          	add	a5,a5,a1
80002720:	40b60633          	sub	a2,a2,a1
80002724:	00c78633          	add	a2,a5,a2

	/* do byte-sized initialization until finished */

	d_byte = (unsigned char *)d_word;

	while (n > 0) {
80002728:	02c79463          	bne	a5,a2,80002750 <memset+0x74>
		*(d_byte++) = c_byte;
		n--;
	}

	return buf;
}
8000272c:	00008067          	ret
		if (n == 0) {
80002730:	fe060ee3          	beqz	a2,8000272c <memset+0x50>
		*(d_byte++) = c_byte;
80002734:	00178793          	addi	a5,a5,1
80002738:	fed78fa3          	sb	a3,-1(a5)
		n--;
8000273c:	fff60613          	addi	a2,a2,-1
80002740:	fa5ff06f          	j	800026e4 <memset+0x8>
		*(d_word++) = c_word;
80002744:	00470713          	addi	a4,a4,4
80002748:	feb72e23          	sw	a1,-4(a4)
		n -= sizeof(unsigned int);
8000274c:	fc1ff06f          	j	8000270c <memset+0x30>
		*(d_byte++) = c_byte;
80002750:	00178793          	addi	a5,a5,1
80002754:	fed78fa3          	sb	a3,-1(a5)
		n--;
80002758:	fd1ff06f          	j	80002728 <memset+0x4c>

8000275c <_stdout_hook_default>:
static int _stdout_hook_default(int c)
{
	(void)(c);  /* Prevent warning about unused argument */

	return EOF;
}
8000275c:	fff00513          	li	a0,-1
80002760:	00008067          	ret

80002764 <__stdout_hook_install>:

static int (*_stdout_hook)(int) = _stdout_hook_default;

void __stdout_hook_install(int (*hook)(int))
{
	_stdout_hook = hook;
80002764:	800077b7          	lui	a5,0x80007
80002768:	d8a7a423          	sw	a0,-632(a5) # 80006d88 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006d89>
}
8000276c:	00008067          	ret

80002770 <test_cb>:
	k_sem_init(&test_end_signal, 0, 1);
	k_object_access_all_grant(&test_end_signal);
}

static void test_cb(void *a, void *dummy2, void *dummy)
{
80002770:	fe010113          	addi	sp,sp,-32
80002774:	00812c23          	sw	s0,24(sp)
	test->setup();
80002778:	00852783          	lw	a5,8(a0)
	phase = TEST_PHASE_SETUP;
8000277c:	80007437          	lui	s0,0x80007
{
80002780:	00912a23          	sw	s1,20(sp)
	phase = TEST_PHASE_SETUP;
80002784:	d8c40413          	addi	s0,s0,-628 # 80006d8c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006d8d>
	struct unit_test *test = (struct unit_test *)a;

	ARG_UNUSED(dummy2);
	ARG_UNUSED(dummy);

	test_result = 1;
80002788:	800074b7          	lui	s1,0x80007
{
8000278c:	00112e23          	sw	ra,28(sp)
80002790:	01212823          	sw	s2,16(sp)
80002794:	01312623          	sw	s3,12(sp)
	test_result = 1;
80002798:	e4048493          	addi	s1,s1,-448 # 80006e40 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006e41>
8000279c:	00100993          	li	s3,1
	phase = TEST_PHASE_SETUP;
800027a0:	00042023          	sw	zero,0(s0)
{
800027a4:	00050913          	mv	s2,a0
	test_result = 1;
800027a8:	0134a023          	sw	s3,0(s1)
	test->setup();
800027ac:	000780e7          	jalr	a5
	test->test();
800027b0:	00492783          	lw	a5,4(s2)
	phase = TEST_PHASE_TEST;
800027b4:	01342023          	sw	s3,0(s0)
	test->test();
800027b8:	000780e7          	jalr	a5
	phase = TEST_PHASE_TEARDOWN;
800027bc:	00200793          	li	a5,2
800027c0:	00f42023          	sw	a5,0(s0)
	test->teardown();
800027c4:	00c92783          	lw	a5,12(s2)
800027c8:	000780e7          	jalr	a5
	phase = TEST_PHASE_FRAMEWORK;
800027cc:	00300793          	li	a5,3
800027d0:	00f42023          	sw	a5,0(s0)
	run_test_functions(test);
	test_result = 0;

	k_sem_give(&test_end_signal);
}
800027d4:	01812403          	lw	s0,24(sp)
	test_result = 0;
800027d8:	0004a023          	sw	zero,0(s1)
}
800027dc:	01c12083          	lw	ra,28(sp)
800027e0:	01412483          	lw	s1,20(sp)
800027e4:	01012903          	lw	s2,16(sp)
800027e8:	00c12983          	lw	s3,12(sp)
K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_SEM_GIVE, k_sem_give, struct k_sem *, sem)
800027ec:	80007537          	lui	a0,0x80007
800027f0:	fd450513          	addi	a0,a0,-44 # 80006fd4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006fd5>
800027f4:	02010113          	addi	sp,sp,32
800027f8:	7e10106f          	j	800047d8 <z_impl_k_sem_give>

800027fc <ztest_test_fail>:
800027fc:	80007537          	lui	a0,0x80007
{
80002800:	ff010113          	addi	sp,sp,-16
	test_result = -1;
80002804:	800077b7          	lui	a5,0x80007
80002808:	fff00713          	li	a4,-1
8000280c:	fd450513          	addi	a0,a0,-44 # 80006fd4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006fd5>
{
80002810:	00112623          	sw	ra,12(sp)
	test_result = -1;
80002814:	e4e7a023          	sw	a4,-448(a5) # 80006e40 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006e41>
80002818:	7c1010ef          	jal	ra,800047d8 <z_impl_k_sem_give>
K_SYSCALL_DECLARE0(K_SYSCALL_K_CURRENT_GET, k_current_get, k_tid_t)
8000281c:	6e9010ef          	jal	ra,80004704 <z_impl_k_current_get>
}
80002820:	00c12083          	lw	ra,12(sp)
80002824:	01010113          	addi	sp,sp,16
K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_THREAD_ABORT, k_thread_abort, k_tid_t, thread)
80002828:	6f80206f          	j	80004f20 <z_impl_k_thread_abort>

8000282c <z_ztest_run_test_suite>:
}

#endif /* !KERNEL */

void z_ztest_run_test_suite(const char *name, struct unit_test *suite)
{
8000282c:	fa010113          	addi	sp,sp,-96
80002830:	04912a23          	sw	s1,84(sp)
	int fail = 0;

	if (test_status < 0) {
80002834:	800074b7          	lui	s1,0x80007
80002838:	e444a783          	lw	a5,-444(s1) # 80006e44 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006e45>
{
8000283c:	04112e23          	sw	ra,92(sp)
80002840:	04812c23          	sw	s0,88(sp)
80002844:	05212823          	sw	s2,80(sp)
80002848:	05312623          	sw	s3,76(sp)
8000284c:	05412423          	sw	s4,72(sp)
80002850:	05512223          	sw	s5,68(sp)
80002854:	05612023          	sw	s6,64(sp)
80002858:	03712e23          	sw	s7,60(sp)
8000285c:	03812c23          	sw	s8,56(sp)
80002860:	03912a23          	sw	s9,52(sp)
80002864:	03a12823          	sw	s10,48(sp)
80002868:	03b12623          	sw	s11,44(sp)
	if (test_status < 0) {
8000286c:	0807c463          	bltz	a5,800028f4 <z_ztest_run_test_suite+0xc8>
K_SYSCALL_DECLARE3_VOID(K_SYSCALL_K_SEM_INIT, k_sem_init, struct k_sem *, sem, unsigned int, initial_count, unsigned int, limit)
80002870:	80007437          	lui	s0,0x80007
80002874:	00100613          	li	a2,1
80002878:	00050993          	mv	s3,a0
8000287c:	00058c13          	mv	s8,a1
80002880:	fd440513          	addi	a0,s0,-44 # 80006fd4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006fd5>
80002884:	00000593          	li	a1,0
80002888:	689010ef          	jal	ra,80004710 <z_impl_k_sem_init>
		return;
	}

	init_testing();

	PRINT("Running test suite %s\n", name);
8000288c:	80007537          	lui	a0,0x80007
80002890:	00098593          	mv	a1,s3
80002894:	96450513          	addi	a0,a0,-1692 # 80006964 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006965>
80002898:	fd8ff0ef          	jal	ra,80002070 <printk>
	PRINT_LINE;
8000289c:	80007937          	lui	s2,0x80007
800028a0:	97c90513          	addi	a0,s2,-1668 # 8000697c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000697d>
		Z_TC_END_RESULT(ret, test->name);
800028a4:	80007ab7          	lui	s5,0x80007
	PRINT_LINE;
800028a8:	fc8ff0ef          	jal	ra,80002070 <printk>
800028ac:	e4448493          	addi	s1,s1,-444
	int fail = 0;
800028b0:	00000a13          	li	s4,0
800028b4:	00812e23          	sw	s0,28(sp)
K_SYSCALL_DECLARE10(K_SYSCALL_K_THREAD_CREATE, k_thread_create, k_tid_t, struct k_thread *, new_thread, k_thread_stack_t *, stack, size_t, stack_size, k_thread_entry_t, entry, void *, p1, void *, p2, void *, p3, int, prio, u32_t, options, s32_t, delay)
800028b8:	80008cb7          	lui	s9,0x80008
800028bc:	80007b37          	lui	s6,0x80007
800028c0:	80002d37          	lui	s10,0x80002
	if (test_result == -1) {
800028c4:	80007db7          	lui	s11,0x80007
800028c8:	80007bb7          	lui	s7,0x80007
		Z_TC_END_RESULT(ret, test->name);
800028cc:	91ca8a93          	addi	s5,s5,-1764 # 8000691c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000691d>
	while (suite->test) {
800028d0:	004c2783          	lw	a5,4(s8)
800028d4:	04079e63          	bnez	a5,80002930 <z_ztest_run_test_suite+0x104>
		if (fail && FAIL_FAST) {
			break;
		}
	}
	if (fail) {
		TC_PRINT("Test suite %s failed.\n", name);
800028d8:	00098593          	mv	a1,s3
	if (fail) {
800028dc:	100a0663          	beqz	s4,800029e8 <z_ztest_run_test_suite+0x1bc>
		TC_PRINT("Test suite %s failed.\n", name);
800028e0:	80007537          	lui	a0,0x80007
800028e4:	9ec50513          	addi	a0,a0,-1556 # 800069ec <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800069ed>
800028e8:	f88ff0ef          	jal	ra,80002070 <printk>
	} else {
		TC_PRINT("Test suite %s succeeded\n", name);
	}

	test_status = (test_status || fail) ? 1 : 0;
800028ec:	00100793          	li	a5,1
800028f0:	00f4a023          	sw	a5,0(s1)
}
800028f4:	05c12083          	lw	ra,92(sp)
800028f8:	05812403          	lw	s0,88(sp)
800028fc:	05412483          	lw	s1,84(sp)
80002900:	05012903          	lw	s2,80(sp)
80002904:	04c12983          	lw	s3,76(sp)
80002908:	04812a03          	lw	s4,72(sp)
8000290c:	04412a83          	lw	s5,68(sp)
80002910:	04012b03          	lw	s6,64(sp)
80002914:	03c12b83          	lw	s7,60(sp)
80002918:	03812c03          	lw	s8,56(sp)
8000291c:	03412c83          	lw	s9,52(sp)
80002920:	03012d03          	lw	s10,48(sp)
80002924:	02c12d83          	lw	s11,44(sp)
80002928:	06010113          	addi	sp,sp,96
8000292c:	00008067          	ret
	TC_START(test->name);
80002930:	000c2583          	lw	a1,0(s8)
80002934:	800077b7          	lui	a5,0x80007
80002938:	9c478513          	addi	a0,a5,-1596 # 800069c4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800069c5>
8000293c:	f34ff0ef          	jal	ra,80002070 <printk>
80002940:	00012223          	sw	zero,4(sp)
			test->thread_options | K_INHERIT_PERMS,	0);
80002944:	010c2783          	lw	a5,16(s8)
80002948:	000c0713          	mv	a4,s8
8000294c:	40000613          	li	a2,1024
80002950:	0087e793          	ori	a5,a5,8
80002954:	fff00893          	li	a7,-1
80002958:	00000813          	li	a6,0
8000295c:	770d0693          	addi	a3,s10,1904 # 80002770 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80002771>
80002960:	00f12023          	sw	a5,0(sp)
80002964:	d60c8593          	addi	a1,s9,-672 # 80007d60 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007d61>
80002968:	00000793          	li	a5,0
8000296c:	fe4b0513          	addi	a0,s6,-28 # 80006fe4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006fe5>
80002970:	40c020ef          	jal	ra,80004d7c <z_impl_k_thread_create>
K_SYSCALL_DECLARE2(K_SYSCALL_K_SEM_TAKE, k_sem_take, int, struct k_sem *, sem, s32_t, timeout)
80002974:	01c12783          	lw	a5,28(sp)
80002978:	fff00593          	li	a1,-1
8000297c:	fd478513          	addi	a0,a5,-44
80002980:	73d010ef          	jal	ra,800048bc <z_impl_k_sem_take>
	if (test_result == -1) {
80002984:	e40d8793          	addi	a5,s11,-448 # 80006e40 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006e41>
K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_THREAD_ABORT, k_thread_abort, k_tid_t, thread)
80002988:	fe4b0513          	addi	a0,s6,-28
8000298c:	0007a403          	lw	s0,0(a5)
80002990:	590020ef          	jal	ra,80004f20 <z_impl_k_thread_abort>
	if (test_result == -2) {
80002994:	800077b7          	lui	a5,0x80007
80002998:	e4078793          	addi	a5,a5,-448 # 80006e40 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006e41>
8000299c:	0007a703          	lw	a4,0(a5)
	if (test_result == -1) {
800029a0:	00140413          	addi	s0,s0,1
	if (test_result == -2) {
800029a4:	ffe00793          	li	a5,-2
	if (test_result == -1) {
800029a8:	00143413          	seqz	s0,s0
	if (test_result == -2) {
800029ac:	000c2603          	lw	a2,0(s8)
800029b0:	02f71463          	bne	a4,a5,800029d8 <z_ztest_run_test_suite+0x1ac>
		Z_TC_END_RESULT(TC_SKIP, test->name);
800029b4:	800075b7          	lui	a1,0x80007
800029b8:	9d858593          	addi	a1,a1,-1576 # 800069d8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800069d9>
		Z_TC_END_RESULT(ret, test->name);
800029bc:	9e0b8513          	addi	a0,s7,-1568 # 800069e0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800069e1>
800029c0:	eb0ff0ef          	jal	ra,80002070 <printk>
800029c4:	97c90513          	addi	a0,s2,-1668
800029c8:	ea8ff0ef          	jal	ra,80002070 <printk>
		fail += run_test(suite);
800029cc:	008a0a33          	add	s4,s4,s0
		suite++;
800029d0:	014c0c13          	addi	s8,s8,20
		if (fail && FAIL_FAST) {
800029d4:	efdff06f          	j	800028d0 <z_ztest_run_test_suite+0xa4>
		Z_TC_END_RESULT(ret, test->name);
800029d8:	00241793          	slli	a5,s0,0x2
800029dc:	00fa87b3          	add	a5,s5,a5
800029e0:	0007a583          	lw	a1,0(a5)
800029e4:	fd9ff06f          	j	800029bc <z_ztest_run_test_suite+0x190>
		TC_PRINT("Test suite %s succeeded\n", name);
800029e8:	80007537          	lui	a0,0x80007
800029ec:	a0450513          	addi	a0,a0,-1532 # 80006a04 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006a05>
800029f0:	e80ff0ef          	jal	ra,80002070 <printk>
	test_status = (test_status || fail) ? 1 : 0;
800029f4:	0004a783          	lw	a5,0(s1)
800029f8:	00f037b3          	snez	a5,a5
800029fc:	ef5ff06f          	j	800028f0 <z_ztest_run_test_suite+0xc4>

80002a00 <end_report>:

void end_report(void)
{
	if (test_status) {
80002a00:	800077b7          	lui	a5,0x80007
80002a04:	e447a783          	lw	a5,-444(a5) # 80006e44 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006e45>
{
80002a08:	ff010113          	addi	sp,sp,-16
80002a0c:	00812423          	sw	s0,8(sp)
80002a10:	80007537          	lui	a0,0x80007
80002a14:	00112623          	sw	ra,12(sp)
80002a18:	80007437          	lui	s0,0x80007
		TC_END_REPORT(TC_FAIL);
80002a1c:	97c50513          	addi	a0,a0,-1668 # 8000697c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000697d>
	if (test_status) {
80002a20:	02078263          	beqz	a5,80002a44 <end_report+0x44>
		TC_END_REPORT(TC_FAIL);
80002a24:	e4cff0ef          	jal	ra,80002070 <printk>
80002a28:	800075b7          	lui	a1,0x80007
80002a2c:	92858593          	addi	a1,a1,-1752 # 80006928 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006929>
	} else {
		TC_END_REPORT(TC_PASS);
80002a30:	93040513          	addi	a0,s0,-1744 # 80006930 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006931>
	}
}
80002a34:	00812403          	lw	s0,8(sp)
80002a38:	00c12083          	lw	ra,12(sp)
80002a3c:	01010113          	addi	sp,sp,16
		TC_END_REPORT(TC_PASS);
80002a40:	e30ff06f          	j	80002070 <printk>
80002a44:	e2cff0ef          	jal	ra,80002070 <printk>
80002a48:	800075b7          	lui	a1,0x80007
80002a4c:	94858593          	addi	a1,a1,-1720 # 80006948 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006949>
80002a50:	fe1ff06f          	j	80002a30 <end_report+0x30>

80002a54 <main>:

	return test_status;
}
#else
void main(void)
{
80002a54:	ff010113          	addi	sp,sp,-16
80002a58:	00112623          	sw	ra,12(sp)
	k_mem_domain_init(&ztest_mem_domain, ARRAY_SIZE(parts), parts);
	k_mem_domain_add_thread(&ztest_mem_domain, k_current_get());
#endif /* CONFIG_USERSPACE */

	z_init_mock();
	test_main();
80002a5c:	bc8fe0ef          	jal	ra,80000e24 <test_main>
	end_report();
}
80002a60:	00c12083          	lw	ra,12(sp)
80002a64:	01010113          	addi	sp,sp,16
	end_report();
80002a68:	f99ff06f          	j	80002a00 <end_report>

80002a6c <uart_vexriscv_sim_poll_out>:



static void uart_vexriscv_sim_poll_out(struct device *dev,
				       unsigned char c)
{
80002a6c:	ff010113          	addi	sp,sp,-16
	volatile int *uart = (int*)0xF0010000;
    volatile int i = 0;
80002a70:	00012623          	sw	zero,12(sp)
    i++;
80002a74:	00c12783          	lw	a5,12(sp)
80002a78:	00178793          	addi	a5,a5,1
80002a7c:	00f12623          	sw	a5,12(sp)
    uart[0] = c;
80002a80:	f00107b7          	lui	a5,0xf0010
80002a84:	00b7a023          	sw	a1,0(a5) # f0010000 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0xf0010001>
}
80002a88:	01010113          	addi	sp,sp,16
80002a8c:	00008067          	ret

80002a90 <uart_vexriscv_sim_poll_in>:

static int uart_vexriscv_sim_poll_in(struct device *dev, unsigned char *c)
{
	return -1;
}
80002a90:	fff00513          	li	a0,-1
80002a94:	00008067          	ret

80002a98 <uart_vexriscv_sim_init>:
static int uart_vexriscv_sim_init(struct device *dev)
{
	/* Nothing to do */

	return 0;
}
80002a98:	00000513          	li	a0,0
80002a9c:	00008067          	ret

80002aa0 <z_sys_device_do_config_level>:
		__device_APPLICATION_start,
		/* End marker */
		__device_init_end,
	};

	for (info = config_levels[level]; info < config_levels[level+1];
80002aa0:	00251713          	slli	a4,a0,0x2
80002aa4:	800077b7          	lui	a5,0x80007
80002aa8:	00150513          	addi	a0,a0,1
80002aac:	a3478793          	addi	a5,a5,-1484 # 80006a34 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006a35>
80002ab0:	00251513          	slli	a0,a0,0x2
{
80002ab4:	ff010113          	addi	sp,sp,-16
	for (info = config_levels[level]; info < config_levels[level+1];
80002ab8:	00e78733          	add	a4,a5,a4
80002abc:	00a787b3          	add	a5,a5,a0
{
80002ac0:	00812423          	sw	s0,8(sp)
80002ac4:	00912223          	sw	s1,4(sp)
	for (info = config_levels[level]; info < config_levels[level+1];
80002ac8:	00072403          	lw	s0,0(a4)
80002acc:	0007a483          	lw	s1,0(a5)
{
80002ad0:	00112623          	sw	ra,12(sp)
	for (info = config_levels[level]; info < config_levels[level+1];
80002ad4:	00946c63          	bltu	s0,s1,80002aec <z_sys_device_do_config_level+0x4c>
			info->driver_api = NULL;
		} else {
			z_object_init(info);
		}
	}
}
80002ad8:	00c12083          	lw	ra,12(sp)
80002adc:	00812403          	lw	s0,8(sp)
80002ae0:	00412483          	lw	s1,4(sp)
80002ae4:	01010113          	addi	sp,sp,16
80002ae8:	00008067          	ret
		retval = device_conf->init(info);
80002aec:	00042783          	lw	a5,0(s0)
80002af0:	00040513          	mv	a0,s0
80002af4:	0047a783          	lw	a5,4(a5)
80002af8:	000780e7          	jalr	a5
		if (retval != 0) {
80002afc:	00050463          	beqz	a0,80002b04 <z_sys_device_do_config_level+0x64>
			info->driver_api = NULL;
80002b00:	00042223          	sw	zero,4(s0)
								info++) {
80002b04:	00c40413          	addi	s0,s0,12
80002b08:	fcdff06f          	j	80002ad4 <z_sys_device_do_config_level+0x34>

80002b0c <z_impl_device_get_binding>:

struct device *z_impl_device_get_binding(const char *name)
{
80002b0c:	ff010113          	addi	sp,sp,-16
	/* Split the search into two loops: in the common scenario, where
	 * device names are stored in ROM (and are referenced by the user
	 * with CONFIG_* macros), only cheap pointer comparisons will be
	 * performed.  Reserve string comparisons for a fallback.
	 */
	for (info = __device_init_start; info != __device_init_end; info++) {
80002b10:	800077b7          	lui	a5,0x80007
{
80002b14:	00912223          	sw	s1,4(sp)
	for (info = __device_init_start; info != __device_init_end; info++) {
80002b18:	800074b7          	lui	s1,0x80007
{
80002b1c:	00812423          	sw	s0,8(sp)
80002b20:	00112623          	sw	ra,12(sp)
	for (info = __device_init_start; info != __device_init_end; info++) {
80002b24:	da078413          	addi	s0,a5,-608 # 80006da0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006da1>
{
80002b28:	01212023          	sw	s2,0(sp)
80002b2c:	da078793          	addi	a5,a5,-608
80002b30:	dd048493          	addi	s1,s1,-560 # 80006dd0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006dd1>
	for (info = __device_init_start; info != __device_init_end; info++) {
80002b34:	00941c63          	bne	s0,s1,80002b4c <z_impl_device_get_binding+0x40>
80002b38:	00050913          	mv	s2,a0
		    (info->config->name == name)) {
			return info;
		}
	}

	for (info = __device_init_start; info != __device_init_end; info++) {
80002b3c:	00078413          	mv	s0,a5
80002b40:	02941463          	bne	s0,s1,80002b68 <z_impl_device_get_binding+0x5c>
		if (strcmp(name, info->config->name) == 0) {
			return info;
		}
	}

	return NULL;
80002b44:	00000413          	li	s0,0
80002b48:	0440006f          	j	80002b8c <z_impl_device_get_binding+0x80>
		if ((info->driver_api != NULL) &&
80002b4c:	00442703          	lw	a4,4(s0)
80002b50:	00070863          	beqz	a4,80002b60 <z_impl_device_get_binding+0x54>
		    (info->config->name == name)) {
80002b54:	00042703          	lw	a4,0(s0)
		if ((info->driver_api != NULL) &&
80002b58:	00072703          	lw	a4,0(a4)
80002b5c:	02a70863          	beq	a4,a0,80002b8c <z_impl_device_get_binding+0x80>
	for (info = __device_init_start; info != __device_init_end; info++) {
80002b60:	00c40413          	addi	s0,s0,12
80002b64:	fd1ff06f          	j	80002b34 <z_impl_device_get_binding+0x28>
		if (info->driver_api == NULL) {
80002b68:	00442783          	lw	a5,4(s0)
80002b6c:	00079663          	bnez	a5,80002b78 <z_impl_device_get_binding+0x6c>
	for (info = __device_init_start; info != __device_init_end; info++) {
80002b70:	00c40413          	addi	s0,s0,12
80002b74:	fcdff06f          	j	80002b40 <z_impl_device_get_binding+0x34>
		if (strcmp(name, info->config->name) == 0) {
80002b78:	00042783          	lw	a5,0(s0)
80002b7c:	00090513          	mv	a0,s2
80002b80:	0007a583          	lw	a1,0(a5)
80002b84:	a9dff0ef          	jal	ra,80002620 <strcmp>
80002b88:	fe0514e3          	bnez	a0,80002b70 <z_impl_device_get_binding+0x64>
}
80002b8c:	00040513          	mv	a0,s0
80002b90:	00c12083          	lw	ra,12(sp)
80002b94:	00812403          	lw	s0,8(sp)
80002b98:	00412483          	lw	s1,4(sp)
80002b9c:	00012903          	lw	s2,0(sp)
80002ba0:	01010113          	addi	sp,sp,16
80002ba4:	00008067          	ret

80002ba8 <idle>:
#else
#define IDLE_YIELD_IF_COOP() do { } while (false)
#endif

void idle(void *unused1, void *unused2, void *unused3)
{
80002ba8:	ff010113          	addi	sp,sp,-16
80002bac:	00812423          	sw	s0,8(sp)
80002bb0:	00912223          	sw	s1,4(sp)
80002bb4:	00112623          	sw	ra,12(sp)
	__asm__ volatile ("csrrc %0, mstatus, %1"
80002bb8:	00800413          	li	s0,8
	z_set_timeout_expiry((ticks < IDLE_THRESH) ? 1 : ticks, true);
80002bbc:	00200493          	li	s1,2
80002bc0:	300437f3          	csrrc	a5,mstatus,s0
	s32_t ticks = z_get_next_timeout_expiry();
80002bc4:	0b5020ef          	jal	ra,80005478 <z_get_next_timeout_expiry>
	z_set_timeout_expiry((ticks < IDLE_THRESH) ? 1 : ticks, true);
80002bc8:	00a4c463          	blt	s1,a0,80002bd0 <idle+0x28>
80002bcc:	00100513          	li	a0,1
80002bd0:	00100593          	li	a1,1
80002bd4:	181020ef          	jal	ra,80005554 <z_set_timeout_expiry>
	k_cpu_idle();
80002bd8:	d08ff0ef          	jal	ra,800020e0 <k_cpu_idle>
80002bdc:	fe5ff06f          	j	80002bc0 <idle+0x18>

80002be0 <z_bss_zero>:
 *
 * @return N/A
 */
void z_bss_zero(void)
{
	(void)memset(&__bss_start, 0,
80002be0:	80007537          	lui	a0,0x80007
80002be4:	800077b7          	lui	a5,0x80007
80002be8:	e1850613          	addi	a2,a0,-488 # 80006e18 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006e19>
80002bec:	16078793          	addi	a5,a5,352 # 80007160 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007161>
80002bf0:	40c78633          	sub	a2,a5,a2
80002bf4:	00000593          	li	a1,0
80002bf8:	e1850513          	addi	a0,a0,-488
80002bfc:	ae1ff06f          	j	800026dc <memset>

80002c00 <bg_thread_main>:
 * init functions, then invokes application's main() routine.
 *
 * @return N/A
 */
static void bg_thread_main(void *unused1, void *unused2, void *unused3)
{
80002c00:	ff010113          	addi	sp,sp,-16
	static const unsigned int boot_delay = CONFIG_BOOT_DELAY;
#else
	static const unsigned int boot_delay;
#endif

	z_sys_device_do_config_level(_SYS_INIT_LEVEL_POST_KERNEL);
80002c04:	00200513          	li	a0,2
{
80002c08:	00112623          	sw	ra,12(sp)
	z_sys_device_do_config_level(_SYS_INIT_LEVEL_POST_KERNEL);
80002c0c:	e95ff0ef          	jal	ra,80002aa0 <z_sys_device_do_config_level>
	if (boot_delay > 0 && IS_ENABLED(CONFIG_MULTITHREADING)) {
		printk("***** delaying boot " STRINGIFY(CONFIG_BOOT_DELAY)
		       "ms (per build configuration) *****\n");
		k_busy_wait(CONFIG_BOOT_DELAY * USEC_PER_MSEC);
	}
	PRINT_BOOT_BANNER();
80002c10:	80007537          	lui	a0,0x80007
80002c14:	a4850513          	addi	a0,a0,-1464 # 80006a48 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006a49>
80002c18:	c58ff0ef          	jal	ra,80002070 <printk>

	/* Final init level before app starts */
	z_sys_device_do_config_level(_SYS_INIT_LEVEL_APPLICATION);
80002c1c:	00300513          	li	a0,3
80002c20:	e81ff0ef          	jal	ra,80002aa0 <z_sys_device_do_config_level>
	extern void __do_init_array_aux(void);
	__do_global_ctors_aux();
	__do_init_array_aux();
#endif

	z_init_static_threads();
80002c24:	24c020ef          	jal	ra,80004e70 <z_init_static_threads>
	__main_time_stamp = (u64_t)k_cycle_get_32();
#endif

	extern void main(void);

	main();
80002c28:	e2dff0ef          	jal	ra,80002a54 <main>

	/* Dump coverage data once the main() has exited. */
	gcov_coverage_dump();

	/* Terminate thread normally since it has no more work to do */
	_main_thread->base.user_options &= ~K_ESSENTIAL;
80002c2c:	800077b7          	lui	a5,0x80007
80002c30:	0c478793          	addi	a5,a5,196 # 800070c4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800070c5>
80002c34:	00c7c703          	lbu	a4,12(a5)
80002c38:	ffe77713          	andi	a4,a4,-2
80002c3c:	00e78623          	sb	a4,12(a5)
}
80002c40:	00c12083          	lw	ra,12(sp)
80002c44:	01010113          	addi	sp,sp,16
80002c48:	00008067          	ret

80002c4c <z_cstart>:
 * cleared/zeroed.
 *
 * @return Does not return
 */
FUNC_NORETURN void z_cstart(void)
{
80002c4c:	f6010113          	addi	sp,sp,-160
80002c50:	08812c23          	sw	s0,152(sp)
void k_cpu_idle(void);
void k_cpu_atomic_idle(unsigned int key);

static ALWAYS_INLINE void kernel_arch_init(void)
{
	_kernel.irq_stack =
80002c54:	800097b7          	lui	a5,0x80009
80002c58:	80007437          	lui	s0,0x80007
80002c5c:	09312623          	sw	s3,140(sp)
80002c60:	d6078793          	addi	a5,a5,-672 # 80008d60 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80008d61>
80002c64:	13440993          	addi	s3,s0,308 # 80007134 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007135>
80002c68:	00f9a223          	sw	a5,4(s3)

	/* perform any architecture-specific initialization */
	kernel_arch_init();

#ifdef CONFIG_MULTITHREADING
	struct k_thread dummy_thread = {
80002c6c:	01010793          	addi	a5,sp,16
80002c70:	07000613          	li	a2,112
80002c74:	00000593          	li	a1,0
80002c78:	00078513          	mv	a0,a5
{
80002c7c:	08112e23          	sw	ra,156(sp)
80002c80:	08912a23          	sw	s1,148(sp)
80002c84:	09212823          	sw	s2,144(sp)
	struct k_thread dummy_thread = {
80002c88:	a55ff0ef          	jal	ra,800026dc <memset>
80002c8c:	00100713          	li	a4,1
# ifdef CONFIG_SCHED_CPU_MASK
		 .base.cpu_mask = -1,
# endif
	};

	_current = &dummy_thread;
80002c90:	00a9a423          	sw	a0,8(s3)
#ifdef CONFIG_USERSPACE
	z_app_shmem_bss_zero();
#endif

	/* perform basic hardware initialization */
	z_sys_device_do_config_level(_SYS_INIT_LEVEL_PRE_KERNEL_1);
80002c94:	00000513          	li	a0,0
	struct k_thread dummy_thread = {
80002c98:	00e10ea3          	sb	a4,29(sp)
	z_sys_device_do_config_level(_SYS_INIT_LEVEL_PRE_KERNEL_1);
80002c9c:	e05ff0ef          	jal	ra,80002aa0 <z_sys_device_do_config_level>
	z_sys_device_do_config_level(_SYS_INIT_LEVEL_PRE_KERNEL_2);
80002ca0:	00100513          	li	a0,1
80002ca4:	dfdff0ef          	jal	ra,80002aa0 <z_sys_device_do_config_level>
	dummy_thread->base.user_options = K_ESSENTIAL;
80002ca8:	10100793          	li	a5,257
80002cac:	00f11e23          	sh	a5,28(sp)
	z_sched_init();
80002cb0:	03d010ef          	jal	ra,800044ec <z_sched_init>
	z_setup_new_thread(_main_thread, _main_stack,
80002cb4:	800077b7          	lui	a5,0x80007
80002cb8:	a8c78793          	addi	a5,a5,-1396 # 80006a8c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006a8d>
	_kernel.ready_q.cache = _main_thread;
80002cbc:	80007937          	lui	s2,0x80007
	z_setup_new_thread(_main_thread, _main_stack,
80002cc0:	00f12223          	sw	a5,4(sp)
80002cc4:	800036b7          	lui	a3,0x80003
80002cc8:	00100793          	li	a5,1
80002ccc:	800085b7          	lui	a1,0x80008
	_kernel.ready_q.cache = _main_thread;
80002cd0:	0c490493          	addi	s1,s2,196 # 800070c4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800070c5>
	z_setup_new_thread(_main_thread, _main_stack,
80002cd4:	00f12023          	sw	a5,0(sp)
80002cd8:	00000713          	li	a4,0
80002cdc:	00000793          	li	a5,0
80002ce0:	00000893          	li	a7,0
80002ce4:	00000813          	li	a6,0
80002ce8:	c0068693          	addi	a3,a3,-1024 # 80002c00 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80002c01>
80002cec:	20000613          	li	a2,512
80002cf0:	16058593          	addi	a1,a1,352 # 80008160 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80008161>
80002cf4:	0c490513          	addi	a0,s2,196
	_kernel.ready_q.cache = _main_thread;
80002cf8:	0299a023          	sw	s1,32(s3)
	z_setup_new_thread(_main_thread, _main_stack,
80002cfc:	5d1010ef          	jal	ra,80004acc <z_setup_new_thread>
	thread->base.thread_state &= ~_THREAD_SUSPENDED;
}

static inline void z_mark_thread_as_started(struct k_thread *thread)
{
	thread->base.thread_state &= ~_THREAD_PRESTART;
80002d00:	00d4c783          	lbu	a5,13(s1)
80002d04:	13440413          	addi	s0,s0,308
80002d08:	ffb7f713          	andi	a4,a5,-5
80002d0c:	00e486a3          	sb	a4,13(s1)
	return !((z_is_thread_prevented_from_running(thread)) != 0 ||
80002d10:	01b7f793          	andi	a5,a5,27
80002d14:	00079a63          	bnez	a5,80002d28 <z_cstart+0xdc>
	return true;
}

static ALWAYS_INLINE void z_ready_thread(struct k_thread *thread)
{
	if (z_is_thread_ready(thread)) {
80002d18:	0184a783          	lw	a5,24(s1)
80002d1c:	00079663          	bnez	a5,80002d28 <z_cstart+0xdc>
		z_add_thread_to_ready_q(thread);
80002d20:	0c490513          	addi	a0,s2,196
80002d24:	5a9000ef          	jal	ra,80003acc <z_add_thread_to_ready_q>
	z_setup_new_thread(thr, stack,
80002d28:	800077b7          	lui	a5,0x80007
80002d2c:	a9478793          	addi	a5,a5,-1388 # 80006a94 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006a95>
80002d30:	00f12223          	sw	a5,4(sp)
80002d34:	80007537          	lui	a0,0x80007
80002d38:	00100793          	li	a5,1
80002d3c:	800036b7          	lui	a3,0x80003
80002d40:	800085b7          	lui	a1,0x80008
80002d44:	05450493          	addi	s1,a0,84 # 80007054 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007055>
80002d48:	00f12023          	sw	a5,0(sp)
80002d4c:	00f00893          	li	a7,15
80002d50:	00000813          	li	a6,0
80002d54:	00000793          	li	a5,0
80002d58:	00000713          	li	a4,0
80002d5c:	ba868693          	addi	a3,a3,-1112 # 80002ba8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80002ba9>
80002d60:	20000613          	li	a2,512
80002d64:	36058593          	addi	a1,a1,864 # 80008360 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80008361>
80002d68:	05450513          	addi	a0,a0,84
80002d6c:	561010ef          	jal	ra,80004acc <z_setup_new_thread>
	thread->base.thread_state &= ~_THREAD_PRESTART;
80002d70:	00d4c783          	lbu	a5,13(s1)
	_kernel.cpus[0].idle_thread = _idle_thread;
80002d74:	00942623          	sw	s1,12(s0)
80002d78:	00800513          	li	a0,8
80002d7c:	ffb7f793          	andi	a5,a5,-5
80002d80:	00f486a3          	sb	a5,13(s1)
	list->head = (sys_dnode_t *)list;
80002d84:	800077b7          	lui	a5,0x80007
80002d88:	14c78793          	addi	a5,a5,332 # 8000714c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000714d>
80002d8c:	00f42c23          	sw	a5,24(s0)
	list->tail = (sys_dnode_t *)list;
80002d90:	00f42e23          	sw	a5,28(s0)
80002d94:	30053573          	csrrc	a0,mstatus,a0
#ifndef CONFIG_ARM
#ifdef CONFIG_TRACING
	sys_trace_thread_switched_out();
#endif
#endif
	ret = __swap(key);
80002d98:	00857513          	andi	a0,a0,8
80002d9c:	c8cfd0ef          	jal	ra,80000228 <__swap>

80002da0 <prepare_thread_to_run>:
	return !((z_is_thread_prevented_from_running(thread)) != 0 ||
80002da0:	00d54783          	lbu	a5,13(a0)
}
#endif

#if !defined(CONFIG_POLL)
static void prepare_thread_to_run(struct k_thread *thread, void *data)
{
80002da4:	fe010113          	addi	sp,sp,-32
80002da8:	00812c23          	sw	s0,24(sp)
80002dac:	00112e23          	sw	ra,28(sp)
80002db0:	01f7f793          	andi	a5,a5,31
80002db4:	00050413          	mv	s0,a0
80002db8:	00079c63          	bnez	a5,80002dd0 <prepare_thread_to_run+0x30>
	if (z_is_thread_ready(thread)) {
80002dbc:	01852783          	lw	a5,24(a0)
80002dc0:	00079863          	bnez	a5,80002dd0 <prepare_thread_to_run+0x30>
80002dc4:	00b12623          	sw	a1,12(sp)
		z_add_thread_to_ready_q(thread);
80002dc8:	505000ef          	jal	ra,80003acc <z_add_thread_to_ready_q>
80002dcc:	00c12583          	lw	a1,12(sp)
}

static ALWAYS_INLINE void
z_set_thread_return_value(struct k_thread *thread, unsigned int value)
{
	thread->arch.swap_return_value = value;
80002dd0:	06042623          	sw	zero,108(s0)
	thread->base.swap_data = data;
80002dd4:	00b42a23          	sw	a1,20(s0)
	z_ready_thread(thread);
	z_set_thread_return_value_with_data(thread, 0, data);
}
80002dd8:	01c12083          	lw	ra,28(sp)
80002ddc:	01812403          	lw	s0,24(sp)
80002de0:	02010113          	addi	sp,sp,32
80002de4:	00008067          	ret

80002de8 <queue_insert>:
			       struct k_queue *);
#endif

static s32_t queue_insert(struct k_queue *queue, void *prev, void *data,
			  bool alloc)
{
80002de8:	fe010113          	addi	sp,sp,-32
80002dec:	00812c23          	sw	s0,24(sp)
80002df0:	00912a23          	sw	s1,20(sp)
80002df4:	01212823          	sw	s2,16(sp)
80002df8:	01312623          	sw	s3,12(sp)
80002dfc:	01412423          	sw	s4,8(sp)
80002e00:	01612023          	sw	s6,0(sp)
80002e04:	00112e23          	sw	ra,28(sp)
80002e08:	01512223          	sw	s5,4(sp)
80002e0c:	00050413          	mv	s0,a0
80002e10:	00058993          	mv	s3,a1
80002e14:	00060a13          	mv	s4,a2
80002e18:	00068b13          	mv	s6,a3
	k_spinlock_key_t key = k_spin_lock(&queue->lock);
80002e1c:	00850913          	addi	s2,a0,8
80002e20:	00800493          	li	s1,8
80002e24:	3004b4f3          	csrrc	s1,mstatus,s1
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80002e28:	00090513          	mv	a0,s2
	key = (mstatus & SOC_MSTATUS_IEN);
80002e2c:	0084f493          	andi	s1,s1,8
80002e30:	569010ef          	jal	ra,80004b98 <z_spin_lock_valid>
80002e34:	02051e63          	bnez	a0,80002e70 <queue_insert+0x88>
80002e38:	80007ab7          	lui	s5,0x80007
80002e3c:	800075b7          	lui	a1,0x80007
80002e40:	80006537          	lui	a0,0x80006
80002e44:	8c058593          	addi	a1,a1,-1856 # 800068c0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800068c1>
80002e48:	04e00693          	li	a3,78
80002e4c:	8a8a8613          	addi	a2,s5,-1880 # 800068a8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800068a9>
80002e50:	7dc50513          	addi	a0,a0,2012 # 800067dc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800067dd>
80002e54:	a1cff0ef          	jal	ra,80002070 <printk>
80002e58:	80007537          	lui	a0,0x80007
80002e5c:	8d850513          	addi	a0,a0,-1832 # 800068d8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800068d9>
80002e60:	a10ff0ef          	jal	ra,80002070 <printk>
80002e64:	04e00593          	li	a1,78
80002e68:	8a8a8513          	addi	a0,s5,-1880
80002e6c:	a40ff0ef          	jal	ra,800020ac <assert_post_action>
	z_spin_lock_set_owner(l);
80002e70:	00090513          	mv	a0,s2
80002e74:	57d010ef          	jal	ra,80004bf0 <z_spin_lock_set_owner>
#if !defined(CONFIG_POLL)
	struct k_thread *first_pending_thread;

	first_pending_thread = z_unpend_first_thread(&queue->wait_q);
80002e78:	00c40513          	addi	a0,s0,12
80002e7c:	450010ef          	jal	ra,800042cc <z_unpend_first_thread>

	if (first_pending_thread != NULL) {
80002e80:	02050063          	beqz	a0,80002ea0 <queue_insert+0xb8>
		prepare_thread_to_run(first_pending_thread, data);
80002e84:	000a0593          	mv	a1,s4
80002e88:	f19ff0ef          	jal	ra,80002da0 <prepare_thread_to_run>

#if defined(CONFIG_POLL)
	handle_poll_events(queue, K_POLL_STATE_DATA_AVAILABLE);
#endif /* CONFIG_POLL */

	z_reschedule(&queue->lock, key);
80002e8c:	00090513          	mv	a0,s2
80002e90:	00048593          	mv	a1,s1
80002e94:	5ec000ef          	jal	ra,80003480 <z_reschedule>
	return 0;
80002e98:	00000513          	li	a0,0
80002e9c:	0600006f          	j	80002efc <queue_insert+0x114>
	if (alloc) {
80002ea0:	0a0b0e63          	beqz	s6,80002f5c <queue_insert+0x174>
		anode = z_thread_malloc(sizeof(*anode));
80002ea4:	00800513          	li	a0,8
80002ea8:	10c030ef          	jal	ra,80005fb4 <z_thread_malloc>
		if (anode == NULL) {
80002eac:	06051c63          	bnez	a0,80002f24 <queue_insert+0x13c>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80002eb0:	00090513          	mv	a0,s2
80002eb4:	50d010ef          	jal	ra,80004bc0 <z_spin_unlock_valid>
80002eb8:	02051e63          	bnez	a0,80002ef4 <queue_insert+0x10c>
80002ebc:	80007437          	lui	s0,0x80007
80002ec0:	800075b7          	lui	a1,0x80007
80002ec4:	80006537          	lui	a0,0x80006
80002ec8:	8f058593          	addi	a1,a1,-1808 # 800068f0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800068f1>
80002ecc:	06100693          	li	a3,97
80002ed0:	8a840613          	addi	a2,s0,-1880 # 800068a8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800068a9>
80002ed4:	7dc50513          	addi	a0,a0,2012 # 800067dc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800067dd>
80002ed8:	998ff0ef          	jal	ra,80002070 <printk>
80002edc:	80007537          	lui	a0,0x80007
80002ee0:	90850513          	addi	a0,a0,-1784 # 80006908 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006909>
80002ee4:	98cff0ef          	jal	ra,80002070 <printk>
80002ee8:	06100593          	li	a1,97
80002eec:	8a840513          	addi	a0,s0,-1880
80002ef0:	9bcff0ef          	jal	ra,800020ac <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80002ef4:	3004a4f3          	csrrs	s1,mstatus,s1
			return -ENOMEM;
80002ef8:	ff400513          	li	a0,-12
}
80002efc:	01c12083          	lw	ra,28(sp)
80002f00:	01812403          	lw	s0,24(sp)
80002f04:	01412483          	lw	s1,20(sp)
80002f08:	01012903          	lw	s2,16(sp)
80002f0c:	00c12983          	lw	s3,12(sp)
80002f10:	00812a03          	lw	s4,8(sp)
80002f14:	00412a83          	lw	s5,4(sp)
80002f18:	00012b03          	lw	s6,0(sp)
80002f1c:	02010113          	addi	sp,sp,32
80002f20:	00008067          	ret
 * @param flags A value between 0 and 3 to set the flags value
 */
static inline void sys_sfnode_init(sys_sfnode_t *node, u8_t flags)
{
	__ASSERT((flags & ~SYS_SFLIST_FLAGS_MASK) == 0U, "flags too large");
	node->next_and_flags = flags;
80002f24:	00100793          	li	a5,1
		anode->data = data;
80002f28:	01452223          	sw	s4,4(a0)
80002f2c:	00f52023          	sw	a5,0(a0)
 */
static inline void sys_sflist_insert(sys_sflist_t *list,
				     sys_sfnode_t *prev,
				     sys_sfnode_t *node);

Z_GENLIST_INSERT(sflist, sfnode)
80002f30:	00052783          	lw	a5,0(a0)
80002f34:	0037f793          	andi	a5,a5,3
80002f38:	02099863          	bnez	s3,80002f68 <queue_insert+0x180>
	parent->next_and_flags = cur_flags | (unative_t)child;
80002f3c:	00042703          	lw	a4,0(s0)
80002f40:	00f767b3          	or	a5,a4,a5
80002f44:	00f52023          	sw	a5,0(a0)
Z_GENLIST_PREPEND(sflist, sfnode)
80002f48:	00442783          	lw	a5,4(s0)
	list->head = node;
80002f4c:	00a42023          	sw	a0,0(s0)
Z_GENLIST_PREPEND(sflist, sfnode)
80002f50:	f2079ee3          	bnez	a5,80002e8c <queue_insert+0xa4>
	list->tail = node;
80002f54:	00a42223          	sw	a0,4(s0)
80002f58:	f35ff06f          	j	80002e8c <queue_insert+0xa4>
	node->next_and_flags = flags;
80002f5c:	000a2023          	sw	zero,0(s4)
80002f60:	000a0513          	mv	a0,s4
80002f64:	fcdff06f          	j	80002f30 <queue_insert+0x148>
	return (sys_sfnode_t *)(node->next_and_flags & ~SYS_SFLIST_FLAGS_MASK);
80002f68:	0009a703          	lw	a4,0(s3)
80002f6c:	ffc77713          	andi	a4,a4,-4
Z_GENLIST_INSERT(sflist, sfnode)
80002f70:	02071863          	bnez	a4,80002fa0 <queue_insert+0x1b8>
Z_GENLIST_APPEND(sflist, sfnode)
80002f74:	00442703          	lw	a4,4(s0)
	parent->next_and_flags = cur_flags | (unative_t)child;
80002f78:	00f52023          	sw	a5,0(a0)
Z_GENLIST_APPEND(sflist, sfnode)
80002f7c:	00071863          	bnez	a4,80002f8c <queue_insert+0x1a4>
	list->tail = node;
80002f80:	00a42223          	sw	a0,4(s0)
	list->head = node;
80002f84:	00a42023          	sw	a0,0(s0)
80002f88:	f05ff06f          	j	80002e8c <queue_insert+0xa4>
	return node->next_and_flags & SYS_SFLIST_FLAGS_MASK;
80002f8c:	00072783          	lw	a5,0(a4)
	parent->next_and_flags = cur_flags | (unative_t)child;
80002f90:	0037f793          	andi	a5,a5,3
80002f94:	00f567b3          	or	a5,a0,a5
80002f98:	00f72023          	sw	a5,0(a4)
80002f9c:	fb9ff06f          	j	80002f54 <queue_insert+0x16c>
80002fa0:	00e7e7b3          	or	a5,a5,a4
80002fa4:	00f52023          	sw	a5,0(a0)
	return node->next_and_flags & SYS_SFLIST_FLAGS_MASK;
80002fa8:	0009a783          	lw	a5,0(s3)
	parent->next_and_flags = cur_flags | (unative_t)child;
80002fac:	0037f793          	andi	a5,a5,3
80002fb0:	00f56533          	or	a0,a0,a5
80002fb4:	00a9a023          	sw	a0,0(s3)
80002fb8:	ed5ff06f          	j	80002e8c <queue_insert+0xa4>

80002fbc <z_queue_node_peek>:
{
80002fbc:	ff010113          	addi	sp,sp,-16
80002fc0:	00812423          	sw	s0,8(sp)
80002fc4:	00112623          	sw	ra,12(sp)
80002fc8:	00050413          	mv	s0,a0
	if ((node != NULL) && (sys_sfnode_flags_get(node) != (u8_t)0)) {
80002fcc:	00050e63          	beqz	a0,80002fe8 <z_queue_node_peek+0x2c>
	return node->next_and_flags & SYS_SFLIST_FLAGS_MASK;
80002fd0:	00052783          	lw	a5,0(a0)
80002fd4:	0037f793          	andi	a5,a5,3
80002fd8:	00078863          	beqz	a5,80002fe8 <z_queue_node_peek+0x2c>
		ret = anode->data;
80002fdc:	00452403          	lw	s0,4(a0)
		if (needs_free) {
80002fe0:	00058463          	beqz	a1,80002fe8 <z_queue_node_peek+0x2c>
			k_free(anode);
80002fe4:	7c1020ef          	jal	ra,80005fa4 <k_free>
}
80002fe8:	00040513          	mv	a0,s0
80002fec:	00c12083          	lw	ra,12(sp)
80002ff0:	00812403          	lw	s0,8(sp)
80002ff4:	01010113          	addi	sp,sp,16
80002ff8:	00008067          	ret

80002ffc <z_impl_k_queue_init>:
	SYS_DLIST_FOR_EACH_CONTAINER(&((wq)->waitq), thread_ptr, \
				     base.qnode_dlist)

static inline void z_waitq_init(_wait_q_t *w)
{
	sys_dlist_init(&w->waitq);
80002ffc:	00c50793          	addi	a5,a0,12
	list->head = NULL;
80003000:	00052023          	sw	zero,0(a0)
	list->tail = NULL;
80003004:	00052223          	sw	zero,4(a0)
	queue->lock = (struct k_spinlock) {};
80003008:	00052423          	sw	zero,8(a0)
	list->head = (sys_dnode_t *)list;
8000300c:	00f52623          	sw	a5,12(a0)
	list->tail = (sys_dnode_t *)list;
80003010:	00f52823          	sw	a5,16(a0)
}
80003014:	00008067          	ret

80003018 <k_queue_append>:
	(void)queue_insert(queue, prev, data, false);
}

void k_queue_append(struct k_queue *queue, void *data)
{
	(void)queue_insert(queue, sys_sflist_peek_tail(&queue->data_q),
80003018:	00058613          	mv	a2,a1
8000301c:	00452583          	lw	a1,4(a0)
80003020:	00000693          	li	a3,0
80003024:	dc5ff06f          	j	80002de8 <queue_insert>

80003028 <z_impl_k_queue_get>:
	return val;
}
#endif /* CONFIG_POLL */

void *z_impl_k_queue_get(struct k_queue *queue, s32_t timeout)
{
80003028:	fe010113          	addi	sp,sp,-32
8000302c:	00812c23          	sw	s0,24(sp)
80003030:	00912a23          	sw	s1,20(sp)
80003034:	01212823          	sw	s2,16(sp)
80003038:	01312623          	sw	s3,12(sp)
8000303c:	00112e23          	sw	ra,28(sp)
80003040:	01412423          	sw	s4,8(sp)
80003044:	00050493          	mv	s1,a0
80003048:	00058993          	mv	s3,a1
	k_spinlock_key_t key = k_spin_lock(&queue->lock);
8000304c:	00850913          	addi	s2,a0,8
	__asm__ volatile ("csrrc %0, mstatus, %1"
80003050:	00800413          	li	s0,8
80003054:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80003058:	00090513          	mv	a0,s2
	key = (mstatus & SOC_MSTATUS_IEN);
8000305c:	00847413          	andi	s0,s0,8
80003060:	339010ef          	jal	ra,80004b98 <z_spin_lock_valid>
80003064:	02051e63          	bnez	a0,800030a0 <z_impl_k_queue_get+0x78>
80003068:	80007a37          	lui	s4,0x80007
8000306c:	800075b7          	lui	a1,0x80007
80003070:	80006537          	lui	a0,0x80006
80003074:	8c058593          	addi	a1,a1,-1856 # 800068c0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800068c1>
80003078:	04e00693          	li	a3,78
8000307c:	8a8a0613          	addi	a2,s4,-1880 # 800068a8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800068a9>
80003080:	7dc50513          	addi	a0,a0,2012 # 800067dc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800067dd>
80003084:	fedfe0ef          	jal	ra,80002070 <printk>
80003088:	80007537          	lui	a0,0x80007
8000308c:	8d850513          	addi	a0,a0,-1832 # 800068d8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800068d9>
80003090:	fe1fe0ef          	jal	ra,80002070 <printk>
80003094:	04e00593          	li	a1,78
80003098:	8a8a0513          	addi	a0,s4,-1880
8000309c:	810ff0ef          	jal	ra,800020ac <assert_post_action>
	z_spin_lock_set_owner(l);
800030a0:	00090513          	mv	a0,s2
800030a4:	34d010ef          	jal	ra,80004bf0 <z_spin_lock_set_owner>
Z_GENLIST_IS_EMPTY(sflist)
800030a8:	0004a503          	lw	a0,0(s1)
	void *data;

	if (likely(!sys_sflist_is_empty(&queue->data_q))) {
800030ac:	08050a63          	beqz	a0,80003140 <z_impl_k_queue_get+0x118>
	return (sys_sfnode_t *)(node->next_and_flags & ~SYS_SFLIST_FLAGS_MASK);
800030b0:	00052783          	lw	a5,0(a0)
 *
 * @return A pointer to the first node of the list
 */
static inline sys_sfnode_t *sys_sflist_get_not_empty(sys_sflist_t *list);

Z_GENLIST_GET_NOT_EMPTY(sflist, sfnode)
800030b4:	0044a703          	lw	a4,4(s1)
	return (sys_sfnode_t *)(node->next_and_flags & ~SYS_SFLIST_FLAGS_MASK);
800030b8:	ffc7f793          	andi	a5,a5,-4
	list->head = node;
800030bc:	00f4a023          	sw	a5,0(s1)
Z_GENLIST_GET_NOT_EMPTY(sflist, sfnode)
800030c0:	00e51463          	bne	a0,a4,800030c8 <z_impl_k_queue_get+0xa0>
	list->tail = node;
800030c4:	00f4a223          	sw	a5,4(s1)
		sys_sfnode_t *node;

		node = sys_sflist_get_not_empty(&queue->data_q);
		data = z_queue_node_peek(node, true);
800030c8:	00100593          	li	a1,1
800030cc:	ef1ff0ef          	jal	ra,80002fbc <z_queue_node_peek>
800030d0:	00050493          	mv	s1,a0
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
800030d4:	00090513          	mv	a0,s2
800030d8:	2e9010ef          	jal	ra,80004bc0 <z_spin_unlock_valid>
800030dc:	02051e63          	bnez	a0,80003118 <z_impl_k_queue_get+0xf0>
800030e0:	80007937          	lui	s2,0x80007
800030e4:	800075b7          	lui	a1,0x80007
800030e8:	80006537          	lui	a0,0x80006
800030ec:	8f058593          	addi	a1,a1,-1808 # 800068f0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800068f1>
800030f0:	06100693          	li	a3,97
800030f4:	8a890613          	addi	a2,s2,-1880 # 800068a8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800068a9>
800030f8:	7dc50513          	addi	a0,a0,2012 # 800067dc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800067dd>
800030fc:	f75fe0ef          	jal	ra,80002070 <printk>
80003100:	80007537          	lui	a0,0x80007
80003104:	90850513          	addi	a0,a0,-1784 # 80006908 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006909>
80003108:	f69fe0ef          	jal	ra,80002070 <printk>
8000310c:	06100593          	li	a1,97
80003110:	8a890513          	addi	a0,s2,-1880
80003114:	f99fe0ef          	jal	ra,800020ac <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80003118:	30042473          	csrrs	s0,mstatus,s0
#else
	int ret = z_pend_curr(&queue->lock, key, &queue->wait_q, timeout);

	return (ret != 0) ? NULL : _current->base.swap_data;
#endif /* CONFIG_POLL */
}
8000311c:	01c12083          	lw	ra,28(sp)
80003120:	01812403          	lw	s0,24(sp)
80003124:	00048513          	mv	a0,s1
80003128:	01012903          	lw	s2,16(sp)
8000312c:	01412483          	lw	s1,20(sp)
80003130:	00c12983          	lw	s3,12(sp)
80003134:	00812a03          	lw	s4,8(sp)
80003138:	02010113          	addi	sp,sp,32
8000313c:	00008067          	ret
	if (timeout == K_NO_WAIT) {
80003140:	04099a63          	bnez	s3,80003194 <z_impl_k_queue_get+0x16c>
80003144:	00090513          	mv	a0,s2
80003148:	279010ef          	jal	ra,80004bc0 <z_spin_unlock_valid>
8000314c:	02051e63          	bnez	a0,80003188 <z_impl_k_queue_get+0x160>
80003150:	800074b7          	lui	s1,0x80007
80003154:	800075b7          	lui	a1,0x80007
80003158:	80006537          	lui	a0,0x80006
8000315c:	8f058593          	addi	a1,a1,-1808 # 800068f0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800068f1>
80003160:	06100693          	li	a3,97
80003164:	8a848613          	addi	a2,s1,-1880 # 800068a8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800068a9>
80003168:	7dc50513          	addi	a0,a0,2012 # 800067dc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800067dd>
8000316c:	f05fe0ef          	jal	ra,80002070 <printk>
80003170:	80007537          	lui	a0,0x80007
80003174:	90850513          	addi	a0,a0,-1784 # 80006908 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006909>
80003178:	ef9fe0ef          	jal	ra,80002070 <printk>
8000317c:	06100593          	li	a1,97
80003180:	8a848513          	addi	a0,s1,-1880
80003184:	f29fe0ef          	jal	ra,800020ac <assert_post_action>
80003188:	30042473          	csrrs	s0,mstatus,s0
		return NULL;
8000318c:	00000493          	li	s1,0
80003190:	f8dff06f          	j	8000311c <z_impl_k_queue_get+0xf4>
	int ret = z_pend_curr(&queue->lock, key, &queue->wait_q, timeout);
80003194:	00c48613          	addi	a2,s1,12
80003198:	00098693          	mv	a3,s3
8000319c:	00040593          	mv	a1,s0
800031a0:	00090513          	mv	a0,s2
800031a4:	0a0010ef          	jal	ra,80004244 <z_pend_curr>
	return (ret != 0) ? NULL : _current->base.swap_data;
800031a8:	00000493          	li	s1,0
800031ac:	f60518e3          	bnez	a0,8000311c <z_impl_k_queue_get+0xf4>
800031b0:	800077b7          	lui	a5,0x80007
800031b4:	13c7a783          	lw	a5,316(a5) # 8000713c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000713d>
800031b8:	0147a483          	lw	s1,20(a5)
800031bc:	f61ff06f          	j	8000311c <z_impl_k_queue_get+0xf4>

800031c0 <z_is_thread_ready>:
	return !((z_is_thread_prevented_from_running(thread)) != 0 ||
800031c0:	00d54783          	lbu	a5,13(a0)
800031c4:	01f7f793          	andi	a5,a5,31
800031c8:	00079863          	bnez	a5,800031d8 <z_is_thread_ready+0x18>
800031cc:	01852503          	lw	a0,24(a0)
800031d0:	00153513          	seqz	a0,a0
800031d4:	00008067          	ret
800031d8:	00000513          	li	a0,0
}
800031dc:	00008067          	ret

800031e0 <reset_time_slice>:
 */
static struct k_thread *pending_current;
#endif

static void reset_time_slice(void)
{
800031e0:	ff010113          	addi	sp,sp,-16
800031e4:	00112623          	sw	ra,12(sp)
	/* Add the elapsed time since the last announced tick to the
	 * slice count, as we'll see those "expired" ticks arrive in a
	 * FUTURE z_time_slice() call.
	 */
	_current_cpu->slice_ticks = slice_time + z_clock_elapsed();
800031e8:	b44ff0ef          	jal	ra,8000252c <z_clock_elapsed>
800031ec:	800077b7          	lui	a5,0x80007
800031f0:	e507a783          	lw	a5,-432(a5) # 80006e50 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006e51>

	z_set_timeout_expiry(slice_time, false);
}
800031f4:	00c12083          	lw	ra,12(sp)
	_current_cpu->slice_ticks = slice_time + z_clock_elapsed();
800031f8:	80007737          	lui	a4,0x80007
800031fc:	00a78533          	add	a0,a5,a0
80003200:	14a72223          	sw	a0,324(a4) # 80007144 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007145>
	z_set_timeout_expiry(slice_time, false);
80003204:	00000593          	li	a1,0
80003208:	00078513          	mv	a0,a5
}
8000320c:	01010113          	addi	sp,sp,16
	z_set_timeout_expiry(slice_time, false);
80003210:	3440206f          	j	80005554 <z_set_timeout_expiry>

80003214 <pended_on.isra.15>:
	pend(thread, wait_q, timeout);
}

static _wait_q_t *pended_on(struct k_thread *thread)
{
	__ASSERT_NO_MSG(thread->base.pended_on);
80003214:	00052783          	lw	a5,0(a0)
static _wait_q_t *pended_on(struct k_thread *thread)
80003218:	ff010113          	addi	sp,sp,-16
8000321c:	00812423          	sw	s0,8(sp)
80003220:	00112623          	sw	ra,12(sp)
80003224:	00912223          	sw	s1,4(sp)
80003228:	00050413          	mv	s0,a0
	__ASSERT_NO_MSG(thread->base.pended_on);
8000322c:	02079863          	bnez	a5,8000325c <pended_on.isra.15+0x48>
80003230:	800074b7          	lui	s1,0x80007
80003234:	800075b7          	lui	a1,0x80007
80003238:	80006537          	lui	a0,0x80006
8000323c:	b3458593          	addi	a1,a1,-1228 # 80006b34 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006b35>
80003240:	7dc50513          	addi	a0,a0,2012 # 800067dc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800067dd>
80003244:	18300693          	li	a3,387
80003248:	b2048613          	addi	a2,s1,-1248 # 80006b20 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006b21>
8000324c:	e25fe0ef          	jal	ra,80002070 <printk>
80003250:	18300593          	li	a1,387
80003254:	b2048513          	addi	a0,s1,-1248
80003258:	e55fe0ef          	jal	ra,800020ac <assert_post_action>

	return thread->base.pended_on;
}
8000325c:	00042503          	lw	a0,0(s0)
80003260:	00c12083          	lw	ra,12(sp)
80003264:	00812403          	lw	s0,8(sp)
80003268:	00412483          	lw	s1,4(sp)
8000326c:	01010113          	addi	sp,sp,16
80003270:	00008067          	ret

80003274 <k_sched_time_slice_set>:
{
80003274:	fe010113          	addi	sp,sp,-32
80003278:	00812c23          	sw	s0,24(sp)
8000327c:	01312623          	sw	s3,12(sp)
80003280:	01412423          	sw	s4,8(sp)
80003284:	00112e23          	sw	ra,28(sp)
80003288:	00912a23          	sw	s1,20(sp)
8000328c:	01212823          	sw	s2,16(sp)
80003290:	00050a13          	mv	s4,a0
80003294:	00058993          	mv	s3,a1
	__asm__ volatile ("csrrc %0, mstatus, %1"
80003298:	00800413          	li	s0,8
8000329c:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
800032a0:	800074b7          	lui	s1,0x80007
800032a4:	e4848513          	addi	a0,s1,-440 # 80006e48 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006e49>
	key = (mstatus & SOC_MSTATUS_IEN);
800032a8:	00847413          	andi	s0,s0,8
800032ac:	0ed010ef          	jal	ra,80004b98 <z_spin_lock_valid>
800032b0:	02051e63          	bnez	a0,800032ec <k_sched_time_slice_set+0x78>
800032b4:	80007937          	lui	s2,0x80007
800032b8:	800075b7          	lui	a1,0x80007
800032bc:	80006537          	lui	a0,0x80006
800032c0:	8c058593          	addi	a1,a1,-1856 # 800068c0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800068c1>
800032c4:	04e00693          	li	a3,78
800032c8:	8a890613          	addi	a2,s2,-1880 # 800068a8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800068a9>
800032cc:	7dc50513          	addi	a0,a0,2012 # 800067dc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800067dd>
800032d0:	da1fe0ef          	jal	ra,80002070 <printk>
800032d4:	80007537          	lui	a0,0x80007
800032d8:	8d850513          	addi	a0,a0,-1832 # 800068d8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800068d9>
800032dc:	d95fe0ef          	jal	ra,80002070 <printk>
800032e0:	04e00593          	li	a1,78
800032e4:	8a890513          	addi	a0,s2,-1880
800032e8:	dc5fe0ef          	jal	ra,800020ac <assert_post_action>
	z_spin_lock_set_owner(l);
800032ec:	e4848513          	addi	a0,s1,-440
800032f0:	101010ef          	jal	ra,80004bf0 <z_spin_lock_set_owner>
		_current_cpu->slice_ticks = 0;
800032f4:	800077b7          	lui	a5,0x80007
		CONFIG_SYS_CLOCK_TICKS_PER_SEC);
#else
	/* simple division keeps precision */
	s32_t ms_per_tick = MSEC_PER_SEC / CONFIG_SYS_CLOCK_TICKS_PER_SEC;

	return (s32_t)ceiling_fraction(ms, ms_per_tick);
800032f8:	00a00593          	li	a1,10
800032fc:	009a0513          	addi	a0,s4,9
80003300:	1407a223          	sw	zero,324(a5) # 80007144 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007145>
80003304:	e34fd0ef          	jal	ra,80000938 <__divsi3>
		slice_max_prio = prio;
80003308:	800077b7          	lui	a5,0x80007
		slice_time = z_ms_to_ticks(slice);
8000330c:	80007937          	lui	s2,0x80007
80003310:	e4a92823          	sw	a0,-432(s2) # 80006e50 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006e51>
		slice_max_prio = prio;
80003314:	e537a623          	sw	s3,-436(a5) # 80006e4c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006e4d>
		reset_time_slice();
80003318:	ec9ff0ef          	jal	ra,800031e0 <reset_time_slice>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
8000331c:	e4848513          	addi	a0,s1,-440
80003320:	0a1010ef          	jal	ra,80004bc0 <z_spin_unlock_valid>
80003324:	02051e63          	bnez	a0,80003360 <k_sched_time_slice_set+0xec>
80003328:	800074b7          	lui	s1,0x80007
8000332c:	800075b7          	lui	a1,0x80007
80003330:	80006537          	lui	a0,0x80006
80003334:	8f058593          	addi	a1,a1,-1808 # 800068f0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800068f1>
80003338:	06100693          	li	a3,97
8000333c:	8a848613          	addi	a2,s1,-1880 # 800068a8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800068a9>
80003340:	7dc50513          	addi	a0,a0,2012 # 800067dc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800067dd>
80003344:	d2dfe0ef          	jal	ra,80002070 <printk>
80003348:	80007537          	lui	a0,0x80007
8000334c:	90850513          	addi	a0,a0,-1784 # 80006908 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006909>
80003350:	d21fe0ef          	jal	ra,80002070 <printk>
80003354:	06100593          	li	a1,97
80003358:	8a848513          	addi	a0,s1,-1880
8000335c:	d51fe0ef          	jal	ra,800020ac <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80003360:	30042473          	csrrs	s0,mstatus,s0
}
80003364:	01c12083          	lw	ra,28(sp)
80003368:	01812403          	lw	s0,24(sp)
8000336c:	01412483          	lw	s1,20(sp)
80003370:	01012903          	lw	s2,16(sp)
80003374:	00c12983          	lw	s3,12(sp)
80003378:	00812a03          	lw	s4,8(sp)
8000337c:	02010113          	addi	sp,sp,32
80003380:	00008067          	ret

80003384 <z_unpend_thread_no_timeout>:

	return ret;
}

ALWAYS_INLINE void z_unpend_thread_no_timeout(struct k_thread *thread)
{
80003384:	fe010113          	addi	sp,sp,-32
80003388:	00812c23          	sw	s0,24(sp)
8000338c:	01212823          	sw	s2,16(sp)
80003390:	00112e23          	sw	ra,28(sp)
80003394:	00912a23          	sw	s1,20(sp)
80003398:	01312623          	sw	s3,12(sp)
8000339c:	00050913          	mv	s2,a0
	__asm__ volatile ("csrrc %0, mstatus, %1"
800033a0:	00800413          	li	s0,8
800033a4:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
800033a8:	800074b7          	lui	s1,0x80007
800033ac:	e4848513          	addi	a0,s1,-440 # 80006e48 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006e49>
	key = (mstatus & SOC_MSTATUS_IEN);
800033b0:	00847413          	andi	s0,s0,8
800033b4:	7e4010ef          	jal	ra,80004b98 <z_spin_lock_valid>
800033b8:	02051e63          	bnez	a0,800033f4 <z_unpend_thread_no_timeout+0x70>
800033bc:	800079b7          	lui	s3,0x80007
800033c0:	800075b7          	lui	a1,0x80007
800033c4:	80006537          	lui	a0,0x80006
800033c8:	8c058593          	addi	a1,a1,-1856 # 800068c0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800068c1>
800033cc:	04e00693          	li	a3,78
800033d0:	8a898613          	addi	a2,s3,-1880 # 800068a8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800068a9>
800033d4:	7dc50513          	addi	a0,a0,2012 # 800067dc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800067dd>
800033d8:	c99fe0ef          	jal	ra,80002070 <printk>
800033dc:	80007537          	lui	a0,0x80007
800033e0:	8d850513          	addi	a0,a0,-1832 # 800068d8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800068d9>
800033e4:	c8dfe0ef          	jal	ra,80002070 <printk>
800033e8:	04e00593          	li	a1,78
800033ec:	8a898513          	addi	a0,s3,-1880
800033f0:	cbdfe0ef          	jal	ra,800020ac <assert_post_action>
	z_spin_lock_set_owner(l);
800033f4:	e4848513          	addi	a0,s1,-440
800033f8:	7f8010ef          	jal	ra,80004bf0 <z_spin_lock_set_owner>
	LOCKED(&sched_spinlock) {
		_priq_wait_remove(&pended_on(thread)->waitq, thread);
800033fc:	00890513          	addi	a0,s2,8
80003400:	e15ff0ef          	jal	ra,80003214 <pended_on.isra.15>
80003404:	00090593          	mv	a1,s2
80003408:	2f0000ef          	jal	ra,800036f8 <z_priq_dumb_remove>
	thread->base.thread_state &= ~_THREAD_PENDING;
8000340c:	00d94783          	lbu	a5,13(s2)
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80003410:	e4848513          	addi	a0,s1,-440
80003414:	ffd7f793          	andi	a5,a5,-3
80003418:	00f906a3          	sb	a5,13(s2)
8000341c:	7a4010ef          	jal	ra,80004bc0 <z_spin_unlock_valid>
80003420:	02051e63          	bnez	a0,8000345c <z_unpend_thread_no_timeout+0xd8>
80003424:	800074b7          	lui	s1,0x80007
80003428:	800075b7          	lui	a1,0x80007
8000342c:	80006537          	lui	a0,0x80006
80003430:	8f058593          	addi	a1,a1,-1808 # 800068f0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800068f1>
80003434:	06100693          	li	a3,97
80003438:	8a848613          	addi	a2,s1,-1880 # 800068a8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800068a9>
8000343c:	7dc50513          	addi	a0,a0,2012 # 800067dc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800067dd>
80003440:	c31fe0ef          	jal	ra,80002070 <printk>
80003444:	80007537          	lui	a0,0x80007
80003448:	90850513          	addi	a0,a0,-1784 # 80006908 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006909>
8000344c:	c25fe0ef          	jal	ra,80002070 <printk>
80003450:	06100593          	li	a1,97
80003454:	8a848513          	addi	a0,s1,-1880
80003458:	c55fe0ef          	jal	ra,800020ac <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
8000345c:	30042473          	csrrs	s0,mstatus,s0
		z_mark_thread_as_not_pending(thread);
	}

	thread->base.pended_on = NULL;
}
80003460:	01c12083          	lw	ra,28(sp)
80003464:	01812403          	lw	s0,24(sp)
	thread->base.pended_on = NULL;
80003468:	00092423          	sw	zero,8(s2)
}
8000346c:	01412483          	lw	s1,20(sp)
80003470:	01012903          	lw	s2,16(sp)
80003474:	00c12983          	lw	s3,12(sp)
80003478:	02010113          	addi	sp,sp,32
8000347c:	00008067          	ret

80003480 <z_reschedule>:
	return !z_is_in_isr();
}

void z_reschedule(struct k_spinlock *lock, k_spinlock_key_t key)
{
	if (resched()) {
80003480:	800077b7          	lui	a5,0x80007
80003484:	1347a783          	lw	a5,308(a5) # 80007134 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007135>
{
80003488:	ff010113          	addi	sp,sp,-16
8000348c:	00812423          	sw	s0,8(sp)
80003490:	00112623          	sw	ra,12(sp)
80003494:	00912223          	sw	s1,4(sp)
80003498:	00058413          	mv	s0,a1
	if (resched()) {
8000349c:	04079e63          	bnez	a5,800034f8 <z_reschedule+0x78>
 */
static ALWAYS_INLINE void k_spin_release(struct k_spinlock *l)
{
	ARG_UNUSED(l);
#ifdef SPIN_VALIDATE
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
800034a0:	720010ef          	jal	ra,80004bc0 <z_spin_unlock_valid>
800034a4:	02051e63          	bnez	a0,800034e0 <z_reschedule+0x60>
800034a8:	800074b7          	lui	s1,0x80007
800034ac:	800075b7          	lui	a1,0x80007
800034b0:	80006537          	lui	a0,0x80006
800034b4:	8f058593          	addi	a1,a1,-1808 # 800068f0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800068f1>
800034b8:	07800693          	li	a3,120
800034bc:	8a848613          	addi	a2,s1,-1880 # 800068a8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800068a9>
800034c0:	7dc50513          	addi	a0,a0,2012 # 800067dc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800067dd>
800034c4:	badfe0ef          	jal	ra,80002070 <printk>
800034c8:	80007537          	lui	a0,0x80007
800034cc:	90850513          	addi	a0,a0,-1784 # 80006908 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006909>
800034d0:	ba1fe0ef          	jal	ra,80002070 <printk>
800034d4:	07800593          	li	a1,120
800034d8:	8a848513          	addi	a0,s1,-1880
800034dc:	bd1fe0ef          	jal	ra,800020ac <assert_post_action>
800034e0:	00040513          	mv	a0,s0
		z_swap(lock, key);
	} else {
		k_spin_unlock(lock, key);
	}
}
800034e4:	00812403          	lw	s0,8(sp)
800034e8:	00c12083          	lw	ra,12(sp)
800034ec:	00412483          	lw	s1,4(sp)
800034f0:	01010113          	addi	sp,sp,16
800034f4:	d35fc06f          	j	80000228 <__swap>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
800034f8:	6c8010ef          	jal	ra,80004bc0 <z_spin_unlock_valid>
800034fc:	02051e63          	bnez	a0,80003538 <z_reschedule+0xb8>
80003500:	800074b7          	lui	s1,0x80007
80003504:	800075b7          	lui	a1,0x80007
80003508:	80006537          	lui	a0,0x80006
8000350c:	8f058593          	addi	a1,a1,-1808 # 800068f0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800068f1>
80003510:	06100693          	li	a3,97
80003514:	8a848613          	addi	a2,s1,-1880 # 800068a8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800068a9>
80003518:	7dc50513          	addi	a0,a0,2012 # 800067dc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800067dd>
8000351c:	b55fe0ef          	jal	ra,80002070 <printk>
80003520:	80007537          	lui	a0,0x80007
80003524:	90850513          	addi	a0,a0,-1784 # 80006908 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006909>
80003528:	b49fe0ef          	jal	ra,80002070 <printk>
8000352c:	06100593          	li	a1,97
80003530:	8a848513          	addi	a0,s1,-1880
80003534:	b79fe0ef          	jal	ra,800020ac <assert_post_action>
			  : "r" (key & SOC_MSTATUS_IEN)
80003538:	00847413          	andi	s0,s0,8
	__asm__ volatile ("csrrs %0, mstatus, %1"
8000353c:	30042473          	csrrs	s0,mstatus,s0
80003540:	00c12083          	lw	ra,12(sp)
80003544:	00812403          	lw	s0,8(sp)
80003548:	00412483          	lw	s1,4(sp)
8000354c:	01010113          	addi	sp,sp,16
80003550:	00008067          	ret

80003554 <z_reschedule_irqlock>:

void z_reschedule_irqlock(u32_t key)
{
	if (resched()) {
80003554:	80007737          	lui	a4,0x80007
80003558:	13472703          	lw	a4,308(a4) # 80007134 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007135>
8000355c:	00071463          	bnez	a4,80003564 <z_reschedule_irqlock+0x10>
80003560:	cc9fc06f          	j	80000228 <__swap>
			  : "r" (key & SOC_MSTATUS_IEN)
80003564:	00857793          	andi	a5,a0,8
	__asm__ volatile ("csrrs %0, mstatus, %1"
80003568:	3007a7f3          	csrrs	a5,mstatus,a5
		z_swap_irqlock(key);
	} else {
		irq_unlock(key);
	}
}
8000356c:	00008067          	ret

80003570 <z_reschedule_unlocked>:
	__asm__ volatile ("csrrc %0, mstatus, %1"
80003570:	00800513          	li	a0,8
80003574:	30053573          	csrrc	a0,mstatus,a0
	(void) z_reschedule_irqlock(z_arch_irq_lock());
80003578:	00857513          	andi	a0,a0,8
8000357c:	fd9ff06f          	j	80003554 <z_reschedule_irqlock>

80003580 <k_sched_lock>:

void k_sched_lock(void)
{
80003580:	fe010113          	addi	sp,sp,-32
80003584:	00812c23          	sw	s0,24(sp)
80003588:	00112e23          	sw	ra,28(sp)
8000358c:	00912a23          	sw	s1,20(sp)
80003590:	01212823          	sw	s2,16(sp)
80003594:	01312623          	sw	s3,12(sp)
80003598:	00800413          	li	s0,8
8000359c:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
800035a0:	800074b7          	lui	s1,0x80007
800035a4:	e4848513          	addi	a0,s1,-440 # 80006e48 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006e49>
	key = (mstatus & SOC_MSTATUS_IEN);
800035a8:	00847413          	andi	s0,s0,8
800035ac:	5ec010ef          	jal	ra,80004b98 <z_spin_lock_valid>
800035b0:	02051e63          	bnez	a0,800035ec <k_sched_lock+0x6c>
800035b4:	80007937          	lui	s2,0x80007
800035b8:	800075b7          	lui	a1,0x80007
800035bc:	80006537          	lui	a0,0x80006
800035c0:	8c058593          	addi	a1,a1,-1856 # 800068c0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800068c1>
800035c4:	04e00693          	li	a3,78
800035c8:	8a890613          	addi	a2,s2,-1880 # 800068a8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800068a9>
800035cc:	7dc50513          	addi	a0,a0,2012 # 800067dc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800067dd>
800035d0:	aa1fe0ef          	jal	ra,80002070 <printk>
800035d4:	80007537          	lui	a0,0x80007
800035d8:	8d850513          	addi	a0,a0,-1832 # 800068d8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800068d9>
800035dc:	a95fe0ef          	jal	ra,80002070 <printk>
800035e0:	04e00593          	li	a1,78
800035e4:	8a890513          	addi	a0,s2,-1880
800035e8:	ac5fe0ef          	jal	ra,800020ac <assert_post_action>
	z_spin_lock_set_owner(l);
800035ec:	e4848513          	addi	a0,s1,-440
}

static inline void z_sched_lock(void)
{
#ifdef CONFIG_PREEMPT_ENABLED
	__ASSERT(!z_is_in_isr(), "");
800035f0:	80007937          	lui	s2,0x80007
800035f4:	5fc010ef          	jal	ra,80004bf0 <z_spin_lock_set_owner>
800035f8:	13492783          	lw	a5,308(s2) # 80007134 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007135>
800035fc:	13490913          	addi	s2,s2,308
80003600:	02078e63          	beqz	a5,8000363c <k_sched_lock+0xbc>
80003604:	800079b7          	lui	s3,0x80007
80003608:	800075b7          	lui	a1,0x80007
8000360c:	80006537          	lui	a0,0x80006
80003610:	ab858593          	addi	a1,a1,-1352 # 80006ab8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006ab9>
80003614:	10000693          	li	a3,256
80003618:	a9c98613          	addi	a2,s3,-1380 # 80006a9c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006a9d>
8000361c:	7dc50513          	addi	a0,a0,2012 # 800067dc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800067dd>
80003620:	a51fe0ef          	jal	ra,80002070 <printk>
80003624:	80007537          	lui	a0,0x80007
80003628:	86050513          	addi	a0,a0,-1952 # 80006860 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006861>
8000362c:	a45fe0ef          	jal	ra,80002070 <printk>
80003630:	10000593          	li	a1,256
80003634:	a9c98513          	addi	a0,s3,-1380
80003638:	a75fe0ef          	jal	ra,800020ac <assert_post_action>
	__ASSERT(_current->base.sched_locked != 1, "");
8000363c:	00892783          	lw	a5,8(s2)
80003640:	00f7c703          	lbu	a4,15(a5)
80003644:	00100793          	li	a5,1
80003648:	02f71e63          	bne	a4,a5,80003684 <k_sched_lock+0x104>
8000364c:	800079b7          	lui	s3,0x80007
80003650:	800075b7          	lui	a1,0x80007
80003654:	80006537          	lui	a0,0x80006
80003658:	ad058593          	addi	a1,a1,-1328 # 80006ad0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006ad1>
8000365c:	10100693          	li	a3,257
80003660:	a9c98613          	addi	a2,s3,-1380 # 80006a9c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006a9d>
80003664:	7dc50513          	addi	a0,a0,2012 # 800067dc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800067dd>
80003668:	a09fe0ef          	jal	ra,80002070 <printk>
8000366c:	80007537          	lui	a0,0x80007
80003670:	86050513          	addi	a0,a0,-1952 # 80006860 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006861>
80003674:	9fdfe0ef          	jal	ra,80002070 <printk>
80003678:	10100593          	li	a1,257
8000367c:	a9c98513          	addi	a0,s3,-1380
80003680:	a2dfe0ef          	jal	ra,800020ac <assert_post_action>

	--_current->base.sched_locked;
80003684:	00892703          	lw	a4,8(s2)
80003688:	00f74783          	lbu	a5,15(a4)
8000368c:	fff78793          	addi	a5,a5,-1
80003690:	00f707a3          	sb	a5,15(a4)
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80003694:	e4848513          	addi	a0,s1,-440
80003698:	528010ef          	jal	ra,80004bc0 <z_spin_unlock_valid>
8000369c:	02051e63          	bnez	a0,800036d8 <k_sched_lock+0x158>
800036a0:	800074b7          	lui	s1,0x80007
800036a4:	800075b7          	lui	a1,0x80007
800036a8:	80006537          	lui	a0,0x80006
800036ac:	8f058593          	addi	a1,a1,-1808 # 800068f0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800068f1>
800036b0:	06100693          	li	a3,97
800036b4:	8a848613          	addi	a2,s1,-1880 # 800068a8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800068a9>
800036b8:	7dc50513          	addi	a0,a0,2012 # 800067dc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800067dd>
800036bc:	9b5fe0ef          	jal	ra,80002070 <printk>
800036c0:	80007537          	lui	a0,0x80007
800036c4:	90850513          	addi	a0,a0,-1784 # 80006908 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006909>
800036c8:	9a9fe0ef          	jal	ra,80002070 <printk>
800036cc:	06100593          	li	a1,97
800036d0:	8a848513          	addi	a0,s1,-1880
800036d4:	9d9fe0ef          	jal	ra,800020ac <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
800036d8:	30042473          	csrrs	s0,mstatus,s0
	LOCKED(&sched_spinlock) {
		z_sched_lock();
	}
}
800036dc:	01c12083          	lw	ra,28(sp)
800036e0:	01812403          	lw	s0,24(sp)
800036e4:	01412483          	lw	s1,20(sp)
800036e8:	01012903          	lw	s2,16(sp)
800036ec:	00c12983          	lw	s3,12(sp)
800036f0:	02010113          	addi	sp,sp,32
800036f4:	00008067          	ret

800036f8 <z_priq_dumb_remove>:
	return thread == _idle_thread;
800036f8:	800077b7          	lui	a5,0x80007
	    z_is_thread_prevented_from_running(thread)) {
		return;
	}
#endif

	__ASSERT_NO_MSG(!is_idle(thread));
800036fc:	d9c7a783          	lw	a5,-612(a5) # 80006d9c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006d9d>
{
80003700:	ff010113          	addi	sp,sp,-16
80003704:	00812423          	sw	s0,8(sp)
80003708:	00112623          	sw	ra,12(sp)
8000370c:	00912223          	sw	s1,4(sp)
80003710:	00058413          	mv	s0,a1
	__ASSERT_NO_MSG(!is_idle(thread));
80003714:	02f59863          	bne	a1,a5,80003744 <z_priq_dumb_remove+0x4c>
80003718:	800074b7          	lui	s1,0x80007
8000371c:	800075b7          	lui	a1,0x80007
80003720:	80006537          	lui	a0,0x80006
80003724:	b6c58593          	addi	a1,a1,-1172 # 80006b6c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006b6d>
80003728:	7dc50513          	addi	a0,a0,2012 # 800067dc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800067dd>
8000372c:	28c00693          	li	a3,652
80003730:	b2048613          	addi	a2,s1,-1248 # 80006b20 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006b21>
80003734:	93dfe0ef          	jal	ra,80002070 <printk>
80003738:	28c00593          	li	a1,652
8000373c:	b2048513          	addi	a0,s1,-1248
80003740:	96dfe0ef          	jal	ra,800020ac <assert_post_action>
	node->prev->next = node->next;
80003744:	00442703          	lw	a4,4(s0)
80003748:	00042783          	lw	a5,0(s0)

	sys_dlist_remove(&thread->base.qnode_dlist);
}
8000374c:	00c12083          	lw	ra,12(sp)
80003750:	00412483          	lw	s1,4(sp)
80003754:	00f72023          	sw	a5,0(a4)
	node->next->prev = node->prev;
80003758:	00e7a223          	sw	a4,4(a5)
	node->next = NULL;
8000375c:	00042023          	sw	zero,0(s0)
	node->prev = NULL;
80003760:	00042223          	sw	zero,4(s0)
80003764:	00812403          	lw	s0,8(sp)
80003768:	01010113          	addi	sp,sp,16
8000376c:	00008067          	ret

80003770 <z_unpend_thread>:
{
80003770:	fe010113          	addi	sp,sp,-32
80003774:	00812c23          	sw	s0,24(sp)
80003778:	00912a23          	sw	s1,20(sp)
8000377c:	00112e23          	sw	ra,28(sp)
80003780:	01212823          	sw	s2,16(sp)
80003784:	01312623          	sw	s3,12(sp)
80003788:	00050413          	mv	s0,a0
	__asm__ volatile ("csrrc %0, mstatus, %1"
8000378c:	00800493          	li	s1,8
80003790:	3004b4f3          	csrrc	s1,mstatus,s1
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80003794:	80007937          	lui	s2,0x80007
80003798:	e4890513          	addi	a0,s2,-440 # 80006e48 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006e49>
	key = (mstatus & SOC_MSTATUS_IEN);
8000379c:	0084f493          	andi	s1,s1,8
800037a0:	3f8010ef          	jal	ra,80004b98 <z_spin_lock_valid>
800037a4:	02051e63          	bnez	a0,800037e0 <z_unpend_thread+0x70>
800037a8:	800079b7          	lui	s3,0x80007
800037ac:	800075b7          	lui	a1,0x80007
800037b0:	80006537          	lui	a0,0x80006
800037b4:	8c058593          	addi	a1,a1,-1856 # 800068c0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800068c1>
800037b8:	04e00693          	li	a3,78
800037bc:	8a898613          	addi	a2,s3,-1880 # 800068a8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800068a9>
800037c0:	7dc50513          	addi	a0,a0,2012 # 800067dc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800067dd>
800037c4:	8adfe0ef          	jal	ra,80002070 <printk>
800037c8:	80007537          	lui	a0,0x80007
800037cc:	8d850513          	addi	a0,a0,-1832 # 800068d8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800068d9>
800037d0:	8a1fe0ef          	jal	ra,80002070 <printk>
800037d4:	04e00593          	li	a1,78
800037d8:	8a898513          	addi	a0,s3,-1880
800037dc:	8d1fe0ef          	jal	ra,800020ac <assert_post_action>
	z_spin_lock_set_owner(l);
800037e0:	e4890513          	addi	a0,s2,-440
800037e4:	40c010ef          	jal	ra,80004bf0 <z_spin_lock_set_owner>
		_priq_wait_remove(&pended_on(thread)->waitq, thread);
800037e8:	00840513          	addi	a0,s0,8
800037ec:	a29ff0ef          	jal	ra,80003214 <pended_on.isra.15>
800037f0:	00040593          	mv	a1,s0
800037f4:	f05ff0ef          	jal	ra,800036f8 <z_priq_dumb_remove>
	thread->base.thread_state &= ~_THREAD_PENDING;
800037f8:	00d44783          	lbu	a5,13(s0)
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
800037fc:	e4890513          	addi	a0,s2,-440
80003800:	ffd7f793          	andi	a5,a5,-3
80003804:	00f406a3          	sb	a5,13(s0)
80003808:	3b8010ef          	jal	ra,80004bc0 <z_spin_unlock_valid>
8000380c:	02051e63          	bnez	a0,80003848 <z_unpend_thread+0xd8>
80003810:	80007937          	lui	s2,0x80007
80003814:	800075b7          	lui	a1,0x80007
80003818:	80006537          	lui	a0,0x80006
8000381c:	8f058593          	addi	a1,a1,-1808 # 800068f0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800068f1>
80003820:	06100693          	li	a3,97
80003824:	8a890613          	addi	a2,s2,-1880 # 800068a8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800068a9>
80003828:	7dc50513          	addi	a0,a0,2012 # 800067dc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800067dd>
8000382c:	845fe0ef          	jal	ra,80002070 <printk>
80003830:	80007537          	lui	a0,0x80007
80003834:	90850513          	addi	a0,a0,-1784 # 80006908 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006909>
80003838:	839fe0ef          	jal	ra,80002070 <printk>
8000383c:	06100593          	li	a1,97
80003840:	8a890513          	addi	a0,s2,-1880
80003844:	869fe0ef          	jal	ra,800020ac <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80003848:	3004a4f3          	csrrs	s1,mstatus,s1
	thread->base.pended_on = NULL;
8000384c:	00042423          	sw	zero,8(s0)
	z_add_timeout(&th->base.timeout, z_thread_timeout, ticks);
}

static inline int z_abort_thread_timeout(struct k_thread *thread)
{
	return z_abort_timeout(&thread->base.timeout);
80003850:	01840513          	addi	a0,s0,24
}
80003854:	01812403          	lw	s0,24(sp)
80003858:	01c12083          	lw	ra,28(sp)
8000385c:	01412483          	lw	s1,20(sp)
80003860:	01012903          	lw	s2,16(sp)
80003864:	00c12983          	lw	s3,12(sp)
80003868:	02010113          	addi	sp,sp,32
8000386c:	3150106f          	j	80005380 <z_abort_timeout>

80003870 <z_priq_dumb_best>:
	return list->head == list;
80003870:	00052783          	lw	a5,0(a0)
	return sys_dlist_is_empty(list) ? NULL : list->head;
80003874:	00f51463          	bne	a0,a5,8000387c <z_priq_dumb_best+0xc>

struct k_thread *z_priq_dumb_best(sys_dlist_t *pq)
{
	struct k_thread *t = NULL;
80003878:	00000793          	li	a5,0

	if (n != NULL) {
		t = CONTAINER_OF(n, struct k_thread, base.qnode_dlist);
	}
	return t;
}
8000387c:	00078513          	mv	a0,a5
80003880:	00008067          	ret

80003884 <update_cache>:
{
80003884:	ff010113          	addi	sp,sp,-16
80003888:	00812423          	sw	s0,8(sp)
	struct k_thread *th = _priq_run_best(&_kernel.ready_q.runq);
8000388c:	80007437          	lui	s0,0x80007
{
80003890:	01212023          	sw	s2,0(sp)
80003894:	00050913          	mv	s2,a0
	struct k_thread *th = _priq_run_best(&_kernel.ready_q.runq);
80003898:	13440513          	addi	a0,s0,308 # 80007134 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007135>
8000389c:	02450513          	addi	a0,a0,36
{
800038a0:	00912223          	sw	s1,4(sp)
800038a4:	00112623          	sw	ra,12(sp)
	struct k_thread *th = _priq_run_best(&_kernel.ready_q.runq);
800038a8:	fc9ff0ef          	jal	ra,80003870 <z_priq_dumb_best>
	return th ? th : _current_cpu->idle_thread;
800038ac:	13440413          	addi	s0,s0,308
800038b0:	00050493          	mv	s1,a0
800038b4:	00051463          	bnez	a0,800038bc <update_cache+0x38>
800038b8:	00c42483          	lw	s1,12(s0)
	if (preempt_ok != 0) {
800038bc:	06091e63          	bnez	s2,80003938 <update_cache+0xb4>
	__ASSERT(_current != NULL, "");
800038c0:	00842783          	lw	a5,8(s0)
800038c4:	02079e63          	bnez	a5,80003900 <update_cache+0x7c>
800038c8:	80007937          	lui	s2,0x80007
800038cc:	800075b7          	lui	a1,0x80007
800038d0:	80006537          	lui	a0,0x80006
800038d4:	b4c58593          	addi	a1,a1,-1204 # 80006b4c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006b4d>
800038d8:	07f00693          	li	a3,127
800038dc:	b2090613          	addi	a2,s2,-1248 # 80006b20 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006b21>
800038e0:	7dc50513          	addi	a0,a0,2012 # 800067dc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800067dd>
800038e4:	f8cfe0ef          	jal	ra,80002070 <printk>
800038e8:	80007537          	lui	a0,0x80007
800038ec:	86050513          	addi	a0,a0,-1952 # 80006860 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006861>
800038f0:	f80fe0ef          	jal	ra,80002070 <printk>
800038f4:	07f00593          	li	a1,127
800038f8:	b2090513          	addi	a0,s2,-1248
800038fc:	fb0fe0ef          	jal	ra,800020ac <assert_post_action>
	if (z_is_thread_prevented_from_running(_current)) {
80003900:	00842783          	lw	a5,8(s0)
80003904:	00d7c703          	lbu	a4,13(a5)
80003908:	01f77713          	andi	a4,a4,31
8000390c:	02071663          	bnez	a4,80003938 <update_cache+0xb4>
	if (is_preempt(_current) || is_metairq(th)) {
80003910:	00e7d683          	lhu	a3,14(a5)
80003914:	07f00713          	li	a4,127
80003918:	02d77063          	bgeu	a4,a3,80003938 <update_cache+0xb4>
		_kernel.ready_q.cache = _current;
8000391c:	02f42023          	sw	a5,32(s0)
}
80003920:	00c12083          	lw	ra,12(sp)
80003924:	00812403          	lw	s0,8(sp)
80003928:	00412483          	lw	s1,4(sp)
8000392c:	00012903          	lw	s2,0(sp)
80003930:	01010113          	addi	sp,sp,16
80003934:	00008067          	ret
		if (th != _current) {
80003938:	00842783          	lw	a5,8(s0)
8000393c:	00978463          	beq	a5,s1,80003944 <update_cache+0xc0>
			reset_time_slice();
80003940:	8a1ff0ef          	jal	ra,800031e0 <reset_time_slice>
		_kernel.ready_q.cache = th;
80003944:	02942023          	sw	s1,32(s0)
}
80003948:	fd9ff06f          	j	80003920 <update_cache+0x9c>

8000394c <k_sched_unlock>:
{
8000394c:	fe010113          	addi	sp,sp,-32
80003950:	01212823          	sw	s2,16(sp)
	__ASSERT(_current->base.sched_locked != 0, "");
80003954:	80007937          	lui	s2,0x80007
80003958:	13490793          	addi	a5,s2,308 # 80007134 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007135>
8000395c:	0087a783          	lw	a5,8(a5)
{
80003960:	00112e23          	sw	ra,28(sp)
80003964:	00812c23          	sw	s0,24(sp)
	__ASSERT(_current->base.sched_locked != 0, "");
80003968:	00f7c783          	lbu	a5,15(a5)
{
8000396c:	00912a23          	sw	s1,20(sp)
80003970:	01312623          	sw	s3,12(sp)
80003974:	13490913          	addi	s2,s2,308
	__ASSERT(_current->base.sched_locked != 0, "");
80003978:	02079e63          	bnez	a5,800039b4 <k_sched_unlock+0x68>
8000397c:	80007437          	lui	s0,0x80007
80003980:	800075b7          	lui	a1,0x80007
80003984:	80006537          	lui	a0,0x80006
80003988:	af858593          	addi	a1,a1,-1288 # 80006af8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006af9>
8000398c:	22100693          	li	a3,545
80003990:	b2040613          	addi	a2,s0,-1248 # 80006b20 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006b21>
80003994:	7dc50513          	addi	a0,a0,2012 # 800067dc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800067dd>
80003998:	ed8fe0ef          	jal	ra,80002070 <printk>
8000399c:	80007537          	lui	a0,0x80007
800039a0:	86050513          	addi	a0,a0,-1952 # 80006860 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006861>
800039a4:	eccfe0ef          	jal	ra,80002070 <printk>
800039a8:	22100593          	li	a1,545
800039ac:	b2040513          	addi	a0,s0,-1248
800039b0:	efcfe0ef          	jal	ra,800020ac <assert_post_action>
	__ASSERT(!z_is_in_isr(), "");
800039b4:	00092783          	lw	a5,0(s2)
800039b8:	02078e63          	beqz	a5,800039f4 <k_sched_unlock+0xa8>
800039bc:	80007437          	lui	s0,0x80007
800039c0:	800075b7          	lui	a1,0x80007
800039c4:	80006537          	lui	a0,0x80006
800039c8:	ab858593          	addi	a1,a1,-1352 # 80006ab8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006ab9>
800039cc:	22200693          	li	a3,546
800039d0:	b2040613          	addi	a2,s0,-1248 # 80006b20 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006b21>
800039d4:	7dc50513          	addi	a0,a0,2012 # 800067dc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800067dd>
800039d8:	e98fe0ef          	jal	ra,80002070 <printk>
800039dc:	80007537          	lui	a0,0x80007
800039e0:	86050513          	addi	a0,a0,-1952 # 80006860 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006861>
800039e4:	e8cfe0ef          	jal	ra,80002070 <printk>
800039e8:	22200593          	li	a1,546
800039ec:	b2040513          	addi	a0,s0,-1248
800039f0:	ebcfe0ef          	jal	ra,800020ac <assert_post_action>
	__asm__ volatile ("csrrc %0, mstatus, %1"
800039f4:	00800413          	li	s0,8
800039f8:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
800039fc:	800074b7          	lui	s1,0x80007
80003a00:	e4848513          	addi	a0,s1,-440 # 80006e48 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006e49>
	key = (mstatus & SOC_MSTATUS_IEN);
80003a04:	00847413          	andi	s0,s0,8
80003a08:	190010ef          	jal	ra,80004b98 <z_spin_lock_valid>
80003a0c:	02051e63          	bnez	a0,80003a48 <k_sched_unlock+0xfc>
80003a10:	800079b7          	lui	s3,0x80007
80003a14:	800075b7          	lui	a1,0x80007
80003a18:	80006537          	lui	a0,0x80006
80003a1c:	8c058593          	addi	a1,a1,-1856 # 800068c0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800068c1>
80003a20:	04e00693          	li	a3,78
80003a24:	8a898613          	addi	a2,s3,-1880 # 800068a8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800068a9>
80003a28:	7dc50513          	addi	a0,a0,2012 # 800067dc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800067dd>
80003a2c:	e44fe0ef          	jal	ra,80002070 <printk>
80003a30:	80007537          	lui	a0,0x80007
80003a34:	8d850513          	addi	a0,a0,-1832 # 800068d8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800068d9>
80003a38:	e38fe0ef          	jal	ra,80002070 <printk>
80003a3c:	04e00593          	li	a1,78
80003a40:	8a898513          	addi	a0,s3,-1880
80003a44:	e68fe0ef          	jal	ra,800020ac <assert_post_action>
	z_spin_lock_set_owner(l);
80003a48:	e4848513          	addi	a0,s1,-440
80003a4c:	1a4010ef          	jal	ra,80004bf0 <z_spin_lock_set_owner>
		++_current->base.sched_locked;
80003a50:	00892703          	lw	a4,8(s2)
		update_cache(1);
80003a54:	00100513          	li	a0,1
		++_current->base.sched_locked;
80003a58:	00f74783          	lbu	a5,15(a4)
80003a5c:	00178793          	addi	a5,a5,1
80003a60:	00f707a3          	sb	a5,15(a4)
		update_cache(1);
80003a64:	e21ff0ef          	jal	ra,80003884 <update_cache>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80003a68:	e4848513          	addi	a0,s1,-440
80003a6c:	154010ef          	jal	ra,80004bc0 <z_spin_unlock_valid>
80003a70:	02051e63          	bnez	a0,80003aac <k_sched_unlock+0x160>
80003a74:	800074b7          	lui	s1,0x80007
80003a78:	800075b7          	lui	a1,0x80007
80003a7c:	80006537          	lui	a0,0x80006
80003a80:	8f058593          	addi	a1,a1,-1808 # 800068f0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800068f1>
80003a84:	06100693          	li	a3,97
80003a88:	8a848613          	addi	a2,s1,-1880 # 800068a8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800068a9>
80003a8c:	7dc50513          	addi	a0,a0,2012 # 800067dc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800067dd>
80003a90:	de0fe0ef          	jal	ra,80002070 <printk>
80003a94:	80007537          	lui	a0,0x80007
80003a98:	90850513          	addi	a0,a0,-1784 # 80006908 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006909>
80003a9c:	dd4fe0ef          	jal	ra,80002070 <printk>
80003aa0:	06100593          	li	a1,97
80003aa4:	8a848513          	addi	a0,s1,-1880
80003aa8:	e04fe0ef          	jal	ra,800020ac <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80003aac:	30042473          	csrrs	s0,mstatus,s0
}
80003ab0:	01812403          	lw	s0,24(sp)
80003ab4:	01c12083          	lw	ra,28(sp)
80003ab8:	01412483          	lw	s1,20(sp)
80003abc:	01012903          	lw	s2,16(sp)
80003ac0:	00c12983          	lw	s3,12(sp)
80003ac4:	02010113          	addi	sp,sp,32
	z_reschedule_unlocked();
80003ac8:	aa9ff06f          	j	80003570 <z_reschedule_unlocked>

80003acc <z_add_thread_to_ready_q>:
{
80003acc:	fe010113          	addi	sp,sp,-32
80003ad0:	00812c23          	sw	s0,24(sp)
80003ad4:	00912a23          	sw	s1,20(sp)
80003ad8:	00112e23          	sw	ra,28(sp)
80003adc:	01212823          	sw	s2,16(sp)
80003ae0:	01312623          	sw	s3,12(sp)
80003ae4:	00050413          	mv	s0,a0
	__asm__ volatile ("csrrc %0, mstatus, %1"
80003ae8:	00800493          	li	s1,8
80003aec:	3004b4f3          	csrrc	s1,mstatus,s1
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80003af0:	80007937          	lui	s2,0x80007
80003af4:	e4890513          	addi	a0,s2,-440 # 80006e48 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006e49>
	key = (mstatus & SOC_MSTATUS_IEN);
80003af8:	0084f493          	andi	s1,s1,8
80003afc:	09c010ef          	jal	ra,80004b98 <z_spin_lock_valid>
80003b00:	02051e63          	bnez	a0,80003b3c <z_add_thread_to_ready_q+0x70>
80003b04:	800079b7          	lui	s3,0x80007
80003b08:	800075b7          	lui	a1,0x80007
80003b0c:	80006537          	lui	a0,0x80006
80003b10:	8c058593          	addi	a1,a1,-1856 # 800068c0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800068c1>
80003b14:	04e00693          	li	a3,78
80003b18:	8a898613          	addi	a2,s3,-1880 # 800068a8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800068a9>
80003b1c:	7dc50513          	addi	a0,a0,2012 # 800067dc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800067dd>
80003b20:	d50fe0ef          	jal	ra,80002070 <printk>
80003b24:	80007537          	lui	a0,0x80007
80003b28:	8d850513          	addi	a0,a0,-1832 # 800068d8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800068d9>
80003b2c:	d44fe0ef          	jal	ra,80002070 <printk>
80003b30:	04e00593          	li	a1,78
80003b34:	8a898513          	addi	a0,s3,-1880
80003b38:	d74fe0ef          	jal	ra,800020ac <assert_post_action>
	z_spin_lock_set_owner(l);
80003b3c:	e4890513          	addi	a0,s2,-440
80003b40:	0b0010ef          	jal	ra,80004bf0 <z_spin_lock_set_owner>
	return thread == _idle_thread;
80003b44:	800077b7          	lui	a5,0x80007
	__ASSERT_NO_MSG(!is_idle(thread));
80003b48:	d9c7a783          	lw	a5,-612(a5) # 80006d9c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006d9d>
80003b4c:	02f41863          	bne	s0,a5,80003b7c <z_add_thread_to_ready_q+0xb0>
80003b50:	800079b7          	lui	s3,0x80007
80003b54:	800075b7          	lui	a1,0x80007
80003b58:	80006537          	lui	a0,0x80006
80003b5c:	b6c58593          	addi	a1,a1,-1172 # 80006b6c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006b6d>
80003b60:	7dc50513          	addi	a0,a0,2012 # 800067dc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800067dd>
80003b64:	27600693          	li	a3,630
80003b68:	b2098613          	addi	a2,s3,-1248 # 80006b20 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006b21>
80003b6c:	d04fe0ef          	jal	ra,80002070 <printk>
80003b70:	27600593          	li	a1,630
80003b74:	b2098513          	addi	a0,s3,-1248
80003b78:	d34fe0ef          	jal	ra,800020ac <assert_post_action>
	return list->head == list;
80003b7c:	80007737          	lui	a4,0x80007
80003b80:	13470693          	addi	a3,a4,308 # 80007134 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007135>
80003b84:	0246a783          	lw	a5,36(a3)
80003b88:	0286a603          	lw	a2,40(a3)
80003b8c:	800076b7          	lui	a3,0x80007
80003b90:	15868693          	addi	a3,a3,344 # 80007158 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007159>
80003b94:	13470713          	addi	a4,a4,308
	return sys_dlist_is_empty(list) ? NULL : list->head;
80003b98:	0ad78663          	beq	a5,a3,80003c44 <z_add_thread_to_ready_q+0x178>
	SYS_DLIST_FOR_EACH_CONTAINER(pq, t, base.qnode_dlist) {
80003b9c:	0a078463          	beqz	a5,80003c44 <z_add_thread_to_ready_q+0x178>
	if (t1->base.prio < t2->base.prio) {
80003ba0:	00e40583          	lb	a1,14(s0)
80003ba4:	00e78503          	lb	a0,14(a5)
80003ba8:	08a5d863          	bge	a1,a0,80003c38 <z_add_thread_to_ready_q+0x16c>
	node->prev = successor->prev;
80003bac:	0047a703          	lw	a4,4(a5)
	node->next = successor;
80003bb0:	00f42023          	sw	a5,0(s0)
	node->prev = successor->prev;
80003bb4:	00e42223          	sw	a4,4(s0)
	successor->prev->next = node;
80003bb8:	00872023          	sw	s0,0(a4)
	successor->prev = node;
80003bbc:	0087a223          	sw	s0,4(a5)
	thread->base.thread_state |= states;
80003bc0:	00d44783          	lbu	a5,13(s0)
		update_cache(0);
80003bc4:	00000513          	li	a0,0
80003bc8:	0407e793          	ori	a5,a5,64
80003bcc:	00f406a3          	sb	a5,13(s0)
80003bd0:	cb5ff0ef          	jal	ra,80003884 <update_cache>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80003bd4:	e4890513          	addi	a0,s2,-440
80003bd8:	7e9000ef          	jal	ra,80004bc0 <z_spin_unlock_valid>
80003bdc:	02051e63          	bnez	a0,80003c18 <z_add_thread_to_ready_q+0x14c>
80003be0:	80007437          	lui	s0,0x80007
80003be4:	800075b7          	lui	a1,0x80007
80003be8:	80006537          	lui	a0,0x80006
80003bec:	8f058593          	addi	a1,a1,-1808 # 800068f0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800068f1>
80003bf0:	06100693          	li	a3,97
80003bf4:	8a840613          	addi	a2,s0,-1880 # 800068a8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800068a9>
80003bf8:	7dc50513          	addi	a0,a0,2012 # 800067dc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800067dd>
80003bfc:	c74fe0ef          	jal	ra,80002070 <printk>
80003c00:	80007537          	lui	a0,0x80007
80003c04:	90850513          	addi	a0,a0,-1784 # 80006908 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006909>
80003c08:	c68fe0ef          	jal	ra,80002070 <printk>
80003c0c:	06100593          	li	a1,97
80003c10:	8a840513          	addi	a0,s0,-1880
80003c14:	c98fe0ef          	jal	ra,800020ac <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80003c18:	3004a4f3          	csrrs	s1,mstatus,s1
}
80003c1c:	01c12083          	lw	ra,28(sp)
80003c20:	01812403          	lw	s0,24(sp)
80003c24:	01412483          	lw	s1,20(sp)
80003c28:	01012903          	lw	s2,16(sp)
80003c2c:	00c12983          	lw	s3,12(sp)
80003c30:	02010113          	addi	sp,sp,32
80003c34:	00008067          	ret
	return (node == list->tail) ? NULL : node->next;
80003c38:	00f60663          	beq	a2,a5,80003c44 <z_add_thread_to_ready_q+0x178>
80003c3c:	0007a783          	lw	a5,0(a5)
	SYS_DLIST_FOR_EACH_CONTAINER(pq, t, base.qnode_dlist) {
80003c40:	f60792e3          	bnez	a5,80003ba4 <z_add_thread_to_ready_q+0xd8>
	node->prev = list->tail;
80003c44:	00c42223          	sw	a2,4(s0)
	list->tail->next = node;
80003c48:	02872783          	lw	a5,40(a4)
	node->next = list;
80003c4c:	00d42023          	sw	a3,0(s0)
	list->tail->next = node;
80003c50:	0087a023          	sw	s0,0(a5)
	list->tail = node;
80003c54:	02872423          	sw	s0,40(a4)
80003c58:	f69ff06f          	j	80003bc0 <z_add_thread_to_ready_q+0xf4>

80003c5c <z_thread_timeout>:
	if (th->base.pended_on != NULL) {
80003c5c:	ff052783          	lw	a5,-16(a0)
{
80003c60:	fe010113          	addi	sp,sp,-32
80003c64:	00812c23          	sw	s0,24(sp)
80003c68:	01312623          	sw	s3,12(sp)
80003c6c:	00112e23          	sw	ra,28(sp)
80003c70:	00912a23          	sw	s1,20(sp)
80003c74:	01212823          	sw	s2,16(sp)
80003c78:	01412423          	sw	s4,8(sp)
80003c7c:	00050413          	mv	s0,a0
	struct k_thread *th = CONTAINER_OF(to, struct k_thread, base.timeout);
80003c80:	fe850993          	addi	s3,a0,-24
	if (th->base.pended_on != NULL) {
80003c84:	0c078463          	beqz	a5,80003d4c <z_thread_timeout+0xf0>
	__asm__ volatile ("csrrc %0, mstatus, %1"
80003c88:	00800493          	li	s1,8
80003c8c:	3004b4f3          	csrrc	s1,mstatus,s1
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80003c90:	80007937          	lui	s2,0x80007
80003c94:	e4890513          	addi	a0,s2,-440 # 80006e48 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006e49>
	key = (mstatus & SOC_MSTATUS_IEN);
80003c98:	0084f493          	andi	s1,s1,8
80003c9c:	6fd000ef          	jal	ra,80004b98 <z_spin_lock_valid>
80003ca0:	02051e63          	bnez	a0,80003cdc <z_thread_timeout+0x80>
80003ca4:	80007a37          	lui	s4,0x80007
80003ca8:	800075b7          	lui	a1,0x80007
80003cac:	80006537          	lui	a0,0x80006
80003cb0:	8c058593          	addi	a1,a1,-1856 # 800068c0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800068c1>
80003cb4:	04e00693          	li	a3,78
80003cb8:	8a8a0613          	addi	a2,s4,-1880 # 800068a8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800068a9>
80003cbc:	7dc50513          	addi	a0,a0,2012 # 800067dc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800067dd>
80003cc0:	bb0fe0ef          	jal	ra,80002070 <printk>
80003cc4:	80007537          	lui	a0,0x80007
80003cc8:	8d850513          	addi	a0,a0,-1832 # 800068d8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800068d9>
80003ccc:	ba4fe0ef          	jal	ra,80002070 <printk>
80003cd0:	04e00593          	li	a1,78
80003cd4:	8a8a0513          	addi	a0,s4,-1880
80003cd8:	bd4fe0ef          	jal	ra,800020ac <assert_post_action>
	z_spin_lock_set_owner(l);
80003cdc:	e4890513          	addi	a0,s2,-440
80003ce0:	711000ef          	jal	ra,80004bf0 <z_spin_lock_set_owner>
		_priq_wait_remove(&pended_on(thread)->waitq, thread);
80003ce4:	ff040513          	addi	a0,s0,-16
80003ce8:	d2cff0ef          	jal	ra,80003214 <pended_on.isra.15>
80003cec:	00098593          	mv	a1,s3
80003cf0:	a09ff0ef          	jal	ra,800036f8 <z_priq_dumb_remove>
	thread->base.thread_state &= ~_THREAD_PENDING;
80003cf4:	ff544783          	lbu	a5,-11(s0)
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80003cf8:	e4890513          	addi	a0,s2,-440
80003cfc:	ffd7f793          	andi	a5,a5,-3
80003d00:	fef40aa3          	sb	a5,-11(s0)
80003d04:	6bd000ef          	jal	ra,80004bc0 <z_spin_unlock_valid>
80003d08:	02051e63          	bnez	a0,80003d44 <z_thread_timeout+0xe8>
80003d0c:	80007937          	lui	s2,0x80007
80003d10:	800075b7          	lui	a1,0x80007
80003d14:	80006537          	lui	a0,0x80006
80003d18:	8f058593          	addi	a1,a1,-1808 # 800068f0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800068f1>
80003d1c:	06100693          	li	a3,97
80003d20:	8a890613          	addi	a2,s2,-1880 # 800068a8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800068a9>
80003d24:	7dc50513          	addi	a0,a0,2012 # 800067dc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800067dd>
80003d28:	b48fe0ef          	jal	ra,80002070 <printk>
80003d2c:	80007537          	lui	a0,0x80007
80003d30:	90850513          	addi	a0,a0,-1784 # 80006908 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006909>
80003d34:	b3cfe0ef          	jal	ra,80002070 <printk>
80003d38:	06100593          	li	a1,97
80003d3c:	8a890513          	addi	a0,s2,-1880
80003d40:	b6cfe0ef          	jal	ra,800020ac <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80003d44:	3004a4f3          	csrrs	s1,mstatus,s1
	thread->base.pended_on = NULL;
80003d48:	fe042823          	sw	zero,-16(s0)
	thread->base.thread_state &= ~_THREAD_SUSPENDED;
80003d4c:	ff544783          	lbu	a5,-11(s0)
	if (z_is_thread_ready(thread)) {
80003d50:	00098513          	mv	a0,s3
	thread->base.thread_state &= ~_THREAD_SUSPENDED;
80003d54:	feb7f793          	andi	a5,a5,-21
80003d58:	fef40aa3          	sb	a5,-11(s0)
	if (z_is_thread_ready(thread)) {
80003d5c:	c64ff0ef          	jal	ra,800031c0 <z_is_thread_ready>
80003d60:	02050463          	beqz	a0,80003d88 <z_thread_timeout+0x12c>
}
80003d64:	01812403          	lw	s0,24(sp)
80003d68:	01c12083          	lw	ra,28(sp)
80003d6c:	01412483          	lw	s1,20(sp)
80003d70:	01012903          	lw	s2,16(sp)
80003d74:	00812a03          	lw	s4,8(sp)
		z_add_thread_to_ready_q(thread);
80003d78:	00098513          	mv	a0,s3
80003d7c:	00c12983          	lw	s3,12(sp)
80003d80:	02010113          	addi	sp,sp,32
80003d84:	d49ff06f          	j	80003acc <z_add_thread_to_ready_q>
80003d88:	01c12083          	lw	ra,28(sp)
80003d8c:	01812403          	lw	s0,24(sp)
80003d90:	01412483          	lw	s1,20(sp)
80003d94:	01012903          	lw	s2,16(sp)
80003d98:	00c12983          	lw	s3,12(sp)
80003d9c:	00812a03          	lw	s4,8(sp)
80003da0:	02010113          	addi	sp,sp,32
80003da4:	00008067          	ret

80003da8 <z_move_thread_to_end_of_prio_q>:
{
80003da8:	fe010113          	addi	sp,sp,-32
80003dac:	00812c23          	sw	s0,24(sp)
80003db0:	01212823          	sw	s2,16(sp)
80003db4:	00112e23          	sw	ra,28(sp)
80003db8:	00912a23          	sw	s1,20(sp)
80003dbc:	01312623          	sw	s3,12(sp)
80003dc0:	01412423          	sw	s4,8(sp)
80003dc4:	01512223          	sw	s5,4(sp)
80003dc8:	00050413          	mv	s0,a0
	__asm__ volatile ("csrrc %0, mstatus, %1"
80003dcc:	00800913          	li	s2,8
80003dd0:	30093973          	csrrc	s2,mstatus,s2
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80003dd4:	800079b7          	lui	s3,0x80007
80003dd8:	e4898513          	addi	a0,s3,-440 # 80006e48 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006e49>
	key = (mstatus & SOC_MSTATUS_IEN);
80003ddc:	00897913          	andi	s2,s2,8
80003de0:	5b9000ef          	jal	ra,80004b98 <z_spin_lock_valid>
80003de4:	02051e63          	bnez	a0,80003e20 <z_move_thread_to_end_of_prio_q+0x78>
80003de8:	800074b7          	lui	s1,0x80007
80003dec:	800075b7          	lui	a1,0x80007
80003df0:	80006537          	lui	a0,0x80006
80003df4:	8c058593          	addi	a1,a1,-1856 # 800068c0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800068c1>
80003df8:	04e00693          	li	a3,78
80003dfc:	8a848613          	addi	a2,s1,-1880 # 800068a8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800068a9>
80003e00:	7dc50513          	addi	a0,a0,2012 # 800067dc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800067dd>
80003e04:	a6cfe0ef          	jal	ra,80002070 <printk>
80003e08:	80007537          	lui	a0,0x80007
80003e0c:	8d850513          	addi	a0,a0,-1832 # 800068d8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800068d9>
80003e10:	a60fe0ef          	jal	ra,80002070 <printk>
80003e14:	04e00593          	li	a1,78
80003e18:	8a848513          	addi	a0,s1,-1880
80003e1c:	a90fe0ef          	jal	ra,800020ac <assert_post_action>
	z_spin_lock_set_owner(l);
80003e20:	e4898513          	addi	a0,s3,-440
80003e24:	5cd000ef          	jal	ra,80004bf0 <z_spin_lock_set_owner>
		_priq_run_remove(&_kernel.ready_q.runq, thread);
80003e28:	800074b7          	lui	s1,0x80007
80003e2c:	13448513          	addi	a0,s1,308 # 80007134 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007135>
80003e30:	00040593          	mv	a1,s0
80003e34:	02450513          	addi	a0,a0,36
80003e38:	8c1ff0ef          	jal	ra,800036f8 <z_priq_dumb_remove>
	return thread == _idle_thread;
80003e3c:	800077b7          	lui	a5,0x80007
	__ASSERT_NO_MSG(!is_idle(thread));
80003e40:	d9c7a783          	lw	a5,-612(a5) # 80006d9c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006d9d>
80003e44:	80007a37          	lui	s4,0x80007
80003e48:	13448493          	addi	s1,s1,308
80003e4c:	158a0a13          	addi	s4,s4,344 # 80007158 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007159>
80003e50:	02f41863          	bne	s0,a5,80003e80 <z_move_thread_to_end_of_prio_q+0xd8>
80003e54:	80007ab7          	lui	s5,0x80007
80003e58:	800075b7          	lui	a1,0x80007
80003e5c:	80006537          	lui	a0,0x80006
80003e60:	b6c58593          	addi	a1,a1,-1172 # 80006b6c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006b6d>
80003e64:	7dc50513          	addi	a0,a0,2012 # 800067dc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800067dd>
80003e68:	27600693          	li	a3,630
80003e6c:	b20a8613          	addi	a2,s5,-1248 # 80006b20 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006b21>
80003e70:	a00fe0ef          	jal	ra,80002070 <printk>
80003e74:	27600593          	li	a1,630
80003e78:	b20a8513          	addi	a0,s5,-1248
80003e7c:	a30fe0ef          	jal	ra,800020ac <assert_post_action>
	return list->head == list;
80003e80:	0244a783          	lw	a5,36(s1)
80003e84:	0284a703          	lw	a4,40(s1)
	return sys_dlist_is_empty(list) ? NULL : list->head;
80003e88:	0b478e63          	beq	a5,s4,80003f44 <z_move_thread_to_end_of_prio_q+0x19c>
	SYS_DLIST_FOR_EACH_CONTAINER(pq, t, base.qnode_dlist) {
80003e8c:	0a078c63          	beqz	a5,80003f44 <z_move_thread_to_end_of_prio_q+0x19c>
	if (t1->base.prio < t2->base.prio) {
80003e90:	00e40683          	lb	a3,14(s0)
80003e94:	00e78603          	lb	a2,14(a5)
80003e98:	0ac6d063          	bge	a3,a2,80003f38 <z_move_thread_to_end_of_prio_q+0x190>
	node->prev = successor->prev;
80003e9c:	0047a703          	lw	a4,4(a5)
	node->next = successor;
80003ea0:	00f42023          	sw	a5,0(s0)
	node->prev = successor->prev;
80003ea4:	00e42223          	sw	a4,4(s0)
	successor->prev->next = node;
80003ea8:	00872023          	sw	s0,0(a4)
	successor->prev = node;
80003eac:	0087a223          	sw	s0,4(a5)
	thread->base.thread_state |= states;
80003eb0:	00d44783          	lbu	a5,13(s0)
		update_cache(thread == _current);
80003eb4:	0084a503          	lw	a0,8(s1)
80003eb8:	0407e793          	ori	a5,a5,64
80003ebc:	40850533          	sub	a0,a0,s0
80003ec0:	00153513          	seqz	a0,a0
80003ec4:	00f406a3          	sb	a5,13(s0)
80003ec8:	9bdff0ef          	jal	ra,80003884 <update_cache>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80003ecc:	e4898513          	addi	a0,s3,-440
80003ed0:	4f1000ef          	jal	ra,80004bc0 <z_spin_unlock_valid>
80003ed4:	02051e63          	bnez	a0,80003f10 <z_move_thread_to_end_of_prio_q+0x168>
80003ed8:	80007437          	lui	s0,0x80007
80003edc:	800075b7          	lui	a1,0x80007
80003ee0:	80006537          	lui	a0,0x80006
80003ee4:	8f058593          	addi	a1,a1,-1808 # 800068f0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800068f1>
80003ee8:	06100693          	li	a3,97
80003eec:	8a840613          	addi	a2,s0,-1880 # 800068a8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800068a9>
80003ef0:	7dc50513          	addi	a0,a0,2012 # 800067dc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800067dd>
80003ef4:	97cfe0ef          	jal	ra,80002070 <printk>
80003ef8:	80007537          	lui	a0,0x80007
80003efc:	90850513          	addi	a0,a0,-1784 # 80006908 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006909>
80003f00:	970fe0ef          	jal	ra,80002070 <printk>
80003f04:	06100593          	li	a1,97
80003f08:	8a840513          	addi	a0,s0,-1880
80003f0c:	9a0fe0ef          	jal	ra,800020ac <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80003f10:	30092973          	csrrs	s2,mstatus,s2
}
80003f14:	01c12083          	lw	ra,28(sp)
80003f18:	01812403          	lw	s0,24(sp)
80003f1c:	01412483          	lw	s1,20(sp)
80003f20:	01012903          	lw	s2,16(sp)
80003f24:	00c12983          	lw	s3,12(sp)
80003f28:	00812a03          	lw	s4,8(sp)
80003f2c:	00412a83          	lw	s5,4(sp)
80003f30:	02010113          	addi	sp,sp,32
80003f34:	00008067          	ret
	return (node == list->tail) ? NULL : node->next;
80003f38:	00e78663          	beq	a5,a4,80003f44 <z_move_thread_to_end_of_prio_q+0x19c>
80003f3c:	0007a783          	lw	a5,0(a5)
	SYS_DLIST_FOR_EACH_CONTAINER(pq, t, base.qnode_dlist) {
80003f40:	f4079ae3          	bnez	a5,80003e94 <z_move_thread_to_end_of_prio_q+0xec>
	node->prev = list->tail;
80003f44:	00e42223          	sw	a4,4(s0)
	list->tail->next = node;
80003f48:	0284a783          	lw	a5,40(s1)
	node->next = list;
80003f4c:	01442023          	sw	s4,0(s0)
	list->tail->next = node;
80003f50:	0087a023          	sw	s0,0(a5)
	list->tail = node;
80003f54:	0284a423          	sw	s0,40(s1)
80003f58:	f59ff06f          	j	80003eb0 <z_move_thread_to_end_of_prio_q+0x108>

80003f5c <z_time_slice>:
	if (slice_time && sliceable(_current)) {
80003f5c:	800077b7          	lui	a5,0x80007
80003f60:	e507a783          	lw	a5,-432(a5) # 80006e50 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006e51>
80003f64:	06078663          	beqz	a5,80003fd0 <z_time_slice+0x74>
80003f68:	800077b7          	lui	a5,0x80007
80003f6c:	13478793          	addi	a5,a5,308 # 80007134 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007135>
80003f70:	0087a703          	lw	a4,8(a5)
		&& !z_is_thread_timeout_active(t);
80003f74:	07f00693          	li	a3,127
80003f78:	00e75603          	lhu	a2,14(a4)
80003f7c:	04c6ea63          	bltu	a3,a2,80003fd0 <z_time_slice+0x74>
		&& !z_is_prio_higher(t->base.prio, slice_max_prio)
80003f80:	800076b7          	lui	a3,0x80007
80003f84:	00e70603          	lb	a2,14(a4)
80003f88:	e4c6a683          	lw	a3,-436(a3) # 80006e4c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006e4d>
80003f8c:	04d64263          	blt	a2,a3,80003fd0 <z_time_slice+0x74>
	return thread == _idle_thread;
80003f90:	800076b7          	lui	a3,0x80007
		&& !is_idle(t)
80003f94:	d9c6a683          	lw	a3,-612(a3) # 80006d9c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006d9d>
80003f98:	02d70c63          	beq	a4,a3,80003fd0 <z_time_slice+0x74>
		&& !z_is_thread_timeout_active(t);
80003f9c:	01872683          	lw	a3,24(a4)
80003fa0:	02069863          	bnez	a3,80003fd0 <z_time_slice+0x74>
		if (ticks >= _current_cpu->slice_ticks) {
80003fa4:	0107a683          	lw	a3,16(a5)
80003fa8:	02d54063          	blt	a0,a3,80003fc8 <z_time_slice+0x6c>
{
80003fac:	ff010113          	addi	sp,sp,-16
			z_move_thread_to_end_of_prio_q(_current);
80003fb0:	00070513          	mv	a0,a4
{
80003fb4:	00112623          	sw	ra,12(sp)
			z_move_thread_to_end_of_prio_q(_current);
80003fb8:	df1ff0ef          	jal	ra,80003da8 <z_move_thread_to_end_of_prio_q>
}
80003fbc:	00c12083          	lw	ra,12(sp)
80003fc0:	01010113          	addi	sp,sp,16
			reset_time_slice();
80003fc4:	a1cff06f          	j	800031e0 <reset_time_slice>
			_current_cpu->slice_ticks -= ticks;
80003fc8:	40a686b3          	sub	a3,a3,a0
80003fcc:	00d7a823          	sw	a3,16(a5)
80003fd0:	00008067          	ret

80003fd4 <z_remove_thread_from_ready_q>:
{
80003fd4:	fe010113          	addi	sp,sp,-32
80003fd8:	00812c23          	sw	s0,24(sp)
80003fdc:	01312623          	sw	s3,12(sp)
80003fe0:	00112e23          	sw	ra,28(sp)
80003fe4:	00912a23          	sw	s1,20(sp)
80003fe8:	01212823          	sw	s2,16(sp)
80003fec:	00050993          	mv	s3,a0
	__asm__ volatile ("csrrc %0, mstatus, %1"
80003ff0:	00800413          	li	s0,8
80003ff4:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80003ff8:	800074b7          	lui	s1,0x80007
80003ffc:	e4848513          	addi	a0,s1,-440 # 80006e48 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006e49>
	key = (mstatus & SOC_MSTATUS_IEN);
80004000:	00847413          	andi	s0,s0,8
80004004:	395000ef          	jal	ra,80004b98 <z_spin_lock_valid>
80004008:	02051e63          	bnez	a0,80004044 <z_remove_thread_from_ready_q+0x70>
8000400c:	80007937          	lui	s2,0x80007
80004010:	800075b7          	lui	a1,0x80007
80004014:	80006537          	lui	a0,0x80006
80004018:	8c058593          	addi	a1,a1,-1856 # 800068c0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800068c1>
8000401c:	04e00693          	li	a3,78
80004020:	8a890613          	addi	a2,s2,-1880 # 800068a8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800068a9>
80004024:	7dc50513          	addi	a0,a0,2012 # 800067dc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800067dd>
80004028:	848fe0ef          	jal	ra,80002070 <printk>
8000402c:	80007537          	lui	a0,0x80007
80004030:	8d850513          	addi	a0,a0,-1832 # 800068d8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800068d9>
80004034:	83cfe0ef          	jal	ra,80002070 <printk>
80004038:	04e00593          	li	a1,78
8000403c:	8a890513          	addi	a0,s2,-1880
80004040:	86cfe0ef          	jal	ra,800020ac <assert_post_action>
	z_spin_lock_set_owner(l);
80004044:	e4848513          	addi	a0,s1,-440
80004048:	3a9000ef          	jal	ra,80004bf0 <z_spin_lock_set_owner>
		if (z_is_thread_queued(thread)) {
8000404c:	00d9c783          	lbu	a5,13(s3)
80004050:	80007937          	lui	s2,0x80007
80004054:	13490913          	addi	s2,s2,308 # 80007134 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007135>
80004058:	0407f793          	andi	a5,a5,64
8000405c:	00078e63          	beqz	a5,80004078 <z_remove_thread_from_ready_q+0xa4>
			_priq_run_remove(&_kernel.ready_q.runq, thread);
80004060:	00098593          	mv	a1,s3
80004064:	02490513          	addi	a0,s2,36
80004068:	e90ff0ef          	jal	ra,800036f8 <z_priq_dumb_remove>
	thread->base.thread_state &= ~states;
8000406c:	00d9c783          	lbu	a5,13(s3)
80004070:	fbf7f793          	andi	a5,a5,-65
80004074:	00f986a3          	sb	a5,13(s3)
		update_cache(thread == _current);
80004078:	00892503          	lw	a0,8(s2)
8000407c:	41350533          	sub	a0,a0,s3
80004080:	00153513          	seqz	a0,a0
80004084:	801ff0ef          	jal	ra,80003884 <update_cache>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80004088:	e4848513          	addi	a0,s1,-440
8000408c:	335000ef          	jal	ra,80004bc0 <z_spin_unlock_valid>
80004090:	02051e63          	bnez	a0,800040cc <z_remove_thread_from_ready_q+0xf8>
80004094:	800074b7          	lui	s1,0x80007
80004098:	800075b7          	lui	a1,0x80007
8000409c:	80006537          	lui	a0,0x80006
800040a0:	8f058593          	addi	a1,a1,-1808 # 800068f0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800068f1>
800040a4:	06100693          	li	a3,97
800040a8:	8a848613          	addi	a2,s1,-1880 # 800068a8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800068a9>
800040ac:	7dc50513          	addi	a0,a0,2012 # 800067dc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800067dd>
800040b0:	fc1fd0ef          	jal	ra,80002070 <printk>
800040b4:	80007537          	lui	a0,0x80007
800040b8:	90850513          	addi	a0,a0,-1784 # 80006908 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006909>
800040bc:	fb5fd0ef          	jal	ra,80002070 <printk>
800040c0:	06100593          	li	a1,97
800040c4:	8a848513          	addi	a0,s1,-1880
800040c8:	fe5fd0ef          	jal	ra,800020ac <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
800040cc:	30042473          	csrrs	s0,mstatus,s0
}
800040d0:	01c12083          	lw	ra,28(sp)
800040d4:	01812403          	lw	s0,24(sp)
800040d8:	01412483          	lw	s1,20(sp)
800040dc:	01012903          	lw	s2,16(sp)
800040e0:	00c12983          	lw	s3,12(sp)
800040e4:	02010113          	addi	sp,sp,32
800040e8:	00008067          	ret

800040ec <pend>:
{
800040ec:	fe010113          	addi	sp,sp,-32
800040f0:	00812c23          	sw	s0,24(sp)
800040f4:	00912a23          	sw	s1,20(sp)
800040f8:	00050413          	mv	s0,a0
800040fc:	01212823          	sw	s2,16(sp)
80004100:	00112e23          	sw	ra,28(sp)
80004104:	01312623          	sw	s3,12(sp)
80004108:	00058493          	mv	s1,a1
8000410c:	00060913          	mv	s2,a2
	z_remove_thread_from_ready_q(thread);
80004110:	ec5ff0ef          	jal	ra,80003fd4 <z_remove_thread_from_ready_q>
	thread->base.thread_state |= _THREAD_PENDING;
80004114:	00d44783          	lbu	a5,13(s0)
80004118:	0027e793          	ori	a5,a5,2
8000411c:	00f406a3          	sb	a5,13(s0)
	if (wait_q != NULL) {
80004120:	06048663          	beqz	s1,8000418c <pend+0xa0>
	return thread == _idle_thread;
80004124:	800077b7          	lui	a5,0x80007
	__ASSERT_NO_MSG(!is_idle(thread));
80004128:	d9c7a783          	lw	a5,-612(a5) # 80006d9c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006d9d>
		thread->base.pended_on = wait_q;
8000412c:	00942423          	sw	s1,8(s0)
	__ASSERT_NO_MSG(!is_idle(thread));
80004130:	02f41863          	bne	s0,a5,80004160 <pend+0x74>
80004134:	800079b7          	lui	s3,0x80007
80004138:	800075b7          	lui	a1,0x80007
8000413c:	80006537          	lui	a0,0x80006
80004140:	b6c58593          	addi	a1,a1,-1172 # 80006b6c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006b6d>
80004144:	7dc50513          	addi	a0,a0,2012 # 800067dc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800067dd>
80004148:	27600693          	li	a3,630
8000414c:	b2098613          	addi	a2,s3,-1248 # 80006b20 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006b21>
80004150:	f21fd0ef          	jal	ra,80002070 <printk>
80004154:	27600593          	li	a1,630
80004158:	b2098513          	addi	a0,s3,-1248
8000415c:	f51fd0ef          	jal	ra,800020ac <assert_post_action>
	return list->head == list;
80004160:	0004a783          	lw	a5,0(s1)
	return sys_dlist_is_empty(list) ? NULL : list->head;
80004164:	06f48c63          	beq	s1,a5,800041dc <pend+0xf0>
	SYS_DLIST_FOR_EACH_CONTAINER(pq, t, base.qnode_dlist) {
80004168:	06078a63          	beqz	a5,800041dc <pend+0xf0>
	if (t1->base.prio < t2->base.prio) {
8000416c:	00e40703          	lb	a4,14(s0)
80004170:	00e78683          	lb	a3,14(a5)
80004174:	04d75c63          	bge	a4,a3,800041cc <pend+0xe0>
	node->prev = successor->prev;
80004178:	0047a703          	lw	a4,4(a5)
	node->next = successor;
8000417c:	00f42023          	sw	a5,0(s0)
	node->prev = successor->prev;
80004180:	00e42223          	sw	a4,4(s0)
	successor->prev->next = node;
80004184:	00872023          	sw	s0,0(a4)
	successor->prev = node;
80004188:	0087a223          	sw	s0,4(a5)
	if (timeout != K_FOREVER) {
8000418c:	fff00793          	li	a5,-1
80004190:	06f90463          	beq	s2,a5,800041f8 <pend+0x10c>
80004194:	00a00593          	li	a1,10
80004198:	00990513          	addi	a0,s2,9
8000419c:	f9cfc0ef          	jal	ra,80000938 <__divsi3>
	z_add_timeout(&th->base.timeout, z_thread_timeout, ticks);
800041a0:	00150613          	addi	a2,a0,1
800041a4:	01840513          	addi	a0,s0,24
}
800041a8:	01812403          	lw	s0,24(sp)
800041ac:	01c12083          	lw	ra,28(sp)
800041b0:	01412483          	lw	s1,20(sp)
800041b4:	01012903          	lw	s2,16(sp)
800041b8:	00c12983          	lw	s3,12(sp)
800041bc:	800045b7          	lui	a1,0x80004
800041c0:	c5c58593          	addi	a1,a1,-932 # 80003c5c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80003c5d>
800041c4:	02010113          	addi	sp,sp,32
800041c8:	78d0006f          	j	80005154 <z_add_timeout>
	return (node == list->tail) ? NULL : node->next;
800041cc:	0044a683          	lw	a3,4(s1)
800041d0:	00d78663          	beq	a5,a3,800041dc <pend+0xf0>
800041d4:	0007a783          	lw	a5,0(a5)
	SYS_DLIST_FOR_EACH_CONTAINER(pq, t, base.qnode_dlist) {
800041d8:	f8079ce3          	bnez	a5,80004170 <pend+0x84>
	node->prev = list->tail;
800041dc:	0044a783          	lw	a5,4(s1)
	node->next = list;
800041e0:	00942023          	sw	s1,0(s0)
	node->prev = list->tail;
800041e4:	00f42223          	sw	a5,4(s0)
	list->tail->next = node;
800041e8:	0044a783          	lw	a5,4(s1)
800041ec:	0087a023          	sw	s0,0(a5)
	list->tail = node;
800041f0:	0084a223          	sw	s0,4(s1)
800041f4:	f99ff06f          	j	8000418c <pend+0xa0>
}
800041f8:	01c12083          	lw	ra,28(sp)
800041fc:	01812403          	lw	s0,24(sp)
80004200:	01412483          	lw	s1,20(sp)
80004204:	01012903          	lw	s2,16(sp)
80004208:	00c12983          	lw	s3,12(sp)
8000420c:	02010113          	addi	sp,sp,32
80004210:	00008067          	ret

80004214 <z_pend_curr_irqlock>:
{
80004214:	ff010113          	addi	sp,sp,-16
	pend(_current, wait_q, timeout);
80004218:	800077b7          	lui	a5,0x80007
{
8000421c:	00812423          	sw	s0,8(sp)
80004220:	00050413          	mv	s0,a0
	pend(_current, wait_q, timeout);
80004224:	13c7a503          	lw	a0,316(a5) # 8000713c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000713d>
{
80004228:	00112623          	sw	ra,12(sp)
	pend(_current, wait_q, timeout);
8000422c:	ec1ff0ef          	jal	ra,800040ec <pend>
80004230:	00040513          	mv	a0,s0
}
80004234:	00812403          	lw	s0,8(sp)
80004238:	00c12083          	lw	ra,12(sp)
8000423c:	01010113          	addi	sp,sp,16
80004240:	fe9fb06f          	j	80000228 <__swap>

80004244 <z_pend_curr>:
{
80004244:	ff010113          	addi	sp,sp,-16
	pend(_current, wait_q, timeout);
80004248:	800077b7          	lui	a5,0x80007
{
8000424c:	00812423          	sw	s0,8(sp)
80004250:	00050413          	mv	s0,a0
	pend(_current, wait_q, timeout);
80004254:	13c7a503          	lw	a0,316(a5) # 8000713c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000713d>
{
80004258:	00912223          	sw	s1,4(sp)
8000425c:	00058493          	mv	s1,a1
80004260:	00060593          	mv	a1,a2
	pend(_current, wait_q, timeout);
80004264:	00068613          	mv	a2,a3
{
80004268:	00112623          	sw	ra,12(sp)
	pend(_current, wait_q, timeout);
8000426c:	e81ff0ef          	jal	ra,800040ec <pend>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80004270:	00040513          	mv	a0,s0
80004274:	14d000ef          	jal	ra,80004bc0 <z_spin_unlock_valid>
80004278:	02051e63          	bnez	a0,800042b4 <z_pend_curr+0x70>
8000427c:	80007437          	lui	s0,0x80007
80004280:	800075b7          	lui	a1,0x80007
80004284:	80006537          	lui	a0,0x80006
80004288:	8f058593          	addi	a1,a1,-1808 # 800068f0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800068f1>
8000428c:	07800693          	li	a3,120
80004290:	8a840613          	addi	a2,s0,-1880 # 800068a8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800068a9>
80004294:	7dc50513          	addi	a0,a0,2012 # 800067dc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800067dd>
80004298:	dd9fd0ef          	jal	ra,80002070 <printk>
8000429c:	80007537          	lui	a0,0x80007
800042a0:	90850513          	addi	a0,a0,-1784 # 80006908 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006909>
800042a4:	dcdfd0ef          	jal	ra,80002070 <printk>
800042a8:	07800593          	li	a1,120
800042ac:	8a840513          	addi	a0,s0,-1880
800042b0:	dfdfd0ef          	jal	ra,800020ac <assert_post_action>
}
800042b4:	00812403          	lw	s0,8(sp)
800042b8:	00c12083          	lw	ra,12(sp)
800042bc:	00048513          	mv	a0,s1
800042c0:	00412483          	lw	s1,4(sp)
800042c4:	01010113          	addi	sp,sp,16
800042c8:	f61fb06f          	j	80000228 <__swap>

800042cc <z_unpend_first_thread>:
{
800042cc:	fe010113          	addi	sp,sp,-32
800042d0:	01212823          	sw	s2,16(sp)
800042d4:	01312623          	sw	s3,12(sp)
800042d8:	00112e23          	sw	ra,28(sp)
800042dc:	00812c23          	sw	s0,24(sp)
800042e0:	00912a23          	sw	s1,20(sp)
800042e4:	00050993          	mv	s3,a0
	__asm__ volatile ("csrrc %0, mstatus, %1"
800042e8:	00800913          	li	s2,8
800042ec:	30093973          	csrrc	s2,mstatus,s2
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
800042f0:	800074b7          	lui	s1,0x80007
800042f4:	e4848513          	addi	a0,s1,-440 # 80006e48 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006e49>
	key = (mstatus & SOC_MSTATUS_IEN);
800042f8:	00897913          	andi	s2,s2,8
800042fc:	09d000ef          	jal	ra,80004b98 <z_spin_lock_valid>
80004300:	02051e63          	bnez	a0,8000433c <z_unpend_first_thread+0x70>
80004304:	80007437          	lui	s0,0x80007
80004308:	800075b7          	lui	a1,0x80007
8000430c:	80006537          	lui	a0,0x80006
80004310:	8c058593          	addi	a1,a1,-1856 # 800068c0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800068c1>
80004314:	04e00693          	li	a3,78
80004318:	8a840613          	addi	a2,s0,-1880 # 800068a8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800068a9>
8000431c:	7dc50513          	addi	a0,a0,2012 # 800067dc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800067dd>
80004320:	d51fd0ef          	jal	ra,80002070 <printk>
80004324:	80007537          	lui	a0,0x80007
80004328:	8d850513          	addi	a0,a0,-1832 # 800068d8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800068d9>
8000432c:	d45fd0ef          	jal	ra,80002070 <printk>
80004330:	04e00593          	li	a1,78
80004334:	8a840513          	addi	a0,s0,-1880
80004338:	d75fd0ef          	jal	ra,800020ac <assert_post_action>
	z_spin_lock_set_owner(l);
8000433c:	e4848513          	addi	a0,s1,-440
80004340:	0b1000ef          	jal	ra,80004bf0 <z_spin_lock_set_owner>
		ret = _priq_wait_best(&wait_q->waitq);
80004344:	00098513          	mv	a0,s3
80004348:	d28ff0ef          	jal	ra,80003870 <z_priq_dumb_best>
8000434c:	00050413          	mv	s0,a0
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80004350:	e4848513          	addi	a0,s1,-440
80004354:	06d000ef          	jal	ra,80004bc0 <z_spin_unlock_valid>
80004358:	02051e63          	bnez	a0,80004394 <z_unpend_first_thread+0xc8>
8000435c:	800079b7          	lui	s3,0x80007
80004360:	800075b7          	lui	a1,0x80007
80004364:	80006537          	lui	a0,0x80006
80004368:	8f058593          	addi	a1,a1,-1808 # 800068f0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800068f1>
8000436c:	06100693          	li	a3,97
80004370:	8a898613          	addi	a2,s3,-1880 # 800068a8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800068a9>
80004374:	7dc50513          	addi	a0,a0,2012 # 800067dc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800067dd>
80004378:	cf9fd0ef          	jal	ra,80002070 <printk>
8000437c:	80007537          	lui	a0,0x80007
80004380:	90850513          	addi	a0,a0,-1784 # 80006908 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006909>
80004384:	cedfd0ef          	jal	ra,80002070 <printk>
80004388:	06100593          	li	a1,97
8000438c:	8a898513          	addi	a0,s3,-1880
80004390:	d1dfd0ef          	jal	ra,800020ac <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80004394:	30092973          	csrrs	s2,mstatus,s2

static inline struct k_thread *z_unpend1_no_timeout(_wait_q_t *wait_q)
{
	struct k_thread *thread = z_find_first_thread_to_unpend(wait_q, NULL);

	if (thread != NULL) {
80004398:	0c040663          	beqz	s0,80004464 <z_unpend_first_thread+0x198>
	__asm__ volatile ("csrrc %0, mstatus, %1"
8000439c:	00800913          	li	s2,8
800043a0:	30093973          	csrrc	s2,mstatus,s2
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
800043a4:	e4848513          	addi	a0,s1,-440
	key = (mstatus & SOC_MSTATUS_IEN);
800043a8:	00897913          	andi	s2,s2,8
800043ac:	7ec000ef          	jal	ra,80004b98 <z_spin_lock_valid>
800043b0:	02051e63          	bnez	a0,800043ec <z_unpend_first_thread+0x120>
800043b4:	800079b7          	lui	s3,0x80007
800043b8:	800075b7          	lui	a1,0x80007
800043bc:	80006537          	lui	a0,0x80006
800043c0:	8c058593          	addi	a1,a1,-1856 # 800068c0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800068c1>
800043c4:	04e00693          	li	a3,78
800043c8:	8a898613          	addi	a2,s3,-1880 # 800068a8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800068a9>
800043cc:	7dc50513          	addi	a0,a0,2012 # 800067dc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800067dd>
800043d0:	ca1fd0ef          	jal	ra,80002070 <printk>
800043d4:	80007537          	lui	a0,0x80007
800043d8:	8d850513          	addi	a0,a0,-1832 # 800068d8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800068d9>
800043dc:	c95fd0ef          	jal	ra,80002070 <printk>
800043e0:	04e00593          	li	a1,78
800043e4:	8a898513          	addi	a0,s3,-1880
800043e8:	cc5fd0ef          	jal	ra,800020ac <assert_post_action>
	z_spin_lock_set_owner(l);
800043ec:	e4848513          	addi	a0,s1,-440
800043f0:	001000ef          	jal	ra,80004bf0 <z_spin_lock_set_owner>
		_priq_wait_remove(&pended_on(thread)->waitq, thread);
800043f4:	00840513          	addi	a0,s0,8
800043f8:	e1dfe0ef          	jal	ra,80003214 <pended_on.isra.15>
800043fc:	00040593          	mv	a1,s0
80004400:	af8ff0ef          	jal	ra,800036f8 <z_priq_dumb_remove>
	thread->base.thread_state &= ~_THREAD_PENDING;
80004404:	00d44783          	lbu	a5,13(s0)
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80004408:	e4848513          	addi	a0,s1,-440
8000440c:	ffd7f793          	andi	a5,a5,-3
80004410:	00f406a3          	sb	a5,13(s0)
80004414:	7ac000ef          	jal	ra,80004bc0 <z_spin_unlock_valid>
80004418:	02051e63          	bnez	a0,80004454 <z_unpend_first_thread+0x188>
8000441c:	800074b7          	lui	s1,0x80007
80004420:	800075b7          	lui	a1,0x80007
80004424:	80006537          	lui	a0,0x80006
80004428:	8f058593          	addi	a1,a1,-1808 # 800068f0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800068f1>
8000442c:	06100693          	li	a3,97
80004430:	8a848613          	addi	a2,s1,-1880 # 800068a8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800068a9>
80004434:	7dc50513          	addi	a0,a0,2012 # 800067dc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800067dd>
80004438:	c39fd0ef          	jal	ra,80002070 <printk>
8000443c:	80007537          	lui	a0,0x80007
80004440:	90850513          	addi	a0,a0,-1784 # 80006908 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006909>
80004444:	c2dfd0ef          	jal	ra,80002070 <printk>
80004448:	06100593          	li	a1,97
8000444c:	8a848513          	addi	a0,s1,-1880
80004450:	c5dfd0ef          	jal	ra,800020ac <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80004454:	30092973          	csrrs	s2,mstatus,s2
	thread->base.pended_on = NULL;
80004458:	00042423          	sw	zero,8(s0)
	return z_abort_timeout(&thread->base.timeout);
8000445c:	01840513          	addi	a0,s0,24
80004460:	721000ef          	jal	ra,80005380 <z_abort_timeout>
}
80004464:	00040513          	mv	a0,s0
80004468:	01c12083          	lw	ra,28(sp)
8000446c:	01812403          	lw	s0,24(sp)
80004470:	01412483          	lw	s1,20(sp)
80004474:	01012903          	lw	s2,16(sp)
80004478:	00c12983          	lw	s3,12(sp)
8000447c:	02010113          	addi	sp,sp,32
80004480:	00008067          	ret

80004484 <z_unpend_all>:
	}
	return t;
}

int z_unpend_all(_wait_q_t *wait_q)
{
80004484:	ff010113          	addi	sp,sp,-16
80004488:	00912223          	sw	s1,4(sp)
8000448c:	01212023          	sw	s2,0(sp)
80004490:	00112623          	sw	ra,12(sp)
80004494:	00812423          	sw	s0,8(sp)
80004498:	00050913          	mv	s2,a0
	int need_sched = 0;
8000449c:	00000493          	li	s1,0
	return list->head == list;
800044a0:	00092403          	lw	s0,0(s2)
	return sys_dlist_is_empty(list) ? NULL : list->head;
800044a4:	00890463          	beq	s2,s0,800044ac <z_unpend_all+0x28>
	struct k_thread *th;

	while ((th = z_waitq_head(wait_q)) != NULL) {
800044a8:	02041063          	bnez	s0,800044c8 <z_unpend_all+0x44>
		z_ready_thread(th);
		need_sched = 1;
	}

	return need_sched;
}
800044ac:	00c12083          	lw	ra,12(sp)
800044b0:	00812403          	lw	s0,8(sp)
800044b4:	00048513          	mv	a0,s1
800044b8:	00012903          	lw	s2,0(sp)
800044bc:	00412483          	lw	s1,4(sp)
800044c0:	01010113          	addi	sp,sp,16
800044c4:	00008067          	ret
		z_unpend_thread(th);
800044c8:	00040513          	mv	a0,s0
800044cc:	aa4ff0ef          	jal	ra,80003770 <z_unpend_thread>
	if (z_is_thread_ready(thread)) {
800044d0:	00040513          	mv	a0,s0
800044d4:	cedfe0ef          	jal	ra,800031c0 <z_is_thread_ready>
		need_sched = 1;
800044d8:	00100493          	li	s1,1
800044dc:	fc0502e3          	beqz	a0,800044a0 <z_unpend_all+0x1c>
		z_add_thread_to_ready_q(thread);
800044e0:	00040513          	mv	a0,s0
800044e4:	de8ff0ef          	jal	ra,80003acc <z_add_thread_to_ready_q>
800044e8:	fb9ff06f          	j	800044a0 <z_unpend_all+0x1c>

800044ec <z_sched_init>:
	list->head = (sys_dnode_t *)list;
800044ec:	800077b7          	lui	a5,0x80007
800044f0:	13478793          	addi	a5,a5,308 # 80007134 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007135>
800044f4:	02478713          	addi	a4,a5,36
800044f8:	02e7a223          	sw	a4,36(a5)
	list->tail = (sys_dnode_t *)list;
800044fc:	02e7a423          	sw	a4,40(a5)
		sys_dlist_init(&_kernel.ready_q.runq.queues[i]);
	}
#endif

#ifdef CONFIG_TIMESLICING
	k_sched_time_slice_set(CONFIG_TIMESLICE_SIZE,
80004500:	00000593          	li	a1,0
80004504:	00000513          	li	a0,0
80004508:	d6dfe06f          	j	80003274 <k_sched_time_slice_set>

8000450c <z_impl_k_yield>:
}
#endif
#endif

void z_impl_k_yield(void)
{
8000450c:	fe010113          	addi	sp,sp,-32
80004510:	00812c23          	sw	s0,24(sp)
	__ASSERT(!z_is_in_isr(), "");
80004514:	80007437          	lui	s0,0x80007
80004518:	13442783          	lw	a5,308(s0) # 80007134 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007135>
{
8000451c:	00112e23          	sw	ra,28(sp)
80004520:	00912a23          	sw	s1,20(sp)
80004524:	01212823          	sw	s2,16(sp)
80004528:	01312623          	sw	s3,12(sp)
8000452c:	01412423          	sw	s4,8(sp)
80004530:	01512223          	sw	s5,4(sp)
80004534:	13440413          	addi	s0,s0,308
	__ASSERT(!z_is_in_isr(), "");
80004538:	02078e63          	beqz	a5,80004574 <z_impl_k_yield+0x68>
8000453c:	800074b7          	lui	s1,0x80007
80004540:	800075b7          	lui	a1,0x80007
80004544:	80006537          	lui	a0,0x80006
80004548:	ab858593          	addi	a1,a1,-1352 # 80006ab8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006ab9>
8000454c:	37e00693          	li	a3,894
80004550:	b2048613          	addi	a2,s1,-1248 # 80006b20 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006b21>
80004554:	7dc50513          	addi	a0,a0,2012 # 800067dc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800067dd>
80004558:	b19fd0ef          	jal	ra,80002070 <printk>
8000455c:	80007537          	lui	a0,0x80007
80004560:	86050513          	addi	a0,a0,-1952 # 80006860 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006861>
80004564:	b0dfd0ef          	jal	ra,80002070 <printk>
80004568:	37e00593          	li	a1,894
8000456c:	b2048513          	addi	a0,s1,-1248
80004570:	b3dfd0ef          	jal	ra,800020ac <assert_post_action>
	return thread == _idle_thread;
80004574:	800077b7          	lui	a5,0x80007

	if (!is_idle(_current)) {
80004578:	00842683          	lw	a3,8(s0)
8000457c:	d9c7a703          	lw	a4,-612(a5) # 80006d9c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006d9d>
80004580:	00078a13          	mv	s4,a5
80004584:	12e68663          	beq	a3,a4,800046b0 <z_impl_k_yield+0x1a4>
	__asm__ volatile ("csrrc %0, mstatus, %1"
80004588:	00800913          	li	s2,8
8000458c:	30093973          	csrrc	s2,mstatus,s2
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80004590:	800079b7          	lui	s3,0x80007
80004594:	e4898513          	addi	a0,s3,-440 # 80006e48 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006e49>
	key = (mstatus & SOC_MSTATUS_IEN);
80004598:	00897913          	andi	s2,s2,8
8000459c:	5fc000ef          	jal	ra,80004b98 <z_spin_lock_valid>
800045a0:	02051e63          	bnez	a0,800045dc <z_impl_k_yield+0xd0>
800045a4:	800074b7          	lui	s1,0x80007
800045a8:	800075b7          	lui	a1,0x80007
800045ac:	80006537          	lui	a0,0x80006
800045b0:	8c058593          	addi	a1,a1,-1856 # 800068c0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800068c1>
800045b4:	04e00693          	li	a3,78
800045b8:	8a848613          	addi	a2,s1,-1880 # 800068a8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800068a9>
800045bc:	7dc50513          	addi	a0,a0,2012 # 800067dc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800067dd>
800045c0:	ab1fd0ef          	jal	ra,80002070 <printk>
800045c4:	80007537          	lui	a0,0x80007
800045c8:	8d850513          	addi	a0,a0,-1832 # 800068d8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800068d9>
800045cc:	aa5fd0ef          	jal	ra,80002070 <printk>
800045d0:	04e00593          	li	a1,78
800045d4:	8a848513          	addi	a0,s1,-1880
800045d8:	ad5fd0ef          	jal	ra,800020ac <assert_post_action>
	z_spin_lock_set_owner(l);
800045dc:	e4898513          	addi	a0,s3,-440
800045e0:	610000ef          	jal	ra,80004bf0 <z_spin_lock_set_owner>
		LOCKED(&sched_spinlock) {
			if (!IS_ENABLED(CONFIG_SMP) ||
			    z_is_thread_queued(_current)) {
				_priq_run_remove(&_kernel.ready_q.runq,
800045e4:	00842583          	lw	a1,8(s0)
800045e8:	02440513          	addi	a0,s0,36
800045ec:	90cff0ef          	jal	ra,800036f8 <z_priq_dumb_remove>
	__ASSERT_NO_MSG(!is_idle(thread));
800045f0:	d9ca2783          	lw	a5,-612(s4)
						 _current);
				_priq_run_add(&_kernel.ready_q.runq,
800045f4:	00842483          	lw	s1,8(s0)
	return thread == _idle_thread;
800045f8:	80007a37          	lui	s4,0x80007
800045fc:	158a0a13          	addi	s4,s4,344 # 80007158 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007159>
	__ASSERT_NO_MSG(!is_idle(thread));
80004600:	02f49863          	bne	s1,a5,80004630 <z_impl_k_yield+0x124>
80004604:	80007ab7          	lui	s5,0x80007
80004608:	800075b7          	lui	a1,0x80007
8000460c:	80006537          	lui	a0,0x80006
80004610:	b6c58593          	addi	a1,a1,-1172 # 80006b6c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006b6d>
80004614:	7dc50513          	addi	a0,a0,2012 # 800067dc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800067dd>
80004618:	27600693          	li	a3,630
8000461c:	b20a8613          	addi	a2,s5,-1248 # 80006b20 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006b21>
80004620:	a51fd0ef          	jal	ra,80002070 <printk>
80004624:	27600593          	li	a1,630
80004628:	b20a8513          	addi	a0,s5,-1248
8000462c:	a81fd0ef          	jal	ra,800020ac <assert_post_action>
	return list->head == list;
80004630:	02442783          	lw	a5,36(s0)
80004634:	02842703          	lw	a4,40(s0)
	return sys_dlist_is_empty(list) ? NULL : list->head;
80004638:	0b478a63          	beq	a5,s4,800046ec <z_impl_k_yield+0x1e0>
	SYS_DLIST_FOR_EACH_CONTAINER(pq, t, base.qnode_dlist) {
8000463c:	0a078863          	beqz	a5,800046ec <z_impl_k_yield+0x1e0>
	if (t1->base.prio < t2->base.prio) {
80004640:	00e48683          	lb	a3,14(s1)
80004644:	00e78603          	lb	a2,14(a5)
80004648:	08c6dc63          	bge	a3,a2,800046e0 <z_impl_k_yield+0x1d4>
	node->prev = successor->prev;
8000464c:	0047a703          	lw	a4,4(a5)
	node->next = successor;
80004650:	00f4a023          	sw	a5,0(s1)
	node->prev = successor->prev;
80004654:	00e4a223          	sw	a4,4(s1)
	successor->prev->next = node;
80004658:	00972023          	sw	s1,0(a4)
	successor->prev = node;
8000465c:	0097a223          	sw	s1,4(a5)
					      _current);
			}
			update_cache(1);
80004660:	00100513          	li	a0,1
80004664:	a20ff0ef          	jal	ra,80003884 <update_cache>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80004668:	e4898513          	addi	a0,s3,-440
8000466c:	554000ef          	jal	ra,80004bc0 <z_spin_unlock_valid>
80004670:	02051e63          	bnez	a0,800046ac <z_impl_k_yield+0x1a0>
80004674:	80007437          	lui	s0,0x80007
80004678:	800075b7          	lui	a1,0x80007
8000467c:	80006537          	lui	a0,0x80006
80004680:	8f058593          	addi	a1,a1,-1808 # 800068f0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800068f1>
80004684:	06100693          	li	a3,97
80004688:	8a840613          	addi	a2,s0,-1880 # 800068a8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800068a9>
8000468c:	7dc50513          	addi	a0,a0,2012 # 800067dc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800067dd>
80004690:	9e1fd0ef          	jal	ra,80002070 <printk>
80004694:	80007537          	lui	a0,0x80007
80004698:	90850513          	addi	a0,a0,-1784 # 80006908 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006909>
8000469c:	9d5fd0ef          	jal	ra,80002070 <printk>
800046a0:	06100593          	li	a1,97
800046a4:	8a840513          	addi	a0,s0,-1880
800046a8:	a05fd0ef          	jal	ra,800020ac <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
800046ac:	30092973          	csrrs	s2,mstatus,s2
	__asm__ volatile ("csrrc %0, mstatus, %1"
800046b0:	00800513          	li	a0,8
800046b4:	30053573          	csrrc	a0,mstatus,a0
		}
	}
	z_swap_unlocked();
}
800046b8:	01812403          	lw	s0,24(sp)
800046bc:	01c12083          	lw	ra,28(sp)
800046c0:	01412483          	lw	s1,20(sp)
800046c4:	01012903          	lw	s2,16(sp)
800046c8:	00c12983          	lw	s3,12(sp)
800046cc:	00812a03          	lw	s4,8(sp)
800046d0:	00412a83          	lw	s5,4(sp)
800046d4:	00857513          	andi	a0,a0,8
800046d8:	02010113          	addi	sp,sp,32
800046dc:	b4dfb06f          	j	80000228 <__swap>
	return (node == list->tail) ? NULL : node->next;
800046e0:	00e78663          	beq	a5,a4,800046ec <z_impl_k_yield+0x1e0>
800046e4:	0007a783          	lw	a5,0(a5)
	SYS_DLIST_FOR_EACH_CONTAINER(pq, t, base.qnode_dlist) {
800046e8:	f4079ee3          	bnez	a5,80004644 <z_impl_k_yield+0x138>
	node->prev = list->tail;
800046ec:	00e4a223          	sw	a4,4(s1)
	list->tail->next = node;
800046f0:	02842783          	lw	a5,40(s0)
	node->next = list;
800046f4:	0144a023          	sw	s4,0(s1)
	list->tail->next = node;
800046f8:	0097a023          	sw	s1,0(a5)
	list->tail = node;
800046fc:	02942423          	sw	s1,40(s0)
80004700:	f61ff06f          	j	80004660 <z_impl_k_yield+0x154>

80004704 <z_impl_k_current_get>:
#endif

k_tid_t z_impl_k_current_get(void)
{
	return _current;
}
80004704:	800077b7          	lui	a5,0x80007
80004708:	13c7a503          	lw	a0,316(a5) # 8000713c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000713d>
8000470c:	00008067          	ret

80004710 <z_impl_k_sem_init>:

#endif /* CONFIG_OBJECT_TRACING */

void z_impl_k_sem_init(struct k_sem *sem, unsigned int initial_count,
		      unsigned int limit)
{
80004710:	fe010113          	addi	sp,sp,-32
80004714:	00812c23          	sw	s0,24(sp)
80004718:	00912a23          	sw	s1,20(sp)
8000471c:	01212823          	sw	s2,16(sp)
80004720:	00112e23          	sw	ra,28(sp)
80004724:	01312623          	sw	s3,12(sp)
80004728:	00050413          	mv	s0,a0
8000472c:	00058913          	mv	s2,a1
80004730:	00060493          	mv	s1,a2
	__ASSERT(limit != 0U, "limit cannot be zero");
80004734:	02061e63          	bnez	a2,80004770 <z_impl_k_sem_init+0x60>
80004738:	800079b7          	lui	s3,0x80007
8000473c:	800075b7          	lui	a1,0x80007
80004740:	80006537          	lui	a0,0x80006
80004744:	b9058593          	addi	a1,a1,-1136 # 80006b90 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006b91>
80004748:	04600693          	li	a3,70
8000474c:	b8098613          	addi	a2,s3,-1152 # 80006b80 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006b81>
80004750:	7dc50513          	addi	a0,a0,2012 # 800067dc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800067dd>
80004754:	91dfd0ef          	jal	ra,80002070 <printk>
80004758:	80007537          	lui	a0,0x80007
8000475c:	b9c50513          	addi	a0,a0,-1124 # 80006b9c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006b9d>
80004760:	911fd0ef          	jal	ra,80002070 <printk>
80004764:	04600593          	li	a1,70
80004768:	b8098513          	addi	a0,s3,-1152
8000476c:	941fd0ef          	jal	ra,800020ac <assert_post_action>
	__ASSERT(initial_count <= limit, "count cannot be greater than limit");
80004770:	0324fe63          	bgeu	s1,s2,800047ac <z_impl_k_sem_init+0x9c>
80004774:	800079b7          	lui	s3,0x80007
80004778:	800075b7          	lui	a1,0x80007
8000477c:	80006537          	lui	a0,0x80006
80004780:	bb458593          	addi	a1,a1,-1100 # 80006bb4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006bb5>
80004784:	04700693          	li	a3,71
80004788:	b8098613          	addi	a2,s3,-1152 # 80006b80 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006b81>
8000478c:	7dc50513          	addi	a0,a0,2012 # 800067dc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800067dd>
80004790:	8e1fd0ef          	jal	ra,80002070 <printk>
80004794:	80007537          	lui	a0,0x80007
80004798:	bcc50513          	addi	a0,a0,-1076 # 80006bcc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006bcd>
8000479c:	8d5fd0ef          	jal	ra,80002070 <printk>
800047a0:	04700593          	li	a1,71
800047a4:	b8098513          	addi	a0,s3,-1152
800047a8:	905fd0ef          	jal	ra,800020ac <assert_post_action>

	sys_trace_void(SYS_TRACE_ID_SEMA_INIT);
	sem->count = initial_count;
800047ac:	01242423          	sw	s2,8(s0)
	sem->limit = limit;
800047b0:	00942623          	sw	s1,12(s0)
	list->head = (sys_dnode_t *)list;
800047b4:	00842023          	sw	s0,0(s0)
	list->tail = (sys_dnode_t *)list;
800047b8:	00842223          	sw	s0,4(s0)

	SYS_TRACING_OBJ_INIT(k_sem, sem);

	z_object_init(sem);
	sys_trace_end_call(SYS_TRACE_ID_SEMA_INIT);
}
800047bc:	01c12083          	lw	ra,28(sp)
800047c0:	01812403          	lw	s0,24(sp)
800047c4:	01412483          	lw	s1,20(sp)
800047c8:	01012903          	lw	s2,16(sp)
800047cc:	00c12983          	lw	s3,12(sp)
800047d0:	02010113          	addi	sp,sp,32
800047d4:	00008067          	ret

800047d8 <z_impl_k_sem_give>:
		handle_poll_events(sem);
	}
}

void z_impl_k_sem_give(struct k_sem *sem)
{
800047d8:	fe010113          	addi	sp,sp,-32
800047dc:	00912a23          	sw	s1,20(sp)
800047e0:	01312623          	sw	s3,12(sp)
800047e4:	00112e23          	sw	ra,28(sp)
800047e8:	00812c23          	sw	s0,24(sp)
800047ec:	01212823          	sw	s2,16(sp)
800047f0:	00050993          	mv	s3,a0
800047f4:	00800493          	li	s1,8
800047f8:	3004b4f3          	csrrc	s1,mstatus,s1
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
800047fc:	80007437          	lui	s0,0x80007
80004800:	e5440513          	addi	a0,s0,-428 # 80006e54 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006e55>
	key = (mstatus & SOC_MSTATUS_IEN);
80004804:	0084f493          	andi	s1,s1,8
80004808:	390000ef          	jal	ra,80004b98 <z_spin_lock_valid>
8000480c:	02051e63          	bnez	a0,80004848 <z_impl_k_sem_give+0x70>
80004810:	80007937          	lui	s2,0x80007
80004814:	800075b7          	lui	a1,0x80007
80004818:	80006537          	lui	a0,0x80006
8000481c:	8c058593          	addi	a1,a1,-1856 # 800068c0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800068c1>
80004820:	04e00693          	li	a3,78
80004824:	8a890613          	addi	a2,s2,-1880 # 800068a8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800068a9>
80004828:	7dc50513          	addi	a0,a0,2012 # 800067dc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800067dd>
8000482c:	845fd0ef          	jal	ra,80002070 <printk>
80004830:	80007537          	lui	a0,0x80007
80004834:	8d850513          	addi	a0,a0,-1832 # 800068d8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800068d9>
80004838:	839fd0ef          	jal	ra,80002070 <printk>
8000483c:	04e00593          	li	a1,78
80004840:	8a890513          	addi	a0,s2,-1880
80004844:	869fd0ef          	jal	ra,800020ac <assert_post_action>
	z_spin_lock_set_owner(l);
80004848:	e5440513          	addi	a0,s0,-428
8000484c:	3a4000ef          	jal	ra,80004bf0 <z_spin_lock_set_owner>
	struct k_thread *thread = z_unpend_first_thread(&sem->wait_q);
80004850:	00098513          	mv	a0,s3
80004854:	a79ff0ef          	jal	ra,800042cc <z_unpend_first_thread>
80004858:	00050913          	mv	s2,a0
	if (thread != NULL) {
8000485c:	04050263          	beqz	a0,800048a0 <z_impl_k_sem_give+0xc8>
	return !((z_is_thread_prevented_from_running(thread)) != 0 ||
80004860:	00d54783          	lbu	a5,13(a0)
80004864:	01f7f793          	andi	a5,a5,31
80004868:	00079863          	bnez	a5,80004878 <z_impl_k_sem_give+0xa0>
	if (z_is_thread_ready(thread)) {
8000486c:	01852783          	lw	a5,24(a0)
80004870:	00079463          	bnez	a5,80004878 <z_impl_k_sem_give+0xa0>
		z_add_thread_to_ready_q(thread);
80004874:	a58ff0ef          	jal	ra,80003acc <z_add_thread_to_ready_q>
80004878:	06092623          	sw	zero,108(s2)
	k_spinlock_key_t key = k_spin_lock(&lock);

	sys_trace_void(SYS_TRACE_ID_SEMA_GIVE);
	do_sem_give(sem);
	sys_trace_end_call(SYS_TRACE_ID_SEMA_GIVE);
	z_reschedule(&lock, key);
8000487c:	e5440513          	addi	a0,s0,-428
}
80004880:	01812403          	lw	s0,24(sp)
80004884:	01c12083          	lw	ra,28(sp)
80004888:	01012903          	lw	s2,16(sp)
8000488c:	00c12983          	lw	s3,12(sp)
	z_reschedule(&lock, key);
80004890:	00048593          	mv	a1,s1
}
80004894:	01412483          	lw	s1,20(sp)
80004898:	02010113          	addi	sp,sp,32
	z_reschedule(&lock, key);
8000489c:	be5fe06f          	j	80003480 <z_reschedule>
	sem->count += (sem->count != sem->limit) ? 1U : 0U;
800048a0:	0089a703          	lw	a4,8(s3)
800048a4:	00c9a783          	lw	a5,12(s3)
800048a8:	40e787b3          	sub	a5,a5,a4
800048ac:	00f037b3          	snez	a5,a5
800048b0:	00e787b3          	add	a5,a5,a4
800048b4:	00f9a423          	sw	a5,8(s3)
800048b8:	fc5ff06f          	j	8000487c <z_impl_k_sem_give+0xa4>

800048bc <z_impl_k_sem_take>:
Z_SYSCALL_HANDLER1_SIMPLE_VOID(k_sem_give, K_OBJ_SEM, struct k_sem *);
#endif

int z_impl_k_sem_take(struct k_sem *sem, s32_t timeout)
{
	__ASSERT(((z_is_in_isr() == false) || (timeout == K_NO_WAIT)), "");
800048bc:	800077b7          	lui	a5,0x80007
800048c0:	1347a783          	lw	a5,308(a5) # 80007134 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007135>
{
800048c4:	fe010113          	addi	sp,sp,-32
800048c8:	01212823          	sw	s2,16(sp)
800048cc:	01312623          	sw	s3,12(sp)
800048d0:	00112e23          	sw	ra,28(sp)
800048d4:	00812c23          	sw	s0,24(sp)
800048d8:	00912a23          	sw	s1,20(sp)
800048dc:	01412423          	sw	s4,8(sp)
800048e0:	00050913          	mv	s2,a0
800048e4:	00058993          	mv	s3,a1
	__ASSERT(((z_is_in_isr() == false) || (timeout == K_NO_WAIT)), "");
800048e8:	04078063          	beqz	a5,80004928 <z_impl_k_sem_take+0x6c>
800048ec:	02058e63          	beqz	a1,80004928 <z_impl_k_sem_take+0x6c>
800048f0:	80007437          	lui	s0,0x80007
800048f4:	800075b7          	lui	a1,0x80007
800048f8:	80006537          	lui	a0,0x80006
800048fc:	bf458593          	addi	a1,a1,-1036 # 80006bf4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006bf5>
80004900:	08c00693          	li	a3,140
80004904:	b8040613          	addi	a2,s0,-1152 # 80006b80 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006b81>
80004908:	7dc50513          	addi	a0,a0,2012 # 800067dc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800067dd>
8000490c:	f64fd0ef          	jal	ra,80002070 <printk>
80004910:	80007537          	lui	a0,0x80007
80004914:	86050513          	addi	a0,a0,-1952 # 80006860 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006861>
80004918:	f58fd0ef          	jal	ra,80002070 <printk>
8000491c:	08c00593          	li	a1,140
80004920:	b8040513          	addi	a0,s0,-1152
80004924:	f88fd0ef          	jal	ra,800020ac <assert_post_action>
	__asm__ volatile ("csrrc %0, mstatus, %1"
80004928:	00800413          	li	s0,8
8000492c:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80004930:	800074b7          	lui	s1,0x80007
80004934:	e5448513          	addi	a0,s1,-428 # 80006e54 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006e55>
	key = (mstatus & SOC_MSTATUS_IEN);
80004938:	00847413          	andi	s0,s0,8
8000493c:	25c000ef          	jal	ra,80004b98 <z_spin_lock_valid>
80004940:	02051e63          	bnez	a0,8000497c <z_impl_k_sem_take+0xc0>
80004944:	80007a37          	lui	s4,0x80007
80004948:	800075b7          	lui	a1,0x80007
8000494c:	80006537          	lui	a0,0x80006
80004950:	8c058593          	addi	a1,a1,-1856 # 800068c0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800068c1>
80004954:	04e00693          	li	a3,78
80004958:	8a8a0613          	addi	a2,s4,-1880 # 800068a8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800068a9>
8000495c:	7dc50513          	addi	a0,a0,2012 # 800067dc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800067dd>
80004960:	f10fd0ef          	jal	ra,80002070 <printk>
80004964:	80007537          	lui	a0,0x80007
80004968:	8d850513          	addi	a0,a0,-1832 # 800068d8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800068d9>
8000496c:	f04fd0ef          	jal	ra,80002070 <printk>
80004970:	04e00593          	li	a1,78
80004974:	8a8a0513          	addi	a0,s4,-1880
80004978:	f34fd0ef          	jal	ra,800020ac <assert_post_action>
	z_spin_lock_set_owner(l);
8000497c:	e5448513          	addi	a0,s1,-428
80004980:	270000ef          	jal	ra,80004bf0 <z_spin_lock_set_owner>

	sys_trace_void(SYS_TRACE_ID_SEMA_TAKE);
	k_spinlock_key_t key = k_spin_lock(&lock);

	if (likely(sem->count > 0U)) {
80004984:	00892783          	lw	a5,8(s2)
80004988:	06078c63          	beqz	a5,80004a00 <z_impl_k_sem_take+0x144>
		sem->count--;
8000498c:	fff78793          	addi	a5,a5,-1
80004990:	00f92423          	sw	a5,8(s2)
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80004994:	e5448513          	addi	a0,s1,-428
80004998:	228000ef          	jal	ra,80004bc0 <z_spin_unlock_valid>
8000499c:	02051e63          	bnez	a0,800049d8 <z_impl_k_sem_take+0x11c>
800049a0:	800074b7          	lui	s1,0x80007
800049a4:	800075b7          	lui	a1,0x80007
800049a8:	80006537          	lui	a0,0x80006
800049ac:	8f058593          	addi	a1,a1,-1808 # 800068f0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800068f1>
800049b0:	06100693          	li	a3,97
800049b4:	8a848613          	addi	a2,s1,-1880 # 800068a8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800068a9>
800049b8:	7dc50513          	addi	a0,a0,2012 # 800067dc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800067dd>
800049bc:	eb4fd0ef          	jal	ra,80002070 <printk>
800049c0:	80007537          	lui	a0,0x80007
800049c4:	90850513          	addi	a0,a0,-1784 # 80006908 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006909>
800049c8:	ea8fd0ef          	jal	ra,80002070 <printk>
800049cc:	06100593          	li	a1,97
800049d0:	8a848513          	addi	a0,s1,-1880
800049d4:	ed8fd0ef          	jal	ra,800020ac <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
800049d8:	30042473          	csrrs	s0,mstatus,s0
		k_spin_unlock(&lock, key);
		sys_trace_end_call(SYS_TRACE_ID_SEMA_TAKE);
		return 0;
800049dc:	00000513          	li	a0,0

	sys_trace_end_call(SYS_TRACE_ID_SEMA_TAKE);

	int ret = z_pend_curr(&lock, key, &sem->wait_q, timeout);
	return ret;
}
800049e0:	01c12083          	lw	ra,28(sp)
800049e4:	01812403          	lw	s0,24(sp)
800049e8:	01412483          	lw	s1,20(sp)
800049ec:	01012903          	lw	s2,16(sp)
800049f0:	00c12983          	lw	s3,12(sp)
800049f4:	00812a03          	lw	s4,8(sp)
800049f8:	02010113          	addi	sp,sp,32
800049fc:	00008067          	ret
	if (timeout == K_NO_WAIT) {
80004a00:	04099a63          	bnez	s3,80004a54 <z_impl_k_sem_take+0x198>
80004a04:	e5448513          	addi	a0,s1,-428
80004a08:	1b8000ef          	jal	ra,80004bc0 <z_spin_unlock_valid>
80004a0c:	02051e63          	bnez	a0,80004a48 <z_impl_k_sem_take+0x18c>
80004a10:	800074b7          	lui	s1,0x80007
80004a14:	800075b7          	lui	a1,0x80007
80004a18:	80006537          	lui	a0,0x80006
80004a1c:	8f058593          	addi	a1,a1,-1808 # 800068f0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800068f1>
80004a20:	06100693          	li	a3,97
80004a24:	8a848613          	addi	a2,s1,-1880 # 800068a8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800068a9>
80004a28:	7dc50513          	addi	a0,a0,2012 # 800067dc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800067dd>
80004a2c:	e44fd0ef          	jal	ra,80002070 <printk>
80004a30:	80007537          	lui	a0,0x80007
80004a34:	90850513          	addi	a0,a0,-1784 # 80006908 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006909>
80004a38:	e38fd0ef          	jal	ra,80002070 <printk>
80004a3c:	06100593          	li	a1,97
80004a40:	8a848513          	addi	a0,s1,-1880
80004a44:	e68fd0ef          	jal	ra,800020ac <assert_post_action>
80004a48:	30042473          	csrrs	s0,mstatus,s0
		return -EBUSY;
80004a4c:	ff000513          	li	a0,-16
80004a50:	f91ff06f          	j	800049e0 <z_impl_k_sem_take+0x124>
	int ret = z_pend_curr(&lock, key, &sem->wait_q, timeout);
80004a54:	00040593          	mv	a1,s0
}
80004a58:	01812403          	lw	s0,24(sp)
80004a5c:	01c12083          	lw	ra,28(sp)
80004a60:	00812a03          	lw	s4,8(sp)
	int ret = z_pend_curr(&lock, key, &sem->wait_q, timeout);
80004a64:	00098693          	mv	a3,s3
80004a68:	00090613          	mv	a2,s2
}
80004a6c:	00c12983          	lw	s3,12(sp)
80004a70:	01012903          	lw	s2,16(sp)
	int ret = z_pend_curr(&lock, key, &sem->wait_q, timeout);
80004a74:	e5448513          	addi	a0,s1,-428
}
80004a78:	01412483          	lw	s1,20(sp)
80004a7c:	02010113          	addi	sp,sp,32
	int ret = z_pend_curr(&lock, key, &sem->wait_q, timeout);
80004a80:	fc4ff06f          	j	80004244 <z_pend_curr>

80004a84 <z_is_thread_ready>:
	return !((z_is_thread_prevented_from_running(thread)) != 0 ||
80004a84:	00d54783          	lbu	a5,13(a0)
80004a88:	01f7f793          	andi	a5,a5,31
80004a8c:	00079863          	bnez	a5,80004a9c <z_is_thread_ready+0x18>
80004a90:	01852503          	lw	a0,24(a0)
80004a94:	00153513          	seqz	a0,a0
80004a98:	00008067          	ret
80004a9c:	00000513          	li	a0,0
}
80004aa0:	00008067          	ret

80004aa4 <k_is_in_isr>:
#endif
}

bool k_is_in_isr(void)
{
	return z_is_in_isr();
80004aa4:	800077b7          	lui	a5,0x80007
80004aa8:	1347a503          	lw	a0,308(a5) # 80007134 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007135>
}
80004aac:	00a03533          	snez	a0,a0
80004ab0:	00008067          	ret

80004ab4 <z_is_thread_essential>:
 *
 * Returns true if current thread is essential, false if it is not.
 */
bool z_is_thread_essential(void)
{
	return (_current->base.user_options & K_ESSENTIAL) == K_ESSENTIAL;
80004ab4:	800077b7          	lui	a5,0x80007
80004ab8:	13c7a783          	lw	a5,316(a5) # 8000713c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000713d>
80004abc:	00c7c503          	lbu	a0,12(a5)
}
80004ac0:	00157513          	andi	a0,a0,1
80004ac4:	00008067          	ret

80004ac8 <z_impl_k_thread_name_set>:
#else
void z_impl_k_thread_name_set(k_tid_t thread_id, const char *value)
{
	ARG_UNUSED(thread_id);
	ARG_UNUSED(value);
}
80004ac8:	00008067          	ret

80004acc <z_setup_new_thread>:
void z_setup_new_thread(struct k_thread *new_thread,
		       k_thread_stack_t *stack, size_t stack_size,
		       k_thread_entry_t entry,
		       void *p1, void *p2, void *p3,
		       int prio, u32_t options, const char *name)
{
80004acc:	fe010113          	addi	sp,sp,-32
	stack_size = STACK_ROUND_DOWN(stack_size
			- sizeof(*new_thread->userspace_local_data));
#endif
#endif

	z_new_thread(new_thread, stack, stack_size, entry, p1, p2, p3,
80004ad0:	02012303          	lw	t1,32(sp)
{
80004ad4:	00812c23          	sw	s0,24(sp)
80004ad8:	00112e23          	sw	ra,28(sp)
	z_new_thread(new_thread, stack, stack_size, entry, p1, p2, p3,
80004adc:	00612023          	sw	t1,0(sp)
{
80004ae0:	00050413          	mv	s0,a0
	z_new_thread(new_thread, stack, stack_size, entry, p1, p2, p3,
80004ae4:	dc0fc0ef          	jal	ra,800010a4 <z_new_thread>
	}
#endif
#ifdef CONFIG_SCHED_DEADLINE
	new_thread->base.prio_deadline = 0;
#endif
	new_thread->resource_pool = _current->resource_pool;
80004ae8:	800077b7          	lui	a5,0x80007
80004aec:	13c7a783          	lw	a5,316(a5) # 8000713c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000713d>
	sys_trace_thread_create(new_thread);
}
80004af0:	01c12083          	lw	ra,28(sp)
	new_thread->resource_pool = _current->resource_pool;
80004af4:	0687a783          	lw	a5,104(a5)
80004af8:	06f42423          	sw	a5,104(s0)
}
80004afc:	01812403          	lw	s0,24(sp)
80004b00:	02010113          	addi	sp,sp,32
80004b04:	00008067          	ret

80004b08 <z_thread_single_abort>:
Z_SYSCALL_HANDLER1_SIMPLE_VOID(k_thread_resume, K_OBJ_THREAD, k_tid_t);
#endif

void z_thread_single_abort(struct k_thread *thread)
{
	if (thread->fn_abort != NULL) {
80004b08:	06052783          	lw	a5,96(a0)
{
80004b0c:	ff010113          	addi	sp,sp,-16
80004b10:	00812423          	sw	s0,8(sp)
80004b14:	00112623          	sw	ra,12(sp)
80004b18:	00050413          	mv	s0,a0
	if (thread->fn_abort != NULL) {
80004b1c:	00078463          	beqz	a5,80004b24 <z_thread_single_abort+0x1c>
		thread->fn_abort();
80004b20:	000780e7          	jalr	a5

	if (IS_ENABLED(CONFIG_SMP)) {
		z_sched_abort(thread);
	}

	if (z_is_thread_ready(thread)) {
80004b24:	00040513          	mv	a0,s0
80004b28:	f5dff0ef          	jal	ra,80004a84 <z_is_thread_ready>
80004b2c:	02050463          	beqz	a0,80004b54 <z_thread_single_abort+0x4c>
		z_remove_thread_from_ready_q(thread);
80004b30:	00040513          	mv	a0,s0
80004b34:	ca0ff0ef          	jal	ra,80003fd4 <z_remove_thread_from_ready_q>
		if (z_is_thread_timeout_active(thread)) {
			(void)z_abort_thread_timeout(thread);
		}
	}

	thread->base.thread_state |= _THREAD_DEAD;
80004b38:	00d44783          	lbu	a5,13(s0)
	z_object_uninit(thread);

	/* Revoke permissions on thread's ID so that it may be recycled */
	z_thread_perms_all_clear(thread);
#endif
}
80004b3c:	00c12083          	lw	ra,12(sp)
	thread->base.thread_state |= _THREAD_DEAD;
80004b40:	0087e793          	ori	a5,a5,8
80004b44:	00f406a3          	sb	a5,13(s0)
}
80004b48:	00812403          	lw	s0,8(sp)
80004b4c:	01010113          	addi	sp,sp,16
80004b50:	00008067          	ret
		if (z_is_thread_pending(thread)) {
80004b54:	00d44783          	lbu	a5,13(s0)
80004b58:	0027f793          	andi	a5,a5,2
80004b5c:	00078663          	beqz	a5,80004b68 <z_thread_single_abort+0x60>
			z_unpend_thread_no_timeout(thread);
80004b60:	00040513          	mv	a0,s0
80004b64:	821fe0ef          	jal	ra,80003384 <z_unpend_thread_no_timeout>
		if (z_is_thread_timeout_active(thread)) {
80004b68:	01842783          	lw	a5,24(s0)
80004b6c:	fc0786e3          	beqz	a5,80004b38 <z_thread_single_abort+0x30>
80004b70:	01840513          	addi	a0,s0,24
80004b74:	00d000ef          	jal	ra,80005380 <z_abort_timeout>
80004b78:	fc1ff06f          	j	80004b38 <z_thread_single_abort+0x30>

80004b7c <z_init_thread_base>:
void z_init_thread_base(struct _thread_base *thread_base, int priority,
		       u32_t initial_state, unsigned int options)
{
	/* k_q_node is initialized upon first insertion in a list */

	thread_base->user_options = (u8_t)options;
80004b7c:	00d50623          	sb	a3,12(a0)
	thread_base->thread_state = (u8_t)initial_state;
80004b80:	00c506a3          	sb	a2,13(a0)

	thread_base->prio = priority;
80004b84:	00b50723          	sb	a1,14(a0)

	thread_base->sched_locked = 0U;
80004b88:	000507a3          	sb	zero,15(a0)
	node->next = NULL;
80004b8c:	00052c23          	sw	zero,24(a0)
	node->prev = NULL;
80004b90:	00052e23          	sw	zero,28(a0)

	/* swap_data does not need to be initialized */

	z_init_thread_timeout(thread_base);
}
80004b94:	00008067          	ret

80004b98 <z_spin_lock_valid>:
 * them in spinlock.h is a giant header ordering headache.
 */
#ifdef SPIN_VALIDATE
bool z_spin_lock_valid(struct k_spinlock *l)
{
	if (l->thread_cpu) {
80004b98:	00052503          	lw	a0,0(a0)
80004b9c:	00050e63          	beqz	a0,80004bb8 <z_spin_lock_valid+0x20>
		if ((l->thread_cpu & 3) == _current_cpu->id) {
80004ba0:	800077b7          	lui	a5,0x80007
80004ba4:	1487c783          	lbu	a5,328(a5) # 80007148 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007149>
80004ba8:	00357513          	andi	a0,a0,3
80004bac:	40f50533          	sub	a0,a0,a5
80004bb0:	00a03533          	snez	a0,a0
80004bb4:	00008067          	ret
			return false;
		}
	}
	return true;
80004bb8:	00100513          	li	a0,1
}
80004bbc:	00008067          	ret

80004bc0 <z_spin_unlock_valid>:

bool z_spin_unlock_valid(struct k_spinlock *l)
{
	if (l->thread_cpu != (_current_cpu->id | (u32_t)_current)) {
80004bc0:	800077b7          	lui	a5,0x80007
80004bc4:	13478793          	addi	a5,a5,308 # 80007134 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007135>
80004bc8:	0147c703          	lbu	a4,20(a5)
80004bcc:	0087a783          	lw	a5,8(a5)
80004bd0:	00e7e7b3          	or	a5,a5,a4
80004bd4:	00052703          	lw	a4,0(a0)
80004bd8:	00f71863          	bne	a4,a5,80004be8 <z_spin_unlock_valid+0x28>
		return false;
	}
	l->thread_cpu = 0;
80004bdc:	00052023          	sw	zero,0(a0)
	return true;
80004be0:	00100513          	li	a0,1
80004be4:	00008067          	ret
		return false;
80004be8:	00000513          	li	a0,0
}
80004bec:	00008067          	ret

80004bf0 <z_spin_lock_set_owner>:

void z_spin_lock_set_owner(struct k_spinlock *l)
{
	l->thread_cpu = _current_cpu->id | (u32_t)_current;
80004bf0:	800077b7          	lui	a5,0x80007
80004bf4:	13478793          	addi	a5,a5,308 # 80007134 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007135>
80004bf8:	0147c703          	lbu	a4,20(a5)
80004bfc:	0087a783          	lw	a5,8(a5)
80004c00:	00e7e7b3          	or	a5,a5,a4
80004c04:	00f52023          	sw	a5,0(a0)
}
80004c08:	00008067          	ret

80004c0c <z_impl_k_thread_start>:
{
80004c0c:	fe010113          	addi	sp,sp,-32
80004c10:	00812c23          	sw	s0,24(sp)
80004c14:	01212823          	sw	s2,16(sp)
80004c18:	00112e23          	sw	ra,28(sp)
80004c1c:	00912a23          	sw	s1,20(sp)
80004c20:	01312623          	sw	s3,12(sp)
80004c24:	00050913          	mv	s2,a0
	__asm__ volatile ("csrrc %0, mstatus, %1"
80004c28:	00800413          	li	s0,8
80004c2c:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80004c30:	800074b7          	lui	s1,0x80007
80004c34:	e5848513          	addi	a0,s1,-424 # 80006e58 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006e59>
	key = (mstatus & SOC_MSTATUS_IEN);
80004c38:	00847413          	andi	s0,s0,8
80004c3c:	f5dff0ef          	jal	ra,80004b98 <z_spin_lock_valid>
80004c40:	02051e63          	bnez	a0,80004c7c <z_impl_k_thread_start+0x70>
80004c44:	800079b7          	lui	s3,0x80007
80004c48:	800075b7          	lui	a1,0x80007
80004c4c:	80006537          	lui	a0,0x80006
80004c50:	8c058593          	addi	a1,a1,-1856 # 800068c0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800068c1>
80004c54:	04e00693          	li	a3,78
80004c58:	8a898613          	addi	a2,s3,-1880 # 800068a8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800068a9>
80004c5c:	7dc50513          	addi	a0,a0,2012 # 800067dc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800067dd>
80004c60:	c10fd0ef          	jal	ra,80002070 <printk>
80004c64:	80007537          	lui	a0,0x80007
80004c68:	8d850513          	addi	a0,a0,-1832 # 800068d8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800068d9>
80004c6c:	c04fd0ef          	jal	ra,80002070 <printk>
80004c70:	04e00593          	li	a1,78
80004c74:	8a898513          	addi	a0,s3,-1880
80004c78:	c34fd0ef          	jal	ra,800020ac <assert_post_action>
	z_spin_lock_set_owner(l);
80004c7c:	e5848513          	addi	a0,s1,-424
80004c80:	f71ff0ef          	jal	ra,80004bf0 <z_spin_lock_set_owner>
	if (z_has_thread_started(thread)) {
80004c84:	00d94783          	lbu	a5,13(s2)
80004c88:	0047f713          	andi	a4,a5,4
80004c8c:	06071463          	bnez	a4,80004cf4 <z_impl_k_thread_start+0xe8>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80004c90:	e5848513          	addi	a0,s1,-424
80004c94:	f2dff0ef          	jal	ra,80004bc0 <z_spin_unlock_valid>
80004c98:	02051e63          	bnez	a0,80004cd4 <z_impl_k_thread_start+0xc8>
80004c9c:	800074b7          	lui	s1,0x80007
80004ca0:	800075b7          	lui	a1,0x80007
80004ca4:	80006537          	lui	a0,0x80006
80004ca8:	8f058593          	addi	a1,a1,-1808 # 800068f0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800068f1>
80004cac:	06100693          	li	a3,97
80004cb0:	8a848613          	addi	a2,s1,-1880 # 800068a8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800068a9>
80004cb4:	7dc50513          	addi	a0,a0,2012 # 800067dc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800067dd>
80004cb8:	bb8fd0ef          	jal	ra,80002070 <printk>
80004cbc:	80007537          	lui	a0,0x80007
80004cc0:	90850513          	addi	a0,a0,-1784 # 80006908 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006909>
80004cc4:	bacfd0ef          	jal	ra,80002070 <printk>
80004cc8:	06100593          	li	a1,97
80004ccc:	8a848513          	addi	a0,s1,-1880
80004cd0:	bdcfd0ef          	jal	ra,800020ac <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80004cd4:	30042473          	csrrs	s0,mstatus,s0
}
80004cd8:	01c12083          	lw	ra,28(sp)
80004cdc:	01812403          	lw	s0,24(sp)
80004ce0:	01412483          	lw	s1,20(sp)
80004ce4:	01012903          	lw	s2,16(sp)
80004ce8:	00c12983          	lw	s3,12(sp)
80004cec:	02010113          	addi	sp,sp,32
80004cf0:	00008067          	ret
	thread->base.thread_state &= ~_THREAD_PRESTART;
80004cf4:	ffb7f793          	andi	a5,a5,-5
80004cf8:	00f906a3          	sb	a5,13(s2)
	if (z_is_thread_ready(thread)) {
80004cfc:	00090513          	mv	a0,s2
80004d00:	d85ff0ef          	jal	ra,80004a84 <z_is_thread_ready>
80004d04:	00050663          	beqz	a0,80004d10 <z_impl_k_thread_start+0x104>
		z_add_thread_to_ready_q(thread);
80004d08:	00090513          	mv	a0,s2
80004d0c:	dc1fe0ef          	jal	ra,80003acc <z_add_thread_to_ready_q>
	z_reschedule(&lock, key);
80004d10:	00040593          	mv	a1,s0
}
80004d14:	01812403          	lw	s0,24(sp)
80004d18:	01c12083          	lw	ra,28(sp)
80004d1c:	01012903          	lw	s2,16(sp)
80004d20:	00c12983          	lw	s3,12(sp)
	z_reschedule(&lock, key);
80004d24:	e5848513          	addi	a0,s1,-424
}
80004d28:	01412483          	lw	s1,20(sp)
80004d2c:	02010113          	addi	sp,sp,32
	z_reschedule(&lock, key);
80004d30:	f50fe06f          	j	80003480 <z_reschedule>

80004d34 <schedule_new_thread>:
	if (delay == 0) {
80004d34:	00059463          	bnez	a1,80004d3c <schedule_new_thread+0x8>
K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_THREAD_START, k_thread_start, k_tid_t, thread)
80004d38:	ed5ff06f          	j	80004c0c <z_impl_k_thread_start>
{
80004d3c:	ff010113          	addi	sp,sp,-16
80004d40:	00812423          	sw	s0,8(sp)
80004d44:	00050413          	mv	s0,a0
80004d48:	00058513          	mv	a0,a1
80004d4c:	00950513          	addi	a0,a0,9
80004d50:	00a00593          	li	a1,10
80004d54:	00112623          	sw	ra,12(sp)
80004d58:	be1fb0ef          	jal	ra,80000938 <__divsi3>
	z_add_timeout(&th->base.timeout, z_thread_timeout, ticks);
80004d5c:	00150613          	addi	a2,a0,1
80004d60:	01840513          	addi	a0,s0,24
}
80004d64:	00812403          	lw	s0,8(sp)
80004d68:	00c12083          	lw	ra,12(sp)
80004d6c:	800045b7          	lui	a1,0x80004
80004d70:	c5c58593          	addi	a1,a1,-932 # 80003c5c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80003c5d>
80004d74:	01010113          	addi	sp,sp,16
80004d78:	3dc0006f          	j	80005154 <z_add_timeout>

80004d7c <z_impl_k_thread_create>:
{
80004d7c:	fc010113          	addi	sp,sp,-64
80004d80:	03512223          	sw	s5,36(sp)
80004d84:	00068a93          	mv	s5,a3
	__ASSERT(!z_is_in_isr(), "Threads may not be created in ISRs");
80004d88:	800076b7          	lui	a3,0x80007
80004d8c:	1346a683          	lw	a3,308(a3) # 80007134 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007135>
{
80004d90:	02812c23          	sw	s0,56(sp)
80004d94:	02912a23          	sw	s1,52(sp)
80004d98:	03312623          	sw	s3,44(sp)
80004d9c:	03412423          	sw	s4,40(sp)
80004da0:	02112e23          	sw	ra,60(sp)
80004da4:	03212823          	sw	s2,48(sp)
80004da8:	00050413          	mv	s0,a0
80004dac:	00058993          	mv	s3,a1
80004db0:	00060a13          	mv	s4,a2
80004db4:	04412483          	lw	s1,68(sp)
	__ASSERT(!z_is_in_isr(), "Threads may not be created in ISRs");
80004db8:	04068e63          	beqz	a3,80004e14 <z_impl_k_thread_create+0x98>
80004dbc:	80007937          	lui	s2,0x80007
80004dc0:	800075b7          	lui	a1,0x80007
80004dc4:	80006537          	lui	a0,0x80006
80004dc8:	1b200693          	li	a3,434
80004dcc:	c2890613          	addi	a2,s2,-984 # 80006c28 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006c29>
80004dd0:	ab858593          	addi	a1,a1,-1352 # 80006ab8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006ab9>
80004dd4:	7dc50513          	addi	a0,a0,2012 # 800067dc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800067dd>
80004dd8:	01112e23          	sw	a7,28(sp)
80004ddc:	01012c23          	sw	a6,24(sp)
80004de0:	00f12a23          	sw	a5,20(sp)
80004de4:	00e12823          	sw	a4,16(sp)
80004de8:	a88fd0ef          	jal	ra,80002070 <printk>
80004dec:	80007537          	lui	a0,0x80007
80004df0:	c3c50513          	addi	a0,a0,-964 # 80006c3c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006c3d>
80004df4:	a7cfd0ef          	jal	ra,80002070 <printk>
80004df8:	1b200593          	li	a1,434
80004dfc:	c2890513          	addi	a0,s2,-984
80004e00:	aacfd0ef          	jal	ra,800020ac <assert_post_action>
80004e04:	01c12883          	lw	a7,28(sp)
80004e08:	01812803          	lw	a6,24(sp)
80004e0c:	01412783          	lw	a5,20(sp)
80004e10:	01012703          	lw	a4,16(sp)
	z_setup_new_thread(new_thread, stack, stack_size, entry, p1, p2, p3,
80004e14:	04012683          	lw	a3,64(sp)
80004e18:	00012223          	sw	zero,4(sp)
80004e1c:	000a0613          	mv	a2,s4
80004e20:	00d12023          	sw	a3,0(sp)
80004e24:	00098593          	mv	a1,s3
80004e28:	000a8693          	mv	a3,s5
80004e2c:	00040513          	mv	a0,s0
80004e30:	c9dff0ef          	jal	ra,80004acc <z_setup_new_thread>
	if (delay != K_FOREVER) {
80004e34:	fff00793          	li	a5,-1
80004e38:	00f48863          	beq	s1,a5,80004e48 <z_impl_k_thread_create+0xcc>
		schedule_new_thread(new_thread, delay);
80004e3c:	00048593          	mv	a1,s1
80004e40:	00040513          	mv	a0,s0
80004e44:	ef1ff0ef          	jal	ra,80004d34 <schedule_new_thread>
}
80004e48:	00040513          	mv	a0,s0
80004e4c:	03c12083          	lw	ra,60(sp)
80004e50:	03812403          	lw	s0,56(sp)
80004e54:	03412483          	lw	s1,52(sp)
80004e58:	03012903          	lw	s2,48(sp)
80004e5c:	02c12983          	lw	s3,44(sp)
80004e60:	02812a03          	lw	s4,40(sp)
80004e64:	02412a83          	lw	s5,36(sp)
80004e68:	04010113          	addi	sp,sp,64
80004e6c:	00008067          	ret

80004e70 <z_init_static_threads>:
{
80004e70:	fe010113          	addi	sp,sp,-32
	_FOREACH_STATIC_THREAD(thread_data) {
80004e74:	800077b7          	lui	a5,0x80007
{
80004e78:	01212823          	sw	s2,16(sp)
	_FOREACH_STATIC_THREAD(thread_data) {
80004e7c:	80007937          	lui	s2,0x80007
{
80004e80:	00812c23          	sw	s0,24(sp)
80004e84:	00912a23          	sw	s1,20(sp)
80004e88:	00112e23          	sw	ra,28(sp)
	_FOREACH_STATIC_THREAD(thread_data) {
80004e8c:	dd078413          	addi	s0,a5,-560 # 80006dd0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006dd1>
80004e90:	dd078493          	addi	s1,a5,-560
80004e94:	dd090913          	addi	s2,s2,-560 # 80006dd0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006dd1>
80004e98:	03246663          	bltu	s0,s2,80004ec4 <z_init_static_threads+0x54>
	_FOREACH_STATIC_THREAD(thread_data) {
80004e9c:	00048413          	mv	s0,s1
	k_sched_lock();
80004ea0:	ee0fe0ef          	jal	ra,80003580 <k_sched_lock>
		if (thread_data->init_delay != K_FOREVER) {
80004ea4:	fff00493          	li	s1,-1
	_FOREACH_STATIC_THREAD(thread_data) {
80004ea8:	07246063          	bltu	s0,s2,80004f08 <z_init_static_threads+0x98>
}
80004eac:	01812403          	lw	s0,24(sp)
80004eb0:	01c12083          	lw	ra,28(sp)
80004eb4:	01412483          	lw	s1,20(sp)
80004eb8:	01012903          	lw	s2,16(sp)
80004ebc:	02010113          	addi	sp,sp,32
	k_sched_unlock();
80004ec0:	a8dfe06f          	j	8000394c <k_sched_unlock>
		z_setup_new_thread(
80004ec4:	02c42783          	lw	a5,44(s0)
80004ec8:	00f12223          	sw	a5,4(sp)
80004ecc:	02042783          	lw	a5,32(s0)
80004ed0:	00f12023          	sw	a5,0(sp)
80004ed4:	01442783          	lw	a5,20(s0)
80004ed8:	01c42883          	lw	a7,28(s0)
80004edc:	01842803          	lw	a6,24(s0)
80004ee0:	01042703          	lw	a4,16(s0)
80004ee4:	00c42683          	lw	a3,12(s0)
80004ee8:	00842603          	lw	a2,8(s0)
80004eec:	00442583          	lw	a1,4(s0)
80004ef0:	00042503          	lw	a0,0(s0)
80004ef4:	bd9ff0ef          	jal	ra,80004acc <z_setup_new_thread>
		thread_data->init_thread->init_data = thread_data;
80004ef8:	00042783          	lw	a5,0(s0)
80004efc:	0487ae23          	sw	s0,92(a5)
	_FOREACH_STATIC_THREAD(thread_data) {
80004f00:	03040413          	addi	s0,s0,48
80004f04:	f95ff06f          	j	80004e98 <z_init_static_threads+0x28>
		if (thread_data->init_delay != K_FOREVER) {
80004f08:	02442583          	lw	a1,36(s0)
80004f0c:	00958663          	beq	a1,s1,80004f18 <z_init_static_threads+0xa8>
			schedule_new_thread(thread_data->init_thread,
80004f10:	00042503          	lw	a0,0(s0)
80004f14:	e21ff0ef          	jal	ra,80004d34 <schedule_new_thread>
	_FOREACH_STATIC_THREAD(thread_data) {
80004f18:	03040413          	addi	s0,s0,48
80004f1c:	f8dff06f          	j	80004ea8 <z_init_static_threads+0x38>

80004f20 <z_impl_k_thread_abort>:

extern void z_thread_single_abort(struct k_thread *thread);

#if !defined(CONFIG_ARCH_HAS_THREAD_ABORT)
void z_impl_k_thread_abort(k_tid_t thread)
{
80004f20:	fe010113          	addi	sp,sp,-32
80004f24:	00812c23          	sw	s0,24(sp)
80004f28:	00912a23          	sw	s1,20(sp)
80004f2c:	00112e23          	sw	ra,28(sp)
80004f30:	01212823          	sw	s2,16(sp)
80004f34:	00050493          	mv	s1,a0
	 * to have been in place to prevent the thread from waking up
	 * due to a delivered interrupt.  Leave a dummy spinlock in
	 * place to do that.  This API should be revisted though, it
	 * doesn't look SMP-safe as it stands.
	 */
	struct k_spinlock lock = {};
80004f38:	00012623          	sw	zero,12(sp)
	__asm__ volatile ("csrrc %0, mstatus, %1"
80004f3c:	00800413          	li	s0,8
80004f40:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80004f44:	00c10513          	addi	a0,sp,12
	key = (mstatus & SOC_MSTATUS_IEN);
80004f48:	00847413          	andi	s0,s0,8
80004f4c:	c4dff0ef          	jal	ra,80004b98 <z_spin_lock_valid>
80004f50:	02051e63          	bnez	a0,80004f8c <z_impl_k_thread_abort+0x6c>
80004f54:	80007937          	lui	s2,0x80007
80004f58:	800075b7          	lui	a1,0x80007
80004f5c:	80006537          	lui	a0,0x80006
80004f60:	8c058593          	addi	a1,a1,-1856 # 800068c0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800068c1>
80004f64:	04e00693          	li	a3,78
80004f68:	8a890613          	addi	a2,s2,-1880 # 800068a8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800068a9>
80004f6c:	7dc50513          	addi	a0,a0,2012 # 800067dc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800067dd>
80004f70:	900fd0ef          	jal	ra,80002070 <printk>
80004f74:	80007537          	lui	a0,0x80007
80004f78:	8d850513          	addi	a0,a0,-1832 # 800068d8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800068d9>
80004f7c:	8f4fd0ef          	jal	ra,80002070 <printk>
80004f80:	04e00593          	li	a1,78
80004f84:	8a890513          	addi	a0,s2,-1880
80004f88:	924fd0ef          	jal	ra,800020ac <assert_post_action>
	z_spin_lock_set_owner(l);
80004f8c:	00c10513          	addi	a0,sp,12
80004f90:	c61ff0ef          	jal	ra,80004bf0 <z_spin_lock_set_owner>
	k_spinlock_key_t key = k_spin_lock(&lock);

	__ASSERT((thread->base.user_options & K_ESSENTIAL) == 0U,
80004f94:	00c4c783          	lbu	a5,12(s1)
80004f98:	0017f793          	andi	a5,a5,1
80004f9c:	02078e63          	beqz	a5,80004fd8 <z_impl_k_thread_abort+0xb8>
80004fa0:	80007937          	lui	s2,0x80007
80004fa4:	800075b7          	lui	a1,0x80007
80004fa8:	80006537          	lui	a0,0x80006
80004fac:	c7c58593          	addi	a1,a1,-900 # 80006c7c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006c7d>
80004fb0:	02900693          	li	a3,41
80004fb4:	c6490613          	addi	a2,s2,-924 # 80006c64 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006c65>
80004fb8:	7dc50513          	addi	a0,a0,2012 # 800067dc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800067dd>
80004fbc:	8b4fd0ef          	jal	ra,80002070 <printk>
80004fc0:	80007537          	lui	a0,0x80007
80004fc4:	cb050513          	addi	a0,a0,-848 # 80006cb0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006cb1>
80004fc8:	8a8fd0ef          	jal	ra,80002070 <printk>
80004fcc:	02900593          	li	a1,41
80004fd0:	c6490513          	addi	a0,s2,-924
80004fd4:	8d8fd0ef          	jal	ra,800020ac <assert_post_action>
		 "essential thread aborted");

	z_thread_single_abort(thread);
80004fd8:	00048513          	mv	a0,s1
80004fdc:	b2dff0ef          	jal	ra,80004b08 <z_thread_single_abort>
	z_thread_monitor_exit(thread);

	z_reschedule(&lock, key);
80004fe0:	00040593          	mv	a1,s0
80004fe4:	00c10513          	addi	a0,sp,12
80004fe8:	c98fe0ef          	jal	ra,80003480 <z_reschedule>
}
80004fec:	01c12083          	lw	ra,28(sp)
80004ff0:	01812403          	lw	s0,24(sp)
80004ff4:	01412483          	lw	s1,20(sp)
80004ff8:	01012903          	lw	s2,16(sp)
80004ffc:	02010113          	addi	sp,sp,32
80005000:	00008067          	ret

80005004 <k_work_q_start>:

extern void z_work_q_main(void *work_q_ptr, void *p2, void *p3);

void k_work_q_start(struct k_work_q *work_q, k_thread_stack_t *stack,
		    size_t stack_size, int prio)
{
80005004:	fd010113          	addi	sp,sp,-48
80005008:	02112623          	sw	ra,44(sp)
8000500c:	02812423          	sw	s0,40(sp)
80005010:	00a12e23          	sw	a0,28(sp)
80005014:	00b12c23          	sw	a1,24(sp)
80005018:	00c12a23          	sw	a2,20(sp)
8000501c:	00d12823          	sw	a3,16(sp)
K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_QUEUE_INIT, k_queue_init, struct k_queue *, queue)
80005020:	fddfd0ef          	jal	ra,80002ffc <z_impl_k_queue_init>
K_SYSCALL_DECLARE10(K_SYSCALL_K_THREAD_CREATE, k_thread_create, k_tid_t, struct k_thread *, new_thread, k_thread_stack_t *, stack, size_t, stack_size, k_thread_entry_t, entry, void *, p1, void *, p2, void *, p3, int, prio, u32_t, options, s32_t, delay)
80005024:	01012683          	lw	a3,16(sp)
	k_queue_init(&work_q->queue);
	(void)k_thread_create(&work_q->thread, stack, stack_size, z_work_q_main,
80005028:	01c12703          	lw	a4,28(sp)
8000502c:	01812583          	lw	a1,24(sp)
80005030:	01412603          	lw	a2,20(sp)
80005034:	01470413          	addi	s0,a4,20
80005038:	00068893          	mv	a7,a3
8000503c:	800026b7          	lui	a3,0x80002
80005040:	00012223          	sw	zero,4(sp)
80005044:	00012023          	sw	zero,0(sp)
80005048:	00040513          	mv	a0,s0
8000504c:	00000813          	li	a6,0
80005050:	00000793          	li	a5,0
80005054:	9d468693          	addi	a3,a3,-1580 # 800019d4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800019d5>
80005058:	d25ff0ef          	jal	ra,80004d7c <z_impl_k_thread_create>
K_SYSCALL_DECLARE2_VOID(K_SYSCALL_K_THREAD_NAME_SET, k_thread_name_set, k_tid_t, thread_id, const char *, value)
8000505c:	00040513          	mv	a0,s0
			work_q, NULL, NULL, prio, 0, 0);

	k_thread_name_set(&work_q->thread, WORKQUEUE_THREAD_NAME);
}
80005060:	02812403          	lw	s0,40(sp)
80005064:	02c12083          	lw	ra,44(sp)
80005068:	800075b7          	lui	a1,0x80007
8000506c:	ccc58593          	addi	a1,a1,-820 # 80006ccc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006ccd>
80005070:	03010113          	addi	sp,sp,48
80005074:	a55ff06f          	j	80004ac8 <z_impl_k_thread_name_set>

80005078 <elapsed>:
	sys_dlist_remove(&t->node);
}

static s32_t elapsed(void)
{
	return announce_remaining == 0 ? z_clock_elapsed() : 0;
80005078:	800077b7          	lui	a5,0x80007
8000507c:	e5c7a783          	lw	a5,-420(a5) # 80006e5c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006e5d>
80005080:	00079463          	bnez	a5,80005088 <elapsed+0x10>
80005084:	ca8fd06f          	j	8000252c <z_clock_elapsed>
}
80005088:	00000513          	li	a0,0
8000508c:	00008067          	ret

80005090 <remove_timeout>:
	return (node != NULL) ? sys_dlist_peek_next_no_check(list, node) : NULL;
80005090:	00052783          	lw	a5,0(a0)
80005094:	02050263          	beqz	a0,800050b8 <remove_timeout+0x28>
80005098:	80007737          	lui	a4,0x80007
	return (node == list->tail) ? NULL : node->next;
8000509c:	d9472703          	lw	a4,-620(a4) # 80006d94 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006d95>
800050a0:	00e50c63          	beq	a0,a4,800050b8 <remove_timeout+0x28>
	if (next(t) != NULL) {
800050a4:	00078a63          	beqz	a5,800050b8 <remove_timeout+0x28>
		next(t)->dticks += t->dticks;
800050a8:	0087a703          	lw	a4,8(a5)
800050ac:	00852683          	lw	a3,8(a0)
800050b0:	00d70733          	add	a4,a4,a3
800050b4:	00e7a423          	sw	a4,8(a5)
	node->prev->next = node->next;
800050b8:	00452703          	lw	a4,4(a0)
800050bc:	00f72023          	sw	a5,0(a4)
	node->next->prev = node->prev;
800050c0:	00e7a223          	sw	a4,4(a5)
	node->next = NULL;
800050c4:	00052023          	sw	zero,0(a0)
	node->prev = NULL;
800050c8:	00052223          	sw	zero,4(a0)
}
800050cc:	00008067          	ret

800050d0 <next_timeout>:

static s32_t next_timeout(void)
{
	int maxw = can_wait_forever ? K_FOREVER : INT_MAX;
800050d0:	800077b7          	lui	a5,0x80007
800050d4:	e6c7c783          	lbu	a5,-404(a5) # 80006e6c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006e6d>
{
800050d8:	ff010113          	addi	sp,sp,-16
800050dc:	00112623          	sw	ra,12(sp)
800050e0:	00812423          	sw	s0,8(sp)
800050e4:	00912223          	sw	s1,4(sp)
800050e8:	fff00513          	li	a0,-1
	int maxw = can_wait_forever ? K_FOREVER : INT_MAX;
800050ec:	00079663          	bnez	a5,800050f8 <next_timeout+0x28>
800050f0:	80000537          	lui	a0,0x80000
800050f4:	fff54513          	not	a0,a0
	return list->head == list;
800050f8:	800077b7          	lui	a5,0x80007
800050fc:	d9078793          	addi	a5,a5,-624 # 80006d90 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006d91>
80005100:	0007a403          	lw	s0,0(a5)
	return sys_dlist_is_empty(list) ? NULL : list->head;
80005104:	02f40463          	beq	s0,a5,8000512c <next_timeout+0x5c>
	struct _timeout *to = first();
	s32_t ret = to == NULL ? maxw : MAX(0, to->dticks - elapsed());
80005108:	02040263          	beqz	s0,8000512c <next_timeout+0x5c>
8000510c:	00842483          	lw	s1,8(s0)
80005110:	f69ff0ef          	jal	ra,80005078 <elapsed>
80005114:	40a484b3          	sub	s1,s1,a0
80005118:	00000513          	li	a0,0
8000511c:	0004c863          	bltz	s1,8000512c <next_timeout+0x5c>
80005120:	00842403          	lw	s0,8(s0)
80005124:	f55ff0ef          	jal	ra,80005078 <elapsed>
80005128:	40a40533          	sub	a0,s0,a0

#ifdef CONFIG_TIMESLICING
	if (_current_cpu->slice_ticks && _current_cpu->slice_ticks < ret) {
8000512c:	800077b7          	lui	a5,0x80007
80005130:	1447a783          	lw	a5,324(a5) # 80007144 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007145>
80005134:	00078663          	beqz	a5,80005140 <next_timeout+0x70>
80005138:	00a7d463          	bge	a5,a0,80005140 <next_timeout+0x70>
8000513c:	00078513          	mv	a0,a5
		ret = _current_cpu->slice_ticks;
	}
#endif
	return ret;
}
80005140:	00c12083          	lw	ra,12(sp)
80005144:	00812403          	lw	s0,8(sp)
80005148:	00412483          	lw	s1,4(sp)
8000514c:	01010113          	addi	sp,sp,16
80005150:	00008067          	ret

80005154 <z_add_timeout>:

void z_add_timeout(struct _timeout *to, _timeout_func_t fn, s32_t ticks)
{
	__ASSERT(!sys_dnode_is_linked(&to->node), "");
80005154:	00052783          	lw	a5,0(a0) # 80000000 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80000001>
{
80005158:	fd010113          	addi	sp,sp,-48
8000515c:	02812423          	sw	s0,40(sp)
80005160:	02912223          	sw	s1,36(sp)
80005164:	01312e23          	sw	s3,28(sp)
80005168:	02112623          	sw	ra,44(sp)
8000516c:	03212023          	sw	s2,32(sp)
80005170:	01412c23          	sw	s4,24(sp)
80005174:	01512a23          	sw	s5,20(sp)
80005178:	01612823          	sw	s6,16(sp)
8000517c:	01712623          	sw	s7,12(sp)
80005180:	01812423          	sw	s8,8(sp)
80005184:	00050413          	mv	s0,a0
80005188:	00058993          	mv	s3,a1
8000518c:	00060493          	mv	s1,a2
	__ASSERT(!sys_dnode_is_linked(&to->node), "");
80005190:	02078e63          	beqz	a5,800051cc <z_add_timeout+0x78>
80005194:	80007937          	lui	s2,0x80007
80005198:	800075b7          	lui	a1,0x80007
8000519c:	80006537          	lui	a0,0x80006
800051a0:	cec58593          	addi	a1,a1,-788 # 80006cec <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006ced>
800051a4:	04d00693          	li	a3,77
800051a8:	cd890613          	addi	a2,s2,-808 # 80006cd8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006cd9>
800051ac:	7dc50513          	addi	a0,a0,2012 # 800067dc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800067dd>
800051b0:	ec1fc0ef          	jal	ra,80002070 <printk>
800051b4:	80007537          	lui	a0,0x80007
800051b8:	86050513          	addi	a0,a0,-1952 # 80006860 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006861>
800051bc:	eb5fc0ef          	jal	ra,80002070 <printk>
800051c0:	04d00593          	li	a1,77
800051c4:	cd890513          	addi	a0,s2,-808
800051c8:	ee5fc0ef          	jal	ra,800020ac <assert_post_action>
	to->fn = fn;
800051cc:	01342623          	sw	s3,12(s0)
	ticks = MAX(1, ticks);
800051d0:	00904463          	bgtz	s1,800051d8 <z_add_timeout+0x84>
800051d4:	00100493          	li	s1,1
	__asm__ volatile ("csrrc %0, mstatus, %1"
800051d8:	00800993          	li	s3,8
800051dc:	3009b9f3          	csrrc	s3,mstatus,s3
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
800051e0:	80007a37          	lui	s4,0x80007
800051e4:	e60a0513          	addi	a0,s4,-416 # 80006e60 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006e61>
	key = (mstatus & SOC_MSTATUS_IEN);
800051e8:	0089f993          	andi	s3,s3,8
800051ec:	9adff0ef          	jal	ra,80004b98 <z_spin_lock_valid>
800051f0:	02051e63          	bnez	a0,8000522c <z_add_timeout+0xd8>
800051f4:	80007937          	lui	s2,0x80007
800051f8:	800075b7          	lui	a1,0x80007
800051fc:	80006537          	lui	a0,0x80006
80005200:	8c058593          	addi	a1,a1,-1856 # 800068c0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800068c1>
80005204:	04e00693          	li	a3,78
80005208:	8a890613          	addi	a2,s2,-1880 # 800068a8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800068a9>
8000520c:	7dc50513          	addi	a0,a0,2012 # 800067dc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800067dd>
80005210:	e61fc0ef          	jal	ra,80002070 <printk>
80005214:	80007537          	lui	a0,0x80007
80005218:	8d850513          	addi	a0,a0,-1832 # 800068d8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800068d9>
8000521c:	e55fc0ef          	jal	ra,80002070 <printk>
80005220:	04e00593          	li	a1,78
80005224:	8a890513          	addi	a0,s2,-1880
80005228:	e85fc0ef          	jal	ra,800020ac <assert_post_action>
	z_spin_lock_set_owner(l);
8000522c:	e60a0513          	addi	a0,s4,-416
80005230:	9c1ff0ef          	jal	ra,80004bf0 <z_spin_lock_set_owner>

	LOCKED(&timeout_lock) {
		struct _timeout *t;

		to->dticks = ticks + elapsed();
80005234:	e45ff0ef          	jal	ra,80005078 <elapsed>
80005238:	00950533          	add	a0,a0,s1
	return list->head == list;
8000523c:	800074b7          	lui	s1,0x80007
80005240:	d904a903          	lw	s2,-624(s1) # 80006d90 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006d91>
80005244:	00a42423          	sw	a0,8(s0)
80005248:	d9048493          	addi	s1,s1,-624
	return sys_dlist_is_empty(list) ? NULL : list->head;
8000524c:	00990c63          	beq	s2,s1,80005264 <z_add_timeout+0x110>
		for (t = first(); t != NULL; t = next(t)) {
			__ASSERT(t->dticks >= 0, "");
80005250:	80007ab7          	lui	s5,0x80007
80005254:	80007b37          	lui	s6,0x80007
80005258:	80006bb7          	lui	s7,0x80006
8000525c:	80007c37          	lui	s8,0x80007
		for (t = first(); t != NULL; t = next(t)) {
80005260:	02091063          	bnez	s2,80005280 <z_add_timeout+0x12c>
	node->prev = list->tail;
80005264:	0044a783          	lw	a5,4(s1)
	node->next = list;
80005268:	00942023          	sw	s1,0(s0)
	node->prev = list->tail;
8000526c:	00f42223          	sw	a5,4(s0)
	list->tail->next = node;
80005270:	0044a783          	lw	a5,4(s1)
80005274:	0087a023          	sw	s0,0(a5)
	list->tail = node;
80005278:	0084a223          	sw	s0,4(s1)
8000527c:	05c0006f          	j	800052d8 <z_add_timeout+0x184>
			__ASSERT(t->dticks >= 0, "");
80005280:	00892783          	lw	a5,8(s2)
80005284:	0207d663          	bgez	a5,800052b0 <z_add_timeout+0x15c>
80005288:	d0cb0593          	addi	a1,s6,-756 # 80006d0c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006d0d>
8000528c:	05600693          	li	a3,86
80005290:	cd8a8613          	addi	a2,s5,-808 # 80006cd8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006cd9>
80005294:	7dcb8513          	addi	a0,s7,2012 # 800067dc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800067dd>
80005298:	dd9fc0ef          	jal	ra,80002070 <printk>
8000529c:	860c0513          	addi	a0,s8,-1952 # 80006860 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006861>
800052a0:	dd1fc0ef          	jal	ra,80002070 <printk>
800052a4:	05600593          	li	a1,86
800052a8:	cd8a8513          	addi	a0,s5,-808
800052ac:	e01fc0ef          	jal	ra,800020ac <assert_post_action>

			if (t->dticks > to->dticks) {
800052b0:	00892703          	lw	a4,8(s2)
800052b4:	00842783          	lw	a5,8(s0)
800052b8:	0ae7d863          	bge	a5,a4,80005368 <z_add_timeout+0x214>
				t->dticks -= to->dticks;
800052bc:	40f707b3          	sub	a5,a4,a5
800052c0:	00f92423          	sw	a5,8(s2)
	node->prev = successor->prev;
800052c4:	00492783          	lw	a5,4(s2)
	node->next = successor;
800052c8:	01242023          	sw	s2,0(s0)
	node->prev = successor->prev;
800052cc:	00f42223          	sw	a5,4(s0)
	successor->prev->next = node;
800052d0:	0087a023          	sw	s0,0(a5)
	successor->prev = node;
800052d4:	00892223          	sw	s0,4(s2)
	return list->head == list;
800052d8:	0004a783          	lw	a5,0(s1)
	return sys_dlist_is_empty(list) ? NULL : list->head;
800052dc:	00978a63          	beq	a5,s1,800052f0 <z_add_timeout+0x19c>

		if (t == NULL) {
			sys_dlist_append(&timeout_list, &to->node);
		}

		if (to == first()) {
800052e0:	00f41863          	bne	s0,a5,800052f0 <z_add_timeout+0x19c>
			z_clock_set_timeout(next_timeout(), false);
800052e4:	dedff0ef          	jal	ra,800050d0 <next_timeout>
800052e8:	00000593          	li	a1,0
800052ec:	898fd0ef          	jal	ra,80002384 <z_clock_set_timeout>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
800052f0:	e60a0513          	addi	a0,s4,-416
800052f4:	8cdff0ef          	jal	ra,80004bc0 <z_spin_unlock_valid>
800052f8:	02051e63          	bnez	a0,80005334 <z_add_timeout+0x1e0>
800052fc:	80007437          	lui	s0,0x80007
80005300:	800075b7          	lui	a1,0x80007
80005304:	80006537          	lui	a0,0x80006
80005308:	8f058593          	addi	a1,a1,-1808 # 800068f0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800068f1>
8000530c:	06100693          	li	a3,97
80005310:	8a840613          	addi	a2,s0,-1880 # 800068a8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800068a9>
80005314:	7dc50513          	addi	a0,a0,2012 # 800067dc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800067dd>
80005318:	d59fc0ef          	jal	ra,80002070 <printk>
8000531c:	80007537          	lui	a0,0x80007
80005320:	90850513          	addi	a0,a0,-1784 # 80006908 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006909>
80005324:	d4dfc0ef          	jal	ra,80002070 <printk>
80005328:	06100593          	li	a1,97
8000532c:	8a840513          	addi	a0,s0,-1880
80005330:	d7dfc0ef          	jal	ra,800020ac <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80005334:	3009a9f3          	csrrs	s3,mstatus,s3
		}
	}
}
80005338:	02c12083          	lw	ra,44(sp)
8000533c:	02812403          	lw	s0,40(sp)
80005340:	02412483          	lw	s1,36(sp)
80005344:	02012903          	lw	s2,32(sp)
80005348:	01c12983          	lw	s3,28(sp)
8000534c:	01812a03          	lw	s4,24(sp)
80005350:	01412a83          	lw	s5,20(sp)
80005354:	01012b03          	lw	s6,16(sp)
80005358:	00c12b83          	lw	s7,12(sp)
8000535c:	00812c03          	lw	s8,8(sp)
80005360:	03010113          	addi	sp,sp,48
80005364:	00008067          	ret
			to->dticks -= t->dticks;
80005368:	40e787b3          	sub	a5,a5,a4
8000536c:	00f42423          	sw	a5,8(s0)
	return (node == list->tail) ? NULL : node->next;
80005370:	0044a783          	lw	a5,4(s1)
80005374:	ef2788e3          	beq	a5,s2,80005264 <z_add_timeout+0x110>
80005378:	00092903          	lw	s2,0(s2)
8000537c:	ee5ff06f          	j	80005260 <z_add_timeout+0x10c>

80005380 <z_abort_timeout>:

int z_abort_timeout(struct _timeout *to)
{
80005380:	fe010113          	addi	sp,sp,-32
80005384:	00812c23          	sw	s0,24(sp)
80005388:	01312623          	sw	s3,12(sp)
8000538c:	00112e23          	sw	ra,28(sp)
80005390:	00912a23          	sw	s1,20(sp)
80005394:	01212823          	sw	s2,16(sp)
80005398:	00050993          	mv	s3,a0
	__asm__ volatile ("csrrc %0, mstatus, %1"
8000539c:	00800413          	li	s0,8
800053a0:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
800053a4:	800074b7          	lui	s1,0x80007
800053a8:	e6048513          	addi	a0,s1,-416 # 80006e60 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006e61>
	key = (mstatus & SOC_MSTATUS_IEN);
800053ac:	00847413          	andi	s0,s0,8
800053b0:	fe8ff0ef          	jal	ra,80004b98 <z_spin_lock_valid>
800053b4:	02051e63          	bnez	a0,800053f0 <z_abort_timeout+0x70>
800053b8:	80007937          	lui	s2,0x80007
800053bc:	800075b7          	lui	a1,0x80007
800053c0:	80006537          	lui	a0,0x80006
800053c4:	8c058593          	addi	a1,a1,-1856 # 800068c0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800068c1>
800053c8:	04e00693          	li	a3,78
800053cc:	8a890613          	addi	a2,s2,-1880 # 800068a8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800068a9>
800053d0:	7dc50513          	addi	a0,a0,2012 # 800067dc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800067dd>
800053d4:	c9dfc0ef          	jal	ra,80002070 <printk>
800053d8:	80007537          	lui	a0,0x80007
800053dc:	8d850513          	addi	a0,a0,-1832 # 800068d8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800068d9>
800053e0:	c91fc0ef          	jal	ra,80002070 <printk>
800053e4:	04e00593          	li	a1,78
800053e8:	8a890513          	addi	a0,s2,-1880
800053ec:	cc1fc0ef          	jal	ra,800020ac <assert_post_action>
	z_spin_lock_set_owner(l);
800053f0:	e6048513          	addi	a0,s1,-416
800053f4:	ffcff0ef          	jal	ra,80004bf0 <z_spin_lock_set_owner>
	int ret = -EINVAL;

	LOCKED(&timeout_lock) {
		if (sys_dnode_is_linked(&to->node)) {
800053f8:	0009a783          	lw	a5,0(s3)
	int ret = -EINVAL;
800053fc:	fea00913          	li	s2,-22
		if (sys_dnode_is_linked(&to->node)) {
80005400:	00078863          	beqz	a5,80005410 <z_abort_timeout+0x90>
			remove_timeout(to);
80005404:	00098513          	mv	a0,s3
80005408:	c89ff0ef          	jal	ra,80005090 <remove_timeout>
			ret = 0;
8000540c:	00000913          	li	s2,0
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80005410:	e6048513          	addi	a0,s1,-416
80005414:	facff0ef          	jal	ra,80004bc0 <z_spin_unlock_valid>
80005418:	02051e63          	bnez	a0,80005454 <z_abort_timeout+0xd4>
8000541c:	800074b7          	lui	s1,0x80007
80005420:	800075b7          	lui	a1,0x80007
80005424:	80006537          	lui	a0,0x80006
80005428:	8f058593          	addi	a1,a1,-1808 # 800068f0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800068f1>
8000542c:	06100693          	li	a3,97
80005430:	8a848613          	addi	a2,s1,-1880 # 800068a8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800068a9>
80005434:	7dc50513          	addi	a0,a0,2012 # 800067dc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800067dd>
80005438:	c39fc0ef          	jal	ra,80002070 <printk>
8000543c:	80007537          	lui	a0,0x80007
80005440:	90850513          	addi	a0,a0,-1784 # 80006908 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006909>
80005444:	c2dfc0ef          	jal	ra,80002070 <printk>
80005448:	06100593          	li	a1,97
8000544c:	8a848513          	addi	a0,s1,-1880
80005450:	c5dfc0ef          	jal	ra,800020ac <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80005454:	30042473          	csrrs	s0,mstatus,s0
		}
	}

	return ret;
}
80005458:	01c12083          	lw	ra,28(sp)
8000545c:	01812403          	lw	s0,24(sp)
80005460:	00090513          	mv	a0,s2
80005464:	01412483          	lw	s1,20(sp)
80005468:	01012903          	lw	s2,16(sp)
8000546c:	00c12983          	lw	s3,12(sp)
80005470:	02010113          	addi	sp,sp,32
80005474:	00008067          	ret

80005478 <z_get_next_timeout_expiry>:

	return ticks - elapsed();
}

s32_t z_get_next_timeout_expiry(void)
{
80005478:	ff010113          	addi	sp,sp,-16
8000547c:	00812423          	sw	s0,8(sp)
80005480:	00112623          	sw	ra,12(sp)
80005484:	00912223          	sw	s1,4(sp)
80005488:	01212023          	sw	s2,0(sp)
	__asm__ volatile ("csrrc %0, mstatus, %1"
8000548c:	00800413          	li	s0,8
80005490:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80005494:	800074b7          	lui	s1,0x80007
80005498:	e6048513          	addi	a0,s1,-416 # 80006e60 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006e61>
	key = (mstatus & SOC_MSTATUS_IEN);
8000549c:	00847413          	andi	s0,s0,8
800054a0:	ef8ff0ef          	jal	ra,80004b98 <z_spin_lock_valid>
800054a4:	02051e63          	bnez	a0,800054e0 <z_get_next_timeout_expiry+0x68>
800054a8:	80007937          	lui	s2,0x80007
800054ac:	800075b7          	lui	a1,0x80007
800054b0:	80006537          	lui	a0,0x80006
800054b4:	8c058593          	addi	a1,a1,-1856 # 800068c0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800068c1>
800054b8:	04e00693          	li	a3,78
800054bc:	8a890613          	addi	a2,s2,-1880 # 800068a8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800068a9>
800054c0:	7dc50513          	addi	a0,a0,2012 # 800067dc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800067dd>
800054c4:	badfc0ef          	jal	ra,80002070 <printk>
800054c8:	80007537          	lui	a0,0x80007
800054cc:	8d850513          	addi	a0,a0,-1832 # 800068d8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800068d9>
800054d0:	ba1fc0ef          	jal	ra,80002070 <printk>
800054d4:	04e00593          	li	a1,78
800054d8:	8a890513          	addi	a0,s2,-1880
800054dc:	bd1fc0ef          	jal	ra,800020ac <assert_post_action>
	z_spin_lock_set_owner(l);
800054e0:	e6048513          	addi	a0,s1,-416
800054e4:	f0cff0ef          	jal	ra,80004bf0 <z_spin_lock_set_owner>
	s32_t ret = K_FOREVER;

	LOCKED(&timeout_lock) {
		ret = next_timeout();
800054e8:	be9ff0ef          	jal	ra,800050d0 <next_timeout>
800054ec:	00050913          	mv	s2,a0
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
800054f0:	e6048513          	addi	a0,s1,-416
800054f4:	eccff0ef          	jal	ra,80004bc0 <z_spin_unlock_valid>
800054f8:	02051e63          	bnez	a0,80005534 <z_get_next_timeout_expiry+0xbc>
800054fc:	800074b7          	lui	s1,0x80007
80005500:	800075b7          	lui	a1,0x80007
80005504:	80006537          	lui	a0,0x80006
80005508:	8f058593          	addi	a1,a1,-1808 # 800068f0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800068f1>
8000550c:	06100693          	li	a3,97
80005510:	8a848613          	addi	a2,s1,-1880 # 800068a8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800068a9>
80005514:	7dc50513          	addi	a0,a0,2012 # 800067dc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800067dd>
80005518:	b59fc0ef          	jal	ra,80002070 <printk>
8000551c:	80007537          	lui	a0,0x80007
80005520:	90850513          	addi	a0,a0,-1784 # 80006908 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006909>
80005524:	b4dfc0ef          	jal	ra,80002070 <printk>
80005528:	06100593          	li	a1,97
8000552c:	8a848513          	addi	a0,s1,-1880
80005530:	b7dfc0ef          	jal	ra,800020ac <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80005534:	30042473          	csrrs	s0,mstatus,s0
	}
	return ret;
}
80005538:	00c12083          	lw	ra,12(sp)
8000553c:	00812403          	lw	s0,8(sp)
80005540:	00090513          	mv	a0,s2
80005544:	00412483          	lw	s1,4(sp)
80005548:	00012903          	lw	s2,0(sp)
8000554c:	01010113          	addi	sp,sp,16
80005550:	00008067          	ret

80005554 <z_set_timeout_expiry>:

void z_set_timeout_expiry(s32_t ticks, bool idle)
{
80005554:	fe010113          	addi	sp,sp,-32
80005558:	00812c23          	sw	s0,24(sp)
8000555c:	01212823          	sw	s2,16(sp)
80005560:	01412423          	sw	s4,8(sp)
80005564:	00112e23          	sw	ra,28(sp)
80005568:	00912a23          	sw	s1,20(sp)
8000556c:	01312623          	sw	s3,12(sp)
80005570:	00050913          	mv	s2,a0
80005574:	00058a13          	mv	s4,a1
	__asm__ volatile ("csrrc %0, mstatus, %1"
80005578:	00800413          	li	s0,8
8000557c:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80005580:	800074b7          	lui	s1,0x80007
80005584:	e6048513          	addi	a0,s1,-416 # 80006e60 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006e61>
	key = (mstatus & SOC_MSTATUS_IEN);
80005588:	00847413          	andi	s0,s0,8
8000558c:	e0cff0ef          	jal	ra,80004b98 <z_spin_lock_valid>
80005590:	02051e63          	bnez	a0,800055cc <z_set_timeout_expiry+0x78>
80005594:	800079b7          	lui	s3,0x80007
80005598:	800075b7          	lui	a1,0x80007
8000559c:	80006537          	lui	a0,0x80006
800055a0:	8c058593          	addi	a1,a1,-1856 # 800068c0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800068c1>
800055a4:	04e00693          	li	a3,78
800055a8:	8a898613          	addi	a2,s3,-1880 # 800068a8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800068a9>
800055ac:	7dc50513          	addi	a0,a0,2012 # 800067dc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800067dd>
800055b0:	ac1fc0ef          	jal	ra,80002070 <printk>
800055b4:	80007537          	lui	a0,0x80007
800055b8:	8d850513          	addi	a0,a0,-1832 # 800068d8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800068d9>
800055bc:	ab5fc0ef          	jal	ra,80002070 <printk>
800055c0:	04e00593          	li	a1,78
800055c4:	8a898513          	addi	a0,s3,-1880
800055c8:	ae5fc0ef          	jal	ra,800020ac <assert_post_action>
	z_spin_lock_set_owner(l);
800055cc:	e6048513          	addi	a0,s1,-416
800055d0:	e20ff0ef          	jal	ra,80004bf0 <z_spin_lock_set_owner>
	LOCKED(&timeout_lock) {
		int next = next_timeout();
800055d4:	afdff0ef          	jal	ra,800050d0 <next_timeout>
		 * what we have.  Also don't try to set a timeout when
		 * one is about to expire: drivers have internal logic
		 * that will bump the timeout to the "next" tick if
		 * it's not considered to be settable as directed.
		 */
		if (sooner && !imminent) {
800055d8:	00a95c63          	bge	s2,a0,800055f0 <z_set_timeout_expiry+0x9c>
800055dc:	00100793          	li	a5,1
800055e0:	00a7d863          	bge	a5,a0,800055f0 <z_set_timeout_expiry+0x9c>
			z_clock_set_timeout(ticks, idle);
800055e4:	000a0593          	mv	a1,s4
800055e8:	00090513          	mv	a0,s2
800055ec:	d99fc0ef          	jal	ra,80002384 <z_clock_set_timeout>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
800055f0:	e6048513          	addi	a0,s1,-416
800055f4:	dccff0ef          	jal	ra,80004bc0 <z_spin_unlock_valid>
800055f8:	02051e63          	bnez	a0,80005634 <z_set_timeout_expiry+0xe0>
800055fc:	800074b7          	lui	s1,0x80007
80005600:	800075b7          	lui	a1,0x80007
80005604:	80006537          	lui	a0,0x80006
80005608:	8f058593          	addi	a1,a1,-1808 # 800068f0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800068f1>
8000560c:	06100693          	li	a3,97
80005610:	8a848613          	addi	a2,s1,-1880 # 800068a8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800068a9>
80005614:	7dc50513          	addi	a0,a0,2012 # 800067dc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800067dd>
80005618:	a59fc0ef          	jal	ra,80002070 <printk>
8000561c:	80007537          	lui	a0,0x80007
80005620:	90850513          	addi	a0,a0,-1784 # 80006908 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006909>
80005624:	a4dfc0ef          	jal	ra,80002070 <printk>
80005628:	06100593          	li	a1,97
8000562c:	8a848513          	addi	a0,s1,-1880
80005630:	a7dfc0ef          	jal	ra,800020ac <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80005634:	30042473          	csrrs	s0,mstatus,s0
		}
	}
}
80005638:	01c12083          	lw	ra,28(sp)
8000563c:	01812403          	lw	s0,24(sp)
80005640:	01412483          	lw	s1,20(sp)
80005644:	01012903          	lw	s2,16(sp)
80005648:	00c12983          	lw	s3,12(sp)
8000564c:	00812a03          	lw	s4,8(sp)
80005650:	02010113          	addi	sp,sp,32
80005654:	00008067          	ret

80005658 <z_clock_announce>:

void z_clock_announce(s32_t ticks)
{
80005658:	fd010113          	addi	sp,sp,-48
8000565c:	02812423          	sw	s0,40(sp)
80005660:	01412c23          	sw	s4,24(sp)
80005664:	02112623          	sw	ra,44(sp)
80005668:	02912223          	sw	s1,36(sp)
8000566c:	03212023          	sw	s2,32(sp)
80005670:	01312e23          	sw	s3,28(sp)
80005674:	01512a23          	sw	s5,20(sp)
80005678:	01612823          	sw	s6,16(sp)
8000567c:	01712623          	sw	s7,12(sp)
80005680:	01812423          	sw	s8,8(sp)
80005684:	01912223          	sw	s9,4(sp)
80005688:	01a12023          	sw	s10,0(sp)
8000568c:	00050a13          	mv	s4,a0
	__asm__ volatile ("csrrc %0, mstatus, %1"
80005690:	00800413          	li	s0,8
#ifdef CONFIG_TIMESLICING
	z_time_slice(ticks);
80005694:	8c9fe0ef          	jal	ra,80003f5c <z_time_slice>
80005698:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
8000569c:	80007937          	lui	s2,0x80007
800056a0:	e6090513          	addi	a0,s2,-416 # 80006e60 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006e61>
	key = (mstatus & SOC_MSTATUS_IEN);
800056a4:	00847413          	andi	s0,s0,8
800056a8:	cf0ff0ef          	jal	ra,80004b98 <z_spin_lock_valid>
800056ac:	02051e63          	bnez	a0,800056e8 <z_clock_announce+0x90>
800056b0:	800074b7          	lui	s1,0x80007
800056b4:	800075b7          	lui	a1,0x80007
800056b8:	80006537          	lui	a0,0x80006
800056bc:	8c058593          	addi	a1,a1,-1856 # 800068c0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800068c1>
800056c0:	04e00693          	li	a3,78
800056c4:	8a848613          	addi	a2,s1,-1880 # 800068a8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800068a9>
800056c8:	7dc50513          	addi	a0,a0,2012 # 800067dc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800067dd>
800056cc:	9a5fc0ef          	jal	ra,80002070 <printk>
800056d0:	80007537          	lui	a0,0x80007
800056d4:	8d850513          	addi	a0,a0,-1832 # 800068d8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800068d9>
800056d8:	999fc0ef          	jal	ra,80002070 <printk>
800056dc:	04e00593          	li	a1,78
800056e0:	8a848513          	addi	a0,s1,-1880
800056e4:	9c9fc0ef          	jal	ra,800020ac <assert_post_action>
#endif

	k_spinlock_key_t key = k_spin_lock(&timeout_lock);

	announce_remaining = ticks;
800056e8:	800079b7          	lui	s3,0x80007
	z_spin_lock_set_owner(l);
800056ec:	e6090513          	addi	a0,s2,-416
800056f0:	d00ff0ef          	jal	ra,80004bf0 <z_spin_lock_set_owner>
800056f4:	800074b7          	lui	s1,0x80007
800056f8:	e549ae23          	sw	s4,-420(s3) # 80006e5c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006e5d>
	return list->head == list;
800056fc:	80007a37          	lui	s4,0x80007
80005700:	e5c98993          	addi	s3,s3,-420
80005704:	d90a0a13          	addi	s4,s4,-624 # 80006d90 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006d91>
80005708:	e2048493          	addi	s1,s1,-480 # 80006e20 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006e21>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
8000570c:	80007ab7          	lui	s5,0x80007
80005710:	80007bb7          	lui	s7,0x80007
80005714:	80006b37          	lui	s6,0x80006
80005718:	80007c37          	lui	s8,0x80007
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
8000571c:	80007cb7          	lui	s9,0x80007
80005720:	000a2d03          	lw	s10,0(s4)
80005724:	0009a783          	lw	a5,0(s3)
80005728:	0004a683          	lw	a3,0(s1)
8000572c:	0044a503          	lw	a0,4(s1)
	return sys_dlist_is_empty(list) ? NULL : list->head;
80005730:	014d0c63          	beq	s10,s4,80005748 <z_clock_announce+0xf0>

	while (first() != NULL && first()->dticks <= announce_remaining) {
80005734:	000d0a63          	beqz	s10,80005748 <z_clock_announce+0xf0>
80005738:	008d2703          	lw	a4,8(s10)
8000573c:	0ae7dc63          	bge	a5,a4,800057f4 <z_clock_announce+0x19c>
		t->fn(t);
		key = k_spin_lock(&timeout_lock);
	}

	if (first() != NULL) {
		first()->dticks -= announce_remaining;
80005740:	40f70733          	sub	a4,a4,a5
80005744:	00ed2423          	sw	a4,8(s10)
	}

	curr_tick += announce_remaining;
80005748:	00d786b3          	add	a3,a5,a3
8000574c:	41f7d713          	srai	a4,a5,0x1f
80005750:	00a70733          	add	a4,a4,a0
80005754:	00f6b7b3          	sltu	a5,a3,a5
80005758:	00e787b3          	add	a5,a5,a4
8000575c:	00d4a023          	sw	a3,0(s1)
80005760:	00f4a223          	sw	a5,4(s1)
	announce_remaining = 0;
80005764:	0009a023          	sw	zero,0(s3)

	z_clock_set_timeout(next_timeout(), false);
80005768:	969ff0ef          	jal	ra,800050d0 <next_timeout>
8000576c:	00000593          	li	a1,0
80005770:	c15fc0ef          	jal	ra,80002384 <z_clock_set_timeout>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80005774:	e6090513          	addi	a0,s2,-416
80005778:	c48ff0ef          	jal	ra,80004bc0 <z_spin_unlock_valid>
8000577c:	02051e63          	bnez	a0,800057b8 <z_clock_announce+0x160>
80005780:	800074b7          	lui	s1,0x80007
80005784:	800075b7          	lui	a1,0x80007
80005788:	80006537          	lui	a0,0x80006
8000578c:	8f058593          	addi	a1,a1,-1808 # 800068f0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800068f1>
80005790:	06100693          	li	a3,97
80005794:	8a848613          	addi	a2,s1,-1880 # 800068a8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800068a9>
80005798:	7dc50513          	addi	a0,a0,2012 # 800067dc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800067dd>
8000579c:	8d5fc0ef          	jal	ra,80002070 <printk>
800057a0:	80007537          	lui	a0,0x80007
800057a4:	90850513          	addi	a0,a0,-1784 # 80006908 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006909>
800057a8:	8c9fc0ef          	jal	ra,80002070 <printk>
800057ac:	06100593          	li	a1,97
800057b0:	8a848513          	addi	a0,s1,-1880
800057b4:	8f9fc0ef          	jal	ra,800020ac <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
800057b8:	30042473          	csrrs	s0,mstatus,s0

	k_spin_unlock(&timeout_lock, key);
}
800057bc:	02c12083          	lw	ra,44(sp)
800057c0:	02812403          	lw	s0,40(sp)
800057c4:	02412483          	lw	s1,36(sp)
800057c8:	02012903          	lw	s2,32(sp)
800057cc:	01c12983          	lw	s3,28(sp)
800057d0:	01812a03          	lw	s4,24(sp)
800057d4:	01412a83          	lw	s5,20(sp)
800057d8:	01012b03          	lw	s6,16(sp)
800057dc:	00c12b83          	lw	s7,12(sp)
800057e0:	00812c03          	lw	s8,8(sp)
800057e4:	00412c83          	lw	s9,4(sp)
800057e8:	00012d03          	lw	s10,0(sp)
800057ec:	03010113          	addi	sp,sp,48
800057f0:	00008067          	ret
		curr_tick += dt;
800057f4:	00d706b3          	add	a3,a4,a3
800057f8:	41f75593          	srai	a1,a4,0x1f
800057fc:	00a585b3          	add	a1,a1,a0
80005800:	00e6b633          	sltu	a2,a3,a4
80005804:	00b60633          	add	a2,a2,a1
		announce_remaining -= dt;
80005808:	40e787b3          	sub	a5,a5,a4
		remove_timeout(t);
8000580c:	000d0513          	mv	a0,s10
		t->dticks = 0;
80005810:	000d2423          	sw	zero,8(s10)
		curr_tick += dt;
80005814:	00d4a023          	sw	a3,0(s1)
80005818:	00c4a223          	sw	a2,4(s1)
		announce_remaining -= dt;
8000581c:	00f9a023          	sw	a5,0(s3)
		remove_timeout(t);
80005820:	871ff0ef          	jal	ra,80005090 <remove_timeout>
80005824:	e6090513          	addi	a0,s2,-416
80005828:	b98ff0ef          	jal	ra,80004bc0 <z_spin_unlock_valid>
8000582c:	02051663          	bnez	a0,80005858 <z_clock_announce+0x200>
80005830:	8f0b8593          	addi	a1,s7,-1808 # 800068f0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800068f1>
80005834:	06100693          	li	a3,97
80005838:	8a8a8613          	addi	a2,s5,-1880 # 800068a8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800068a9>
8000583c:	7dcb0513          	addi	a0,s6,2012 # 800067dc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800067dd>
80005840:	831fc0ef          	jal	ra,80002070 <printk>
80005844:	908c0513          	addi	a0,s8,-1784 # 80006908 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006909>
80005848:	829fc0ef          	jal	ra,80002070 <printk>
8000584c:	06100593          	li	a1,97
80005850:	8a8a8513          	addi	a0,s5,-1880
80005854:	859fc0ef          	jal	ra,800020ac <assert_post_action>
80005858:	30042473          	csrrs	s0,mstatus,s0
		t->fn(t);
8000585c:	00cd2783          	lw	a5,12(s10)
80005860:	000d0513          	mv	a0,s10
	__asm__ volatile ("csrrc %0, mstatus, %1"
80005864:	00800413          	li	s0,8
80005868:	000780e7          	jalr	a5
8000586c:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80005870:	e6090513          	addi	a0,s2,-416
	key = (mstatus & SOC_MSTATUS_IEN);
80005874:	00847413          	andi	s0,s0,8
80005878:	b20ff0ef          	jal	ra,80004b98 <z_spin_lock_valid>
8000587c:	02051863          	bnez	a0,800058ac <z_clock_announce+0x254>
80005880:	8c0c8593          	addi	a1,s9,-1856 # 800068c0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800068c1>
80005884:	04e00693          	li	a3,78
80005888:	8a8a8613          	addi	a2,s5,-1880
8000588c:	7dcb0513          	addi	a0,s6,2012
80005890:	fe0fc0ef          	jal	ra,80002070 <printk>
80005894:	80007537          	lui	a0,0x80007
80005898:	8d850513          	addi	a0,a0,-1832 # 800068d8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800068d9>
8000589c:	fd4fc0ef          	jal	ra,80002070 <printk>
800058a0:	04e00593          	li	a1,78
800058a4:	8a8a8513          	addi	a0,s5,-1880
800058a8:	805fc0ef          	jal	ra,800020ac <assert_post_action>
	z_spin_lock_set_owner(l);
800058ac:	e6090513          	addi	a0,s2,-416
800058b0:	b40ff0ef          	jal	ra,80004bf0 <z_spin_lock_set_owner>
	return k;
800058b4:	e6dff06f          	j	80005720 <z_clock_announce+0xc8>

800058b8 <z_tick_get>:
{
	can_wait_forever = 1;
}

s64_t z_tick_get(void)
{
800058b8:	fe010113          	addi	sp,sp,-32
800058bc:	00912a23          	sw	s1,20(sp)
800058c0:	00112e23          	sw	ra,28(sp)
800058c4:	00812c23          	sw	s0,24(sp)
800058c8:	01212823          	sw	s2,16(sp)
800058cc:	01312623          	sw	s3,12(sp)
	__asm__ volatile ("csrrc %0, mstatus, %1"
800058d0:	00800493          	li	s1,8
800058d4:	3004b4f3          	csrrc	s1,mstatus,s1
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
800058d8:	80007937          	lui	s2,0x80007
800058dc:	e6090513          	addi	a0,s2,-416 # 80006e60 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006e61>
	key = (mstatus & SOC_MSTATUS_IEN);
800058e0:	0084f493          	andi	s1,s1,8
800058e4:	ab4ff0ef          	jal	ra,80004b98 <z_spin_lock_valid>
800058e8:	02051e63          	bnez	a0,80005924 <z_tick_get+0x6c>
800058ec:	80007437          	lui	s0,0x80007
800058f0:	800075b7          	lui	a1,0x80007
800058f4:	80006537          	lui	a0,0x80006
800058f8:	8c058593          	addi	a1,a1,-1856 # 800068c0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800068c1>
800058fc:	04e00693          	li	a3,78
80005900:	8a840613          	addi	a2,s0,-1880 # 800068a8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800068a9>
80005904:	7dc50513          	addi	a0,a0,2012 # 800067dc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800067dd>
80005908:	f68fc0ef          	jal	ra,80002070 <printk>
8000590c:	80007537          	lui	a0,0x80007
80005910:	8d850513          	addi	a0,a0,-1832 # 800068d8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800068d9>
80005914:	f5cfc0ef          	jal	ra,80002070 <printk>
80005918:	04e00593          	li	a1,78
8000591c:	8a840513          	addi	a0,s0,-1880
80005920:	f8cfc0ef          	jal	ra,800020ac <assert_post_action>
	z_spin_lock_set_owner(l);
80005924:	e6090513          	addi	a0,s2,-416
80005928:	ac8ff0ef          	jal	ra,80004bf0 <z_spin_lock_set_owner>
	u64_t t = 0U;

	LOCKED(&timeout_lock) {
		t = curr_tick + z_clock_elapsed();
8000592c:	c01fc0ef          	jal	ra,8000252c <z_clock_elapsed>
80005930:	800077b7          	lui	a5,0x80007
80005934:	e2078793          	addi	a5,a5,-480 # 80006e20 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006e21>
80005938:	0007a983          	lw	s3,0(a5)
8000593c:	0047a403          	lw	s0,4(a5)
80005940:	013509b3          	add	s3,a0,s3
80005944:	00a9b533          	sltu	a0,s3,a0
80005948:	00850433          	add	s0,a0,s0
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
8000594c:	e6090513          	addi	a0,s2,-416
80005950:	a70ff0ef          	jal	ra,80004bc0 <z_spin_unlock_valid>
80005954:	02051e63          	bnez	a0,80005990 <z_tick_get+0xd8>
80005958:	80007937          	lui	s2,0x80007
8000595c:	800075b7          	lui	a1,0x80007
80005960:	80006537          	lui	a0,0x80006
80005964:	8f058593          	addi	a1,a1,-1808 # 800068f0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800068f1>
80005968:	06100693          	li	a3,97
8000596c:	8a890613          	addi	a2,s2,-1880 # 800068a8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800068a9>
80005970:	7dc50513          	addi	a0,a0,2012 # 800067dc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800067dd>
80005974:	efcfc0ef          	jal	ra,80002070 <printk>
80005978:	80007537          	lui	a0,0x80007
8000597c:	90850513          	addi	a0,a0,-1784 # 80006908 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006909>
80005980:	ef0fc0ef          	jal	ra,80002070 <printk>
80005984:	06100593          	li	a1,97
80005988:	8a890513          	addi	a0,s2,-1880
8000598c:	f20fc0ef          	jal	ra,800020ac <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80005990:	3004a4f3          	csrrs	s1,mstatus,s1
	}
	return t;
}
80005994:	00040593          	mv	a1,s0
80005998:	01c12083          	lw	ra,28(sp)
8000599c:	01812403          	lw	s0,24(sp)
800059a0:	00098513          	mv	a0,s3
800059a4:	01412483          	lw	s1,20(sp)
800059a8:	01012903          	lw	s2,16(sp)
800059ac:	00c12983          	lw	s3,12(sp)
800059b0:	02010113          	addi	sp,sp,32
800059b4:	00008067          	ret

800059b8 <z_impl_k_uptime_get>:
	return z_impl_k_uptime_get_32();
}
#endif

s64_t z_impl_k_uptime_get(void)
{
800059b8:	ff010113          	addi	sp,sp,-16
800059bc:	00112623          	sw	ra,12(sp)
	return __ticks_to_ms(z_tick_get());
800059c0:	ef9ff0ef          	jal	ra,800058b8 <z_tick_get>
#ifdef _NEED_PRECISE_TICK_MS_CONVERSION
	/* use 64-bit math to keep precision */
	return (u64_t)ticks * MSEC_PER_SEC / (u64_t)CONFIG_SYS_CLOCK_TICKS_PER_SEC;
#else
	/* simple multiplication keeps precision */
	return (u64_t)ticks * MSEC_PER_SEC / (u64_t)CONFIG_SYS_CLOCK_TICKS_PER_SEC;
800059c4:	3e800613          	li	a2,1000
800059c8:	00000693          	li	a3,0
800059cc:	eddfa0ef          	jal	ra,800008a8 <__muldi3>
800059d0:	06400613          	li	a2,100
800059d4:	00000693          	li	a3,0
800059d8:	8d9fa0ef          	jal	ra,800002b0 <__udivdi3>
}
800059dc:	00c12083          	lw	ra,12(sp)
800059e0:	01010113          	addi	sp,sp,16
800059e4:	00008067          	ret

800059e8 <z_impl_atomic_or>:
 * @param value the value to OR
 *
 * @return The previous value from <target>
 */
atomic_val_t z_impl_atomic_or(atomic_t *target, atomic_val_t value)
{
800059e8:	fe010113          	addi	sp,sp,-32
800059ec:	00812c23          	sw	s0,24(sp)
800059f0:	01212823          	sw	s2,16(sp)
800059f4:	01412423          	sw	s4,8(sp)
800059f8:	00112e23          	sw	ra,28(sp)
800059fc:	00912a23          	sw	s1,20(sp)
80005a00:	01312623          	sw	s3,12(sp)
80005a04:	00050a13          	mv	s4,a0
80005a08:	00058913          	mv	s2,a1
	__asm__ volatile ("csrrc %0, mstatus, %1"
80005a0c:	00800413          	li	s0,8
80005a10:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80005a14:	800074b7          	lui	s1,0x80007
80005a18:	e6448513          	addi	a0,s1,-412 # 80006e64 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006e65>
	key = (mstatus & SOC_MSTATUS_IEN);
80005a1c:	00847413          	andi	s0,s0,8
80005a20:	978ff0ef          	jal	ra,80004b98 <z_spin_lock_valid>
80005a24:	02051e63          	bnez	a0,80005a60 <z_impl_atomic_or+0x78>
80005a28:	800079b7          	lui	s3,0x80007
80005a2c:	800075b7          	lui	a1,0x80007
80005a30:	80006537          	lui	a0,0x80006
80005a34:	8c058593          	addi	a1,a1,-1856 # 800068c0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800068c1>
80005a38:	04e00693          	li	a3,78
80005a3c:	8a898613          	addi	a2,s3,-1880 # 800068a8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800068a9>
80005a40:	7dc50513          	addi	a0,a0,2012 # 800067dc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800067dd>
80005a44:	e2cfc0ef          	jal	ra,80002070 <printk>
80005a48:	80007537          	lui	a0,0x80007
80005a4c:	8d850513          	addi	a0,a0,-1832 # 800068d8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800068d9>
80005a50:	e20fc0ef          	jal	ra,80002070 <printk>
80005a54:	04e00593          	li	a1,78
80005a58:	8a898513          	addi	a0,s3,-1880
80005a5c:	e50fc0ef          	jal	ra,800020ac <assert_post_action>
	z_spin_lock_set_owner(l);
80005a60:	e6448513          	addi	a0,s1,-412
80005a64:	98cff0ef          	jal	ra,80004bf0 <z_spin_lock_set_owner>
	k_spinlock_key_t key;
	atomic_val_t ret;

	key = k_spin_lock(&lock);

	ret = *target;
80005a68:	000a2983          	lw	s3,0(s4)
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80005a6c:	e6448513          	addi	a0,s1,-412
	*target |= value;
80005a70:	0129e933          	or	s2,s3,s2
80005a74:	012a2023          	sw	s2,0(s4)
80005a78:	948ff0ef          	jal	ra,80004bc0 <z_spin_unlock_valid>
80005a7c:	02051e63          	bnez	a0,80005ab8 <z_impl_atomic_or+0xd0>
80005a80:	800074b7          	lui	s1,0x80007
80005a84:	800075b7          	lui	a1,0x80007
80005a88:	80006537          	lui	a0,0x80006
80005a8c:	8f058593          	addi	a1,a1,-1808 # 800068f0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800068f1>
80005a90:	06100693          	li	a3,97
80005a94:	8a848613          	addi	a2,s1,-1880 # 800068a8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800068a9>
80005a98:	7dc50513          	addi	a0,a0,2012 # 800067dc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800067dd>
80005a9c:	dd4fc0ef          	jal	ra,80002070 <printk>
80005aa0:	80007537          	lui	a0,0x80007
80005aa4:	90850513          	addi	a0,a0,-1784 # 80006908 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006909>
80005aa8:	dc8fc0ef          	jal	ra,80002070 <printk>
80005aac:	06100593          	li	a1,97
80005ab0:	8a848513          	addi	a0,s1,-1880
80005ab4:	df8fc0ef          	jal	ra,800020ac <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80005ab8:	30042473          	csrrs	s0,mstatus,s0

	k_spin_unlock(&lock, key);

	return ret;
}
80005abc:	01c12083          	lw	ra,28(sp)
80005ac0:	01812403          	lw	s0,24(sp)
80005ac4:	00098513          	mv	a0,s3
80005ac8:	01412483          	lw	s1,20(sp)
80005acc:	01012903          	lw	s2,16(sp)
80005ad0:	00c12983          	lw	s3,12(sp)
80005ad4:	00812a03          	lw	s4,8(sp)
80005ad8:	02010113          	addi	sp,sp,32
80005adc:	00008067          	ret

80005ae0 <z_impl_atomic_and>:
 * @param value the value to AND
 *
 * @return The previous value from <target>
 */
atomic_val_t z_impl_atomic_and(atomic_t *target, atomic_val_t value)
{
80005ae0:	fe010113          	addi	sp,sp,-32
80005ae4:	00812c23          	sw	s0,24(sp)
80005ae8:	01212823          	sw	s2,16(sp)
80005aec:	01412423          	sw	s4,8(sp)
80005af0:	00112e23          	sw	ra,28(sp)
80005af4:	00912a23          	sw	s1,20(sp)
80005af8:	01312623          	sw	s3,12(sp)
80005afc:	00050a13          	mv	s4,a0
80005b00:	00058913          	mv	s2,a1
	__asm__ volatile ("csrrc %0, mstatus, %1"
80005b04:	00800413          	li	s0,8
80005b08:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80005b0c:	800074b7          	lui	s1,0x80007
80005b10:	e6448513          	addi	a0,s1,-412 # 80006e64 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006e65>
	key = (mstatus & SOC_MSTATUS_IEN);
80005b14:	00847413          	andi	s0,s0,8
80005b18:	880ff0ef          	jal	ra,80004b98 <z_spin_lock_valid>
80005b1c:	02051e63          	bnez	a0,80005b58 <z_impl_atomic_and+0x78>
80005b20:	800079b7          	lui	s3,0x80007
80005b24:	800075b7          	lui	a1,0x80007
80005b28:	80006537          	lui	a0,0x80006
80005b2c:	8c058593          	addi	a1,a1,-1856 # 800068c0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800068c1>
80005b30:	04e00693          	li	a3,78
80005b34:	8a898613          	addi	a2,s3,-1880 # 800068a8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800068a9>
80005b38:	7dc50513          	addi	a0,a0,2012 # 800067dc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800067dd>
80005b3c:	d34fc0ef          	jal	ra,80002070 <printk>
80005b40:	80007537          	lui	a0,0x80007
80005b44:	8d850513          	addi	a0,a0,-1832 # 800068d8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800068d9>
80005b48:	d28fc0ef          	jal	ra,80002070 <printk>
80005b4c:	04e00593          	li	a1,78
80005b50:	8a898513          	addi	a0,s3,-1880
80005b54:	d58fc0ef          	jal	ra,800020ac <assert_post_action>
	z_spin_lock_set_owner(l);
80005b58:	e6448513          	addi	a0,s1,-412
80005b5c:	894ff0ef          	jal	ra,80004bf0 <z_spin_lock_set_owner>
	k_spinlock_key_t key;
	atomic_val_t ret;

	key = k_spin_lock(&lock);

	ret = *target;
80005b60:	000a2983          	lw	s3,0(s4)
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80005b64:	e6448513          	addi	a0,s1,-412
	*target &= value;
80005b68:	0129f933          	and	s2,s3,s2
80005b6c:	012a2023          	sw	s2,0(s4)
80005b70:	850ff0ef          	jal	ra,80004bc0 <z_spin_unlock_valid>
80005b74:	02051e63          	bnez	a0,80005bb0 <z_impl_atomic_and+0xd0>
80005b78:	800074b7          	lui	s1,0x80007
80005b7c:	800075b7          	lui	a1,0x80007
80005b80:	80006537          	lui	a0,0x80006
80005b84:	8f058593          	addi	a1,a1,-1808 # 800068f0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800068f1>
80005b88:	06100693          	li	a3,97
80005b8c:	8a848613          	addi	a2,s1,-1880 # 800068a8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800068a9>
80005b90:	7dc50513          	addi	a0,a0,2012 # 800067dc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800067dd>
80005b94:	cdcfc0ef          	jal	ra,80002070 <printk>
80005b98:	80007537          	lui	a0,0x80007
80005b9c:	90850513          	addi	a0,a0,-1784 # 80006908 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006909>
80005ba0:	cd0fc0ef          	jal	ra,80002070 <printk>
80005ba4:	06100593          	li	a1,97
80005ba8:	8a848513          	addi	a0,s1,-1880
80005bac:	d00fc0ef          	jal	ra,800020ac <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80005bb0:	30042473          	csrrs	s0,mstatus,s0

	k_spin_unlock(&lock, key);

	return ret;
}
80005bb4:	01c12083          	lw	ra,28(sp)
80005bb8:	01812403          	lw	s0,24(sp)
80005bbc:	00098513          	mv	a0,s3
80005bc0:	01412483          	lw	s1,20(sp)
80005bc4:	01012903          	lw	s2,16(sp)
80005bc8:	00c12983          	lw	s3,12(sp)
80005bcc:	00812a03          	lw	s4,8(sp)
80005bd0:	02010113          	addi	sp,sp,32
80005bd4:	00008067          	ret

80005bd8 <init_static_pools>:
	z_waitq_init(&p->wait_q);
	z_sys_mem_pool_base_init(&p->base);
}

int init_static_pools(struct device *unused)
{
80005bd8:	ff010113          	addi	sp,sp,-16
80005bdc:	00812423          	sw	s0,8(sp)
80005be0:	00912223          	sw	s1,4(sp)
	ARG_UNUSED(unused);
	struct k_mem_pool *p;

	for (p = _k_mem_pool_list_start; p < _k_mem_pool_list_end; p++) {
80005be4:	80007437          	lui	s0,0x80007
80005be8:	800074b7          	lui	s1,0x80007
{
80005bec:	00112623          	sw	ra,12(sp)
	for (p = _k_mem_pool_list_start; p < _k_mem_pool_list_end; p++) {
80005bf0:	dd040413          	addi	s0,s0,-560 # 80006dd0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006dd1>
80005bf4:	dd048493          	addi	s1,s1,-560 # 80006dd0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006dd1>
80005bf8:	00946e63          	bltu	s0,s1,80005c14 <init_static_pools+0x3c>
		k_mem_pool_init(p);
	}

	return 0;
}
80005bfc:	00c12083          	lw	ra,12(sp)
80005c00:	00812403          	lw	s0,8(sp)
80005c04:	00412483          	lw	s1,4(sp)
80005c08:	00000513          	li	a0,0
80005c0c:	01010113          	addi	sp,sp,16
80005c10:	00008067          	ret
80005c14:	01440793          	addi	a5,s0,20
	z_sys_mem_pool_base_init(&p->base);
80005c18:	00040513          	mv	a0,s0
	list->head = (sys_dnode_t *)list;
80005c1c:	00f42a23          	sw	a5,20(s0)
	list->tail = (sys_dnode_t *)list;
80005c20:	00f42c23          	sw	a5,24(s0)
80005c24:	e68fb0ef          	jal	ra,8000128c <z_sys_mem_pool_base_init>
	for (p = _k_mem_pool_list_start; p < _k_mem_pool_list_end; p++) {
80005c28:	01c40413          	addi	s0,s0,28
80005c2c:	fcdff06f          	j	80005bf8 <init_static_pools+0x20>

80005c30 <k_mem_pool_alloc>:
		     size_t size, s32_t timeout)
{
	int ret;
	s64_t end = 0;

	__ASSERT(!(z_is_in_isr() && timeout != K_NO_WAIT), "");
80005c30:	800077b7          	lui	a5,0x80007
80005c34:	1347a783          	lw	a5,308(a5) # 80007134 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007135>
{
80005c38:	fb010113          	addi	sp,sp,-80
80005c3c:	04812423          	sw	s0,72(sp)
80005c40:	04912223          	sw	s1,68(sp)
80005c44:	03312e23          	sw	s3,60(sp)
80005c48:	03612823          	sw	s6,48(sp)
80005c4c:	04112623          	sw	ra,76(sp)
80005c50:	05212023          	sw	s2,64(sp)
80005c54:	03412c23          	sw	s4,56(sp)
80005c58:	03512a23          	sw	s5,52(sp)
80005c5c:	03712623          	sw	s7,44(sp)
80005c60:	03812423          	sw	s8,40(sp)
80005c64:	03912223          	sw	s9,36(sp)
80005c68:	03a12023          	sw	s10,32(sp)
80005c6c:	01b12e23          	sw	s11,28(sp)
80005c70:	00050993          	mv	s3,a0
80005c74:	00058493          	mv	s1,a1
80005c78:	00060b13          	mv	s6,a2
80005c7c:	00068413          	mv	s0,a3
	__ASSERT(!(z_is_in_isr() && timeout != K_NO_WAIT), "");
80005c80:	16078263          	beqz	a5,80005de4 <k_mem_pool_alloc+0x1b4>
80005c84:	12069463          	bnez	a3,80005dac <k_mem_pool_alloc+0x17c>
	s64_t end = 0;
80005c88:	00000913          	li	s2,0
	return pool - &_k_mem_pool_list_start[0];
80005c8c:	80007537          	lui	a0,0x80007
80005c90:	dd050513          	addi	a0,a0,-560 # 80006dd0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006dd1>
80005c94:	40a98533          	sub	a0,s3,a0
80005c98:	b6db75b7          	lui	a1,0xb6db7
80005c9c:	db758593          	addi	a1,a1,-585 # b6db6db7 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0xb6db6db8>
80005ca0:	40255513          	srai	a0,a0,0x2
80005ca4:	be1fa0ef          	jal	ra,80000884 <__mulsi3>
		if (ret == -EAGAIN) {
			ret = -ENOMEM;
		}

		block->id.pool = pool_id(p);
		block->id.level = level_num;
80005ca8:	fffffa37          	lui	s4,0xfffff
		block->id.block = block_num;
80005cac:	00001ab7          	lui	s5,0x1
		block->id.pool = pool_id(p);
80005cb0:	0ff57c13          	andi	s8,a0,255
			if (ret != -EAGAIN) {
80005cb4:	ff500b93          	li	s7,-11
			ret = -ENOMEM;
80005cb8:	ff400c93          	li	s9,-12
		block->id.level = level_num;
80005cbc:	0ffa0a13          	addi	s4,s4,255 # fffff0ff <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0xfffff100>
		block->id.block = block_num;
80005cc0:	fffa8a93          	addi	s5,s5,-1 # fff <CONFIG_ISR_STACK_SIZE+0x7ff>
	__asm__ volatile ("csrrc %0, mstatus, %1"
80005cc4:	00800d13          	li	s10,8
		if (ret == 0 || timeout == K_NO_WAIT ||
		    ret != -ENOMEM) {
			return ret;
		}

		z_pend_curr_unlocked(&p->wait_q, timeout);
80005cc8:	01498d93          	addi	s11,s3,20
			ret = z_sys_mem_pool_block_alloc(&p->base, size,
80005ccc:	00048713          	mv	a4,s1
80005cd0:	00c10693          	addi	a3,sp,12
80005cd4:	00810613          	addi	a2,sp,8
80005cd8:	000b0593          	mv	a1,s6
80005cdc:	00098513          	mv	a0,s3
80005ce0:	ef4fb0ef          	jal	ra,800013d4 <z_sys_mem_pool_block_alloc>
			if (ret != -EAGAIN) {
80005ce4:	03751263          	bne	a0,s7,80005d08 <k_mem_pool_alloc+0xd8>
			ret = z_sys_mem_pool_block_alloc(&p->base, size,
80005ce8:	00048713          	mv	a4,s1
80005cec:	00c10693          	addi	a3,sp,12
80005cf0:	00810613          	addi	a2,sp,8
80005cf4:	000b0593          	mv	a1,s6
80005cf8:	00098513          	mv	a0,s3
80005cfc:	ed8fb0ef          	jal	ra,800013d4 <z_sys_mem_pool_block_alloc>
			if (ret != -EAGAIN) {
80005d00:	01751463          	bne	a0,s7,80005d08 <k_mem_pool_alloc+0xd8>
			ret = -ENOMEM;
80005d04:	ff400513          	li	a0,-12
		block->id.level = level_num;
80005d08:	00812783          	lw	a5,8(sp)
		block->id.pool = pool_id(p);
80005d0c:	01848223          	sb	s8,4(s1)
		block->id.level = level_num;
80005d10:	00f7f793          	andi	a5,a5,15
80005d14:	00879713          	slli	a4,a5,0x8
80005d18:	0044a783          	lw	a5,4(s1)
80005d1c:	0147f7b3          	and	a5,a5,s4
80005d20:	00e7e7b3          	or	a5,a5,a4
		block->id.block = block_num;
80005d24:	00c12703          	lw	a4,12(sp)
80005d28:	0157f7b3          	and	a5,a5,s5
80005d2c:	00c71713          	slli	a4,a4,0xc
80005d30:	00e7e7b3          	or	a5,a5,a4
80005d34:	00f4a223          	sw	a5,4(s1)
		if (ret == 0 || timeout == K_NO_WAIT ||
80005d38:	02050c63          	beqz	a0,80005d70 <k_mem_pool_alloc+0x140>
80005d3c:	02040a63          	beqz	s0,80005d70 <k_mem_pool_alloc+0x140>
80005d40:	03951863          	bne	a0,s9,80005d70 <k_mem_pool_alloc+0x140>
80005d44:	300d3573          	csrrc	a0,mstatus,s10
	(void) z_pend_curr_irqlock(z_arch_irq_lock(), wait_q, timeout);
80005d48:	00040613          	mv	a2,s0
80005d4c:	000d8593          	mv	a1,s11
80005d50:	00857513          	andi	a0,a0,8
80005d54:	cc0fe0ef          	jal	ra,80004214 <z_pend_curr_irqlock>

		if (timeout != K_FOREVER) {
80005d58:	fff00793          	li	a5,-1
80005d5c:	f6f408e3          	beq	s0,a5,80005ccc <k_mem_pool_alloc+0x9c>
			timeout = end - z_tick_get();
80005d60:	b59ff0ef          	jal	ra,800058b8 <z_tick_get>
80005d64:	40a90433          	sub	s0,s2,a0

			if (timeout < 0) {
80005d68:	f60452e3          	bgez	s0,80005ccc <k_mem_pool_alloc+0x9c>
				break;
			}
		}
	}

	return -EAGAIN;
80005d6c:	ff500513          	li	a0,-11
}
80005d70:	04c12083          	lw	ra,76(sp)
80005d74:	04812403          	lw	s0,72(sp)
80005d78:	04412483          	lw	s1,68(sp)
80005d7c:	04012903          	lw	s2,64(sp)
80005d80:	03c12983          	lw	s3,60(sp)
80005d84:	03812a03          	lw	s4,56(sp)
80005d88:	03412a83          	lw	s5,52(sp)
80005d8c:	03012b03          	lw	s6,48(sp)
80005d90:	02c12b83          	lw	s7,44(sp)
80005d94:	02812c03          	lw	s8,40(sp)
80005d98:	02412c83          	lw	s9,36(sp)
80005d9c:	02012d03          	lw	s10,32(sp)
80005da0:	01c12d83          	lw	s11,28(sp)
80005da4:	05010113          	addi	sp,sp,80
80005da8:	00008067          	ret
	__ASSERT(!(z_is_in_isr() && timeout != K_NO_WAIT), "");
80005dac:	80007937          	lui	s2,0x80007
80005db0:	800075b7          	lui	a1,0x80007
80005db4:	80006537          	lui	a0,0x80006
80005db8:	d3058593          	addi	a1,a1,-720 # 80006d30 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006d31>
80005dbc:	03900693          	li	a3,57
80005dc0:	d1c90613          	addi	a2,s2,-740 # 80006d1c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006d1d>
80005dc4:	7dc50513          	addi	a0,a0,2012 # 800067dc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800067dd>
80005dc8:	aa8fc0ef          	jal	ra,80002070 <printk>
80005dcc:	80007537          	lui	a0,0x80007
80005dd0:	86050513          	addi	a0,a0,-1952 # 80006860 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006861>
80005dd4:	a9cfc0ef          	jal	ra,80002070 <printk>
80005dd8:	03900593          	li	a1,57
80005ddc:	d1c90513          	addi	a0,s2,-740
80005de0:	accfc0ef          	jal	ra,800020ac <assert_post_action>
	if (timeout > 0) {
80005de4:	ea8052e3          	blez	s0,80005c88 <k_mem_pool_alloc+0x58>
		end = z_tick_get() + z_ms_to_ticks(timeout);
80005de8:	ad1ff0ef          	jal	ra,800058b8 <z_tick_get>
80005dec:	00050913          	mv	s2,a0
	return (s32_t)ceiling_fraction(ms, ms_per_tick);
80005df0:	00a00593          	li	a1,10
80005df4:	00940513          	addi	a0,s0,9
80005df8:	b41fa0ef          	jal	ra,80000938 <__divsi3>
80005dfc:	01250933          	add	s2,a0,s2
80005e00:	e8dff06f          	j	80005c8c <k_mem_pool_alloc+0x5c>

80005e04 <k_mem_pool_free_id>:
void k_mem_pool_free_id(struct k_mem_block_id *id)
{
	int need_sched = 0;
	struct k_mem_pool *p = get_pool(id->pool);

	z_sys_mem_pool_block_free(&p->base, id->level, id->block);
80005e04:	00054783          	lbu	a5,0(a0)
{
80005e08:	fe010113          	addi	sp,sp,-32
	z_sys_mem_pool_block_free(&p->base, id->level, id->block);
80005e0c:	00052603          	lw	a2,0(a0)
{
80005e10:	00812c23          	sw	s0,24(sp)
80005e14:	00379413          	slli	s0,a5,0x3
80005e18:	01212823          	sw	s2,16(sp)
80005e1c:	40f40433          	sub	s0,s0,a5
	z_sys_mem_pool_block_free(&p->base, id->level, id->block);
80005e20:	80007937          	lui	s2,0x80007
80005e24:	00241413          	slli	s0,s0,0x2
80005e28:	00865593          	srli	a1,a2,0x8
80005e2c:	dd090513          	addi	a0,s2,-560 # 80006dd0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006dd1>
80005e30:	00c65613          	srli	a2,a2,0xc
80005e34:	00f5f593          	andi	a1,a1,15
80005e38:	00850533          	add	a0,a0,s0
{
80005e3c:	00112e23          	sw	ra,28(sp)
80005e40:	00912a23          	sw	s1,20(sp)
80005e44:	01312623          	sw	s3,12(sp)
80005e48:	01412423          	sw	s4,8(sp)
	z_sys_mem_pool_block_free(&p->base, id->level, id->block);
80005e4c:	869fb0ef          	jal	ra,800016b4 <z_sys_mem_pool_block_free>
80005e50:	00800593          	li	a1,8
80005e54:	3005b5f3          	csrrc	a1,mstatus,a1
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80005e58:	800074b7          	lui	s1,0x80007
80005e5c:	e6848513          	addi	a0,s1,-408 # 80006e68 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006e69>
	key = (mstatus & SOC_MSTATUS_IEN);
80005e60:	0085f993          	andi	s3,a1,8
80005e64:	d35fe0ef          	jal	ra,80004b98 <z_spin_lock_valid>
80005e68:	dd090913          	addi	s2,s2,-560
80005e6c:	02051e63          	bnez	a0,80005ea8 <k_mem_pool_free_id+0xa4>
80005e70:	80007a37          	lui	s4,0x80007
80005e74:	800075b7          	lui	a1,0x80007
80005e78:	80006537          	lui	a0,0x80006
80005e7c:	8c058593          	addi	a1,a1,-1856 # 800068c0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800068c1>
80005e80:	04e00693          	li	a3,78
80005e84:	8a8a0613          	addi	a2,s4,-1880 # 800068a8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800068a9>
80005e88:	7dc50513          	addi	a0,a0,2012 # 800067dc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800067dd>
80005e8c:	9e4fc0ef          	jal	ra,80002070 <printk>
80005e90:	80007537          	lui	a0,0x80007
80005e94:	8d850513          	addi	a0,a0,-1832 # 800068d8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800068d9>
80005e98:	9d8fc0ef          	jal	ra,80002070 <printk>
80005e9c:	04e00593          	li	a1,78
80005ea0:	8a8a0513          	addi	a0,s4,-1880
80005ea4:	a08fc0ef          	jal	ra,800020ac <assert_post_action>
	z_spin_lock_set_owner(l);
80005ea8:	e6848513          	addi	a0,s1,-408
80005eac:	d45fe0ef          	jal	ra,80004bf0 <z_spin_lock_set_owner>
	 * is unsynchronized.  Maybe we want to put the lock into the
	 * wait_q instead and make the API safe?)
	 */
	k_spinlock_key_t key = k_spin_lock(&lock);

	need_sched = z_unpend_all(&p->wait_q);
80005eb0:	01440513          	addi	a0,s0,20
80005eb4:	00a90533          	add	a0,s2,a0
80005eb8:	dccfe0ef          	jal	ra,80004484 <z_unpend_all>

	if (need_sched != 0) {
80005ebc:	02050663          	beqz	a0,80005ee8 <k_mem_pool_free_id+0xe4>
		z_reschedule(&lock, key);
	} else {
		k_spin_unlock(&lock, key);
	}
}
80005ec0:	01812403          	lw	s0,24(sp)
80005ec4:	01c12083          	lw	ra,28(sp)
80005ec8:	01012903          	lw	s2,16(sp)
80005ecc:	00812a03          	lw	s4,8(sp)
		z_reschedule(&lock, key);
80005ed0:	00098593          	mv	a1,s3
80005ed4:	e6848513          	addi	a0,s1,-408
}
80005ed8:	00c12983          	lw	s3,12(sp)
80005edc:	01412483          	lw	s1,20(sp)
80005ee0:	02010113          	addi	sp,sp,32
		z_reschedule(&lock, key);
80005ee4:	d9cfd06f          	j	80003480 <z_reschedule>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80005ee8:	e6848513          	addi	a0,s1,-408
80005eec:	cd5fe0ef          	jal	ra,80004bc0 <z_spin_unlock_valid>
80005ef0:	02051e63          	bnez	a0,80005f2c <k_mem_pool_free_id+0x128>
80005ef4:	80007437          	lui	s0,0x80007
80005ef8:	800075b7          	lui	a1,0x80007
80005efc:	80006537          	lui	a0,0x80006
80005f00:	8f058593          	addi	a1,a1,-1808 # 800068f0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800068f1>
80005f04:	06100693          	li	a3,97
80005f08:	8a840613          	addi	a2,s0,-1880 # 800068a8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800068a9>
80005f0c:	7dc50513          	addi	a0,a0,2012 # 800067dc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800067dd>
80005f10:	960fc0ef          	jal	ra,80002070 <printk>
80005f14:	80007537          	lui	a0,0x80007
80005f18:	90850513          	addi	a0,a0,-1784 # 80006908 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006909>
80005f1c:	954fc0ef          	jal	ra,80002070 <printk>
80005f20:	06100593          	li	a1,97
80005f24:	8a840513          	addi	a0,s0,-1880
80005f28:	984fc0ef          	jal	ra,800020ac <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80005f2c:	3009a5f3          	csrrs	a1,mstatus,s3
}
80005f30:	01c12083          	lw	ra,28(sp)
80005f34:	01812403          	lw	s0,24(sp)
80005f38:	01412483          	lw	s1,20(sp)
80005f3c:	01012903          	lw	s2,16(sp)
80005f40:	00c12983          	lw	s3,12(sp)
80005f44:	00812a03          	lw	s4,8(sp)
80005f48:	02010113          	addi	sp,sp,32
80005f4c:	00008067          	ret

80005f50 <k_mem_pool_malloc>:

	/*
	 * get a block large enough to hold an initial (hidden) block
	 * descriptor, as well as the space the caller requested
	 */
	if (__builtin_add_overflow(size, sizeof(struct k_mem_block_id),
80005f50:	00458613          	addi	a2,a1,4
80005f54:	00b67e63          	bgeu	a2,a1,80005f70 <k_mem_pool_malloc+0x20>
				   &size)) {
		return NULL;
80005f58:	00000513          	li	a0,0
	/* save the block descriptor info at the start of the actual block */
	(void)memcpy(block.data, &block.id, sizeof(struct k_mem_block_id));

	/* return address of the user area part of the block to the caller */
	return (char *)block.data + sizeof(struct k_mem_block_id);
}
80005f5c:	00008067          	ret
		return NULL;
80005f60:	00000513          	li	a0,0
}
80005f64:	01c12083          	lw	ra,28(sp)
80005f68:	02010113          	addi	sp,sp,32
80005f6c:	00008067          	ret
{
80005f70:	fe010113          	addi	sp,sp,-32
	if (k_mem_pool_alloc(pool, &block, size, K_NO_WAIT) != 0) {
80005f74:	00000693          	li	a3,0
80005f78:	00810593          	addi	a1,sp,8
{
80005f7c:	00112e23          	sw	ra,28(sp)
	if (k_mem_pool_alloc(pool, &block, size, K_NO_WAIT) != 0) {
80005f80:	cb1ff0ef          	jal	ra,80005c30 <k_mem_pool_alloc>
80005f84:	fc051ee3          	bnez	a0,80005f60 <k_mem_pool_malloc+0x10>
	(void)memcpy(block.data, &block.id, sizeof(struct k_mem_block_id));
80005f88:	00812503          	lw	a0,8(sp)
80005f8c:	00400613          	li	a2,4
80005f90:	00c10593          	addi	a1,sp,12
80005f94:	eb0fc0ef          	jal	ra,80002644 <memcpy>
	return (char *)block.data + sizeof(struct k_mem_block_id);
80005f98:	00812503          	lw	a0,8(sp)
80005f9c:	00450513          	addi	a0,a0,4
80005fa0:	fc5ff06f          	j	80005f64 <k_mem_pool_malloc+0x14>

80005fa4 <k_free>:

void k_free(void *ptr)
{
	if (ptr != NULL) {
80005fa4:	00050663          	beqz	a0,80005fb0 <k_free+0xc>
		/* point to hidden block descriptor at start of block */
		ptr = (char *)ptr - sizeof(struct k_mem_block_id);

		/* return block to the heap memory pool */
		k_mem_pool_free_id(ptr);
80005fa8:	ffc50513          	addi	a0,a0,-4
80005fac:	e59ff06f          	j	80005e04 <k_mem_pool_free_id>
	}
}
80005fb0:	00008067          	ret

80005fb4 <z_thread_malloc>:

void *z_thread_malloc(size_t size)
{
	void *ret;

	if (_current->resource_pool != NULL) {
80005fb4:	800077b7          	lui	a5,0x80007
80005fb8:	13c7a783          	lw	a5,316(a5) # 8000713c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000713d>
{
80005fbc:	00050593          	mv	a1,a0
	if (_current->resource_pool != NULL) {
80005fc0:	0687a503          	lw	a0,104(a5)
80005fc4:	00050463          	beqz	a0,80005fcc <z_thread_malloc+0x18>
		ret = k_mem_pool_malloc(_current->resource_pool, size);
80005fc8:	f89ff06f          	j	80005f50 <k_mem_pool_malloc>
	} else {
		ret = NULL;
	}

	return ret;
}
80005fcc:	00000513          	li	a0,0
80005fd0:	00008067          	ret

80005fd4 <_OffsetAbsSyms>:
 * point regs
 */
GEN_ABSOLUTE_SYM(_K_THREAD_NO_FLOAT_SIZEOF,
		 STACK_ROUND_UP(sizeof(struct k_thread)));

GEN_ABS_SYM_END
80005fd4:	00008067          	ret
