import * as iam from '@aws-cdk/aws-iam';
import * as sfn from '@aws-cdk/aws-stepfunctions';
import { Construct } from 'constructs';
/**
 * Properties for getting a Query Results.
 *
 * @stability stable
 */
export interface AthenaGetQueryResultsProps extends sfn.TaskStateBaseProps {
    /**
     * Query that will be retrieved.
     *
     * @stability stable
     * @example
     *
     * 'adfsaf-23trf23-f23rt23'
     */
    readonly queryExecutionId: string;
    /**
     * Pagination token.
     *
     * @default - No next token
     * @stability stable
     */
    readonly nextToken?: string;
    /**
     * Max number of results.
     *
     * @default 1000
     * @stability stable
     */
    readonly maxResults?: number;
}
/**
 * Get an Athena Query Results as a Task.
 *
 * @see https://docs.aws.amazon.com/step-functions/latest/dg/connect-athena.html
 * @stability stable
 */
export declare class AthenaGetQueryResults extends sfn.TaskStateBase {
    private readonly props;
    private static readonly SUPPORTED_INTEGRATION_PATTERNS;
    /**
     * @stability stable
     */
    protected readonly taskMetrics?: sfn.TaskMetricsConfig;
    /**
     * @stability stable
     */
    protected readonly taskPolicies?: iam.PolicyStatement[];
    private readonly integrationPattern;
    /**
     * @stability stable
     */
    constructor(scope: Construct, id: string, props: AthenaGetQueryResultsProps);
    /**
     * Provides the Athena get query results service integration task configuration
     * @internal
     */
    protected _renderTask(): any;
}
