# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['openapi_python_client',
 'openapi_python_client.openapi_parser',
 'openapi_python_client.templates']

package_data = \
{'': ['*'], 'openapi_python_client.templates': ['property_templates/*']}

install_requires = \
['black>=19.10b0,<20.0',
 'httpx>=0.13.0,<0.14.0',
 'isort>=4.3.21,<5.0.0',
 'jinja2>=2.11.1,<3.0.0',
 'pyyaml>=5.3.1,<6.0.0',
 'shellingham>=1.3.2,<2.0.0',
 'stringcase>=1.2.0,<2.0.0',
 'typer>=0.1,<0.3']

extras_require = \
{':sys_platform == "win32"': ['colorama>=0.4.3,<0.5.0']}

entry_points = \
{'console_scripts': ['openapi-python-client = openapi_python_client.cli:app']}

setup_kwargs = {
    'name': 'openapi-python-client',
    'version': '0.4.0',
    'description': 'Generate modern Python clients from OpenAPI',
    'long_description': '[![triaxtec](https://circleci.com/gh/triaxtec/openapi-python-client.svg?style=svg)](https://circleci.com/gh/triaxtec/openapi-python-client)\n[![codecov](https://codecov.io/gh/triaxtec/openapi-python-client/branch/master/graph/badge.svg)](https://codecov.io/gh/triaxtec/openapi-python-client)\n[![PyPI version shields.io](https://img.shields.io/pypi/v/openapi-python-client.svg)](https://pypi.python.org/pypi/openapi-python-client/)\n[![MIT license](https://img.shields.io/badge/License-MIT-blue.svg)](https://lbesson.mit-license.org/)\n[![Generic badge](https://img.shields.io/badge/type_checked-mypy-informational.svg)](https://mypy.readthedocs.io/en/stable/introduction.html)\n[![Code style: black](https://img.shields.io/badge/code%20style-black-000000.svg)](https://github.com/ambv/black)\n\n\n# openapi-python-client\nGenerate modern Python clients from OpenAPI\n\n**This project is still in early development and does not support all OpenAPI features**\n\n## Why This?\nThe Python clients generated by openapi-generator support Python 2 and therefore come with a lot of baggage. This tool \naims to generate clients which:\n1. Use all the latest and greatest Python features like type annotations and dataclasses\n1. Don\'t carry around a bunch of compatibility code for older version of Python (e.g. the `six` package)\n1. Have better documentation and more obvious usage instructions\n\nAdditionally, because this generator is written in Python, it should be more accessible to contribution by the people \nusing it (Python developers).\n\n## Installation\nI recommend you install with [pipx](https://pipxproject.github.io/pipx/)  so you don\'t conflict with any other packages \nyou might have: `pipx install openapi-python-client`.\n\nBetter yet, use `pipx run openapi-python-client <normal params / options>` to always use the latest version of the generator.\n\nYou can install with normal pip if you want to though: `pip install openapi-python-client`\n\nThen, if you want tab completion: `openapi-python-client --install-completion`\n\n## Usage\n### Create a new client\n`openapi-python-client generate --url https://my.api.com/openapi.json`\n\nThis will generate a new client library named based on the title in your OpenAPI spec.  For example, if the title \nof your API is "My API", the expected output will be "my-api-client".  If a folder already exists by that name, you\'ll \nget an error.\n\n### Update an existing client\n`openapi-python-client update --url https://my.api.com/openapi.json`\n\n> For more usage details run `openapi-python-client --help` or read [usage](usage.md)\n\n## What You Get\n1. A `pyproject.toml` file with some basic metadata intended to be used with [Poetry].\n1. A `README.md` you\'ll most definitely need to update with your project\'s details\n1. A Python module named just like the auto-generated project name (e.g. "my_api_client") which contains:\n    1. A `client` module which will have both a `Client` class and an `AuthenticatedClient` class.  You\'ll need these \n    for calling the functions in the `api` module.\n    1. An `api` module which will contain one module for each tag in your OpenAPI spec, as well as a `default` module \n    for endpoints without a tag.  Each of these modules in turn contains one function for calling each endpoint.\n    1. A `models` module which has all the classes defined by the various schemas in your OpenAPI spec\n    \nFor a full example you can look at the `test_end_to_end` directory which has a declared [FastAPI](https://fastapi.tiangolo.com/) \nserver and the resulting openapi.json file in the "fastapi" directory.  "golden-master" is the generated client from that \nOpenAPI document.\n    \n## OpenAPI features supported\n1. All HTTP Methods\n1. JSON and form bodies, path and query parameters\n1. File uploads with multipart/form-data bodies\n1. float, string, int, date, datetime, string enums, and custom schemas or lists containing any of those\n1. html/text or application/json responses containing any of the previous types\n1. Bearer token security\n\n## Configuration\nYou can pass a YAML (or JSON) file to openapi-python-client with the `--config` option in order to change some behavior.\nThe following parameters are supported:\n\n### class_overrides\nUsed to change the name of generated model classes.  This param should be a mapping of existing class name \n(usually a key in the "schemas" section of your OpenAPI document) to class_name and module_name. As an example, if the \nname of the a model in OpenAPI (and therefore the generated class name) was something like "_PrivateInternalLongName" \nand you want the generated client\'s model to be called "ShortName" in a module called "short_name" you could do this:\n\nExample:\n```yaml\nclass_overrides:\n    _PrivateInternalLongName:\n      class_name: ShortName\n      module_name: short_name\n```\n\nThe easiest way to find what needs to be overridden is probably to generate your client and go look at everything in the\n models folder.\n\n\n[CHANGELOG.md]: CHANGELOG.md\n[Poetry]: https://python-poetry.org/\n',
    'author': 'Dylan Anthony',
    'author_email': 'danthony@triaxtec.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/triaxtec/openapi-python-client',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'extras_require': extras_require,
    'entry_points': entry_points,
    'python_requires': '>=3.8.0,<4.0.0',
}


setup(**setup_kwargs)
