/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.jdbc.jdbc_4.util;

import java.math.BigInteger;

public class ByteConverter {
    public static boolean getBoolean(byte[] byArray, int n) {
        return byArray[n] != 0;
    }

    public static char getChar(byte[] byArray, int n) {
        return (char)(((byArray[n + 1] & 0xFF) << 0) + ((byArray[n + 0] & 0xFF) << 8));
    }

    public static short getShort(byte[] byArray, int n) {
        return (short)(((byArray[n + 1] & 0xFF) << 0) + ((byArray[n + 0] & 0xFF) << 8));
    }

    public static int getUnsignedShort(byte[] byArray, int n) {
        return ((byArray[n + 1] & 0xFF) << 0) + ((byArray[n + 0] & 0xFF) << 8);
    }

    public static int getInt(byte[] byArray, int n) {
        return ((byArray[n + 3] & 0xFF) << 0) + ((byArray[n + 2] & 0xFF) << 8) + ((byArray[n + 1] & 0xFF) << 16) + ((byArray[n + 0] & 0xFF) << 24);
    }

    public static float getFloat(byte[] byArray, int n) {
        int n2 = ((byArray[n + 3] & 0xFF) << 0) + ((byArray[n + 2] & 0xFF) << 8) + ((byArray[n + 1] & 0xFF) << 16) + ((byArray[n + 0] & 0xFF) << 24);
        return Float.intBitsToFloat(n2);
    }

    public static long getLong(byte[] byArray, int n) {
        return (((long)byArray[n + 7] & 0xFFL) << 0) + (((long)byArray[n + 6] & 0xFFL) << 8) + (((long)byArray[n + 5] & 0xFFL) << 16) + (((long)byArray[n + 4] & 0xFFL) << 24) + (((long)byArray[n + 3] & 0xFFL) << 32) + (((long)byArray[n + 2] & 0xFFL) << 40) + (((long)byArray[n + 1] & 0xFFL) << 48) + (((long)byArray[n + 0] & 0xFFL) << 56);
    }

    public static double getDouble(byte[] byArray, int n) {
        long l = (((long)byArray[n + 7] & 0xFFL) << 0) + (((long)byArray[n + 6] & 0xFFL) << 8) + (((long)byArray[n + 5] & 0xFFL) << 16) + (((long)byArray[n + 4] & 0xFFL) << 24) + (((long)byArray[n + 3] & 0xFFL) << 32) + (((long)byArray[n + 2] & 0xFFL) << 40) + (((long)byArray[n + 1] & 0xFFL) << 48) + (((long)byArray[n + 0] & 0xFFL) << 56);
        return Double.longBitsToDouble(l);
    }

    public static BigInteger get16ByteBigInteger(byte[] byArray, int n) {
        byte[] byArray2 = new byte[16];
        for (int i = 0; i < byArray2.length; ++i) {
            byArray2[i] = byArray[n + i];
        }
        return new BigInteger(byArray2);
    }

    public static void putBoolean(byte[] byArray, int n, boolean bl) {
        byArray[n] = (byte)(bl ? 1 : 0);
    }

    public static void putChar(byte[] byArray, int n, char c) {
        byArray[n + 1] = (byte)(c >>> 0);
        byArray[n + 0] = (byte)(c >>> 8);
    }

    public static void putShort(byte[] byArray, int n, short s) {
        byArray[n + 1] = (byte)(s >>> 0);
        byArray[n + 0] = (byte)(s >>> 8);
    }

    public static void putInt(byte[] byArray, int n, int n2) {
        byArray[n + 3] = (byte)(n2 >>> 0);
        byArray[n + 2] = (byte)(n2 >>> 8);
        byArray[n + 1] = (byte)(n2 >>> 16);
        byArray[n + 0] = (byte)(n2 >>> 24);
    }

    public static void putFloat(byte[] byArray, int n, float f) {
        int n2 = Float.floatToIntBits(f);
        byArray[n + 3] = (byte)(n2 >>> 0);
        byArray[n + 2] = (byte)(n2 >>> 8);
        byArray[n + 1] = (byte)(n2 >>> 16);
        byArray[n + 0] = (byte)(n2 >>> 24);
    }

    public static void putLong(byte[] byArray, int n, long l) {
        byArray[n + 7] = (byte)(l >>> 0);
        byArray[n + 6] = (byte)(l >>> 8);
        byArray[n + 5] = (byte)(l >>> 16);
        byArray[n + 4] = (byte)(l >>> 24);
        byArray[n + 3] = (byte)(l >>> 32);
        byArray[n + 2] = (byte)(l >>> 40);
        byArray[n + 1] = (byte)(l >>> 48);
        byArray[n + 0] = (byte)(l >>> 56);
    }

    public static void putDouble(byte[] byArray, int n, double d) {
        long l = Double.doubleToLongBits(d);
        byArray[n + 7] = (byte)(l >>> 0);
        byArray[n + 6] = (byte)(l >>> 8);
        byArray[n + 5] = (byte)(l >>> 16);
        byArray[n + 4] = (byte)(l >>> 24);
        byArray[n + 3] = (byte)(l >>> 32);
        byArray[n + 2] = (byte)(l >>> 40);
        byArray[n + 1] = (byte)(l >>> 48);
        byArray[n + 0] = (byte)(l >>> 56);
    }

    public static byte[] putBoolean(boolean bl) {
        byte[] byArray = new byte[1];
        ByteConverter.putBoolean(byArray, 0, bl);
        return byArray;
    }

    public static byte[] putByte(byte by) {
        byte[] byArray = new byte[]{by};
        return byArray;
    }

    public static byte[] putChar(char c) {
        byte[] byArray = new byte[2];
        ByteConverter.putChar(byArray, 0, c);
        return byArray;
    }

    public static byte[] putShort(short s) {
        byte[] byArray = new byte[2];
        ByteConverter.putShort(byArray, 0, s);
        return byArray;
    }

    public static byte[] putInt(int n) {
        byte[] byArray = new byte[4];
        ByteConverter.putInt(byArray, 0, n);
        return byArray;
    }

    public static byte[] putFloat(float f) {
        byte[] byArray = new byte[4];
        ByteConverter.putFloat(byArray, 0, f);
        return byArray;
    }

    public static byte[] putLong(long l) {
        byte[] byArray = new byte[8];
        ByteConverter.putLong(byArray, 0, l);
        return byArray;
    }

    public static byte[] putDouble(double d) {
        byte[] byArray = new byte[8];
        ByteConverter.putDouble(byArray, 0, d);
        return byArray;
    }

    public static byte[] copyByteArrayAddLengthPrefix(byte[] byArray) {
        if (byArray.length > 65535) {
            throw new IllegalArgumentException("abyOrig.length exceeds 0xFFFF");
        }
        byte[] byArray2 = new byte[byArray.length + 2];
        ByteConverter.putShort(byArray2, 0, (short)byArray.length);
        System.arraycopy(byArray, 0, byArray2, 2, byArray.length);
        return byArray2;
    }

    public static byte[] bigIntToByteArray(BigInteger bigInteger, int n) {
        byte[] byArray = new byte[n];
        ByteConverter.bigIntToByteArray(bigInteger, byArray, 0, n);
        return byArray;
    }

    public static void bigIntToByteArray(BigInteger bigInteger, byte[] byArray, int n) {
        ByteConverter.bigIntToByteArray(bigInteger, byArray, n, byArray.length - n);
    }

    public static void bigIntToByteArray(BigInteger bigInteger, byte[] byArray, int n, int n2) {
        byte[] byArray2 = bigInteger.toByteArray();
        int n3 = bigInteger.signum() == -1 ? -1 : 0;
        int n4 = byArray2.length - 1;
        for (int i = n + n2 - 1; i >= n; --i) {
            byArray[i] = n4 >= 0 ? byArray2[n4] : n3;
            --n4;
        }
    }
}

