"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.bundle = void 0;
const fs = require("fs");
const path = require("path");
const lambda = require("@aws-cdk/aws-lambda");
const cdk = require("@aws-cdk/core");
/**
 * Produce bundled Lambda asset code
 */
function bundle(options) {
    // Bundling image derived from runtime bundling image (AWS SAM docker image)
    const image = cdk.BundlingDockerImage.fromAsset(__dirname, {
        buildArgs: {
            IMAGE: options.runtime.bundlingDockerImage.image,
        },
    });
    let installer = options.runtime === lambda.Runtime.PYTHON_2_7 ? Installer.PIP : Installer.PIP3;
    let hasRequirements = fs.existsSync(path.join(options.entry, 'requirements.txt'));
    let depsCommand = chain([
        hasRequirements ? `${installer} install -r requirements.txt -t ${cdk.AssetStaging.BUNDLING_OUTPUT_DIR}` : '',
        `rsync -r . ${cdk.AssetStaging.BUNDLING_OUTPUT_DIR}`,
    ]);
    return lambda.Code.fromAsset(options.entry, {
        bundling: {
            image,
            command: ['bash', '-c', depsCommand],
        },
    });
}
exports.bundle = bundle;
var Installer;
(function (Installer) {
    Installer["PIP"] = "pip";
    Installer["PIP3"] = "pip3";
})(Installer || (Installer = {}));
function chain(commands) {
    return commands.filter(c => !!c).join(' && ');
}
//# sourceMappingURL=data:application/json;base64,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