# Generated File
import dataclasses
import struct
import typing

from retro_data_structures.game_check import Game
from retro_data_structures.properties.base_property import BaseProperty
import retro_data_structures.enums.prime as enums
from retro_data_structures.properties.prime.archetypes.BeamCombos import BeamCombos
from retro_data_structures.properties.prime.archetypes.ChargedBeams import ChargedBeams


@dataclasses.dataclass()
class DamageVulnerability(BaseProperty):
    power: enums.VulnerabilityType = dataclasses.field(default=enums.VulnerabilityType.DoubleDamage)
    ice: enums.VulnerabilityType = dataclasses.field(default=enums.VulnerabilityType.DoubleDamage)
    wave: enums.VulnerabilityType = dataclasses.field(default=enums.VulnerabilityType.DoubleDamage)
    plasma: enums.VulnerabilityType = dataclasses.field(default=enums.VulnerabilityType.DoubleDamage)
    bomb: enums.VulnerabilityType = dataclasses.field(default=enums.VulnerabilityType.DoubleDamage)
    power_bomb: enums.VulnerabilityType = dataclasses.field(default=enums.VulnerabilityType.DoubleDamage)
    missile: enums.VulnerabilityType = dataclasses.field(default=enums.VulnerabilityType.DoubleDamage)
    boost_ball: enums.VulnerabilityType = dataclasses.field(default=enums.VulnerabilityType.DoubleDamage)
    phazon: enums.VulnerabilityType = dataclasses.field(default=enums.VulnerabilityType.DoubleDamage)
    ai: enums.VulnerabilityType = dataclasses.field(default=enums.VulnerabilityType.DoubleDamage)
    poison_water: enums.VulnerabilityType = dataclasses.field(default=enums.VulnerabilityType.DoubleDamage)
    lava: enums.VulnerabilityType = dataclasses.field(default=enums.VulnerabilityType.DoubleDamage)
    hot: enums.VulnerabilityType = dataclasses.field(default=enums.VulnerabilityType.DoubleDamage)
    unused_weapon_1: enums.VulnerabilityType = dataclasses.field(default=enums.VulnerabilityType.DoubleDamage)
    unused_weapon_2: enums.VulnerabilityType = dataclasses.field(default=enums.VulnerabilityType.DoubleDamage)
    unused_weapon_3: enums.VulnerabilityType = dataclasses.field(default=enums.VulnerabilityType.DoubleDamage)
    unnamed_0x00000010: ChargedBeams = dataclasses.field(default_factory=ChargedBeams)
    unnamed_0x00000011: BeamCombos = dataclasses.field(default_factory=BeamCombos)

    @classmethod
    def game(cls) -> Game:
        return Game.PRIME

    @classmethod
    def from_stream(cls, data: typing.BinaryIO, size: typing.Optional[int] = None, default_override: typing.Optional[dict] = None):
        property_size = None  # Atomic
        power = enums.VulnerabilityType.from_stream(data)
        ice = enums.VulnerabilityType.from_stream(data)
        wave = enums.VulnerabilityType.from_stream(data)
        plasma = enums.VulnerabilityType.from_stream(data)
        bomb = enums.VulnerabilityType.from_stream(data)
        power_bomb = enums.VulnerabilityType.from_stream(data)
        missile = enums.VulnerabilityType.from_stream(data)
        boost_ball = enums.VulnerabilityType.from_stream(data)
        phazon = enums.VulnerabilityType.from_stream(data)
        ai = enums.VulnerabilityType.from_stream(data)
        poison_water = enums.VulnerabilityType.from_stream(data)
        lava = enums.VulnerabilityType.from_stream(data)
        hot = enums.VulnerabilityType.from_stream(data)
        unused_weapon_1 = enums.VulnerabilityType.from_stream(data)
        unused_weapon_2 = enums.VulnerabilityType.from_stream(data)
        unused_weapon_3 = enums.VulnerabilityType.from_stream(data)
        unnamed_0x00000010 = ChargedBeams.from_stream(data, property_size)
        unnamed_0x00000011 = BeamCombos.from_stream(data, property_size)
        return cls(power, ice, wave, plasma, bomb, power_bomb, missile, boost_ball, phazon, ai, poison_water, lava, hot, unused_weapon_1, unused_weapon_2, unused_weapon_3, unnamed_0x00000010, unnamed_0x00000011)

    def to_stream(self, data: typing.BinaryIO, default_override: typing.Optional[dict] = None):
        default_override = default_override or {}
        self.power.to_stream(data)
        self.ice.to_stream(data)
        self.wave.to_stream(data)
        self.plasma.to_stream(data)
        self.bomb.to_stream(data)
        self.power_bomb.to_stream(data)
        self.missile.to_stream(data)
        self.boost_ball.to_stream(data)
        self.phazon.to_stream(data)
        self.ai.to_stream(data)
        self.poison_water.to_stream(data)
        self.lava.to_stream(data)
        self.hot.to_stream(data)
        self.unused_weapon_1.to_stream(data)
        self.unused_weapon_2.to_stream(data)
        self.unused_weapon_3.to_stream(data)
        self.unnamed_0x00000010.to_stream(data)
        self.unnamed_0x00000011.to_stream(data)

    @classmethod
    def from_json(cls, data: dict):
        return cls(
            power=enums.VulnerabilityType.from_json(data['power']),
            ice=enums.VulnerabilityType.from_json(data['ice']),
            wave=enums.VulnerabilityType.from_json(data['wave']),
            plasma=enums.VulnerabilityType.from_json(data['plasma']),
            bomb=enums.VulnerabilityType.from_json(data['bomb']),
            power_bomb=enums.VulnerabilityType.from_json(data['power_bomb']),
            missile=enums.VulnerabilityType.from_json(data['missile']),
            boost_ball=enums.VulnerabilityType.from_json(data['boost_ball']),
            phazon=enums.VulnerabilityType.from_json(data['phazon']),
            ai=enums.VulnerabilityType.from_json(data['ai']),
            poison_water=enums.VulnerabilityType.from_json(data['poison_water']),
            lava=enums.VulnerabilityType.from_json(data['lava']),
            hot=enums.VulnerabilityType.from_json(data['hot']),
            unused_weapon_1=enums.VulnerabilityType.from_json(data['unused_weapon_1']),
            unused_weapon_2=enums.VulnerabilityType.from_json(data['unused_weapon_2']),
            unused_weapon_3=enums.VulnerabilityType.from_json(data['unused_weapon_3']),
            unnamed_0x00000010=ChargedBeams.from_json(data['unnamed_0x00000010']),
            unnamed_0x00000011=BeamCombos.from_json(data['unnamed_0x00000011']),
        )

    def to_json(self) -> dict:
        return {
            'power': self.power.to_json(),
            'ice': self.ice.to_json(),
            'wave': self.wave.to_json(),
            'plasma': self.plasma.to_json(),
            'bomb': self.bomb.to_json(),
            'power_bomb': self.power_bomb.to_json(),
            'missile': self.missile.to_json(),
            'boost_ball': self.boost_ball.to_json(),
            'phazon': self.phazon.to_json(),
            'ai': self.ai.to_json(),
            'poison_water': self.poison_water.to_json(),
            'lava': self.lava.to_json(),
            'hot': self.hot.to_json(),
            'unused_weapon_1': self.unused_weapon_1.to_json(),
            'unused_weapon_2': self.unused_weapon_2.to_json(),
            'unused_weapon_3': self.unused_weapon_3.to_json(),
            'unnamed_0x00000010': self.unnamed_0x00000010.to_json(),
            'unnamed_0x00000011': self.unnamed_0x00000011.to_json(),
        }
