# Generated File
import dataclasses
import struct
import typing

from retro_data_structures.game_check import Game
from retro_data_structures.properties.base_property import BaseProperty
from retro_data_structures.properties.echoes.core.Color import Color


@dataclasses.dataclass()
class VulnerabilityIndicator(BaseProperty):
    indicator_angle: float = dataclasses.field(default=0.0)
    indicator_color: Color = dataclasses.field(default_factory=lambda: Color(r=0.0, g=0.0, b=0.0, a=0.0))

    @classmethod
    def game(cls) -> Game:
        return Game.ECHOES

    @classmethod
    def from_stream(cls, data: typing.BinaryIO, size: typing.Optional[int] = None, default_override: typing.Optional[dict] = None):
        property_count = struct.unpack(">H", data.read(2))[0]
        present_fields = default_override or {}
        for _ in range(property_count):
            property_id, property_size = struct.unpack(">LH", data.read(6))
            start = data.tell()
            try:
                property_name, decoder = _property_decoder[property_id]
                present_fields[property_name] = decoder(data, property_size)
            except KeyError:
                data.read(property_size)  # skip unknown property
            assert data.tell() - start == property_size

        return cls(**present_fields)

    def to_stream(self, data: typing.BinaryIO, default_override: typing.Optional[dict] = None):
        default_override = default_override or {}
        data.write(b'\x00\x02')  # 2 properties

        data.write(b'L\x86\xafB')  # 0x4c86af42
        data.write(b'\x00\x04')  # size
        data.write(struct.pack('>f', self.indicator_angle))

        data.write(b'Ckf\xac')  # 0x436b66ac
        data.write(b'\x00\x10')  # size
        self.indicator_color.to_stream(data)

    @classmethod
    def from_json(cls, data: dict):
        return cls(
            indicator_angle=data['indicator_angle'],
            indicator_color=Color.from_json(data['indicator_color']),
        )

    def to_json(self) -> dict:
        return {
            'indicator_angle': self.indicator_angle,
            'indicator_color': self.indicator_color.to_json(),
        }


def _decode_indicator_angle(data: typing.BinaryIO, property_size: int):
    return struct.unpack('>f', data.read(4))[0]


def _decode_indicator_color(data: typing.BinaryIO, property_size: int):
    return Color.from_stream(data)


_property_decoder: typing.Dict[int, typing.Tuple[str, typing.Callable[[typing.BinaryIO, int], typing.Any]]] = {
    0x4c86af42: ('indicator_angle', _decode_indicator_angle),
    0x436b66ac: ('indicator_color', _decode_indicator_color),
}
