# Generated File
import dataclasses
import struct
import typing

from retro_data_structures.game_check import Game
from retro_data_structures.properties.base_property import BaseProperty


@dataclasses.dataclass()
class DamageVulnerability(BaseProperty):
    unknown_0xad373af2: float = dataclasses.field(default=2.0)
    unknown_0x6bec3998: float = dataclasses.field(default=0.0)
    unknown_0x44337a05: float = dataclasses.field(default=0.0)
    unknown_0x10f37815: int = dataclasses.field(default=524288)
    unknown_0xf65feef8: int = dataclasses.field(default=524288)

    @classmethod
    def game(cls) -> Game:
        return Game.DKCRETURNS

    @classmethod
    def from_stream(cls, data: typing.BinaryIO, size: typing.Optional[int] = None, default_override: typing.Optional[dict] = None):
        property_count = struct.unpack(">H", data.read(2))[0]
        if default_override is None and (result := _fast_decode(data, property_count)) is not None:
            return result

        present_fields = default_override or {}
        for _ in range(property_count):
            property_id, property_size = struct.unpack(">LH", data.read(6))
            start = data.tell()
            try:
                property_name, decoder = _property_decoder[property_id]
                present_fields[property_name] = decoder(data, property_size)
            except KeyError:
                data.read(property_size)  # skip unknown property
            assert data.tell() - start == property_size

        return cls(**present_fields)

    def to_stream(self, data: typing.BinaryIO, default_override: typing.Optional[dict] = None):
        default_override = default_override or {}
        data.write(b'\x00\x05')  # 5 properties

        data.write(b'\xad7:\xf2')  # 0xad373af2
        data.write(b'\x00\x04')  # size
        data.write(struct.pack('>f', self.unknown_0xad373af2))

        data.write(b'k\xec9\x98')  # 0x6bec3998
        data.write(b'\x00\x04')  # size
        data.write(struct.pack('>f', self.unknown_0x6bec3998))

        data.write(b'D3z\x05')  # 0x44337a05
        data.write(b'\x00\x04')  # size
        data.write(struct.pack('>f', self.unknown_0x44337a05))

        data.write(b'\x10\xf3x\x15')  # 0x10f37815
        data.write(b'\x00\x04')  # size
        data.write(struct.pack('>l', self.unknown_0x10f37815))

        data.write(b'\xf6_\xee\xf8')  # 0xf65feef8
        data.write(b'\x00\x04')  # size
        data.write(struct.pack('>l', self.unknown_0xf65feef8))

    @classmethod
    def from_json(cls, data: dict):
        return cls(
            unknown_0xad373af2=data['unknown_0xad373af2'],
            unknown_0x6bec3998=data['unknown_0x6bec3998'],
            unknown_0x44337a05=data['unknown_0x44337a05'],
            unknown_0x10f37815=data['unknown_0x10f37815'],
            unknown_0xf65feef8=data['unknown_0xf65feef8'],
        )

    def to_json(self) -> dict:
        return {
            'unknown_0xad373af2': self.unknown_0xad373af2,
            'unknown_0x6bec3998': self.unknown_0x6bec3998,
            'unknown_0x44337a05': self.unknown_0x44337a05,
            'unknown_0x10f37815': self.unknown_0x10f37815,
            'unknown_0xf65feef8': self.unknown_0xf65feef8,
        }


_FAST_FORMAT = None
_FAST_IDS = (0xad373af2, 0x6bec3998, 0x44337a05, 0x10f37815, 0xf65feef8)


def _fast_decode(data: typing.BinaryIO, property_count: int) -> typing.Optional[DamageVulnerability]:
    if property_count != 5:
        return None

    global _FAST_FORMAT
    if _FAST_FORMAT is None:
        _FAST_FORMAT = struct.Struct('>LHfLHfLHfLHlLHl')

    dec = _FAST_FORMAT.unpack(data.read(50))
    if (dec[0], dec[3], dec[6], dec[9], dec[12]) != _FAST_IDS:
        return None

    return DamageVulnerability(
        dec[2],
        dec[5],
        dec[8],
        dec[11],
        dec[14],
    )


def _decode_unknown_0xad373af2(data: typing.BinaryIO, property_size: int):
    return struct.unpack('>f', data.read(4))[0]


def _decode_unknown_0x6bec3998(data: typing.BinaryIO, property_size: int):
    return struct.unpack('>f', data.read(4))[0]


def _decode_unknown_0x44337a05(data: typing.BinaryIO, property_size: int):
    return struct.unpack('>f', data.read(4))[0]


def _decode_unknown_0x10f37815(data: typing.BinaryIO, property_size: int):
    return struct.unpack('>l', data.read(4))[0]


def _decode_unknown_0xf65feef8(data: typing.BinaryIO, property_size: int):
    return struct.unpack('>l', data.read(4))[0]


_property_decoder: typing.Dict[int, typing.Tuple[str, typing.Callable[[typing.BinaryIO, int], typing.Any]]] = {
    0xad373af2: ('unknown_0xad373af2', _decode_unknown_0xad373af2),
    0x6bec3998: ('unknown_0x6bec3998', _decode_unknown_0x6bec3998),
    0x44337a05: ('unknown_0x44337a05', _decode_unknown_0x44337a05),
    0x10f37815: ('unknown_0x10f37815', _decode_unknown_0x10f37815),
    0xf65feef8: ('unknown_0xf65feef8', _decode_unknown_0xf65feef8),
}
