/*********************************************************************************************************************
 Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.

 Licensed under the Apache License, Version 2.0 (the "License").
 You may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 ******************************************************************************************************************** */
import type { OpenAPIV3 } from "openapi-types";
import { ApiGatewayIntegration } from "../integrations";
import type { MethodAndPath, OperationLookup } from "../spec";
import { SerialisedAuthorizerReference } from "../spec/api-gateway-auth";
/**
 * Serialise a method and path into a single string
 */
export declare const concatMethodAndPath: ({ method, path }: MethodAndPath) => string;
/**
 * Serialized integration for a method
 */
export interface SerializedMethodIntegration {
    /**
     * The lambda function invocation uri for the api method
     */
    readonly integration: ApiGatewayIntegration;
    /**
     * The authorizer (if any) to apply to the method
     */
    readonly methodAuthorizer?: SerialisedAuthorizerReference;
}
/**
 * Cross-origin resource sharing options
 */
export interface SerializedCorsOptions {
    /**
     * HTTP methods to allow
     */
    readonly allowMethods: string[];
    /**
     * Headers to allow
     */
    readonly allowHeaders: string[];
    /**
     * Origins to allow
     */
    readonly allowOrigins: string[];
    /**
     * HTTP status code to be returned by preflight requests
     */
    readonly statusCode: number;
}
/**
 * Options for preparing an api spec for deployment by api gateway
 */
export interface PrepareApiSpecOptions {
    /**
     * Integrations for api operations
     */
    readonly integrations: {
        [operationId: string]: SerializedMethodIntegration;
    };
    /**
     * Options for cross-origin resource sharing
     */
    readonly corsOptions?: SerializedCorsOptions;
    /**
     * Operation id to method and path mapping
     */
    readonly operationLookup: OperationLookup;
    /**
     * Security schemes to add to the spec
     */
    readonly securitySchemes: {
        [key: string]: OpenAPIV3.SecuritySchemeObject;
    };
    /**
     * The default authorizer to reference
     */
    readonly defaultAuthorizerReference?: SerialisedAuthorizerReference;
}
/**
 * Prepares the api spec for deployment by adding integrations, configuring auth, etc
 */
export declare const prepareApiSpec: (spec: OpenAPIV3.Document, options: PrepareApiSpecOptions) => OpenAPIV3.Document;
