# -*- coding: utf-8 -*-
# This file is auto-generated, don't edit it. Thanks.
from Tea.model import TeaModel
from typing import Dict, List, Any


class AcceptInquiredSystemEventRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        owner_account: str = None,
        region_id: str = None,
        event_id: str = None,
        choice: str = None,
    ):
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.owner_account = owner_account
        self.region_id = region_id
        self.event_id = event_id
        self.choice = choice

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.event_id is not None:
            result['EventId'] = self.event_id
        if self.choice is not None:
            result['Choice'] = self.choice
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('EventId') is not None:
            self.event_id = m.get('EventId')
        if m.get('Choice') is not None:
            self.choice = m.get('Choice')
        return self


class AcceptInquiredSystemEventResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class AcceptInquiredSystemEventResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: AcceptInquiredSystemEventResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = AcceptInquiredSystemEventResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ActivateRouterInterfaceRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        region_id: str = None,
        router_interface_id: str = None,
    ):
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.region_id = region_id
        self.router_interface_id = router_interface_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.router_interface_id is not None:
            result['RouterInterfaceId'] = self.router_interface_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('RouterInterfaceId') is not None:
            self.router_interface_id = m.get('RouterInterfaceId')
        return self


class ActivateRouterInterfaceResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ActivateRouterInterfaceResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ActivateRouterInterfaceResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ActivateRouterInterfaceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AddBandwidthPackageIpsRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        owner_account: str = None,
        region_id: str = None,
        bandwidth_package_id: str = None,
        ip_count: str = None,
        client_token: str = None,
    ):
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.owner_account = owner_account
        self.region_id = region_id
        self.bandwidth_package_id = bandwidth_package_id
        self.ip_count = ip_count
        self.client_token = client_token

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.bandwidth_package_id is not None:
            result['BandwidthPackageId'] = self.bandwidth_package_id
        if self.ip_count is not None:
            result['IpCount'] = self.ip_count
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('BandwidthPackageId') is not None:
            self.bandwidth_package_id = m.get('BandwidthPackageId')
        if m.get('IpCount') is not None:
            self.ip_count = m.get('IpCount')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        return self


class AddBandwidthPackageIpsResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class AddBandwidthPackageIpsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: AddBandwidthPackageIpsResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = AddBandwidthPackageIpsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AddTagsRequestTag(TeaModel):
    def __init__(
        self,
        key: str = None,
        value: str = None,
    ):
        self.key = key
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('key') is not None:
            self.key = m.get('key')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class AddTagsRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        region_id: str = None,
        resource_type: str = None,
        resource_id: str = None,
        tag: List[AddTagsRequestTag] = None,
    ):
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.region_id = region_id
        self.resource_type = resource_type
        self.resource_id = resource_id
        self.tag = tag

    def validate(self):
        if self.tag:
            for k in self.tag:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_type is not None:
            result['ResourceType'] = self.resource_type
        if self.resource_id is not None:
            result['ResourceId'] = self.resource_id
        result['Tag'] = []
        if self.tag is not None:
            for k in self.tag:
                result['Tag'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceType') is not None:
            self.resource_type = m.get('ResourceType')
        if m.get('ResourceId') is not None:
            self.resource_id = m.get('ResourceId')
        self.tag = []
        if m.get('Tag') is not None:
            for k in m.get('Tag'):
                temp_model = AddTagsRequestTag()
                self.tag.append(temp_model.from_map(k))
        return self


class AddTagsResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class AddTagsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: AddTagsResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = AddTagsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AllocateDedicatedHostsRequestNetworkAttributes(TeaModel):
    def __init__(
        self,
        slb_udp_timeout: int = None,
        udp_timeout: int = None,
    ):
        self.slb_udp_timeout = slb_udp_timeout
        self.udp_timeout = udp_timeout

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.slb_udp_timeout is not None:
            result['SlbUdpTimeout'] = self.slb_udp_timeout
        if self.udp_timeout is not None:
            result['UdpTimeout'] = self.udp_timeout
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('SlbUdpTimeout') is not None:
            self.slb_udp_timeout = m.get('SlbUdpTimeout')
        if m.get('UdpTimeout') is not None:
            self.udp_timeout = m.get('UdpTimeout')
        return self


class AllocateDedicatedHostsRequestTag(TeaModel):
    def __init__(
        self,
        key: str = None,
        value: str = None,
    ):
        self.key = key
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class AllocateDedicatedHostsRequest(TeaModel):
    def __init__(
        self,
        network_attributes: AllocateDedicatedHostsRequestNetworkAttributes = None,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        owner_account: str = None,
        region_id: str = None,
        tag: List[AllocateDedicatedHostsRequestTag] = None,
        resource_group_id: str = None,
        zone_id: str = None,
        dedicated_host_name: str = None,
        dedicated_host_cluster_id: str = None,
        dedicated_host_type: str = None,
        action_on_maintenance: str = None,
        description: str = None,
        auto_placement: str = None,
        cpu_over_commit_ratio: float = None,
        min_quantity: int = None,
        charge_type: str = None,
        quantity: int = None,
        period: int = None,
        period_unit: str = None,
        auto_renew: bool = None,
        auto_renew_period: int = None,
        auto_release_time: str = None,
        client_token: str = None,
    ):
        self.network_attributes = network_attributes
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.owner_account = owner_account
        self.region_id = region_id
        self.tag = tag
        self.resource_group_id = resource_group_id
        self.zone_id = zone_id
        self.dedicated_host_name = dedicated_host_name
        self.dedicated_host_cluster_id = dedicated_host_cluster_id
        self.dedicated_host_type = dedicated_host_type
        self.action_on_maintenance = action_on_maintenance
        self.description = description
        self.auto_placement = auto_placement
        self.cpu_over_commit_ratio = cpu_over_commit_ratio
        self.min_quantity = min_quantity
        self.charge_type = charge_type
        self.quantity = quantity
        self.period = period
        self.period_unit = period_unit
        self.auto_renew = auto_renew
        self.auto_renew_period = auto_renew_period
        self.auto_release_time = auto_release_time
        self.client_token = client_token

    def validate(self):
        if self.network_attributes:
            self.network_attributes.validate()
        if self.tag:
            for k in self.tag:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.network_attributes is not None:
            result['NetworkAttributes'] = self.network_attributes.to_map()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        result['Tag'] = []
        if self.tag is not None:
            for k in self.tag:
                result['Tag'].append(k.to_map() if k else None)
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.zone_id is not None:
            result['ZoneId'] = self.zone_id
        if self.dedicated_host_name is not None:
            result['DedicatedHostName'] = self.dedicated_host_name
        if self.dedicated_host_cluster_id is not None:
            result['DedicatedHostClusterId'] = self.dedicated_host_cluster_id
        if self.dedicated_host_type is not None:
            result['DedicatedHostType'] = self.dedicated_host_type
        if self.action_on_maintenance is not None:
            result['ActionOnMaintenance'] = self.action_on_maintenance
        if self.description is not None:
            result['Description'] = self.description
        if self.auto_placement is not None:
            result['AutoPlacement'] = self.auto_placement
        if self.cpu_over_commit_ratio is not None:
            result['CpuOverCommitRatio'] = self.cpu_over_commit_ratio
        if self.min_quantity is not None:
            result['MinQuantity'] = self.min_quantity
        if self.charge_type is not None:
            result['ChargeType'] = self.charge_type
        if self.quantity is not None:
            result['Quantity'] = self.quantity
        if self.period is not None:
            result['Period'] = self.period
        if self.period_unit is not None:
            result['PeriodUnit'] = self.period_unit
        if self.auto_renew is not None:
            result['AutoRenew'] = self.auto_renew
        if self.auto_renew_period is not None:
            result['AutoRenewPeriod'] = self.auto_renew_period
        if self.auto_release_time is not None:
            result['AutoReleaseTime'] = self.auto_release_time
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('NetworkAttributes') is not None:
            temp_model = AllocateDedicatedHostsRequestNetworkAttributes()
            self.network_attributes = temp_model.from_map(m['NetworkAttributes'])
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        self.tag = []
        if m.get('Tag') is not None:
            for k in m.get('Tag'):
                temp_model = AllocateDedicatedHostsRequestTag()
                self.tag.append(temp_model.from_map(k))
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        if m.get('ZoneId') is not None:
            self.zone_id = m.get('ZoneId')
        if m.get('DedicatedHostName') is not None:
            self.dedicated_host_name = m.get('DedicatedHostName')
        if m.get('DedicatedHostClusterId') is not None:
            self.dedicated_host_cluster_id = m.get('DedicatedHostClusterId')
        if m.get('DedicatedHostType') is not None:
            self.dedicated_host_type = m.get('DedicatedHostType')
        if m.get('ActionOnMaintenance') is not None:
            self.action_on_maintenance = m.get('ActionOnMaintenance')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('AutoPlacement') is not None:
            self.auto_placement = m.get('AutoPlacement')
        if m.get('CpuOverCommitRatio') is not None:
            self.cpu_over_commit_ratio = m.get('CpuOverCommitRatio')
        if m.get('MinQuantity') is not None:
            self.min_quantity = m.get('MinQuantity')
        if m.get('ChargeType') is not None:
            self.charge_type = m.get('ChargeType')
        if m.get('Quantity') is not None:
            self.quantity = m.get('Quantity')
        if m.get('Period') is not None:
            self.period = m.get('Period')
        if m.get('PeriodUnit') is not None:
            self.period_unit = m.get('PeriodUnit')
        if m.get('AutoRenew') is not None:
            self.auto_renew = m.get('AutoRenew')
        if m.get('AutoRenewPeriod') is not None:
            self.auto_renew_period = m.get('AutoRenewPeriod')
        if m.get('AutoReleaseTime') is not None:
            self.auto_release_time = m.get('AutoReleaseTime')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        return self


class AllocateDedicatedHostsResponseBodyDedicatedHostIdSets(TeaModel):
    def __init__(
        self,
        dedicated_host_id: List[str] = None,
    ):
        self.dedicated_host_id = dedicated_host_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dedicated_host_id is not None:
            result['DedicatedHostId'] = self.dedicated_host_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DedicatedHostId') is not None:
            self.dedicated_host_id = m.get('DedicatedHostId')
        return self


class AllocateDedicatedHostsResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        dedicated_host_id_sets: AllocateDedicatedHostsResponseBodyDedicatedHostIdSets = None,
    ):
        self.request_id = request_id
        self.dedicated_host_id_sets = dedicated_host_id_sets

    def validate(self):
        if self.dedicated_host_id_sets:
            self.dedicated_host_id_sets.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.dedicated_host_id_sets is not None:
            result['DedicatedHostIdSets'] = self.dedicated_host_id_sets.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('DedicatedHostIdSets') is not None:
            temp_model = AllocateDedicatedHostsResponseBodyDedicatedHostIdSets()
            self.dedicated_host_id_sets = temp_model.from_map(m['DedicatedHostIdSets'])
        return self


class AllocateDedicatedHostsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: AllocateDedicatedHostsResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = AllocateDedicatedHostsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AllocateEipAddressRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        region_id: str = None,
        bandwidth: str = None,
        isp: str = None,
        internet_charge_type: str = None,
        activity_id: int = None,
        owner_account: str = None,
        client_token: str = None,
    ):
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.region_id = region_id
        self.bandwidth = bandwidth
        self.isp = isp
        self.internet_charge_type = internet_charge_type
        self.activity_id = activity_id
        self.owner_account = owner_account
        self.client_token = client_token

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.bandwidth is not None:
            result['Bandwidth'] = self.bandwidth
        if self.isp is not None:
            result['ISP'] = self.isp
        if self.internet_charge_type is not None:
            result['InternetChargeType'] = self.internet_charge_type
        if self.activity_id is not None:
            result['ActivityId'] = self.activity_id
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('Bandwidth') is not None:
            self.bandwidth = m.get('Bandwidth')
        if m.get('ISP') is not None:
            self.isp = m.get('ISP')
        if m.get('InternetChargeType') is not None:
            self.internet_charge_type = m.get('InternetChargeType')
        if m.get('ActivityId') is not None:
            self.activity_id = m.get('ActivityId')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        return self


class AllocateEipAddressResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        allocation_id: str = None,
        eip_address: str = None,
    ):
        self.request_id = request_id
        self.allocation_id = allocation_id
        self.eip_address = eip_address

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.allocation_id is not None:
            result['AllocationId'] = self.allocation_id
        if self.eip_address is not None:
            result['EipAddress'] = self.eip_address
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('AllocationId') is not None:
            self.allocation_id = m.get('AllocationId')
        if m.get('EipAddress') is not None:
            self.eip_address = m.get('EipAddress')
        return self


class AllocateEipAddressResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: AllocateEipAddressResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = AllocateEipAddressResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AllocatePublicIpAddressRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        instance_id: str = None,
        ip_address: str = None,
        vlan_id: str = None,
        owner_account: str = None,
    ):
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.instance_id = instance_id
        self.ip_address = ip_address
        self.vlan_id = vlan_id
        self.owner_account = owner_account

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.ip_address is not None:
            result['IpAddress'] = self.ip_address
        if self.vlan_id is not None:
            result['VlanId'] = self.vlan_id
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('IpAddress') is not None:
            self.ip_address = m.get('IpAddress')
        if m.get('VlanId') is not None:
            self.vlan_id = m.get('VlanId')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        return self


class AllocatePublicIpAddressResponseBody(TeaModel):
    def __init__(
        self,
        ip_address: str = None,
        request_id: str = None,
    ):
        self.ip_address = ip_address
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ip_address is not None:
            result['IpAddress'] = self.ip_address
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IpAddress') is not None:
            self.ip_address = m.get('IpAddress')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class AllocatePublicIpAddressResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: AllocatePublicIpAddressResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = AllocatePublicIpAddressResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ApplyAutoSnapshotPolicyRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        region_id: str = None,
        auto_snapshot_policy_id: str = None,
        disk_ids: str = None,
    ):
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.region_id = region_id
        self.auto_snapshot_policy_id = auto_snapshot_policy_id
        self.disk_ids = disk_ids

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['regionId'] = self.region_id
        if self.auto_snapshot_policy_id is not None:
            result['autoSnapshotPolicyId'] = self.auto_snapshot_policy_id
        if self.disk_ids is not None:
            result['diskIds'] = self.disk_ids
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('regionId') is not None:
            self.region_id = m.get('regionId')
        if m.get('autoSnapshotPolicyId') is not None:
            self.auto_snapshot_policy_id = m.get('autoSnapshotPolicyId')
        if m.get('diskIds') is not None:
            self.disk_ids = m.get('diskIds')
        return self


class ApplyAutoSnapshotPolicyResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ApplyAutoSnapshotPolicyResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ApplyAutoSnapshotPolicyResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ApplyAutoSnapshotPolicyResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AssignIpv6AddressesRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        owner_account: str = None,
        region_id: str = None,
        network_interface_id: str = None,
        ipv_6address_count: int = None,
        ipv_6address: List[str] = None,
    ):
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.owner_account = owner_account
        self.region_id = region_id
        self.network_interface_id = network_interface_id
        self.ipv_6address_count = ipv_6address_count
        self.ipv_6address = ipv_6address

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.network_interface_id is not None:
            result['NetworkInterfaceId'] = self.network_interface_id
        if self.ipv_6address_count is not None:
            result['Ipv6AddressCount'] = self.ipv_6address_count
        if self.ipv_6address is not None:
            result['Ipv6Address'] = self.ipv_6address
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('NetworkInterfaceId') is not None:
            self.network_interface_id = m.get('NetworkInterfaceId')
        if m.get('Ipv6AddressCount') is not None:
            self.ipv_6address_count = m.get('Ipv6AddressCount')
        if m.get('Ipv6Address') is not None:
            self.ipv_6address = m.get('Ipv6Address')
        return self


class AssignIpv6AddressesResponseBodyIpv6Sets(TeaModel):
    def __init__(
        self,
        ipv_6address: List[str] = None,
    ):
        self.ipv_6address = ipv_6address

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ipv_6address is not None:
            result['Ipv6Address'] = self.ipv_6address
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Ipv6Address') is not None:
            self.ipv_6address = m.get('Ipv6Address')
        return self


class AssignIpv6AddressesResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        network_interface_id: str = None,
        ipv_6sets: AssignIpv6AddressesResponseBodyIpv6Sets = None,
    ):
        self.request_id = request_id
        self.network_interface_id = network_interface_id
        self.ipv_6sets = ipv_6sets

    def validate(self):
        if self.ipv_6sets:
            self.ipv_6sets.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.network_interface_id is not None:
            result['NetworkInterfaceId'] = self.network_interface_id
        if self.ipv_6sets is not None:
            result['Ipv6Sets'] = self.ipv_6sets.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('NetworkInterfaceId') is not None:
            self.network_interface_id = m.get('NetworkInterfaceId')
        if m.get('Ipv6Sets') is not None:
            temp_model = AssignIpv6AddressesResponseBodyIpv6Sets()
            self.ipv_6sets = temp_model.from_map(m['Ipv6Sets'])
        return self


class AssignIpv6AddressesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: AssignIpv6AddressesResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = AssignIpv6AddressesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AssignPrivateIpAddressesRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        owner_account: str = None,
        region_id: str = None,
        network_interface_id: str = None,
        secondary_private_ip_address_count: int = None,
        client_token: str = None,
        private_ip_address: List[str] = None,
    ):
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.owner_account = owner_account
        self.region_id = region_id
        self.network_interface_id = network_interface_id
        self.secondary_private_ip_address_count = secondary_private_ip_address_count
        self.client_token = client_token
        self.private_ip_address = private_ip_address

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.network_interface_id is not None:
            result['NetworkInterfaceId'] = self.network_interface_id
        if self.secondary_private_ip_address_count is not None:
            result['SecondaryPrivateIpAddressCount'] = self.secondary_private_ip_address_count
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.private_ip_address is not None:
            result['PrivateIpAddress'] = self.private_ip_address
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('NetworkInterfaceId') is not None:
            self.network_interface_id = m.get('NetworkInterfaceId')
        if m.get('SecondaryPrivateIpAddressCount') is not None:
            self.secondary_private_ip_address_count = m.get('SecondaryPrivateIpAddressCount')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('PrivateIpAddress') is not None:
            self.private_ip_address = m.get('PrivateIpAddress')
        return self


class AssignPrivateIpAddressesResponseBodyAssignedPrivateIpAddressesSetPrivateIpSet(TeaModel):
    def __init__(
        self,
        private_ip_address: List[str] = None,
    ):
        self.private_ip_address = private_ip_address

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.private_ip_address is not None:
            result['PrivateIpAddress'] = self.private_ip_address
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PrivateIpAddress') is not None:
            self.private_ip_address = m.get('PrivateIpAddress')
        return self


class AssignPrivateIpAddressesResponseBodyAssignedPrivateIpAddressesSet(TeaModel):
    def __init__(
        self,
        network_interface_id: str = None,
        private_ip_set: AssignPrivateIpAddressesResponseBodyAssignedPrivateIpAddressesSetPrivateIpSet = None,
    ):
        self.network_interface_id = network_interface_id
        self.private_ip_set = private_ip_set

    def validate(self):
        if self.private_ip_set:
            self.private_ip_set.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.network_interface_id is not None:
            result['NetworkInterfaceId'] = self.network_interface_id
        if self.private_ip_set is not None:
            result['PrivateIpSet'] = self.private_ip_set.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('NetworkInterfaceId') is not None:
            self.network_interface_id = m.get('NetworkInterfaceId')
        if m.get('PrivateIpSet') is not None:
            temp_model = AssignPrivateIpAddressesResponseBodyAssignedPrivateIpAddressesSetPrivateIpSet()
            self.private_ip_set = temp_model.from_map(m['PrivateIpSet'])
        return self


class AssignPrivateIpAddressesResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        assigned_private_ip_addresses_set: AssignPrivateIpAddressesResponseBodyAssignedPrivateIpAddressesSet = None,
    ):
        self.request_id = request_id
        self.assigned_private_ip_addresses_set = assigned_private_ip_addresses_set

    def validate(self):
        if self.assigned_private_ip_addresses_set:
            self.assigned_private_ip_addresses_set.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.assigned_private_ip_addresses_set is not None:
            result['AssignedPrivateIpAddressesSet'] = self.assigned_private_ip_addresses_set.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('AssignedPrivateIpAddressesSet') is not None:
            temp_model = AssignPrivateIpAddressesResponseBodyAssignedPrivateIpAddressesSet()
            self.assigned_private_ip_addresses_set = temp_model.from_map(m['AssignedPrivateIpAddressesSet'])
        return self


class AssignPrivateIpAddressesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: AssignPrivateIpAddressesResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = AssignPrivateIpAddressesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AssociateEipAddressRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        region_id: str = None,
        allocation_id: str = None,
        instance_id: str = None,
        owner_account: str = None,
        instance_type: str = None,
    ):
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.region_id = region_id
        self.allocation_id = allocation_id
        self.instance_id = instance_id
        self.owner_account = owner_account
        self.instance_type = instance_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.allocation_id is not None:
            result['AllocationId'] = self.allocation_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.instance_type is not None:
            result['InstanceType'] = self.instance_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('AllocationId') is not None:
            self.allocation_id = m.get('AllocationId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('InstanceType') is not None:
            self.instance_type = m.get('InstanceType')
        return self


class AssociateEipAddressResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class AssociateEipAddressResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: AssociateEipAddressResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = AssociateEipAddressResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AssociateHaVipRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        owner_account: str = None,
        client_token: str = None,
        region_id: str = None,
        ha_vip_id: str = None,
        instance_id: str = None,
    ):
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.owner_account = owner_account
        self.client_token = client_token
        self.region_id = region_id
        self.ha_vip_id = ha_vip_id
        self.instance_id = instance_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.ha_vip_id is not None:
            result['HaVipId'] = self.ha_vip_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('HaVipId') is not None:
            self.ha_vip_id = m.get('HaVipId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class AssociateHaVipResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class AssociateHaVipResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: AssociateHaVipResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = AssociateHaVipResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AttachClassicLinkVpcRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        region_id: str = None,
        instance_id: str = None,
        vpc_id: str = None,
    ):
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.region_id = region_id
        self.instance_id = instance_id
        self.vpc_id = vpc_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.vpc_id is not None:
            result['VpcId'] = self.vpc_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('VpcId') is not None:
            self.vpc_id = m.get('VpcId')
        return self


class AttachClassicLinkVpcResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class AttachClassicLinkVpcResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: AttachClassicLinkVpcResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = AttachClassicLinkVpcResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AttachDiskRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        instance_id: str = None,
        disk_id: str = None,
        device: str = None,
        delete_with_instance: bool = None,
        bootable: bool = None,
        password: str = None,
        key_pair_name: str = None,
        owner_account: str = None,
    ):
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.instance_id = instance_id
        self.disk_id = disk_id
        self.device = device
        self.delete_with_instance = delete_with_instance
        self.bootable = bootable
        self.password = password
        self.key_pair_name = key_pair_name
        self.owner_account = owner_account

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.disk_id is not None:
            result['DiskId'] = self.disk_id
        if self.device is not None:
            result['Device'] = self.device
        if self.delete_with_instance is not None:
            result['DeleteWithInstance'] = self.delete_with_instance
        if self.bootable is not None:
            result['Bootable'] = self.bootable
        if self.password is not None:
            result['Password'] = self.password
        if self.key_pair_name is not None:
            result['KeyPairName'] = self.key_pair_name
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('DiskId') is not None:
            self.disk_id = m.get('DiskId')
        if m.get('Device') is not None:
            self.device = m.get('Device')
        if m.get('DeleteWithInstance') is not None:
            self.delete_with_instance = m.get('DeleteWithInstance')
        if m.get('Bootable') is not None:
            self.bootable = m.get('Bootable')
        if m.get('Password') is not None:
            self.password = m.get('Password')
        if m.get('KeyPairName') is not None:
            self.key_pair_name = m.get('KeyPairName')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        return self


class AttachDiskResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class AttachDiskResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: AttachDiskResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = AttachDiskResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AttachInstanceRamRoleRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        region_id: str = None,
        ram_role_name: str = None,
        instance_ids: str = None,
        policy: str = None,
    ):
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.region_id = region_id
        self.ram_role_name = ram_role_name
        self.instance_ids = instance_ids
        self.policy = policy

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.ram_role_name is not None:
            result['RamRoleName'] = self.ram_role_name
        if self.instance_ids is not None:
            result['InstanceIds'] = self.instance_ids
        if self.policy is not None:
            result['Policy'] = self.policy
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('RamRoleName') is not None:
            self.ram_role_name = m.get('RamRoleName')
        if m.get('InstanceIds') is not None:
            self.instance_ids = m.get('InstanceIds')
        if m.get('Policy') is not None:
            self.policy = m.get('Policy')
        return self


class AttachInstanceRamRoleResponseBodyAttachInstanceRamRoleResultsAttachInstanceRamRoleResult(TeaModel):
    def __init__(
        self,
        code: str = None,
        message: str = None,
        instance_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.message = message
        self.instance_id = instance_id
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class AttachInstanceRamRoleResponseBodyAttachInstanceRamRoleResults(TeaModel):
    def __init__(
        self,
        attach_instance_ram_role_result: List[AttachInstanceRamRoleResponseBodyAttachInstanceRamRoleResultsAttachInstanceRamRoleResult] = None,
    ):
        self.attach_instance_ram_role_result = attach_instance_ram_role_result

    def validate(self):
        if self.attach_instance_ram_role_result:
            for k in self.attach_instance_ram_role_result:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['AttachInstanceRamRoleResult'] = []
        if self.attach_instance_ram_role_result is not None:
            for k in self.attach_instance_ram_role_result:
                result['AttachInstanceRamRoleResult'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.attach_instance_ram_role_result = []
        if m.get('AttachInstanceRamRoleResult') is not None:
            for k in m.get('AttachInstanceRamRoleResult'):
                temp_model = AttachInstanceRamRoleResponseBodyAttachInstanceRamRoleResultsAttachInstanceRamRoleResult()
                self.attach_instance_ram_role_result.append(temp_model.from_map(k))
        return self


class AttachInstanceRamRoleResponseBody(TeaModel):
    def __init__(
        self,
        ram_role_name: str = None,
        request_id: str = None,
        total_count: int = None,
        fail_count: int = None,
        attach_instance_ram_role_results: AttachInstanceRamRoleResponseBodyAttachInstanceRamRoleResults = None,
    ):
        self.ram_role_name = ram_role_name
        self.request_id = request_id
        self.total_count = total_count
        self.fail_count = fail_count
        self.attach_instance_ram_role_results = attach_instance_ram_role_results

    def validate(self):
        if self.attach_instance_ram_role_results:
            self.attach_instance_ram_role_results.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ram_role_name is not None:
            result['RamRoleName'] = self.ram_role_name
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        if self.fail_count is not None:
            result['FailCount'] = self.fail_count
        if self.attach_instance_ram_role_results is not None:
            result['AttachInstanceRamRoleResults'] = self.attach_instance_ram_role_results.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RamRoleName') is not None:
            self.ram_role_name = m.get('RamRoleName')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        if m.get('FailCount') is not None:
            self.fail_count = m.get('FailCount')
        if m.get('AttachInstanceRamRoleResults') is not None:
            temp_model = AttachInstanceRamRoleResponseBodyAttachInstanceRamRoleResults()
            self.attach_instance_ram_role_results = temp_model.from_map(m['AttachInstanceRamRoleResults'])
        return self


class AttachInstanceRamRoleResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: AttachInstanceRamRoleResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = AttachInstanceRamRoleResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AttachKeyPairRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        region_id: str = None,
        key_pair_name: str = None,
        instance_ids: str = None,
    ):
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.region_id = region_id
        self.key_pair_name = key_pair_name
        self.instance_ids = instance_ids

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.key_pair_name is not None:
            result['KeyPairName'] = self.key_pair_name
        if self.instance_ids is not None:
            result['InstanceIds'] = self.instance_ids
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('KeyPairName') is not None:
            self.key_pair_name = m.get('KeyPairName')
        if m.get('InstanceIds') is not None:
            self.instance_ids = m.get('InstanceIds')
        return self


class AttachKeyPairResponseBodyResultsResult(TeaModel):
    def __init__(
        self,
        code: str = None,
        message: str = None,
        instance_id: str = None,
        success: str = None,
    ):
        self.code = code
        self.message = message
        self.instance_id = instance_id
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class AttachKeyPairResponseBodyResults(TeaModel):
    def __init__(
        self,
        result: List[AttachKeyPairResponseBodyResultsResult] = None,
    ):
        self.result = result

    def validate(self):
        if self.result:
            for k in self.result:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Result'] = []
        if self.result is not None:
            for k in self.result:
                result['Result'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.result = []
        if m.get('Result') is not None:
            for k in m.get('Result'):
                temp_model = AttachKeyPairResponseBodyResultsResult()
                self.result.append(temp_model.from_map(k))
        return self


class AttachKeyPairResponseBody(TeaModel):
    def __init__(
        self,
        key_pair_name: str = None,
        request_id: str = None,
        total_count: str = None,
        fail_count: str = None,
        results: AttachKeyPairResponseBodyResults = None,
    ):
        self.key_pair_name = key_pair_name
        self.request_id = request_id
        self.total_count = total_count
        self.fail_count = fail_count
        self.results = results

    def validate(self):
        if self.results:
            self.results.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key_pair_name is not None:
            result['KeyPairName'] = self.key_pair_name
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        if self.fail_count is not None:
            result['FailCount'] = self.fail_count
        if self.results is not None:
            result['Results'] = self.results.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('KeyPairName') is not None:
            self.key_pair_name = m.get('KeyPairName')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        if m.get('FailCount') is not None:
            self.fail_count = m.get('FailCount')
        if m.get('Results') is not None:
            temp_model = AttachKeyPairResponseBodyResults()
            self.results = temp_model.from_map(m['Results'])
        return self


class AttachKeyPairResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: AttachKeyPairResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = AttachKeyPairResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AttachNetworkInterfaceRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        owner_account: str = None,
        region_id: str = None,
        network_interface_id: str = None,
        instance_id: str = None,
        trunk_network_instance_id: str = None,
        wait_for_network_configuration_ready: bool = None,
    ):
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.owner_account = owner_account
        self.region_id = region_id
        self.network_interface_id = network_interface_id
        self.instance_id = instance_id
        self.trunk_network_instance_id = trunk_network_instance_id
        self.wait_for_network_configuration_ready = wait_for_network_configuration_ready

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.network_interface_id is not None:
            result['NetworkInterfaceId'] = self.network_interface_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.trunk_network_instance_id is not None:
            result['TrunkNetworkInstanceId'] = self.trunk_network_instance_id
        if self.wait_for_network_configuration_ready is not None:
            result['WaitForNetworkConfigurationReady'] = self.wait_for_network_configuration_ready
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('NetworkInterfaceId') is not None:
            self.network_interface_id = m.get('NetworkInterfaceId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('TrunkNetworkInstanceId') is not None:
            self.trunk_network_instance_id = m.get('TrunkNetworkInstanceId')
        if m.get('WaitForNetworkConfigurationReady') is not None:
            self.wait_for_network_configuration_ready = m.get('WaitForNetworkConfigurationReady')
        return self


class AttachNetworkInterfaceResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class AttachNetworkInterfaceResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: AttachNetworkInterfaceResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = AttachNetworkInterfaceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AuthorizeSecurityGroupRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        owner_account: str = None,
        region_id: str = None,
        security_group_id: str = None,
        ip_protocol: str = None,
        port_range: str = None,
        source_group_id: str = None,
        source_group_owner_id: int = None,
        source_group_owner_account: str = None,
        source_cidr_ip: str = None,
        ipv_6source_cidr_ip: str = None,
        source_prefix_list_id: str = None,
        source_port_range: str = None,
        dest_cidr_ip: str = None,
        ipv_6dest_cidr_ip: str = None,
        policy: str = None,
        priority: str = None,
        nic_type: str = None,
        client_token: str = None,
        description: str = None,
    ):
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.owner_account = owner_account
        self.region_id = region_id
        self.security_group_id = security_group_id
        self.ip_protocol = ip_protocol
        self.port_range = port_range
        self.source_group_id = source_group_id
        self.source_group_owner_id = source_group_owner_id
        self.source_group_owner_account = source_group_owner_account
        self.source_cidr_ip = source_cidr_ip
        self.ipv_6source_cidr_ip = ipv_6source_cidr_ip
        self.source_prefix_list_id = source_prefix_list_id
        self.source_port_range = source_port_range
        self.dest_cidr_ip = dest_cidr_ip
        self.ipv_6dest_cidr_ip = ipv_6dest_cidr_ip
        self.policy = policy
        self.priority = priority
        self.nic_type = nic_type
        self.client_token = client_token
        self.description = description

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.security_group_id is not None:
            result['SecurityGroupId'] = self.security_group_id
        if self.ip_protocol is not None:
            result['IpProtocol'] = self.ip_protocol
        if self.port_range is not None:
            result['PortRange'] = self.port_range
        if self.source_group_id is not None:
            result['SourceGroupId'] = self.source_group_id
        if self.source_group_owner_id is not None:
            result['SourceGroupOwnerId'] = self.source_group_owner_id
        if self.source_group_owner_account is not None:
            result['SourceGroupOwnerAccount'] = self.source_group_owner_account
        if self.source_cidr_ip is not None:
            result['SourceCidrIp'] = self.source_cidr_ip
        if self.ipv_6source_cidr_ip is not None:
            result['Ipv6SourceCidrIp'] = self.ipv_6source_cidr_ip
        if self.source_prefix_list_id is not None:
            result['SourcePrefixListId'] = self.source_prefix_list_id
        if self.source_port_range is not None:
            result['SourcePortRange'] = self.source_port_range
        if self.dest_cidr_ip is not None:
            result['DestCidrIp'] = self.dest_cidr_ip
        if self.ipv_6dest_cidr_ip is not None:
            result['Ipv6DestCidrIp'] = self.ipv_6dest_cidr_ip
        if self.policy is not None:
            result['Policy'] = self.policy
        if self.priority is not None:
            result['Priority'] = self.priority
        if self.nic_type is not None:
            result['NicType'] = self.nic_type
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.description is not None:
            result['Description'] = self.description
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('SecurityGroupId') is not None:
            self.security_group_id = m.get('SecurityGroupId')
        if m.get('IpProtocol') is not None:
            self.ip_protocol = m.get('IpProtocol')
        if m.get('PortRange') is not None:
            self.port_range = m.get('PortRange')
        if m.get('SourceGroupId') is not None:
            self.source_group_id = m.get('SourceGroupId')
        if m.get('SourceGroupOwnerId') is not None:
            self.source_group_owner_id = m.get('SourceGroupOwnerId')
        if m.get('SourceGroupOwnerAccount') is not None:
            self.source_group_owner_account = m.get('SourceGroupOwnerAccount')
        if m.get('SourceCidrIp') is not None:
            self.source_cidr_ip = m.get('SourceCidrIp')
        if m.get('Ipv6SourceCidrIp') is not None:
            self.ipv_6source_cidr_ip = m.get('Ipv6SourceCidrIp')
        if m.get('SourcePrefixListId') is not None:
            self.source_prefix_list_id = m.get('SourcePrefixListId')
        if m.get('SourcePortRange') is not None:
            self.source_port_range = m.get('SourcePortRange')
        if m.get('DestCidrIp') is not None:
            self.dest_cidr_ip = m.get('DestCidrIp')
        if m.get('Ipv6DestCidrIp') is not None:
            self.ipv_6dest_cidr_ip = m.get('Ipv6DestCidrIp')
        if m.get('Policy') is not None:
            self.policy = m.get('Policy')
        if m.get('Priority') is not None:
            self.priority = m.get('Priority')
        if m.get('NicType') is not None:
            self.nic_type = m.get('NicType')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        return self


class AuthorizeSecurityGroupResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class AuthorizeSecurityGroupResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: AuthorizeSecurityGroupResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = AuthorizeSecurityGroupResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AuthorizeSecurityGroupEgressRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        owner_account: str = None,
        region_id: str = None,
        security_group_id: str = None,
        ip_protocol: str = None,
        port_range: str = None,
        dest_group_id: str = None,
        dest_group_owner_id: int = None,
        dest_group_owner_account: str = None,
        dest_cidr_ip: str = None,
        ipv_6dest_cidr_ip: str = None,
        dest_prefix_list_id: str = None,
        source_cidr_ip: str = None,
        ipv_6source_cidr_ip: str = None,
        source_port_range: str = None,
        policy: str = None,
        priority: str = None,
        nic_type: str = None,
        client_token: str = None,
        description: str = None,
    ):
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.owner_account = owner_account
        self.region_id = region_id
        self.security_group_id = security_group_id
        self.ip_protocol = ip_protocol
        self.port_range = port_range
        self.dest_group_id = dest_group_id
        self.dest_group_owner_id = dest_group_owner_id
        self.dest_group_owner_account = dest_group_owner_account
        self.dest_cidr_ip = dest_cidr_ip
        self.ipv_6dest_cidr_ip = ipv_6dest_cidr_ip
        self.dest_prefix_list_id = dest_prefix_list_id
        self.source_cidr_ip = source_cidr_ip
        self.ipv_6source_cidr_ip = ipv_6source_cidr_ip
        self.source_port_range = source_port_range
        self.policy = policy
        self.priority = priority
        self.nic_type = nic_type
        self.client_token = client_token
        self.description = description

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.security_group_id is not None:
            result['SecurityGroupId'] = self.security_group_id
        if self.ip_protocol is not None:
            result['IpProtocol'] = self.ip_protocol
        if self.port_range is not None:
            result['PortRange'] = self.port_range
        if self.dest_group_id is not None:
            result['DestGroupId'] = self.dest_group_id
        if self.dest_group_owner_id is not None:
            result['DestGroupOwnerId'] = self.dest_group_owner_id
        if self.dest_group_owner_account is not None:
            result['DestGroupOwnerAccount'] = self.dest_group_owner_account
        if self.dest_cidr_ip is not None:
            result['DestCidrIp'] = self.dest_cidr_ip
        if self.ipv_6dest_cidr_ip is not None:
            result['Ipv6DestCidrIp'] = self.ipv_6dest_cidr_ip
        if self.dest_prefix_list_id is not None:
            result['DestPrefixListId'] = self.dest_prefix_list_id
        if self.source_cidr_ip is not None:
            result['SourceCidrIp'] = self.source_cidr_ip
        if self.ipv_6source_cidr_ip is not None:
            result['Ipv6SourceCidrIp'] = self.ipv_6source_cidr_ip
        if self.source_port_range is not None:
            result['SourcePortRange'] = self.source_port_range
        if self.policy is not None:
            result['Policy'] = self.policy
        if self.priority is not None:
            result['Priority'] = self.priority
        if self.nic_type is not None:
            result['NicType'] = self.nic_type
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.description is not None:
            result['Description'] = self.description
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('SecurityGroupId') is not None:
            self.security_group_id = m.get('SecurityGroupId')
        if m.get('IpProtocol') is not None:
            self.ip_protocol = m.get('IpProtocol')
        if m.get('PortRange') is not None:
            self.port_range = m.get('PortRange')
        if m.get('DestGroupId') is not None:
            self.dest_group_id = m.get('DestGroupId')
        if m.get('DestGroupOwnerId') is not None:
            self.dest_group_owner_id = m.get('DestGroupOwnerId')
        if m.get('DestGroupOwnerAccount') is not None:
            self.dest_group_owner_account = m.get('DestGroupOwnerAccount')
        if m.get('DestCidrIp') is not None:
            self.dest_cidr_ip = m.get('DestCidrIp')
        if m.get('Ipv6DestCidrIp') is not None:
            self.ipv_6dest_cidr_ip = m.get('Ipv6DestCidrIp')
        if m.get('DestPrefixListId') is not None:
            self.dest_prefix_list_id = m.get('DestPrefixListId')
        if m.get('SourceCidrIp') is not None:
            self.source_cidr_ip = m.get('SourceCidrIp')
        if m.get('Ipv6SourceCidrIp') is not None:
            self.ipv_6source_cidr_ip = m.get('Ipv6SourceCidrIp')
        if m.get('SourcePortRange') is not None:
            self.source_port_range = m.get('SourcePortRange')
        if m.get('Policy') is not None:
            self.policy = m.get('Policy')
        if m.get('Priority') is not None:
            self.priority = m.get('Priority')
        if m.get('NicType') is not None:
            self.nic_type = m.get('NicType')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        return self


class AuthorizeSecurityGroupEgressResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class AuthorizeSecurityGroupEgressResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: AuthorizeSecurityGroupEgressResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = AuthorizeSecurityGroupEgressResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CancelAutoSnapshotPolicyRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        region_id: str = None,
        disk_ids: str = None,
    ):
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.region_id = region_id
        self.disk_ids = disk_ids

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['regionId'] = self.region_id
        if self.disk_ids is not None:
            result['diskIds'] = self.disk_ids
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('regionId') is not None:
            self.region_id = m.get('regionId')
        if m.get('diskIds') is not None:
            self.disk_ids = m.get('diskIds')
        return self


class CancelAutoSnapshotPolicyResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CancelAutoSnapshotPolicyResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CancelAutoSnapshotPolicyResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CancelAutoSnapshotPolicyResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CancelCopyImageRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        region_id: str = None,
        image_id: str = None,
        owner_account: str = None,
    ):
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.region_id = region_id
        self.image_id = image_id
        self.owner_account = owner_account

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.image_id is not None:
            result['ImageId'] = self.image_id
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ImageId') is not None:
            self.image_id = m.get('ImageId')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        return self


class CancelCopyImageResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CancelCopyImageResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CancelCopyImageResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CancelCopyImageResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CancelImagePipelineExecutionRequestTemplateTag(TeaModel):
    def __init__(
        self,
        key: str = None,
        value: str = None,
    ):
        self.key = key
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class CancelImagePipelineExecutionRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        owner_account: str = None,
        region_id: str = None,
        template_tag: List[CancelImagePipelineExecutionRequestTemplateTag] = None,
        execution_id: str = None,
    ):
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.owner_account = owner_account
        self.region_id = region_id
        self.template_tag = template_tag
        self.execution_id = execution_id

    def validate(self):
        if self.template_tag:
            for k in self.template_tag:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        result['TemplateTag'] = []
        if self.template_tag is not None:
            for k in self.template_tag:
                result['TemplateTag'].append(k.to_map() if k else None)
        if self.execution_id is not None:
            result['ExecutionId'] = self.execution_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        self.template_tag = []
        if m.get('TemplateTag') is not None:
            for k in m.get('TemplateTag'):
                temp_model = CancelImagePipelineExecutionRequestTemplateTag()
                self.template_tag.append(temp_model.from_map(k))
        if m.get('ExecutionId') is not None:
            self.execution_id = m.get('ExecutionId')
        return self


class CancelImagePipelineExecutionResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CancelImagePipelineExecutionResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CancelImagePipelineExecutionResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CancelImagePipelineExecutionResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CancelPhysicalConnectionRequest(TeaModel):
    def __init__(
        self,
        region_id: str = None,
        physical_connection_id: str = None,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        client_token: str = None,
        owner_account: str = None,
        user_cidr: str = None,
    ):
        self.region_id = region_id
        self.physical_connection_id = physical_connection_id
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.client_token = client_token
        self.owner_account = owner_account
        self.user_cidr = user_cidr

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.physical_connection_id is not None:
            result['PhysicalConnectionId'] = self.physical_connection_id
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.user_cidr is not None:
            result['UserCidr'] = self.user_cidr
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('PhysicalConnectionId') is not None:
            self.physical_connection_id = m.get('PhysicalConnectionId')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('UserCidr') is not None:
            self.user_cidr = m.get('UserCidr')
        return self


class CancelPhysicalConnectionResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CancelPhysicalConnectionResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CancelPhysicalConnectionResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CancelPhysicalConnectionResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CancelSimulatedSystemEventsRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        owner_account: str = None,
        region_id: str = None,
        event_id: List[str] = None,
    ):
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.owner_account = owner_account
        self.region_id = region_id
        self.event_id = event_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.event_id is not None:
            result['EventId'] = self.event_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('EventId') is not None:
            self.event_id = m.get('EventId')
        return self


class CancelSimulatedSystemEventsResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CancelSimulatedSystemEventsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CancelSimulatedSystemEventsResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CancelSimulatedSystemEventsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CancelTaskRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        region_id: str = None,
        task_id: str = None,
    ):
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.region_id = region_id
        self.task_id = task_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        return self


class CancelTaskResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CancelTaskResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CancelTaskResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CancelTaskResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ConnectRouterInterfaceRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        region_id: str = None,
        router_interface_id: str = None,
    ):
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.region_id = region_id
        self.router_interface_id = router_interface_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.router_interface_id is not None:
            result['RouterInterfaceId'] = self.router_interface_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('RouterInterfaceId') is not None:
            self.router_interface_id = m.get('RouterInterfaceId')
        return self


class ConnectRouterInterfaceResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ConnectRouterInterfaceResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ConnectRouterInterfaceResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ConnectRouterInterfaceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ConvertNatPublicIpToEipRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        instance_id: str = None,
        region_id: str = None,
    ):
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.instance_id = instance_id
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class ConvertNatPublicIpToEipResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ConvertNatPublicIpToEipResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ConvertNatPublicIpToEipResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ConvertNatPublicIpToEipResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CopyImageRequestTag(TeaModel):
    def __init__(
        self,
        key: str = None,
        value: str = None,
    ):
        self.key = key
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class CopyImageRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        destination_image_name: str = None,
        destination_description: str = None,
        image_id: str = None,
        region_id: str = None,
        destination_region_id: str = None,
        owner_account: str = None,
        encrypted: bool = None,
        kmskey_id: str = None,
        encrypt_algorithm: str = None,
        resource_group_id: str = None,
        tag: List[CopyImageRequestTag] = None,
    ):
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.destination_image_name = destination_image_name
        self.destination_description = destination_description
        self.image_id = image_id
        self.region_id = region_id
        self.destination_region_id = destination_region_id
        self.owner_account = owner_account
        self.encrypted = encrypted
        self.kmskey_id = kmskey_id
        self.encrypt_algorithm = encrypt_algorithm
        self.resource_group_id = resource_group_id
        self.tag = tag

    def validate(self):
        if self.tag:
            for k in self.tag:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.destination_image_name is not None:
            result['DestinationImageName'] = self.destination_image_name
        if self.destination_description is not None:
            result['DestinationDescription'] = self.destination_description
        if self.image_id is not None:
            result['ImageId'] = self.image_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.destination_region_id is not None:
            result['DestinationRegionId'] = self.destination_region_id
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.encrypted is not None:
            result['Encrypted'] = self.encrypted
        if self.kmskey_id is not None:
            result['KMSKeyId'] = self.kmskey_id
        if self.encrypt_algorithm is not None:
            result['EncryptAlgorithm'] = self.encrypt_algorithm
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        result['Tag'] = []
        if self.tag is not None:
            for k in self.tag:
                result['Tag'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('DestinationImageName') is not None:
            self.destination_image_name = m.get('DestinationImageName')
        if m.get('DestinationDescription') is not None:
            self.destination_description = m.get('DestinationDescription')
        if m.get('ImageId') is not None:
            self.image_id = m.get('ImageId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('DestinationRegionId') is not None:
            self.destination_region_id = m.get('DestinationRegionId')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('Encrypted') is not None:
            self.encrypted = m.get('Encrypted')
        if m.get('KMSKeyId') is not None:
            self.kmskey_id = m.get('KMSKeyId')
        if m.get('EncryptAlgorithm') is not None:
            self.encrypt_algorithm = m.get('EncryptAlgorithm')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        self.tag = []
        if m.get('Tag') is not None:
            for k in m.get('Tag'):
                temp_model = CopyImageRequestTag()
                self.tag.append(temp_model.from_map(k))
        return self


class CopyImageResponseBody(TeaModel):
    def __init__(
        self,
        image_id: str = None,
        request_id: str = None,
    ):
        self.image_id = image_id
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.image_id is not None:
            result['ImageId'] = self.image_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ImageId') is not None:
            self.image_id = m.get('ImageId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CopyImageResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CopyImageResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CopyImageResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CopySnapshotRequestTag(TeaModel):
    def __init__(
        self,
        key: str = None,
        value: str = None,
    ):
        self.key = key
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class CopySnapshotRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        resource_group_id: str = None,
        tag: List[CopySnapshotRequestTag] = None,
        region_id: str = None,
        destination_region_id: str = None,
        snapshot_id: str = None,
        destination_snapshot_name: str = None,
        destination_snapshot_description: str = None,
        retention_days: int = None,
    ):
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.resource_group_id = resource_group_id
        self.tag = tag
        self.region_id = region_id
        self.destination_region_id = destination_region_id
        self.snapshot_id = snapshot_id
        self.destination_snapshot_name = destination_snapshot_name
        self.destination_snapshot_description = destination_snapshot_description
        self.retention_days = retention_days

    def validate(self):
        if self.tag:
            for k in self.tag:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        result['Tag'] = []
        if self.tag is not None:
            for k in self.tag:
                result['Tag'].append(k.to_map() if k else None)
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.destination_region_id is not None:
            result['DestinationRegionId'] = self.destination_region_id
        if self.snapshot_id is not None:
            result['SnapshotId'] = self.snapshot_id
        if self.destination_snapshot_name is not None:
            result['DestinationSnapshotName'] = self.destination_snapshot_name
        if self.destination_snapshot_description is not None:
            result['DestinationSnapshotDescription'] = self.destination_snapshot_description
        if self.retention_days is not None:
            result['RetentionDays'] = self.retention_days
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        self.tag = []
        if m.get('Tag') is not None:
            for k in m.get('Tag'):
                temp_model = CopySnapshotRequestTag()
                self.tag.append(temp_model.from_map(k))
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('DestinationRegionId') is not None:
            self.destination_region_id = m.get('DestinationRegionId')
        if m.get('SnapshotId') is not None:
            self.snapshot_id = m.get('SnapshotId')
        if m.get('DestinationSnapshotName') is not None:
            self.destination_snapshot_name = m.get('DestinationSnapshotName')
        if m.get('DestinationSnapshotDescription') is not None:
            self.destination_snapshot_description = m.get('DestinationSnapshotDescription')
        if m.get('RetentionDays') is not None:
            self.retention_days = m.get('RetentionDays')
        return self


class CopySnapshotResponseBody(TeaModel):
    def __init__(
        self,
        snapshot_id: str = None,
        request_id: str = None,
    ):
        self.snapshot_id = snapshot_id
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.snapshot_id is not None:
            result['SnapshotId'] = self.snapshot_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('SnapshotId') is not None:
            self.snapshot_id = m.get('SnapshotId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CopySnapshotResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CopySnapshotResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CopySnapshotResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateActivationRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        owner_account: str = None,
        region_id: str = None,
        instance_name: str = None,
        description: str = None,
        instance_count: int = None,
        time_to_live_in_hours: int = None,
        ip_address_range: str = None,
    ):
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.owner_account = owner_account
        self.region_id = region_id
        self.instance_name = instance_name
        self.description = description
        self.instance_count = instance_count
        self.time_to_live_in_hours = time_to_live_in_hours
        self.ip_address_range = ip_address_range

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.instance_name is not None:
            result['InstanceName'] = self.instance_name
        if self.description is not None:
            result['Description'] = self.description
        if self.instance_count is not None:
            result['InstanceCount'] = self.instance_count
        if self.time_to_live_in_hours is not None:
            result['TimeToLiveInHours'] = self.time_to_live_in_hours
        if self.ip_address_range is not None:
            result['IpAddressRange'] = self.ip_address_range
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('InstanceName') is not None:
            self.instance_name = m.get('InstanceName')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('InstanceCount') is not None:
            self.instance_count = m.get('InstanceCount')
        if m.get('TimeToLiveInHours') is not None:
            self.time_to_live_in_hours = m.get('TimeToLiveInHours')
        if m.get('IpAddressRange') is not None:
            self.ip_address_range = m.get('IpAddressRange')
        return self


class CreateActivationResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        activation_code: str = None,
        activation_id: str = None,
    ):
        self.request_id = request_id
        self.activation_code = activation_code
        self.activation_id = activation_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.activation_code is not None:
            result['ActivationCode'] = self.activation_code
        if self.activation_id is not None:
            result['ActivationId'] = self.activation_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ActivationCode') is not None:
            self.activation_code = m.get('ActivationCode')
        if m.get('ActivationId') is not None:
            self.activation_id = m.get('ActivationId')
        return self


class CreateActivationResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CreateActivationResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateActivationResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateAutoProvisioningGroupRequestLaunchConfigurationDataDisk(TeaModel):
    def __init__(
        self,
        performance_level: str = None,
        kms_key_id: str = None,
        description: str = None,
        snapshot_id: str = None,
        size: int = None,
        device: str = None,
        disk_name: str = None,
        category: str = None,
        delete_with_instance: bool = None,
        encrypted: bool = None,
    ):
        self.performance_level = performance_level
        self.kms_key_id = kms_key_id
        self.description = description
        self.snapshot_id = snapshot_id
        self.size = size
        self.device = device
        self.disk_name = disk_name
        self.category = category
        self.delete_with_instance = delete_with_instance
        self.encrypted = encrypted

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.performance_level is not None:
            result['PerformanceLevel'] = self.performance_level
        if self.kms_key_id is not None:
            result['KmsKeyId'] = self.kms_key_id
        if self.description is not None:
            result['Description'] = self.description
        if self.snapshot_id is not None:
            result['SnapshotId'] = self.snapshot_id
        if self.size is not None:
            result['Size'] = self.size
        if self.device is not None:
            result['Device'] = self.device
        if self.disk_name is not None:
            result['DiskName'] = self.disk_name
        if self.category is not None:
            result['Category'] = self.category
        if self.delete_with_instance is not None:
            result['DeleteWithInstance'] = self.delete_with_instance
        if self.encrypted is not None:
            result['Encrypted'] = self.encrypted
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PerformanceLevel') is not None:
            self.performance_level = m.get('PerformanceLevel')
        if m.get('KmsKeyId') is not None:
            self.kms_key_id = m.get('KmsKeyId')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('SnapshotId') is not None:
            self.snapshot_id = m.get('SnapshotId')
        if m.get('Size') is not None:
            self.size = m.get('Size')
        if m.get('Device') is not None:
            self.device = m.get('Device')
        if m.get('DiskName') is not None:
            self.disk_name = m.get('DiskName')
        if m.get('Category') is not None:
            self.category = m.get('Category')
        if m.get('DeleteWithInstance') is not None:
            self.delete_with_instance = m.get('DeleteWithInstance')
        if m.get('Encrypted') is not None:
            self.encrypted = m.get('Encrypted')
        return self


class CreateAutoProvisioningGroupRequestLaunchConfigurationTag(TeaModel):
    def __init__(
        self,
        key: str = None,
        value: str = None,
    ):
        self.key = key
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class CreateAutoProvisioningGroupRequestLaunchConfiguration(TeaModel):
    def __init__(
        self,
        image_id: str = None,
        security_group_id: str = None,
        io_optimized: str = None,
        internet_charge_type: str = None,
        internet_max_bandwidth_in: int = None,
        internet_max_bandwidth_out: int = None,
        instance_name: str = None,
        host_name: str = None,
        instance_description: str = None,
        key_pair_name: str = None,
        ram_role_name: str = None,
        security_enhancement_strategy: str = None,
        user_data: str = None,
        system_disk_category: str = None,
        system_disk_size: int = None,
        system_disk_name: str = None,
        system_disk_description: str = None,
        system_disk_performance_level: str = None,
        password_inherit: bool = None,
        resource_group_id: str = None,
        credit_specification: str = None,
        deployment_set_id: str = None,
        data_disk: List[CreateAutoProvisioningGroupRequestLaunchConfigurationDataDisk] = None,
        tag: List[CreateAutoProvisioningGroupRequestLaunchConfigurationTag] = None,
        host_names: List[str] = None,
    ):
        self.image_id = image_id
        self.security_group_id = security_group_id
        self.io_optimized = io_optimized
        self.internet_charge_type = internet_charge_type
        self.internet_max_bandwidth_in = internet_max_bandwidth_in
        self.internet_max_bandwidth_out = internet_max_bandwidth_out
        self.instance_name = instance_name
        self.host_name = host_name
        self.instance_description = instance_description
        self.key_pair_name = key_pair_name
        self.ram_role_name = ram_role_name
        self.security_enhancement_strategy = security_enhancement_strategy
        self.user_data = user_data
        self.system_disk_category = system_disk_category
        self.system_disk_size = system_disk_size
        self.system_disk_name = system_disk_name
        self.system_disk_description = system_disk_description
        self.system_disk_performance_level = system_disk_performance_level
        self.password_inherit = password_inherit
        self.resource_group_id = resource_group_id
        self.credit_specification = credit_specification
        self.deployment_set_id = deployment_set_id
        self.data_disk = data_disk
        self.tag = tag
        self.host_names = host_names

    def validate(self):
        if self.data_disk:
            for k in self.data_disk:
                if k:
                    k.validate()
        if self.tag:
            for k in self.tag:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.image_id is not None:
            result['ImageId'] = self.image_id
        if self.security_group_id is not None:
            result['SecurityGroupId'] = self.security_group_id
        if self.io_optimized is not None:
            result['IoOptimized'] = self.io_optimized
        if self.internet_charge_type is not None:
            result['InternetChargeType'] = self.internet_charge_type
        if self.internet_max_bandwidth_in is not None:
            result['InternetMaxBandwidthIn'] = self.internet_max_bandwidth_in
        if self.internet_max_bandwidth_out is not None:
            result['InternetMaxBandwidthOut'] = self.internet_max_bandwidth_out
        if self.instance_name is not None:
            result['InstanceName'] = self.instance_name
        if self.host_name is not None:
            result['HostName'] = self.host_name
        if self.instance_description is not None:
            result['InstanceDescription'] = self.instance_description
        if self.key_pair_name is not None:
            result['KeyPairName'] = self.key_pair_name
        if self.ram_role_name is not None:
            result['RamRoleName'] = self.ram_role_name
        if self.security_enhancement_strategy is not None:
            result['SecurityEnhancementStrategy'] = self.security_enhancement_strategy
        if self.user_data is not None:
            result['UserData'] = self.user_data
        if self.system_disk_category is not None:
            result['SystemDiskCategory'] = self.system_disk_category
        if self.system_disk_size is not None:
            result['SystemDiskSize'] = self.system_disk_size
        if self.system_disk_name is not None:
            result['SystemDiskName'] = self.system_disk_name
        if self.system_disk_description is not None:
            result['SystemDiskDescription'] = self.system_disk_description
        if self.system_disk_performance_level is not None:
            result['SystemDiskPerformanceLevel'] = self.system_disk_performance_level
        if self.password_inherit is not None:
            result['PasswordInherit'] = self.password_inherit
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.credit_specification is not None:
            result['CreditSpecification'] = self.credit_specification
        if self.deployment_set_id is not None:
            result['DeploymentSetId'] = self.deployment_set_id
        result['DataDisk'] = []
        if self.data_disk is not None:
            for k in self.data_disk:
                result['DataDisk'].append(k.to_map() if k else None)
        result['Tag'] = []
        if self.tag is not None:
            for k in self.tag:
                result['Tag'].append(k.to_map() if k else None)
        if self.host_names is not None:
            result['HostNames'] = self.host_names
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ImageId') is not None:
            self.image_id = m.get('ImageId')
        if m.get('SecurityGroupId') is not None:
            self.security_group_id = m.get('SecurityGroupId')
        if m.get('IoOptimized') is not None:
            self.io_optimized = m.get('IoOptimized')
        if m.get('InternetChargeType') is not None:
            self.internet_charge_type = m.get('InternetChargeType')
        if m.get('InternetMaxBandwidthIn') is not None:
            self.internet_max_bandwidth_in = m.get('InternetMaxBandwidthIn')
        if m.get('InternetMaxBandwidthOut') is not None:
            self.internet_max_bandwidth_out = m.get('InternetMaxBandwidthOut')
        if m.get('InstanceName') is not None:
            self.instance_name = m.get('InstanceName')
        if m.get('HostName') is not None:
            self.host_name = m.get('HostName')
        if m.get('InstanceDescription') is not None:
            self.instance_description = m.get('InstanceDescription')
        if m.get('KeyPairName') is not None:
            self.key_pair_name = m.get('KeyPairName')
        if m.get('RamRoleName') is not None:
            self.ram_role_name = m.get('RamRoleName')
        if m.get('SecurityEnhancementStrategy') is not None:
            self.security_enhancement_strategy = m.get('SecurityEnhancementStrategy')
        if m.get('UserData') is not None:
            self.user_data = m.get('UserData')
        if m.get('SystemDiskCategory') is not None:
            self.system_disk_category = m.get('SystemDiskCategory')
        if m.get('SystemDiskSize') is not None:
            self.system_disk_size = m.get('SystemDiskSize')
        if m.get('SystemDiskName') is not None:
            self.system_disk_name = m.get('SystemDiskName')
        if m.get('SystemDiskDescription') is not None:
            self.system_disk_description = m.get('SystemDiskDescription')
        if m.get('SystemDiskPerformanceLevel') is not None:
            self.system_disk_performance_level = m.get('SystemDiskPerformanceLevel')
        if m.get('PasswordInherit') is not None:
            self.password_inherit = m.get('PasswordInherit')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        if m.get('CreditSpecification') is not None:
            self.credit_specification = m.get('CreditSpecification')
        if m.get('DeploymentSetId') is not None:
            self.deployment_set_id = m.get('DeploymentSetId')
        self.data_disk = []
        if m.get('DataDisk') is not None:
            for k in m.get('DataDisk'):
                temp_model = CreateAutoProvisioningGroupRequestLaunchConfigurationDataDisk()
                self.data_disk.append(temp_model.from_map(k))
        self.tag = []
        if m.get('Tag') is not None:
            for k in m.get('Tag'):
                temp_model = CreateAutoProvisioningGroupRequestLaunchConfigurationTag()
                self.tag.append(temp_model.from_map(k))
        if m.get('HostNames') is not None:
            self.host_names = m.get('HostNames')
        return self


class CreateAutoProvisioningGroupRequestLaunchTemplateConfig(TeaModel):
    def __init__(
        self,
        v_switch_id: str = None,
        max_price: float = None,
        priority: int = None,
        instance_type: str = None,
        weighted_capacity: float = None,
    ):
        self.v_switch_id = v_switch_id
        self.max_price = max_price
        self.priority = priority
        self.instance_type = instance_type
        self.weighted_capacity = weighted_capacity

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.v_switch_id is not None:
            result['VSwitchId'] = self.v_switch_id
        if self.max_price is not None:
            result['MaxPrice'] = self.max_price
        if self.priority is not None:
            result['Priority'] = self.priority
        if self.instance_type is not None:
            result['InstanceType'] = self.instance_type
        if self.weighted_capacity is not None:
            result['WeightedCapacity'] = self.weighted_capacity
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('VSwitchId') is not None:
            self.v_switch_id = m.get('VSwitchId')
        if m.get('MaxPrice') is not None:
            self.max_price = m.get('MaxPrice')
        if m.get('Priority') is not None:
            self.priority = m.get('Priority')
        if m.get('InstanceType') is not None:
            self.instance_type = m.get('InstanceType')
        if m.get('WeightedCapacity') is not None:
            self.weighted_capacity = m.get('WeightedCapacity')
        return self


class CreateAutoProvisioningGroupRequestSystemDiskConfig(TeaModel):
    def __init__(
        self,
        disk_category: str = None,
    ):
        self.disk_category = disk_category

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.disk_category is not None:
            result['DiskCategory'] = self.disk_category
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DiskCategory') is not None:
            self.disk_category = m.get('DiskCategory')
        return self


class CreateAutoProvisioningGroupRequestDataDiskConfig(TeaModel):
    def __init__(
        self,
        disk_category: str = None,
    ):
        self.disk_category = disk_category

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.disk_category is not None:
            result['DiskCategory'] = self.disk_category
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DiskCategory') is not None:
            self.disk_category = m.get('DiskCategory')
        return self


class CreateAutoProvisioningGroupRequest(TeaModel):
    def __init__(
        self,
        launch_configuration: CreateAutoProvisioningGroupRequestLaunchConfiguration = None,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        owner_account: str = None,
        region_id: str = None,
        resource_group_id: str = None,
        auto_provisioning_group_name: str = None,
        auto_provisioning_group_type: str = None,
        spot_allocation_strategy: str = None,
        spot_instance_interruption_behavior: str = None,
        spot_instance_pools_to_use_count: int = None,
        pay_as_you_go_allocation_strategy: str = None,
        excess_capacity_termination_policy: str = None,
        valid_from: str = None,
        valid_until: str = None,
        terminate_instances_with_expiration: bool = None,
        terminate_instances: bool = None,
        max_spot_price: float = None,
        total_target_capacity: str = None,
        pay_as_you_go_target_capacity: str = None,
        spot_target_capacity: str = None,
        default_target_capacity_type: str = None,
        launch_template_id: str = None,
        launch_template_version: str = None,
        description: str = None,
        client_token: str = None,
        launch_template_config: List[CreateAutoProvisioningGroupRequestLaunchTemplateConfig] = None,
        system_disk_config: List[CreateAutoProvisioningGroupRequestSystemDiskConfig] = None,
        data_disk_config: List[CreateAutoProvisioningGroupRequestDataDiskConfig] = None,
        min_target_capacity: str = None,
    ):
        self.launch_configuration = launch_configuration
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.owner_account = owner_account
        self.region_id = region_id
        self.resource_group_id = resource_group_id
        self.auto_provisioning_group_name = auto_provisioning_group_name
        self.auto_provisioning_group_type = auto_provisioning_group_type
        self.spot_allocation_strategy = spot_allocation_strategy
        self.spot_instance_interruption_behavior = spot_instance_interruption_behavior
        self.spot_instance_pools_to_use_count = spot_instance_pools_to_use_count
        self.pay_as_you_go_allocation_strategy = pay_as_you_go_allocation_strategy
        self.excess_capacity_termination_policy = excess_capacity_termination_policy
        self.valid_from = valid_from
        self.valid_until = valid_until
        self.terminate_instances_with_expiration = terminate_instances_with_expiration
        self.terminate_instances = terminate_instances
        self.max_spot_price = max_spot_price
        self.total_target_capacity = total_target_capacity
        self.pay_as_you_go_target_capacity = pay_as_you_go_target_capacity
        self.spot_target_capacity = spot_target_capacity
        self.default_target_capacity_type = default_target_capacity_type
        self.launch_template_id = launch_template_id
        self.launch_template_version = launch_template_version
        self.description = description
        self.client_token = client_token
        self.launch_template_config = launch_template_config
        self.system_disk_config = system_disk_config
        self.data_disk_config = data_disk_config
        self.min_target_capacity = min_target_capacity

    def validate(self):
        if self.launch_configuration:
            self.launch_configuration.validate()
        if self.launch_template_config:
            for k in self.launch_template_config:
                if k:
                    k.validate()
        if self.system_disk_config:
            for k in self.system_disk_config:
                if k:
                    k.validate()
        if self.data_disk_config:
            for k in self.data_disk_config:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.launch_configuration is not None:
            result['LaunchConfiguration'] = self.launch_configuration.to_map()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.auto_provisioning_group_name is not None:
            result['AutoProvisioningGroupName'] = self.auto_provisioning_group_name
        if self.auto_provisioning_group_type is not None:
            result['AutoProvisioningGroupType'] = self.auto_provisioning_group_type
        if self.spot_allocation_strategy is not None:
            result['SpotAllocationStrategy'] = self.spot_allocation_strategy
        if self.spot_instance_interruption_behavior is not None:
            result['SpotInstanceInterruptionBehavior'] = self.spot_instance_interruption_behavior
        if self.spot_instance_pools_to_use_count is not None:
            result['SpotInstancePoolsToUseCount'] = self.spot_instance_pools_to_use_count
        if self.pay_as_you_go_allocation_strategy is not None:
            result['PayAsYouGoAllocationStrategy'] = self.pay_as_you_go_allocation_strategy
        if self.excess_capacity_termination_policy is not None:
            result['ExcessCapacityTerminationPolicy'] = self.excess_capacity_termination_policy
        if self.valid_from is not None:
            result['ValidFrom'] = self.valid_from
        if self.valid_until is not None:
            result['ValidUntil'] = self.valid_until
        if self.terminate_instances_with_expiration is not None:
            result['TerminateInstancesWithExpiration'] = self.terminate_instances_with_expiration
        if self.terminate_instances is not None:
            result['TerminateInstances'] = self.terminate_instances
        if self.max_spot_price is not None:
            result['MaxSpotPrice'] = self.max_spot_price
        if self.total_target_capacity is not None:
            result['TotalTargetCapacity'] = self.total_target_capacity
        if self.pay_as_you_go_target_capacity is not None:
            result['PayAsYouGoTargetCapacity'] = self.pay_as_you_go_target_capacity
        if self.spot_target_capacity is not None:
            result['SpotTargetCapacity'] = self.spot_target_capacity
        if self.default_target_capacity_type is not None:
            result['DefaultTargetCapacityType'] = self.default_target_capacity_type
        if self.launch_template_id is not None:
            result['LaunchTemplateId'] = self.launch_template_id
        if self.launch_template_version is not None:
            result['LaunchTemplateVersion'] = self.launch_template_version
        if self.description is not None:
            result['Description'] = self.description
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        result['LaunchTemplateConfig'] = []
        if self.launch_template_config is not None:
            for k in self.launch_template_config:
                result['LaunchTemplateConfig'].append(k.to_map() if k else None)
        result['SystemDiskConfig'] = []
        if self.system_disk_config is not None:
            for k in self.system_disk_config:
                result['SystemDiskConfig'].append(k.to_map() if k else None)
        result['DataDiskConfig'] = []
        if self.data_disk_config is not None:
            for k in self.data_disk_config:
                result['DataDiskConfig'].append(k.to_map() if k else None)
        if self.min_target_capacity is not None:
            result['MinTargetCapacity'] = self.min_target_capacity
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('LaunchConfiguration') is not None:
            temp_model = CreateAutoProvisioningGroupRequestLaunchConfiguration()
            self.launch_configuration = temp_model.from_map(m['LaunchConfiguration'])
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        if m.get('AutoProvisioningGroupName') is not None:
            self.auto_provisioning_group_name = m.get('AutoProvisioningGroupName')
        if m.get('AutoProvisioningGroupType') is not None:
            self.auto_provisioning_group_type = m.get('AutoProvisioningGroupType')
        if m.get('SpotAllocationStrategy') is not None:
            self.spot_allocation_strategy = m.get('SpotAllocationStrategy')
        if m.get('SpotInstanceInterruptionBehavior') is not None:
            self.spot_instance_interruption_behavior = m.get('SpotInstanceInterruptionBehavior')
        if m.get('SpotInstancePoolsToUseCount') is not None:
            self.spot_instance_pools_to_use_count = m.get('SpotInstancePoolsToUseCount')
        if m.get('PayAsYouGoAllocationStrategy') is not None:
            self.pay_as_you_go_allocation_strategy = m.get('PayAsYouGoAllocationStrategy')
        if m.get('ExcessCapacityTerminationPolicy') is not None:
            self.excess_capacity_termination_policy = m.get('ExcessCapacityTerminationPolicy')
        if m.get('ValidFrom') is not None:
            self.valid_from = m.get('ValidFrom')
        if m.get('ValidUntil') is not None:
            self.valid_until = m.get('ValidUntil')
        if m.get('TerminateInstancesWithExpiration') is not None:
            self.terminate_instances_with_expiration = m.get('TerminateInstancesWithExpiration')
        if m.get('TerminateInstances') is not None:
            self.terminate_instances = m.get('TerminateInstances')
        if m.get('MaxSpotPrice') is not None:
            self.max_spot_price = m.get('MaxSpotPrice')
        if m.get('TotalTargetCapacity') is not None:
            self.total_target_capacity = m.get('TotalTargetCapacity')
        if m.get('PayAsYouGoTargetCapacity') is not None:
            self.pay_as_you_go_target_capacity = m.get('PayAsYouGoTargetCapacity')
        if m.get('SpotTargetCapacity') is not None:
            self.spot_target_capacity = m.get('SpotTargetCapacity')
        if m.get('DefaultTargetCapacityType') is not None:
            self.default_target_capacity_type = m.get('DefaultTargetCapacityType')
        if m.get('LaunchTemplateId') is not None:
            self.launch_template_id = m.get('LaunchTemplateId')
        if m.get('LaunchTemplateVersion') is not None:
            self.launch_template_version = m.get('LaunchTemplateVersion')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        self.launch_template_config = []
        if m.get('LaunchTemplateConfig') is not None:
            for k in m.get('LaunchTemplateConfig'):
                temp_model = CreateAutoProvisioningGroupRequestLaunchTemplateConfig()
                self.launch_template_config.append(temp_model.from_map(k))
        self.system_disk_config = []
        if m.get('SystemDiskConfig') is not None:
            for k in m.get('SystemDiskConfig'):
                temp_model = CreateAutoProvisioningGroupRequestSystemDiskConfig()
                self.system_disk_config.append(temp_model.from_map(k))
        self.data_disk_config = []
        if m.get('DataDiskConfig') is not None:
            for k in m.get('DataDiskConfig'):
                temp_model = CreateAutoProvisioningGroupRequestDataDiskConfig()
                self.data_disk_config.append(temp_model.from_map(k))
        if m.get('MinTargetCapacity') is not None:
            self.min_target_capacity = m.get('MinTargetCapacity')
        return self


class CreateAutoProvisioningGroupResponseBodyLaunchResultsLaunchResultInstanceIds(TeaModel):
    def __init__(
        self,
        instance_id: List[str] = None,
    ):
        self.instance_id = instance_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class CreateAutoProvisioningGroupResponseBodyLaunchResultsLaunchResult(TeaModel):
    def __init__(
        self,
        zone_id: str = None,
        error_msg: str = None,
        instance_type: str = None,
        error_code: str = None,
        spot_strategy: str = None,
        instance_ids: CreateAutoProvisioningGroupResponseBodyLaunchResultsLaunchResultInstanceIds = None,
    ):
        self.zone_id = zone_id
        self.error_msg = error_msg
        self.instance_type = instance_type
        self.error_code = error_code
        self.spot_strategy = spot_strategy
        self.instance_ids = instance_ids

    def validate(self):
        if self.instance_ids:
            self.instance_ids.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.zone_id is not None:
            result['ZoneId'] = self.zone_id
        if self.error_msg is not None:
            result['ErrorMsg'] = self.error_msg
        if self.instance_type is not None:
            result['InstanceType'] = self.instance_type
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.spot_strategy is not None:
            result['SpotStrategy'] = self.spot_strategy
        if self.instance_ids is not None:
            result['InstanceIds'] = self.instance_ids.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ZoneId') is not None:
            self.zone_id = m.get('ZoneId')
        if m.get('ErrorMsg') is not None:
            self.error_msg = m.get('ErrorMsg')
        if m.get('InstanceType') is not None:
            self.instance_type = m.get('InstanceType')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('SpotStrategy') is not None:
            self.spot_strategy = m.get('SpotStrategy')
        if m.get('InstanceIds') is not None:
            temp_model = CreateAutoProvisioningGroupResponseBodyLaunchResultsLaunchResultInstanceIds()
            self.instance_ids = temp_model.from_map(m['InstanceIds'])
        return self


class CreateAutoProvisioningGroupResponseBodyLaunchResults(TeaModel):
    def __init__(
        self,
        launch_result: List[CreateAutoProvisioningGroupResponseBodyLaunchResultsLaunchResult] = None,
    ):
        self.launch_result = launch_result

    def validate(self):
        if self.launch_result:
            for k in self.launch_result:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['LaunchResult'] = []
        if self.launch_result is not None:
            for k in self.launch_result:
                result['LaunchResult'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.launch_result = []
        if m.get('LaunchResult') is not None:
            for k in m.get('LaunchResult'):
                temp_model = CreateAutoProvisioningGroupResponseBodyLaunchResultsLaunchResult()
                self.launch_result.append(temp_model.from_map(k))
        return self


class CreateAutoProvisioningGroupResponseBody(TeaModel):
    def __init__(
        self,
        auto_provisioning_group_id: str = None,
        request_id: str = None,
        launch_results: CreateAutoProvisioningGroupResponseBodyLaunchResults = None,
    ):
        self.auto_provisioning_group_id = auto_provisioning_group_id
        self.request_id = request_id
        self.launch_results = launch_results

    def validate(self):
        if self.launch_results:
            self.launch_results.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auto_provisioning_group_id is not None:
            result['AutoProvisioningGroupId'] = self.auto_provisioning_group_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.launch_results is not None:
            result['LaunchResults'] = self.launch_results.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AutoProvisioningGroupId') is not None:
            self.auto_provisioning_group_id = m.get('AutoProvisioningGroupId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('LaunchResults') is not None:
            temp_model = CreateAutoProvisioningGroupResponseBodyLaunchResults()
            self.launch_results = temp_model.from_map(m['LaunchResults'])
        return self


class CreateAutoProvisioningGroupResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CreateAutoProvisioningGroupResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateAutoProvisioningGroupResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateAutoSnapshotPolicyRequestTag(TeaModel):
    def __init__(
        self,
        key: str = None,
        value: str = None,
    ):
        self.key = key
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class CreateAutoSnapshotPolicyRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        region_id: str = None,
        auto_snapshot_policy_name: str = None,
        time_points: str = None,
        repeat_weekdays: str = None,
        retention_days: int = None,
        enable_cross_region_copy: bool = None,
        target_copy_regions: str = None,
        copied_snapshots_retention_days: int = None,
        tag: List[CreateAutoSnapshotPolicyRequestTag] = None,
        resource_group_id: str = None,
    ):
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.region_id = region_id
        self.auto_snapshot_policy_name = auto_snapshot_policy_name
        self.time_points = time_points
        self.repeat_weekdays = repeat_weekdays
        self.retention_days = retention_days
        self.enable_cross_region_copy = enable_cross_region_copy
        self.target_copy_regions = target_copy_regions
        self.copied_snapshots_retention_days = copied_snapshots_retention_days
        self.tag = tag
        self.resource_group_id = resource_group_id

    def validate(self):
        if self.tag:
            for k in self.tag:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['regionId'] = self.region_id
        if self.auto_snapshot_policy_name is not None:
            result['autoSnapshotPolicyName'] = self.auto_snapshot_policy_name
        if self.time_points is not None:
            result['timePoints'] = self.time_points
        if self.repeat_weekdays is not None:
            result['repeatWeekdays'] = self.repeat_weekdays
        if self.retention_days is not None:
            result['retentionDays'] = self.retention_days
        if self.enable_cross_region_copy is not None:
            result['EnableCrossRegionCopy'] = self.enable_cross_region_copy
        if self.target_copy_regions is not None:
            result['TargetCopyRegions'] = self.target_copy_regions
        if self.copied_snapshots_retention_days is not None:
            result['CopiedSnapshotsRetentionDays'] = self.copied_snapshots_retention_days
        result['Tag'] = []
        if self.tag is not None:
            for k in self.tag:
                result['Tag'].append(k.to_map() if k else None)
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('regionId') is not None:
            self.region_id = m.get('regionId')
        if m.get('autoSnapshotPolicyName') is not None:
            self.auto_snapshot_policy_name = m.get('autoSnapshotPolicyName')
        if m.get('timePoints') is not None:
            self.time_points = m.get('timePoints')
        if m.get('repeatWeekdays') is not None:
            self.repeat_weekdays = m.get('repeatWeekdays')
        if m.get('retentionDays') is not None:
            self.retention_days = m.get('retentionDays')
        if m.get('EnableCrossRegionCopy') is not None:
            self.enable_cross_region_copy = m.get('EnableCrossRegionCopy')
        if m.get('TargetCopyRegions') is not None:
            self.target_copy_regions = m.get('TargetCopyRegions')
        if m.get('CopiedSnapshotsRetentionDays') is not None:
            self.copied_snapshots_retention_days = m.get('CopiedSnapshotsRetentionDays')
        self.tag = []
        if m.get('Tag') is not None:
            for k in m.get('Tag'):
                temp_model = CreateAutoSnapshotPolicyRequestTag()
                self.tag.append(temp_model.from_map(k))
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        return self


class CreateAutoSnapshotPolicyResponseBody(TeaModel):
    def __init__(
        self,
        auto_snapshot_policy_id: str = None,
        request_id: str = None,
    ):
        self.auto_snapshot_policy_id = auto_snapshot_policy_id
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auto_snapshot_policy_id is not None:
            result['AutoSnapshotPolicyId'] = self.auto_snapshot_policy_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AutoSnapshotPolicyId') is not None:
            self.auto_snapshot_policy_id = m.get('AutoSnapshotPolicyId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateAutoSnapshotPolicyResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CreateAutoSnapshotPolicyResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateAutoSnapshotPolicyResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateCapacityReservationRequestPrivatePoolOptions(TeaModel):
    def __init__(
        self,
        name: str = None,
        match_criteria: str = None,
    ):
        self.name = name
        self.match_criteria = match_criteria

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['Name'] = self.name
        if self.match_criteria is not None:
            result['MatchCriteria'] = self.match_criteria
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('MatchCriteria') is not None:
            self.match_criteria = m.get('MatchCriteria')
        return self


class CreateCapacityReservationRequestTag(TeaModel):
    def __init__(
        self,
        key: str = None,
        value: str = None,
    ):
        self.key = key
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class CreateCapacityReservationRequest(TeaModel):
    def __init__(
        self,
        private_pool_options: CreateCapacityReservationRequestPrivatePoolOptions = None,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        owner_account: str = None,
        region_id: str = None,
        resource_group_id: str = None,
        tag: List[CreateCapacityReservationRequestTag] = None,
        client_token: str = None,
        description: str = None,
        instance_amount: int = None,
        instance_type: str = None,
        start_time: str = None,
        end_time: str = None,
        end_time_type: str = None,
        platform: str = None,
        zone_id: List[str] = None,
    ):
        self.private_pool_options = private_pool_options
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.owner_account = owner_account
        self.region_id = region_id
        self.resource_group_id = resource_group_id
        self.tag = tag
        self.client_token = client_token
        self.description = description
        self.instance_amount = instance_amount
        self.instance_type = instance_type
        self.start_time = start_time
        self.end_time = end_time
        self.end_time_type = end_time_type
        self.platform = platform
        self.zone_id = zone_id

    def validate(self):
        if self.private_pool_options:
            self.private_pool_options.validate()
        if self.tag:
            for k in self.tag:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.private_pool_options is not None:
            result['PrivatePoolOptions'] = self.private_pool_options.to_map()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        result['Tag'] = []
        if self.tag is not None:
            for k in self.tag:
                result['Tag'].append(k.to_map() if k else None)
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.description is not None:
            result['Description'] = self.description
        if self.instance_amount is not None:
            result['InstanceAmount'] = self.instance_amount
        if self.instance_type is not None:
            result['InstanceType'] = self.instance_type
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.end_time_type is not None:
            result['EndTimeType'] = self.end_time_type
        if self.platform is not None:
            result['Platform'] = self.platform
        if self.zone_id is not None:
            result['ZoneId'] = self.zone_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PrivatePoolOptions') is not None:
            temp_model = CreateCapacityReservationRequestPrivatePoolOptions()
            self.private_pool_options = temp_model.from_map(m['PrivatePoolOptions'])
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        self.tag = []
        if m.get('Tag') is not None:
            for k in m.get('Tag'):
                temp_model = CreateCapacityReservationRequestTag()
                self.tag.append(temp_model.from_map(k))
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('InstanceAmount') is not None:
            self.instance_amount = m.get('InstanceAmount')
        if m.get('InstanceType') is not None:
            self.instance_type = m.get('InstanceType')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('EndTimeType') is not None:
            self.end_time_type = m.get('EndTimeType')
        if m.get('Platform') is not None:
            self.platform = m.get('Platform')
        if m.get('ZoneId') is not None:
            self.zone_id = m.get('ZoneId')
        return self


class CreateCapacityReservationResponseBody(TeaModel):
    def __init__(
        self,
        private_pool_options_id: str = None,
        request_id: str = None,
    ):
        self.private_pool_options_id = private_pool_options_id
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.private_pool_options_id is not None:
            result['PrivatePoolOptionsId'] = self.private_pool_options_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PrivatePoolOptionsId') is not None:
            self.private_pool_options_id = m.get('PrivatePoolOptionsId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateCapacityReservationResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CreateCapacityReservationResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateCapacityReservationResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateCommandRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        owner_account: str = None,
        region_id: str = None,
        name: str = None,
        description: str = None,
        type: str = None,
        command_content: str = None,
        working_dir: str = None,
        timeout: int = None,
        enable_parameter: bool = None,
    ):
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.owner_account = owner_account
        self.region_id = region_id
        self.name = name
        self.description = description
        self.type = type
        self.command_content = command_content
        self.working_dir = working_dir
        self.timeout = timeout
        self.enable_parameter = enable_parameter

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.name is not None:
            result['Name'] = self.name
        if self.description is not None:
            result['Description'] = self.description
        if self.type is not None:
            result['Type'] = self.type
        if self.command_content is not None:
            result['CommandContent'] = self.command_content
        if self.working_dir is not None:
            result['WorkingDir'] = self.working_dir
        if self.timeout is not None:
            result['Timeout'] = self.timeout
        if self.enable_parameter is not None:
            result['EnableParameter'] = self.enable_parameter
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('CommandContent') is not None:
            self.command_content = m.get('CommandContent')
        if m.get('WorkingDir') is not None:
            self.working_dir = m.get('WorkingDir')
        if m.get('Timeout') is not None:
            self.timeout = m.get('Timeout')
        if m.get('EnableParameter') is not None:
            self.enable_parameter = m.get('EnableParameter')
        return self


class CreateCommandResponseBody(TeaModel):
    def __init__(
        self,
        command_id: str = None,
        request_id: str = None,
    ):
        self.command_id = command_id
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.command_id is not None:
            result['CommandId'] = self.command_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CommandId') is not None:
            self.command_id = m.get('CommandId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateCommandResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CreateCommandResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateCommandResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateDedicatedBlockStorageClusterRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        owner_account: str = None,
        region_id: str = None,
        zone_id: str = None,
        dedicated_block_storage_cluster_name: str = None,
        category: str = None,
        capacity: int = None,
        description: str = None,
        performance_level: str = None,
        period: int = None,
        period_unit: str = None,
        from_app: str = None,
        client_token: str = None,
    ):
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.owner_account = owner_account
        self.region_id = region_id
        self.zone_id = zone_id
        self.dedicated_block_storage_cluster_name = dedicated_block_storage_cluster_name
        self.category = category
        self.capacity = capacity
        self.description = description
        self.performance_level = performance_level
        self.period = period
        self.period_unit = period_unit
        self.from_app = from_app
        self.client_token = client_token

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.zone_id is not None:
            result['ZoneId'] = self.zone_id
        if self.dedicated_block_storage_cluster_name is not None:
            result['DedicatedBlockStorageClusterName'] = self.dedicated_block_storage_cluster_name
        if self.category is not None:
            result['Category'] = self.category
        if self.capacity is not None:
            result['Capacity'] = self.capacity
        if self.description is not None:
            result['Description'] = self.description
        if self.performance_level is not None:
            result['PerformanceLevel'] = self.performance_level
        if self.period is not None:
            result['Period'] = self.period
        if self.period_unit is not None:
            result['PeriodUnit'] = self.period_unit
        if self.from_app is not None:
            result['FromApp'] = self.from_app
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ZoneId') is not None:
            self.zone_id = m.get('ZoneId')
        if m.get('DedicatedBlockStorageClusterName') is not None:
            self.dedicated_block_storage_cluster_name = m.get('DedicatedBlockStorageClusterName')
        if m.get('Category') is not None:
            self.category = m.get('Category')
        if m.get('Capacity') is not None:
            self.capacity = m.get('Capacity')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('PerformanceLevel') is not None:
            self.performance_level = m.get('PerformanceLevel')
        if m.get('Period') is not None:
            self.period = m.get('Period')
        if m.get('PeriodUnit') is not None:
            self.period_unit = m.get('PeriodUnit')
        if m.get('FromApp') is not None:
            self.from_app = m.get('FromApp')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        return self


class CreateDedicatedBlockStorageClusterResponseBody(TeaModel):
    def __init__(
        self,
        dedicated_block_storage_cluster_order_id: str = None,
        request_id: str = None,
        dedicated_block_storage_cluster_id: str = None,
    ):
        self.dedicated_block_storage_cluster_order_id = dedicated_block_storage_cluster_order_id
        self.request_id = request_id
        self.dedicated_block_storage_cluster_id = dedicated_block_storage_cluster_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dedicated_block_storage_cluster_order_id is not None:
            result['DedicatedBlockStorageClusterOrderId'] = self.dedicated_block_storage_cluster_order_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.dedicated_block_storage_cluster_id is not None:
            result['DedicatedBlockStorageClusterId'] = self.dedicated_block_storage_cluster_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DedicatedBlockStorageClusterOrderId') is not None:
            self.dedicated_block_storage_cluster_order_id = m.get('DedicatedBlockStorageClusterOrderId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('DedicatedBlockStorageClusterId') is not None:
            self.dedicated_block_storage_cluster_id = m.get('DedicatedBlockStorageClusterId')
        return self


class CreateDedicatedBlockStorageClusterResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CreateDedicatedBlockStorageClusterResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateDedicatedBlockStorageClusterResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateDedicatedHostClusterRequestTag(TeaModel):
    def __init__(
        self,
        key: str = None,
        value: str = None,
    ):
        self.key = key
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class CreateDedicatedHostClusterRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        owner_account: str = None,
        region_id: str = None,
        dry_run: bool = None,
        tag: List[CreateDedicatedHostClusterRequestTag] = None,
        resource_group_id: str = None,
        zone_id: str = None,
        dedicated_host_cluster_name: str = None,
        description: str = None,
    ):
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.owner_account = owner_account
        self.region_id = region_id
        self.dry_run = dry_run
        self.tag = tag
        self.resource_group_id = resource_group_id
        self.zone_id = zone_id
        self.dedicated_host_cluster_name = dedicated_host_cluster_name
        self.description = description

    def validate(self):
        if self.tag:
            for k in self.tag:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.dry_run is not None:
            result['DryRun'] = self.dry_run
        result['Tag'] = []
        if self.tag is not None:
            for k in self.tag:
                result['Tag'].append(k.to_map() if k else None)
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.zone_id is not None:
            result['ZoneId'] = self.zone_id
        if self.dedicated_host_cluster_name is not None:
            result['DedicatedHostClusterName'] = self.dedicated_host_cluster_name
        if self.description is not None:
            result['Description'] = self.description
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('DryRun') is not None:
            self.dry_run = m.get('DryRun')
        self.tag = []
        if m.get('Tag') is not None:
            for k in m.get('Tag'):
                temp_model = CreateDedicatedHostClusterRequestTag()
                self.tag.append(temp_model.from_map(k))
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        if m.get('ZoneId') is not None:
            self.zone_id = m.get('ZoneId')
        if m.get('DedicatedHostClusterName') is not None:
            self.dedicated_host_cluster_name = m.get('DedicatedHostClusterName')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        return self


class CreateDedicatedHostClusterResponseBody(TeaModel):
    def __init__(
        self,
        dedicated_host_cluster_id: str = None,
        request_id: str = None,
    ):
        self.dedicated_host_cluster_id = dedicated_host_cluster_id
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dedicated_host_cluster_id is not None:
            result['DedicatedHostClusterId'] = self.dedicated_host_cluster_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DedicatedHostClusterId') is not None:
            self.dedicated_host_cluster_id = m.get('DedicatedHostClusterId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateDedicatedHostClusterResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CreateDedicatedHostClusterResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateDedicatedHostClusterResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateDemandRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        owner_account: str = None,
        client_token: str = None,
        region_id: str = None,
        zone_id: str = None,
        demand_name: str = None,
        demand_description: str = None,
        instance_type: str = None,
        amount: int = None,
        instance_charge_type: str = None,
        period: int = None,
        period_unit: str = None,
        start_time: str = None,
        end_time: str = None,
    ):
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.owner_account = owner_account
        self.client_token = client_token
        self.region_id = region_id
        self.zone_id = zone_id
        self.demand_name = demand_name
        self.demand_description = demand_description
        self.instance_type = instance_type
        self.amount = amount
        self.instance_charge_type = instance_charge_type
        self.period = period
        self.period_unit = period_unit
        self.start_time = start_time
        self.end_time = end_time

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.zone_id is not None:
            result['ZoneId'] = self.zone_id
        if self.demand_name is not None:
            result['DemandName'] = self.demand_name
        if self.demand_description is not None:
            result['DemandDescription'] = self.demand_description
        if self.instance_type is not None:
            result['InstanceType'] = self.instance_type
        if self.amount is not None:
            result['Amount'] = self.amount
        if self.instance_charge_type is not None:
            result['InstanceChargeType'] = self.instance_charge_type
        if self.period is not None:
            result['Period'] = self.period
        if self.period_unit is not None:
            result['PeriodUnit'] = self.period_unit
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ZoneId') is not None:
            self.zone_id = m.get('ZoneId')
        if m.get('DemandName') is not None:
            self.demand_name = m.get('DemandName')
        if m.get('DemandDescription') is not None:
            self.demand_description = m.get('DemandDescription')
        if m.get('InstanceType') is not None:
            self.instance_type = m.get('InstanceType')
        if m.get('Amount') is not None:
            self.amount = m.get('Amount')
        if m.get('InstanceChargeType') is not None:
            self.instance_charge_type = m.get('InstanceChargeType')
        if m.get('Period') is not None:
            self.period = m.get('Period')
        if m.get('PeriodUnit') is not None:
            self.period_unit = m.get('PeriodUnit')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        return self


class CreateDemandResponseBody(TeaModel):
    def __init__(
        self,
        demand_id: str = None,
        request_id: str = None,
    ):
        self.demand_id = demand_id
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.demand_id is not None:
            result['DemandId'] = self.demand_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DemandId') is not None:
            self.demand_id = m.get('DemandId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateDemandResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CreateDemandResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateDemandResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateDeploymentSetRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        region_id: str = None,
        on_unable_to_redeploy_failed_instance: str = None,
        description: str = None,
        client_token: str = None,
        deployment_set_name: str = None,
        domain: str = None,
        granularity: str = None,
        strategy: str = None,
        group_count: int = None,
        owner_account: str = None,
    ):
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.region_id = region_id
        self.on_unable_to_redeploy_failed_instance = on_unable_to_redeploy_failed_instance
        self.description = description
        self.client_token = client_token
        self.deployment_set_name = deployment_set_name
        self.domain = domain
        self.granularity = granularity
        self.strategy = strategy
        self.group_count = group_count
        self.owner_account = owner_account

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.on_unable_to_redeploy_failed_instance is not None:
            result['OnUnableToRedeployFailedInstance'] = self.on_unable_to_redeploy_failed_instance
        if self.description is not None:
            result['Description'] = self.description
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.deployment_set_name is not None:
            result['DeploymentSetName'] = self.deployment_set_name
        if self.domain is not None:
            result['Domain'] = self.domain
        if self.granularity is not None:
            result['Granularity'] = self.granularity
        if self.strategy is not None:
            result['Strategy'] = self.strategy
        if self.group_count is not None:
            result['GroupCount'] = self.group_count
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('OnUnableToRedeployFailedInstance') is not None:
            self.on_unable_to_redeploy_failed_instance = m.get('OnUnableToRedeployFailedInstance')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('DeploymentSetName') is not None:
            self.deployment_set_name = m.get('DeploymentSetName')
        if m.get('Domain') is not None:
            self.domain = m.get('Domain')
        if m.get('Granularity') is not None:
            self.granularity = m.get('Granularity')
        if m.get('Strategy') is not None:
            self.strategy = m.get('Strategy')
        if m.get('GroupCount') is not None:
            self.group_count = m.get('GroupCount')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        return self


class CreateDeploymentSetResponseBody(TeaModel):
    def __init__(
        self,
        deployment_set_id: str = None,
        request_id: str = None,
    ):
        self.deployment_set_id = deployment_set_id
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.deployment_set_id is not None:
            result['DeploymentSetId'] = self.deployment_set_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DeploymentSetId') is not None:
            self.deployment_set_id = m.get('DeploymentSetId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateDeploymentSetResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CreateDeploymentSetResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateDeploymentSetResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateDiskRequestTag(TeaModel):
    def __init__(
        self,
        key: str = None,
        value: str = None,
    ):
        self.key = key
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('key') is not None:
            self.key = m.get('key')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class CreateDiskRequestArn(TeaModel):
    def __init__(
        self,
        role_type: str = None,
        rolearn: str = None,
        assume_role_for: int = None,
    ):
        self.role_type = role_type
        self.rolearn = rolearn
        self.assume_role_for = assume_role_for

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.role_type is not None:
            result['RoleType'] = self.role_type
        if self.rolearn is not None:
            result['Rolearn'] = self.rolearn
        if self.assume_role_for is not None:
            result['AssumeRoleFor'] = self.assume_role_for
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RoleType') is not None:
            self.role_type = m.get('RoleType')
        if m.get('Rolearn') is not None:
            self.rolearn = m.get('Rolearn')
        if m.get('AssumeRoleFor') is not None:
            self.assume_role_for = m.get('AssumeRoleFor')
        return self


class CreateDiskRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        region_id: str = None,
        zone_id: str = None,
        snapshot_id: str = None,
        disk_name: str = None,
        size: int = None,
        disk_category: str = None,
        description: str = None,
        encrypted: bool = None,
        client_token: str = None,
        owner_account: str = None,
        instance_id: str = None,
        resource_group_id: str = None,
        kmskey_id: str = None,
        performance_level: str = None,
        advanced_features: str = None,
        storage_set_id: str = None,
        encrypt_algorithm: str = None,
        storage_set_partition_number: int = None,
        dedicated_block_storage_cluster_id: str = None,
        multi_attach: str = None,
        tag: List[CreateDiskRequestTag] = None,
        arn: List[CreateDiskRequestArn] = None,
    ):
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.region_id = region_id
        self.zone_id = zone_id
        self.snapshot_id = snapshot_id
        self.disk_name = disk_name
        self.size = size
        self.disk_category = disk_category
        self.description = description
        self.encrypted = encrypted
        self.client_token = client_token
        self.owner_account = owner_account
        self.instance_id = instance_id
        self.resource_group_id = resource_group_id
        self.kmskey_id = kmskey_id
        self.performance_level = performance_level
        self.advanced_features = advanced_features
        self.storage_set_id = storage_set_id
        self.encrypt_algorithm = encrypt_algorithm
        self.storage_set_partition_number = storage_set_partition_number
        self.dedicated_block_storage_cluster_id = dedicated_block_storage_cluster_id
        self.multi_attach = multi_attach
        self.tag = tag
        self.arn = arn

    def validate(self):
        if self.tag:
            for k in self.tag:
                if k:
                    k.validate()
        if self.arn:
            for k in self.arn:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.zone_id is not None:
            result['ZoneId'] = self.zone_id
        if self.snapshot_id is not None:
            result['SnapshotId'] = self.snapshot_id
        if self.disk_name is not None:
            result['DiskName'] = self.disk_name
        if self.size is not None:
            result['Size'] = self.size
        if self.disk_category is not None:
            result['DiskCategory'] = self.disk_category
        if self.description is not None:
            result['Description'] = self.description
        if self.encrypted is not None:
            result['Encrypted'] = self.encrypted
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.kmskey_id is not None:
            result['KMSKeyId'] = self.kmskey_id
        if self.performance_level is not None:
            result['PerformanceLevel'] = self.performance_level
        if self.advanced_features is not None:
            result['AdvancedFeatures'] = self.advanced_features
        if self.storage_set_id is not None:
            result['StorageSetId'] = self.storage_set_id
        if self.encrypt_algorithm is not None:
            result['EncryptAlgorithm'] = self.encrypt_algorithm
        if self.storage_set_partition_number is not None:
            result['StorageSetPartitionNumber'] = self.storage_set_partition_number
        if self.dedicated_block_storage_cluster_id is not None:
            result['DedicatedBlockStorageClusterId'] = self.dedicated_block_storage_cluster_id
        if self.multi_attach is not None:
            result['MultiAttach'] = self.multi_attach
        result['Tag'] = []
        if self.tag is not None:
            for k in self.tag:
                result['Tag'].append(k.to_map() if k else None)
        result['Arn'] = []
        if self.arn is not None:
            for k in self.arn:
                result['Arn'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ZoneId') is not None:
            self.zone_id = m.get('ZoneId')
        if m.get('SnapshotId') is not None:
            self.snapshot_id = m.get('SnapshotId')
        if m.get('DiskName') is not None:
            self.disk_name = m.get('DiskName')
        if m.get('Size') is not None:
            self.size = m.get('Size')
        if m.get('DiskCategory') is not None:
            self.disk_category = m.get('DiskCategory')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('Encrypted') is not None:
            self.encrypted = m.get('Encrypted')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        if m.get('KMSKeyId') is not None:
            self.kmskey_id = m.get('KMSKeyId')
        if m.get('PerformanceLevel') is not None:
            self.performance_level = m.get('PerformanceLevel')
        if m.get('AdvancedFeatures') is not None:
            self.advanced_features = m.get('AdvancedFeatures')
        if m.get('StorageSetId') is not None:
            self.storage_set_id = m.get('StorageSetId')
        if m.get('EncryptAlgorithm') is not None:
            self.encrypt_algorithm = m.get('EncryptAlgorithm')
        if m.get('StorageSetPartitionNumber') is not None:
            self.storage_set_partition_number = m.get('StorageSetPartitionNumber')
        if m.get('DedicatedBlockStorageClusterId') is not None:
            self.dedicated_block_storage_cluster_id = m.get('DedicatedBlockStorageClusterId')
        if m.get('MultiAttach') is not None:
            self.multi_attach = m.get('MultiAttach')
        self.tag = []
        if m.get('Tag') is not None:
            for k in m.get('Tag'):
                temp_model = CreateDiskRequestTag()
                self.tag.append(temp_model.from_map(k))
        self.arn = []
        if m.get('Arn') is not None:
            for k in m.get('Arn'):
                temp_model = CreateDiskRequestArn()
                self.arn.append(temp_model.from_map(k))
        return self


class CreateDiskResponseBody(TeaModel):
    def __init__(
        self,
        disk_id: str = None,
        request_id: str = None,
        order_id: str = None,
    ):
        self.disk_id = disk_id
        self.request_id = request_id
        self.order_id = order_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.disk_id is not None:
            result['DiskId'] = self.disk_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.order_id is not None:
            result['OrderId'] = self.order_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DiskId') is not None:
            self.disk_id = m.get('DiskId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('OrderId') is not None:
            self.order_id = m.get('OrderId')
        return self


class CreateDiskResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CreateDiskResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateDiskResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateDiskReplicaPairRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        owner_account: str = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        region_id: str = None,
        disk_id: str = None,
        destination_region_id: str = None,
        destination_disk_id: str = None,
        pair_name: str = None,
        description: str = None,
        async_cycle: int = None,
    ):
        self.owner_id = owner_id
        self.owner_account = owner_account
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.region_id = region_id
        self.disk_id = disk_id
        self.destination_region_id = destination_region_id
        self.destination_disk_id = destination_disk_id
        self.pair_name = pair_name
        self.description = description
        self.async_cycle = async_cycle

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.disk_id is not None:
            result['DiskId'] = self.disk_id
        if self.destination_region_id is not None:
            result['DestinationRegionId'] = self.destination_region_id
        if self.destination_disk_id is not None:
            result['DestinationDiskId'] = self.destination_disk_id
        if self.pair_name is not None:
            result['PairName'] = self.pair_name
        if self.description is not None:
            result['Description'] = self.description
        if self.async_cycle is not None:
            result['AsyncCycle'] = self.async_cycle
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('DiskId') is not None:
            self.disk_id = m.get('DiskId')
        if m.get('DestinationRegionId') is not None:
            self.destination_region_id = m.get('DestinationRegionId')
        if m.get('DestinationDiskId') is not None:
            self.destination_disk_id = m.get('DestinationDiskId')
        if m.get('PairName') is not None:
            self.pair_name = m.get('PairName')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('AsyncCycle') is not None:
            self.async_cycle = m.get('AsyncCycle')
        return self


class CreateDiskReplicaPairResponseBody(TeaModel):
    def __init__(
        self,
        pair_id: str = None,
        request_id: str = None,
    ):
        self.pair_id = pair_id
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.pair_id is not None:
            result['PairId'] = self.pair_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PairId') is not None:
            self.pair_id = m.get('PairId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateDiskReplicaPairResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CreateDiskReplicaPairResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateDiskReplicaPairResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateElasticityAssuranceRequestPrivatePoolOptions(TeaModel):
    def __init__(
        self,
        name: str = None,
        match_criteria: str = None,
    ):
        self.name = name
        self.match_criteria = match_criteria

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['Name'] = self.name
        if self.match_criteria is not None:
            result['MatchCriteria'] = self.match_criteria
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('MatchCriteria') is not None:
            self.match_criteria = m.get('MatchCriteria')
        return self


class CreateElasticityAssuranceRequestTag(TeaModel):
    def __init__(
        self,
        key: str = None,
        value: str = None,
    ):
        self.key = key
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class CreateElasticityAssuranceRequest(TeaModel):
    def __init__(
        self,
        private_pool_options: CreateElasticityAssuranceRequestPrivatePoolOptions = None,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        owner_account: str = None,
        region_id: str = None,
        resource_group_id: str = None,
        tag: List[CreateElasticityAssuranceRequestTag] = None,
        period: int = None,
        period_unit: str = None,
        client_token: str = None,
        description: str = None,
        assurance_times: str = None,
        instance_amount: int = None,
        instance_cpu_core_count: int = None,
        start_time: str = None,
        zone_id: List[str] = None,
        instance_type: List[str] = None,
    ):
        self.private_pool_options = private_pool_options
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.owner_account = owner_account
        self.region_id = region_id
        self.resource_group_id = resource_group_id
        self.tag = tag
        self.period = period
        self.period_unit = period_unit
        self.client_token = client_token
        self.description = description
        self.assurance_times = assurance_times
        self.instance_amount = instance_amount
        self.instance_cpu_core_count = instance_cpu_core_count
        self.start_time = start_time
        self.zone_id = zone_id
        self.instance_type = instance_type

    def validate(self):
        if self.private_pool_options:
            self.private_pool_options.validate()
        if self.tag:
            for k in self.tag:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.private_pool_options is not None:
            result['PrivatePoolOptions'] = self.private_pool_options.to_map()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        result['Tag'] = []
        if self.tag is not None:
            for k in self.tag:
                result['Tag'].append(k.to_map() if k else None)
        if self.period is not None:
            result['Period'] = self.period
        if self.period_unit is not None:
            result['PeriodUnit'] = self.period_unit
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.description is not None:
            result['Description'] = self.description
        if self.assurance_times is not None:
            result['AssuranceTimes'] = self.assurance_times
        if self.instance_amount is not None:
            result['InstanceAmount'] = self.instance_amount
        if self.instance_cpu_core_count is not None:
            result['InstanceCpuCoreCount'] = self.instance_cpu_core_count
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.zone_id is not None:
            result['ZoneId'] = self.zone_id
        if self.instance_type is not None:
            result['InstanceType'] = self.instance_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PrivatePoolOptions') is not None:
            temp_model = CreateElasticityAssuranceRequestPrivatePoolOptions()
            self.private_pool_options = temp_model.from_map(m['PrivatePoolOptions'])
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        self.tag = []
        if m.get('Tag') is not None:
            for k in m.get('Tag'):
                temp_model = CreateElasticityAssuranceRequestTag()
                self.tag.append(temp_model.from_map(k))
        if m.get('Period') is not None:
            self.period = m.get('Period')
        if m.get('PeriodUnit') is not None:
            self.period_unit = m.get('PeriodUnit')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('AssuranceTimes') is not None:
            self.assurance_times = m.get('AssuranceTimes')
        if m.get('InstanceAmount') is not None:
            self.instance_amount = m.get('InstanceAmount')
        if m.get('InstanceCpuCoreCount') is not None:
            self.instance_cpu_core_count = m.get('InstanceCpuCoreCount')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('ZoneId') is not None:
            self.zone_id = m.get('ZoneId')
        if m.get('InstanceType') is not None:
            self.instance_type = m.get('InstanceType')
        return self


class CreateElasticityAssuranceResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        private_pool_options_id: str = None,
        order_id: str = None,
    ):
        self.request_id = request_id
        self.private_pool_options_id = private_pool_options_id
        self.order_id = order_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.private_pool_options_id is not None:
            result['PrivatePoolOptionsId'] = self.private_pool_options_id
        if self.order_id is not None:
            result['OrderId'] = self.order_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('PrivatePoolOptionsId') is not None:
            self.private_pool_options_id = m.get('PrivatePoolOptionsId')
        if m.get('OrderId') is not None:
            self.order_id = m.get('OrderId')
        return self


class CreateElasticityAssuranceResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CreateElasticityAssuranceResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateElasticityAssuranceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateForwardEntryRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        owner_account: str = None,
        region_id: str = None,
        forward_table_id: str = None,
        external_ip: str = None,
        external_port: str = None,
        internal_ip: str = None,
        internal_port: str = None,
        ip_protocol: str = None,
    ):
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.owner_account = owner_account
        self.region_id = region_id
        self.forward_table_id = forward_table_id
        self.external_ip = external_ip
        self.external_port = external_port
        self.internal_ip = internal_ip
        self.internal_port = internal_port
        self.ip_protocol = ip_protocol

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.forward_table_id is not None:
            result['ForwardTableId'] = self.forward_table_id
        if self.external_ip is not None:
            result['ExternalIp'] = self.external_ip
        if self.external_port is not None:
            result['ExternalPort'] = self.external_port
        if self.internal_ip is not None:
            result['InternalIp'] = self.internal_ip
        if self.internal_port is not None:
            result['InternalPort'] = self.internal_port
        if self.ip_protocol is not None:
            result['IpProtocol'] = self.ip_protocol
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ForwardTableId') is not None:
            self.forward_table_id = m.get('ForwardTableId')
        if m.get('ExternalIp') is not None:
            self.external_ip = m.get('ExternalIp')
        if m.get('ExternalPort') is not None:
            self.external_port = m.get('ExternalPort')
        if m.get('InternalIp') is not None:
            self.internal_ip = m.get('InternalIp')
        if m.get('InternalPort') is not None:
            self.internal_port = m.get('InternalPort')
        if m.get('IpProtocol') is not None:
            self.ip_protocol = m.get('IpProtocol')
        return self


class CreateForwardEntryResponseBody(TeaModel):
    def __init__(
        self,
        forward_entry_id: str = None,
        request_id: str = None,
    ):
        self.forward_entry_id = forward_entry_id
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.forward_entry_id is not None:
            result['ForwardEntryId'] = self.forward_entry_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ForwardEntryId') is not None:
            self.forward_entry_id = m.get('ForwardEntryId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateForwardEntryResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CreateForwardEntryResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateForwardEntryResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateHaVipRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        owner_account: str = None,
        client_token: str = None,
        region_id: str = None,
        v_switch_id: str = None,
        ip_address: str = None,
        description: str = None,
    ):
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.owner_account = owner_account
        self.client_token = client_token
        self.region_id = region_id
        self.v_switch_id = v_switch_id
        self.ip_address = ip_address
        self.description = description

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.v_switch_id is not None:
            result['VSwitchId'] = self.v_switch_id
        if self.ip_address is not None:
            result['IpAddress'] = self.ip_address
        if self.description is not None:
            result['Description'] = self.description
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('VSwitchId') is not None:
            self.v_switch_id = m.get('VSwitchId')
        if m.get('IpAddress') is not None:
            self.ip_address = m.get('IpAddress')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        return self


class CreateHaVipResponseBody(TeaModel):
    def __init__(
        self,
        ha_vip_id: str = None,
        request_id: str = None,
    ):
        self.ha_vip_id = ha_vip_id
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ha_vip_id is not None:
            result['HaVipId'] = self.ha_vip_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('HaVipId') is not None:
            self.ha_vip_id = m.get('HaVipId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateHaVipResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CreateHaVipResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateHaVipResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateHpcClusterRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        region_id: str = None,
        client_token: str = None,
        owner_account: str = None,
        description: str = None,
        name: str = None,
    ):
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.region_id = region_id
        self.client_token = client_token
        self.owner_account = owner_account
        self.description = description
        self.name = name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.description is not None:
            result['Description'] = self.description
        if self.name is not None:
            result['Name'] = self.name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        return self


class CreateHpcClusterResponseBody(TeaModel):
    def __init__(
        self,
        hpc_cluster_id: str = None,
        request_id: str = None,
    ):
        self.hpc_cluster_id = hpc_cluster_id
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.hpc_cluster_id is not None:
            result['HpcClusterId'] = self.hpc_cluster_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('HpcClusterId') is not None:
            self.hpc_cluster_id = m.get('HpcClusterId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateHpcClusterResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CreateHpcClusterResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateHpcClusterResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateImageRequestDiskDeviceMapping(TeaModel):
    def __init__(
        self,
        snapshot_id: str = None,
        size: int = None,
        device: str = None,
        disk_type: str = None,
    ):
        self.snapshot_id = snapshot_id
        self.size = size
        self.device = device
        self.disk_type = disk_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.snapshot_id is not None:
            result['SnapshotId'] = self.snapshot_id
        if self.size is not None:
            result['Size'] = self.size
        if self.device is not None:
            result['Device'] = self.device
        if self.disk_type is not None:
            result['DiskType'] = self.disk_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('SnapshotId') is not None:
            self.snapshot_id = m.get('SnapshotId')
        if m.get('Size') is not None:
            self.size = m.get('Size')
        if m.get('Device') is not None:
            self.device = m.get('Device')
        if m.get('DiskType') is not None:
            self.disk_type = m.get('DiskType')
        return self


class CreateImageRequestTag(TeaModel):
    def __init__(
        self,
        key: str = None,
        value: str = None,
    ):
        self.key = key
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('key') is not None:
            self.key = m.get('key')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class CreateImageRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        region_id: str = None,
        snapshot_id: str = None,
        instance_id: str = None,
        image_name: str = None,
        image_family: str = None,
        image_version: str = None,
        description: str = None,
        platform: str = None,
        architecture: str = None,
        client_token: str = None,
        owner_account: str = None,
        resource_group_id: str = None,
        disk_device_mapping: List[CreateImageRequestDiskDeviceMapping] = None,
        tag: List[CreateImageRequestTag] = None,
    ):
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.region_id = region_id
        self.snapshot_id = snapshot_id
        self.instance_id = instance_id
        self.image_name = image_name
        self.image_family = image_family
        self.image_version = image_version
        self.description = description
        self.platform = platform
        self.architecture = architecture
        self.client_token = client_token
        self.owner_account = owner_account
        self.resource_group_id = resource_group_id
        self.disk_device_mapping = disk_device_mapping
        self.tag = tag

    def validate(self):
        if self.disk_device_mapping:
            for k in self.disk_device_mapping:
                if k:
                    k.validate()
        if self.tag:
            for k in self.tag:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.snapshot_id is not None:
            result['SnapshotId'] = self.snapshot_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.image_name is not None:
            result['ImageName'] = self.image_name
        if self.image_family is not None:
            result['ImageFamily'] = self.image_family
        if self.image_version is not None:
            result['ImageVersion'] = self.image_version
        if self.description is not None:
            result['Description'] = self.description
        if self.platform is not None:
            result['Platform'] = self.platform
        if self.architecture is not None:
            result['Architecture'] = self.architecture
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        result['DiskDeviceMapping'] = []
        if self.disk_device_mapping is not None:
            for k in self.disk_device_mapping:
                result['DiskDeviceMapping'].append(k.to_map() if k else None)
        result['Tag'] = []
        if self.tag is not None:
            for k in self.tag:
                result['Tag'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('SnapshotId') is not None:
            self.snapshot_id = m.get('SnapshotId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('ImageName') is not None:
            self.image_name = m.get('ImageName')
        if m.get('ImageFamily') is not None:
            self.image_family = m.get('ImageFamily')
        if m.get('ImageVersion') is not None:
            self.image_version = m.get('ImageVersion')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('Platform') is not None:
            self.platform = m.get('Platform')
        if m.get('Architecture') is not None:
            self.architecture = m.get('Architecture')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        self.disk_device_mapping = []
        if m.get('DiskDeviceMapping') is not None:
            for k in m.get('DiskDeviceMapping'):
                temp_model = CreateImageRequestDiskDeviceMapping()
                self.disk_device_mapping.append(temp_model.from_map(k))
        self.tag = []
        if m.get('Tag') is not None:
            for k in m.get('Tag'):
                temp_model = CreateImageRequestTag()
                self.tag.append(temp_model.from_map(k))
        return self


class CreateImageResponseBody(TeaModel):
    def __init__(
        self,
        image_id: str = None,
        request_id: str = None,
    ):
        self.image_id = image_id
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.image_id is not None:
            result['ImageId'] = self.image_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ImageId') is not None:
            self.image_id = m.get('ImageId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateImageResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CreateImageResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateImageResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateImageComponentRequestTag(TeaModel):
    def __init__(
        self,
        key: str = None,
        value: str = None,
    ):
        self.key = key
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class CreateImageComponentRequest(TeaModel):
    def __init__(
        self,
        tag: List[CreateImageComponentRequestTag] = None,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        owner_account: str = None,
        region_id: str = None,
        resource_group_id: str = None,
        name: str = None,
        description: str = None,
        system_type: str = None,
        component_type: str = None,
        content: str = None,
        client_token: str = None,
    ):
        self.tag = tag
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.owner_account = owner_account
        self.region_id = region_id
        self.resource_group_id = resource_group_id
        self.name = name
        self.description = description
        self.system_type = system_type
        self.component_type = component_type
        self.content = content
        self.client_token = client_token

    def validate(self):
        if self.tag:
            for k in self.tag:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Tag'] = []
        if self.tag is not None:
            for k in self.tag:
                result['Tag'].append(k.to_map() if k else None)
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.name is not None:
            result['Name'] = self.name
        if self.description is not None:
            result['Description'] = self.description
        if self.system_type is not None:
            result['SystemType'] = self.system_type
        if self.component_type is not None:
            result['ComponentType'] = self.component_type
        if self.content is not None:
            result['Content'] = self.content
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.tag = []
        if m.get('Tag') is not None:
            for k in m.get('Tag'):
                temp_model = CreateImageComponentRequestTag()
                self.tag.append(temp_model.from_map(k))
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('SystemType') is not None:
            self.system_type = m.get('SystemType')
        if m.get('ComponentType') is not None:
            self.component_type = m.get('ComponentType')
        if m.get('Content') is not None:
            self.content = m.get('Content')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        return self


class CreateImageComponentResponseBody(TeaModel):
    def __init__(
        self,
        image_component_id: str = None,
        request_id: str = None,
    ):
        self.image_component_id = image_component_id
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.image_component_id is not None:
            result['ImageComponentId'] = self.image_component_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ImageComponentId') is not None:
            self.image_component_id = m.get('ImageComponentId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateImageComponentResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CreateImageComponentResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateImageComponentResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateImagePipelineRequestTag(TeaModel):
    def __init__(
        self,
        key: str = None,
        value: str = None,
    ):
        self.key = key
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class CreateImagePipelineRequest(TeaModel):
    def __init__(
        self,
        tag: List[CreateImagePipelineRequestTag] = None,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        owner_account: str = None,
        region_id: str = None,
        resource_group_id: str = None,
        add_account: List[int] = None,
        to_region_id: List[str] = None,
        base_image_type: str = None,
        base_image: str = None,
        name: str = None,
        description: str = None,
        image_name: str = None,
        v_switch_id: str = None,
        instance_type: str = None,
        system_disk_size: int = None,
        internet_max_bandwidth_out: int = None,
        delete_instance_on_failure: bool = None,
        build_content: str = None,
        client_token: str = None,
    ):
        self.tag = tag
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.owner_account = owner_account
        self.region_id = region_id
        self.resource_group_id = resource_group_id
        self.add_account = add_account
        self.to_region_id = to_region_id
        self.base_image_type = base_image_type
        self.base_image = base_image
        self.name = name
        self.description = description
        self.image_name = image_name
        self.v_switch_id = v_switch_id
        self.instance_type = instance_type
        self.system_disk_size = system_disk_size
        self.internet_max_bandwidth_out = internet_max_bandwidth_out
        self.delete_instance_on_failure = delete_instance_on_failure
        self.build_content = build_content
        self.client_token = client_token

    def validate(self):
        if self.tag:
            for k in self.tag:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Tag'] = []
        if self.tag is not None:
            for k in self.tag:
                result['Tag'].append(k.to_map() if k else None)
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.add_account is not None:
            result['AddAccount'] = self.add_account
        if self.to_region_id is not None:
            result['ToRegionId'] = self.to_region_id
        if self.base_image_type is not None:
            result['BaseImageType'] = self.base_image_type
        if self.base_image is not None:
            result['BaseImage'] = self.base_image
        if self.name is not None:
            result['Name'] = self.name
        if self.description is not None:
            result['Description'] = self.description
        if self.image_name is not None:
            result['ImageName'] = self.image_name
        if self.v_switch_id is not None:
            result['VSwitchId'] = self.v_switch_id
        if self.instance_type is not None:
            result['InstanceType'] = self.instance_type
        if self.system_disk_size is not None:
            result['SystemDiskSize'] = self.system_disk_size
        if self.internet_max_bandwidth_out is not None:
            result['InternetMaxBandwidthOut'] = self.internet_max_bandwidth_out
        if self.delete_instance_on_failure is not None:
            result['DeleteInstanceOnFailure'] = self.delete_instance_on_failure
        if self.build_content is not None:
            result['BuildContent'] = self.build_content
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.tag = []
        if m.get('Tag') is not None:
            for k in m.get('Tag'):
                temp_model = CreateImagePipelineRequestTag()
                self.tag.append(temp_model.from_map(k))
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        if m.get('AddAccount') is not None:
            self.add_account = m.get('AddAccount')
        if m.get('ToRegionId') is not None:
            self.to_region_id = m.get('ToRegionId')
        if m.get('BaseImageType') is not None:
            self.base_image_type = m.get('BaseImageType')
        if m.get('BaseImage') is not None:
            self.base_image = m.get('BaseImage')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('ImageName') is not None:
            self.image_name = m.get('ImageName')
        if m.get('VSwitchId') is not None:
            self.v_switch_id = m.get('VSwitchId')
        if m.get('InstanceType') is not None:
            self.instance_type = m.get('InstanceType')
        if m.get('SystemDiskSize') is not None:
            self.system_disk_size = m.get('SystemDiskSize')
        if m.get('InternetMaxBandwidthOut') is not None:
            self.internet_max_bandwidth_out = m.get('InternetMaxBandwidthOut')
        if m.get('DeleteInstanceOnFailure') is not None:
            self.delete_instance_on_failure = m.get('DeleteInstanceOnFailure')
        if m.get('BuildContent') is not None:
            self.build_content = m.get('BuildContent')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        return self


class CreateImagePipelineResponseBody(TeaModel):
    def __init__(
        self,
        image_pipeline_id: str = None,
        request_id: str = None,
    ):
        self.image_pipeline_id = image_pipeline_id
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.image_pipeline_id is not None:
            result['ImagePipelineId'] = self.image_pipeline_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ImagePipelineId') is not None:
            self.image_pipeline_id = m.get('ImagePipelineId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateImagePipelineResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CreateImagePipelineResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateImagePipelineResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateInstanceRequestSystemDisk(TeaModel):
    def __init__(
        self,
        size: int = None,
        category: str = None,
        disk_name: str = None,
        description: str = None,
        performance_level: str = None,
    ):
        self.size = size
        self.category = category
        self.disk_name = disk_name
        self.description = description
        self.performance_level = performance_level

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.size is not None:
            result['Size'] = self.size
        if self.category is not None:
            result['Category'] = self.category
        if self.disk_name is not None:
            result['DiskName'] = self.disk_name
        if self.description is not None:
            result['Description'] = self.description
        if self.performance_level is not None:
            result['PerformanceLevel'] = self.performance_level
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Size') is not None:
            self.size = m.get('Size')
        if m.get('Category') is not None:
            self.category = m.get('Category')
        if m.get('DiskName') is not None:
            self.disk_name = m.get('DiskName')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('PerformanceLevel') is not None:
            self.performance_level = m.get('PerformanceLevel')
        return self


class CreateInstanceRequestHibernationOptions(TeaModel):
    def __init__(
        self,
        configured: bool = None,
    ):
        self.configured = configured

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.configured is not None:
            result['Configured'] = self.configured
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Configured') is not None:
            self.configured = m.get('Configured')
        return self


class CreateInstanceRequestPrivatePoolOptions(TeaModel):
    def __init__(
        self,
        match_criteria: str = None,
        id: str = None,
    ):
        self.match_criteria = match_criteria
        self.id = id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.match_criteria is not None:
            result['MatchCriteria'] = self.match_criteria
        if self.id is not None:
            result['Id'] = self.id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('MatchCriteria') is not None:
            self.match_criteria = m.get('MatchCriteria')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        return self


class CreateInstanceRequestDataDisk(TeaModel):
    def __init__(
        self,
        performance_level: str = None,
        description: str = None,
        snapshot_id: str = None,
        size: int = None,
        device: str = None,
        disk_name: str = None,
        category: str = None,
        delete_with_instance: bool = None,
        kmskey_id: str = None,
        encrypt_algorithm: str = None,
        encrypted: bool = None,
    ):
        self.performance_level = performance_level
        self.description = description
        self.snapshot_id = snapshot_id
        self.size = size
        self.device = device
        self.disk_name = disk_name
        self.category = category
        self.delete_with_instance = delete_with_instance
        self.kmskey_id = kmskey_id
        self.encrypt_algorithm = encrypt_algorithm
        self.encrypted = encrypted

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.performance_level is not None:
            result['PerformanceLevel'] = self.performance_level
        if self.description is not None:
            result['Description'] = self.description
        if self.snapshot_id is not None:
            result['SnapshotId'] = self.snapshot_id
        if self.size is not None:
            result['Size'] = self.size
        if self.device is not None:
            result['Device'] = self.device
        if self.disk_name is not None:
            result['DiskName'] = self.disk_name
        if self.category is not None:
            result['Category'] = self.category
        if self.delete_with_instance is not None:
            result['DeleteWithInstance'] = self.delete_with_instance
        if self.kmskey_id is not None:
            result['KMSKeyId'] = self.kmskey_id
        if self.encrypt_algorithm is not None:
            result['EncryptAlgorithm'] = self.encrypt_algorithm
        if self.encrypted is not None:
            result['Encrypted'] = self.encrypted
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PerformanceLevel') is not None:
            self.performance_level = m.get('PerformanceLevel')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('SnapshotId') is not None:
            self.snapshot_id = m.get('SnapshotId')
        if m.get('Size') is not None:
            self.size = m.get('Size')
        if m.get('Device') is not None:
            self.device = m.get('Device')
        if m.get('DiskName') is not None:
            self.disk_name = m.get('DiskName')
        if m.get('Category') is not None:
            self.category = m.get('Category')
        if m.get('DeleteWithInstance') is not None:
            self.delete_with_instance = m.get('DeleteWithInstance')
        if m.get('KMSKeyId') is not None:
            self.kmskey_id = m.get('KMSKeyId')
        if m.get('EncryptAlgorithm') is not None:
            self.encrypt_algorithm = m.get('EncryptAlgorithm')
        if m.get('Encrypted') is not None:
            self.encrypted = m.get('Encrypted')
        return self


class CreateInstanceRequestArn(TeaModel):
    def __init__(
        self,
        role_type: str = None,
        rolearn: str = None,
        assume_role_for: int = None,
    ):
        self.role_type = role_type
        self.rolearn = rolearn
        self.assume_role_for = assume_role_for

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.role_type is not None:
            result['RoleType'] = self.role_type
        if self.rolearn is not None:
            result['Rolearn'] = self.rolearn
        if self.assume_role_for is not None:
            result['AssumeRoleFor'] = self.assume_role_for
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RoleType') is not None:
            self.role_type = m.get('RoleType')
        if m.get('Rolearn') is not None:
            self.rolearn = m.get('Rolearn')
        if m.get('AssumeRoleFor') is not None:
            self.assume_role_for = m.get('AssumeRoleFor')
        return self


class CreateInstanceRequestTag(TeaModel):
    def __init__(
        self,
        key: str = None,
        value: str = None,
    ):
        self.key = key
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('key') is not None:
            self.key = m.get('key')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class CreateInstanceRequest(TeaModel):
    def __init__(
        self,
        system_disk: CreateInstanceRequestSystemDisk = None,
        hibernation_options: CreateInstanceRequestHibernationOptions = None,
        private_pool_options: CreateInstanceRequestPrivatePoolOptions = None,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        region_id: str = None,
        image_id: str = None,
        image_family: str = None,
        instance_type: str = None,
        security_group_id: str = None,
        instance_name: str = None,
        internet_charge_type: str = None,
        auto_renew: bool = None,
        auto_renew_period: int = None,
        internet_max_bandwidth_in: int = None,
        internet_max_bandwidth_out: int = None,
        host_name: str = None,
        password: str = None,
        password_inherit: bool = None,
        deployment_set_id: str = None,
        deployment_set_group_no: int = None,
        zone_id: str = None,
        cluster_id: str = None,
        client_token: str = None,
        vlan_id: str = None,
        inner_ip_address: str = None,
        node_controller_id: str = None,
        description: str = None,
        v_switch_id: str = None,
        private_ip_address: str = None,
        io_optimized: str = None,
        owner_account: str = None,
        use_additional_service: bool = None,
        instance_charge_type: str = None,
        period: int = None,
        period_unit: str = None,
        user_data: str = None,
        spot_strategy: str = None,
        key_pair_name: str = None,
        spot_price_limit: float = None,
        spot_duration: int = None,
        spot_interruption_behavior: str = None,
        ram_role_name: str = None,
        security_enhancement_strategy: str = None,
        resource_group_id: str = None,
        hpc_cluster_id: str = None,
        dry_run: bool = None,
        dedicated_host_id: str = None,
        credit_specification: str = None,
        deletion_protection: bool = None,
        affinity: str = None,
        tenancy: str = None,
        storage_set_id: str = None,
        storage_set_partition_number: int = None,
        http_endpoint: str = None,
        http_tokens: str = None,
        http_put_response_hop_limit: int = None,
        data_disk: List[CreateInstanceRequestDataDisk] = None,
        arn: List[CreateInstanceRequestArn] = None,
        tag: List[CreateInstanceRequestTag] = None,
    ):
        self.system_disk = system_disk
        self.hibernation_options = hibernation_options
        self.private_pool_options = private_pool_options
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.region_id = region_id
        self.image_id = image_id
        self.image_family = image_family
        self.instance_type = instance_type
        self.security_group_id = security_group_id
        self.instance_name = instance_name
        self.internet_charge_type = internet_charge_type
        self.auto_renew = auto_renew
        self.auto_renew_period = auto_renew_period
        self.internet_max_bandwidth_in = internet_max_bandwidth_in
        self.internet_max_bandwidth_out = internet_max_bandwidth_out
        self.host_name = host_name
        self.password = password
        self.password_inherit = password_inherit
        self.deployment_set_id = deployment_set_id
        self.deployment_set_group_no = deployment_set_group_no
        self.zone_id = zone_id
        self.cluster_id = cluster_id
        self.client_token = client_token
        self.vlan_id = vlan_id
        self.inner_ip_address = inner_ip_address
        self.node_controller_id = node_controller_id
        self.description = description
        self.v_switch_id = v_switch_id
        self.private_ip_address = private_ip_address
        self.io_optimized = io_optimized
        self.owner_account = owner_account
        self.use_additional_service = use_additional_service
        self.instance_charge_type = instance_charge_type
        self.period = period
        self.period_unit = period_unit
        self.user_data = user_data
        self.spot_strategy = spot_strategy
        self.key_pair_name = key_pair_name
        self.spot_price_limit = spot_price_limit
        self.spot_duration = spot_duration
        self.spot_interruption_behavior = spot_interruption_behavior
        self.ram_role_name = ram_role_name
        self.security_enhancement_strategy = security_enhancement_strategy
        self.resource_group_id = resource_group_id
        self.hpc_cluster_id = hpc_cluster_id
        self.dry_run = dry_run
        self.dedicated_host_id = dedicated_host_id
        self.credit_specification = credit_specification
        self.deletion_protection = deletion_protection
        self.affinity = affinity
        self.tenancy = tenancy
        self.storage_set_id = storage_set_id
        self.storage_set_partition_number = storage_set_partition_number
        self.http_endpoint = http_endpoint
        self.http_tokens = http_tokens
        self.http_put_response_hop_limit = http_put_response_hop_limit
        self.data_disk = data_disk
        self.arn = arn
        self.tag = tag

    def validate(self):
        if self.system_disk:
            self.system_disk.validate()
        if self.hibernation_options:
            self.hibernation_options.validate()
        if self.private_pool_options:
            self.private_pool_options.validate()
        if self.data_disk:
            for k in self.data_disk:
                if k:
                    k.validate()
        if self.arn:
            for k in self.arn:
                if k:
                    k.validate()
        if self.tag:
            for k in self.tag:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.system_disk is not None:
            result['SystemDisk'] = self.system_disk.to_map()
        if self.hibernation_options is not None:
            result['HibernationOptions'] = self.hibernation_options.to_map()
        if self.private_pool_options is not None:
            result['PrivatePoolOptions'] = self.private_pool_options.to_map()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.image_id is not None:
            result['ImageId'] = self.image_id
        if self.image_family is not None:
            result['ImageFamily'] = self.image_family
        if self.instance_type is not None:
            result['InstanceType'] = self.instance_type
        if self.security_group_id is not None:
            result['SecurityGroupId'] = self.security_group_id
        if self.instance_name is not None:
            result['InstanceName'] = self.instance_name
        if self.internet_charge_type is not None:
            result['InternetChargeType'] = self.internet_charge_type
        if self.auto_renew is not None:
            result['AutoRenew'] = self.auto_renew
        if self.auto_renew_period is not None:
            result['AutoRenewPeriod'] = self.auto_renew_period
        if self.internet_max_bandwidth_in is not None:
            result['InternetMaxBandwidthIn'] = self.internet_max_bandwidth_in
        if self.internet_max_bandwidth_out is not None:
            result['InternetMaxBandwidthOut'] = self.internet_max_bandwidth_out
        if self.host_name is not None:
            result['HostName'] = self.host_name
        if self.password is not None:
            result['Password'] = self.password
        if self.password_inherit is not None:
            result['PasswordInherit'] = self.password_inherit
        if self.deployment_set_id is not None:
            result['DeploymentSetId'] = self.deployment_set_id
        if self.deployment_set_group_no is not None:
            result['DeploymentSetGroupNo'] = self.deployment_set_group_no
        if self.zone_id is not None:
            result['ZoneId'] = self.zone_id
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.vlan_id is not None:
            result['VlanId'] = self.vlan_id
        if self.inner_ip_address is not None:
            result['InnerIpAddress'] = self.inner_ip_address
        if self.node_controller_id is not None:
            result['NodeControllerId'] = self.node_controller_id
        if self.description is not None:
            result['Description'] = self.description
        if self.v_switch_id is not None:
            result['VSwitchId'] = self.v_switch_id
        if self.private_ip_address is not None:
            result['PrivateIpAddress'] = self.private_ip_address
        if self.io_optimized is not None:
            result['IoOptimized'] = self.io_optimized
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.use_additional_service is not None:
            result['UseAdditionalService'] = self.use_additional_service
        if self.instance_charge_type is not None:
            result['InstanceChargeType'] = self.instance_charge_type
        if self.period is not None:
            result['Period'] = self.period
        if self.period_unit is not None:
            result['PeriodUnit'] = self.period_unit
        if self.user_data is not None:
            result['UserData'] = self.user_data
        if self.spot_strategy is not None:
            result['SpotStrategy'] = self.spot_strategy
        if self.key_pair_name is not None:
            result['KeyPairName'] = self.key_pair_name
        if self.spot_price_limit is not None:
            result['SpotPriceLimit'] = self.spot_price_limit
        if self.spot_duration is not None:
            result['SpotDuration'] = self.spot_duration
        if self.spot_interruption_behavior is not None:
            result['SpotInterruptionBehavior'] = self.spot_interruption_behavior
        if self.ram_role_name is not None:
            result['RamRoleName'] = self.ram_role_name
        if self.security_enhancement_strategy is not None:
            result['SecurityEnhancementStrategy'] = self.security_enhancement_strategy
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.hpc_cluster_id is not None:
            result['HpcClusterId'] = self.hpc_cluster_id
        if self.dry_run is not None:
            result['DryRun'] = self.dry_run
        if self.dedicated_host_id is not None:
            result['DedicatedHostId'] = self.dedicated_host_id
        if self.credit_specification is not None:
            result['CreditSpecification'] = self.credit_specification
        if self.deletion_protection is not None:
            result['DeletionProtection'] = self.deletion_protection
        if self.affinity is not None:
            result['Affinity'] = self.affinity
        if self.tenancy is not None:
            result['Tenancy'] = self.tenancy
        if self.storage_set_id is not None:
            result['StorageSetId'] = self.storage_set_id
        if self.storage_set_partition_number is not None:
            result['StorageSetPartitionNumber'] = self.storage_set_partition_number
        if self.http_endpoint is not None:
            result['HttpEndpoint'] = self.http_endpoint
        if self.http_tokens is not None:
            result['HttpTokens'] = self.http_tokens
        if self.http_put_response_hop_limit is not None:
            result['HttpPutResponseHopLimit'] = self.http_put_response_hop_limit
        result['DataDisk'] = []
        if self.data_disk is not None:
            for k in self.data_disk:
                result['DataDisk'].append(k.to_map() if k else None)
        result['Arn'] = []
        if self.arn is not None:
            for k in self.arn:
                result['Arn'].append(k.to_map() if k else None)
        result['Tag'] = []
        if self.tag is not None:
            for k in self.tag:
                result['Tag'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('SystemDisk') is not None:
            temp_model = CreateInstanceRequestSystemDisk()
            self.system_disk = temp_model.from_map(m['SystemDisk'])
        if m.get('HibernationOptions') is not None:
            temp_model = CreateInstanceRequestHibernationOptions()
            self.hibernation_options = temp_model.from_map(m['HibernationOptions'])
        if m.get('PrivatePoolOptions') is not None:
            temp_model = CreateInstanceRequestPrivatePoolOptions()
            self.private_pool_options = temp_model.from_map(m['PrivatePoolOptions'])
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ImageId') is not None:
            self.image_id = m.get('ImageId')
        if m.get('ImageFamily') is not None:
            self.image_family = m.get('ImageFamily')
        if m.get('InstanceType') is not None:
            self.instance_type = m.get('InstanceType')
        if m.get('SecurityGroupId') is not None:
            self.security_group_id = m.get('SecurityGroupId')
        if m.get('InstanceName') is not None:
            self.instance_name = m.get('InstanceName')
        if m.get('InternetChargeType') is not None:
            self.internet_charge_type = m.get('InternetChargeType')
        if m.get('AutoRenew') is not None:
            self.auto_renew = m.get('AutoRenew')
        if m.get('AutoRenewPeriod') is not None:
            self.auto_renew_period = m.get('AutoRenewPeriod')
        if m.get('InternetMaxBandwidthIn') is not None:
            self.internet_max_bandwidth_in = m.get('InternetMaxBandwidthIn')
        if m.get('InternetMaxBandwidthOut') is not None:
            self.internet_max_bandwidth_out = m.get('InternetMaxBandwidthOut')
        if m.get('HostName') is not None:
            self.host_name = m.get('HostName')
        if m.get('Password') is not None:
            self.password = m.get('Password')
        if m.get('PasswordInherit') is not None:
            self.password_inherit = m.get('PasswordInherit')
        if m.get('DeploymentSetId') is not None:
            self.deployment_set_id = m.get('DeploymentSetId')
        if m.get('DeploymentSetGroupNo') is not None:
            self.deployment_set_group_no = m.get('DeploymentSetGroupNo')
        if m.get('ZoneId') is not None:
            self.zone_id = m.get('ZoneId')
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('VlanId') is not None:
            self.vlan_id = m.get('VlanId')
        if m.get('InnerIpAddress') is not None:
            self.inner_ip_address = m.get('InnerIpAddress')
        if m.get('NodeControllerId') is not None:
            self.node_controller_id = m.get('NodeControllerId')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('VSwitchId') is not None:
            self.v_switch_id = m.get('VSwitchId')
        if m.get('PrivateIpAddress') is not None:
            self.private_ip_address = m.get('PrivateIpAddress')
        if m.get('IoOptimized') is not None:
            self.io_optimized = m.get('IoOptimized')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('UseAdditionalService') is not None:
            self.use_additional_service = m.get('UseAdditionalService')
        if m.get('InstanceChargeType') is not None:
            self.instance_charge_type = m.get('InstanceChargeType')
        if m.get('Period') is not None:
            self.period = m.get('Period')
        if m.get('PeriodUnit') is not None:
            self.period_unit = m.get('PeriodUnit')
        if m.get('UserData') is not None:
            self.user_data = m.get('UserData')
        if m.get('SpotStrategy') is not None:
            self.spot_strategy = m.get('SpotStrategy')
        if m.get('KeyPairName') is not None:
            self.key_pair_name = m.get('KeyPairName')
        if m.get('SpotPriceLimit') is not None:
            self.spot_price_limit = m.get('SpotPriceLimit')
        if m.get('SpotDuration') is not None:
            self.spot_duration = m.get('SpotDuration')
        if m.get('SpotInterruptionBehavior') is not None:
            self.spot_interruption_behavior = m.get('SpotInterruptionBehavior')
        if m.get('RamRoleName') is not None:
            self.ram_role_name = m.get('RamRoleName')
        if m.get('SecurityEnhancementStrategy') is not None:
            self.security_enhancement_strategy = m.get('SecurityEnhancementStrategy')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        if m.get('HpcClusterId') is not None:
            self.hpc_cluster_id = m.get('HpcClusterId')
        if m.get('DryRun') is not None:
            self.dry_run = m.get('DryRun')
        if m.get('DedicatedHostId') is not None:
            self.dedicated_host_id = m.get('DedicatedHostId')
        if m.get('CreditSpecification') is not None:
            self.credit_specification = m.get('CreditSpecification')
        if m.get('DeletionProtection') is not None:
            self.deletion_protection = m.get('DeletionProtection')
        if m.get('Affinity') is not None:
            self.affinity = m.get('Affinity')
        if m.get('Tenancy') is not None:
            self.tenancy = m.get('Tenancy')
        if m.get('StorageSetId') is not None:
            self.storage_set_id = m.get('StorageSetId')
        if m.get('StorageSetPartitionNumber') is not None:
            self.storage_set_partition_number = m.get('StorageSetPartitionNumber')
        if m.get('HttpEndpoint') is not None:
            self.http_endpoint = m.get('HttpEndpoint')
        if m.get('HttpTokens') is not None:
            self.http_tokens = m.get('HttpTokens')
        if m.get('HttpPutResponseHopLimit') is not None:
            self.http_put_response_hop_limit = m.get('HttpPutResponseHopLimit')
        self.data_disk = []
        if m.get('DataDisk') is not None:
            for k in m.get('DataDisk'):
                temp_model = CreateInstanceRequestDataDisk()
                self.data_disk.append(temp_model.from_map(k))
        self.arn = []
        if m.get('Arn') is not None:
            for k in m.get('Arn'):
                temp_model = CreateInstanceRequestArn()
                self.arn.append(temp_model.from_map(k))
        self.tag = []
        if m.get('Tag') is not None:
            for k in m.get('Tag'):
                temp_model = CreateInstanceRequestTag()
                self.tag.append(temp_model.from_map(k))
        return self


class CreateInstanceResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        instance_id: str = None,
        order_id: str = None,
        trade_price: float = None,
    ):
        self.request_id = request_id
        self.instance_id = instance_id
        self.order_id = order_id
        self.trade_price = trade_price

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.order_id is not None:
            result['OrderId'] = self.order_id
        if self.trade_price is not None:
            result['TradePrice'] = self.trade_price
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('OrderId') is not None:
            self.order_id = m.get('OrderId')
        if m.get('TradePrice') is not None:
            self.trade_price = m.get('TradePrice')
        return self


class CreateInstanceResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CreateInstanceResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateInstanceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateKeyPairRequestTag(TeaModel):
    def __init__(
        self,
        key: str = None,
        value: str = None,
    ):
        self.key = key
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class CreateKeyPairRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        region_id: str = None,
        key_pair_name: str = None,
        resource_group_id: str = None,
        tag: List[CreateKeyPairRequestTag] = None,
    ):
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.region_id = region_id
        self.key_pair_name = key_pair_name
        self.resource_group_id = resource_group_id
        self.tag = tag

    def validate(self):
        if self.tag:
            for k in self.tag:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.key_pair_name is not None:
            result['KeyPairName'] = self.key_pair_name
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        result['Tag'] = []
        if self.tag is not None:
            for k in self.tag:
                result['Tag'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('KeyPairName') is not None:
            self.key_pair_name = m.get('KeyPairName')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        self.tag = []
        if m.get('Tag') is not None:
            for k in m.get('Tag'):
                temp_model = CreateKeyPairRequestTag()
                self.tag.append(temp_model.from_map(k))
        return self


class CreateKeyPairResponseBody(TeaModel):
    def __init__(
        self,
        private_key_body: str = None,
        key_pair_name: str = None,
        key_pair_id: str = None,
        request_id: str = None,
        key_pair_finger_print: str = None,
    ):
        self.private_key_body = private_key_body
        self.key_pair_name = key_pair_name
        self.key_pair_id = key_pair_id
        self.request_id = request_id
        self.key_pair_finger_print = key_pair_finger_print

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.private_key_body is not None:
            result['PrivateKeyBody'] = self.private_key_body
        if self.key_pair_name is not None:
            result['KeyPairName'] = self.key_pair_name
        if self.key_pair_id is not None:
            result['KeyPairId'] = self.key_pair_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.key_pair_finger_print is not None:
            result['KeyPairFingerPrint'] = self.key_pair_finger_print
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PrivateKeyBody') is not None:
            self.private_key_body = m.get('PrivateKeyBody')
        if m.get('KeyPairName') is not None:
            self.key_pair_name = m.get('KeyPairName')
        if m.get('KeyPairId') is not None:
            self.key_pair_id = m.get('KeyPairId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('KeyPairFingerPrint') is not None:
            self.key_pair_finger_print = m.get('KeyPairFingerPrint')
        return self


class CreateKeyPairResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CreateKeyPairResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateKeyPairResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateLaunchTemplateRequestSystemDisk(TeaModel):
    def __init__(
        self,
        category: str = None,
        size: int = None,
        disk_name: str = None,
        description: str = None,
        iops: int = None,
        performance_level: str = None,
        delete_with_instance: bool = None,
    ):
        self.category = category
        self.size = size
        self.disk_name = disk_name
        self.description = description
        self.iops = iops
        self.performance_level = performance_level
        self.delete_with_instance = delete_with_instance

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.category is not None:
            result['Category'] = self.category
        if self.size is not None:
            result['Size'] = self.size
        if self.disk_name is not None:
            result['DiskName'] = self.disk_name
        if self.description is not None:
            result['Description'] = self.description
        if self.iops is not None:
            result['Iops'] = self.iops
        if self.performance_level is not None:
            result['PerformanceLevel'] = self.performance_level
        if self.delete_with_instance is not None:
            result['DeleteWithInstance'] = self.delete_with_instance
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Category') is not None:
            self.category = m.get('Category')
        if m.get('Size') is not None:
            self.size = m.get('Size')
        if m.get('DiskName') is not None:
            self.disk_name = m.get('DiskName')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('Iops') is not None:
            self.iops = m.get('Iops')
        if m.get('PerformanceLevel') is not None:
            self.performance_level = m.get('PerformanceLevel')
        if m.get('DeleteWithInstance') is not None:
            self.delete_with_instance = m.get('DeleteWithInstance')
        return self


class CreateLaunchTemplateRequestTemplateTag(TeaModel):
    def __init__(
        self,
        key: str = None,
        value: str = None,
    ):
        self.key = key
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class CreateLaunchTemplateRequestDataDisk(TeaModel):
    def __init__(
        self,
        performance_level: str = None,
        description: str = None,
        snapshot_id: str = None,
        size: int = None,
        device: str = None,
        disk_name: str = None,
        category: str = None,
        delete_with_instance: bool = None,
        encrypted: str = None,
    ):
        self.performance_level = performance_level
        self.description = description
        self.snapshot_id = snapshot_id
        self.size = size
        self.device = device
        self.disk_name = disk_name
        self.category = category
        self.delete_with_instance = delete_with_instance
        self.encrypted = encrypted

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.performance_level is not None:
            result['PerformanceLevel'] = self.performance_level
        if self.description is not None:
            result['Description'] = self.description
        if self.snapshot_id is not None:
            result['SnapshotId'] = self.snapshot_id
        if self.size is not None:
            result['Size'] = self.size
        if self.device is not None:
            result['Device'] = self.device
        if self.disk_name is not None:
            result['DiskName'] = self.disk_name
        if self.category is not None:
            result['Category'] = self.category
        if self.delete_with_instance is not None:
            result['DeleteWithInstance'] = self.delete_with_instance
        if self.encrypted is not None:
            result['Encrypted'] = self.encrypted
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PerformanceLevel') is not None:
            self.performance_level = m.get('PerformanceLevel')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('SnapshotId') is not None:
            self.snapshot_id = m.get('SnapshotId')
        if m.get('Size') is not None:
            self.size = m.get('Size')
        if m.get('Device') is not None:
            self.device = m.get('Device')
        if m.get('DiskName') is not None:
            self.disk_name = m.get('DiskName')
        if m.get('Category') is not None:
            self.category = m.get('Category')
        if m.get('DeleteWithInstance') is not None:
            self.delete_with_instance = m.get('DeleteWithInstance')
        if m.get('Encrypted') is not None:
            self.encrypted = m.get('Encrypted')
        return self


class CreateLaunchTemplateRequestNetworkInterface(TeaModel):
    def __init__(
        self,
        v_switch_id: str = None,
        network_interface_name: str = None,
        description: str = None,
        security_group_id: str = None,
        primary_ip_address: str = None,
        security_group_ids: List[str] = None,
    ):
        self.v_switch_id = v_switch_id
        self.network_interface_name = network_interface_name
        self.description = description
        self.security_group_id = security_group_id
        self.primary_ip_address = primary_ip_address
        self.security_group_ids = security_group_ids

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.v_switch_id is not None:
            result['VSwitchId'] = self.v_switch_id
        if self.network_interface_name is not None:
            result['NetworkInterfaceName'] = self.network_interface_name
        if self.description is not None:
            result['Description'] = self.description
        if self.security_group_id is not None:
            result['SecurityGroupId'] = self.security_group_id
        if self.primary_ip_address is not None:
            result['PrimaryIpAddress'] = self.primary_ip_address
        if self.security_group_ids is not None:
            result['SecurityGroupIds'] = self.security_group_ids
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('VSwitchId') is not None:
            self.v_switch_id = m.get('VSwitchId')
        if m.get('NetworkInterfaceName') is not None:
            self.network_interface_name = m.get('NetworkInterfaceName')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('SecurityGroupId') is not None:
            self.security_group_id = m.get('SecurityGroupId')
        if m.get('PrimaryIpAddress') is not None:
            self.primary_ip_address = m.get('PrimaryIpAddress')
        if m.get('SecurityGroupIds') is not None:
            self.security_group_ids = m.get('SecurityGroupIds')
        return self


class CreateLaunchTemplateRequestTag(TeaModel):
    def __init__(
        self,
        key: str = None,
        value: str = None,
    ):
        self.key = key
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class CreateLaunchTemplateRequest(TeaModel):
    def __init__(
        self,
        system_disk: CreateLaunchTemplateRequestSystemDisk = None,
        template_tag: List[CreateLaunchTemplateRequestTemplateTag] = None,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        owner_account: str = None,
        region_id: str = None,
        data_disk: List[CreateLaunchTemplateRequestDataDisk] = None,
        network_interface: List[CreateLaunchTemplateRequestNetworkInterface] = None,
        tag: List[CreateLaunchTemplateRequestTag] = None,
        security_group_ids: List[str] = None,
        launch_template_name: str = None,
        version_description: str = None,
        image_id: str = None,
        image_owner_alias: str = None,
        password_inherit: bool = None,
        instance_type: str = None,
        security_group_id: str = None,
        vpc_id: str = None,
        v_switch_id: str = None,
        instance_name: str = None,
        description: str = None,
        internet_max_bandwidth_in: int = None,
        internet_max_bandwidth_out: int = None,
        host_name: str = None,
        zone_id: str = None,
        io_optimized: str = None,
        instance_charge_type: str = None,
        period: int = None,
        internet_charge_type: str = None,
        enable_vm_os_config: bool = None,
        network_type: str = None,
        user_data: str = None,
        key_pair_name: str = None,
        ram_role_name: str = None,
        auto_release_time: str = None,
        spot_strategy: str = None,
        spot_price_limit: float = None,
        spot_duration: int = None,
        resource_group_id: str = None,
        template_resource_group_id: str = None,
        security_enhancement_strategy: str = None,
        private_ip_address: str = None,
        deployment_set_id: str = None,
    ):
        self.system_disk = system_disk
        self.template_tag = template_tag
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.owner_account = owner_account
        self.region_id = region_id
        self.data_disk = data_disk
        self.network_interface = network_interface
        self.tag = tag
        self.security_group_ids = security_group_ids
        self.launch_template_name = launch_template_name
        self.version_description = version_description
        self.image_id = image_id
        self.image_owner_alias = image_owner_alias
        self.password_inherit = password_inherit
        self.instance_type = instance_type
        self.security_group_id = security_group_id
        self.vpc_id = vpc_id
        self.v_switch_id = v_switch_id
        self.instance_name = instance_name
        self.description = description
        self.internet_max_bandwidth_in = internet_max_bandwidth_in
        self.internet_max_bandwidth_out = internet_max_bandwidth_out
        self.host_name = host_name
        self.zone_id = zone_id
        self.io_optimized = io_optimized
        self.instance_charge_type = instance_charge_type
        self.period = period
        self.internet_charge_type = internet_charge_type
        self.enable_vm_os_config = enable_vm_os_config
        self.network_type = network_type
        self.user_data = user_data
        self.key_pair_name = key_pair_name
        self.ram_role_name = ram_role_name
        self.auto_release_time = auto_release_time
        self.spot_strategy = spot_strategy
        self.spot_price_limit = spot_price_limit
        self.spot_duration = spot_duration
        self.resource_group_id = resource_group_id
        self.template_resource_group_id = template_resource_group_id
        self.security_enhancement_strategy = security_enhancement_strategy
        self.private_ip_address = private_ip_address
        self.deployment_set_id = deployment_set_id

    def validate(self):
        if self.system_disk:
            self.system_disk.validate()
        if self.template_tag:
            for k in self.template_tag:
                if k:
                    k.validate()
        if self.data_disk:
            for k in self.data_disk:
                if k:
                    k.validate()
        if self.network_interface:
            for k in self.network_interface:
                if k:
                    k.validate()
        if self.tag:
            for k in self.tag:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.system_disk is not None:
            result['SystemDisk'] = self.system_disk.to_map()
        result['TemplateTag'] = []
        if self.template_tag is not None:
            for k in self.template_tag:
                result['TemplateTag'].append(k.to_map() if k else None)
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        result['DataDisk'] = []
        if self.data_disk is not None:
            for k in self.data_disk:
                result['DataDisk'].append(k.to_map() if k else None)
        result['NetworkInterface'] = []
        if self.network_interface is not None:
            for k in self.network_interface:
                result['NetworkInterface'].append(k.to_map() if k else None)
        result['Tag'] = []
        if self.tag is not None:
            for k in self.tag:
                result['Tag'].append(k.to_map() if k else None)
        if self.security_group_ids is not None:
            result['SecurityGroupIds'] = self.security_group_ids
        if self.launch_template_name is not None:
            result['LaunchTemplateName'] = self.launch_template_name
        if self.version_description is not None:
            result['VersionDescription'] = self.version_description
        if self.image_id is not None:
            result['ImageId'] = self.image_id
        if self.image_owner_alias is not None:
            result['ImageOwnerAlias'] = self.image_owner_alias
        if self.password_inherit is not None:
            result['PasswordInherit'] = self.password_inherit
        if self.instance_type is not None:
            result['InstanceType'] = self.instance_type
        if self.security_group_id is not None:
            result['SecurityGroupId'] = self.security_group_id
        if self.vpc_id is not None:
            result['VpcId'] = self.vpc_id
        if self.v_switch_id is not None:
            result['VSwitchId'] = self.v_switch_id
        if self.instance_name is not None:
            result['InstanceName'] = self.instance_name
        if self.description is not None:
            result['Description'] = self.description
        if self.internet_max_bandwidth_in is not None:
            result['InternetMaxBandwidthIn'] = self.internet_max_bandwidth_in
        if self.internet_max_bandwidth_out is not None:
            result['InternetMaxBandwidthOut'] = self.internet_max_bandwidth_out
        if self.host_name is not None:
            result['HostName'] = self.host_name
        if self.zone_id is not None:
            result['ZoneId'] = self.zone_id
        if self.io_optimized is not None:
            result['IoOptimized'] = self.io_optimized
        if self.instance_charge_type is not None:
            result['InstanceChargeType'] = self.instance_charge_type
        if self.period is not None:
            result['Period'] = self.period
        if self.internet_charge_type is not None:
            result['InternetChargeType'] = self.internet_charge_type
        if self.enable_vm_os_config is not None:
            result['EnableVmOsConfig'] = self.enable_vm_os_config
        if self.network_type is not None:
            result['NetworkType'] = self.network_type
        if self.user_data is not None:
            result['UserData'] = self.user_data
        if self.key_pair_name is not None:
            result['KeyPairName'] = self.key_pair_name
        if self.ram_role_name is not None:
            result['RamRoleName'] = self.ram_role_name
        if self.auto_release_time is not None:
            result['AutoReleaseTime'] = self.auto_release_time
        if self.spot_strategy is not None:
            result['SpotStrategy'] = self.spot_strategy
        if self.spot_price_limit is not None:
            result['SpotPriceLimit'] = self.spot_price_limit
        if self.spot_duration is not None:
            result['SpotDuration'] = self.spot_duration
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.template_resource_group_id is not None:
            result['TemplateResourceGroupId'] = self.template_resource_group_id
        if self.security_enhancement_strategy is not None:
            result['SecurityEnhancementStrategy'] = self.security_enhancement_strategy
        if self.private_ip_address is not None:
            result['PrivateIpAddress'] = self.private_ip_address
        if self.deployment_set_id is not None:
            result['DeploymentSetId'] = self.deployment_set_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('SystemDisk') is not None:
            temp_model = CreateLaunchTemplateRequestSystemDisk()
            self.system_disk = temp_model.from_map(m['SystemDisk'])
        self.template_tag = []
        if m.get('TemplateTag') is not None:
            for k in m.get('TemplateTag'):
                temp_model = CreateLaunchTemplateRequestTemplateTag()
                self.template_tag.append(temp_model.from_map(k))
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        self.data_disk = []
        if m.get('DataDisk') is not None:
            for k in m.get('DataDisk'):
                temp_model = CreateLaunchTemplateRequestDataDisk()
                self.data_disk.append(temp_model.from_map(k))
        self.network_interface = []
        if m.get('NetworkInterface') is not None:
            for k in m.get('NetworkInterface'):
                temp_model = CreateLaunchTemplateRequestNetworkInterface()
                self.network_interface.append(temp_model.from_map(k))
        self.tag = []
        if m.get('Tag') is not None:
            for k in m.get('Tag'):
                temp_model = CreateLaunchTemplateRequestTag()
                self.tag.append(temp_model.from_map(k))
        if m.get('SecurityGroupIds') is not None:
            self.security_group_ids = m.get('SecurityGroupIds')
        if m.get('LaunchTemplateName') is not None:
            self.launch_template_name = m.get('LaunchTemplateName')
        if m.get('VersionDescription') is not None:
            self.version_description = m.get('VersionDescription')
        if m.get('ImageId') is not None:
            self.image_id = m.get('ImageId')
        if m.get('ImageOwnerAlias') is not None:
            self.image_owner_alias = m.get('ImageOwnerAlias')
        if m.get('PasswordInherit') is not None:
            self.password_inherit = m.get('PasswordInherit')
        if m.get('InstanceType') is not None:
            self.instance_type = m.get('InstanceType')
        if m.get('SecurityGroupId') is not None:
            self.security_group_id = m.get('SecurityGroupId')
        if m.get('VpcId') is not None:
            self.vpc_id = m.get('VpcId')
        if m.get('VSwitchId') is not None:
            self.v_switch_id = m.get('VSwitchId')
        if m.get('InstanceName') is not None:
            self.instance_name = m.get('InstanceName')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('InternetMaxBandwidthIn') is not None:
            self.internet_max_bandwidth_in = m.get('InternetMaxBandwidthIn')
        if m.get('InternetMaxBandwidthOut') is not None:
            self.internet_max_bandwidth_out = m.get('InternetMaxBandwidthOut')
        if m.get('HostName') is not None:
            self.host_name = m.get('HostName')
        if m.get('ZoneId') is not None:
            self.zone_id = m.get('ZoneId')
        if m.get('IoOptimized') is not None:
            self.io_optimized = m.get('IoOptimized')
        if m.get('InstanceChargeType') is not None:
            self.instance_charge_type = m.get('InstanceChargeType')
        if m.get('Period') is not None:
            self.period = m.get('Period')
        if m.get('InternetChargeType') is not None:
            self.internet_charge_type = m.get('InternetChargeType')
        if m.get('EnableVmOsConfig') is not None:
            self.enable_vm_os_config = m.get('EnableVmOsConfig')
        if m.get('NetworkType') is not None:
            self.network_type = m.get('NetworkType')
        if m.get('UserData') is not None:
            self.user_data = m.get('UserData')
        if m.get('KeyPairName') is not None:
            self.key_pair_name = m.get('KeyPairName')
        if m.get('RamRoleName') is not None:
            self.ram_role_name = m.get('RamRoleName')
        if m.get('AutoReleaseTime') is not None:
            self.auto_release_time = m.get('AutoReleaseTime')
        if m.get('SpotStrategy') is not None:
            self.spot_strategy = m.get('SpotStrategy')
        if m.get('SpotPriceLimit') is not None:
            self.spot_price_limit = m.get('SpotPriceLimit')
        if m.get('SpotDuration') is not None:
            self.spot_duration = m.get('SpotDuration')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        if m.get('TemplateResourceGroupId') is not None:
            self.template_resource_group_id = m.get('TemplateResourceGroupId')
        if m.get('SecurityEnhancementStrategy') is not None:
            self.security_enhancement_strategy = m.get('SecurityEnhancementStrategy')
        if m.get('PrivateIpAddress') is not None:
            self.private_ip_address = m.get('PrivateIpAddress')
        if m.get('DeploymentSetId') is not None:
            self.deployment_set_id = m.get('DeploymentSetId')
        return self


class CreateLaunchTemplateResponseBody(TeaModel):
    def __init__(
        self,
        launch_template_id: str = None,
        request_id: str = None,
    ):
        self.launch_template_id = launch_template_id
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.launch_template_id is not None:
            result['LaunchTemplateId'] = self.launch_template_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('LaunchTemplateId') is not None:
            self.launch_template_id = m.get('LaunchTemplateId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateLaunchTemplateResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CreateLaunchTemplateResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateLaunchTemplateResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateLaunchTemplateVersionRequestSystemDisk(TeaModel):
    def __init__(
        self,
        category: str = None,
        size: int = None,
        disk_name: str = None,
        description: str = None,
        iops: int = None,
        performance_level: str = None,
        delete_with_instance: bool = None,
    ):
        self.category = category
        self.size = size
        self.disk_name = disk_name
        self.description = description
        self.iops = iops
        self.performance_level = performance_level
        self.delete_with_instance = delete_with_instance

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.category is not None:
            result['Category'] = self.category
        if self.size is not None:
            result['Size'] = self.size
        if self.disk_name is not None:
            result['DiskName'] = self.disk_name
        if self.description is not None:
            result['Description'] = self.description
        if self.iops is not None:
            result['Iops'] = self.iops
        if self.performance_level is not None:
            result['PerformanceLevel'] = self.performance_level
        if self.delete_with_instance is not None:
            result['DeleteWithInstance'] = self.delete_with_instance
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Category') is not None:
            self.category = m.get('Category')
        if m.get('Size') is not None:
            self.size = m.get('Size')
        if m.get('DiskName') is not None:
            self.disk_name = m.get('DiskName')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('Iops') is not None:
            self.iops = m.get('Iops')
        if m.get('PerformanceLevel') is not None:
            self.performance_level = m.get('PerformanceLevel')
        if m.get('DeleteWithInstance') is not None:
            self.delete_with_instance = m.get('DeleteWithInstance')
        return self


class CreateLaunchTemplateVersionRequestDataDisk(TeaModel):
    def __init__(
        self,
        performance_level: str = None,
        description: str = None,
        snapshot_id: str = None,
        size: int = None,
        device: str = None,
        disk_name: str = None,
        category: str = None,
        delete_with_instance: bool = None,
        encrypted: str = None,
    ):
        self.performance_level = performance_level
        self.description = description
        self.snapshot_id = snapshot_id
        self.size = size
        self.device = device
        self.disk_name = disk_name
        self.category = category
        self.delete_with_instance = delete_with_instance
        self.encrypted = encrypted

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.performance_level is not None:
            result['PerformanceLevel'] = self.performance_level
        if self.description is not None:
            result['Description'] = self.description
        if self.snapshot_id is not None:
            result['SnapshotId'] = self.snapshot_id
        if self.size is not None:
            result['Size'] = self.size
        if self.device is not None:
            result['Device'] = self.device
        if self.disk_name is not None:
            result['DiskName'] = self.disk_name
        if self.category is not None:
            result['Category'] = self.category
        if self.delete_with_instance is not None:
            result['DeleteWithInstance'] = self.delete_with_instance
        if self.encrypted is not None:
            result['Encrypted'] = self.encrypted
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PerformanceLevel') is not None:
            self.performance_level = m.get('PerformanceLevel')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('SnapshotId') is not None:
            self.snapshot_id = m.get('SnapshotId')
        if m.get('Size') is not None:
            self.size = m.get('Size')
        if m.get('Device') is not None:
            self.device = m.get('Device')
        if m.get('DiskName') is not None:
            self.disk_name = m.get('DiskName')
        if m.get('Category') is not None:
            self.category = m.get('Category')
        if m.get('DeleteWithInstance') is not None:
            self.delete_with_instance = m.get('DeleteWithInstance')
        if m.get('Encrypted') is not None:
            self.encrypted = m.get('Encrypted')
        return self


class CreateLaunchTemplateVersionRequestNetworkInterface(TeaModel):
    def __init__(
        self,
        v_switch_id: str = None,
        network_interface_name: str = None,
        description: str = None,
        security_group_id: str = None,
        primary_ip_address: str = None,
        security_group_ids: List[str] = None,
    ):
        self.v_switch_id = v_switch_id
        self.network_interface_name = network_interface_name
        self.description = description
        self.security_group_id = security_group_id
        self.primary_ip_address = primary_ip_address
        self.security_group_ids = security_group_ids

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.v_switch_id is not None:
            result['VSwitchId'] = self.v_switch_id
        if self.network_interface_name is not None:
            result['NetworkInterfaceName'] = self.network_interface_name
        if self.description is not None:
            result['Description'] = self.description
        if self.security_group_id is not None:
            result['SecurityGroupId'] = self.security_group_id
        if self.primary_ip_address is not None:
            result['PrimaryIpAddress'] = self.primary_ip_address
        if self.security_group_ids is not None:
            result['SecurityGroupIds'] = self.security_group_ids
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('VSwitchId') is not None:
            self.v_switch_id = m.get('VSwitchId')
        if m.get('NetworkInterfaceName') is not None:
            self.network_interface_name = m.get('NetworkInterfaceName')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('SecurityGroupId') is not None:
            self.security_group_id = m.get('SecurityGroupId')
        if m.get('PrimaryIpAddress') is not None:
            self.primary_ip_address = m.get('PrimaryIpAddress')
        if m.get('SecurityGroupIds') is not None:
            self.security_group_ids = m.get('SecurityGroupIds')
        return self


class CreateLaunchTemplateVersionRequestTag(TeaModel):
    def __init__(
        self,
        key: str = None,
        value: str = None,
    ):
        self.key = key
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class CreateLaunchTemplateVersionRequest(TeaModel):
    def __init__(
        self,
        system_disk: CreateLaunchTemplateVersionRequestSystemDisk = None,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        owner_account: str = None,
        region_id: str = None,
        data_disk: List[CreateLaunchTemplateVersionRequestDataDisk] = None,
        network_interface: List[CreateLaunchTemplateVersionRequestNetworkInterface] = None,
        tag: List[CreateLaunchTemplateVersionRequestTag] = None,
        security_group_ids: List[str] = None,
        launch_template_id: str = None,
        launch_template_name: str = None,
        version_description: str = None,
        image_id: str = None,
        image_owner_alias: str = None,
        password_inherit: bool = None,
        instance_type: str = None,
        security_group_id: str = None,
        vpc_id: str = None,
        v_switch_id: str = None,
        instance_name: str = None,
        description: str = None,
        internet_max_bandwidth_in: int = None,
        internet_max_bandwidth_out: int = None,
        host_name: str = None,
        zone_id: str = None,
        io_optimized: str = None,
        instance_charge_type: str = None,
        period: int = None,
        internet_charge_type: str = None,
        enable_vm_os_config: bool = None,
        network_type: str = None,
        user_data: str = None,
        key_pair_name: str = None,
        ram_role_name: str = None,
        auto_release_time: str = None,
        spot_strategy: str = None,
        spot_price_limit: float = None,
        spot_duration: int = None,
        resource_group_id: str = None,
        security_enhancement_strategy: str = None,
        private_ip_address: str = None,
        deployment_set_id: str = None,
    ):
        self.system_disk = system_disk
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.owner_account = owner_account
        self.region_id = region_id
        self.data_disk = data_disk
        self.network_interface = network_interface
        self.tag = tag
        self.security_group_ids = security_group_ids
        self.launch_template_id = launch_template_id
        self.launch_template_name = launch_template_name
        self.version_description = version_description
        self.image_id = image_id
        self.image_owner_alias = image_owner_alias
        self.password_inherit = password_inherit
        self.instance_type = instance_type
        self.security_group_id = security_group_id
        self.vpc_id = vpc_id
        self.v_switch_id = v_switch_id
        self.instance_name = instance_name
        self.description = description
        self.internet_max_bandwidth_in = internet_max_bandwidth_in
        self.internet_max_bandwidth_out = internet_max_bandwidth_out
        self.host_name = host_name
        self.zone_id = zone_id
        self.io_optimized = io_optimized
        self.instance_charge_type = instance_charge_type
        self.period = period
        self.internet_charge_type = internet_charge_type
        self.enable_vm_os_config = enable_vm_os_config
        self.network_type = network_type
        self.user_data = user_data
        self.key_pair_name = key_pair_name
        self.ram_role_name = ram_role_name
        self.auto_release_time = auto_release_time
        self.spot_strategy = spot_strategy
        self.spot_price_limit = spot_price_limit
        self.spot_duration = spot_duration
        self.resource_group_id = resource_group_id
        self.security_enhancement_strategy = security_enhancement_strategy
        self.private_ip_address = private_ip_address
        self.deployment_set_id = deployment_set_id

    def validate(self):
        if self.system_disk:
            self.system_disk.validate()
        if self.data_disk:
            for k in self.data_disk:
                if k:
                    k.validate()
        if self.network_interface:
            for k in self.network_interface:
                if k:
                    k.validate()
        if self.tag:
            for k in self.tag:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.system_disk is not None:
            result['SystemDisk'] = self.system_disk.to_map()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        result['DataDisk'] = []
        if self.data_disk is not None:
            for k in self.data_disk:
                result['DataDisk'].append(k.to_map() if k else None)
        result['NetworkInterface'] = []
        if self.network_interface is not None:
            for k in self.network_interface:
                result['NetworkInterface'].append(k.to_map() if k else None)
        result['Tag'] = []
        if self.tag is not None:
            for k in self.tag:
                result['Tag'].append(k.to_map() if k else None)
        if self.security_group_ids is not None:
            result['SecurityGroupIds'] = self.security_group_ids
        if self.launch_template_id is not None:
            result['LaunchTemplateId'] = self.launch_template_id
        if self.launch_template_name is not None:
            result['LaunchTemplateName'] = self.launch_template_name
        if self.version_description is not None:
            result['VersionDescription'] = self.version_description
        if self.image_id is not None:
            result['ImageId'] = self.image_id
        if self.image_owner_alias is not None:
            result['ImageOwnerAlias'] = self.image_owner_alias
        if self.password_inherit is not None:
            result['PasswordInherit'] = self.password_inherit
        if self.instance_type is not None:
            result['InstanceType'] = self.instance_type
        if self.security_group_id is not None:
            result['SecurityGroupId'] = self.security_group_id
        if self.vpc_id is not None:
            result['VpcId'] = self.vpc_id
        if self.v_switch_id is not None:
            result['VSwitchId'] = self.v_switch_id
        if self.instance_name is not None:
            result['InstanceName'] = self.instance_name
        if self.description is not None:
            result['Description'] = self.description
        if self.internet_max_bandwidth_in is not None:
            result['InternetMaxBandwidthIn'] = self.internet_max_bandwidth_in
        if self.internet_max_bandwidth_out is not None:
            result['InternetMaxBandwidthOut'] = self.internet_max_bandwidth_out
        if self.host_name is not None:
            result['HostName'] = self.host_name
        if self.zone_id is not None:
            result['ZoneId'] = self.zone_id
        if self.io_optimized is not None:
            result['IoOptimized'] = self.io_optimized
        if self.instance_charge_type is not None:
            result['InstanceChargeType'] = self.instance_charge_type
        if self.period is not None:
            result['Period'] = self.period
        if self.internet_charge_type is not None:
            result['InternetChargeType'] = self.internet_charge_type
        if self.enable_vm_os_config is not None:
            result['EnableVmOsConfig'] = self.enable_vm_os_config
        if self.network_type is not None:
            result['NetworkType'] = self.network_type
        if self.user_data is not None:
            result['UserData'] = self.user_data
        if self.key_pair_name is not None:
            result['KeyPairName'] = self.key_pair_name
        if self.ram_role_name is not None:
            result['RamRoleName'] = self.ram_role_name
        if self.auto_release_time is not None:
            result['AutoReleaseTime'] = self.auto_release_time
        if self.spot_strategy is not None:
            result['SpotStrategy'] = self.spot_strategy
        if self.spot_price_limit is not None:
            result['SpotPriceLimit'] = self.spot_price_limit
        if self.spot_duration is not None:
            result['SpotDuration'] = self.spot_duration
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.security_enhancement_strategy is not None:
            result['SecurityEnhancementStrategy'] = self.security_enhancement_strategy
        if self.private_ip_address is not None:
            result['PrivateIpAddress'] = self.private_ip_address
        if self.deployment_set_id is not None:
            result['DeploymentSetId'] = self.deployment_set_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('SystemDisk') is not None:
            temp_model = CreateLaunchTemplateVersionRequestSystemDisk()
            self.system_disk = temp_model.from_map(m['SystemDisk'])
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        self.data_disk = []
        if m.get('DataDisk') is not None:
            for k in m.get('DataDisk'):
                temp_model = CreateLaunchTemplateVersionRequestDataDisk()
                self.data_disk.append(temp_model.from_map(k))
        self.network_interface = []
        if m.get('NetworkInterface') is not None:
            for k in m.get('NetworkInterface'):
                temp_model = CreateLaunchTemplateVersionRequestNetworkInterface()
                self.network_interface.append(temp_model.from_map(k))
        self.tag = []
        if m.get('Tag') is not None:
            for k in m.get('Tag'):
                temp_model = CreateLaunchTemplateVersionRequestTag()
                self.tag.append(temp_model.from_map(k))
        if m.get('SecurityGroupIds') is not None:
            self.security_group_ids = m.get('SecurityGroupIds')
        if m.get('LaunchTemplateId') is not None:
            self.launch_template_id = m.get('LaunchTemplateId')
        if m.get('LaunchTemplateName') is not None:
            self.launch_template_name = m.get('LaunchTemplateName')
        if m.get('VersionDescription') is not None:
            self.version_description = m.get('VersionDescription')
        if m.get('ImageId') is not None:
            self.image_id = m.get('ImageId')
        if m.get('ImageOwnerAlias') is not None:
            self.image_owner_alias = m.get('ImageOwnerAlias')
        if m.get('PasswordInherit') is not None:
            self.password_inherit = m.get('PasswordInherit')
        if m.get('InstanceType') is not None:
            self.instance_type = m.get('InstanceType')
        if m.get('SecurityGroupId') is not None:
            self.security_group_id = m.get('SecurityGroupId')
        if m.get('VpcId') is not None:
            self.vpc_id = m.get('VpcId')
        if m.get('VSwitchId') is not None:
            self.v_switch_id = m.get('VSwitchId')
        if m.get('InstanceName') is not None:
            self.instance_name = m.get('InstanceName')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('InternetMaxBandwidthIn') is not None:
            self.internet_max_bandwidth_in = m.get('InternetMaxBandwidthIn')
        if m.get('InternetMaxBandwidthOut') is not None:
            self.internet_max_bandwidth_out = m.get('InternetMaxBandwidthOut')
        if m.get('HostName') is not None:
            self.host_name = m.get('HostName')
        if m.get('ZoneId') is not None:
            self.zone_id = m.get('ZoneId')
        if m.get('IoOptimized') is not None:
            self.io_optimized = m.get('IoOptimized')
        if m.get('InstanceChargeType') is not None:
            self.instance_charge_type = m.get('InstanceChargeType')
        if m.get('Period') is not None:
            self.period = m.get('Period')
        if m.get('InternetChargeType') is not None:
            self.internet_charge_type = m.get('InternetChargeType')
        if m.get('EnableVmOsConfig') is not None:
            self.enable_vm_os_config = m.get('EnableVmOsConfig')
        if m.get('NetworkType') is not None:
            self.network_type = m.get('NetworkType')
        if m.get('UserData') is not None:
            self.user_data = m.get('UserData')
        if m.get('KeyPairName') is not None:
            self.key_pair_name = m.get('KeyPairName')
        if m.get('RamRoleName') is not None:
            self.ram_role_name = m.get('RamRoleName')
        if m.get('AutoReleaseTime') is not None:
            self.auto_release_time = m.get('AutoReleaseTime')
        if m.get('SpotStrategy') is not None:
            self.spot_strategy = m.get('SpotStrategy')
        if m.get('SpotPriceLimit') is not None:
            self.spot_price_limit = m.get('SpotPriceLimit')
        if m.get('SpotDuration') is not None:
            self.spot_duration = m.get('SpotDuration')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        if m.get('SecurityEnhancementStrategy') is not None:
            self.security_enhancement_strategy = m.get('SecurityEnhancementStrategy')
        if m.get('PrivateIpAddress') is not None:
            self.private_ip_address = m.get('PrivateIpAddress')
        if m.get('DeploymentSetId') is not None:
            self.deployment_set_id = m.get('DeploymentSetId')
        return self


class CreateLaunchTemplateVersionResponseBody(TeaModel):
    def __init__(
        self,
        launch_template_version_number: int = None,
        request_id: str = None,
    ):
        self.launch_template_version_number = launch_template_version_number
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.launch_template_version_number is not None:
            result['LaunchTemplateVersionNumber'] = self.launch_template_version_number
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('LaunchTemplateVersionNumber') is not None:
            self.launch_template_version_number = m.get('LaunchTemplateVersionNumber')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateLaunchTemplateVersionResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CreateLaunchTemplateVersionResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateLaunchTemplateVersionResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateNatGatewayRequestBandwidthPackage(TeaModel):
    def __init__(
        self,
        bandwidth: int = None,
        zone: str = None,
        ip_count: int = None,
    ):
        self.bandwidth = bandwidth
        self.zone = zone
        self.ip_count = ip_count

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bandwidth is not None:
            result['Bandwidth'] = self.bandwidth
        if self.zone is not None:
            result['Zone'] = self.zone
        if self.ip_count is not None:
            result['IpCount'] = self.ip_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Bandwidth') is not None:
            self.bandwidth = m.get('Bandwidth')
        if m.get('Zone') is not None:
            self.zone = m.get('Zone')
        if m.get('IpCount') is not None:
            self.ip_count = m.get('IpCount')
        return self


class CreateNatGatewayRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        owner_account: str = None,
        region_id: str = None,
        vpc_id: str = None,
        name: str = None,
        description: str = None,
        client_token: str = None,
        bandwidth_package: List[CreateNatGatewayRequestBandwidthPackage] = None,
    ):
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.owner_account = owner_account
        self.region_id = region_id
        self.vpc_id = vpc_id
        self.name = name
        self.description = description
        self.client_token = client_token
        self.bandwidth_package = bandwidth_package

    def validate(self):
        if self.bandwidth_package:
            for k in self.bandwidth_package:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.vpc_id is not None:
            result['VpcId'] = self.vpc_id
        if self.name is not None:
            result['Name'] = self.name
        if self.description is not None:
            result['Description'] = self.description
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        result['BandwidthPackage'] = []
        if self.bandwidth_package is not None:
            for k in self.bandwidth_package:
                result['BandwidthPackage'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('VpcId') is not None:
            self.vpc_id = m.get('VpcId')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        self.bandwidth_package = []
        if m.get('BandwidthPackage') is not None:
            for k in m.get('BandwidthPackage'):
                temp_model = CreateNatGatewayRequestBandwidthPackage()
                self.bandwidth_package.append(temp_model.from_map(k))
        return self


class CreateNatGatewayResponseBodyForwardTableIds(TeaModel):
    def __init__(
        self,
        forward_table_id: List[str] = None,
    ):
        self.forward_table_id = forward_table_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.forward_table_id is not None:
            result['ForwardTableId'] = self.forward_table_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ForwardTableId') is not None:
            self.forward_table_id = m.get('ForwardTableId')
        return self


class CreateNatGatewayResponseBodyBandwidthPackageIds(TeaModel):
    def __init__(
        self,
        bandwidth_package_id: List[str] = None,
    ):
        self.bandwidth_package_id = bandwidth_package_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bandwidth_package_id is not None:
            result['BandwidthPackageId'] = self.bandwidth_package_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BandwidthPackageId') is not None:
            self.bandwidth_package_id = m.get('BandwidthPackageId')
        return self


class CreateNatGatewayResponseBody(TeaModel):
    def __init__(
        self,
        nat_gateway_id: str = None,
        request_id: str = None,
        forward_table_ids: CreateNatGatewayResponseBodyForwardTableIds = None,
        bandwidth_package_ids: CreateNatGatewayResponseBodyBandwidthPackageIds = None,
    ):
        self.nat_gateway_id = nat_gateway_id
        self.request_id = request_id
        self.forward_table_ids = forward_table_ids
        self.bandwidth_package_ids = bandwidth_package_ids

    def validate(self):
        if self.forward_table_ids:
            self.forward_table_ids.validate()
        if self.bandwidth_package_ids:
            self.bandwidth_package_ids.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.nat_gateway_id is not None:
            result['NatGatewayId'] = self.nat_gateway_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.forward_table_ids is not None:
            result['ForwardTableIds'] = self.forward_table_ids.to_map()
        if self.bandwidth_package_ids is not None:
            result['BandwidthPackageIds'] = self.bandwidth_package_ids.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('NatGatewayId') is not None:
            self.nat_gateway_id = m.get('NatGatewayId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ForwardTableIds') is not None:
            temp_model = CreateNatGatewayResponseBodyForwardTableIds()
            self.forward_table_ids = temp_model.from_map(m['ForwardTableIds'])
        if m.get('BandwidthPackageIds') is not None:
            temp_model = CreateNatGatewayResponseBodyBandwidthPackageIds()
            self.bandwidth_package_ids = temp_model.from_map(m['BandwidthPackageIds'])
        return self


class CreateNatGatewayResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CreateNatGatewayResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateNatGatewayResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateNetworkInterfaceRequestTag(TeaModel):
    def __init__(
        self,
        key: str = None,
        value: str = None,
    ):
        self.key = key
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class CreateNetworkInterfaceRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        owner_account: str = None,
        region_id: str = None,
        tag: List[CreateNetworkInterfaceRequestTag] = None,
        resource_group_id: str = None,
        v_switch_id: str = None,
        primary_ip_address: str = None,
        security_group_id: str = None,
        network_interface_name: str = None,
        description: str = None,
        visible: bool = None,
        instance_type: str = None,
        business_type: str = None,
        secondary_private_ip_address_count: int = None,
        queue_number: int = None,
        client_token: str = None,
        network_interface_traffic_mode: str = None,
        queue_pair_number: int = None,
        security_group_ids: List[str] = None,
        private_ip_address: List[str] = None,
        ipv_6address: List[str] = None,
        ipv_6address_count: int = None,
    ):
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.owner_account = owner_account
        self.region_id = region_id
        self.tag = tag
        self.resource_group_id = resource_group_id
        self.v_switch_id = v_switch_id
        self.primary_ip_address = primary_ip_address
        self.security_group_id = security_group_id
        self.network_interface_name = network_interface_name
        self.description = description
        self.visible = visible
        self.instance_type = instance_type
        self.business_type = business_type
        self.secondary_private_ip_address_count = secondary_private_ip_address_count
        self.queue_number = queue_number
        self.client_token = client_token
        self.network_interface_traffic_mode = network_interface_traffic_mode
        self.queue_pair_number = queue_pair_number
        self.security_group_ids = security_group_ids
        self.private_ip_address = private_ip_address
        self.ipv_6address = ipv_6address
        self.ipv_6address_count = ipv_6address_count

    def validate(self):
        if self.tag:
            for k in self.tag:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        result['Tag'] = []
        if self.tag is not None:
            for k in self.tag:
                result['Tag'].append(k.to_map() if k else None)
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.v_switch_id is not None:
            result['VSwitchId'] = self.v_switch_id
        if self.primary_ip_address is not None:
            result['PrimaryIpAddress'] = self.primary_ip_address
        if self.security_group_id is not None:
            result['SecurityGroupId'] = self.security_group_id
        if self.network_interface_name is not None:
            result['NetworkInterfaceName'] = self.network_interface_name
        if self.description is not None:
            result['Description'] = self.description
        if self.visible is not None:
            result['Visible'] = self.visible
        if self.instance_type is not None:
            result['InstanceType'] = self.instance_type
        if self.business_type is not None:
            result['BusinessType'] = self.business_type
        if self.secondary_private_ip_address_count is not None:
            result['SecondaryPrivateIpAddressCount'] = self.secondary_private_ip_address_count
        if self.queue_number is not None:
            result['QueueNumber'] = self.queue_number
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.network_interface_traffic_mode is not None:
            result['NetworkInterfaceTrafficMode'] = self.network_interface_traffic_mode
        if self.queue_pair_number is not None:
            result['QueuePairNumber'] = self.queue_pair_number
        if self.security_group_ids is not None:
            result['SecurityGroupIds'] = self.security_group_ids
        if self.private_ip_address is not None:
            result['PrivateIpAddress'] = self.private_ip_address
        if self.ipv_6address is not None:
            result['Ipv6Address'] = self.ipv_6address
        if self.ipv_6address_count is not None:
            result['Ipv6AddressCount'] = self.ipv_6address_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        self.tag = []
        if m.get('Tag') is not None:
            for k in m.get('Tag'):
                temp_model = CreateNetworkInterfaceRequestTag()
                self.tag.append(temp_model.from_map(k))
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        if m.get('VSwitchId') is not None:
            self.v_switch_id = m.get('VSwitchId')
        if m.get('PrimaryIpAddress') is not None:
            self.primary_ip_address = m.get('PrimaryIpAddress')
        if m.get('SecurityGroupId') is not None:
            self.security_group_id = m.get('SecurityGroupId')
        if m.get('NetworkInterfaceName') is not None:
            self.network_interface_name = m.get('NetworkInterfaceName')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('Visible') is not None:
            self.visible = m.get('Visible')
        if m.get('InstanceType') is not None:
            self.instance_type = m.get('InstanceType')
        if m.get('BusinessType') is not None:
            self.business_type = m.get('BusinessType')
        if m.get('SecondaryPrivateIpAddressCount') is not None:
            self.secondary_private_ip_address_count = m.get('SecondaryPrivateIpAddressCount')
        if m.get('QueueNumber') is not None:
            self.queue_number = m.get('QueueNumber')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('NetworkInterfaceTrafficMode') is not None:
            self.network_interface_traffic_mode = m.get('NetworkInterfaceTrafficMode')
        if m.get('QueuePairNumber') is not None:
            self.queue_pair_number = m.get('QueuePairNumber')
        if m.get('SecurityGroupIds') is not None:
            self.security_group_ids = m.get('SecurityGroupIds')
        if m.get('PrivateIpAddress') is not None:
            self.private_ip_address = m.get('PrivateIpAddress')
        if m.get('Ipv6Address') is not None:
            self.ipv_6address = m.get('Ipv6Address')
        if m.get('Ipv6AddressCount') is not None:
            self.ipv_6address_count = m.get('Ipv6AddressCount')
        return self


class CreateNetworkInterfaceResponseBodySecurityGroupIds(TeaModel):
    def __init__(
        self,
        security_group_id: List[str] = None,
    ):
        self.security_group_id = security_group_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.security_group_id is not None:
            result['SecurityGroupId'] = self.security_group_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('SecurityGroupId') is not None:
            self.security_group_id = m.get('SecurityGroupId')
        return self


class CreateNetworkInterfaceResponseBodyPrivateIpSetsPrivateIpSet(TeaModel):
    def __init__(
        self,
        private_ip_address: str = None,
        primary: bool = None,
    ):
        self.private_ip_address = private_ip_address
        self.primary = primary

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.private_ip_address is not None:
            result['PrivateIpAddress'] = self.private_ip_address
        if self.primary is not None:
            result['Primary'] = self.primary
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PrivateIpAddress') is not None:
            self.private_ip_address = m.get('PrivateIpAddress')
        if m.get('Primary') is not None:
            self.primary = m.get('Primary')
        return self


class CreateNetworkInterfaceResponseBodyPrivateIpSets(TeaModel):
    def __init__(
        self,
        private_ip_set: List[CreateNetworkInterfaceResponseBodyPrivateIpSetsPrivateIpSet] = None,
    ):
        self.private_ip_set = private_ip_set

    def validate(self):
        if self.private_ip_set:
            for k in self.private_ip_set:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['PrivateIpSet'] = []
        if self.private_ip_set is not None:
            for k in self.private_ip_set:
                result['PrivateIpSet'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.private_ip_set = []
        if m.get('PrivateIpSet') is not None:
            for k in m.get('PrivateIpSet'):
                temp_model = CreateNetworkInterfaceResponseBodyPrivateIpSetsPrivateIpSet()
                self.private_ip_set.append(temp_model.from_map(k))
        return self


class CreateNetworkInterfaceResponseBodyTagsTag(TeaModel):
    def __init__(
        self,
        tag_value: str = None,
        tag_key: str = None,
    ):
        self.tag_value = tag_value
        self.tag_key = tag_key

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.tag_value is not None:
            result['TagValue'] = self.tag_value
        if self.tag_key is not None:
            result['TagKey'] = self.tag_key
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TagValue') is not None:
            self.tag_value = m.get('TagValue')
        if m.get('TagKey') is not None:
            self.tag_key = m.get('TagKey')
        return self


class CreateNetworkInterfaceResponseBodyTags(TeaModel):
    def __init__(
        self,
        tag: List[CreateNetworkInterfaceResponseBodyTagsTag] = None,
    ):
        self.tag = tag

    def validate(self):
        if self.tag:
            for k in self.tag:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Tag'] = []
        if self.tag is not None:
            for k in self.tag:
                result['Tag'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.tag = []
        if m.get('Tag') is not None:
            for k in m.get('Tag'):
                temp_model = CreateNetworkInterfaceResponseBodyTagsTag()
                self.tag.append(temp_model.from_map(k))
        return self


class CreateNetworkInterfaceResponseBodyIpv6SetsIpv6Set(TeaModel):
    def __init__(
        self,
        ipv_6address: str = None,
    ):
        self.ipv_6address = ipv_6address

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ipv_6address is not None:
            result['Ipv6Address'] = self.ipv_6address
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Ipv6Address') is not None:
            self.ipv_6address = m.get('Ipv6Address')
        return self


class CreateNetworkInterfaceResponseBodyIpv6Sets(TeaModel):
    def __init__(
        self,
        ipv_6set: List[CreateNetworkInterfaceResponseBodyIpv6SetsIpv6Set] = None,
    ):
        self.ipv_6set = ipv_6set

    def validate(self):
        if self.ipv_6set:
            for k in self.ipv_6set:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Ipv6Set'] = []
        if self.ipv_6set is not None:
            for k in self.ipv_6set:
                result['Ipv6Set'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.ipv_6set = []
        if m.get('Ipv6Set') is not None:
            for k in m.get('Ipv6Set'):
                temp_model = CreateNetworkInterfaceResponseBodyIpv6SetsIpv6Set()
                self.ipv_6set.append(temp_model.from_map(k))
        return self


class CreateNetworkInterfaceResponseBody(TeaModel):
    def __init__(
        self,
        status: str = None,
        type: str = None,
        vpc_id: str = None,
        network_interface_name: str = None,
        mac_address: str = None,
        network_interface_id: str = None,
        service_id: int = None,
        owner_id: str = None,
        service_managed: bool = None,
        v_switch_id: str = None,
        request_id: str = None,
        description: str = None,
        resource_group_id: str = None,
        zone_id: str = None,
        private_ip_address: str = None,
        security_group_ids: CreateNetworkInterfaceResponseBodySecurityGroupIds = None,
        private_ip_sets: CreateNetworkInterfaceResponseBodyPrivateIpSets = None,
        tags: CreateNetworkInterfaceResponseBodyTags = None,
        ipv_6sets: CreateNetworkInterfaceResponseBodyIpv6Sets = None,
    ):
        self.status = status
        self.type = type
        self.vpc_id = vpc_id
        self.network_interface_name = network_interface_name
        self.mac_address = mac_address
        self.network_interface_id = network_interface_id
        self.service_id = service_id
        self.owner_id = owner_id
        self.service_managed = service_managed
        self.v_switch_id = v_switch_id
        self.request_id = request_id
        self.description = description
        self.resource_group_id = resource_group_id
        self.zone_id = zone_id
        self.private_ip_address = private_ip_address
        self.security_group_ids = security_group_ids
        self.private_ip_sets = private_ip_sets
        self.tags = tags
        self.ipv_6sets = ipv_6sets

    def validate(self):
        if self.security_group_ids:
            self.security_group_ids.validate()
        if self.private_ip_sets:
            self.private_ip_sets.validate()
        if self.tags:
            self.tags.validate()
        if self.ipv_6sets:
            self.ipv_6sets.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.status is not None:
            result['Status'] = self.status
        if self.type is not None:
            result['Type'] = self.type
        if self.vpc_id is not None:
            result['VpcId'] = self.vpc_id
        if self.network_interface_name is not None:
            result['NetworkInterfaceName'] = self.network_interface_name
        if self.mac_address is not None:
            result['MacAddress'] = self.mac_address
        if self.network_interface_id is not None:
            result['NetworkInterfaceId'] = self.network_interface_id
        if self.service_id is not None:
            result['ServiceID'] = self.service_id
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.service_managed is not None:
            result['ServiceManaged'] = self.service_managed
        if self.v_switch_id is not None:
            result['VSwitchId'] = self.v_switch_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.description is not None:
            result['Description'] = self.description
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.zone_id is not None:
            result['ZoneId'] = self.zone_id
        if self.private_ip_address is not None:
            result['PrivateIpAddress'] = self.private_ip_address
        if self.security_group_ids is not None:
            result['SecurityGroupIds'] = self.security_group_ids.to_map()
        if self.private_ip_sets is not None:
            result['PrivateIpSets'] = self.private_ip_sets.to_map()
        if self.tags is not None:
            result['Tags'] = self.tags.to_map()
        if self.ipv_6sets is not None:
            result['Ipv6Sets'] = self.ipv_6sets.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('VpcId') is not None:
            self.vpc_id = m.get('VpcId')
        if m.get('NetworkInterfaceName') is not None:
            self.network_interface_name = m.get('NetworkInterfaceName')
        if m.get('MacAddress') is not None:
            self.mac_address = m.get('MacAddress')
        if m.get('NetworkInterfaceId') is not None:
            self.network_interface_id = m.get('NetworkInterfaceId')
        if m.get('ServiceID') is not None:
            self.service_id = m.get('ServiceID')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ServiceManaged') is not None:
            self.service_managed = m.get('ServiceManaged')
        if m.get('VSwitchId') is not None:
            self.v_switch_id = m.get('VSwitchId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        if m.get('ZoneId') is not None:
            self.zone_id = m.get('ZoneId')
        if m.get('PrivateIpAddress') is not None:
            self.private_ip_address = m.get('PrivateIpAddress')
        if m.get('SecurityGroupIds') is not None:
            temp_model = CreateNetworkInterfaceResponseBodySecurityGroupIds()
            self.security_group_ids = temp_model.from_map(m['SecurityGroupIds'])
        if m.get('PrivateIpSets') is not None:
            temp_model = CreateNetworkInterfaceResponseBodyPrivateIpSets()
            self.private_ip_sets = temp_model.from_map(m['PrivateIpSets'])
        if m.get('Tags') is not None:
            temp_model = CreateNetworkInterfaceResponseBodyTags()
            self.tags = temp_model.from_map(m['Tags'])
        if m.get('Ipv6Sets') is not None:
            temp_model = CreateNetworkInterfaceResponseBodyIpv6Sets()
            self.ipv_6sets = temp_model.from_map(m['Ipv6Sets'])
        return self


class CreateNetworkInterfaceResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CreateNetworkInterfaceResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateNetworkInterfaceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateNetworkInterfacePermissionRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        owner_account: str = None,
        region_id: str = None,
        account_id: int = None,
        network_interface_id: str = None,
        permission: str = None,
    ):
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.owner_account = owner_account
        self.region_id = region_id
        self.account_id = account_id
        self.network_interface_id = network_interface_id
        self.permission = permission

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.account_id is not None:
            result['AccountId'] = self.account_id
        if self.network_interface_id is not None:
            result['NetworkInterfaceId'] = self.network_interface_id
        if self.permission is not None:
            result['Permission'] = self.permission
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('AccountId') is not None:
            self.account_id = m.get('AccountId')
        if m.get('NetworkInterfaceId') is not None:
            self.network_interface_id = m.get('NetworkInterfaceId')
        if m.get('Permission') is not None:
            self.permission = m.get('Permission')
        return self


class CreateNetworkInterfacePermissionResponseBodyNetworkInterfacePermission(TeaModel):
    def __init__(
        self,
        permission: str = None,
        network_interface_id: str = None,
        account_id: int = None,
        network_interface_permission_id: str = None,
        service_name: str = None,
        permission_state: str = None,
    ):
        self.permission = permission
        self.network_interface_id = network_interface_id
        self.account_id = account_id
        self.network_interface_permission_id = network_interface_permission_id
        self.service_name = service_name
        self.permission_state = permission_state

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.permission is not None:
            result['Permission'] = self.permission
        if self.network_interface_id is not None:
            result['NetworkInterfaceId'] = self.network_interface_id
        if self.account_id is not None:
            result['AccountId'] = self.account_id
        if self.network_interface_permission_id is not None:
            result['NetworkInterfacePermissionId'] = self.network_interface_permission_id
        if self.service_name is not None:
            result['ServiceName'] = self.service_name
        if self.permission_state is not None:
            result['PermissionState'] = self.permission_state
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Permission') is not None:
            self.permission = m.get('Permission')
        if m.get('NetworkInterfaceId') is not None:
            self.network_interface_id = m.get('NetworkInterfaceId')
        if m.get('AccountId') is not None:
            self.account_id = m.get('AccountId')
        if m.get('NetworkInterfacePermissionId') is not None:
            self.network_interface_permission_id = m.get('NetworkInterfacePermissionId')
        if m.get('ServiceName') is not None:
            self.service_name = m.get('ServiceName')
        if m.get('PermissionState') is not None:
            self.permission_state = m.get('PermissionState')
        return self


class CreateNetworkInterfacePermissionResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        network_interface_permission: CreateNetworkInterfacePermissionResponseBodyNetworkInterfacePermission = None,
    ):
        self.request_id = request_id
        self.network_interface_permission = network_interface_permission

    def validate(self):
        if self.network_interface_permission:
            self.network_interface_permission.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.network_interface_permission is not None:
            result['NetworkInterfacePermission'] = self.network_interface_permission.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('NetworkInterfacePermission') is not None:
            temp_model = CreateNetworkInterfacePermissionResponseBodyNetworkInterfacePermission()
            self.network_interface_permission = temp_model.from_map(m['NetworkInterfacePermission'])
        return self


class CreateNetworkInterfacePermissionResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CreateNetworkInterfacePermissionResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateNetworkInterfacePermissionResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreatePhysicalConnectionRequest(TeaModel):
    def __init__(
        self,
        region_id: str = None,
        access_point_id: str = None,
        type: str = None,
        line_operator: str = None,
        bandwidth: int = None,
        peer_location: str = None,
        port_type: str = None,
        redundant_physical_connection_id: str = None,
        description: str = None,
        name: str = None,
        circuit_code: str = None,
        client_token: str = None,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        owner_account: str = None,
        user_cidr: str = None,
    ):
        self.region_id = region_id
        self.access_point_id = access_point_id
        self.type = type
        self.line_operator = line_operator
        self.bandwidth = bandwidth
        self.peer_location = peer_location
        self.port_type = port_type
        self.redundant_physical_connection_id = redundant_physical_connection_id
        self.description = description
        self.name = name
        self.circuit_code = circuit_code
        self.client_token = client_token
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.owner_account = owner_account
        self.user_cidr = user_cidr

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.access_point_id is not None:
            result['AccessPointId'] = self.access_point_id
        if self.type is not None:
            result['Type'] = self.type
        if self.line_operator is not None:
            result['LineOperator'] = self.line_operator
        if self.bandwidth is not None:
            result['bandwidth'] = self.bandwidth
        if self.peer_location is not None:
            result['PeerLocation'] = self.peer_location
        if self.port_type is not None:
            result['PortType'] = self.port_type
        if self.redundant_physical_connection_id is not None:
            result['RedundantPhysicalConnectionId'] = self.redundant_physical_connection_id
        if self.description is not None:
            result['Description'] = self.description
        if self.name is not None:
            result['Name'] = self.name
        if self.circuit_code is not None:
            result['CircuitCode'] = self.circuit_code
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.user_cidr is not None:
            result['UserCidr'] = self.user_cidr
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('AccessPointId') is not None:
            self.access_point_id = m.get('AccessPointId')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('LineOperator') is not None:
            self.line_operator = m.get('LineOperator')
        if m.get('bandwidth') is not None:
            self.bandwidth = m.get('bandwidth')
        if m.get('PeerLocation') is not None:
            self.peer_location = m.get('PeerLocation')
        if m.get('PortType') is not None:
            self.port_type = m.get('PortType')
        if m.get('RedundantPhysicalConnectionId') is not None:
            self.redundant_physical_connection_id = m.get('RedundantPhysicalConnectionId')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('CircuitCode') is not None:
            self.circuit_code = m.get('CircuitCode')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('UserCidr') is not None:
            self.user_cidr = m.get('UserCidr')
        return self


class CreatePhysicalConnectionResponseBody(TeaModel):
    def __init__(
        self,
        physical_connection_id: str = None,
        request_id: str = None,
    ):
        self.physical_connection_id = physical_connection_id
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.physical_connection_id is not None:
            result['PhysicalConnectionId'] = self.physical_connection_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PhysicalConnectionId') is not None:
            self.physical_connection_id = m.get('PhysicalConnectionId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreatePhysicalConnectionResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CreatePhysicalConnectionResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreatePhysicalConnectionResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreatePrefixListRequestEntry(TeaModel):
    def __init__(
        self,
        description: str = None,
        cidr: str = None,
    ):
        self.description = description
        self.cidr = cidr

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.description is not None:
            result['Description'] = self.description
        if self.cidr is not None:
            result['Cidr'] = self.cidr
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('Cidr') is not None:
            self.cidr = m.get('Cidr')
        return self


class CreatePrefixListRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        owner_account: str = None,
        region_id: str = None,
        entry: List[CreatePrefixListRequestEntry] = None,
        max_entries: int = None,
        address_family: str = None,
        client_token: str = None,
        prefix_list_name: str = None,
        description: str = None,
    ):
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.owner_account = owner_account
        self.region_id = region_id
        self.entry = entry
        self.max_entries = max_entries
        self.address_family = address_family
        self.client_token = client_token
        self.prefix_list_name = prefix_list_name
        self.description = description

    def validate(self):
        if self.entry:
            for k in self.entry:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        result['Entry'] = []
        if self.entry is not None:
            for k in self.entry:
                result['Entry'].append(k.to_map() if k else None)
        if self.max_entries is not None:
            result['MaxEntries'] = self.max_entries
        if self.address_family is not None:
            result['AddressFamily'] = self.address_family
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.prefix_list_name is not None:
            result['PrefixListName'] = self.prefix_list_name
        if self.description is not None:
            result['Description'] = self.description
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        self.entry = []
        if m.get('Entry') is not None:
            for k in m.get('Entry'):
                temp_model = CreatePrefixListRequestEntry()
                self.entry.append(temp_model.from_map(k))
        if m.get('MaxEntries') is not None:
            self.max_entries = m.get('MaxEntries')
        if m.get('AddressFamily') is not None:
            self.address_family = m.get('AddressFamily')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('PrefixListName') is not None:
            self.prefix_list_name = m.get('PrefixListName')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        return self


class CreatePrefixListResponseBody(TeaModel):
    def __init__(
        self,
        prefix_list_id: str = None,
        request_id: str = None,
    ):
        self.prefix_list_id = prefix_list_id
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.prefix_list_id is not None:
            result['PrefixListId'] = self.prefix_list_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PrefixListId') is not None:
            self.prefix_list_id = m.get('PrefixListId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreatePrefixListResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CreatePrefixListResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreatePrefixListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateResource02RequestFilter(TeaModel):
    def __init__(
        self,
        key: str = None,
        value: str = None,
    ):
        self.key = key
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class CreateResource02Request(TeaModel):
    def __init__(
        self,
        status: str = None,
        filter: List[CreateResource02RequestFilter] = None,
    ):
        self.status = status
        self.filter = filter

    def validate(self):
        if self.filter:
            for k in self.filter:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.status is not None:
            result['Status'] = self.status
        result['Filter'] = []
        if self.filter is not None:
            for k in self.filter:
                result['Filter'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Status') is not None:
            self.status = m.get('Status')
        self.filter = []
        if m.get('Filter') is not None:
            for k in m.get('Filter'):
                temp_model = CreateResource02RequestFilter()
                self.filter.append(temp_model.from_map(k))
        return self


class CreateResource02ResponseBody(TeaModel):
    def __init__(
        self,
        status: str = None,
        request_id: str = None,
        ids: str = None,
    ):
        self.status = status
        self.request_id = request_id
        self.ids = ids

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.status is not None:
            result['Status'] = self.status
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.ids is not None:
            result['ids'] = self.ids
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ids') is not None:
            self.ids = m.get('ids')
        return self


class CreateResource02Response(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CreateResource02ResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateResource02ResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateRouteEntryRequestNextHopList(TeaModel):
    def __init__(
        self,
        next_hop_id: str = None,
        next_hop_type: str = None,
    ):
        self.next_hop_id = next_hop_id
        self.next_hop_type = next_hop_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.next_hop_id is not None:
            result['NextHopId'] = self.next_hop_id
        if self.next_hop_type is not None:
            result['NextHopType'] = self.next_hop_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('NextHopId') is not None:
            self.next_hop_id = m.get('NextHopId')
        if m.get('NextHopType') is not None:
            self.next_hop_type = m.get('NextHopType')
        return self


class CreateRouteEntryRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        region_id: str = None,
        route_table_id: str = None,
        destination_cidr_block: str = None,
        next_hop_id: str = None,
        client_token: str = None,
        next_hop_type: str = None,
        owner_account: str = None,
        next_hop_list: List[CreateRouteEntryRequestNextHopList] = None,
    ):
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.region_id = region_id
        self.route_table_id = route_table_id
        self.destination_cidr_block = destination_cidr_block
        self.next_hop_id = next_hop_id
        self.client_token = client_token
        self.next_hop_type = next_hop_type
        self.owner_account = owner_account
        self.next_hop_list = next_hop_list

    def validate(self):
        if self.next_hop_list:
            for k in self.next_hop_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.route_table_id is not None:
            result['RouteTableId'] = self.route_table_id
        if self.destination_cidr_block is not None:
            result['DestinationCidrBlock'] = self.destination_cidr_block
        if self.next_hop_id is not None:
            result['NextHopId'] = self.next_hop_id
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.next_hop_type is not None:
            result['NextHopType'] = self.next_hop_type
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        result['NextHopList'] = []
        if self.next_hop_list is not None:
            for k in self.next_hop_list:
                result['NextHopList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('RouteTableId') is not None:
            self.route_table_id = m.get('RouteTableId')
        if m.get('DestinationCidrBlock') is not None:
            self.destination_cidr_block = m.get('DestinationCidrBlock')
        if m.get('NextHopId') is not None:
            self.next_hop_id = m.get('NextHopId')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('NextHopType') is not None:
            self.next_hop_type = m.get('NextHopType')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        self.next_hop_list = []
        if m.get('NextHopList') is not None:
            for k in m.get('NextHopList'):
                temp_model = CreateRouteEntryRequestNextHopList()
                self.next_hop_list.append(temp_model.from_map(k))
        return self


class CreateRouteEntryResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateRouteEntryResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CreateRouteEntryResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateRouteEntryResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateRouterInterfaceRequest(TeaModel):
    def __init__(
        self,
        region_id: str = None,
        role: str = None,
        opposite_region_id: str = None,
        spec: str = None,
        router_type: str = None,
        router_id: str = None,
        opposite_interface_id: str = None,
        opposite_router_id: str = None,
        opposite_router_type: str = None,
        opposite_interface_owner_id: str = None,
        health_check_source_ip: str = None,
        health_check_target_ip: str = None,
        access_point_id: str = None,
        opposite_access_point_id: str = None,
        description: str = None,
        name: str = None,
        period: int = None,
        instance_charge_type: str = None,
        auto_pay: bool = None,
        pricing_cycle: str = None,
        client_token: str = None,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        owner_account: str = None,
        user_cidr: str = None,
    ):
        self.region_id = region_id
        self.role = role
        self.opposite_region_id = opposite_region_id
        self.spec = spec
        self.router_type = router_type
        self.router_id = router_id
        self.opposite_interface_id = opposite_interface_id
        self.opposite_router_id = opposite_router_id
        self.opposite_router_type = opposite_router_type
        self.opposite_interface_owner_id = opposite_interface_owner_id
        self.health_check_source_ip = health_check_source_ip
        self.health_check_target_ip = health_check_target_ip
        self.access_point_id = access_point_id
        self.opposite_access_point_id = opposite_access_point_id
        self.description = description
        self.name = name
        self.period = period
        self.instance_charge_type = instance_charge_type
        self.auto_pay = auto_pay
        self.pricing_cycle = pricing_cycle
        self.client_token = client_token
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.owner_account = owner_account
        self.user_cidr = user_cidr

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.role is not None:
            result['Role'] = self.role
        if self.opposite_region_id is not None:
            result['OppositeRegionId'] = self.opposite_region_id
        if self.spec is not None:
            result['Spec'] = self.spec
        if self.router_type is not None:
            result['RouterType'] = self.router_type
        if self.router_id is not None:
            result['RouterId'] = self.router_id
        if self.opposite_interface_id is not None:
            result['OppositeInterfaceId'] = self.opposite_interface_id
        if self.opposite_router_id is not None:
            result['OppositeRouterId'] = self.opposite_router_id
        if self.opposite_router_type is not None:
            result['OppositeRouterType'] = self.opposite_router_type
        if self.opposite_interface_owner_id is not None:
            result['OppositeInterfaceOwnerId'] = self.opposite_interface_owner_id
        if self.health_check_source_ip is not None:
            result['HealthCheckSourceIp'] = self.health_check_source_ip
        if self.health_check_target_ip is not None:
            result['HealthCheckTargetIp'] = self.health_check_target_ip
        if self.access_point_id is not None:
            result['AccessPointId'] = self.access_point_id
        if self.opposite_access_point_id is not None:
            result['OppositeAccessPointId'] = self.opposite_access_point_id
        if self.description is not None:
            result['Description'] = self.description
        if self.name is not None:
            result['Name'] = self.name
        if self.period is not None:
            result['Period'] = self.period
        if self.instance_charge_type is not None:
            result['InstanceChargeType'] = self.instance_charge_type
        if self.auto_pay is not None:
            result['AutoPay'] = self.auto_pay
        if self.pricing_cycle is not None:
            result['PricingCycle'] = self.pricing_cycle
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.user_cidr is not None:
            result['UserCidr'] = self.user_cidr
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('Role') is not None:
            self.role = m.get('Role')
        if m.get('OppositeRegionId') is not None:
            self.opposite_region_id = m.get('OppositeRegionId')
        if m.get('Spec') is not None:
            self.spec = m.get('Spec')
        if m.get('RouterType') is not None:
            self.router_type = m.get('RouterType')
        if m.get('RouterId') is not None:
            self.router_id = m.get('RouterId')
        if m.get('OppositeInterfaceId') is not None:
            self.opposite_interface_id = m.get('OppositeInterfaceId')
        if m.get('OppositeRouterId') is not None:
            self.opposite_router_id = m.get('OppositeRouterId')
        if m.get('OppositeRouterType') is not None:
            self.opposite_router_type = m.get('OppositeRouterType')
        if m.get('OppositeInterfaceOwnerId') is not None:
            self.opposite_interface_owner_id = m.get('OppositeInterfaceOwnerId')
        if m.get('HealthCheckSourceIp') is not None:
            self.health_check_source_ip = m.get('HealthCheckSourceIp')
        if m.get('HealthCheckTargetIp') is not None:
            self.health_check_target_ip = m.get('HealthCheckTargetIp')
        if m.get('AccessPointId') is not None:
            self.access_point_id = m.get('AccessPointId')
        if m.get('OppositeAccessPointId') is not None:
            self.opposite_access_point_id = m.get('OppositeAccessPointId')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Period') is not None:
            self.period = m.get('Period')
        if m.get('InstanceChargeType') is not None:
            self.instance_charge_type = m.get('InstanceChargeType')
        if m.get('AutoPay') is not None:
            self.auto_pay = m.get('AutoPay')
        if m.get('PricingCycle') is not None:
            self.pricing_cycle = m.get('PricingCycle')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('UserCidr') is not None:
            self.user_cidr = m.get('UserCidr')
        return self


class CreateRouterInterfaceResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        order_id: int = None,
        router_interface_id: str = None,
    ):
        self.request_id = request_id
        self.order_id = order_id
        self.router_interface_id = router_interface_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.order_id is not None:
            result['OrderId'] = self.order_id
        if self.router_interface_id is not None:
            result['RouterInterfaceId'] = self.router_interface_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('OrderId') is not None:
            self.order_id = m.get('OrderId')
        if m.get('RouterInterfaceId') is not None:
            self.router_interface_id = m.get('RouterInterfaceId')
        return self


class CreateRouterInterfaceResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CreateRouterInterfaceResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateRouterInterfaceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateSecurityGroupRequestTag(TeaModel):
    def __init__(
        self,
        key: str = None,
        value: str = None,
    ):
        self.key = key
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('key') is not None:
            self.key = m.get('key')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class CreateSecurityGroupRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        region_id: str = None,
        description: str = None,
        client_token: str = None,
        security_group_name: str = None,
        vpc_id: str = None,
        security_group_type: str = None,
        service_managed: bool = None,
        owner_account: str = None,
        resource_group_id: str = None,
        tag: List[CreateSecurityGroupRequestTag] = None,
    ):
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.region_id = region_id
        self.description = description
        self.client_token = client_token
        self.security_group_name = security_group_name
        self.vpc_id = vpc_id
        self.security_group_type = security_group_type
        self.service_managed = service_managed
        self.owner_account = owner_account
        self.resource_group_id = resource_group_id
        self.tag = tag

    def validate(self):
        if self.tag:
            for k in self.tag:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.description is not None:
            result['Description'] = self.description
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.security_group_name is not None:
            result['SecurityGroupName'] = self.security_group_name
        if self.vpc_id is not None:
            result['VpcId'] = self.vpc_id
        if self.security_group_type is not None:
            result['SecurityGroupType'] = self.security_group_type
        if self.service_managed is not None:
            result['ServiceManaged'] = self.service_managed
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        result['Tag'] = []
        if self.tag is not None:
            for k in self.tag:
                result['Tag'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('SecurityGroupName') is not None:
            self.security_group_name = m.get('SecurityGroupName')
        if m.get('VpcId') is not None:
            self.vpc_id = m.get('VpcId')
        if m.get('SecurityGroupType') is not None:
            self.security_group_type = m.get('SecurityGroupType')
        if m.get('ServiceManaged') is not None:
            self.service_managed = m.get('ServiceManaged')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        self.tag = []
        if m.get('Tag') is not None:
            for k in m.get('Tag'):
                temp_model = CreateSecurityGroupRequestTag()
                self.tag.append(temp_model.from_map(k))
        return self


class CreateSecurityGroupResponseBody(TeaModel):
    def __init__(
        self,
        security_group_id: str = None,
        request_id: str = None,
    ):
        self.security_group_id = security_group_id
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.security_group_id is not None:
            result['SecurityGroupId'] = self.security_group_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('SecurityGroupId') is not None:
            self.security_group_id = m.get('SecurityGroupId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateSecurityGroupResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CreateSecurityGroupResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateSecurityGroupResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateSimulatedSystemEventsRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        owner_account: str = None,
        region_id: str = None,
        instance_id: List[str] = None,
        event_type: str = None,
        not_before: str = None,
    ):
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.owner_account = owner_account
        self.region_id = region_id
        self.instance_id = instance_id
        self.event_type = event_type
        self.not_before = not_before

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.event_type is not None:
            result['EventType'] = self.event_type
        if self.not_before is not None:
            result['NotBefore'] = self.not_before
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('EventType') is not None:
            self.event_type = m.get('EventType')
        if m.get('NotBefore') is not None:
            self.not_before = m.get('NotBefore')
        return self


class CreateSimulatedSystemEventsResponseBodyEventIdSet(TeaModel):
    def __init__(
        self,
        event_id: List[str] = None,
    ):
        self.event_id = event_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.event_id is not None:
            result['EventId'] = self.event_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('EventId') is not None:
            self.event_id = m.get('EventId')
        return self


class CreateSimulatedSystemEventsResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        event_id_set: CreateSimulatedSystemEventsResponseBodyEventIdSet = None,
    ):
        self.request_id = request_id
        self.event_id_set = event_id_set

    def validate(self):
        if self.event_id_set:
            self.event_id_set.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.event_id_set is not None:
            result['EventIdSet'] = self.event_id_set.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('EventIdSet') is not None:
            temp_model = CreateSimulatedSystemEventsResponseBodyEventIdSet()
            self.event_id_set = temp_model.from_map(m['EventIdSet'])
        return self


class CreateSimulatedSystemEventsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CreateSimulatedSystemEventsResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateSimulatedSystemEventsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateSnapshotRequestTag(TeaModel):
    def __init__(
        self,
        key: str = None,
        value: str = None,
    ):
        self.key = key
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('key') is not None:
            self.key = m.get('key')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class CreateSnapshotRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        disk_id: str = None,
        snapshot_name: str = None,
        description: str = None,
        retention_days: int = None,
        category: str = None,
        client_token: str = None,
        owner_account: str = None,
        resource_group_id: str = None,
        instant_access: bool = None,
        instant_access_retention_days: int = None,
        tag: List[CreateSnapshotRequestTag] = None,
    ):
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.disk_id = disk_id
        self.snapshot_name = snapshot_name
        self.description = description
        self.retention_days = retention_days
        self.category = category
        self.client_token = client_token
        self.owner_account = owner_account
        self.resource_group_id = resource_group_id
        self.instant_access = instant_access
        self.instant_access_retention_days = instant_access_retention_days
        self.tag = tag

    def validate(self):
        if self.tag:
            for k in self.tag:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.disk_id is not None:
            result['DiskId'] = self.disk_id
        if self.snapshot_name is not None:
            result['SnapshotName'] = self.snapshot_name
        if self.description is not None:
            result['Description'] = self.description
        if self.retention_days is not None:
            result['RetentionDays'] = self.retention_days
        if self.category is not None:
            result['Category'] = self.category
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.instant_access is not None:
            result['InstantAccess'] = self.instant_access
        if self.instant_access_retention_days is not None:
            result['InstantAccessRetentionDays'] = self.instant_access_retention_days
        result['Tag'] = []
        if self.tag is not None:
            for k in self.tag:
                result['Tag'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('DiskId') is not None:
            self.disk_id = m.get('DiskId')
        if m.get('SnapshotName') is not None:
            self.snapshot_name = m.get('SnapshotName')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('RetentionDays') is not None:
            self.retention_days = m.get('RetentionDays')
        if m.get('Category') is not None:
            self.category = m.get('Category')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        if m.get('InstantAccess') is not None:
            self.instant_access = m.get('InstantAccess')
        if m.get('InstantAccessRetentionDays') is not None:
            self.instant_access_retention_days = m.get('InstantAccessRetentionDays')
        self.tag = []
        if m.get('Tag') is not None:
            for k in m.get('Tag'):
                temp_model = CreateSnapshotRequestTag()
                self.tag.append(temp_model.from_map(k))
        return self


class CreateSnapshotResponseBody(TeaModel):
    def __init__(
        self,
        snapshot_id: str = None,
        request_id: str = None,
    ):
        self.snapshot_id = snapshot_id
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.snapshot_id is not None:
            result['SnapshotId'] = self.snapshot_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('SnapshotId') is not None:
            self.snapshot_id = m.get('SnapshotId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateSnapshotResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CreateSnapshotResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateSnapshotResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateSnapshotGroupRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        owner_account: str = None,
        region_id: str = None,
        instance_id: str = None,
        instant_access: bool = None,
        instant_access_retention_days: int = None,
        name: str = None,
        description: str = None,
        exclude_disk_id: List[str] = None,
    ):
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.owner_account = owner_account
        self.region_id = region_id
        self.instance_id = instance_id
        self.instant_access = instant_access
        self.instant_access_retention_days = instant_access_retention_days
        self.name = name
        self.description = description
        self.exclude_disk_id = exclude_disk_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.instant_access is not None:
            result['InstantAccess'] = self.instant_access
        if self.instant_access_retention_days is not None:
            result['InstantAccessRetentionDays'] = self.instant_access_retention_days
        if self.name is not None:
            result['Name'] = self.name
        if self.description is not None:
            result['Description'] = self.description
        if self.exclude_disk_id is not None:
            result['ExcludeDiskId'] = self.exclude_disk_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('InstantAccess') is not None:
            self.instant_access = m.get('InstantAccess')
        if m.get('InstantAccessRetentionDays') is not None:
            self.instant_access_retention_days = m.get('InstantAccessRetentionDays')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('ExcludeDiskId') is not None:
            self.exclude_disk_id = m.get('ExcludeDiskId')
        return self


class CreateSnapshotGroupResponseBody(TeaModel):
    def __init__(
        self,
        snapshot_group_id: str = None,
        request_id: str = None,
    ):
        self.snapshot_group_id = snapshot_group_id
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.snapshot_group_id is not None:
            result['SnapshotGroupId'] = self.snapshot_group_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('SnapshotGroupId') is not None:
            self.snapshot_group_id = m.get('SnapshotGroupId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateSnapshotGroupResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CreateSnapshotGroupResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateSnapshotGroupResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateStorageSetRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        owner_account: str = None,
        client_token: str = None,
        region_id: str = None,
        zone_id: str = None,
        storage_set_name: str = None,
        description: str = None,
        max_partition_number: int = None,
    ):
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.owner_account = owner_account
        self.client_token = client_token
        self.region_id = region_id
        self.zone_id = zone_id
        self.storage_set_name = storage_set_name
        self.description = description
        self.max_partition_number = max_partition_number

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.zone_id is not None:
            result['ZoneId'] = self.zone_id
        if self.storage_set_name is not None:
            result['StorageSetName'] = self.storage_set_name
        if self.description is not None:
            result['Description'] = self.description
        if self.max_partition_number is not None:
            result['MaxPartitionNumber'] = self.max_partition_number
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ZoneId') is not None:
            self.zone_id = m.get('ZoneId')
        if m.get('StorageSetName') is not None:
            self.storage_set_name = m.get('StorageSetName')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('MaxPartitionNumber') is not None:
            self.max_partition_number = m.get('MaxPartitionNumber')
        return self


class CreateStorageSetResponseBody(TeaModel):
    def __init__(
        self,
        storage_set_id: str = None,
        request_id: str = None,
    ):
        self.storage_set_id = storage_set_id
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.storage_set_id is not None:
            result['StorageSetId'] = self.storage_set_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('StorageSetId') is not None:
            self.storage_set_id = m.get('StorageSetId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateStorageSetResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CreateStorageSetResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateStorageSetResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateVirtualBorderRouterRequest(TeaModel):
    def __init__(
        self,
        region_id: str = None,
        physical_connection_id: str = None,
        vbr_owner_id: int = None,
        vlan_id: int = None,
        circuit_code: str = None,
        local_gateway_ip: str = None,
        peer_gateway_ip: str = None,
        peering_subnet_mask: str = None,
        description: str = None,
        name: str = None,
        client_token: str = None,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        owner_account: str = None,
        user_cidr: str = None,
    ):
        self.region_id = region_id
        self.physical_connection_id = physical_connection_id
        self.vbr_owner_id = vbr_owner_id
        self.vlan_id = vlan_id
        self.circuit_code = circuit_code
        self.local_gateway_ip = local_gateway_ip
        self.peer_gateway_ip = peer_gateway_ip
        self.peering_subnet_mask = peering_subnet_mask
        self.description = description
        self.name = name
        self.client_token = client_token
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.owner_account = owner_account
        self.user_cidr = user_cidr

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.physical_connection_id is not None:
            result['PhysicalConnectionId'] = self.physical_connection_id
        if self.vbr_owner_id is not None:
            result['VbrOwnerId'] = self.vbr_owner_id
        if self.vlan_id is not None:
            result['VlanId'] = self.vlan_id
        if self.circuit_code is not None:
            result['CircuitCode'] = self.circuit_code
        if self.local_gateway_ip is not None:
            result['LocalGatewayIp'] = self.local_gateway_ip
        if self.peer_gateway_ip is not None:
            result['PeerGatewayIp'] = self.peer_gateway_ip
        if self.peering_subnet_mask is not None:
            result['PeeringSubnetMask'] = self.peering_subnet_mask
        if self.description is not None:
            result['Description'] = self.description
        if self.name is not None:
            result['Name'] = self.name
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.user_cidr is not None:
            result['UserCidr'] = self.user_cidr
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('PhysicalConnectionId') is not None:
            self.physical_connection_id = m.get('PhysicalConnectionId')
        if m.get('VbrOwnerId') is not None:
            self.vbr_owner_id = m.get('VbrOwnerId')
        if m.get('VlanId') is not None:
            self.vlan_id = m.get('VlanId')
        if m.get('CircuitCode') is not None:
            self.circuit_code = m.get('CircuitCode')
        if m.get('LocalGatewayIp') is not None:
            self.local_gateway_ip = m.get('LocalGatewayIp')
        if m.get('PeerGatewayIp') is not None:
            self.peer_gateway_ip = m.get('PeerGatewayIp')
        if m.get('PeeringSubnetMask') is not None:
            self.peering_subnet_mask = m.get('PeeringSubnetMask')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('UserCidr') is not None:
            self.user_cidr = m.get('UserCidr')
        return self


class CreateVirtualBorderRouterResponseBody(TeaModel):
    def __init__(
        self,
        vbr_id: str = None,
        request_id: str = None,
    ):
        self.vbr_id = vbr_id
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.vbr_id is not None:
            result['VbrId'] = self.vbr_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('VbrId') is not None:
            self.vbr_id = m.get('VbrId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateVirtualBorderRouterResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CreateVirtualBorderRouterResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateVirtualBorderRouterResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateVpcRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        region_id: str = None,
        cidr_block: str = None,
        vpc_name: str = None,
        description: str = None,
        client_token: str = None,
        owner_account: str = None,
        user_cidr: str = None,
    ):
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.region_id = region_id
        self.cidr_block = cidr_block
        self.vpc_name = vpc_name
        self.description = description
        self.client_token = client_token
        self.owner_account = owner_account
        self.user_cidr = user_cidr

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.cidr_block is not None:
            result['CidrBlock'] = self.cidr_block
        if self.vpc_name is not None:
            result['VpcName'] = self.vpc_name
        if self.description is not None:
            result['Description'] = self.description
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.user_cidr is not None:
            result['UserCidr'] = self.user_cidr
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('CidrBlock') is not None:
            self.cidr_block = m.get('CidrBlock')
        if m.get('VpcName') is not None:
            self.vpc_name = m.get('VpcName')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('UserCidr') is not None:
            self.user_cidr = m.get('UserCidr')
        return self


class CreateVpcResponseBody(TeaModel):
    def __init__(
        self,
        vpc_id: str = None,
        vrouter_id: str = None,
        request_id: str = None,
        route_table_id: str = None,
    ):
        self.vpc_id = vpc_id
        self.vrouter_id = vrouter_id
        self.request_id = request_id
        self.route_table_id = route_table_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.vpc_id is not None:
            result['VpcId'] = self.vpc_id
        if self.vrouter_id is not None:
            result['VRouterId'] = self.vrouter_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.route_table_id is not None:
            result['RouteTableId'] = self.route_table_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('VpcId') is not None:
            self.vpc_id = m.get('VpcId')
        if m.get('VRouterId') is not None:
            self.vrouter_id = m.get('VRouterId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('RouteTableId') is not None:
            self.route_table_id = m.get('RouteTableId')
        return self


class CreateVpcResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CreateVpcResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateVpcResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateVSwitchRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        zone_id: str = None,
        cidr_block: str = None,
        vpc_id: str = None,
        region_id: str = None,
        v_switch_name: str = None,
        description: str = None,
        client_token: str = None,
        owner_account: str = None,
    ):
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.zone_id = zone_id
        self.cidr_block = cidr_block
        self.vpc_id = vpc_id
        self.region_id = region_id
        self.v_switch_name = v_switch_name
        self.description = description
        self.client_token = client_token
        self.owner_account = owner_account

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.zone_id is not None:
            result['ZoneId'] = self.zone_id
        if self.cidr_block is not None:
            result['CidrBlock'] = self.cidr_block
        if self.vpc_id is not None:
            result['VpcId'] = self.vpc_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.v_switch_name is not None:
            result['VSwitchName'] = self.v_switch_name
        if self.description is not None:
            result['Description'] = self.description
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('ZoneId') is not None:
            self.zone_id = m.get('ZoneId')
        if m.get('CidrBlock') is not None:
            self.cidr_block = m.get('CidrBlock')
        if m.get('VpcId') is not None:
            self.vpc_id = m.get('VpcId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('VSwitchName') is not None:
            self.v_switch_name = m.get('VSwitchName')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        return self


class CreateVSwitchResponseBody(TeaModel):
    def __init__(
        self,
        v_switch_id: str = None,
        request_id: str = None,
    ):
        self.v_switch_id = v_switch_id
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.v_switch_id is not None:
            result['VSwitchId'] = self.v_switch_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('VSwitchId') is not None:
            self.v_switch_id = m.get('VSwitchId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateVSwitchResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CreateVSwitchResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateVSwitchResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeactivateRouterInterfaceRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        region_id: str = None,
        router_interface_id: str = None,
    ):
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.region_id = region_id
        self.router_interface_id = router_interface_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.router_interface_id is not None:
            result['RouterInterfaceId'] = self.router_interface_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('RouterInterfaceId') is not None:
            self.router_interface_id = m.get('RouterInterfaceId')
        return self


class DeactivateRouterInterfaceResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeactivateRouterInterfaceResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DeactivateRouterInterfaceResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeactivateRouterInterfaceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteActivationRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        owner_account: str = None,
        region_id: str = None,
        activation_id: str = None,
    ):
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.owner_account = owner_account
        self.region_id = region_id
        self.activation_id = activation_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.activation_id is not None:
            result['ActivationId'] = self.activation_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ActivationId') is not None:
            self.activation_id = m.get('ActivationId')
        return self


class DeleteActivationResponseBodyActivation(TeaModel):
    def __init__(
        self,
        creation_time: str = None,
        deregistered_count: int = None,
        instance_count: int = None,
        description: str = None,
        registered_count: int = None,
        instance_name: str = None,
        ip_address_range: str = None,
        time_to_live_in_hours: int = None,
        activation_id: str = None,
    ):
        self.creation_time = creation_time
        self.deregistered_count = deregistered_count
        self.instance_count = instance_count
        self.description = description
        self.registered_count = registered_count
        self.instance_name = instance_name
        self.ip_address_range = ip_address_range
        self.time_to_live_in_hours = time_to_live_in_hours
        self.activation_id = activation_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.creation_time is not None:
            result['CreationTime'] = self.creation_time
        if self.deregistered_count is not None:
            result['DeregisteredCount'] = self.deregistered_count
        if self.instance_count is not None:
            result['InstanceCount'] = self.instance_count
        if self.description is not None:
            result['Description'] = self.description
        if self.registered_count is not None:
            result['RegisteredCount'] = self.registered_count
        if self.instance_name is not None:
            result['InstanceName'] = self.instance_name
        if self.ip_address_range is not None:
            result['IpAddressRange'] = self.ip_address_range
        if self.time_to_live_in_hours is not None:
            result['TimeToLiveInHours'] = self.time_to_live_in_hours
        if self.activation_id is not None:
            result['ActivationId'] = self.activation_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CreationTime') is not None:
            self.creation_time = m.get('CreationTime')
        if m.get('DeregisteredCount') is not None:
            self.deregistered_count = m.get('DeregisteredCount')
        if m.get('InstanceCount') is not None:
            self.instance_count = m.get('InstanceCount')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('RegisteredCount') is not None:
            self.registered_count = m.get('RegisteredCount')
        if m.get('InstanceName') is not None:
            self.instance_name = m.get('InstanceName')
        if m.get('IpAddressRange') is not None:
            self.ip_address_range = m.get('IpAddressRange')
        if m.get('TimeToLiveInHours') is not None:
            self.time_to_live_in_hours = m.get('TimeToLiveInHours')
        if m.get('ActivationId') is not None:
            self.activation_id = m.get('ActivationId')
        return self


class DeleteActivationResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        activation: DeleteActivationResponseBodyActivation = None,
    ):
        self.request_id = request_id
        self.activation = activation

    def validate(self):
        if self.activation:
            self.activation.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.activation is not None:
            result['Activation'] = self.activation.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Activation') is not None:
            temp_model = DeleteActivationResponseBodyActivation()
            self.activation = temp_model.from_map(m['Activation'])
        return self


class DeleteActivationResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DeleteActivationResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteActivationResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteAutoProvisioningGroupRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        owner_account: str = None,
        region_id: str = None,
        auto_provisioning_group_id: str = None,
        terminate_instances: bool = None,
    ):
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.owner_account = owner_account
        self.region_id = region_id
        self.auto_provisioning_group_id = auto_provisioning_group_id
        self.terminate_instances = terminate_instances

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.auto_provisioning_group_id is not None:
            result['AutoProvisioningGroupId'] = self.auto_provisioning_group_id
        if self.terminate_instances is not None:
            result['TerminateInstances'] = self.terminate_instances
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('AutoProvisioningGroupId') is not None:
            self.auto_provisioning_group_id = m.get('AutoProvisioningGroupId')
        if m.get('TerminateInstances') is not None:
            self.terminate_instances = m.get('TerminateInstances')
        return self


class DeleteAutoProvisioningGroupResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteAutoProvisioningGroupResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DeleteAutoProvisioningGroupResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteAutoProvisioningGroupResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteAutoSnapshotPolicyRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        region_id: str = None,
        auto_snapshot_policy_id: str = None,
    ):
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.region_id = region_id
        self.auto_snapshot_policy_id = auto_snapshot_policy_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['regionId'] = self.region_id
        if self.auto_snapshot_policy_id is not None:
            result['autoSnapshotPolicyId'] = self.auto_snapshot_policy_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('regionId') is not None:
            self.region_id = m.get('regionId')
        if m.get('autoSnapshotPolicyId') is not None:
            self.auto_snapshot_policy_id = m.get('autoSnapshotPolicyId')
        return self


class DeleteAutoSnapshotPolicyResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteAutoSnapshotPolicyResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DeleteAutoSnapshotPolicyResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteAutoSnapshotPolicyResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteBandwidthPackageRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        owner_account: str = None,
        region_id: str = None,
        bandwidth_package_id: str = None,
    ):
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.owner_account = owner_account
        self.region_id = region_id
        self.bandwidth_package_id = bandwidth_package_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.bandwidth_package_id is not None:
            result['BandwidthPackageId'] = self.bandwidth_package_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('BandwidthPackageId') is not None:
            self.bandwidth_package_id = m.get('BandwidthPackageId')
        return self


class DeleteBandwidthPackageResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteBandwidthPackageResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DeleteBandwidthPackageResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteBandwidthPackageResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteCommandRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        owner_account: str = None,
        region_id: str = None,
        command_id: str = None,
    ):
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.owner_account = owner_account
        self.region_id = region_id
        self.command_id = command_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.command_id is not None:
            result['CommandId'] = self.command_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('CommandId') is not None:
            self.command_id = m.get('CommandId')
        return self


class DeleteCommandResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteCommandResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DeleteCommandResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteCommandResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteDedicatedHostClusterRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        owner_account: str = None,
        region_id: str = None,
        dedicated_host_cluster_id: str = None,
    ):
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.owner_account = owner_account
        self.region_id = region_id
        self.dedicated_host_cluster_id = dedicated_host_cluster_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.dedicated_host_cluster_id is not None:
            result['DedicatedHostClusterId'] = self.dedicated_host_cluster_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('DedicatedHostClusterId') is not None:
            self.dedicated_host_cluster_id = m.get('DedicatedHostClusterId')
        return self


class DeleteDedicatedHostClusterResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteDedicatedHostClusterResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DeleteDedicatedHostClusterResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteDedicatedHostClusterResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteDemandRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        owner_account: str = None,
        client_token: str = None,
        region_id: str = None,
        demand_id: str = None,
        reason: str = None,
    ):
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.owner_account = owner_account
        self.client_token = client_token
        self.region_id = region_id
        self.demand_id = demand_id
        self.reason = reason

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.demand_id is not None:
            result['DemandId'] = self.demand_id
        if self.reason is not None:
            result['Reason'] = self.reason
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('DemandId') is not None:
            self.demand_id = m.get('DemandId')
        if m.get('Reason') is not None:
            self.reason = m.get('Reason')
        return self


class DeleteDemandResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteDemandResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DeleteDemandResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteDemandResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteDeploymentSetRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        region_id: str = None,
        deployment_set_id: str = None,
        owner_account: str = None,
    ):
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.region_id = region_id
        self.deployment_set_id = deployment_set_id
        self.owner_account = owner_account

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.deployment_set_id is not None:
            result['DeploymentSetId'] = self.deployment_set_id
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('DeploymentSetId') is not None:
            self.deployment_set_id = m.get('DeploymentSetId')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        return self


class DeleteDeploymentSetResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteDeploymentSetResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DeleteDeploymentSetResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteDeploymentSetResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteDiskRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        disk_id: str = None,
        owner_account: str = None,
    ):
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.disk_id = disk_id
        self.owner_account = owner_account

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.disk_id is not None:
            result['DiskId'] = self.disk_id
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('DiskId') is not None:
            self.disk_id = m.get('DiskId')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        return self


class DeleteDiskResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteDiskResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DeleteDiskResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteDiskResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteDiskReplicaPairRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        owner_account: str = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        region_id: str = None,
        replica_pair_id: str = None,
    ):
        self.owner_id = owner_id
        self.owner_account = owner_account
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.region_id = region_id
        self.replica_pair_id = replica_pair_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.replica_pair_id is not None:
            result['ReplicaPairId'] = self.replica_pair_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ReplicaPairId') is not None:
            self.replica_pair_id = m.get('ReplicaPairId')
        return self


class DeleteDiskReplicaPairResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteDiskReplicaPairResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DeleteDiskReplicaPairResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteDiskReplicaPairResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteForwardEntryRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        owner_account: str = None,
        region_id: str = None,
        forward_table_id: str = None,
        forward_entry_id: str = None,
    ):
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.owner_account = owner_account
        self.region_id = region_id
        self.forward_table_id = forward_table_id
        self.forward_entry_id = forward_entry_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.forward_table_id is not None:
            result['ForwardTableId'] = self.forward_table_id
        if self.forward_entry_id is not None:
            result['ForwardEntryId'] = self.forward_entry_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ForwardTableId') is not None:
            self.forward_table_id = m.get('ForwardTableId')
        if m.get('ForwardEntryId') is not None:
            self.forward_entry_id = m.get('ForwardEntryId')
        return self


class DeleteForwardEntryResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteForwardEntryResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DeleteForwardEntryResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteForwardEntryResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteHaVipRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        owner_account: str = None,
        client_token: str = None,
        region_id: str = None,
        ha_vip_id: str = None,
    ):
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.owner_account = owner_account
        self.client_token = client_token
        self.region_id = region_id
        self.ha_vip_id = ha_vip_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.ha_vip_id is not None:
            result['HaVipId'] = self.ha_vip_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('HaVipId') is not None:
            self.ha_vip_id = m.get('HaVipId')
        return self


class DeleteHaVipResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteHaVipResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DeleteHaVipResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteHaVipResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteHpcClusterRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        region_id: str = None,
        client_token: str = None,
        owner_account: str = None,
        hpc_cluster_id: str = None,
    ):
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.region_id = region_id
        self.client_token = client_token
        self.owner_account = owner_account
        self.hpc_cluster_id = hpc_cluster_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.hpc_cluster_id is not None:
            result['HpcClusterId'] = self.hpc_cluster_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('HpcClusterId') is not None:
            self.hpc_cluster_id = m.get('HpcClusterId')
        return self


class DeleteHpcClusterResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteHpcClusterResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DeleteHpcClusterResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteHpcClusterResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteImageRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        region_id: str = None,
        image_id: str = None,
        force: bool = None,
        owner_account: str = None,
    ):
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.region_id = region_id
        self.image_id = image_id
        self.force = force
        self.owner_account = owner_account

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.image_id is not None:
            result['ImageId'] = self.image_id
        if self.force is not None:
            result['Force'] = self.force
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ImageId') is not None:
            self.image_id = m.get('ImageId')
        if m.get('Force') is not None:
            self.force = m.get('Force')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        return self


class DeleteImageResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteImageResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DeleteImageResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteImageResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteImageComponentRequestTemplateTag(TeaModel):
    def __init__(
        self,
        key: str = None,
        value: str = None,
    ):
        self.key = key
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class DeleteImageComponentRequest(TeaModel):
    def __init__(
        self,
        template_tag: List[DeleteImageComponentRequestTemplateTag] = None,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        owner_account: str = None,
        region_id: str = None,
        image_component_id: str = None,
    ):
        self.template_tag = template_tag
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.owner_account = owner_account
        self.region_id = region_id
        self.image_component_id = image_component_id

    def validate(self):
        if self.template_tag:
            for k in self.template_tag:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['TemplateTag'] = []
        if self.template_tag is not None:
            for k in self.template_tag:
                result['TemplateTag'].append(k.to_map() if k else None)
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.image_component_id is not None:
            result['ImageComponentId'] = self.image_component_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.template_tag = []
        if m.get('TemplateTag') is not None:
            for k in m.get('TemplateTag'):
                temp_model = DeleteImageComponentRequestTemplateTag()
                self.template_tag.append(temp_model.from_map(k))
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ImageComponentId') is not None:
            self.image_component_id = m.get('ImageComponentId')
        return self


class DeleteImageComponentResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteImageComponentResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DeleteImageComponentResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteImageComponentResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteImagePipelineRequestTemplateTag(TeaModel):
    def __init__(
        self,
        key: str = None,
        value: str = None,
    ):
        self.key = key
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class DeleteImagePipelineRequest(TeaModel):
    def __init__(
        self,
        template_tag: List[DeleteImagePipelineRequestTemplateTag] = None,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        owner_account: str = None,
        region_id: str = None,
        image_pipeline_id: str = None,
    ):
        self.template_tag = template_tag
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.owner_account = owner_account
        self.region_id = region_id
        self.image_pipeline_id = image_pipeline_id

    def validate(self):
        if self.template_tag:
            for k in self.template_tag:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['TemplateTag'] = []
        if self.template_tag is not None:
            for k in self.template_tag:
                result['TemplateTag'].append(k.to_map() if k else None)
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.image_pipeline_id is not None:
            result['ImagePipelineId'] = self.image_pipeline_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.template_tag = []
        if m.get('TemplateTag') is not None:
            for k in m.get('TemplateTag'):
                temp_model = DeleteImagePipelineRequestTemplateTag()
                self.template_tag.append(temp_model.from_map(k))
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ImagePipelineId') is not None:
            self.image_pipeline_id = m.get('ImagePipelineId')
        return self


class DeleteImagePipelineResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteImagePipelineResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DeleteImagePipelineResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteImagePipelineResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteInstanceRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        instance_id: str = None,
        owner_account: str = None,
        force: bool = None,
        terminate_subscription: bool = None,
    ):
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.instance_id = instance_id
        self.owner_account = owner_account
        self.force = force
        self.terminate_subscription = terminate_subscription

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.force is not None:
            result['Force'] = self.force
        if self.terminate_subscription is not None:
            result['TerminateSubscription'] = self.terminate_subscription
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('Force') is not None:
            self.force = m.get('Force')
        if m.get('TerminateSubscription') is not None:
            self.terminate_subscription = m.get('TerminateSubscription')
        return self


class DeleteInstanceResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteInstanceResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DeleteInstanceResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteInstanceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteInstancesRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        dry_run: bool = None,
        owner_account: str = None,
        force: bool = None,
        terminate_subscription: bool = None,
        client_token: str = None,
        region_id: str = None,
        instance_id: List[str] = None,
    ):
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.dry_run = dry_run
        self.owner_account = owner_account
        self.force = force
        self.terminate_subscription = terminate_subscription
        self.client_token = client_token
        self.region_id = region_id
        self.instance_id = instance_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.dry_run is not None:
            result['DryRun'] = self.dry_run
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.force is not None:
            result['Force'] = self.force
        if self.terminate_subscription is not None:
            result['TerminateSubscription'] = self.terminate_subscription
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('DryRun') is not None:
            self.dry_run = m.get('DryRun')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('Force') is not None:
            self.force = m.get('Force')
        if m.get('TerminateSubscription') is not None:
            self.terminate_subscription = m.get('TerminateSubscription')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class DeleteInstancesResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteInstancesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DeleteInstancesResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteInstancesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteKeyPairsRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        region_id: str = None,
        key_pair_names: str = None,
    ):
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.region_id = region_id
        self.key_pair_names = key_pair_names

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.key_pair_names is not None:
            result['KeyPairNames'] = self.key_pair_names
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('KeyPairNames') is not None:
            self.key_pair_names = m.get('KeyPairNames')
        return self


class DeleteKeyPairsResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteKeyPairsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DeleteKeyPairsResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteKeyPairsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteLaunchTemplateRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        owner_account: str = None,
        region_id: str = None,
        launch_template_id: str = None,
        launch_template_name: str = None,
    ):
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.owner_account = owner_account
        self.region_id = region_id
        self.launch_template_id = launch_template_id
        self.launch_template_name = launch_template_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.launch_template_id is not None:
            result['LaunchTemplateId'] = self.launch_template_id
        if self.launch_template_name is not None:
            result['LaunchTemplateName'] = self.launch_template_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('LaunchTemplateId') is not None:
            self.launch_template_id = m.get('LaunchTemplateId')
        if m.get('LaunchTemplateName') is not None:
            self.launch_template_name = m.get('LaunchTemplateName')
        return self


class DeleteLaunchTemplateResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteLaunchTemplateResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DeleteLaunchTemplateResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteLaunchTemplateResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteLaunchTemplateVersionRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        owner_account: str = None,
        region_id: str = None,
        delete_version: List[int] = None,
        launch_template_id: str = None,
        launch_template_name: str = None,
    ):
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.owner_account = owner_account
        self.region_id = region_id
        self.delete_version = delete_version
        self.launch_template_id = launch_template_id
        self.launch_template_name = launch_template_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.delete_version is not None:
            result['DeleteVersion'] = self.delete_version
        if self.launch_template_id is not None:
            result['LaunchTemplateId'] = self.launch_template_id
        if self.launch_template_name is not None:
            result['LaunchTemplateName'] = self.launch_template_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('DeleteVersion') is not None:
            self.delete_version = m.get('DeleteVersion')
        if m.get('LaunchTemplateId') is not None:
            self.launch_template_id = m.get('LaunchTemplateId')
        if m.get('LaunchTemplateName') is not None:
            self.launch_template_name = m.get('LaunchTemplateName')
        return self


class DeleteLaunchTemplateVersionResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteLaunchTemplateVersionResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DeleteLaunchTemplateVersionResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteLaunchTemplateVersionResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteNatGatewayRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        owner_account: str = None,
        region_id: str = None,
        nat_gateway_id: str = None,
    ):
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.owner_account = owner_account
        self.region_id = region_id
        self.nat_gateway_id = nat_gateway_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.nat_gateway_id is not None:
            result['NatGatewayId'] = self.nat_gateway_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('NatGatewayId') is not None:
            self.nat_gateway_id = m.get('NatGatewayId')
        return self


class DeleteNatGatewayResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteNatGatewayResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DeleteNatGatewayResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteNatGatewayResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteNetworkInterfaceRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        owner_account: str = None,
        region_id: str = None,
        network_interface_id: str = None,
    ):
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.owner_account = owner_account
        self.region_id = region_id
        self.network_interface_id = network_interface_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.network_interface_id is not None:
            result['NetworkInterfaceId'] = self.network_interface_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('NetworkInterfaceId') is not None:
            self.network_interface_id = m.get('NetworkInterfaceId')
        return self


class DeleteNetworkInterfaceResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteNetworkInterfaceResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DeleteNetworkInterfaceResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteNetworkInterfaceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteNetworkInterfacePermissionRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        owner_account: str = None,
        region_id: str = None,
        network_interface_permission_id: str = None,
        force: bool = None,
    ):
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.owner_account = owner_account
        self.region_id = region_id
        self.network_interface_permission_id = network_interface_permission_id
        self.force = force

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.network_interface_permission_id is not None:
            result['NetworkInterfacePermissionId'] = self.network_interface_permission_id
        if self.force is not None:
            result['Force'] = self.force
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('NetworkInterfacePermissionId') is not None:
            self.network_interface_permission_id = m.get('NetworkInterfacePermissionId')
        if m.get('Force') is not None:
            self.force = m.get('Force')
        return self


class DeleteNetworkInterfacePermissionResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteNetworkInterfacePermissionResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DeleteNetworkInterfacePermissionResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteNetworkInterfacePermissionResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeletePhysicalConnectionRequest(TeaModel):
    def __init__(
        self,
        region_id: str = None,
        physical_connection_id: str = None,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        client_token: str = None,
        owner_account: str = None,
    ):
        self.region_id = region_id
        self.physical_connection_id = physical_connection_id
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.client_token = client_token
        self.owner_account = owner_account

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.physical_connection_id is not None:
            result['PhysicalConnectionId'] = self.physical_connection_id
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('PhysicalConnectionId') is not None:
            self.physical_connection_id = m.get('PhysicalConnectionId')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        return self


class DeletePhysicalConnectionResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeletePhysicalConnectionResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DeletePhysicalConnectionResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeletePhysicalConnectionResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeletePrefixListRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        owner_account: str = None,
        region_id: str = None,
        prefix_list_id: str = None,
    ):
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.owner_account = owner_account
        self.region_id = region_id
        self.prefix_list_id = prefix_list_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.prefix_list_id is not None:
            result['PrefixListId'] = self.prefix_list_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('PrefixListId') is not None:
            self.prefix_list_id = m.get('PrefixListId')
        return self


class DeletePrefixListResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeletePrefixListResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DeletePrefixListResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeletePrefixListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteReplicaPairRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        owner_account: str = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        region_id: str = None,
        replica_pair_id: str = None,
    ):
        self.owner_id = owner_id
        self.owner_account = owner_account
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.region_id = region_id
        self.replica_pair_id = replica_pair_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.replica_pair_id is not None:
            result['ReplicaPairId'] = self.replica_pair_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ReplicaPairId') is not None:
            self.replica_pair_id = m.get('ReplicaPairId')
        return self


class DeleteReplicaPairResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteReplicaPairResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DeleteReplicaPairResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteReplicaPairResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteRouteEntryRequestNextHopList(TeaModel):
    def __init__(
        self,
        next_hop_id: str = None,
        next_hop_type: str = None,
    ):
        self.next_hop_id = next_hop_id
        self.next_hop_type = next_hop_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.next_hop_id is not None:
            result['NextHopId'] = self.next_hop_id
        if self.next_hop_type is not None:
            result['NextHopType'] = self.next_hop_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('NextHopId') is not None:
            self.next_hop_id = m.get('NextHopId')
        if m.get('NextHopType') is not None:
            self.next_hop_type = m.get('NextHopType')
        return self


class DeleteRouteEntryRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        region_id: str = None,
        route_table_id: str = None,
        destination_cidr_block: str = None,
        next_hop_id: str = None,
        owner_account: str = None,
        next_hop_list: List[DeleteRouteEntryRequestNextHopList] = None,
    ):
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.region_id = region_id
        self.route_table_id = route_table_id
        self.destination_cidr_block = destination_cidr_block
        self.next_hop_id = next_hop_id
        self.owner_account = owner_account
        self.next_hop_list = next_hop_list

    def validate(self):
        if self.next_hop_list:
            for k in self.next_hop_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.route_table_id is not None:
            result['RouteTableId'] = self.route_table_id
        if self.destination_cidr_block is not None:
            result['DestinationCidrBlock'] = self.destination_cidr_block
        if self.next_hop_id is not None:
            result['NextHopId'] = self.next_hop_id
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        result['NextHopList'] = []
        if self.next_hop_list is not None:
            for k in self.next_hop_list:
                result['NextHopList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('RouteTableId') is not None:
            self.route_table_id = m.get('RouteTableId')
        if m.get('DestinationCidrBlock') is not None:
            self.destination_cidr_block = m.get('DestinationCidrBlock')
        if m.get('NextHopId') is not None:
            self.next_hop_id = m.get('NextHopId')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        self.next_hop_list = []
        if m.get('NextHopList') is not None:
            for k in m.get('NextHopList'):
                temp_model = DeleteRouteEntryRequestNextHopList()
                self.next_hop_list.append(temp_model.from_map(k))
        return self


class DeleteRouteEntryResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteRouteEntryResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DeleteRouteEntryResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteRouteEntryResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteRouterInterfaceRequest(TeaModel):
    def __init__(
        self,
        region_id: str = None,
        router_interface_id: str = None,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        client_token: str = None,
        owner_account: str = None,
        user_cidr: str = None,
    ):
        self.region_id = region_id
        self.router_interface_id = router_interface_id
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.client_token = client_token
        self.owner_account = owner_account
        self.user_cidr = user_cidr

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.router_interface_id is not None:
            result['RouterInterfaceId'] = self.router_interface_id
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.user_cidr is not None:
            result['UserCidr'] = self.user_cidr
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('RouterInterfaceId') is not None:
            self.router_interface_id = m.get('RouterInterfaceId')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('UserCidr') is not None:
            self.user_cidr = m.get('UserCidr')
        return self


class DeleteRouterInterfaceResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteRouterInterfaceResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DeleteRouterInterfaceResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteRouterInterfaceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteSecurityGroupRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        region_id: str = None,
        security_group_id: str = None,
        owner_account: str = None,
    ):
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.region_id = region_id
        self.security_group_id = security_group_id
        self.owner_account = owner_account

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.security_group_id is not None:
            result['SecurityGroupId'] = self.security_group_id
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('SecurityGroupId') is not None:
            self.security_group_id = m.get('SecurityGroupId')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        return self


class DeleteSecurityGroupResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteSecurityGroupResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DeleteSecurityGroupResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteSecurityGroupResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteSnapshotRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        snapshot_id: str = None,
        force: bool = None,
        owner_account: str = None,
    ):
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.snapshot_id = snapshot_id
        self.force = force
        self.owner_account = owner_account

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.snapshot_id is not None:
            result['SnapshotId'] = self.snapshot_id
        if self.force is not None:
            result['Force'] = self.force
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('SnapshotId') is not None:
            self.snapshot_id = m.get('SnapshotId')
        if m.get('Force') is not None:
            self.force = m.get('Force')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        return self


class DeleteSnapshotResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteSnapshotResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DeleteSnapshotResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteSnapshotResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteSnapshotGroupRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        owner_account: str = None,
        region_id: str = None,
        snapshot_group_id: str = None,
    ):
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.owner_account = owner_account
        self.region_id = region_id
        self.snapshot_group_id = snapshot_group_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.snapshot_group_id is not None:
            result['SnapshotGroupId'] = self.snapshot_group_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('SnapshotGroupId') is not None:
            self.snapshot_group_id = m.get('SnapshotGroupId')
        return self


class DeleteSnapshotGroupResponseBodyOperationProgressSetOperationProgressRelatedItemSetRelatedItem(TeaModel):
    def __init__(
        self,
        name: str = None,
        value: str = None,
    ):
        self.name = name
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['Name'] = self.name
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class DeleteSnapshotGroupResponseBodyOperationProgressSetOperationProgressRelatedItemSet(TeaModel):
    def __init__(
        self,
        related_item: List[DeleteSnapshotGroupResponseBodyOperationProgressSetOperationProgressRelatedItemSetRelatedItem] = None,
    ):
        self.related_item = related_item

    def validate(self):
        if self.related_item:
            for k in self.related_item:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['RelatedItem'] = []
        if self.related_item is not None:
            for k in self.related_item:
                result['RelatedItem'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.related_item = []
        if m.get('RelatedItem') is not None:
            for k in m.get('RelatedItem'):
                temp_model = DeleteSnapshotGroupResponseBodyOperationProgressSetOperationProgressRelatedItemSetRelatedItem()
                self.related_item.append(temp_model.from_map(k))
        return self


class DeleteSnapshotGroupResponseBodyOperationProgressSetOperationProgress(TeaModel):
    def __init__(
        self,
        error_msg: str = None,
        error_code: str = None,
        operation_status: str = None,
        related_item_set: DeleteSnapshotGroupResponseBodyOperationProgressSetOperationProgressRelatedItemSet = None,
    ):
        self.error_msg = error_msg
        self.error_code = error_code
        self.operation_status = operation_status
        self.related_item_set = related_item_set

    def validate(self):
        if self.related_item_set:
            self.related_item_set.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.error_msg is not None:
            result['ErrorMsg'] = self.error_msg
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.operation_status is not None:
            result['OperationStatus'] = self.operation_status
        if self.related_item_set is not None:
            result['RelatedItemSet'] = self.related_item_set.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ErrorMsg') is not None:
            self.error_msg = m.get('ErrorMsg')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('OperationStatus') is not None:
            self.operation_status = m.get('OperationStatus')
        if m.get('RelatedItemSet') is not None:
            temp_model = DeleteSnapshotGroupResponseBodyOperationProgressSetOperationProgressRelatedItemSet()
            self.related_item_set = temp_model.from_map(m['RelatedItemSet'])
        return self


class DeleteSnapshotGroupResponseBodyOperationProgressSet(TeaModel):
    def __init__(
        self,
        operation_progress: List[DeleteSnapshotGroupResponseBodyOperationProgressSetOperationProgress] = None,
    ):
        self.operation_progress = operation_progress

    def validate(self):
        if self.operation_progress:
            for k in self.operation_progress:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['OperationProgress'] = []
        if self.operation_progress is not None:
            for k in self.operation_progress:
                result['OperationProgress'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.operation_progress = []
        if m.get('OperationProgress') is not None:
            for k in m.get('OperationProgress'):
                temp_model = DeleteSnapshotGroupResponseBodyOperationProgressSetOperationProgress()
                self.operation_progress.append(temp_model.from_map(k))
        return self


class DeleteSnapshotGroupResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        operation_progress_set: DeleteSnapshotGroupResponseBodyOperationProgressSet = None,
    ):
        self.request_id = request_id
        self.operation_progress_set = operation_progress_set

    def validate(self):
        if self.operation_progress_set:
            self.operation_progress_set.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.operation_progress_set is not None:
            result['OperationProgressSet'] = self.operation_progress_set.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('OperationProgressSet') is not None:
            temp_model = DeleteSnapshotGroupResponseBodyOperationProgressSet()
            self.operation_progress_set = temp_model.from_map(m['OperationProgressSet'])
        return self


class DeleteSnapshotGroupResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DeleteSnapshotGroupResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteSnapshotGroupResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteStorageSetRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        owner_account: str = None,
        client_token: str = None,
        region_id: str = None,
        storage_set_id: str = None,
    ):
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.owner_account = owner_account
        self.client_token = client_token
        self.region_id = region_id
        self.storage_set_id = storage_set_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.storage_set_id is not None:
            result['StorageSetId'] = self.storage_set_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('StorageSetId') is not None:
            self.storage_set_id = m.get('StorageSetId')
        return self


class DeleteStorageSetResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteStorageSetResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DeleteStorageSetResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteStorageSetResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteVirtualBorderRouterRequest(TeaModel):
    def __init__(
        self,
        region_id: str = None,
        vbr_id: str = None,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        client_token: str = None,
        owner_account: str = None,
        user_cidr: str = None,
    ):
        self.region_id = region_id
        self.vbr_id = vbr_id
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.client_token = client_token
        self.owner_account = owner_account
        self.user_cidr = user_cidr

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.vbr_id is not None:
            result['VbrId'] = self.vbr_id
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.user_cidr is not None:
            result['UserCidr'] = self.user_cidr
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('VbrId') is not None:
            self.vbr_id = m.get('VbrId')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('UserCidr') is not None:
            self.user_cidr = m.get('UserCidr')
        return self


class DeleteVirtualBorderRouterResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteVirtualBorderRouterResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DeleteVirtualBorderRouterResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteVirtualBorderRouterResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteVpcRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        vpc_id: str = None,
        region_id: str = None,
        owner_account: str = None,
    ):
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.vpc_id = vpc_id
        self.region_id = region_id
        self.owner_account = owner_account

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.vpc_id is not None:
            result['VpcId'] = self.vpc_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('VpcId') is not None:
            self.vpc_id = m.get('VpcId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        return self


class DeleteVpcResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteVpcResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DeleteVpcResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteVpcResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteVSwitchRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        v_switch_id: str = None,
        region_id: str = None,
        owner_account: str = None,
    ):
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.v_switch_id = v_switch_id
        self.region_id = region_id
        self.owner_account = owner_account

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.v_switch_id is not None:
            result['VSwitchId'] = self.v_switch_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('VSwitchId') is not None:
            self.v_switch_id = m.get('VSwitchId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        return self


class DeleteVSwitchResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteVSwitchResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DeleteVSwitchResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteVSwitchResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeregisterManagedInstanceRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        owner_account: str = None,
        region_id: str = None,
        instance_id: str = None,
    ):
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.owner_account = owner_account
        self.region_id = region_id
        self.instance_id = instance_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class DeregisterManagedInstanceResponseBodyInstance(TeaModel):
    def __init__(
        self,
        last_invoked_time: str = None,
        internet_ip: str = None,
        hostname: str = None,
        instance_id: str = None,
        activation_id: str = None,
        intranet_ip: str = None,
        agent_version: str = None,
        registration_time: str = None,
        instance_name: str = None,
        os_type: str = None,
        os_version: str = None,
        invocation_count: int = None,
        machine_id: str = None,
    ):
        self.last_invoked_time = last_invoked_time
        self.internet_ip = internet_ip
        self.hostname = hostname
        self.instance_id = instance_id
        self.activation_id = activation_id
        self.intranet_ip = intranet_ip
        self.agent_version = agent_version
        self.registration_time = registration_time
        self.instance_name = instance_name
        self.os_type = os_type
        self.os_version = os_version
        self.invocation_count = invocation_count
        self.machine_id = machine_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.last_invoked_time is not None:
            result['LastInvokedTime'] = self.last_invoked_time
        if self.internet_ip is not None:
            result['InternetIp'] = self.internet_ip
        if self.hostname is not None:
            result['Hostname'] = self.hostname
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.activation_id is not None:
            result['ActivationId'] = self.activation_id
        if self.intranet_ip is not None:
            result['IntranetIp'] = self.intranet_ip
        if self.agent_version is not None:
            result['AgentVersion'] = self.agent_version
        if self.registration_time is not None:
            result['RegistrationTime'] = self.registration_time
        if self.instance_name is not None:
            result['InstanceName'] = self.instance_name
        if self.os_type is not None:
            result['OsType'] = self.os_type
        if self.os_version is not None:
            result['OsVersion'] = self.os_version
        if self.invocation_count is not None:
            result['InvocationCount'] = self.invocation_count
        if self.machine_id is not None:
            result['MachineId'] = self.machine_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('LastInvokedTime') is not None:
            self.last_invoked_time = m.get('LastInvokedTime')
        if m.get('InternetIp') is not None:
            self.internet_ip = m.get('InternetIp')
        if m.get('Hostname') is not None:
            self.hostname = m.get('Hostname')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('ActivationId') is not None:
            self.activation_id = m.get('ActivationId')
        if m.get('IntranetIp') is not None:
            self.intranet_ip = m.get('IntranetIp')
        if m.get('AgentVersion') is not None:
            self.agent_version = m.get('AgentVersion')
        if m.get('RegistrationTime') is not None:
            self.registration_time = m.get('RegistrationTime')
        if m.get('InstanceName') is not None:
            self.instance_name = m.get('InstanceName')
        if m.get('OsType') is not None:
            self.os_type = m.get('OsType')
        if m.get('OsVersion') is not None:
            self.os_version = m.get('OsVersion')
        if m.get('InvocationCount') is not None:
            self.invocation_count = m.get('InvocationCount')
        if m.get('MachineId') is not None:
            self.machine_id = m.get('MachineId')
        return self


class DeregisterManagedInstanceResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        instance: DeregisterManagedInstanceResponseBodyInstance = None,
    ):
        self.request_id = request_id
        self.instance = instance

    def validate(self):
        if self.instance:
            self.instance.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.instance is not None:
            result['Instance'] = self.instance.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Instance') is not None:
            temp_model = DeregisterManagedInstanceResponseBodyInstance()
            self.instance = temp_model.from_map(m['Instance'])
        return self


class DeregisterManagedInstanceResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DeregisterManagedInstanceResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeregisterManagedInstanceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeAccessPointsRequestFilter(TeaModel):
    def __init__(
        self,
        key: str = None,
        value: List[str] = None,
    ):
        self.key = key
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class DescribeAccessPointsRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        region_id: str = None,
        type: str = None,
        page_number: int = None,
        page_size: int = None,
        filter: List[DescribeAccessPointsRequestFilter] = None,
    ):
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.region_id = region_id
        self.type = type
        self.page_number = page_number
        self.page_size = page_size
        self.filter = filter

    def validate(self):
        if self.filter:
            for k in self.filter:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.type is not None:
            result['Type'] = self.type
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        result['Filter'] = []
        if self.filter is not None:
            for k in self.filter:
                result['Filter'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        self.filter = []
        if m.get('Filter') is not None:
            for k in m.get('Filter'):
                temp_model = DescribeAccessPointsRequestFilter()
                self.filter.append(temp_model.from_map(k))
        return self


class DescribeAccessPointsResponseBodyAccessPointSetAccessPointType(TeaModel):
    def __init__(
        self,
        status: str = None,
        type: str = None,
        host_operator: str = None,
        description: str = None,
        attached_region_no: str = None,
        name: str = None,
        access_point_id: str = None,
        location: str = None,
    ):
        self.status = status
        self.type = type
        self.host_operator = host_operator
        self.description = description
        self.attached_region_no = attached_region_no
        self.name = name
        self.access_point_id = access_point_id
        self.location = location

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.status is not None:
            result['Status'] = self.status
        if self.type is not None:
            result['Type'] = self.type
        if self.host_operator is not None:
            result['HostOperator'] = self.host_operator
        if self.description is not None:
            result['Description'] = self.description
        if self.attached_region_no is not None:
            result['AttachedRegionNo'] = self.attached_region_no
        if self.name is not None:
            result['Name'] = self.name
        if self.access_point_id is not None:
            result['AccessPointId'] = self.access_point_id
        if self.location is not None:
            result['Location'] = self.location
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('HostOperator') is not None:
            self.host_operator = m.get('HostOperator')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('AttachedRegionNo') is not None:
            self.attached_region_no = m.get('AttachedRegionNo')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('AccessPointId') is not None:
            self.access_point_id = m.get('AccessPointId')
        if m.get('Location') is not None:
            self.location = m.get('Location')
        return self


class DescribeAccessPointsResponseBodyAccessPointSet(TeaModel):
    def __init__(
        self,
        access_point_type: List[DescribeAccessPointsResponseBodyAccessPointSetAccessPointType] = None,
    ):
        self.access_point_type = access_point_type

    def validate(self):
        if self.access_point_type:
            for k in self.access_point_type:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['AccessPointType'] = []
        if self.access_point_type is not None:
            for k in self.access_point_type:
                result['AccessPointType'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.access_point_type = []
        if m.get('AccessPointType') is not None:
            for k in m.get('AccessPointType'):
                temp_model = DescribeAccessPointsResponseBodyAccessPointSetAccessPointType()
                self.access_point_type.append(temp_model.from_map(k))
        return self


class DescribeAccessPointsResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        page_number: int = None,
        page_size: int = None,
        total_count: int = None,
        access_point_set: DescribeAccessPointsResponseBodyAccessPointSet = None,
    ):
        self.request_id = request_id
        self.page_number = page_number
        self.page_size = page_size
        self.total_count = total_count
        self.access_point_set = access_point_set

    def validate(self):
        if self.access_point_set:
            self.access_point_set.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        if self.access_point_set is not None:
            result['AccessPointSet'] = self.access_point_set.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        if m.get('AccessPointSet') is not None:
            temp_model = DescribeAccessPointsResponseBodyAccessPointSet()
            self.access_point_set = temp_model.from_map(m['AccessPointSet'])
        return self


class DescribeAccessPointsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeAccessPointsResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeAccessPointsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeAccountAttributesRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        attribute_name: List[str] = None,
        region_id: str = None,
        zone_id: str = None,
    ):
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.attribute_name = attribute_name
        self.region_id = region_id
        self.zone_id = zone_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.attribute_name is not None:
            result['AttributeName'] = self.attribute_name
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.zone_id is not None:
            result['ZoneId'] = self.zone_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('AttributeName') is not None:
            self.attribute_name = m.get('AttributeName')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ZoneId') is not None:
            self.zone_id = m.get('ZoneId')
        return self


class DescribeAccountAttributesResponseBodyAccountAttributeItemsAccountAttributeItemAttributeValuesValueItem(TeaModel):
    def __init__(
        self,
        disk_category: str = None,
        value: str = None,
        expired_time: str = None,
        zone_id: str = None,
        instance_type: str = None,
        count: int = None,
        instance_charge_type: str = None,
    ):
        self.disk_category = disk_category
        self.value = value
        self.expired_time = expired_time
        self.zone_id = zone_id
        self.instance_type = instance_type
        self.count = count
        self.instance_charge_type = instance_charge_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.disk_category is not None:
            result['DiskCategory'] = self.disk_category
        if self.value is not None:
            result['Value'] = self.value
        if self.expired_time is not None:
            result['ExpiredTime'] = self.expired_time
        if self.zone_id is not None:
            result['ZoneId'] = self.zone_id
        if self.instance_type is not None:
            result['InstanceType'] = self.instance_type
        if self.count is not None:
            result['Count'] = self.count
        if self.instance_charge_type is not None:
            result['InstanceChargeType'] = self.instance_charge_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DiskCategory') is not None:
            self.disk_category = m.get('DiskCategory')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        if m.get('ExpiredTime') is not None:
            self.expired_time = m.get('ExpiredTime')
        if m.get('ZoneId') is not None:
            self.zone_id = m.get('ZoneId')
        if m.get('InstanceType') is not None:
            self.instance_type = m.get('InstanceType')
        if m.get('Count') is not None:
            self.count = m.get('Count')
        if m.get('InstanceChargeType') is not None:
            self.instance_charge_type = m.get('InstanceChargeType')
        return self


class DescribeAccountAttributesResponseBodyAccountAttributeItemsAccountAttributeItemAttributeValues(TeaModel):
    def __init__(
        self,
        value_item: List[DescribeAccountAttributesResponseBodyAccountAttributeItemsAccountAttributeItemAttributeValuesValueItem] = None,
    ):
        self.value_item = value_item

    def validate(self):
        if self.value_item:
            for k in self.value_item:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['ValueItem'] = []
        if self.value_item is not None:
            for k in self.value_item:
                result['ValueItem'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.value_item = []
        if m.get('ValueItem') is not None:
            for k in m.get('ValueItem'):
                temp_model = DescribeAccountAttributesResponseBodyAccountAttributeItemsAccountAttributeItemAttributeValuesValueItem()
                self.value_item.append(temp_model.from_map(k))
        return self


class DescribeAccountAttributesResponseBodyAccountAttributeItemsAccountAttributeItem(TeaModel):
    def __init__(
        self,
        attribute_name: str = None,
        attribute_values: DescribeAccountAttributesResponseBodyAccountAttributeItemsAccountAttributeItemAttributeValues = None,
    ):
        self.attribute_name = attribute_name
        self.attribute_values = attribute_values

    def validate(self):
        if self.attribute_values:
            self.attribute_values.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.attribute_name is not None:
            result['AttributeName'] = self.attribute_name
        if self.attribute_values is not None:
            result['AttributeValues'] = self.attribute_values.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AttributeName') is not None:
            self.attribute_name = m.get('AttributeName')
        if m.get('AttributeValues') is not None:
            temp_model = DescribeAccountAttributesResponseBodyAccountAttributeItemsAccountAttributeItemAttributeValues()
            self.attribute_values = temp_model.from_map(m['AttributeValues'])
        return self


class DescribeAccountAttributesResponseBodyAccountAttributeItems(TeaModel):
    def __init__(
        self,
        account_attribute_item: List[DescribeAccountAttributesResponseBodyAccountAttributeItemsAccountAttributeItem] = None,
    ):
        self.account_attribute_item = account_attribute_item

    def validate(self):
        if self.account_attribute_item:
            for k in self.account_attribute_item:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['AccountAttributeItem'] = []
        if self.account_attribute_item is not None:
            for k in self.account_attribute_item:
                result['AccountAttributeItem'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.account_attribute_item = []
        if m.get('AccountAttributeItem') is not None:
            for k in m.get('AccountAttributeItem'):
                temp_model = DescribeAccountAttributesResponseBodyAccountAttributeItemsAccountAttributeItem()
                self.account_attribute_item.append(temp_model.from_map(k))
        return self


class DescribeAccountAttributesResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        account_attribute_items: DescribeAccountAttributesResponseBodyAccountAttributeItems = None,
    ):
        self.request_id = request_id
        self.account_attribute_items = account_attribute_items

    def validate(self):
        if self.account_attribute_items:
            self.account_attribute_items.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.account_attribute_items is not None:
            result['AccountAttributeItems'] = self.account_attribute_items.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('AccountAttributeItems') is not None:
            temp_model = DescribeAccountAttributesResponseBodyAccountAttributeItems()
            self.account_attribute_items = temp_model.from_map(m['AccountAttributeItems'])
        return self


class DescribeAccountAttributesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeAccountAttributesResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeAccountAttributesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeActivationsRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        owner_account: str = None,
        region_id: str = None,
        activation_id: str = None,
        instance_name: str = None,
        page_number: int = None,
        page_size: int = None,
    ):
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.owner_account = owner_account
        self.region_id = region_id
        self.activation_id = activation_id
        self.instance_name = instance_name
        self.page_number = page_number
        self.page_size = page_size

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.activation_id is not None:
            result['ActivationId'] = self.activation_id
        if self.instance_name is not None:
            result['InstanceName'] = self.instance_name
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ActivationId') is not None:
            self.activation_id = m.get('ActivationId')
        if m.get('InstanceName') is not None:
            self.instance_name = m.get('InstanceName')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        return self


class DescribeActivationsResponseBodyActivationList(TeaModel):
    def __init__(
        self,
        creation_time: str = None,
        deregistered_count: int = None,
        instance_count: int = None,
        description: str = None,
        registered_count: int = None,
        instance_name: str = None,
        disabled: bool = None,
        ip_address_range: str = None,
        time_to_live_in_hours: int = None,
        activation_id: str = None,
    ):
        self.creation_time = creation_time
        self.deregistered_count = deregistered_count
        self.instance_count = instance_count
        self.description = description
        self.registered_count = registered_count
        self.instance_name = instance_name
        self.disabled = disabled
        self.ip_address_range = ip_address_range
        self.time_to_live_in_hours = time_to_live_in_hours
        self.activation_id = activation_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.creation_time is not None:
            result['CreationTime'] = self.creation_time
        if self.deregistered_count is not None:
            result['DeregisteredCount'] = self.deregistered_count
        if self.instance_count is not None:
            result['InstanceCount'] = self.instance_count
        if self.description is not None:
            result['Description'] = self.description
        if self.registered_count is not None:
            result['RegisteredCount'] = self.registered_count
        if self.instance_name is not None:
            result['InstanceName'] = self.instance_name
        if self.disabled is not None:
            result['Disabled'] = self.disabled
        if self.ip_address_range is not None:
            result['IpAddressRange'] = self.ip_address_range
        if self.time_to_live_in_hours is not None:
            result['TimeToLiveInHours'] = self.time_to_live_in_hours
        if self.activation_id is not None:
            result['ActivationId'] = self.activation_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CreationTime') is not None:
            self.creation_time = m.get('CreationTime')
        if m.get('DeregisteredCount') is not None:
            self.deregistered_count = m.get('DeregisteredCount')
        if m.get('InstanceCount') is not None:
            self.instance_count = m.get('InstanceCount')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('RegisteredCount') is not None:
            self.registered_count = m.get('RegisteredCount')
        if m.get('InstanceName') is not None:
            self.instance_name = m.get('InstanceName')
        if m.get('Disabled') is not None:
            self.disabled = m.get('Disabled')
        if m.get('IpAddressRange') is not None:
            self.ip_address_range = m.get('IpAddressRange')
        if m.get('TimeToLiveInHours') is not None:
            self.time_to_live_in_hours = m.get('TimeToLiveInHours')
        if m.get('ActivationId') is not None:
            self.activation_id = m.get('ActivationId')
        return self


class DescribeActivationsResponseBody(TeaModel):
    def __init__(
        self,
        page_size: int = None,
        request_id: str = None,
        page_number: int = None,
        total_count: int = None,
        activation_list: List[DescribeActivationsResponseBodyActivationList] = None,
    ):
        self.page_size = page_size
        self.request_id = request_id
        self.page_number = page_number
        self.total_count = total_count
        self.activation_list = activation_list

    def validate(self):
        if self.activation_list:
            for k in self.activation_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        result['ActivationList'] = []
        if self.activation_list is not None:
            for k in self.activation_list:
                result['ActivationList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        self.activation_list = []
        if m.get('ActivationList') is not None:
            for k in m.get('ActivationList'):
                temp_model = DescribeActivationsResponseBodyActivationList()
                self.activation_list.append(temp_model.from_map(k))
        return self


class DescribeActivationsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeActivationsResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeActivationsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeAutoProvisioningGroupHistoryRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        owner_account: str = None,
        region_id: str = None,
        page_number: int = None,
        page_size: int = None,
        auto_provisioning_group_id: str = None,
        start_time: str = None,
        end_time: str = None,
    ):
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.owner_account = owner_account
        self.region_id = region_id
        self.page_number = page_number
        self.page_size = page_size
        self.auto_provisioning_group_id = auto_provisioning_group_id
        self.start_time = start_time
        self.end_time = end_time

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.auto_provisioning_group_id is not None:
            result['AutoProvisioningGroupId'] = self.auto_provisioning_group_id
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('AutoProvisioningGroupId') is not None:
            self.auto_provisioning_group_id = m.get('AutoProvisioningGroupId')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        return self


class DescribeAutoProvisioningGroupHistoryResponseBodyAutoProvisioningGroupHistoriesAutoProvisioningGroupHistoryActivityDetailsActivityDetail(TeaModel):
    def __init__(
        self,
        status: str = None,
        detail: str = None,
    ):
        self.status = status
        self.detail = detail

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.status is not None:
            result['Status'] = self.status
        if self.detail is not None:
            result['Detail'] = self.detail
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Detail') is not None:
            self.detail = m.get('Detail')
        return self


class DescribeAutoProvisioningGroupHistoryResponseBodyAutoProvisioningGroupHistoriesAutoProvisioningGroupHistoryActivityDetails(TeaModel):
    def __init__(
        self,
        activity_detail: List[DescribeAutoProvisioningGroupHistoryResponseBodyAutoProvisioningGroupHistoriesAutoProvisioningGroupHistoryActivityDetailsActivityDetail] = None,
    ):
        self.activity_detail = activity_detail

    def validate(self):
        if self.activity_detail:
            for k in self.activity_detail:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['ActivityDetail'] = []
        if self.activity_detail is not None:
            for k in self.activity_detail:
                result['ActivityDetail'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.activity_detail = []
        if m.get('ActivityDetail') is not None:
            for k in m.get('ActivityDetail'):
                temp_model = DescribeAutoProvisioningGroupHistoryResponseBodyAutoProvisioningGroupHistoriesAutoProvisioningGroupHistoryActivityDetailsActivityDetail()
                self.activity_detail.append(temp_model.from_map(k))
        return self


class DescribeAutoProvisioningGroupHistoryResponseBodyAutoProvisioningGroupHistoriesAutoProvisioningGroupHistory(TeaModel):
    def __init__(
        self,
        status: str = None,
        start_time: str = None,
        task_id: str = None,
        last_event_time: str = None,
        activity_details: DescribeAutoProvisioningGroupHistoryResponseBodyAutoProvisioningGroupHistoriesAutoProvisioningGroupHistoryActivityDetails = None,
    ):
        self.status = status
        self.start_time = start_time
        self.task_id = task_id
        self.last_event_time = last_event_time
        self.activity_details = activity_details

    def validate(self):
        if self.activity_details:
            self.activity_details.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.status is not None:
            result['Status'] = self.status
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        if self.last_event_time is not None:
            result['LastEventTime'] = self.last_event_time
        if self.activity_details is not None:
            result['ActivityDetails'] = self.activity_details.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        if m.get('LastEventTime') is not None:
            self.last_event_time = m.get('LastEventTime')
        if m.get('ActivityDetails') is not None:
            temp_model = DescribeAutoProvisioningGroupHistoryResponseBodyAutoProvisioningGroupHistoriesAutoProvisioningGroupHistoryActivityDetails()
            self.activity_details = temp_model.from_map(m['ActivityDetails'])
        return self


class DescribeAutoProvisioningGroupHistoryResponseBodyAutoProvisioningGroupHistories(TeaModel):
    def __init__(
        self,
        auto_provisioning_group_history: List[DescribeAutoProvisioningGroupHistoryResponseBodyAutoProvisioningGroupHistoriesAutoProvisioningGroupHistory] = None,
    ):
        self.auto_provisioning_group_history = auto_provisioning_group_history

    def validate(self):
        if self.auto_provisioning_group_history:
            for k in self.auto_provisioning_group_history:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['AutoProvisioningGroupHistory'] = []
        if self.auto_provisioning_group_history is not None:
            for k in self.auto_provisioning_group_history:
                result['AutoProvisioningGroupHistory'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.auto_provisioning_group_history = []
        if m.get('AutoProvisioningGroupHistory') is not None:
            for k in m.get('AutoProvisioningGroupHistory'):
                temp_model = DescribeAutoProvisioningGroupHistoryResponseBodyAutoProvisioningGroupHistoriesAutoProvisioningGroupHistory()
                self.auto_provisioning_group_history.append(temp_model.from_map(k))
        return self


class DescribeAutoProvisioningGroupHistoryResponseBody(TeaModel):
    def __init__(
        self,
        page_size: int = None,
        request_id: str = None,
        page_number: int = None,
        total_count: int = None,
        auto_provisioning_group_histories: DescribeAutoProvisioningGroupHistoryResponseBodyAutoProvisioningGroupHistories = None,
    ):
        self.page_size = page_size
        self.request_id = request_id
        self.page_number = page_number
        self.total_count = total_count
        self.auto_provisioning_group_histories = auto_provisioning_group_histories

    def validate(self):
        if self.auto_provisioning_group_histories:
            self.auto_provisioning_group_histories.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        if self.auto_provisioning_group_histories is not None:
            result['AutoProvisioningGroupHistories'] = self.auto_provisioning_group_histories.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        if m.get('AutoProvisioningGroupHistories') is not None:
            temp_model = DescribeAutoProvisioningGroupHistoryResponseBodyAutoProvisioningGroupHistories()
            self.auto_provisioning_group_histories = temp_model.from_map(m['AutoProvisioningGroupHistories'])
        return self


class DescribeAutoProvisioningGroupHistoryResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeAutoProvisioningGroupHistoryResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeAutoProvisioningGroupHistoryResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeAutoProvisioningGroupInstancesRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        owner_account: str = None,
        region_id: str = None,
        page_number: int = None,
        page_size: int = None,
        auto_provisioning_group_id: str = None,
    ):
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.owner_account = owner_account
        self.region_id = region_id
        self.page_number = page_number
        self.page_size = page_size
        self.auto_provisioning_group_id = auto_provisioning_group_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.auto_provisioning_group_id is not None:
            result['AutoProvisioningGroupId'] = self.auto_provisioning_group_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('AutoProvisioningGroupId') is not None:
            self.auto_provisioning_group_id = m.get('AutoProvisioningGroupId')
        return self


class DescribeAutoProvisioningGroupInstancesResponseBodyInstancesInstance(TeaModel):
    def __init__(
        self,
        status: str = None,
        creation_time: str = None,
        is_spot: bool = None,
        cpu: int = None,
        instance_id: str = None,
        network_type: str = None,
        instance_type: str = None,
        region_id: str = None,
        io_optimized: bool = None,
        os_type: str = None,
        zone_id: str = None,
        memory: int = None,
    ):
        self.status = status
        self.creation_time = creation_time
        self.is_spot = is_spot
        self.cpu = cpu
        self.instance_id = instance_id
        self.network_type = network_type
        self.instance_type = instance_type
        self.region_id = region_id
        self.io_optimized = io_optimized
        self.os_type = os_type
        self.zone_id = zone_id
        self.memory = memory

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.status is not None:
            result['Status'] = self.status
        if self.creation_time is not None:
            result['CreationTime'] = self.creation_time
        if self.is_spot is not None:
            result['IsSpot'] = self.is_spot
        if self.cpu is not None:
            result['CPU'] = self.cpu
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.network_type is not None:
            result['NetworkType'] = self.network_type
        if self.instance_type is not None:
            result['InstanceType'] = self.instance_type
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.io_optimized is not None:
            result['IoOptimized'] = self.io_optimized
        if self.os_type is not None:
            result['OsType'] = self.os_type
        if self.zone_id is not None:
            result['ZoneId'] = self.zone_id
        if self.memory is not None:
            result['Memory'] = self.memory
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('CreationTime') is not None:
            self.creation_time = m.get('CreationTime')
        if m.get('IsSpot') is not None:
            self.is_spot = m.get('IsSpot')
        if m.get('CPU') is not None:
            self.cpu = m.get('CPU')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('NetworkType') is not None:
            self.network_type = m.get('NetworkType')
        if m.get('InstanceType') is not None:
            self.instance_type = m.get('InstanceType')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('IoOptimized') is not None:
            self.io_optimized = m.get('IoOptimized')
        if m.get('OsType') is not None:
            self.os_type = m.get('OsType')
        if m.get('ZoneId') is not None:
            self.zone_id = m.get('ZoneId')
        if m.get('Memory') is not None:
            self.memory = m.get('Memory')
        return self


class DescribeAutoProvisioningGroupInstancesResponseBodyInstances(TeaModel):
    def __init__(
        self,
        instance: List[DescribeAutoProvisioningGroupInstancesResponseBodyInstancesInstance] = None,
    ):
        self.instance = instance

    def validate(self):
        if self.instance:
            for k in self.instance:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Instance'] = []
        if self.instance is not None:
            for k in self.instance:
                result['Instance'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.instance = []
        if m.get('Instance') is not None:
            for k in m.get('Instance'):
                temp_model = DescribeAutoProvisioningGroupInstancesResponseBodyInstancesInstance()
                self.instance.append(temp_model.from_map(k))
        return self


class DescribeAutoProvisioningGroupInstancesResponseBody(TeaModel):
    def __init__(
        self,
        page_size: int = None,
        request_id: str = None,
        page_number: int = None,
        total_count: int = None,
        instances: DescribeAutoProvisioningGroupInstancesResponseBodyInstances = None,
    ):
        self.page_size = page_size
        self.request_id = request_id
        self.page_number = page_number
        self.total_count = total_count
        self.instances = instances

    def validate(self):
        if self.instances:
            self.instances.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        if self.instances is not None:
            result['Instances'] = self.instances.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        if m.get('Instances') is not None:
            temp_model = DescribeAutoProvisioningGroupInstancesResponseBodyInstances()
            self.instances = temp_model.from_map(m['Instances'])
        return self


class DescribeAutoProvisioningGroupInstancesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeAutoProvisioningGroupInstancesResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeAutoProvisioningGroupInstancesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeAutoProvisioningGroupsRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        owner_account: str = None,
        region_id: str = None,
        page_number: int = None,
        page_size: int = None,
        auto_provisioning_group_id: List[str] = None,
        auto_provisioning_group_status: List[str] = None,
        auto_provisioning_group_name: str = None,
    ):
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.owner_account = owner_account
        self.region_id = region_id
        self.page_number = page_number
        self.page_size = page_size
        self.auto_provisioning_group_id = auto_provisioning_group_id
        self.auto_provisioning_group_status = auto_provisioning_group_status
        self.auto_provisioning_group_name = auto_provisioning_group_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.auto_provisioning_group_id is not None:
            result['AutoProvisioningGroupId'] = self.auto_provisioning_group_id
        if self.auto_provisioning_group_status is not None:
            result['AutoProvisioningGroupStatus'] = self.auto_provisioning_group_status
        if self.auto_provisioning_group_name is not None:
            result['AutoProvisioningGroupName'] = self.auto_provisioning_group_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('AutoProvisioningGroupId') is not None:
            self.auto_provisioning_group_id = m.get('AutoProvisioningGroupId')
        if m.get('AutoProvisioningGroupStatus') is not None:
            self.auto_provisioning_group_status = m.get('AutoProvisioningGroupStatus')
        if m.get('AutoProvisioningGroupName') is not None:
            self.auto_provisioning_group_name = m.get('AutoProvisioningGroupName')
        return self


class DescribeAutoProvisioningGroupsResponseBodyAutoProvisioningGroupsAutoProvisioningGroupLaunchTemplateConfigsLaunchTemplateConfig(TeaModel):
    def __init__(
        self,
        max_price: float = None,
        priority: float = None,
        v_switch_id: str = None,
        weighted_capacity: float = None,
        instance_type: str = None,
    ):
        self.max_price = max_price
        self.priority = priority
        self.v_switch_id = v_switch_id
        self.weighted_capacity = weighted_capacity
        self.instance_type = instance_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.max_price is not None:
            result['MaxPrice'] = self.max_price
        if self.priority is not None:
            result['Priority'] = self.priority
        if self.v_switch_id is not None:
            result['VSwitchId'] = self.v_switch_id
        if self.weighted_capacity is not None:
            result['WeightedCapacity'] = self.weighted_capacity
        if self.instance_type is not None:
            result['InstanceType'] = self.instance_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('MaxPrice') is not None:
            self.max_price = m.get('MaxPrice')
        if m.get('Priority') is not None:
            self.priority = m.get('Priority')
        if m.get('VSwitchId') is not None:
            self.v_switch_id = m.get('VSwitchId')
        if m.get('WeightedCapacity') is not None:
            self.weighted_capacity = m.get('WeightedCapacity')
        if m.get('InstanceType') is not None:
            self.instance_type = m.get('InstanceType')
        return self


class DescribeAutoProvisioningGroupsResponseBodyAutoProvisioningGroupsAutoProvisioningGroupLaunchTemplateConfigs(TeaModel):
    def __init__(
        self,
        launch_template_config: List[DescribeAutoProvisioningGroupsResponseBodyAutoProvisioningGroupsAutoProvisioningGroupLaunchTemplateConfigsLaunchTemplateConfig] = None,
    ):
        self.launch_template_config = launch_template_config

    def validate(self):
        if self.launch_template_config:
            for k in self.launch_template_config:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['LaunchTemplateConfig'] = []
        if self.launch_template_config is not None:
            for k in self.launch_template_config:
                result['LaunchTemplateConfig'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.launch_template_config = []
        if m.get('LaunchTemplateConfig') is not None:
            for k in m.get('LaunchTemplateConfig'):
                temp_model = DescribeAutoProvisioningGroupsResponseBodyAutoProvisioningGroupsAutoProvisioningGroupLaunchTemplateConfigsLaunchTemplateConfig()
                self.launch_template_config.append(temp_model.from_map(k))
        return self


class DescribeAutoProvisioningGroupsResponseBodyAutoProvisioningGroupsAutoProvisioningGroupSpotOptions(TeaModel):
    def __init__(
        self,
        instance_pools_to_use_count: int = None,
        allocation_strategy: str = None,
        instance_interruption_behavior: str = None,
    ):
        self.instance_pools_to_use_count = instance_pools_to_use_count
        self.allocation_strategy = allocation_strategy
        self.instance_interruption_behavior = instance_interruption_behavior

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_pools_to_use_count is not None:
            result['InstancePoolsToUseCount'] = self.instance_pools_to_use_count
        if self.allocation_strategy is not None:
            result['AllocationStrategy'] = self.allocation_strategy
        if self.instance_interruption_behavior is not None:
            result['InstanceInterruptionBehavior'] = self.instance_interruption_behavior
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstancePoolsToUseCount') is not None:
            self.instance_pools_to_use_count = m.get('InstancePoolsToUseCount')
        if m.get('AllocationStrategy') is not None:
            self.allocation_strategy = m.get('AllocationStrategy')
        if m.get('InstanceInterruptionBehavior') is not None:
            self.instance_interruption_behavior = m.get('InstanceInterruptionBehavior')
        return self


class DescribeAutoProvisioningGroupsResponseBodyAutoProvisioningGroupsAutoProvisioningGroupPayAsYouGoOptions(TeaModel):
    def __init__(
        self,
        allocation_strategy: str = None,
    ):
        self.allocation_strategy = allocation_strategy

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.allocation_strategy is not None:
            result['AllocationStrategy'] = self.allocation_strategy
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AllocationStrategy') is not None:
            self.allocation_strategy = m.get('AllocationStrategy')
        return self


class DescribeAutoProvisioningGroupsResponseBodyAutoProvisioningGroupsAutoProvisioningGroupTargetCapacitySpecification(TeaModel):
    def __init__(
        self,
        spot_target_capacity: float = None,
        pay_as_you_go_target_capacity: float = None,
        default_target_capacity_type: str = None,
        total_target_capacity: float = None,
    ):
        self.spot_target_capacity = spot_target_capacity
        self.pay_as_you_go_target_capacity = pay_as_you_go_target_capacity
        self.default_target_capacity_type = default_target_capacity_type
        self.total_target_capacity = total_target_capacity

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.spot_target_capacity is not None:
            result['SpotTargetCapacity'] = self.spot_target_capacity
        if self.pay_as_you_go_target_capacity is not None:
            result['PayAsYouGoTargetCapacity'] = self.pay_as_you_go_target_capacity
        if self.default_target_capacity_type is not None:
            result['DefaultTargetCapacityType'] = self.default_target_capacity_type
        if self.total_target_capacity is not None:
            result['TotalTargetCapacity'] = self.total_target_capacity
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('SpotTargetCapacity') is not None:
            self.spot_target_capacity = m.get('SpotTargetCapacity')
        if m.get('PayAsYouGoTargetCapacity') is not None:
            self.pay_as_you_go_target_capacity = m.get('PayAsYouGoTargetCapacity')
        if m.get('DefaultTargetCapacityType') is not None:
            self.default_target_capacity_type = m.get('DefaultTargetCapacityType')
        if m.get('TotalTargetCapacity') is not None:
            self.total_target_capacity = m.get('TotalTargetCapacity')
        return self


class DescribeAutoProvisioningGroupsResponseBodyAutoProvisioningGroupsAutoProvisioningGroup(TeaModel):
    def __init__(
        self,
        creation_time: str = None,
        auto_provisioning_group_name: str = None,
        status: str = None,
        terminate_instances: bool = None,
        max_spot_price: float = None,
        state: str = None,
        launch_template_id: str = None,
        valid_from: str = None,
        launch_template_version: str = None,
        terminate_instances_with_expiration: bool = None,
        region_id: str = None,
        valid_until: str = None,
        auto_provisioning_group_type: str = None,
        auto_provisioning_group_id: str = None,
        excess_capacity_termination_policy: str = None,
        launch_template_configs: DescribeAutoProvisioningGroupsResponseBodyAutoProvisioningGroupsAutoProvisioningGroupLaunchTemplateConfigs = None,
        spot_options: DescribeAutoProvisioningGroupsResponseBodyAutoProvisioningGroupsAutoProvisioningGroupSpotOptions = None,
        pay_as_you_go_options: DescribeAutoProvisioningGroupsResponseBodyAutoProvisioningGroupsAutoProvisioningGroupPayAsYouGoOptions = None,
        target_capacity_specification: DescribeAutoProvisioningGroupsResponseBodyAutoProvisioningGroupsAutoProvisioningGroupTargetCapacitySpecification = None,
    ):
        self.creation_time = creation_time
        self.auto_provisioning_group_name = auto_provisioning_group_name
        self.status = status
        self.terminate_instances = terminate_instances
        self.max_spot_price = max_spot_price
        self.state = state
        self.launch_template_id = launch_template_id
        self.valid_from = valid_from
        self.launch_template_version = launch_template_version
        self.terminate_instances_with_expiration = terminate_instances_with_expiration
        self.region_id = region_id
        self.valid_until = valid_until
        self.auto_provisioning_group_type = auto_provisioning_group_type
        self.auto_provisioning_group_id = auto_provisioning_group_id
        self.excess_capacity_termination_policy = excess_capacity_termination_policy
        self.launch_template_configs = launch_template_configs
        self.spot_options = spot_options
        self.pay_as_you_go_options = pay_as_you_go_options
        self.target_capacity_specification = target_capacity_specification

    def validate(self):
        if self.launch_template_configs:
            self.launch_template_configs.validate()
        if self.spot_options:
            self.spot_options.validate()
        if self.pay_as_you_go_options:
            self.pay_as_you_go_options.validate()
        if self.target_capacity_specification:
            self.target_capacity_specification.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.creation_time is not None:
            result['CreationTime'] = self.creation_time
        if self.auto_provisioning_group_name is not None:
            result['AutoProvisioningGroupName'] = self.auto_provisioning_group_name
        if self.status is not None:
            result['Status'] = self.status
        if self.terminate_instances is not None:
            result['TerminateInstances'] = self.terminate_instances
        if self.max_spot_price is not None:
            result['MaxSpotPrice'] = self.max_spot_price
        if self.state is not None:
            result['State'] = self.state
        if self.launch_template_id is not None:
            result['LaunchTemplateId'] = self.launch_template_id
        if self.valid_from is not None:
            result['ValidFrom'] = self.valid_from
        if self.launch_template_version is not None:
            result['LaunchTemplateVersion'] = self.launch_template_version
        if self.terminate_instances_with_expiration is not None:
            result['TerminateInstancesWithExpiration'] = self.terminate_instances_with_expiration
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.valid_until is not None:
            result['ValidUntil'] = self.valid_until
        if self.auto_provisioning_group_type is not None:
            result['AutoProvisioningGroupType'] = self.auto_provisioning_group_type
        if self.auto_provisioning_group_id is not None:
            result['AutoProvisioningGroupId'] = self.auto_provisioning_group_id
        if self.excess_capacity_termination_policy is not None:
            result['ExcessCapacityTerminationPolicy'] = self.excess_capacity_termination_policy
        if self.launch_template_configs is not None:
            result['LaunchTemplateConfigs'] = self.launch_template_configs.to_map()
        if self.spot_options is not None:
            result['SpotOptions'] = self.spot_options.to_map()
        if self.pay_as_you_go_options is not None:
            result['PayAsYouGoOptions'] = self.pay_as_you_go_options.to_map()
        if self.target_capacity_specification is not None:
            result['TargetCapacitySpecification'] = self.target_capacity_specification.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CreationTime') is not None:
            self.creation_time = m.get('CreationTime')
        if m.get('AutoProvisioningGroupName') is not None:
            self.auto_provisioning_group_name = m.get('AutoProvisioningGroupName')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('TerminateInstances') is not None:
            self.terminate_instances = m.get('TerminateInstances')
        if m.get('MaxSpotPrice') is not None:
            self.max_spot_price = m.get('MaxSpotPrice')
        if m.get('State') is not None:
            self.state = m.get('State')
        if m.get('LaunchTemplateId') is not None:
            self.launch_template_id = m.get('LaunchTemplateId')
        if m.get('ValidFrom') is not None:
            self.valid_from = m.get('ValidFrom')
        if m.get('LaunchTemplateVersion') is not None:
            self.launch_template_version = m.get('LaunchTemplateVersion')
        if m.get('TerminateInstancesWithExpiration') is not None:
            self.terminate_instances_with_expiration = m.get('TerminateInstancesWithExpiration')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ValidUntil') is not None:
            self.valid_until = m.get('ValidUntil')
        if m.get('AutoProvisioningGroupType') is not None:
            self.auto_provisioning_group_type = m.get('AutoProvisioningGroupType')
        if m.get('AutoProvisioningGroupId') is not None:
            self.auto_provisioning_group_id = m.get('AutoProvisioningGroupId')
        if m.get('ExcessCapacityTerminationPolicy') is not None:
            self.excess_capacity_termination_policy = m.get('ExcessCapacityTerminationPolicy')
        if m.get('LaunchTemplateConfigs') is not None:
            temp_model = DescribeAutoProvisioningGroupsResponseBodyAutoProvisioningGroupsAutoProvisioningGroupLaunchTemplateConfigs()
            self.launch_template_configs = temp_model.from_map(m['LaunchTemplateConfigs'])
        if m.get('SpotOptions') is not None:
            temp_model = DescribeAutoProvisioningGroupsResponseBodyAutoProvisioningGroupsAutoProvisioningGroupSpotOptions()
            self.spot_options = temp_model.from_map(m['SpotOptions'])
        if m.get('PayAsYouGoOptions') is not None:
            temp_model = DescribeAutoProvisioningGroupsResponseBodyAutoProvisioningGroupsAutoProvisioningGroupPayAsYouGoOptions()
            self.pay_as_you_go_options = temp_model.from_map(m['PayAsYouGoOptions'])
        if m.get('TargetCapacitySpecification') is not None:
            temp_model = DescribeAutoProvisioningGroupsResponseBodyAutoProvisioningGroupsAutoProvisioningGroupTargetCapacitySpecification()
            self.target_capacity_specification = temp_model.from_map(m['TargetCapacitySpecification'])
        return self


class DescribeAutoProvisioningGroupsResponseBodyAutoProvisioningGroups(TeaModel):
    def __init__(
        self,
        auto_provisioning_group: List[DescribeAutoProvisioningGroupsResponseBodyAutoProvisioningGroupsAutoProvisioningGroup] = None,
    ):
        self.auto_provisioning_group = auto_provisioning_group

    def validate(self):
        if self.auto_provisioning_group:
            for k in self.auto_provisioning_group:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['AutoProvisioningGroup'] = []
        if self.auto_provisioning_group is not None:
            for k in self.auto_provisioning_group:
                result['AutoProvisioningGroup'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.auto_provisioning_group = []
        if m.get('AutoProvisioningGroup') is not None:
            for k in m.get('AutoProvisioningGroup'):
                temp_model = DescribeAutoProvisioningGroupsResponseBodyAutoProvisioningGroupsAutoProvisioningGroup()
                self.auto_provisioning_group.append(temp_model.from_map(k))
        return self


class DescribeAutoProvisioningGroupsResponseBody(TeaModel):
    def __init__(
        self,
        page_size: int = None,
        request_id: str = None,
        page_number: int = None,
        total_count: int = None,
        auto_provisioning_groups: DescribeAutoProvisioningGroupsResponseBodyAutoProvisioningGroups = None,
    ):
        self.page_size = page_size
        self.request_id = request_id
        self.page_number = page_number
        self.total_count = total_count
        self.auto_provisioning_groups = auto_provisioning_groups

    def validate(self):
        if self.auto_provisioning_groups:
            self.auto_provisioning_groups.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        if self.auto_provisioning_groups is not None:
            result['AutoProvisioningGroups'] = self.auto_provisioning_groups.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        if m.get('AutoProvisioningGroups') is not None:
            temp_model = DescribeAutoProvisioningGroupsResponseBodyAutoProvisioningGroups()
            self.auto_provisioning_groups = temp_model.from_map(m['AutoProvisioningGroups'])
        return self


class DescribeAutoProvisioningGroupsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeAutoProvisioningGroupsResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeAutoProvisioningGroupsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeAutoSnapshotPolicyExRequestTag(TeaModel):
    def __init__(
        self,
        key: str = None,
        value: str = None,
    ):
        self.key = key
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class DescribeAutoSnapshotPolicyExRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        owner_account: str = None,
        region_id: str = None,
        auto_snapshot_policy_id: str = None,
        page_number: int = None,
        page_size: int = None,
        tag: List[DescribeAutoSnapshotPolicyExRequestTag] = None,
    ):
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.owner_account = owner_account
        self.region_id = region_id
        self.auto_snapshot_policy_id = auto_snapshot_policy_id
        self.page_number = page_number
        self.page_size = page_size
        self.tag = tag

    def validate(self):
        if self.tag:
            for k in self.tag:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.auto_snapshot_policy_id is not None:
            result['AutoSnapshotPolicyId'] = self.auto_snapshot_policy_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        result['Tag'] = []
        if self.tag is not None:
            for k in self.tag:
                result['Tag'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('AutoSnapshotPolicyId') is not None:
            self.auto_snapshot_policy_id = m.get('AutoSnapshotPolicyId')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        self.tag = []
        if m.get('Tag') is not None:
            for k in m.get('Tag'):
                temp_model = DescribeAutoSnapshotPolicyExRequestTag()
                self.tag.append(temp_model.from_map(k))
        return self


class DescribeAutoSnapshotPolicyExResponseBodyAutoSnapshotPoliciesAutoSnapshotPolicyTagsTag(TeaModel):
    def __init__(
        self,
        tag_value: str = None,
        tag_key: str = None,
    ):
        self.tag_value = tag_value
        self.tag_key = tag_key

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.tag_value is not None:
            result['TagValue'] = self.tag_value
        if self.tag_key is not None:
            result['TagKey'] = self.tag_key
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TagValue') is not None:
            self.tag_value = m.get('TagValue')
        if m.get('TagKey') is not None:
            self.tag_key = m.get('TagKey')
        return self


class DescribeAutoSnapshotPolicyExResponseBodyAutoSnapshotPoliciesAutoSnapshotPolicyTags(TeaModel):
    def __init__(
        self,
        tag: List[DescribeAutoSnapshotPolicyExResponseBodyAutoSnapshotPoliciesAutoSnapshotPolicyTagsTag] = None,
    ):
        self.tag = tag

    def validate(self):
        if self.tag:
            for k in self.tag:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Tag'] = []
        if self.tag is not None:
            for k in self.tag:
                result['Tag'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.tag = []
        if m.get('Tag') is not None:
            for k in m.get('Tag'):
                temp_model = DescribeAutoSnapshotPolicyExResponseBodyAutoSnapshotPoliciesAutoSnapshotPolicyTagsTag()
                self.tag.append(temp_model.from_map(k))
        return self


class DescribeAutoSnapshotPolicyExResponseBodyAutoSnapshotPoliciesAutoSnapshotPolicy(TeaModel):
    def __init__(
        self,
        time_points: str = None,
        creation_time: str = None,
        status: str = None,
        auto_snapshot_policy_name: str = None,
        target_copy_regions: str = None,
        copied_snapshots_retention_days: int = None,
        auto_snapshot_policy_id: str = None,
        retention_days: int = None,
        region_id: str = None,
        disk_nums: int = None,
        enable_cross_region_copy: bool = None,
        repeat_weekdays: str = None,
        volume_nums: int = None,
        tags: DescribeAutoSnapshotPolicyExResponseBodyAutoSnapshotPoliciesAutoSnapshotPolicyTags = None,
    ):
        self.time_points = time_points
        self.creation_time = creation_time
        self.status = status
        self.auto_snapshot_policy_name = auto_snapshot_policy_name
        self.target_copy_regions = target_copy_regions
        self.copied_snapshots_retention_days = copied_snapshots_retention_days
        self.auto_snapshot_policy_id = auto_snapshot_policy_id
        self.retention_days = retention_days
        self.region_id = region_id
        self.disk_nums = disk_nums
        self.enable_cross_region_copy = enable_cross_region_copy
        self.repeat_weekdays = repeat_weekdays
        self.volume_nums = volume_nums
        self.tags = tags

    def validate(self):
        if self.tags:
            self.tags.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.time_points is not None:
            result['TimePoints'] = self.time_points
        if self.creation_time is not None:
            result['CreationTime'] = self.creation_time
        if self.status is not None:
            result['Status'] = self.status
        if self.auto_snapshot_policy_name is not None:
            result['AutoSnapshotPolicyName'] = self.auto_snapshot_policy_name
        if self.target_copy_regions is not None:
            result['TargetCopyRegions'] = self.target_copy_regions
        if self.copied_snapshots_retention_days is not None:
            result['CopiedSnapshotsRetentionDays'] = self.copied_snapshots_retention_days
        if self.auto_snapshot_policy_id is not None:
            result['AutoSnapshotPolicyId'] = self.auto_snapshot_policy_id
        if self.retention_days is not None:
            result['RetentionDays'] = self.retention_days
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.disk_nums is not None:
            result['DiskNums'] = self.disk_nums
        if self.enable_cross_region_copy is not None:
            result['EnableCrossRegionCopy'] = self.enable_cross_region_copy
        if self.repeat_weekdays is not None:
            result['RepeatWeekdays'] = self.repeat_weekdays
        if self.volume_nums is not None:
            result['VolumeNums'] = self.volume_nums
        if self.tags is not None:
            result['Tags'] = self.tags.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TimePoints') is not None:
            self.time_points = m.get('TimePoints')
        if m.get('CreationTime') is not None:
            self.creation_time = m.get('CreationTime')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('AutoSnapshotPolicyName') is not None:
            self.auto_snapshot_policy_name = m.get('AutoSnapshotPolicyName')
        if m.get('TargetCopyRegions') is not None:
            self.target_copy_regions = m.get('TargetCopyRegions')
        if m.get('CopiedSnapshotsRetentionDays') is not None:
            self.copied_snapshots_retention_days = m.get('CopiedSnapshotsRetentionDays')
        if m.get('AutoSnapshotPolicyId') is not None:
            self.auto_snapshot_policy_id = m.get('AutoSnapshotPolicyId')
        if m.get('RetentionDays') is not None:
            self.retention_days = m.get('RetentionDays')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('DiskNums') is not None:
            self.disk_nums = m.get('DiskNums')
        if m.get('EnableCrossRegionCopy') is not None:
            self.enable_cross_region_copy = m.get('EnableCrossRegionCopy')
        if m.get('RepeatWeekdays') is not None:
            self.repeat_weekdays = m.get('RepeatWeekdays')
        if m.get('VolumeNums') is not None:
            self.volume_nums = m.get('VolumeNums')
        if m.get('Tags') is not None:
            temp_model = DescribeAutoSnapshotPolicyExResponseBodyAutoSnapshotPoliciesAutoSnapshotPolicyTags()
            self.tags = temp_model.from_map(m['Tags'])
        return self


class DescribeAutoSnapshotPolicyExResponseBodyAutoSnapshotPolicies(TeaModel):
    def __init__(
        self,
        auto_snapshot_policy: List[DescribeAutoSnapshotPolicyExResponseBodyAutoSnapshotPoliciesAutoSnapshotPolicy] = None,
    ):
        self.auto_snapshot_policy = auto_snapshot_policy

    def validate(self):
        if self.auto_snapshot_policy:
            for k in self.auto_snapshot_policy:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['AutoSnapshotPolicy'] = []
        if self.auto_snapshot_policy is not None:
            for k in self.auto_snapshot_policy:
                result['AutoSnapshotPolicy'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.auto_snapshot_policy = []
        if m.get('AutoSnapshotPolicy') is not None:
            for k in m.get('AutoSnapshotPolicy'):
                temp_model = DescribeAutoSnapshotPolicyExResponseBodyAutoSnapshotPoliciesAutoSnapshotPolicy()
                self.auto_snapshot_policy.append(temp_model.from_map(k))
        return self


class DescribeAutoSnapshotPolicyExResponseBody(TeaModel):
    def __init__(
        self,
        page_size: int = None,
        request_id: str = None,
        page_number: int = None,
        total_count: int = None,
        auto_snapshot_policies: DescribeAutoSnapshotPolicyExResponseBodyAutoSnapshotPolicies = None,
    ):
        self.page_size = page_size
        self.request_id = request_id
        self.page_number = page_number
        self.total_count = total_count
        self.auto_snapshot_policies = auto_snapshot_policies

    def validate(self):
        if self.auto_snapshot_policies:
            self.auto_snapshot_policies.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        if self.auto_snapshot_policies is not None:
            result['AutoSnapshotPolicies'] = self.auto_snapshot_policies.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        if m.get('AutoSnapshotPolicies') is not None:
            temp_model = DescribeAutoSnapshotPolicyExResponseBodyAutoSnapshotPolicies()
            self.auto_snapshot_policies = temp_model.from_map(m['AutoSnapshotPolicies'])
        return self


class DescribeAutoSnapshotPolicyExResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeAutoSnapshotPolicyExResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeAutoSnapshotPolicyExResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeAvailableResourceRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        owner_account: str = None,
        region_id: str = None,
        instance_charge_type: str = None,
        spot_strategy: str = None,
        spot_duration: int = None,
        destination_resource: str = None,
        zone_id: str = None,
        io_optimized: str = None,
        dedicated_host_id: str = None,
        instance_type: str = None,
        system_disk_category: str = None,
        data_disk_category: str = None,
        network_category: str = None,
        cores: int = None,
        memory: float = None,
        resource_type: str = None,
        scope: str = None,
    ):
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.owner_account = owner_account
        self.region_id = region_id
        self.instance_charge_type = instance_charge_type
        self.spot_strategy = spot_strategy
        self.spot_duration = spot_duration
        self.destination_resource = destination_resource
        self.zone_id = zone_id
        self.io_optimized = io_optimized
        self.dedicated_host_id = dedicated_host_id
        self.instance_type = instance_type
        self.system_disk_category = system_disk_category
        self.data_disk_category = data_disk_category
        self.network_category = network_category
        self.cores = cores
        self.memory = memory
        self.resource_type = resource_type
        self.scope = scope

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.instance_charge_type is not None:
            result['InstanceChargeType'] = self.instance_charge_type
        if self.spot_strategy is not None:
            result['SpotStrategy'] = self.spot_strategy
        if self.spot_duration is not None:
            result['SpotDuration'] = self.spot_duration
        if self.destination_resource is not None:
            result['DestinationResource'] = self.destination_resource
        if self.zone_id is not None:
            result['ZoneId'] = self.zone_id
        if self.io_optimized is not None:
            result['IoOptimized'] = self.io_optimized
        if self.dedicated_host_id is not None:
            result['DedicatedHostId'] = self.dedicated_host_id
        if self.instance_type is not None:
            result['InstanceType'] = self.instance_type
        if self.system_disk_category is not None:
            result['SystemDiskCategory'] = self.system_disk_category
        if self.data_disk_category is not None:
            result['DataDiskCategory'] = self.data_disk_category
        if self.network_category is not None:
            result['NetworkCategory'] = self.network_category
        if self.cores is not None:
            result['Cores'] = self.cores
        if self.memory is not None:
            result['Memory'] = self.memory
        if self.resource_type is not None:
            result['ResourceType'] = self.resource_type
        if self.scope is not None:
            result['Scope'] = self.scope
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('InstanceChargeType') is not None:
            self.instance_charge_type = m.get('InstanceChargeType')
        if m.get('SpotStrategy') is not None:
            self.spot_strategy = m.get('SpotStrategy')
        if m.get('SpotDuration') is not None:
            self.spot_duration = m.get('SpotDuration')
        if m.get('DestinationResource') is not None:
            self.destination_resource = m.get('DestinationResource')
        if m.get('ZoneId') is not None:
            self.zone_id = m.get('ZoneId')
        if m.get('IoOptimized') is not None:
            self.io_optimized = m.get('IoOptimized')
        if m.get('DedicatedHostId') is not None:
            self.dedicated_host_id = m.get('DedicatedHostId')
        if m.get('InstanceType') is not None:
            self.instance_type = m.get('InstanceType')
        if m.get('SystemDiskCategory') is not None:
            self.system_disk_category = m.get('SystemDiskCategory')
        if m.get('DataDiskCategory') is not None:
            self.data_disk_category = m.get('DataDiskCategory')
        if m.get('NetworkCategory') is not None:
            self.network_category = m.get('NetworkCategory')
        if m.get('Cores') is not None:
            self.cores = m.get('Cores')
        if m.get('Memory') is not None:
            self.memory = m.get('Memory')
        if m.get('ResourceType') is not None:
            self.resource_type = m.get('ResourceType')
        if m.get('Scope') is not None:
            self.scope = m.get('Scope')
        return self


class DescribeAvailableResourceResponseBodyAvailableZonesAvailableZoneAvailableResourcesAvailableResourceSupportedResourcesSupportedResource(TeaModel):
    def __init__(
        self,
        status: str = None,
        value: str = None,
        max: int = None,
        unit: str = None,
        status_category: str = None,
        min: int = None,
    ):
        self.status = status
        self.value = value
        self.max = max
        self.unit = unit
        self.status_category = status_category
        self.min = min

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.status is not None:
            result['Status'] = self.status
        if self.value is not None:
            result['Value'] = self.value
        if self.max is not None:
            result['Max'] = self.max
        if self.unit is not None:
            result['Unit'] = self.unit
        if self.status_category is not None:
            result['StatusCategory'] = self.status_category
        if self.min is not None:
            result['Min'] = self.min
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        if m.get('Max') is not None:
            self.max = m.get('Max')
        if m.get('Unit') is not None:
            self.unit = m.get('Unit')
        if m.get('StatusCategory') is not None:
            self.status_category = m.get('StatusCategory')
        if m.get('Min') is not None:
            self.min = m.get('Min')
        return self


class DescribeAvailableResourceResponseBodyAvailableZonesAvailableZoneAvailableResourcesAvailableResourceSupportedResources(TeaModel):
    def __init__(
        self,
        supported_resource: List[DescribeAvailableResourceResponseBodyAvailableZonesAvailableZoneAvailableResourcesAvailableResourceSupportedResourcesSupportedResource] = None,
    ):
        self.supported_resource = supported_resource

    def validate(self):
        if self.supported_resource:
            for k in self.supported_resource:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['SupportedResource'] = []
        if self.supported_resource is not None:
            for k in self.supported_resource:
                result['SupportedResource'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.supported_resource = []
        if m.get('SupportedResource') is not None:
            for k in m.get('SupportedResource'):
                temp_model = DescribeAvailableResourceResponseBodyAvailableZonesAvailableZoneAvailableResourcesAvailableResourceSupportedResourcesSupportedResource()
                self.supported_resource.append(temp_model.from_map(k))
        return self


class DescribeAvailableResourceResponseBodyAvailableZonesAvailableZoneAvailableResourcesAvailableResource(TeaModel):
    def __init__(
        self,
        type: str = None,
        supported_resources: DescribeAvailableResourceResponseBodyAvailableZonesAvailableZoneAvailableResourcesAvailableResourceSupportedResources = None,
    ):
        self.type = type
        self.supported_resources = supported_resources

    def validate(self):
        if self.supported_resources:
            self.supported_resources.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.type is not None:
            result['Type'] = self.type
        if self.supported_resources is not None:
            result['SupportedResources'] = self.supported_resources.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('SupportedResources') is not None:
            temp_model = DescribeAvailableResourceResponseBodyAvailableZonesAvailableZoneAvailableResourcesAvailableResourceSupportedResources()
            self.supported_resources = temp_model.from_map(m['SupportedResources'])
        return self


class DescribeAvailableResourceResponseBodyAvailableZonesAvailableZoneAvailableResources(TeaModel):
    def __init__(
        self,
        available_resource: List[DescribeAvailableResourceResponseBodyAvailableZonesAvailableZoneAvailableResourcesAvailableResource] = None,
    ):
        self.available_resource = available_resource

    def validate(self):
        if self.available_resource:
            for k in self.available_resource:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['AvailableResource'] = []
        if self.available_resource is not None:
            for k in self.available_resource:
                result['AvailableResource'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.available_resource = []
        if m.get('AvailableResource') is not None:
            for k in m.get('AvailableResource'):
                temp_model = DescribeAvailableResourceResponseBodyAvailableZonesAvailableZoneAvailableResourcesAvailableResource()
                self.available_resource.append(temp_model.from_map(k))
        return self


class DescribeAvailableResourceResponseBodyAvailableZonesAvailableZone(TeaModel):
    def __init__(
        self,
        zone_id: str = None,
        status: str = None,
        status_category: str = None,
        region_id: str = None,
        available_resources: DescribeAvailableResourceResponseBodyAvailableZonesAvailableZoneAvailableResources = None,
    ):
        self.zone_id = zone_id
        self.status = status
        self.status_category = status_category
        self.region_id = region_id
        self.available_resources = available_resources

    def validate(self):
        if self.available_resources:
            self.available_resources.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.zone_id is not None:
            result['ZoneId'] = self.zone_id
        if self.status is not None:
            result['Status'] = self.status
        if self.status_category is not None:
            result['StatusCategory'] = self.status_category
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.available_resources is not None:
            result['AvailableResources'] = self.available_resources.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ZoneId') is not None:
            self.zone_id = m.get('ZoneId')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('StatusCategory') is not None:
            self.status_category = m.get('StatusCategory')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('AvailableResources') is not None:
            temp_model = DescribeAvailableResourceResponseBodyAvailableZonesAvailableZoneAvailableResources()
            self.available_resources = temp_model.from_map(m['AvailableResources'])
        return self


class DescribeAvailableResourceResponseBodyAvailableZones(TeaModel):
    def __init__(
        self,
        available_zone: List[DescribeAvailableResourceResponseBodyAvailableZonesAvailableZone] = None,
    ):
        self.available_zone = available_zone

    def validate(self):
        if self.available_zone:
            for k in self.available_zone:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['AvailableZone'] = []
        if self.available_zone is not None:
            for k in self.available_zone:
                result['AvailableZone'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.available_zone = []
        if m.get('AvailableZone') is not None:
            for k in m.get('AvailableZone'):
                temp_model = DescribeAvailableResourceResponseBodyAvailableZonesAvailableZone()
                self.available_zone.append(temp_model.from_map(k))
        return self


class DescribeAvailableResourceResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        available_zones: DescribeAvailableResourceResponseBodyAvailableZones = None,
    ):
        self.request_id = request_id
        self.available_zones = available_zones

    def validate(self):
        if self.available_zones:
            self.available_zones.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.available_zones is not None:
            result['AvailableZones'] = self.available_zones.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('AvailableZones') is not None:
            temp_model = DescribeAvailableResourceResponseBodyAvailableZones()
            self.available_zones = temp_model.from_map(m['AvailableZones'])
        return self


class DescribeAvailableResourceResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeAvailableResourceResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeAvailableResourceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeBandwidthLimitationRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        owner_account: str = None,
        region_id: str = None,
        instance_charge_type: str = None,
        spot_strategy: str = None,
        instance_type: str = None,
        resource_id: str = None,
        operation_type: str = None,
    ):
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.owner_account = owner_account
        self.region_id = region_id
        self.instance_charge_type = instance_charge_type
        self.spot_strategy = spot_strategy
        self.instance_type = instance_type
        self.resource_id = resource_id
        self.operation_type = operation_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.instance_charge_type is not None:
            result['InstanceChargeType'] = self.instance_charge_type
        if self.spot_strategy is not None:
            result['SpotStrategy'] = self.spot_strategy
        if self.instance_type is not None:
            result['InstanceType'] = self.instance_type
        if self.resource_id is not None:
            result['ResourceId'] = self.resource_id
        if self.operation_type is not None:
            result['OperationType'] = self.operation_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('InstanceChargeType') is not None:
            self.instance_charge_type = m.get('InstanceChargeType')
        if m.get('SpotStrategy') is not None:
            self.spot_strategy = m.get('SpotStrategy')
        if m.get('InstanceType') is not None:
            self.instance_type = m.get('InstanceType')
        if m.get('ResourceId') is not None:
            self.resource_id = m.get('ResourceId')
        if m.get('OperationType') is not None:
            self.operation_type = m.get('OperationType')
        return self


class DescribeBandwidthLimitationResponseBodyBandwidthsBandwidth(TeaModel):
    def __init__(
        self,
        internet_charge_type: str = None,
        max: int = None,
        min: int = None,
        unit: str = None,
    ):
        self.internet_charge_type = internet_charge_type
        self.max = max
        self.min = min
        self.unit = unit

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.internet_charge_type is not None:
            result['InternetChargeType'] = self.internet_charge_type
        if self.max is not None:
            result['Max'] = self.max
        if self.min is not None:
            result['Min'] = self.min
        if self.unit is not None:
            result['Unit'] = self.unit
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InternetChargeType') is not None:
            self.internet_charge_type = m.get('InternetChargeType')
        if m.get('Max') is not None:
            self.max = m.get('Max')
        if m.get('Min') is not None:
            self.min = m.get('Min')
        if m.get('Unit') is not None:
            self.unit = m.get('Unit')
        return self


class DescribeBandwidthLimitationResponseBodyBandwidths(TeaModel):
    def __init__(
        self,
        bandwidth: List[DescribeBandwidthLimitationResponseBodyBandwidthsBandwidth] = None,
    ):
        self.bandwidth = bandwidth

    def validate(self):
        if self.bandwidth:
            for k in self.bandwidth:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Bandwidth'] = []
        if self.bandwidth is not None:
            for k in self.bandwidth:
                result['Bandwidth'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.bandwidth = []
        if m.get('Bandwidth') is not None:
            for k in m.get('Bandwidth'):
                temp_model = DescribeBandwidthLimitationResponseBodyBandwidthsBandwidth()
                self.bandwidth.append(temp_model.from_map(k))
        return self


class DescribeBandwidthLimitationResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        bandwidths: DescribeBandwidthLimitationResponseBodyBandwidths = None,
    ):
        self.request_id = request_id
        self.bandwidths = bandwidths

    def validate(self):
        if self.bandwidths:
            self.bandwidths.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.bandwidths is not None:
            result['Bandwidths'] = self.bandwidths.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Bandwidths') is not None:
            temp_model = DescribeBandwidthLimitationResponseBodyBandwidths()
            self.bandwidths = temp_model.from_map(m['Bandwidths'])
        return self


class DescribeBandwidthLimitationResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeBandwidthLimitationResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeBandwidthLimitationResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeBandwidthPackagesRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        owner_account: str = None,
        region_id: str = None,
        bandwidth_package_id: str = None,
        nat_gateway_id: str = None,
        page_number: int = None,
        page_size: int = None,
    ):
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.owner_account = owner_account
        self.region_id = region_id
        self.bandwidth_package_id = bandwidth_package_id
        self.nat_gateway_id = nat_gateway_id
        self.page_number = page_number
        self.page_size = page_size

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.bandwidth_package_id is not None:
            result['BandwidthPackageId'] = self.bandwidth_package_id
        if self.nat_gateway_id is not None:
            result['NatGatewayId'] = self.nat_gateway_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('BandwidthPackageId') is not None:
            self.bandwidth_package_id = m.get('BandwidthPackageId')
        if m.get('NatGatewayId') is not None:
            self.nat_gateway_id = m.get('NatGatewayId')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        return self


class DescribeBandwidthPackagesResponseBodyBandwidthPackagesBandwidthPackagePublicIpAddressesPublicIpAddresse(TeaModel):
    def __init__(
        self,
        ip_address: str = None,
        allocation_id: str = None,
    ):
        self.ip_address = ip_address
        self.allocation_id = allocation_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ip_address is not None:
            result['IpAddress'] = self.ip_address
        if self.allocation_id is not None:
            result['AllocationId'] = self.allocation_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IpAddress') is not None:
            self.ip_address = m.get('IpAddress')
        if m.get('AllocationId') is not None:
            self.allocation_id = m.get('AllocationId')
        return self


class DescribeBandwidthPackagesResponseBodyBandwidthPackagesBandwidthPackagePublicIpAddresses(TeaModel):
    def __init__(
        self,
        public_ip_addresse: List[DescribeBandwidthPackagesResponseBodyBandwidthPackagesBandwidthPackagePublicIpAddressesPublicIpAddresse] = None,
    ):
        self.public_ip_addresse = public_ip_addresse

    def validate(self):
        if self.public_ip_addresse:
            for k in self.public_ip_addresse:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['PublicIpAddresse'] = []
        if self.public_ip_addresse is not None:
            for k in self.public_ip_addresse:
                result['PublicIpAddresse'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.public_ip_addresse = []
        if m.get('PublicIpAddresse') is not None:
            for k in m.get('PublicIpAddresse'):
                temp_model = DescribeBandwidthPackagesResponseBodyBandwidthPackagesBandwidthPackagePublicIpAddressesPublicIpAddresse()
                self.public_ip_addresse.append(temp_model.from_map(k))
        return self


class DescribeBandwidthPackagesResponseBodyBandwidthPackagesBandwidthPackage(TeaModel):
    def __init__(
        self,
        status: str = None,
        creation_time: str = None,
        ip_count: str = None,
        region_id: str = None,
        instance_charge_type: str = None,
        bandwidth_package_id: str = None,
        description: str = None,
        bandwidth: str = None,
        nat_gateway_id: str = None,
        zone_id: str = None,
        internet_charge_type: str = None,
        business_status: str = None,
        name: str = None,
        isp: str = None,
        public_ip_addresses: DescribeBandwidthPackagesResponseBodyBandwidthPackagesBandwidthPackagePublicIpAddresses = None,
    ):
        self.status = status
        self.creation_time = creation_time
        self.ip_count = ip_count
        self.region_id = region_id
        self.instance_charge_type = instance_charge_type
        self.bandwidth_package_id = bandwidth_package_id
        self.description = description
        self.bandwidth = bandwidth
        self.nat_gateway_id = nat_gateway_id
        self.zone_id = zone_id
        self.internet_charge_type = internet_charge_type
        self.business_status = business_status
        self.name = name
        self.isp = isp
        self.public_ip_addresses = public_ip_addresses

    def validate(self):
        if self.public_ip_addresses:
            self.public_ip_addresses.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.status is not None:
            result['Status'] = self.status
        if self.creation_time is not None:
            result['CreationTime'] = self.creation_time
        if self.ip_count is not None:
            result['IpCount'] = self.ip_count
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.instance_charge_type is not None:
            result['InstanceChargeType'] = self.instance_charge_type
        if self.bandwidth_package_id is not None:
            result['BandwidthPackageId'] = self.bandwidth_package_id
        if self.description is not None:
            result['Description'] = self.description
        if self.bandwidth is not None:
            result['Bandwidth'] = self.bandwidth
        if self.nat_gateway_id is not None:
            result['NatGatewayId'] = self.nat_gateway_id
        if self.zone_id is not None:
            result['ZoneId'] = self.zone_id
        if self.internet_charge_type is not None:
            result['InternetChargeType'] = self.internet_charge_type
        if self.business_status is not None:
            result['BusinessStatus'] = self.business_status
        if self.name is not None:
            result['Name'] = self.name
        if self.isp is not None:
            result['ISP'] = self.isp
        if self.public_ip_addresses is not None:
            result['PublicIpAddresses'] = self.public_ip_addresses.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('CreationTime') is not None:
            self.creation_time = m.get('CreationTime')
        if m.get('IpCount') is not None:
            self.ip_count = m.get('IpCount')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('InstanceChargeType') is not None:
            self.instance_charge_type = m.get('InstanceChargeType')
        if m.get('BandwidthPackageId') is not None:
            self.bandwidth_package_id = m.get('BandwidthPackageId')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('Bandwidth') is not None:
            self.bandwidth = m.get('Bandwidth')
        if m.get('NatGatewayId') is not None:
            self.nat_gateway_id = m.get('NatGatewayId')
        if m.get('ZoneId') is not None:
            self.zone_id = m.get('ZoneId')
        if m.get('InternetChargeType') is not None:
            self.internet_charge_type = m.get('InternetChargeType')
        if m.get('BusinessStatus') is not None:
            self.business_status = m.get('BusinessStatus')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('ISP') is not None:
            self.isp = m.get('ISP')
        if m.get('PublicIpAddresses') is not None:
            temp_model = DescribeBandwidthPackagesResponseBodyBandwidthPackagesBandwidthPackagePublicIpAddresses()
            self.public_ip_addresses = temp_model.from_map(m['PublicIpAddresses'])
        return self


class DescribeBandwidthPackagesResponseBodyBandwidthPackages(TeaModel):
    def __init__(
        self,
        bandwidth_package: List[DescribeBandwidthPackagesResponseBodyBandwidthPackagesBandwidthPackage] = None,
    ):
        self.bandwidth_package = bandwidth_package

    def validate(self):
        if self.bandwidth_package:
            for k in self.bandwidth_package:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['BandwidthPackage'] = []
        if self.bandwidth_package is not None:
            for k in self.bandwidth_package:
                result['BandwidthPackage'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.bandwidth_package = []
        if m.get('BandwidthPackage') is not None:
            for k in m.get('BandwidthPackage'):
                temp_model = DescribeBandwidthPackagesResponseBodyBandwidthPackagesBandwidthPackage()
                self.bandwidth_package.append(temp_model.from_map(k))
        return self


class DescribeBandwidthPackagesResponseBody(TeaModel):
    def __init__(
        self,
        page_size: int = None,
        request_id: str = None,
        page_number: int = None,
        total_count: int = None,
        bandwidth_packages: DescribeBandwidthPackagesResponseBodyBandwidthPackages = None,
    ):
        self.page_size = page_size
        self.request_id = request_id
        self.page_number = page_number
        self.total_count = total_count
        self.bandwidth_packages = bandwidth_packages

    def validate(self):
        if self.bandwidth_packages:
            self.bandwidth_packages.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        if self.bandwidth_packages is not None:
            result['BandwidthPackages'] = self.bandwidth_packages.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        if m.get('BandwidthPackages') is not None:
            temp_model = DescribeBandwidthPackagesResponseBodyBandwidthPackages()
            self.bandwidth_packages = temp_model.from_map(m['BandwidthPackages'])
        return self


class DescribeBandwidthPackagesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeBandwidthPackagesResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeBandwidthPackagesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeCapacityReservationInstancesRequestPrivatePoolOptions(TeaModel):
    def __init__(
        self,
        id: str = None,
    ):
        self.id = id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.id is not None:
            result['Id'] = self.id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Id') is not None:
            self.id = m.get('Id')
        return self


class DescribeCapacityReservationInstancesRequest(TeaModel):
    def __init__(
        self,
        private_pool_options: DescribeCapacityReservationInstancesRequestPrivatePoolOptions = None,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        owner_account: str = None,
        region_id: str = None,
        max_results: int = None,
        next_token: str = None,
    ):
        self.private_pool_options = private_pool_options
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.owner_account = owner_account
        self.region_id = region_id
        self.max_results = max_results
        self.next_token = next_token

    def validate(self):
        if self.private_pool_options:
            self.private_pool_options.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.private_pool_options is not None:
            result['PrivatePoolOptions'] = self.private_pool_options.to_map()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.max_results is not None:
            result['MaxResults'] = self.max_results
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PrivatePoolOptions') is not None:
            temp_model = DescribeCapacityReservationInstancesRequestPrivatePoolOptions()
            self.private_pool_options = temp_model.from_map(m['PrivatePoolOptions'])
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('MaxResults') is not None:
            self.max_results = m.get('MaxResults')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        return self


class DescribeCapacityReservationInstancesResponseBodyCapacityReservationItemInstanceIdSet(TeaModel):
    def __init__(
        self,
        instance_id: str = None,
    ):
        self.instance_id = instance_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class DescribeCapacityReservationInstancesResponseBodyCapacityReservationItem(TeaModel):
    def __init__(
        self,
        instance_id_set: List[DescribeCapacityReservationInstancesResponseBodyCapacityReservationItemInstanceIdSet] = None,
    ):
        self.instance_id_set = instance_id_set

    def validate(self):
        if self.instance_id_set:
            for k in self.instance_id_set:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['InstanceIdSet'] = []
        if self.instance_id_set is not None:
            for k in self.instance_id_set:
                result['InstanceIdSet'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.instance_id_set = []
        if m.get('InstanceIdSet') is not None:
            for k in m.get('InstanceIdSet'):
                temp_model = DescribeCapacityReservationInstancesResponseBodyCapacityReservationItemInstanceIdSet()
                self.instance_id_set.append(temp_model.from_map(k))
        return self


class DescribeCapacityReservationInstancesResponseBody(TeaModel):
    def __init__(
        self,
        next_token: str = None,
        request_id: str = None,
        total_count: int = None,
        max_results: int = None,
        capacity_reservation_item: DescribeCapacityReservationInstancesResponseBodyCapacityReservationItem = None,
    ):
        self.next_token = next_token
        self.request_id = request_id
        self.total_count = total_count
        self.max_results = max_results
        self.capacity_reservation_item = capacity_reservation_item

    def validate(self):
        if self.capacity_reservation_item:
            self.capacity_reservation_item.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        if self.max_results is not None:
            result['MaxResults'] = self.max_results
        if self.capacity_reservation_item is not None:
            result['CapacityReservationItem'] = self.capacity_reservation_item.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        if m.get('MaxResults') is not None:
            self.max_results = m.get('MaxResults')
        if m.get('CapacityReservationItem') is not None:
            temp_model = DescribeCapacityReservationInstancesResponseBodyCapacityReservationItem()
            self.capacity_reservation_item = temp_model.from_map(m['CapacityReservationItem'])
        return self


class DescribeCapacityReservationInstancesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeCapacityReservationInstancesResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeCapacityReservationInstancesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeCapacityReservationsRequestPrivatePoolOptions(TeaModel):
    def __init__(
        self,
        ids: str = None,
    ):
        self.ids = ids

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ids is not None:
            result['Ids'] = self.ids
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Ids') is not None:
            self.ids = m.get('Ids')
        return self


class DescribeCapacityReservationsRequestTag(TeaModel):
    def __init__(
        self,
        key: str = None,
        value: str = None,
    ):
        self.key = key
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class DescribeCapacityReservationsRequest(TeaModel):
    def __init__(
        self,
        private_pool_options: DescribeCapacityReservationsRequestPrivatePoolOptions = None,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        owner_account: str = None,
        region_id: str = None,
        resource_group_id: str = None,
        tag: List[DescribeCapacityReservationsRequestTag] = None,
        max_results: int = None,
        next_token: str = None,
        platform: str = None,
        instance_type: str = None,
        zone_id: str = None,
        instance_charge_type: str = None,
        status: str = None,
    ):
        self.private_pool_options = private_pool_options
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.owner_account = owner_account
        self.region_id = region_id
        self.resource_group_id = resource_group_id
        self.tag = tag
        self.max_results = max_results
        self.next_token = next_token
        self.platform = platform
        self.instance_type = instance_type
        self.zone_id = zone_id
        self.instance_charge_type = instance_charge_type
        self.status = status

    def validate(self):
        if self.private_pool_options:
            self.private_pool_options.validate()
        if self.tag:
            for k in self.tag:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.private_pool_options is not None:
            result['PrivatePoolOptions'] = self.private_pool_options.to_map()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        result['Tag'] = []
        if self.tag is not None:
            for k in self.tag:
                result['Tag'].append(k.to_map() if k else None)
        if self.max_results is not None:
            result['MaxResults'] = self.max_results
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.platform is not None:
            result['Platform'] = self.platform
        if self.instance_type is not None:
            result['InstanceType'] = self.instance_type
        if self.zone_id is not None:
            result['ZoneId'] = self.zone_id
        if self.instance_charge_type is not None:
            result['InstanceChargeType'] = self.instance_charge_type
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PrivatePoolOptions') is not None:
            temp_model = DescribeCapacityReservationsRequestPrivatePoolOptions()
            self.private_pool_options = temp_model.from_map(m['PrivatePoolOptions'])
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        self.tag = []
        if m.get('Tag') is not None:
            for k in m.get('Tag'):
                temp_model = DescribeCapacityReservationsRequestTag()
                self.tag.append(temp_model.from_map(k))
        if m.get('MaxResults') is not None:
            self.max_results = m.get('MaxResults')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('Platform') is not None:
            self.platform = m.get('Platform')
        if m.get('InstanceType') is not None:
            self.instance_type = m.get('InstanceType')
        if m.get('ZoneId') is not None:
            self.zone_id = m.get('ZoneId')
        if m.get('InstanceChargeType') is not None:
            self.instance_charge_type = m.get('InstanceChargeType')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class DescribeCapacityReservationsResponseBodyCapacityReservationSetCapacityReservationItemAllocatedResourcesAllocatedResource(TeaModel):
    def __init__(
        self,
        used_amount: int = None,
        total_amount: int = None,
        zone_id: str = None,
        instance_type: str = None,
    ):
        self.used_amount = used_amount
        self.total_amount = total_amount
        self.zone_id = zone_id
        self.instance_type = instance_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.used_amount is not None:
            result['UsedAmount'] = self.used_amount
        if self.total_amount is not None:
            result['TotalAmount'] = self.total_amount
        if self.zone_id is not None:
            result['zoneId'] = self.zone_id
        if self.instance_type is not None:
            result['InstanceType'] = self.instance_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('UsedAmount') is not None:
            self.used_amount = m.get('UsedAmount')
        if m.get('TotalAmount') is not None:
            self.total_amount = m.get('TotalAmount')
        if m.get('zoneId') is not None:
            self.zone_id = m.get('zoneId')
        if m.get('InstanceType') is not None:
            self.instance_type = m.get('InstanceType')
        return self


class DescribeCapacityReservationsResponseBodyCapacityReservationSetCapacityReservationItemAllocatedResources(TeaModel):
    def __init__(
        self,
        allocated_resource: List[DescribeCapacityReservationsResponseBodyCapacityReservationSetCapacityReservationItemAllocatedResourcesAllocatedResource] = None,
    ):
        self.allocated_resource = allocated_resource

    def validate(self):
        if self.allocated_resource:
            for k in self.allocated_resource:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['AllocatedResource'] = []
        if self.allocated_resource is not None:
            for k in self.allocated_resource:
                result['AllocatedResource'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.allocated_resource = []
        if m.get('AllocatedResource') is not None:
            for k in m.get('AllocatedResource'):
                temp_model = DescribeCapacityReservationsResponseBodyCapacityReservationSetCapacityReservationItemAllocatedResourcesAllocatedResource()
                self.allocated_resource.append(temp_model.from_map(k))
        return self


class DescribeCapacityReservationsResponseBodyCapacityReservationSetCapacityReservationItemTagsTag(TeaModel):
    def __init__(
        self,
        tag_value: str = None,
        tag_key: str = None,
    ):
        self.tag_value = tag_value
        self.tag_key = tag_key

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.tag_value is not None:
            result['TagValue'] = self.tag_value
        if self.tag_key is not None:
            result['TagKey'] = self.tag_key
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TagValue') is not None:
            self.tag_value = m.get('TagValue')
        if m.get('TagKey') is not None:
            self.tag_key = m.get('TagKey')
        return self


class DescribeCapacityReservationsResponseBodyCapacityReservationSetCapacityReservationItemTags(TeaModel):
    def __init__(
        self,
        tag: List[DescribeCapacityReservationsResponseBodyCapacityReservationSetCapacityReservationItemTagsTag] = None,
    ):
        self.tag = tag

    def validate(self):
        if self.tag:
            for k in self.tag:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Tag'] = []
        if self.tag is not None:
            for k in self.tag:
                result['Tag'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.tag = []
        if m.get('Tag') is not None:
            for k in m.get('Tag'):
                temp_model = DescribeCapacityReservationsResponseBodyCapacityReservationSetCapacityReservationItemTagsTag()
                self.tag.append(temp_model.from_map(k))
        return self


class DescribeCapacityReservationsResponseBodyCapacityReservationSetCapacityReservationItem(TeaModel):
    def __init__(
        self,
        status: str = None,
        time_slot: str = None,
        private_pool_options_match_criteria: str = None,
        private_pool_options_id: str = None,
        private_pool_options_name: str = None,
        region_id: str = None,
        instance_charge_type: str = None,
        end_time: str = None,
        start_time: str = None,
        description: str = None,
        end_time_type: str = None,
        resource_group_id: str = None,
        platform: str = None,
        allocated_resources: DescribeCapacityReservationsResponseBodyCapacityReservationSetCapacityReservationItemAllocatedResources = None,
        tags: DescribeCapacityReservationsResponseBodyCapacityReservationSetCapacityReservationItemTags = None,
    ):
        self.status = status
        self.time_slot = time_slot
        self.private_pool_options_match_criteria = private_pool_options_match_criteria
        self.private_pool_options_id = private_pool_options_id
        self.private_pool_options_name = private_pool_options_name
        self.region_id = region_id
        self.instance_charge_type = instance_charge_type
        self.end_time = end_time
        self.start_time = start_time
        self.description = description
        self.end_time_type = end_time_type
        self.resource_group_id = resource_group_id
        self.platform = platform
        self.allocated_resources = allocated_resources
        self.tags = tags

    def validate(self):
        if self.allocated_resources:
            self.allocated_resources.validate()
        if self.tags:
            self.tags.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.status is not None:
            result['Status'] = self.status
        if self.time_slot is not None:
            result['TimeSlot'] = self.time_slot
        if self.private_pool_options_match_criteria is not None:
            result['PrivatePoolOptionsMatchCriteria'] = self.private_pool_options_match_criteria
        if self.private_pool_options_id is not None:
            result['PrivatePoolOptionsId'] = self.private_pool_options_id
        if self.private_pool_options_name is not None:
            result['PrivatePoolOptionsName'] = self.private_pool_options_name
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.instance_charge_type is not None:
            result['InstanceChargeType'] = self.instance_charge_type
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.description is not None:
            result['Description'] = self.description
        if self.end_time_type is not None:
            result['EndTimeType'] = self.end_time_type
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.platform is not None:
            result['Platform'] = self.platform
        if self.allocated_resources is not None:
            result['AllocatedResources'] = self.allocated_resources.to_map()
        if self.tags is not None:
            result['Tags'] = self.tags.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('TimeSlot') is not None:
            self.time_slot = m.get('TimeSlot')
        if m.get('PrivatePoolOptionsMatchCriteria') is not None:
            self.private_pool_options_match_criteria = m.get('PrivatePoolOptionsMatchCriteria')
        if m.get('PrivatePoolOptionsId') is not None:
            self.private_pool_options_id = m.get('PrivatePoolOptionsId')
        if m.get('PrivatePoolOptionsName') is not None:
            self.private_pool_options_name = m.get('PrivatePoolOptionsName')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('InstanceChargeType') is not None:
            self.instance_charge_type = m.get('InstanceChargeType')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('EndTimeType') is not None:
            self.end_time_type = m.get('EndTimeType')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        if m.get('Platform') is not None:
            self.platform = m.get('Platform')
        if m.get('AllocatedResources') is not None:
            temp_model = DescribeCapacityReservationsResponseBodyCapacityReservationSetCapacityReservationItemAllocatedResources()
            self.allocated_resources = temp_model.from_map(m['AllocatedResources'])
        if m.get('Tags') is not None:
            temp_model = DescribeCapacityReservationsResponseBodyCapacityReservationSetCapacityReservationItemTags()
            self.tags = temp_model.from_map(m['Tags'])
        return self


class DescribeCapacityReservationsResponseBodyCapacityReservationSet(TeaModel):
    def __init__(
        self,
        capacity_reservation_item: List[DescribeCapacityReservationsResponseBodyCapacityReservationSetCapacityReservationItem] = None,
    ):
        self.capacity_reservation_item = capacity_reservation_item

    def validate(self):
        if self.capacity_reservation_item:
            for k in self.capacity_reservation_item:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['CapacityReservationItem'] = []
        if self.capacity_reservation_item is not None:
            for k in self.capacity_reservation_item:
                result['CapacityReservationItem'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.capacity_reservation_item = []
        if m.get('CapacityReservationItem') is not None:
            for k in m.get('CapacityReservationItem'):
                temp_model = DescribeCapacityReservationsResponseBodyCapacityReservationSetCapacityReservationItem()
                self.capacity_reservation_item.append(temp_model.from_map(k))
        return self


class DescribeCapacityReservationsResponseBody(TeaModel):
    def __init__(
        self,
        next_token: str = None,
        request_id: str = None,
        total_count: int = None,
        max_results: int = None,
        capacity_reservation_set: DescribeCapacityReservationsResponseBodyCapacityReservationSet = None,
    ):
        self.next_token = next_token
        self.request_id = request_id
        self.total_count = total_count
        self.max_results = max_results
        self.capacity_reservation_set = capacity_reservation_set

    def validate(self):
        if self.capacity_reservation_set:
            self.capacity_reservation_set.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        if self.max_results is not None:
            result['MaxResults'] = self.max_results
        if self.capacity_reservation_set is not None:
            result['CapacityReservationSet'] = self.capacity_reservation_set.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        if m.get('MaxResults') is not None:
            self.max_results = m.get('MaxResults')
        if m.get('CapacityReservationSet') is not None:
            temp_model = DescribeCapacityReservationsResponseBodyCapacityReservationSet()
            self.capacity_reservation_set = temp_model.from_map(m['CapacityReservationSet'])
        return self


class DescribeCapacityReservationsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeCapacityReservationsResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeCapacityReservationsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeClassicLinkInstancesRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        region_id: str = None,
        vpc_id: str = None,
        instance_id: str = None,
        page_number: str = None,
        page_size: str = None,
    ):
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.region_id = region_id
        self.vpc_id = vpc_id
        self.instance_id = instance_id
        self.page_number = page_number
        self.page_size = page_size

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.vpc_id is not None:
            result['VpcId'] = self.vpc_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('VpcId') is not None:
            self.vpc_id = m.get('VpcId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        return self


class DescribeClassicLinkInstancesResponseBodyLinksLink(TeaModel):
    def __init__(
        self,
        vpc_id: str = None,
        instance_id: str = None,
    ):
        self.vpc_id = vpc_id
        self.instance_id = instance_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.vpc_id is not None:
            result['VpcId'] = self.vpc_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('VpcId') is not None:
            self.vpc_id = m.get('VpcId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class DescribeClassicLinkInstancesResponseBodyLinks(TeaModel):
    def __init__(
        self,
        link: List[DescribeClassicLinkInstancesResponseBodyLinksLink] = None,
    ):
        self.link = link

    def validate(self):
        if self.link:
            for k in self.link:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Link'] = []
        if self.link is not None:
            for k in self.link:
                result['Link'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.link = []
        if m.get('Link') is not None:
            for k in m.get('Link'):
                temp_model = DescribeClassicLinkInstancesResponseBodyLinksLink()
                self.link.append(temp_model.from_map(k))
        return self


class DescribeClassicLinkInstancesResponseBody(TeaModel):
    def __init__(
        self,
        page_size: int = None,
        request_id: str = None,
        page_number: int = None,
        total_count: int = None,
        links: DescribeClassicLinkInstancesResponseBodyLinks = None,
    ):
        self.page_size = page_size
        self.request_id = request_id
        self.page_number = page_number
        self.total_count = total_count
        self.links = links

    def validate(self):
        if self.links:
            self.links.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        if self.links is not None:
            result['Links'] = self.links.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        if m.get('Links') is not None:
            temp_model = DescribeClassicLinkInstancesResponseBodyLinks()
            self.links = temp_model.from_map(m['Links'])
        return self


class DescribeClassicLinkInstancesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeClassicLinkInstancesResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeClassicLinkInstancesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeCloudAssistantStatusRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        owner_account: str = None,
        region_id: str = None,
        ostype: str = None,
        page_number: int = None,
        page_size: int = None,
        instance_id: List[str] = None,
    ):
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.owner_account = owner_account
        self.region_id = region_id
        self.ostype = ostype
        self.page_number = page_number
        self.page_size = page_size
        self.instance_id = instance_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.ostype is not None:
            result['OSType'] = self.ostype
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('OSType') is not None:
            self.ostype = m.get('OSType')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class DescribeCloudAssistantStatusResponseBodyInstanceCloudAssistantStatusSetInstanceCloudAssistantStatus(TeaModel):
    def __init__(
        self,
        cloud_assistant_status: str = None,
        last_invoked_time: str = None,
        cloud_assistant_version: str = None,
        active_task_count: int = None,
        invocation_count: int = None,
        instance_id: str = None,
        last_heartbeat_time: str = None,
        ostype: str = None,
        support_session_manager: bool = None,
    ):
        self.cloud_assistant_status = cloud_assistant_status
        self.last_invoked_time = last_invoked_time
        self.cloud_assistant_version = cloud_assistant_version
        self.active_task_count = active_task_count
        self.invocation_count = invocation_count
        self.instance_id = instance_id
        self.last_heartbeat_time = last_heartbeat_time
        self.ostype = ostype
        self.support_session_manager = support_session_manager

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cloud_assistant_status is not None:
            result['CloudAssistantStatus'] = self.cloud_assistant_status
        if self.last_invoked_time is not None:
            result['LastInvokedTime'] = self.last_invoked_time
        if self.cloud_assistant_version is not None:
            result['CloudAssistantVersion'] = self.cloud_assistant_version
        if self.active_task_count is not None:
            result['ActiveTaskCount'] = self.active_task_count
        if self.invocation_count is not None:
            result['InvocationCount'] = self.invocation_count
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.last_heartbeat_time is not None:
            result['LastHeartbeatTime'] = self.last_heartbeat_time
        if self.ostype is not None:
            result['OSType'] = self.ostype
        if self.support_session_manager is not None:
            result['SupportSessionManager'] = self.support_session_manager
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CloudAssistantStatus') is not None:
            self.cloud_assistant_status = m.get('CloudAssistantStatus')
        if m.get('LastInvokedTime') is not None:
            self.last_invoked_time = m.get('LastInvokedTime')
        if m.get('CloudAssistantVersion') is not None:
            self.cloud_assistant_version = m.get('CloudAssistantVersion')
        if m.get('ActiveTaskCount') is not None:
            self.active_task_count = m.get('ActiveTaskCount')
        if m.get('InvocationCount') is not None:
            self.invocation_count = m.get('InvocationCount')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('LastHeartbeatTime') is not None:
            self.last_heartbeat_time = m.get('LastHeartbeatTime')
        if m.get('OSType') is not None:
            self.ostype = m.get('OSType')
        if m.get('SupportSessionManager') is not None:
            self.support_session_manager = m.get('SupportSessionManager')
        return self


class DescribeCloudAssistantStatusResponseBodyInstanceCloudAssistantStatusSet(TeaModel):
    def __init__(
        self,
        instance_cloud_assistant_status: List[DescribeCloudAssistantStatusResponseBodyInstanceCloudAssistantStatusSetInstanceCloudAssistantStatus] = None,
    ):
        self.instance_cloud_assistant_status = instance_cloud_assistant_status

    def validate(self):
        if self.instance_cloud_assistant_status:
            for k in self.instance_cloud_assistant_status:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['InstanceCloudAssistantStatus'] = []
        if self.instance_cloud_assistant_status is not None:
            for k in self.instance_cloud_assistant_status:
                result['InstanceCloudAssistantStatus'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.instance_cloud_assistant_status = []
        if m.get('InstanceCloudAssistantStatus') is not None:
            for k in m.get('InstanceCloudAssistantStatus'):
                temp_model = DescribeCloudAssistantStatusResponseBodyInstanceCloudAssistantStatusSetInstanceCloudAssistantStatus()
                self.instance_cloud_assistant_status.append(temp_model.from_map(k))
        return self


class DescribeCloudAssistantStatusResponseBody(TeaModel):
    def __init__(
        self,
        page_size: int = None,
        request_id: str = None,
        page_number: int = None,
        total_count: int = None,
        instance_cloud_assistant_status_set: DescribeCloudAssistantStatusResponseBodyInstanceCloudAssistantStatusSet = None,
    ):
        self.page_size = page_size
        self.request_id = request_id
        self.page_number = page_number
        self.total_count = total_count
        self.instance_cloud_assistant_status_set = instance_cloud_assistant_status_set

    def validate(self):
        if self.instance_cloud_assistant_status_set:
            self.instance_cloud_assistant_status_set.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        if self.instance_cloud_assistant_status_set is not None:
            result['InstanceCloudAssistantStatusSet'] = self.instance_cloud_assistant_status_set.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        if m.get('InstanceCloudAssistantStatusSet') is not None:
            temp_model = DescribeCloudAssistantStatusResponseBodyInstanceCloudAssistantStatusSet()
            self.instance_cloud_assistant_status_set = temp_model.from_map(m['InstanceCloudAssistantStatusSet'])
        return self


class DescribeCloudAssistantStatusResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeCloudAssistantStatusResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeCloudAssistantStatusResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeClustersRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        region_id: str = None,
        owner_account: str = None,
    ):
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.region_id = region_id
        self.owner_account = owner_account

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        return self


class DescribeClustersResponseBodyClustersCluster(TeaModel):
    def __init__(
        self,
        cluster_id: str = None,
    ):
        self.cluster_id = cluster_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        return self


class DescribeClustersResponseBodyClusters(TeaModel):
    def __init__(
        self,
        cluster: List[DescribeClustersResponseBodyClustersCluster] = None,
    ):
        self.cluster = cluster

    def validate(self):
        if self.cluster:
            for k in self.cluster:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Cluster'] = []
        if self.cluster is not None:
            for k in self.cluster:
                result['Cluster'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.cluster = []
        if m.get('Cluster') is not None:
            for k in m.get('Cluster'):
                temp_model = DescribeClustersResponseBodyClustersCluster()
                self.cluster.append(temp_model.from_map(k))
        return self


class DescribeClustersResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        clusters: DescribeClustersResponseBodyClusters = None,
    ):
        self.request_id = request_id
        self.clusters = clusters

    def validate(self):
        if self.clusters:
            self.clusters.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.clusters is not None:
            result['Clusters'] = self.clusters.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Clusters') is not None:
            temp_model = DescribeClustersResponseBodyClusters()
            self.clusters = temp_model.from_map(m['Clusters'])
        return self


class DescribeClustersResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeClustersResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeClustersResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeCommandsRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        owner_account: str = None,
        region_id: str = None,
        provider: str = None,
        command_id: str = None,
        name: str = None,
        description: str = None,
        type: str = None,
        content_encoding: str = None,
        page_number: int = None,
        page_size: int = None,
    ):
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.owner_account = owner_account
        self.region_id = region_id
        self.provider = provider
        self.command_id = command_id
        self.name = name
        self.description = description
        self.type = type
        self.content_encoding = content_encoding
        self.page_number = page_number
        self.page_size = page_size

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.provider is not None:
            result['Provider'] = self.provider
        if self.command_id is not None:
            result['CommandId'] = self.command_id
        if self.name is not None:
            result['Name'] = self.name
        if self.description is not None:
            result['Description'] = self.description
        if self.type is not None:
            result['Type'] = self.type
        if self.content_encoding is not None:
            result['ContentEncoding'] = self.content_encoding
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('Provider') is not None:
            self.provider = m.get('Provider')
        if m.get('CommandId') is not None:
            self.command_id = m.get('CommandId')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('ContentEncoding') is not None:
            self.content_encoding = m.get('ContentEncoding')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        return self


class DescribeCommandsResponseBodyCommandsCommandParameterNames(TeaModel):
    def __init__(
        self,
        parameter_name: List[str] = None,
    ):
        self.parameter_name = parameter_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.parameter_name is not None:
            result['ParameterName'] = self.parameter_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ParameterName') is not None:
            self.parameter_name = m.get('ParameterName')
        return self


class DescribeCommandsResponseBodyCommandsCommand(TeaModel):
    def __init__(
        self,
        creation_time: str = None,
        type: str = None,
        timeout: int = None,
        invoke_times: int = None,
        command_id: str = None,
        working_dir: str = None,
        description: str = None,
        version: int = None,
        provider: str = None,
        command_content: str = None,
        category: str = None,
        latest: bool = None,
        name: str = None,
        enable_parameter: bool = None,
        parameter_names: DescribeCommandsResponseBodyCommandsCommandParameterNames = None,
    ):
        self.creation_time = creation_time
        self.type = type
        self.timeout = timeout
        self.invoke_times = invoke_times
        self.command_id = command_id
        self.working_dir = working_dir
        self.description = description
        self.version = version
        self.provider = provider
        self.command_content = command_content
        self.category = category
        self.latest = latest
        self.name = name
        self.enable_parameter = enable_parameter
        self.parameter_names = parameter_names

    def validate(self):
        if self.parameter_names:
            self.parameter_names.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.creation_time is not None:
            result['CreationTime'] = self.creation_time
        if self.type is not None:
            result['Type'] = self.type
        if self.timeout is not None:
            result['Timeout'] = self.timeout
        if self.invoke_times is not None:
            result['InvokeTimes'] = self.invoke_times
        if self.command_id is not None:
            result['CommandId'] = self.command_id
        if self.working_dir is not None:
            result['WorkingDir'] = self.working_dir
        if self.description is not None:
            result['Description'] = self.description
        if self.version is not None:
            result['Version'] = self.version
        if self.provider is not None:
            result['Provider'] = self.provider
        if self.command_content is not None:
            result['CommandContent'] = self.command_content
        if self.category is not None:
            result['Category'] = self.category
        if self.latest is not None:
            result['Latest'] = self.latest
        if self.name is not None:
            result['Name'] = self.name
        if self.enable_parameter is not None:
            result['EnableParameter'] = self.enable_parameter
        if self.parameter_names is not None:
            result['ParameterNames'] = self.parameter_names.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CreationTime') is not None:
            self.creation_time = m.get('CreationTime')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('Timeout') is not None:
            self.timeout = m.get('Timeout')
        if m.get('InvokeTimes') is not None:
            self.invoke_times = m.get('InvokeTimes')
        if m.get('CommandId') is not None:
            self.command_id = m.get('CommandId')
        if m.get('WorkingDir') is not None:
            self.working_dir = m.get('WorkingDir')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('Version') is not None:
            self.version = m.get('Version')
        if m.get('Provider') is not None:
            self.provider = m.get('Provider')
        if m.get('CommandContent') is not None:
            self.command_content = m.get('CommandContent')
        if m.get('Category') is not None:
            self.category = m.get('Category')
        if m.get('Latest') is not None:
            self.latest = m.get('Latest')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('EnableParameter') is not None:
            self.enable_parameter = m.get('EnableParameter')
        if m.get('ParameterNames') is not None:
            temp_model = DescribeCommandsResponseBodyCommandsCommandParameterNames()
            self.parameter_names = temp_model.from_map(m['ParameterNames'])
        return self


class DescribeCommandsResponseBodyCommands(TeaModel):
    def __init__(
        self,
        command: List[DescribeCommandsResponseBodyCommandsCommand] = None,
    ):
        self.command = command

    def validate(self):
        if self.command:
            for k in self.command:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Command'] = []
        if self.command is not None:
            for k in self.command:
                result['Command'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.command = []
        if m.get('Command') is not None:
            for k in m.get('Command'):
                temp_model = DescribeCommandsResponseBodyCommandsCommand()
                self.command.append(temp_model.from_map(k))
        return self


class DescribeCommandsResponseBody(TeaModel):
    def __init__(
        self,
        page_size: int = None,
        request_id: str = None,
        page_number: int = None,
        total_count: int = None,
        commands: DescribeCommandsResponseBodyCommands = None,
    ):
        self.page_size = page_size
        self.request_id = request_id
        self.page_number = page_number
        self.total_count = total_count
        self.commands = commands

    def validate(self):
        if self.commands:
            self.commands.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        if self.commands is not None:
            result['Commands'] = self.commands.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        if m.get('Commands') is not None:
            temp_model = DescribeCommandsResponseBodyCommands()
            self.commands = temp_model.from_map(m['Commands'])
        return self


class DescribeCommandsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeCommandsResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeCommandsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDedicatedBlockStorageClustersRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        owner_account: str = None,
        region_id: str = None,
        dedicated_block_storage_cluster_id: List[str] = None,
        status: List[str] = None,
        zone_id: str = None,
        category: str = None,
        next_token: str = None,
        max_results: int = None,
    ):
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.owner_account = owner_account
        self.region_id = region_id
        self.dedicated_block_storage_cluster_id = dedicated_block_storage_cluster_id
        self.status = status
        self.zone_id = zone_id
        self.category = category
        self.next_token = next_token
        self.max_results = max_results

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.dedicated_block_storage_cluster_id is not None:
            result['DedicatedBlockStorageClusterId'] = self.dedicated_block_storage_cluster_id
        if self.status is not None:
            result['Status'] = self.status
        if self.zone_id is not None:
            result['ZoneId'] = self.zone_id
        if self.category is not None:
            result['Category'] = self.category
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.max_results is not None:
            result['MaxResults'] = self.max_results
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('DedicatedBlockStorageClusterId') is not None:
            self.dedicated_block_storage_cluster_id = m.get('DedicatedBlockStorageClusterId')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('ZoneId') is not None:
            self.zone_id = m.get('ZoneId')
        if m.get('Category') is not None:
            self.category = m.get('Category')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('MaxResults') is not None:
            self.max_results = m.get('MaxResults')
        return self


class DescribeDedicatedBlockStorageClustersResponseBodyDedicatedBlockStorageClustersDedicatedBlockStorageClusterDedicatedBlockStorageClusterCapacity(TeaModel):
    def __init__(
        self,
        total_capacity: int = None,
        available_capacity: int = None,
    ):
        self.total_capacity = total_capacity
        self.available_capacity = available_capacity

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.total_capacity is not None:
            result['TotalCapacity'] = self.total_capacity
        if self.available_capacity is not None:
            result['AvailableCapacity'] = self.available_capacity
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TotalCapacity') is not None:
            self.total_capacity = m.get('TotalCapacity')
        if m.get('AvailableCapacity') is not None:
            self.available_capacity = m.get('AvailableCapacity')
        return self


class DescribeDedicatedBlockStorageClustersResponseBodyDedicatedBlockStorageClustersDedicatedBlockStorageCluster(TeaModel):
    def __init__(
        self,
        status: str = None,
        performance_level: str = None,
        description: str = None,
        expired_time: str = None,
        create_time: str = None,
        zone_id: str = None,
        category: str = None,
        dedicated_block_storage_cluster_name: str = None,
        dedicated_block_storage_cluster_id: str = None,
        dedicated_block_storage_cluster_capacity: DescribeDedicatedBlockStorageClustersResponseBodyDedicatedBlockStorageClustersDedicatedBlockStorageClusterDedicatedBlockStorageClusterCapacity = None,
    ):
        self.status = status
        self.performance_level = performance_level
        self.description = description
        self.expired_time = expired_time
        self.create_time = create_time
        self.zone_id = zone_id
        self.category = category
        self.dedicated_block_storage_cluster_name = dedicated_block_storage_cluster_name
        self.dedicated_block_storage_cluster_id = dedicated_block_storage_cluster_id
        self.dedicated_block_storage_cluster_capacity = dedicated_block_storage_cluster_capacity

    def validate(self):
        if self.dedicated_block_storage_cluster_capacity:
            self.dedicated_block_storage_cluster_capacity.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.status is not None:
            result['Status'] = self.status
        if self.performance_level is not None:
            result['PerformanceLevel'] = self.performance_level
        if self.description is not None:
            result['Description'] = self.description
        if self.expired_time is not None:
            result['ExpiredTime'] = self.expired_time
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.zone_id is not None:
            result['ZoneId'] = self.zone_id
        if self.category is not None:
            result['Category'] = self.category
        if self.dedicated_block_storage_cluster_name is not None:
            result['DedicatedBlockStorageClusterName'] = self.dedicated_block_storage_cluster_name
        if self.dedicated_block_storage_cluster_id is not None:
            result['DedicatedBlockStorageClusterId'] = self.dedicated_block_storage_cluster_id
        if self.dedicated_block_storage_cluster_capacity is not None:
            result['DedicatedBlockStorageClusterCapacity'] = self.dedicated_block_storage_cluster_capacity.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('PerformanceLevel') is not None:
            self.performance_level = m.get('PerformanceLevel')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('ExpiredTime') is not None:
            self.expired_time = m.get('ExpiredTime')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('ZoneId') is not None:
            self.zone_id = m.get('ZoneId')
        if m.get('Category') is not None:
            self.category = m.get('Category')
        if m.get('DedicatedBlockStorageClusterName') is not None:
            self.dedicated_block_storage_cluster_name = m.get('DedicatedBlockStorageClusterName')
        if m.get('DedicatedBlockStorageClusterId') is not None:
            self.dedicated_block_storage_cluster_id = m.get('DedicatedBlockStorageClusterId')
        if m.get('DedicatedBlockStorageClusterCapacity') is not None:
            temp_model = DescribeDedicatedBlockStorageClustersResponseBodyDedicatedBlockStorageClustersDedicatedBlockStorageClusterDedicatedBlockStorageClusterCapacity()
            self.dedicated_block_storage_cluster_capacity = temp_model.from_map(m['DedicatedBlockStorageClusterCapacity'])
        return self


class DescribeDedicatedBlockStorageClustersResponseBodyDedicatedBlockStorageClusters(TeaModel):
    def __init__(
        self,
        dedicated_block_storage_cluster: List[DescribeDedicatedBlockStorageClustersResponseBodyDedicatedBlockStorageClustersDedicatedBlockStorageCluster] = None,
    ):
        self.dedicated_block_storage_cluster = dedicated_block_storage_cluster

    def validate(self):
        if self.dedicated_block_storage_cluster:
            for k in self.dedicated_block_storage_cluster:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['DedicatedBlockStorageCluster'] = []
        if self.dedicated_block_storage_cluster is not None:
            for k in self.dedicated_block_storage_cluster:
                result['DedicatedBlockStorageCluster'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.dedicated_block_storage_cluster = []
        if m.get('DedicatedBlockStorageCluster') is not None:
            for k in m.get('DedicatedBlockStorageCluster'):
                temp_model = DescribeDedicatedBlockStorageClustersResponseBodyDedicatedBlockStorageClustersDedicatedBlockStorageCluster()
                self.dedicated_block_storage_cluster.append(temp_model.from_map(k))
        return self


class DescribeDedicatedBlockStorageClustersResponseBody(TeaModel):
    def __init__(
        self,
        next_token: str = None,
        request_id: str = None,
        dedicated_block_storage_clusters: DescribeDedicatedBlockStorageClustersResponseBodyDedicatedBlockStorageClusters = None,
    ):
        self.next_token = next_token
        self.request_id = request_id
        self.dedicated_block_storage_clusters = dedicated_block_storage_clusters

    def validate(self):
        if self.dedicated_block_storage_clusters:
            self.dedicated_block_storage_clusters.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.dedicated_block_storage_clusters is not None:
            result['DedicatedBlockStorageClusters'] = self.dedicated_block_storage_clusters.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('DedicatedBlockStorageClusters') is not None:
            temp_model = DescribeDedicatedBlockStorageClustersResponseBodyDedicatedBlockStorageClusters()
            self.dedicated_block_storage_clusters = temp_model.from_map(m['DedicatedBlockStorageClusters'])
        return self


class DescribeDedicatedBlockStorageClustersResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeDedicatedBlockStorageClustersResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeDedicatedBlockStorageClustersResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDedicatedHostAutoRenewRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        owner_account: str = None,
        dedicated_host_ids: str = None,
        region_id: str = None,
    ):
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.owner_account = owner_account
        self.dedicated_host_ids = dedicated_host_ids
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.dedicated_host_ids is not None:
            result['DedicatedHostIds'] = self.dedicated_host_ids
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('DedicatedHostIds') is not None:
            self.dedicated_host_ids = m.get('DedicatedHostIds')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DescribeDedicatedHostAutoRenewResponseBodyDedicatedHostRenewAttributesDedicatedHostRenewAttribute(TeaModel):
    def __init__(
        self,
        period_unit: str = None,
        duration: int = None,
        dedicated_host_id: str = None,
        renewal_status: str = None,
        auto_renew_enabled: bool = None,
    ):
        self.period_unit = period_unit
        self.duration = duration
        self.dedicated_host_id = dedicated_host_id
        self.renewal_status = renewal_status
        self.auto_renew_enabled = auto_renew_enabled

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.period_unit is not None:
            result['PeriodUnit'] = self.period_unit
        if self.duration is not None:
            result['Duration'] = self.duration
        if self.dedicated_host_id is not None:
            result['DedicatedHostId'] = self.dedicated_host_id
        if self.renewal_status is not None:
            result['RenewalStatus'] = self.renewal_status
        if self.auto_renew_enabled is not None:
            result['AutoRenewEnabled'] = self.auto_renew_enabled
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PeriodUnit') is not None:
            self.period_unit = m.get('PeriodUnit')
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        if m.get('DedicatedHostId') is not None:
            self.dedicated_host_id = m.get('DedicatedHostId')
        if m.get('RenewalStatus') is not None:
            self.renewal_status = m.get('RenewalStatus')
        if m.get('AutoRenewEnabled') is not None:
            self.auto_renew_enabled = m.get('AutoRenewEnabled')
        return self


class DescribeDedicatedHostAutoRenewResponseBodyDedicatedHostRenewAttributes(TeaModel):
    def __init__(
        self,
        dedicated_host_renew_attribute: List[DescribeDedicatedHostAutoRenewResponseBodyDedicatedHostRenewAttributesDedicatedHostRenewAttribute] = None,
    ):
        self.dedicated_host_renew_attribute = dedicated_host_renew_attribute

    def validate(self):
        if self.dedicated_host_renew_attribute:
            for k in self.dedicated_host_renew_attribute:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['DedicatedHostRenewAttribute'] = []
        if self.dedicated_host_renew_attribute is not None:
            for k in self.dedicated_host_renew_attribute:
                result['DedicatedHostRenewAttribute'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.dedicated_host_renew_attribute = []
        if m.get('DedicatedHostRenewAttribute') is not None:
            for k in m.get('DedicatedHostRenewAttribute'):
                temp_model = DescribeDedicatedHostAutoRenewResponseBodyDedicatedHostRenewAttributesDedicatedHostRenewAttribute()
                self.dedicated_host_renew_attribute.append(temp_model.from_map(k))
        return self


class DescribeDedicatedHostAutoRenewResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        dedicated_host_renew_attributes: DescribeDedicatedHostAutoRenewResponseBodyDedicatedHostRenewAttributes = None,
    ):
        self.request_id = request_id
        self.dedicated_host_renew_attributes = dedicated_host_renew_attributes

    def validate(self):
        if self.dedicated_host_renew_attributes:
            self.dedicated_host_renew_attributes.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.dedicated_host_renew_attributes is not None:
            result['DedicatedHostRenewAttributes'] = self.dedicated_host_renew_attributes.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('DedicatedHostRenewAttributes') is not None:
            temp_model = DescribeDedicatedHostAutoRenewResponseBodyDedicatedHostRenewAttributes()
            self.dedicated_host_renew_attributes = temp_model.from_map(m['DedicatedHostRenewAttributes'])
        return self


class DescribeDedicatedHostAutoRenewResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeDedicatedHostAutoRenewResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeDedicatedHostAutoRenewResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDedicatedHostClustersRequestTag(TeaModel):
    def __init__(
        self,
        key: str = None,
        value: str = None,
    ):
        self.key = key
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class DescribeDedicatedHostClustersRequest(TeaModel):
    def __init__(
        self,
        tag: List[DescribeDedicatedHostClustersRequestTag] = None,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        status: str = None,
        lock_reason: str = None,
        owner_account: str = None,
        resource_group_id: str = None,
        region_id: str = None,
        zone_id: str = None,
        dedicated_host_cluster_ids: str = None,
        dedicated_host_cluster_name: str = None,
        page_number: int = None,
        page_size: int = None,
    ):
        self.tag = tag
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.status = status
        self.lock_reason = lock_reason
        self.owner_account = owner_account
        self.resource_group_id = resource_group_id
        self.region_id = region_id
        self.zone_id = zone_id
        self.dedicated_host_cluster_ids = dedicated_host_cluster_ids
        self.dedicated_host_cluster_name = dedicated_host_cluster_name
        self.page_number = page_number
        self.page_size = page_size

    def validate(self):
        if self.tag:
            for k in self.tag:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Tag'] = []
        if self.tag is not None:
            for k in self.tag:
                result['Tag'].append(k.to_map() if k else None)
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.status is not None:
            result['Status'] = self.status
        if self.lock_reason is not None:
            result['LockReason'] = self.lock_reason
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.zone_id is not None:
            result['ZoneId'] = self.zone_id
        if self.dedicated_host_cluster_ids is not None:
            result['DedicatedHostClusterIds'] = self.dedicated_host_cluster_ids
        if self.dedicated_host_cluster_name is not None:
            result['DedicatedHostClusterName'] = self.dedicated_host_cluster_name
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.tag = []
        if m.get('Tag') is not None:
            for k in m.get('Tag'):
                temp_model = DescribeDedicatedHostClustersRequestTag()
                self.tag.append(temp_model.from_map(k))
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('LockReason') is not None:
            self.lock_reason = m.get('LockReason')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ZoneId') is not None:
            self.zone_id = m.get('ZoneId')
        if m.get('DedicatedHostClusterIds') is not None:
            self.dedicated_host_cluster_ids = m.get('DedicatedHostClusterIds')
        if m.get('DedicatedHostClusterName') is not None:
            self.dedicated_host_cluster_name = m.get('DedicatedHostClusterName')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        return self


class DescribeDedicatedHostClustersResponseBodyDedicatedHostClustersDedicatedHostClusterTagsTag(TeaModel):
    def __init__(
        self,
        tag_value: str = None,
        tag_key: str = None,
    ):
        self.tag_value = tag_value
        self.tag_key = tag_key

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.tag_value is not None:
            result['TagValue'] = self.tag_value
        if self.tag_key is not None:
            result['TagKey'] = self.tag_key
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TagValue') is not None:
            self.tag_value = m.get('TagValue')
        if m.get('TagKey') is not None:
            self.tag_key = m.get('TagKey')
        return self


class DescribeDedicatedHostClustersResponseBodyDedicatedHostClustersDedicatedHostClusterTags(TeaModel):
    def __init__(
        self,
        tag: List[DescribeDedicatedHostClustersResponseBodyDedicatedHostClustersDedicatedHostClusterTagsTag] = None,
    ):
        self.tag = tag

    def validate(self):
        if self.tag:
            for k in self.tag:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Tag'] = []
        if self.tag is not None:
            for k in self.tag:
                result['Tag'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.tag = []
        if m.get('Tag') is not None:
            for k in m.get('Tag'):
                temp_model = DescribeDedicatedHostClustersResponseBodyDedicatedHostClustersDedicatedHostClusterTagsTag()
                self.tag.append(temp_model.from_map(k))
        return self


class DescribeDedicatedHostClustersResponseBodyDedicatedHostClustersDedicatedHostClusterDedicatedHostIds(TeaModel):
    def __init__(
        self,
        dedicated_host_id: List[str] = None,
    ):
        self.dedicated_host_id = dedicated_host_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dedicated_host_id is not None:
            result['DedicatedHostId'] = self.dedicated_host_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DedicatedHostId') is not None:
            self.dedicated_host_id = m.get('DedicatedHostId')
        return self


class DescribeDedicatedHostClustersResponseBodyDedicatedHostClustersDedicatedHostClusterDedicatedHostClusterCapacityLocalStorageCapacitiesLocalStorageCapacity(TeaModel):
    def __init__(
        self,
        data_disk_category: str = None,
        available_disk: int = None,
        total_disk: int = None,
    ):
        self.data_disk_category = data_disk_category
        self.available_disk = available_disk
        self.total_disk = total_disk

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data_disk_category is not None:
            result['DataDiskCategory'] = self.data_disk_category
        if self.available_disk is not None:
            result['AvailableDisk'] = self.available_disk
        if self.total_disk is not None:
            result['TotalDisk'] = self.total_disk
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DataDiskCategory') is not None:
            self.data_disk_category = m.get('DataDiskCategory')
        if m.get('AvailableDisk') is not None:
            self.available_disk = m.get('AvailableDisk')
        if m.get('TotalDisk') is not None:
            self.total_disk = m.get('TotalDisk')
        return self


class DescribeDedicatedHostClustersResponseBodyDedicatedHostClustersDedicatedHostClusterDedicatedHostClusterCapacityLocalStorageCapacities(TeaModel):
    def __init__(
        self,
        local_storage_capacity: List[DescribeDedicatedHostClustersResponseBodyDedicatedHostClustersDedicatedHostClusterDedicatedHostClusterCapacityLocalStorageCapacitiesLocalStorageCapacity] = None,
    ):
        self.local_storage_capacity = local_storage_capacity

    def validate(self):
        if self.local_storage_capacity:
            for k in self.local_storage_capacity:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['LocalStorageCapacity'] = []
        if self.local_storage_capacity is not None:
            for k in self.local_storage_capacity:
                result['LocalStorageCapacity'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.local_storage_capacity = []
        if m.get('LocalStorageCapacity') is not None:
            for k in m.get('LocalStorageCapacity'):
                temp_model = DescribeDedicatedHostClustersResponseBodyDedicatedHostClustersDedicatedHostClusterDedicatedHostClusterCapacityLocalStorageCapacitiesLocalStorageCapacity()
                self.local_storage_capacity.append(temp_model.from_map(k))
        return self


class DescribeDedicatedHostClustersResponseBodyDedicatedHostClustersDedicatedHostClusterDedicatedHostClusterCapacityAvailableInstanceTypesAvailableInstanceType(TeaModel):
    def __init__(
        self,
        instance_type: str = None,
        available_instance_capacity: int = None,
    ):
        self.instance_type = instance_type
        self.available_instance_capacity = available_instance_capacity

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_type is not None:
            result['InstanceType'] = self.instance_type
        if self.available_instance_capacity is not None:
            result['AvailableInstanceCapacity'] = self.available_instance_capacity
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceType') is not None:
            self.instance_type = m.get('InstanceType')
        if m.get('AvailableInstanceCapacity') is not None:
            self.available_instance_capacity = m.get('AvailableInstanceCapacity')
        return self


class DescribeDedicatedHostClustersResponseBodyDedicatedHostClustersDedicatedHostClusterDedicatedHostClusterCapacityAvailableInstanceTypes(TeaModel):
    def __init__(
        self,
        available_instance_type: List[DescribeDedicatedHostClustersResponseBodyDedicatedHostClustersDedicatedHostClusterDedicatedHostClusterCapacityAvailableInstanceTypesAvailableInstanceType] = None,
    ):
        self.available_instance_type = available_instance_type

    def validate(self):
        if self.available_instance_type:
            for k in self.available_instance_type:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['AvailableInstanceType'] = []
        if self.available_instance_type is not None:
            for k in self.available_instance_type:
                result['AvailableInstanceType'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.available_instance_type = []
        if m.get('AvailableInstanceType') is not None:
            for k in m.get('AvailableInstanceType'):
                temp_model = DescribeDedicatedHostClustersResponseBodyDedicatedHostClustersDedicatedHostClusterDedicatedHostClusterCapacityAvailableInstanceTypesAvailableInstanceType()
                self.available_instance_type.append(temp_model.from_map(k))
        return self


class DescribeDedicatedHostClustersResponseBodyDedicatedHostClustersDedicatedHostClusterDedicatedHostClusterCapacity(TeaModel):
    def __init__(
        self,
        available_vcpus: int = None,
        available_memory: int = None,
        total_memory: int = None,
        total_vcpus: int = None,
        local_storage_capacities: DescribeDedicatedHostClustersResponseBodyDedicatedHostClustersDedicatedHostClusterDedicatedHostClusterCapacityLocalStorageCapacities = None,
        available_instance_types: DescribeDedicatedHostClustersResponseBodyDedicatedHostClustersDedicatedHostClusterDedicatedHostClusterCapacityAvailableInstanceTypes = None,
    ):
        self.available_vcpus = available_vcpus
        self.available_memory = available_memory
        self.total_memory = total_memory
        self.total_vcpus = total_vcpus
        self.local_storage_capacities = local_storage_capacities
        self.available_instance_types = available_instance_types

    def validate(self):
        if self.local_storage_capacities:
            self.local_storage_capacities.validate()
        if self.available_instance_types:
            self.available_instance_types.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.available_vcpus is not None:
            result['AvailableVcpus'] = self.available_vcpus
        if self.available_memory is not None:
            result['AvailableMemory'] = self.available_memory
        if self.total_memory is not None:
            result['TotalMemory'] = self.total_memory
        if self.total_vcpus is not None:
            result['TotalVcpus'] = self.total_vcpus
        if self.local_storage_capacities is not None:
            result['LocalStorageCapacities'] = self.local_storage_capacities.to_map()
        if self.available_instance_types is not None:
            result['AvailableInstanceTypes'] = self.available_instance_types.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AvailableVcpus') is not None:
            self.available_vcpus = m.get('AvailableVcpus')
        if m.get('AvailableMemory') is not None:
            self.available_memory = m.get('AvailableMemory')
        if m.get('TotalMemory') is not None:
            self.total_memory = m.get('TotalMemory')
        if m.get('TotalVcpus') is not None:
            self.total_vcpus = m.get('TotalVcpus')
        if m.get('LocalStorageCapacities') is not None:
            temp_model = DescribeDedicatedHostClustersResponseBodyDedicatedHostClustersDedicatedHostClusterDedicatedHostClusterCapacityLocalStorageCapacities()
            self.local_storage_capacities = temp_model.from_map(m['LocalStorageCapacities'])
        if m.get('AvailableInstanceTypes') is not None:
            temp_model = DescribeDedicatedHostClustersResponseBodyDedicatedHostClustersDedicatedHostClusterDedicatedHostClusterCapacityAvailableInstanceTypes()
            self.available_instance_types = temp_model.from_map(m['AvailableInstanceTypes'])
        return self


class DescribeDedicatedHostClustersResponseBodyDedicatedHostClustersDedicatedHostCluster(TeaModel):
    def __init__(
        self,
        description: str = None,
        dedicated_host_cluster_id: str = None,
        resource_group_id: str = None,
        zone_id: str = None,
        region_id: str = None,
        dedicated_host_cluster_name: str = None,
        tags: DescribeDedicatedHostClustersResponseBodyDedicatedHostClustersDedicatedHostClusterTags = None,
        dedicated_host_ids: DescribeDedicatedHostClustersResponseBodyDedicatedHostClustersDedicatedHostClusterDedicatedHostIds = None,
        dedicated_host_cluster_capacity: DescribeDedicatedHostClustersResponseBodyDedicatedHostClustersDedicatedHostClusterDedicatedHostClusterCapacity = None,
    ):
        self.description = description
        self.dedicated_host_cluster_id = dedicated_host_cluster_id
        self.resource_group_id = resource_group_id
        self.zone_id = zone_id
        self.region_id = region_id
        self.dedicated_host_cluster_name = dedicated_host_cluster_name
        self.tags = tags
        self.dedicated_host_ids = dedicated_host_ids
        self.dedicated_host_cluster_capacity = dedicated_host_cluster_capacity

    def validate(self):
        if self.tags:
            self.tags.validate()
        if self.dedicated_host_ids:
            self.dedicated_host_ids.validate()
        if self.dedicated_host_cluster_capacity:
            self.dedicated_host_cluster_capacity.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.description is not None:
            result['Description'] = self.description
        if self.dedicated_host_cluster_id is not None:
            result['DedicatedHostClusterId'] = self.dedicated_host_cluster_id
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.zone_id is not None:
            result['ZoneId'] = self.zone_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.dedicated_host_cluster_name is not None:
            result['DedicatedHostClusterName'] = self.dedicated_host_cluster_name
        if self.tags is not None:
            result['Tags'] = self.tags.to_map()
        if self.dedicated_host_ids is not None:
            result['DedicatedHostIds'] = self.dedicated_host_ids.to_map()
        if self.dedicated_host_cluster_capacity is not None:
            result['DedicatedHostClusterCapacity'] = self.dedicated_host_cluster_capacity.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('DedicatedHostClusterId') is not None:
            self.dedicated_host_cluster_id = m.get('DedicatedHostClusterId')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        if m.get('ZoneId') is not None:
            self.zone_id = m.get('ZoneId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('DedicatedHostClusterName') is not None:
            self.dedicated_host_cluster_name = m.get('DedicatedHostClusterName')
        if m.get('Tags') is not None:
            temp_model = DescribeDedicatedHostClustersResponseBodyDedicatedHostClustersDedicatedHostClusterTags()
            self.tags = temp_model.from_map(m['Tags'])
        if m.get('DedicatedHostIds') is not None:
            temp_model = DescribeDedicatedHostClustersResponseBodyDedicatedHostClustersDedicatedHostClusterDedicatedHostIds()
            self.dedicated_host_ids = temp_model.from_map(m['DedicatedHostIds'])
        if m.get('DedicatedHostClusterCapacity') is not None:
            temp_model = DescribeDedicatedHostClustersResponseBodyDedicatedHostClustersDedicatedHostClusterDedicatedHostClusterCapacity()
            self.dedicated_host_cluster_capacity = temp_model.from_map(m['DedicatedHostClusterCapacity'])
        return self


class DescribeDedicatedHostClustersResponseBodyDedicatedHostClusters(TeaModel):
    def __init__(
        self,
        dedicated_host_cluster: List[DescribeDedicatedHostClustersResponseBodyDedicatedHostClustersDedicatedHostCluster] = None,
    ):
        self.dedicated_host_cluster = dedicated_host_cluster

    def validate(self):
        if self.dedicated_host_cluster:
            for k in self.dedicated_host_cluster:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['DedicatedHostCluster'] = []
        if self.dedicated_host_cluster is not None:
            for k in self.dedicated_host_cluster:
                result['DedicatedHostCluster'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.dedicated_host_cluster = []
        if m.get('DedicatedHostCluster') is not None:
            for k in m.get('DedicatedHostCluster'):
                temp_model = DescribeDedicatedHostClustersResponseBodyDedicatedHostClustersDedicatedHostCluster()
                self.dedicated_host_cluster.append(temp_model.from_map(k))
        return self


class DescribeDedicatedHostClustersResponseBody(TeaModel):
    def __init__(
        self,
        page_size: int = None,
        request_id: str = None,
        page_number: int = None,
        total_count: int = None,
        dedicated_host_clusters: DescribeDedicatedHostClustersResponseBodyDedicatedHostClusters = None,
    ):
        self.page_size = page_size
        self.request_id = request_id
        self.page_number = page_number
        self.total_count = total_count
        self.dedicated_host_clusters = dedicated_host_clusters

    def validate(self):
        if self.dedicated_host_clusters:
            self.dedicated_host_clusters.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        if self.dedicated_host_clusters is not None:
            result['DedicatedHostClusters'] = self.dedicated_host_clusters.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        if m.get('DedicatedHostClusters') is not None:
            temp_model = DescribeDedicatedHostClustersResponseBodyDedicatedHostClusters()
            self.dedicated_host_clusters = temp_model.from_map(m['DedicatedHostClusters'])
        return self


class DescribeDedicatedHostClustersResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeDedicatedHostClustersResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeDedicatedHostClustersResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDedicatedHostsRequestTag(TeaModel):
    def __init__(
        self,
        key: str = None,
        value: str = None,
    ):
        self.key = key
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class DescribeDedicatedHostsRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        region_id: str = None,
        zone_id: str = None,
        dedicated_host_ids: str = None,
        dedicated_host_name: str = None,
        status: str = None,
        dedicated_host_type: str = None,
        lock_reason: str = None,
        page_number: int = None,
        page_size: int = None,
        owner_account: str = None,
        resource_group_id: str = None,
        tag: List[DescribeDedicatedHostsRequestTag] = None,
        dedicated_host_cluster_id: str = None,
    ):
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.region_id = region_id
        self.zone_id = zone_id
        self.dedicated_host_ids = dedicated_host_ids
        self.dedicated_host_name = dedicated_host_name
        self.status = status
        self.dedicated_host_type = dedicated_host_type
        self.lock_reason = lock_reason
        self.page_number = page_number
        self.page_size = page_size
        self.owner_account = owner_account
        self.resource_group_id = resource_group_id
        self.tag = tag
        self.dedicated_host_cluster_id = dedicated_host_cluster_id

    def validate(self):
        if self.tag:
            for k in self.tag:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.zone_id is not None:
            result['ZoneId'] = self.zone_id
        if self.dedicated_host_ids is not None:
            result['DedicatedHostIds'] = self.dedicated_host_ids
        if self.dedicated_host_name is not None:
            result['DedicatedHostName'] = self.dedicated_host_name
        if self.status is not None:
            result['Status'] = self.status
        if self.dedicated_host_type is not None:
            result['DedicatedHostType'] = self.dedicated_host_type
        if self.lock_reason is not None:
            result['LockReason'] = self.lock_reason
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        result['Tag'] = []
        if self.tag is not None:
            for k in self.tag:
                result['Tag'].append(k.to_map() if k else None)
        if self.dedicated_host_cluster_id is not None:
            result['DedicatedHostClusterId'] = self.dedicated_host_cluster_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ZoneId') is not None:
            self.zone_id = m.get('ZoneId')
        if m.get('DedicatedHostIds') is not None:
            self.dedicated_host_ids = m.get('DedicatedHostIds')
        if m.get('DedicatedHostName') is not None:
            self.dedicated_host_name = m.get('DedicatedHostName')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('DedicatedHostType') is not None:
            self.dedicated_host_type = m.get('DedicatedHostType')
        if m.get('LockReason') is not None:
            self.lock_reason = m.get('LockReason')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        self.tag = []
        if m.get('Tag') is not None:
            for k in m.get('Tag'):
                temp_model = DescribeDedicatedHostsRequestTag()
                self.tag.append(temp_model.from_map(k))
        if m.get('DedicatedHostClusterId') is not None:
            self.dedicated_host_cluster_id = m.get('DedicatedHostClusterId')
        return self


class DescribeDedicatedHostsResponseBodyDedicatedHostsDedicatedHostInstancesInstance(TeaModel):
    def __init__(
        self,
        instance_type: str = None,
        instance_id: str = None,
    ):
        self.instance_type = instance_type
        self.instance_id = instance_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_type is not None:
            result['InstanceType'] = self.instance_type
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceType') is not None:
            self.instance_type = m.get('InstanceType')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class DescribeDedicatedHostsResponseBodyDedicatedHostsDedicatedHostInstances(TeaModel):
    def __init__(
        self,
        instance: List[DescribeDedicatedHostsResponseBodyDedicatedHostsDedicatedHostInstancesInstance] = None,
    ):
        self.instance = instance

    def validate(self):
        if self.instance:
            for k in self.instance:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Instance'] = []
        if self.instance is not None:
            for k in self.instance:
                result['Instance'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.instance = []
        if m.get('Instance') is not None:
            for k in m.get('Instance'):
                temp_model = DescribeDedicatedHostsResponseBodyDedicatedHostsDedicatedHostInstancesInstance()
                self.instance.append(temp_model.from_map(k))
        return self


class DescribeDedicatedHostsResponseBodyDedicatedHostsDedicatedHostOperationLocksOperationLock(TeaModel):
    def __init__(
        self,
        lock_reason: str = None,
    ):
        self.lock_reason = lock_reason

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.lock_reason is not None:
            result['LockReason'] = self.lock_reason
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('LockReason') is not None:
            self.lock_reason = m.get('LockReason')
        return self


class DescribeDedicatedHostsResponseBodyDedicatedHostsDedicatedHostOperationLocks(TeaModel):
    def __init__(
        self,
        operation_lock: List[DescribeDedicatedHostsResponseBodyDedicatedHostsDedicatedHostOperationLocksOperationLock] = None,
    ):
        self.operation_lock = operation_lock

    def validate(self):
        if self.operation_lock:
            for k in self.operation_lock:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['OperationLock'] = []
        if self.operation_lock is not None:
            for k in self.operation_lock:
                result['OperationLock'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.operation_lock = []
        if m.get('OperationLock') is not None:
            for k in m.get('OperationLock'):
                temp_model = DescribeDedicatedHostsResponseBodyDedicatedHostsDedicatedHostOperationLocksOperationLock()
                self.operation_lock.append(temp_model.from_map(k))
        return self


class DescribeDedicatedHostsResponseBodyDedicatedHostsDedicatedHostTagsTag(TeaModel):
    def __init__(
        self,
        tag_value: str = None,
        tag_key: str = None,
    ):
        self.tag_value = tag_value
        self.tag_key = tag_key

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.tag_value is not None:
            result['TagValue'] = self.tag_value
        if self.tag_key is not None:
            result['TagKey'] = self.tag_key
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TagValue') is not None:
            self.tag_value = m.get('TagValue')
        if m.get('TagKey') is not None:
            self.tag_key = m.get('TagKey')
        return self


class DescribeDedicatedHostsResponseBodyDedicatedHostsDedicatedHostTags(TeaModel):
    def __init__(
        self,
        tag: List[DescribeDedicatedHostsResponseBodyDedicatedHostsDedicatedHostTagsTag] = None,
    ):
        self.tag = tag

    def validate(self):
        if self.tag:
            for k in self.tag:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Tag'] = []
        if self.tag is not None:
            for k in self.tag:
                result['Tag'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.tag = []
        if m.get('Tag') is not None:
            for k in m.get('Tag'):
                temp_model = DescribeDedicatedHostsResponseBodyDedicatedHostsDedicatedHostTagsTag()
                self.tag.append(temp_model.from_map(k))
        return self


class DescribeDedicatedHostsResponseBodyDedicatedHostsDedicatedHostSupportedInstanceTypeFamilies(TeaModel):
    def __init__(
        self,
        supported_instance_type_family: List[str] = None,
    ):
        self.supported_instance_type_family = supported_instance_type_family

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.supported_instance_type_family is not None:
            result['SupportedInstanceTypeFamily'] = self.supported_instance_type_family
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('SupportedInstanceTypeFamily') is not None:
            self.supported_instance_type_family = m.get('SupportedInstanceTypeFamily')
        return self


class DescribeDedicatedHostsResponseBodyDedicatedHostsDedicatedHostSupportedCustomInstanceTypeFamilies(TeaModel):
    def __init__(
        self,
        supported_custom_instance_type_family: List[str] = None,
    ):
        self.supported_custom_instance_type_family = supported_custom_instance_type_family

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.supported_custom_instance_type_family is not None:
            result['SupportedCustomInstanceTypeFamily'] = self.supported_custom_instance_type_family
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('SupportedCustomInstanceTypeFamily') is not None:
            self.supported_custom_instance_type_family = m.get('SupportedCustomInstanceTypeFamily')
        return self


class DescribeDedicatedHostsResponseBodyDedicatedHostsDedicatedHostSupportedInstanceTypesList(TeaModel):
    def __init__(
        self,
        supported_instance_types_list: List[str] = None,
    ):
        self.supported_instance_types_list = supported_instance_types_list

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.supported_instance_types_list is not None:
            result['SupportedInstanceTypesList'] = self.supported_instance_types_list
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('SupportedInstanceTypesList') is not None:
            self.supported_instance_types_list = m.get('SupportedInstanceTypesList')
        return self


class DescribeDedicatedHostsResponseBodyDedicatedHostsDedicatedHostCapacity(TeaModel):
    def __init__(
        self,
        available_memory: float = None,
        local_storage_category: str = None,
        total_memory: float = None,
        total_local_storage: int = None,
        total_vcpus: int = None,
        total_vgpus: int = None,
        available_local_storage: int = None,
        available_vcpus: int = None,
        available_vgpus: int = None,
    ):
        self.available_memory = available_memory
        self.local_storage_category = local_storage_category
        self.total_memory = total_memory
        self.total_local_storage = total_local_storage
        self.total_vcpus = total_vcpus
        self.total_vgpus = total_vgpus
        self.available_local_storage = available_local_storage
        self.available_vcpus = available_vcpus
        self.available_vgpus = available_vgpus

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.available_memory is not None:
            result['AvailableMemory'] = self.available_memory
        if self.local_storage_category is not None:
            result['LocalStorageCategory'] = self.local_storage_category
        if self.total_memory is not None:
            result['TotalMemory'] = self.total_memory
        if self.total_local_storage is not None:
            result['TotalLocalStorage'] = self.total_local_storage
        if self.total_vcpus is not None:
            result['TotalVcpus'] = self.total_vcpus
        if self.total_vgpus is not None:
            result['TotalVgpus'] = self.total_vgpus
        if self.available_local_storage is not None:
            result['AvailableLocalStorage'] = self.available_local_storage
        if self.available_vcpus is not None:
            result['AvailableVcpus'] = self.available_vcpus
        if self.available_vgpus is not None:
            result['AvailableVgpus'] = self.available_vgpus
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AvailableMemory') is not None:
            self.available_memory = m.get('AvailableMemory')
        if m.get('LocalStorageCategory') is not None:
            self.local_storage_category = m.get('LocalStorageCategory')
        if m.get('TotalMemory') is not None:
            self.total_memory = m.get('TotalMemory')
        if m.get('TotalLocalStorage') is not None:
            self.total_local_storage = m.get('TotalLocalStorage')
        if m.get('TotalVcpus') is not None:
            self.total_vcpus = m.get('TotalVcpus')
        if m.get('TotalVgpus') is not None:
            self.total_vgpus = m.get('TotalVgpus')
        if m.get('AvailableLocalStorage') is not None:
            self.available_local_storage = m.get('AvailableLocalStorage')
        if m.get('AvailableVcpus') is not None:
            self.available_vcpus = m.get('AvailableVcpus')
        if m.get('AvailableVgpus') is not None:
            self.available_vgpus = m.get('AvailableVgpus')
        return self


class DescribeDedicatedHostsResponseBodyDedicatedHostsDedicatedHostNetworkAttributes(TeaModel):
    def __init__(
        self,
        udp_timeout: int = None,
        slb_udp_timeout: int = None,
    ):
        self.udp_timeout = udp_timeout
        self.slb_udp_timeout = slb_udp_timeout

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.udp_timeout is not None:
            result['UdpTimeout'] = self.udp_timeout
        if self.slb_udp_timeout is not None:
            result['SlbUdpTimeout'] = self.slb_udp_timeout
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('UdpTimeout') is not None:
            self.udp_timeout = m.get('UdpTimeout')
        if m.get('SlbUdpTimeout') is not None:
            self.slb_udp_timeout = m.get('SlbUdpTimeout')
        return self


class DescribeDedicatedHostsResponseBodyDedicatedHostsDedicatedHostHostDetailInfo(TeaModel):
    def __init__(
        self,
        serial_number: str = None,
    ):
        self.serial_number = serial_number

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.serial_number is not None:
            result['SerialNumber'] = self.serial_number
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('SerialNumber') is not None:
            self.serial_number = m.get('SerialNumber')
        return self


class DescribeDedicatedHostsResponseBodyDedicatedHostsDedicatedHost(TeaModel):
    def __init__(
        self,
        creation_time: str = None,
        status: str = None,
        cores: int = None,
        auto_placement: str = None,
        gpuspec: str = None,
        auto_release_time: str = None,
        charge_type: str = None,
        cpu_over_commit_ratio: float = None,
        action_on_maintenance: str = None,
        sale_cycle: str = None,
        physical_gpus: int = None,
        region_id: str = None,
        dedicated_host_name: str = None,
        description: str = None,
        dedicated_host_cluster_id: str = None,
        expired_time: str = None,
        dedicated_host_type: str = None,
        resource_group_id: str = None,
        zone_id: str = None,
        dedicated_host_id: str = None,
        sockets: int = None,
        machine_id: str = None,
        instances: DescribeDedicatedHostsResponseBodyDedicatedHostsDedicatedHostInstances = None,
        operation_locks: DescribeDedicatedHostsResponseBodyDedicatedHostsDedicatedHostOperationLocks = None,
        tags: DescribeDedicatedHostsResponseBodyDedicatedHostsDedicatedHostTags = None,
        supported_instance_type_families: DescribeDedicatedHostsResponseBodyDedicatedHostsDedicatedHostSupportedInstanceTypeFamilies = None,
        supported_custom_instance_type_families: DescribeDedicatedHostsResponseBodyDedicatedHostsDedicatedHostSupportedCustomInstanceTypeFamilies = None,
        supported_instance_types_list: DescribeDedicatedHostsResponseBodyDedicatedHostsDedicatedHostSupportedInstanceTypesList = None,
        capacity: DescribeDedicatedHostsResponseBodyDedicatedHostsDedicatedHostCapacity = None,
        network_attributes: DescribeDedicatedHostsResponseBodyDedicatedHostsDedicatedHostNetworkAttributes = None,
        host_detail_info: DescribeDedicatedHostsResponseBodyDedicatedHostsDedicatedHostHostDetailInfo = None,
    ):
        self.creation_time = creation_time
        self.status = status
        self.cores = cores
        self.auto_placement = auto_placement
        self.gpuspec = gpuspec
        self.auto_release_time = auto_release_time
        self.charge_type = charge_type
        self.cpu_over_commit_ratio = cpu_over_commit_ratio
        self.action_on_maintenance = action_on_maintenance
        self.sale_cycle = sale_cycle
        self.physical_gpus = physical_gpus
        self.region_id = region_id
        self.dedicated_host_name = dedicated_host_name
        self.description = description
        self.dedicated_host_cluster_id = dedicated_host_cluster_id
        self.expired_time = expired_time
        self.dedicated_host_type = dedicated_host_type
        self.resource_group_id = resource_group_id
        self.zone_id = zone_id
        self.dedicated_host_id = dedicated_host_id
        self.sockets = sockets
        self.machine_id = machine_id
        self.instances = instances
        self.operation_locks = operation_locks
        self.tags = tags
        self.supported_instance_type_families = supported_instance_type_families
        self.supported_custom_instance_type_families = supported_custom_instance_type_families
        self.supported_instance_types_list = supported_instance_types_list
        self.capacity = capacity
        self.network_attributes = network_attributes
        self.host_detail_info = host_detail_info

    def validate(self):
        if self.instances:
            self.instances.validate()
        if self.operation_locks:
            self.operation_locks.validate()
        if self.tags:
            self.tags.validate()
        if self.supported_instance_type_families:
            self.supported_instance_type_families.validate()
        if self.supported_custom_instance_type_families:
            self.supported_custom_instance_type_families.validate()
        if self.supported_instance_types_list:
            self.supported_instance_types_list.validate()
        if self.capacity:
            self.capacity.validate()
        if self.network_attributes:
            self.network_attributes.validate()
        if self.host_detail_info:
            self.host_detail_info.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.creation_time is not None:
            result['CreationTime'] = self.creation_time
        if self.status is not None:
            result['Status'] = self.status
        if self.cores is not None:
            result['Cores'] = self.cores
        if self.auto_placement is not None:
            result['AutoPlacement'] = self.auto_placement
        if self.gpuspec is not None:
            result['GPUSpec'] = self.gpuspec
        if self.auto_release_time is not None:
            result['AutoReleaseTime'] = self.auto_release_time
        if self.charge_type is not None:
            result['ChargeType'] = self.charge_type
        if self.cpu_over_commit_ratio is not None:
            result['CpuOverCommitRatio'] = self.cpu_over_commit_ratio
        if self.action_on_maintenance is not None:
            result['ActionOnMaintenance'] = self.action_on_maintenance
        if self.sale_cycle is not None:
            result['SaleCycle'] = self.sale_cycle
        if self.physical_gpus is not None:
            result['PhysicalGpus'] = self.physical_gpus
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.dedicated_host_name is not None:
            result['DedicatedHostName'] = self.dedicated_host_name
        if self.description is not None:
            result['Description'] = self.description
        if self.dedicated_host_cluster_id is not None:
            result['DedicatedHostClusterId'] = self.dedicated_host_cluster_id
        if self.expired_time is not None:
            result['ExpiredTime'] = self.expired_time
        if self.dedicated_host_type is not None:
            result['DedicatedHostType'] = self.dedicated_host_type
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.zone_id is not None:
            result['ZoneId'] = self.zone_id
        if self.dedicated_host_id is not None:
            result['DedicatedHostId'] = self.dedicated_host_id
        if self.sockets is not None:
            result['Sockets'] = self.sockets
        if self.machine_id is not None:
            result['MachineId'] = self.machine_id
        if self.instances is not None:
            result['Instances'] = self.instances.to_map()
        if self.operation_locks is not None:
            result['OperationLocks'] = self.operation_locks.to_map()
        if self.tags is not None:
            result['Tags'] = self.tags.to_map()
        if self.supported_instance_type_families is not None:
            result['SupportedInstanceTypeFamilies'] = self.supported_instance_type_families.to_map()
        if self.supported_custom_instance_type_families is not None:
            result['SupportedCustomInstanceTypeFamilies'] = self.supported_custom_instance_type_families.to_map()
        if self.supported_instance_types_list is not None:
            result['SupportedInstanceTypesList'] = self.supported_instance_types_list.to_map()
        if self.capacity is not None:
            result['Capacity'] = self.capacity.to_map()
        if self.network_attributes is not None:
            result['NetworkAttributes'] = self.network_attributes.to_map()
        if self.host_detail_info is not None:
            result['HostDetailInfo'] = self.host_detail_info.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CreationTime') is not None:
            self.creation_time = m.get('CreationTime')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Cores') is not None:
            self.cores = m.get('Cores')
        if m.get('AutoPlacement') is not None:
            self.auto_placement = m.get('AutoPlacement')
        if m.get('GPUSpec') is not None:
            self.gpuspec = m.get('GPUSpec')
        if m.get('AutoReleaseTime') is not None:
            self.auto_release_time = m.get('AutoReleaseTime')
        if m.get('ChargeType') is not None:
            self.charge_type = m.get('ChargeType')
        if m.get('CpuOverCommitRatio') is not None:
            self.cpu_over_commit_ratio = m.get('CpuOverCommitRatio')
        if m.get('ActionOnMaintenance') is not None:
            self.action_on_maintenance = m.get('ActionOnMaintenance')
        if m.get('SaleCycle') is not None:
            self.sale_cycle = m.get('SaleCycle')
        if m.get('PhysicalGpus') is not None:
            self.physical_gpus = m.get('PhysicalGpus')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('DedicatedHostName') is not None:
            self.dedicated_host_name = m.get('DedicatedHostName')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('DedicatedHostClusterId') is not None:
            self.dedicated_host_cluster_id = m.get('DedicatedHostClusterId')
        if m.get('ExpiredTime') is not None:
            self.expired_time = m.get('ExpiredTime')
        if m.get('DedicatedHostType') is not None:
            self.dedicated_host_type = m.get('DedicatedHostType')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        if m.get('ZoneId') is not None:
            self.zone_id = m.get('ZoneId')
        if m.get('DedicatedHostId') is not None:
            self.dedicated_host_id = m.get('DedicatedHostId')
        if m.get('Sockets') is not None:
            self.sockets = m.get('Sockets')
        if m.get('MachineId') is not None:
            self.machine_id = m.get('MachineId')
        if m.get('Instances') is not None:
            temp_model = DescribeDedicatedHostsResponseBodyDedicatedHostsDedicatedHostInstances()
            self.instances = temp_model.from_map(m['Instances'])
        if m.get('OperationLocks') is not None:
            temp_model = DescribeDedicatedHostsResponseBodyDedicatedHostsDedicatedHostOperationLocks()
            self.operation_locks = temp_model.from_map(m['OperationLocks'])
        if m.get('Tags') is not None:
            temp_model = DescribeDedicatedHostsResponseBodyDedicatedHostsDedicatedHostTags()
            self.tags = temp_model.from_map(m['Tags'])
        if m.get('SupportedInstanceTypeFamilies') is not None:
            temp_model = DescribeDedicatedHostsResponseBodyDedicatedHostsDedicatedHostSupportedInstanceTypeFamilies()
            self.supported_instance_type_families = temp_model.from_map(m['SupportedInstanceTypeFamilies'])
        if m.get('SupportedCustomInstanceTypeFamilies') is not None:
            temp_model = DescribeDedicatedHostsResponseBodyDedicatedHostsDedicatedHostSupportedCustomInstanceTypeFamilies()
            self.supported_custom_instance_type_families = temp_model.from_map(m['SupportedCustomInstanceTypeFamilies'])
        if m.get('SupportedInstanceTypesList') is not None:
            temp_model = DescribeDedicatedHostsResponseBodyDedicatedHostsDedicatedHostSupportedInstanceTypesList()
            self.supported_instance_types_list = temp_model.from_map(m['SupportedInstanceTypesList'])
        if m.get('Capacity') is not None:
            temp_model = DescribeDedicatedHostsResponseBodyDedicatedHostsDedicatedHostCapacity()
            self.capacity = temp_model.from_map(m['Capacity'])
        if m.get('NetworkAttributes') is not None:
            temp_model = DescribeDedicatedHostsResponseBodyDedicatedHostsDedicatedHostNetworkAttributes()
            self.network_attributes = temp_model.from_map(m['NetworkAttributes'])
        if m.get('HostDetailInfo') is not None:
            temp_model = DescribeDedicatedHostsResponseBodyDedicatedHostsDedicatedHostHostDetailInfo()
            self.host_detail_info = temp_model.from_map(m['HostDetailInfo'])
        return self


class DescribeDedicatedHostsResponseBodyDedicatedHosts(TeaModel):
    def __init__(
        self,
        dedicated_host: List[DescribeDedicatedHostsResponseBodyDedicatedHostsDedicatedHost] = None,
    ):
        self.dedicated_host = dedicated_host

    def validate(self):
        if self.dedicated_host:
            for k in self.dedicated_host:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['DedicatedHost'] = []
        if self.dedicated_host is not None:
            for k in self.dedicated_host:
                result['DedicatedHost'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.dedicated_host = []
        if m.get('DedicatedHost') is not None:
            for k in m.get('DedicatedHost'):
                temp_model = DescribeDedicatedHostsResponseBodyDedicatedHostsDedicatedHost()
                self.dedicated_host.append(temp_model.from_map(k))
        return self


class DescribeDedicatedHostsResponseBody(TeaModel):
    def __init__(
        self,
        page_size: int = None,
        request_id: str = None,
        page_number: int = None,
        total_count: int = None,
        dedicated_hosts: DescribeDedicatedHostsResponseBodyDedicatedHosts = None,
    ):
        self.page_size = page_size
        self.request_id = request_id
        self.page_number = page_number
        self.total_count = total_count
        self.dedicated_hosts = dedicated_hosts

    def validate(self):
        if self.dedicated_hosts:
            self.dedicated_hosts.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        if self.dedicated_hosts is not None:
            result['DedicatedHosts'] = self.dedicated_hosts.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        if m.get('DedicatedHosts') is not None:
            temp_model = DescribeDedicatedHostsResponseBodyDedicatedHosts()
            self.dedicated_hosts = temp_model.from_map(m['DedicatedHosts'])
        return self


class DescribeDedicatedHostsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeDedicatedHostsResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeDedicatedHostsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDedicatedHostTypesRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        owner_account: str = None,
        region_id: str = None,
        dedicated_host_type: str = None,
        supported_instance_type_family: str = None,
    ):
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.owner_account = owner_account
        self.region_id = region_id
        self.dedicated_host_type = dedicated_host_type
        self.supported_instance_type_family = supported_instance_type_family

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.dedicated_host_type is not None:
            result['DedicatedHostType'] = self.dedicated_host_type
        if self.supported_instance_type_family is not None:
            result['SupportedInstanceTypeFamily'] = self.supported_instance_type_family
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('DedicatedHostType') is not None:
            self.dedicated_host_type = m.get('DedicatedHostType')
        if m.get('SupportedInstanceTypeFamily') is not None:
            self.supported_instance_type_family = m.get('SupportedInstanceTypeFamily')
        return self


class DescribeDedicatedHostTypesResponseBodyDedicatedHostTypesDedicatedHostTypeSupportedInstanceTypeFamilies(TeaModel):
    def __init__(
        self,
        supported_instance_type_family: List[str] = None,
    ):
        self.supported_instance_type_family = supported_instance_type_family

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.supported_instance_type_family is not None:
            result['SupportedInstanceTypeFamily'] = self.supported_instance_type_family
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('SupportedInstanceTypeFamily') is not None:
            self.supported_instance_type_family = m.get('SupportedInstanceTypeFamily')
        return self


class DescribeDedicatedHostTypesResponseBodyDedicatedHostTypesDedicatedHostTypeSupportedInstanceTypesList(TeaModel):
    def __init__(
        self,
        supported_instance_types_list: List[str] = None,
    ):
        self.supported_instance_types_list = supported_instance_types_list

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.supported_instance_types_list is not None:
            result['SupportedInstanceTypesList'] = self.supported_instance_types_list
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('SupportedInstanceTypesList') is not None:
            self.supported_instance_types_list = m.get('SupportedInstanceTypesList')
        return self


class DescribeDedicatedHostTypesResponseBodyDedicatedHostTypesDedicatedHostType(TeaModel):
    def __init__(
        self,
        cores: int = None,
        local_storage_category: str = None,
        gpuspec: str = None,
        total_vcpus: int = None,
        cpu_over_commit_ratio_range: str = None,
        physical_gpus: int = None,
        memory_size: float = None,
        support_cpu_over_commit_ratio: bool = None,
        local_storage_capacity: int = None,
        dedicated_host_type: str = None,
        local_storage_amount: int = None,
        total_vgpus: int = None,
        sockets: int = None,
        supported_instance_type_families: DescribeDedicatedHostTypesResponseBodyDedicatedHostTypesDedicatedHostTypeSupportedInstanceTypeFamilies = None,
        supported_instance_types_list: DescribeDedicatedHostTypesResponseBodyDedicatedHostTypesDedicatedHostTypeSupportedInstanceTypesList = None,
    ):
        self.cores = cores
        self.local_storage_category = local_storage_category
        self.gpuspec = gpuspec
        self.total_vcpus = total_vcpus
        self.cpu_over_commit_ratio_range = cpu_over_commit_ratio_range
        self.physical_gpus = physical_gpus
        self.memory_size = memory_size
        self.support_cpu_over_commit_ratio = support_cpu_over_commit_ratio
        self.local_storage_capacity = local_storage_capacity
        self.dedicated_host_type = dedicated_host_type
        self.local_storage_amount = local_storage_amount
        self.total_vgpus = total_vgpus
        self.sockets = sockets
        self.supported_instance_type_families = supported_instance_type_families
        self.supported_instance_types_list = supported_instance_types_list

    def validate(self):
        if self.supported_instance_type_families:
            self.supported_instance_type_families.validate()
        if self.supported_instance_types_list:
            self.supported_instance_types_list.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cores is not None:
            result['Cores'] = self.cores
        if self.local_storage_category is not None:
            result['LocalStorageCategory'] = self.local_storage_category
        if self.gpuspec is not None:
            result['GPUSpec'] = self.gpuspec
        if self.total_vcpus is not None:
            result['TotalVcpus'] = self.total_vcpus
        if self.cpu_over_commit_ratio_range is not None:
            result['CpuOverCommitRatioRange'] = self.cpu_over_commit_ratio_range
        if self.physical_gpus is not None:
            result['PhysicalGpus'] = self.physical_gpus
        if self.memory_size is not None:
            result['MemorySize'] = self.memory_size
        if self.support_cpu_over_commit_ratio is not None:
            result['SupportCpuOverCommitRatio'] = self.support_cpu_over_commit_ratio
        if self.local_storage_capacity is not None:
            result['LocalStorageCapacity'] = self.local_storage_capacity
        if self.dedicated_host_type is not None:
            result['DedicatedHostType'] = self.dedicated_host_type
        if self.local_storage_amount is not None:
            result['LocalStorageAmount'] = self.local_storage_amount
        if self.total_vgpus is not None:
            result['TotalVgpus'] = self.total_vgpus
        if self.sockets is not None:
            result['Sockets'] = self.sockets
        if self.supported_instance_type_families is not None:
            result['SupportedInstanceTypeFamilies'] = self.supported_instance_type_families.to_map()
        if self.supported_instance_types_list is not None:
            result['SupportedInstanceTypesList'] = self.supported_instance_types_list.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Cores') is not None:
            self.cores = m.get('Cores')
        if m.get('LocalStorageCategory') is not None:
            self.local_storage_category = m.get('LocalStorageCategory')
        if m.get('GPUSpec') is not None:
            self.gpuspec = m.get('GPUSpec')
        if m.get('TotalVcpus') is not None:
            self.total_vcpus = m.get('TotalVcpus')
        if m.get('CpuOverCommitRatioRange') is not None:
            self.cpu_over_commit_ratio_range = m.get('CpuOverCommitRatioRange')
        if m.get('PhysicalGpus') is not None:
            self.physical_gpus = m.get('PhysicalGpus')
        if m.get('MemorySize') is not None:
            self.memory_size = m.get('MemorySize')
        if m.get('SupportCpuOverCommitRatio') is not None:
            self.support_cpu_over_commit_ratio = m.get('SupportCpuOverCommitRatio')
        if m.get('LocalStorageCapacity') is not None:
            self.local_storage_capacity = m.get('LocalStorageCapacity')
        if m.get('DedicatedHostType') is not None:
            self.dedicated_host_type = m.get('DedicatedHostType')
        if m.get('LocalStorageAmount') is not None:
            self.local_storage_amount = m.get('LocalStorageAmount')
        if m.get('TotalVgpus') is not None:
            self.total_vgpus = m.get('TotalVgpus')
        if m.get('Sockets') is not None:
            self.sockets = m.get('Sockets')
        if m.get('SupportedInstanceTypeFamilies') is not None:
            temp_model = DescribeDedicatedHostTypesResponseBodyDedicatedHostTypesDedicatedHostTypeSupportedInstanceTypeFamilies()
            self.supported_instance_type_families = temp_model.from_map(m['SupportedInstanceTypeFamilies'])
        if m.get('SupportedInstanceTypesList') is not None:
            temp_model = DescribeDedicatedHostTypesResponseBodyDedicatedHostTypesDedicatedHostTypeSupportedInstanceTypesList()
            self.supported_instance_types_list = temp_model.from_map(m['SupportedInstanceTypesList'])
        return self


class DescribeDedicatedHostTypesResponseBodyDedicatedHostTypes(TeaModel):
    def __init__(
        self,
        dedicated_host_type: List[DescribeDedicatedHostTypesResponseBodyDedicatedHostTypesDedicatedHostType] = None,
    ):
        self.dedicated_host_type = dedicated_host_type

    def validate(self):
        if self.dedicated_host_type:
            for k in self.dedicated_host_type:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['DedicatedHostType'] = []
        if self.dedicated_host_type is not None:
            for k in self.dedicated_host_type:
                result['DedicatedHostType'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.dedicated_host_type = []
        if m.get('DedicatedHostType') is not None:
            for k in m.get('DedicatedHostType'):
                temp_model = DescribeDedicatedHostTypesResponseBodyDedicatedHostTypesDedicatedHostType()
                self.dedicated_host_type.append(temp_model.from_map(k))
        return self


class DescribeDedicatedHostTypesResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        dedicated_host_types: DescribeDedicatedHostTypesResponseBodyDedicatedHostTypes = None,
    ):
        self.request_id = request_id
        self.dedicated_host_types = dedicated_host_types

    def validate(self):
        if self.dedicated_host_types:
            self.dedicated_host_types.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.dedicated_host_types is not None:
            result['DedicatedHostTypes'] = self.dedicated_host_types.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('DedicatedHostTypes') is not None:
            temp_model = DescribeDedicatedHostTypesResponseBodyDedicatedHostTypes()
            self.dedicated_host_types = temp_model.from_map(m['DedicatedHostTypes'])
        return self


class DescribeDedicatedHostTypesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeDedicatedHostTypesResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeDedicatedHostTypesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDemandsRequestTag(TeaModel):
    def __init__(
        self,
        key: str = None,
        value: str = None,
    ):
        self.key = key
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class DescribeDemandsRequest(TeaModel):
    def __init__(
        self,
        tag: List[DescribeDemandsRequestTag] = None,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        owner_account: str = None,
        region_id: str = None,
        page_number: int = None,
        page_size: int = None,
        dry_run: bool = None,
        demand_status: List[str] = None,
        zone_id: str = None,
        demand_id: str = None,
        instance_type_family: str = None,
        instance_type: str = None,
        instance_charge_type: str = None,
        demand_type: str = None,
    ):
        self.tag = tag
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.owner_account = owner_account
        self.region_id = region_id
        self.page_number = page_number
        self.page_size = page_size
        self.dry_run = dry_run
        self.demand_status = demand_status
        self.zone_id = zone_id
        self.demand_id = demand_id
        self.instance_type_family = instance_type_family
        self.instance_type = instance_type
        self.instance_charge_type = instance_charge_type
        self.demand_type = demand_type

    def validate(self):
        if self.tag:
            for k in self.tag:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Tag'] = []
        if self.tag is not None:
            for k in self.tag:
                result['Tag'].append(k.to_map() if k else None)
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.dry_run is not None:
            result['DryRun'] = self.dry_run
        if self.demand_status is not None:
            result['DemandStatus'] = self.demand_status
        if self.zone_id is not None:
            result['ZoneId'] = self.zone_id
        if self.demand_id is not None:
            result['DemandId'] = self.demand_id
        if self.instance_type_family is not None:
            result['InstanceTypeFamily'] = self.instance_type_family
        if self.instance_type is not None:
            result['InstanceType'] = self.instance_type
        if self.instance_charge_type is not None:
            result['InstanceChargeType'] = self.instance_charge_type
        if self.demand_type is not None:
            result['DemandType'] = self.demand_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.tag = []
        if m.get('Tag') is not None:
            for k in m.get('Tag'):
                temp_model = DescribeDemandsRequestTag()
                self.tag.append(temp_model.from_map(k))
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('DryRun') is not None:
            self.dry_run = m.get('DryRun')
        if m.get('DemandStatus') is not None:
            self.demand_status = m.get('DemandStatus')
        if m.get('ZoneId') is not None:
            self.zone_id = m.get('ZoneId')
        if m.get('DemandId') is not None:
            self.demand_id = m.get('DemandId')
        if m.get('InstanceTypeFamily') is not None:
            self.instance_type_family = m.get('InstanceTypeFamily')
        if m.get('InstanceType') is not None:
            self.instance_type = m.get('InstanceType')
        if m.get('InstanceChargeType') is not None:
            self.instance_charge_type = m.get('InstanceChargeType')
        if m.get('DemandType') is not None:
            self.demand_type = m.get('DemandType')
        return self


class DescribeDemandsResponseBodyDemandsDemandSupplyInfosSupplyInfo(TeaModel):
    def __init__(
        self,
        amount: int = None,
        supply_status: str = None,
        supply_start_time: str = None,
        supply_end_time: str = None,
    ):
        self.amount = amount
        self.supply_status = supply_status
        self.supply_start_time = supply_start_time
        self.supply_end_time = supply_end_time

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.amount is not None:
            result['Amount'] = self.amount
        if self.supply_status is not None:
            result['SupplyStatus'] = self.supply_status
        if self.supply_start_time is not None:
            result['SupplyStartTime'] = self.supply_start_time
        if self.supply_end_time is not None:
            result['SupplyEndTime'] = self.supply_end_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Amount') is not None:
            self.amount = m.get('Amount')
        if m.get('SupplyStatus') is not None:
            self.supply_status = m.get('SupplyStatus')
        if m.get('SupplyStartTime') is not None:
            self.supply_start_time = m.get('SupplyStartTime')
        if m.get('SupplyEndTime') is not None:
            self.supply_end_time = m.get('SupplyEndTime')
        return self


class DescribeDemandsResponseBodyDemandsDemandSupplyInfos(TeaModel):
    def __init__(
        self,
        supply_info: List[DescribeDemandsResponseBodyDemandsDemandSupplyInfosSupplyInfo] = None,
    ):
        self.supply_info = supply_info

    def validate(self):
        if self.supply_info:
            for k in self.supply_info:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['SupplyInfo'] = []
        if self.supply_info is not None:
            for k in self.supply_info:
                result['SupplyInfo'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.supply_info = []
        if m.get('SupplyInfo') is not None:
            for k in m.get('SupplyInfo'):
                temp_model = DescribeDemandsResponseBodyDemandsDemandSupplyInfosSupplyInfo()
                self.supply_info.append(temp_model.from_map(k))
        return self


class DescribeDemandsResponseBodyDemandsDemand(TeaModel):
    def __init__(
        self,
        comment: str = None,
        demand_description: str = None,
        demand_id: str = None,
        demand_time: str = None,
        instance_type: str = None,
        demand_name: str = None,
        period: int = None,
        instance_charge_type: str = None,
        available_amount: int = None,
        end_time: str = None,
        start_time: str = None,
        period_unit: str = None,
        zone_id: str = None,
        used_amount: int = None,
        total_amount: int = None,
        delivering_amount: int = None,
        instance_type_family: str = None,
        demand_status: str = None,
        supply_infos: DescribeDemandsResponseBodyDemandsDemandSupplyInfos = None,
    ):
        self.comment = comment
        self.demand_description = demand_description
        self.demand_id = demand_id
        self.demand_time = demand_time
        self.instance_type = instance_type
        self.demand_name = demand_name
        self.period = period
        self.instance_charge_type = instance_charge_type
        self.available_amount = available_amount
        self.end_time = end_time
        self.start_time = start_time
        self.period_unit = period_unit
        self.zone_id = zone_id
        self.used_amount = used_amount
        self.total_amount = total_amount
        self.delivering_amount = delivering_amount
        self.instance_type_family = instance_type_family
        self.demand_status = demand_status
        self.supply_infos = supply_infos

    def validate(self):
        if self.supply_infos:
            self.supply_infos.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.comment is not None:
            result['Comment'] = self.comment
        if self.demand_description is not None:
            result['DemandDescription'] = self.demand_description
        if self.demand_id is not None:
            result['DemandId'] = self.demand_id
        if self.demand_time is not None:
            result['DemandTime'] = self.demand_time
        if self.instance_type is not None:
            result['InstanceType'] = self.instance_type
        if self.demand_name is not None:
            result['DemandName'] = self.demand_name
        if self.period is not None:
            result['Period'] = self.period
        if self.instance_charge_type is not None:
            result['InstanceChargeType'] = self.instance_charge_type
        if self.available_amount is not None:
            result['AvailableAmount'] = self.available_amount
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.period_unit is not None:
            result['PeriodUnit'] = self.period_unit
        if self.zone_id is not None:
            result['ZoneId'] = self.zone_id
        if self.used_amount is not None:
            result['UsedAmount'] = self.used_amount
        if self.total_amount is not None:
            result['TotalAmount'] = self.total_amount
        if self.delivering_amount is not None:
            result['DeliveringAmount'] = self.delivering_amount
        if self.instance_type_family is not None:
            result['InstanceTypeFamily'] = self.instance_type_family
        if self.demand_status is not None:
            result['DemandStatus'] = self.demand_status
        if self.supply_infos is not None:
            result['SupplyInfos'] = self.supply_infos.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Comment') is not None:
            self.comment = m.get('Comment')
        if m.get('DemandDescription') is not None:
            self.demand_description = m.get('DemandDescription')
        if m.get('DemandId') is not None:
            self.demand_id = m.get('DemandId')
        if m.get('DemandTime') is not None:
            self.demand_time = m.get('DemandTime')
        if m.get('InstanceType') is not None:
            self.instance_type = m.get('InstanceType')
        if m.get('DemandName') is not None:
            self.demand_name = m.get('DemandName')
        if m.get('Period') is not None:
            self.period = m.get('Period')
        if m.get('InstanceChargeType') is not None:
            self.instance_charge_type = m.get('InstanceChargeType')
        if m.get('AvailableAmount') is not None:
            self.available_amount = m.get('AvailableAmount')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('PeriodUnit') is not None:
            self.period_unit = m.get('PeriodUnit')
        if m.get('ZoneId') is not None:
            self.zone_id = m.get('ZoneId')
        if m.get('UsedAmount') is not None:
            self.used_amount = m.get('UsedAmount')
        if m.get('TotalAmount') is not None:
            self.total_amount = m.get('TotalAmount')
        if m.get('DeliveringAmount') is not None:
            self.delivering_amount = m.get('DeliveringAmount')
        if m.get('InstanceTypeFamily') is not None:
            self.instance_type_family = m.get('InstanceTypeFamily')
        if m.get('DemandStatus') is not None:
            self.demand_status = m.get('DemandStatus')
        if m.get('SupplyInfos') is not None:
            temp_model = DescribeDemandsResponseBodyDemandsDemandSupplyInfos()
            self.supply_infos = temp_model.from_map(m['SupplyInfos'])
        return self


class DescribeDemandsResponseBodyDemands(TeaModel):
    def __init__(
        self,
        demand: List[DescribeDemandsResponseBodyDemandsDemand] = None,
    ):
        self.demand = demand

    def validate(self):
        if self.demand:
            for k in self.demand:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Demand'] = []
        if self.demand is not None:
            for k in self.demand:
                result['Demand'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.demand = []
        if m.get('Demand') is not None:
            for k in m.get('Demand'):
                temp_model = DescribeDemandsResponseBodyDemandsDemand()
                self.demand.append(temp_model.from_map(k))
        return self


class DescribeDemandsResponseBody(TeaModel):
    def __init__(
        self,
        page_size: int = None,
        page_number: int = None,
        request_id: str = None,
        total_count: int = None,
        region_id: str = None,
        demands: DescribeDemandsResponseBodyDemands = None,
    ):
        self.page_size = page_size
        self.page_number = page_number
        self.request_id = request_id
        self.total_count = total_count
        self.region_id = region_id
        self.demands = demands

    def validate(self):
        if self.demands:
            self.demands.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.demands is not None:
            result['Demands'] = self.demands.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('Demands') is not None:
            temp_model = DescribeDemandsResponseBodyDemands()
            self.demands = temp_model.from_map(m['Demands'])
        return self


class DescribeDemandsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeDemandsResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeDemandsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDeploymentSetsRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        region_id: str = None,
        page_number: int = None,
        page_size: int = None,
        owner_account: str = None,
        deployment_set_ids: str = None,
        network_type: str = None,
        strategy: str = None,
        deployment_set_name: str = None,
        granularity: str = None,
        domain: str = None,
    ):
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.region_id = region_id
        self.page_number = page_number
        self.page_size = page_size
        self.owner_account = owner_account
        self.deployment_set_ids = deployment_set_ids
        self.network_type = network_type
        self.strategy = strategy
        self.deployment_set_name = deployment_set_name
        self.granularity = granularity
        self.domain = domain

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.deployment_set_ids is not None:
            result['DeploymentSetIds'] = self.deployment_set_ids
        if self.network_type is not None:
            result['NetworkType'] = self.network_type
        if self.strategy is not None:
            result['Strategy'] = self.strategy
        if self.deployment_set_name is not None:
            result['DeploymentSetName'] = self.deployment_set_name
        if self.granularity is not None:
            result['Granularity'] = self.granularity
        if self.domain is not None:
            result['Domain'] = self.domain
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('DeploymentSetIds') is not None:
            self.deployment_set_ids = m.get('DeploymentSetIds')
        if m.get('NetworkType') is not None:
            self.network_type = m.get('NetworkType')
        if m.get('Strategy') is not None:
            self.strategy = m.get('Strategy')
        if m.get('DeploymentSetName') is not None:
            self.deployment_set_name = m.get('DeploymentSetName')
        if m.get('Granularity') is not None:
            self.granularity = m.get('Granularity')
        if m.get('Domain') is not None:
            self.domain = m.get('Domain')
        return self


class DescribeDeploymentSetsResponseBodyDeploymentSetsDeploymentSetInstanceIds(TeaModel):
    def __init__(
        self,
        instance_id: List[str] = None,
    ):
        self.instance_id = instance_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class DescribeDeploymentSetsResponseBodyDeploymentSetsDeploymentSet(TeaModel):
    def __init__(
        self,
        creation_time: str = None,
        strategy: str = None,
        deployment_set_id: str = None,
        deployment_strategy: str = None,
        deployment_set_description: str = None,
        domain: str = None,
        group_count: int = None,
        granularity: str = None,
        deployment_set_name: str = None,
        instance_amount: int = None,
        instance_ids: DescribeDeploymentSetsResponseBodyDeploymentSetsDeploymentSetInstanceIds = None,
    ):
        self.creation_time = creation_time
        self.strategy = strategy
        self.deployment_set_id = deployment_set_id
        self.deployment_strategy = deployment_strategy
        self.deployment_set_description = deployment_set_description
        self.domain = domain
        self.group_count = group_count
        self.granularity = granularity
     