import type middy from '@middy/core';
import type { Tracer } from '../Tracer';
import type { CaptureLambdaHandlerOptions } from '../types';
/**
 * A middy middleware automating capture of metadata and annotations on segments or subsegments for a Lambda Handler.
 *
 * Using this middleware on your handler function will automatically:
 * * handle the subsegment lifecycle
 * * add the `ColdStart` annotation
 * * add the function response as metadata
 * * add the function error as metadata (if any)
 *
 * @example
 * ```typescript
 * import { Tracer, captureLambdaHandler } from '@aws-lambda-powertools/tracer';
 * import middy from '@middy/core';
 *
 * const tracer = new Tracer({ serviceName: 'serverlessAirline' });
 *
 * const lambdaHandler = async (_event: any, _context: any) => {
 *   ...
 * };
 *
 * export const handler = middy(lambdaHandler).use(captureLambdaHandler(tracer));
 * ```
 *
 * @param target - The Tracer instance to use for tracing
 * @param options - (_optional_) Options for the middleware
 * @returns middleware - The middy middleware object
 */
declare const captureLambdaHandler: (target: Tracer, options?: CaptureLambdaHandlerOptions | undefined) => middy.MiddlewareObj;
export { captureLambdaHandler, };
//# sourceMappingURL=middy.d.ts.map