import { LayerVersion } from 'aws-cdk-lib/aws-lambda';
import { Construct } from 'constructs';
export interface IExampleConstructProps {
    /**
     * Debug log sampling rate. Zero means all events.
     * @default 'test'
     * */
    layerVersionName: string;
}
/**
 * Create a Lambda layer with the PowerTools and other required modules.
 */
export declare class ToolsLayer extends Construct {
    /** Lambda Layer */
    layerVersion: LayerVersion;
    /**
       * @param {Construct} scope
       * @param {string} id
    */
    constructor(scope: Construct, id: string, props?: IExampleConstructProps);
}
